<?php $__env->startSection('content'); ?>
<div class="content-wrapper">

	<section class="content-header">
		<h1 class="pull-left">
			<?php echo e($title); ?> List
		</h1>
		<span class="pull-right">
			<a href="<?php echo e(route($route.'create')); ?>" class="btn btn-success"> <i class="fa fa-plus"></i> Add new</a>
		</span>
		<p>&nbsp;</p>
	</section>

	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<?php echo $__env->make('flash', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
				<div class="box box-info">
					<div class="box-body">
						<table id="datatable1" class="table table-bordered table-striped">
							<thead>
							<tr>
								<th>Name</th>
								<th width="100px">Action</th>
							</tr>
							</thead>
							<tbody>
							
							</tbody>
							<tfoot>
							<tr>
								<th>Name</th>
								<th>Action</th>
							</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
		<!-- DataTables -->
<script type="text/javascript">

	$(document).ready(function () {
		var oTable = $('#datatable1').DataTable({
            responsive: true,
            autoWidth: false,
			stateSave: true,
			processing: true,
			serverSide: true,
			ajax: '<?php echo e(url('admin/reference')); ?>',
			columns: [
				{data: 'name', name: 'name', searchable: false, orderable : false},
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			],
			
		});

		$("#datatable1").on('click', '.data-delete', function () {
			var obj = $(this);
			var id = $(this).attr('data-id');

			if (confirm("Are you sure to Delete Data?")) {
				$.ajax({
					type: "DELETE",
					url: "<?php echo e(url('admin/reference')); ?>/" + id,
					data: {
						id: id,
						_token: "<?php echo e(csrf_token()); ?>"
					},
					dataType: 'json',
					beforeSend: function () {
						$(this).attr('disabled', true);
						$('.alert .msg-content').html('');
						$('.alert').hide();
					},
					success: function (resp) {
						oTable.ajax.reload();
						alert(resp.message);
					},
					error: function (e) {
						if (e.status == 403) {
							alert('Unauthorized: Access is denied due to invalid credentials.');
						}else{
							//alert('Error: ' + e);
							alert('internal error occurred.');
						}
					}
				});
			}
		});
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>