<div class="row">
    <div class="col-md-6 col-md-offset-3">
        <div class="form-group <?php echo e($errors->has('name') ? ' has-error' : ''); ?>">
            <label class="control-label">Name <span class="text-danger">*</span></label>
            <?php echo Form::text('name',null, ['class' => 'form-control']); ?>

            <span class="help-block" id="error_name"><strong><?php echo e($errors->first('name')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
            <label class="control-label">Email <span class="text-danger">*</span></label>
            <?php echo Form::text('email',null, ['class' => 'form-control']); ?>

            <span class="help-block" id="error_email"><strong><?php echo e($errors->first('email')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
            <label class="control-label">Password <span class="text-danger">*</span></label>
            <?php echo Form::password('password', ['class' => 'form-control']); ?>

            <span class="help-block" id="error_password"><strong><?php echo e($errors->first('password')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('password_confirmation') ? ' has-error' : ''); ?>">
            <label class="control-label">Password Confirmation <span class="text-danger">*</span></label>
            <?php echo Form::password('password_confirmation', ['class' => 'form-control']); ?>

            <span class="help-block" id="error_password_confirmation"><strong><?php echo e($errors->first('password_confirmation')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('school_name') ? ' has-error' : ''); ?>">
            <label class="control-label">School Name <span class="text-danger">*</span></label>
            <?php echo Form::text('school_name',null, ['class' => 'form-control']); ?>

            <span class="help-block" id="error_email"><strong><?php echo e($errors->first('school_name')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('address') ? ' has-error' : ''); ?>">
            <label class="control-label">Address<span class="text-danger">*</span></label>
            <?php echo Form::text('address',null, ['class' => 'form-control']); ?>

            <span class="help-block" id="error_email"><strong><?php echo e($errors->first('address')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('start_date') ? ' has-error' : ''); ?>">
            <label class="control-label">Start Date<span class="text-danger">*</span></label>
            <?php echo Form::text('start_date',(!empty($record) && !empty($record->start_date))?date('d-m-Y',strtotime($record->start_date)):null, ['class' => 'form-control datepicker','required'=>'required']); ?>

            <span class="help-block" id="error_email"><strong><?php echo e($errors->first('start_date')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('end_date') ? ' has-error' : ''); ?>">
            <label class="control-label">End Date<span class="text-danger">*</span></label>
            <?php echo Form::text('end_date',(!empty($record) && !empty($record->end_date))?date('d-m-Y',strtotime($record->end_date)):null, ['class' => 'form-control datepicker','required'=>'required']); ?>

            <span class="help-block" id="error_email"><strong><?php echo e($errors->first('end_date')); ?></strong></span>
        </div>
        <div class="form-group <?php echo e($errors->has('logo') ? ' has-error' : ''); ?>">
            <label class="control-label">Logo <span class="text-danger">*</span></label>
            <?php echo Form::file('logo', ['class' => 'form-control thumb_image']); ?>

            <span class="help-block" id="error_image"><strong><?php echo e($errors->first('image')); ?></strong></span>
            <img src="<?php echo e(!empty($record['logo'])?$record['logo_url']:url('public/assets/admin/images/not-available.jpg')); ?>" id="thumb_logo" width="150" />
        </div>
        <div class="form-group <?php echo e($errors->has('image') ? ' has-error' : ''); ?>">
            <label class="control-label">Image <span class="text-danger">*</span></label>
            <?php echo Form::file('image', ['class' => 'form-control thumb_image']); ?>

            <span class="help-block" id="error_image"><strong><?php echo e($errors->first('image')); ?></strong></span>
        </div>
    </div>
    <div class="col-md-3 text-center" >
        <img src="<?php echo e(!empty($record['image'])?$record['image_url']:url('public/assets/admin/images/not-available.jpg')); ?>" id="thumb_image" width="150" />
    </div>

</div>
<hr/>
<b><center>User Role</center></b>
<div class="row">
    <div class="col-md-6 col-md-offset-3">
        <div class="form-group <?php echo e($errors->has('role') ? ' has-error' : ''); ?>">
            <label class="control-label">Select Role <span class="text-danger">*</span></label>
            <?php if(!empty($record)): ?>
            <?php echo Form::select('role_id',\Spatie\Permission\Models\Role::all()->pluck('name','name'),$record->getRoleNames()->toArray(),['class' => 'form-control']); ?>

		    <?php else: ?>
			<?php echo Form::select('role_id',\Spatie\Permission\Models\Role::all()->pluck('name','name'),null,['class' => 'form-control']); ?>

		    <?php endif; ?>
            <span class="help-block" id="error_name"><strong><?php echo e($errors->first('name')); ?></strong></span>
        </div>
    </div>    
</div>
<?php $__env->startSection('js'); ?>
<script>
    $(document).ready(function () {
	$('.datepicker').datepicker({
		autoclose: true,
		format: 'dd-mm-yyyy',
		todayHighlight: true,
		todayBtn: true,
	});
    
});
</script>
<?php $__env->stopSection(); ?>

