

<?php $__env->startSection('content'); ?>
<style>
    .custom-label{
       
        display: flex;
        justify-content: center;
    }
    .select2-container--default .select2-selection--multiple .select2-selection__choice{
        color: #111 !important;
    }
    .custom-label:hover{
        cursor: pointer;
    }
</style>



<div class="content-wrapper mt-5 paper_section" >
    <?php echo $__env->make('flash', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="paper_title mb-5">
        <h3 class="text-center">Generate Paper</h3>
        <h5 class="text-center m-3 text-secondary">Generate Paper of Your Choice</h5>
    </div>
    <?php if(!empty($paper)): ?>
    
        <form action="<?php echo e(url('admin/peperupdate/'.$paper->id)); ?>" method="post">
    
    <?php else: ?>
    <form action="<?php echo e(url('admin/paperstore')); ?>" method="post">
    
    <?php endif; ?>
        <?php echo e(csrf_field()); ?>

    <!-- Tab Navigation -->
    <ul class="nav nav-tabs paper-step-tabs" id="myTab" role="tablist">
        <li class="paper-nav-item">
            <a class="paper-nav-link active" id="step1-tab" data-toggle="tab" href="#step1" role="tab" aria-controls="step1" aria-selected="true">
                <div class="paper-step-number">1</div>
                <div class="paper-step-title">Step 1<br><small>Select Board, Standard, Semester, Subject</small></div>
            </a>
        </li>
        <li class="paper-nav-item">
            <a class="paper-nav-link" id="step2-tab" data-toggle="tab" href="#step2" role="tab" aria-controls="step2" aria-selected="false">
                <div class="paper-step-number">2</div>
                <div class="paper-step-title">Step 2<br><small>Manage Paper Details, Date, Time, Difficulty</small></div>
            </a>
        </li>
        <li class="paper-nav-item">
            <a class="paper-nav-link" id="step3-tab" data-toggle="tab" href="#step3" role="tab" aria-controls="step3" aria-selected="false">
                <div class="paper-step-number">3</div>
                <div class="paper-step-title">Step 3<br><small>Choose Questions of Chapters & Subjects</small></div>
            </a>
        </li>
    </ul>

    
   
    <div class="tab-content paper-tab-content" id="myTabContent">
        <div class="tab-pane fade in active" id="step1" role="tabpanel" aria-labelledby="step1-tab">
            
                <div class="text-center">
                    <?php $__currentLoopData = $board; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="radio-inline">
                        <label><input type="radio" name="board_id" value="<?php echo e($b->id); ?>" <?php echo e(!empty($paper) && $paper->board_id == $b->id?'checked':''); ?> class="form-check-input" onchange="fetchStandards(this.value);" > <?php echo e($b->name); ?></label>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <span class="help-block" id="error_image"><strong><?php echo e($errors->first('board_id')); ?></strong></span>
                    
                </div>
                <div class="row mt-3 px-5">
                    <div class="col-md-4">
                        <label class="text-left float-start mb-1">Standard <span style="color:red">*</span></label>
                        <select class="form-control js-example-basic-multiple" name="standard_id" id="standard_id" >
                            <option value="">-- Select Standard --</option>
                            <?php if(!empty($paper)): ?>
                            <?php $__currentLoopData = $standard; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($s->id); ?>" <?php echo e(!empty($paper->standard_id) && $paper->standard_id == $s->id?'selected':''); ?>><?php echo e($s->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                        <span class="help-block" id="error_image"><strong><?php echo e($errors->first('standard_id')); ?></strong></span>
                    </div>
                    <div class="col-md-4">
                        <label class="text-left float-start mb-1">Semester<span style="color:red">*</span></label>
                        <select class="form-control js-example-basic-multiple" name="semester_id" id="semester_id" >
                            <option value="">-- Select Semester --</option>
                            <?php if(!empty($paper)): ?>
                            <?php $__currentLoopData = $semester; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($s->id); ?>" <?php echo e(!empty($paper->semester_id) && $paper->semester_id == $s->id?'selected':''); ?>><?php echo e($s->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                        <span class="help-block" id="error_image"><strong><?php echo e($errors->first('semester_id')); ?></strong></span>
                    </div>
                    <div class="col-md-4">
                        <label class="text-left float-start mb-1">Subject<span style="color:red">*</span></label>
                        <select class="form-control js-example-basic-multiple" name="subject_id" id="subject_id" >
                            <option value="">-- Select Subject --</option>
                            <?php if(!empty($paper)): ?>
                            <?php $__currentLoopData = $subject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($s->id); ?>" <?php echo e(!empty($paper->subject_id) && $paper->subject_id == $s->id?'selected':''); ?>><?php echo e($s->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                        <span class="help-block" id="error_image"><strong><?php echo e($errors->first('subject_id')); ?></strong></span>
                    </div>
                   
                </div>
                <div class="text-right px-5 mt-5">
                    <button type="button" class="btn btn-primary" >Continue</button>
                </div>
        </div>

        <div class="tab-pane fade" id="step2" role="tabpanel" aria-labelledby="step2-tab">
            
                <div class="row mt-3 px-5">
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Paper Date</label>
                        <input type="text" name="paper_date" class="form-control datepicker" value="<?php echo e(!empty($paper)?date('d-m-Y',strtotime($paper->paper_date)):''); ?>">
                        <span class="help-block" id="error_image"><strong><?php echo e($errors->first('paper_date')); ?></strong></span>
                    </div>
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Paper Type</label>
                        <select class="form-control" name="paper_type">
                            <option  value="Weekly" <?php echo e(!empty($paper) && $paper->paper_type == 'Weekly'?'selected':''); ?> >Weekly</option>
                            <option value="Monthly" <?php echo e(!empty($paper) && $paper->paper_type == 'Monthly'?'selected':''); ?>>Monthly</option>
                        </select>
                        <span class="help-block" id="error_image"><strong><?php echo e($errors->first('paper_type')); ?></strong></span>
                    </div>
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Paper Difficulty</label>
                        <select class="form-control" name="paper_difficulty">
                            <option  value="Easy" <?php echo e(!empty($paper) && $paper->paper_difficulty == 'Easy'?'selected':''); ?>>Easy</option>
                            <option value="Medium" <?php echo e(!empty($paper) && $paper->paper_difficulty == 'Medium'?'selected':''); ?>>Medium</option>
                            <option value="Hard" <?php echo e(!empty($paper) && $paper->paper_difficulty == 'Hard'?'selected':''); ?>>Hard</option>
                        </select>
                        <span class="help-block" id="error_image"><strong><?php echo e($errors->first('paper_difficulty')); ?></strong></span>
                    </div>
                    <div class="col-md-3">
                        <div class="paper-box-generate">
                            <label>Generate As</label>
                            <div class="radio">
                                <label><input type="radio" name="generate_as" value="Question Paper" <?php echo e(!empty($paper) && $paper->generate_as == 'Question Paper'?'checked':''); ?>> Question Paper</label>
                            </div>
                            <div class="radio">
                                <label><input type="radio" name="generate_as" value="Paper With Inline" <?php echo e(!empty($paper) && $paper->generate_as == 'Paper With Inline'?'checked':''); ?>> Paper with Inline</label>
                            </div>
                            <div class="radio">
                                <label><input type="radio" name="generate_as" value="Paper Answer Key" <?php echo e(!empty($paper) && $paper->generate_as == 'Paper Answer Key'?'checked':''); ?>> Paper Answer Key</label>
                            </div>
                        </div>
                        <span class="help-block" id="error_image"><strong><?php echo e($errors->first('generate_as')); ?></strong></span>
                    </div>
                </div>
                <div class="text-right px-5 paper-box-button mt-3">
                    <button class="btn btn-success">Back</button>
                    <button type="button" class="btn btn-primary">Continue</button>
                </div>
        </div>

        <div class="tab-pane fade tab_3" id="step3" role="tabpanel" aria-labelledby="step3-tab">
           
                <div class="row mt-3 px-5">
                    <div id="chapter">
                     <div class="col-md-8">
                            <label class="form-label float-start">Select chapter: <span> Select All : <input class="form-check-input skip-validation" type="checkbox" value="all" id="selectAllCheckbox" name="all_check"></span></label>
                            <select class="form-select searchable-select skip-validation" name="chapter_id[]" id="chapter_id" style="width: 100%" multiple>
                                <?php if(!empty($paper)): ?>
                            <?php $__currentLoopData = $chapter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($s->id); ?>"  <?php echo e(!empty($paper->chapter_id) && in_array($s->id, explode(',', $paper->chapter_id)) ? 'selected' : ''); ?>><?php echo e($s->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </select>
                            <span class="help-block" id="error_image"><strong><?php echo e($errors->first('chapter_id')); ?></strong></span>
                    </div>
                   </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="float-start">Generate Type</label>
                            <select class="form-control" name="generate_type" id="generateTypeSelect">
                                <option  value="">--select Generate Type --</option>
                                <option  value="Manually" <?php echo e(!empty($paper) && $paper->generate_type == 'Manually'?'selected':''); ?>>Manually</option>
                                <option value="Random" <?php echo e(!empty($paper) && $paper->generate_type == 'Random'?'selected':''); ?>>Random</option>
                            </select>
                            <span class="help-block" id="error_image"><strong><?php echo e($errors->first('generate_type')); ?></strong></span>
                        </div>
                    </div>
                    <input type="hidden" name="paper_id" value="<?php echo e(!empty($paper)?$paper->id:''); ?>" id="paper_id">
                    <div class="col-md-12" id="subjectquestion" style="display:none;">
                        <h3 class="mt-3">Subject Questions</h3>
                    <div class="accordion paper-accordion mt-5">
                            <div class="panel panel-default paper-accordion-item">


                                <div class="panel-group" id="accordion">

                                </div>

                                
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                            <h3 class="mt-3">Subject Question Types</h3>
                            <div class="paper_box_table mt-3 table-responsive">
                                <table class="table  table-stripped">
                                        <tr>
                                            <th>Question Type Heading</th>
                                            <th>Avaliable</th>
                                            <th>Ask</th>
                                            <th>Optional</th>
                                            <th>Mark</th>
                                            <th>Section</th>
                                            <th>Question No</th>
                                            <th>Question Section</th>
                                            <th>Total</th>
                                        </tr>
                                        <tr class="text-left">
                                            <td>Question 1</td>
                                            <td>5</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>&nbsp;</td>
                                            <td>Q. No</td>
                                            <td>Q. section</td>
                                            <td>0</td>
                                        </tr>
                                        <tr class="text-left">
                                            <td>Question 2</td>
                                            <td>5</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>&nbsp;</td>
                                            <td>Q. No</td>
                                            <td>Q. section</td>
                                            <td>0</td>
                                        </tr>
                                        <tr class="text-left">
                                            <td>Question 3</td>
                                            <td>5</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>&nbsp;</td>
                                            <td>Q. No</td>
                                            <td>Q. section</td>
                                            <td>0</td>
                                        </tr>
                                        <tr class="text-left">
                                            <td>Question 4</td>
                                            <td>5</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>0</td>
                                            <td>&nbsp;</td>
                                            <td>Q. No</td>
                                            <td>Q. section</td>
                                            <td>0</td>
                                        </tr>
                                </table>  
                            </div>  
                    </div>
                </div>
                <div class="text-right paper-box-button">  
                    <button class="btn btn-success">Back</button>
                    <button type="submit" class="btn btn-primary">Generate</button>
                </div>
        </div>
    </div>
</form>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>

function fetchStandards(boardId) {
      
        $('#standard_id').empty().append('<option value="">-- Select Standard --</option>');

      
        $.ajax({
            url: "<?php echo e(url('admin/getstandard')); ?>", 
            type: 'GET',
            data: { board_id: boardId },
            success: function(standards) {
                
                $.each(standards, function(key, value) {
                    $('#standard_id')
							.append($('<option>', {
									value: key
								})
								.text(value));
                });
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error: ', status, error);
                
            }
        });
    }

    $(document).ready(function() {
        $('#selectAllCheckbox').click(function() {
         
            
            if ($(this).is(':checked')) {
               
                $('#chapter_id option[value!=""]').prop('selected', true).trigger('change');
            } else {
                
                $('#chapter_id option').prop('selected', false).trigger('change');
            }
        });
    });

    $(document).ready(function() {
        var chapterId = $('#chapter_id').val();
    var generateType = $('#generateTypeSelect').val();
    var paper_id = $('#paper_id').val();
    if(chapterId !== '' && generateType === 'Manually')
    {
      runFunction(chapterId, generateType, paper_id);

    }
    $('#generateTypeSelect, #chapter_id').change(function() {
        var chapterId = $('#chapter_id').val();
        var generateType = $('#generateTypeSelect').val();
        var paper_id = $('#paper_id').val();

        runFunction(chapterId, generateType, paper_id);
    });
});
        
    function runFunction(chapterId, generateType, paper_id=null) {
        var generateType = $('#generateTypeSelect').val();
        var chapterId = $('#chapter_id').val(); 
        var paper_id = $('#paper_id').val();

        if (generateType === 'Manually') { 
            $.ajax({
                type: 'GET',
                url: "<?php echo e(url('admin/getquestiontype')); ?>",
                data: { chapter_id: chapterId, paper_id: paper_id },
                success: function(response) {
                    $('#subjectquestion').show();
                    $('#accordion').empty();

                    const paperDetailMap = {};
                    response.paperdetail.forEach(item => {
                        paperDetailMap[item.question_id] = {
                            question_no: item.question_no,
                            question_section: item.question_section,
                            questiontype_id:item.questiontype_id,
                            question_mark: item.question_mark,
                            optional: item.optional,
                            que_id: item.que_id
                        };
                    });
                    
                   
                    $.each(response.questionType, function(index, questionType) {
                        var panelId = 'collapse' + (index + 1); 
                        var panelHtml = `
                            <div class="panel-heading paper-accordion-header" id="heading${index}">
                                <h4 class="panel-title accordian_header_box" style="position: relative;">
                                    <a data-toggle="collapse" data-parent="#accordion" href="#${panelId}">
                                        <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp; ${questionType.name}
                                        <input type="hidden" name="questiontype[]" value="${questionType.id}">
                                    </a>
                                    <select class="accordian_input" name="question_no[]" placeholder="Question No:">
                                        <option value="">-- Question No --</option>
                                        ${$.map(response.question_no, function(questionNumber) {
                                          
                                            const selected = Object.values(paperDetailMap).filter(item => item.questiontype_id == questionType.id).some(item => 
                                            item.question_no === questionNumber
                                                    ) ? 'selected' : '';
                                            return `<option value="${questionNumber}" ${selected}>${questionNumber}</option>`;
                                        }).join('')}
                                    </select>
                                    
                                    <select class="accordian_input" name="question_section[]" id="question_section_${questionType.id}" placeholder="Question Section:">
                                        <option value="">-- Question Section --</option>
                                        ${$.map(response.question_section, function(questionSection) {
                                            const selected = Object.values(paperDetailMap).filter(item=> item.questiontype_id == questionType.id).some(item => item.question_section === questionSection) ? 'selected' : '';
                                            return `<option value="${questionSection}" ${selected}>${questionSection}</option>`;
                                        }).join('')}
                                    </select>
                                </h4>
                            </div>
                            <div id="${panelId}" class="panel-collapse collapse">
                                <div class="panel-body">
                                    <ul class="list-unstyled"> <!-- List for questions -->
                                        <li>
                                            <div class="row">
                                                <div class="col-md-6">Question</div>
                                                <div class="col-md-2">Que.Mark</div>
                                                <div class="col-md-2">Optional</div>
                                                <div class="col-md-2">OR Que.ID</div>
                                            </div>
                                        </li>
                        `;

                        
                        $.each(questionType.question, function(qIndex, question) {
                            const isChecked = paperDetailMap[question.id] ? 'checked' : '';
                            const questionMarkValue = paperDetailMap[question.id]?.question_mark || 1; // Default to 1 if not set
                            const optionalValue = paperDetailMap[question.id]?.optional || ''; // Default to empty
                            const queIdValue = paperDetailMap[question.id]?.que_id || 0; // Default to 0 if not set

                            panelHtml += `
                                <li>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input type="hidden" name="question[${questionType.id}][]" value="${question.id}">
                                            <label>Chapter: ${question.chapter.name}</label><br>
                                            <label class="custom-label">
                                                <div class="pl-5 float-start mr-2">
                                                    <input type="checkbox" name="question_select[${questionType.id}][]" class="checkbox-inline" ${isChecked}>
                                                </div>
                                                <font style="font-weight:700">${qIndex + 1}-</font>
                                                <font style="color:blue;font-weight:700">(${question.id}):</font>
                                                ${question.question_title}
                                            </label>
                                        </div>
                                        <div class="col-md-2">
                                            <input type="number" class="form-control" name="question_mark[${questionType.id}][]" min="0" step="0.1" id="marks_${question.id}" max="100" value="${questionMarkValue}">
                                        </div>
                                        <div class="col-md-2">
                                            <select class="form-control" name="optional[${questionType.id}][]" id="optional_${question.id}">
                                                <option value="">Select Optional</option>
                                                <option value="N" ${optionalValue === 'N' ? 'selected' : ''}>N</option>
                                                <option value="Y" ${optionalValue === 'Y' ? 'selected' : ''}>Y</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <input type="number" class="form-control" name="que_id[${questionType.id}][]" min="0" step="1.0" id="que_${question.id}" max="1000000" value="${queIdValue}">
                                        </div>
                                    </div>
                                </li>
                            `;
                        });

                        panelHtml += `
                                    </ul>
                                </div>
                            </div>
                        `;
                        $('#accordion').append(panelHtml); 
                    });
                }
            });
        } else { 
            $('#subjectquestion').hide();
        }
    }



  $(document).ready(function() {
    $('.searchable-select').select2({ 
      placeholder: "Select an option",
      allowClear: true
    });
  });

  $(document).ready(function() {
		
		
		$('.js-example-basic-multiple').select2(); 
  });

  $("body").on("change", "#standard_id", function() {
		var row_id = $(this).val();
        
		$.ajax({
			type: "POST",
			url: "<?php echo e(url('admin/getsemester')); ?>",
			data: {
				"_token": "<?php echo e(csrf_token()); ?>",
				"standard_id": row_id,
				

			},
			error: function(result) {},
			success: function(result,semester) {
				if (result.subjects == '') {
					$('#subject_id option:not([value=""])').remove();
				} else {
					$('#subject_id option').remove();
					$('#subject_id').append('<option value="">---- Select Subject ----</option>');
					$.each(result.subjects, function(key, value) {
						$('#subject_id')
							.append($('<option>', {
									value: key
								})
								.text(value));
					});
				}
				if(result.semesters == '')
				{
					$('#semester_id option:not([value=""]').remove();
				}
				else{
					$('#semester_id option').remove();
					$('#semester_id').append('<option value="">---- Select Semester ----</option>');
					$.each(result.semesters, function(key, value) {
						$('#semester_id')
							.append($('<option>', {
									value: key
								})
								.text(value));
					});
				}
			}
		});
		
	});

    $("body").on("change", "#subject_id", function() {
		var row_id = $(this).val();
        
		$.ajax({
			type: "POST",
			url: "<?php echo e(url('admin/getchapter')); ?>",
			data: {
				"_token": "<?php echo e(csrf_token()); ?>",
				"subject_id": row_id,
				

			},
			error: function(response) {},
			success: function(response) {
				if (response.chapter == '') {
					$('#chapter_id option').remove();
				} else {
					$('#chapter_id option').remove();
					$('#chapter_id').append('<option value="">---- Select Chapter ----</option>');
					$.each(response.chapter, function(key, value) {
						$('#chapter_id')
							.append($('<option>', {
									value: key
								})
								.text(value));
					});
				}
				
			}
		});
		
	});
</script>
<script>
   $(document).ready(function() {
   
    $('#accordion').on('shown.bs.collapse', function(e) {
      
        $(e.target).prev('.panel-heading').find('.arrow-icon')
            .removeClass('glyphicon-chevron-down')
            .addClass('glyphicon-chevron-up');
        
      
        $(e.target).prev('.panel-heading').find('i.fa')
            .removeClass('fa-arrow-right')
            .addClass('fa-arrow-down');
    });

    $('#accordion').on('hidden.bs.collapse', function(e) {
      
        $(e.target).prev('.panel-heading').find('.arrow-icon')
            .removeClass('glyphicon-chevron-up')
            .addClass('glyphicon-chevron-down');
        
       
        $(e.target).prev('.panel-heading').find('i.fa')
            .removeClass('fa-arrow-down')
            .addClass('fa-arrow-right');
    });
});
</script>

<script>
  $(document).ready(function() {
    const tabContents = document.querySelectorAll(".tab-pane");
    const continueButtons = document.querySelectorAll(".btn-primary");
    const backButtons = document.querySelectorAll(".btn-success");
    const tabLinks = document.querySelectorAll('[role="tab"]');
    let currentTab = 0; 

    function showTab(index) {

        tabContents.forEach((tab, i) => {
         
            tab.classList.toggle("in", i === index);
            tab.classList.toggle("active", i === index);
            tab.classList.toggle("fade", i !== index);
        });
    
        tabLinks.forEach((link, i) => {
            link.classList.toggle("active", i === index);
        const closestLi = link.closest('li');
        if (closestLi) {
            closestLi.classList.toggle("active", i === index);
        }
           
        });
     
         
    }
    
    const accordionId = '#accordion'; 
    const chapter = '#chapter'; 
    const paper = "#paper_id";
    continueButtons.forEach((button, index) => {
       
        button.addEventListener("click", function (event) {
           
            const currentTabElement = document.querySelector('.tab-pane.active');
            const target = currentTabElement.id;
            const inputs = currentTabElement.querySelectorAll('input, select');
            let isValid = true;
            
            if(target === 'step1')
            {
                currentTab =0;
            }
            else if(target === 'step2')
            {
                currentTab =1;
            }
            else if(target === 'step3')
            {
                currentTab =2;
            }
            
            currentTabElement.querySelectorAll('.error-message').forEach(error => error.remove());

            inputs.forEach(input => {

                if (input.closest(accordionId)) return;
                if (input.matches(paper)) return;
    if (input.tagName === 'INPUT' && input.type === 'radio') {
        const radioButtons = currentTabElement.querySelectorAll(`input[name="${input.name}"]`);
        let isRadioChecked = false;
        radioButtons.forEach(radioButton => {
            if (radioButton.checked) {
                isRadioChecked = true;
            }
        });
        if (!isRadioChecked) {
            isValid = false;
            radioButtons.forEach(radioButton => {
                radioButton.classList.add('is-invalid');
            });
            const errorMessage = document.createElement('div'); 
            errorMessage.className = 'error-message';  
            const inputName = input.name.replace('[]', '').replace('_', ' ').trim();
            errorMessage.style.color = 'red';
            errorMessage.textContent = `Please select one of the ${inputName} options.`;
            input.parentNode.appendChild(errorMessage);
        } else {
            radioButtons.forEach(radioButton => {
                radioButton.classList.remove('is-invalid');
            });
        }
    } else if (input.tagName === 'INPUT'&& input.type !== 'radio' && input.type !== 'checkbox' && input.type !== 'search') {
        if (!input.value.trim()) {
           
            isValid = false;
            input.classList.add('is-invalid'); 

            const errorMessage = document.createElement('div');
            errorMessage.className = 'error-message';
            const inputName = input.name.replace('[]', '').replace('_', ' ').trim();
            errorMessage.style.color = 'red';
            errorMessage.textContent = `This ${inputName} is required.`; 

            input.parentNode.appendChild(errorMessage);
        } else {
            input.classList.remove('is-invalid'); 
        }
    } else if (input.tagName === 'SELECT') {

        if (!input.value) {
            
            isValid = false;
            input.classList.add('is-invalid'); 

            const errorMessage = document.createElement('div');
            errorMessage.className = 'error-message';
            const inputName = input.name.replace('[]', '').replace('_', ' ').trim();
            errorMessage.style.color = 'red';
            errorMessage.textContent = `${inputName} is required.`; 
            input.parentNode.appendChild(errorMessage);
        } else {
            input.classList.remove('is-invalid'); 
        }
    }  
});

            if (isValid == true) {
                   currentTab++;
                    showTab(currentTab);
                    submitform();
            
            }
            else{
                event.preventDefault();
            } 
            
        });
       
    });

    backButtons.forEach((button, index) => {
        button.addEventListener("click", function (event) {
           
            event.preventDefault();
            if (currentTab > 0) {
                currentTab = currentTab - 1;

                showTab(currentTab); 
            }
        });
    });

    $('#myTab a').click(function(e) {
    const currentTabElement = $(this);
    const target = currentTabElement.attr('href');
   
    $('#myTab a').removeClass('active'); 
    $('#myTab li').removeClass('active')
    currentTabElement.addClass('active');
    currentTabElement.closest('li').addClass('active');
    $('.tab-pane').removeClass('in active');
    $(target).addClass('in active');
});
  });
$(document).ready(function () {
	$('.datepicker').datepicker({
		autoclose: true,
		format: 'dd-mm-yyyy',
		todayHighlight: true,
		todayBtn: true,
	});
    $('.datepicker').datepicker('setDate', new Date());
});
function submitform() {
    
    $('form').off('submit').on('submit', function(event) {
        event.preventDefault();

        var emptyFields = [];
         var generalErrorMessage = "Please select at least one question type, fill in 'Question No', 'Question Section', and check at least one question.";
        var anyQuestionTypeValid = false;
        var firstErrorMessage = "";
        var secondErrorMessage = "";
        var thirdErrorMessage = "";
        var forthErrorMessage = "";
        var fifthErrorMessage = "";
        var sixErrorMessage = "";
        
       
       
        $('.tab-pane').each(function(index, tab) {
            $(tab).find('input:not(#accordion input), select:not(#accordion select)').not('[name="all_check"]').not('[name="paper_id"]').each(function() {
                if ($(this).is('input, select') && $(this).val() === '' && $(this).attr('name')) {
                    var fieldName = $(this).attr('name').replace('[]', '').replace('_', ' ').trim();
                    emptyFields.push(fieldName);
                }
            });
        });

     
       
        $('#accordion .panel-heading').each(function() {
            var questionTypeId = $(this).find('input[name="questiontype[]"]').val();
            var questionNo = $(this).find('select[name="question_no[]"]').val();
            var questionSection = $(this).find('select[name="question_section[]"]').val();
            var isCheckboxChecked = $(this).closest('.panel').find(`input[name="question_select[${questionTypeId}][]"]:checked`).length > 0;

    if (questionNo && !questionSection && !isCheckboxChecked) {
       
       if (!firstErrorMessage) {
           firstErrorMessage = "Please select question Section of question type " + $(this).find('a').text().trim() + ".";
       }
   }
    
     else if (!questionNo && questionSection && !isCheckboxChecked) {
       
            if (!secondErrorMessage) {  
                secondErrorMessage = "Please select question No of question type " +  $(this).find('a').text().trim() + ".";
            }
    } 
   
    else if (questionNo && questionSection && !isCheckboxChecked) {
      
            if (!thirdErrorMessage) {
                thirdErrorMessage = "Please select atleast one question of this question type " +  $(this).find('a').text().trim() + ".";
            }
    } 
      else if (!questionNo && !questionSection && isCheckboxChecked) {
      
                if (!forthErrorMessage) {
                forthErrorMessage = "Please select question no and question section  of this question type ." + $(this).find('a').text().trim() + ".";
            }
        }
    else if (questionNo && !questionSection && isCheckboxChecked) {
          
            if (!fifthErrorMessage) {  
                fifthErrorMessage = "Please select question Section of question type " +  $(this).find('a').text().trim() + ".";
            }
    } 
   
   
    else if (!questionNo && questionSection && isCheckboxChecked) {
       
            
            if (!sixErrorMessage) {  
                sixErrorMessage = "Please select question Section of question type " +  $(this).find('a').text().trim() + ".";
            }
    } 
   
    
    else if (questionNo && questionSection && isCheckboxChecked) {
        
        
        anyQuestionTypeValid = true;
        firstErrorMessage = "";
        secondErrorMessage = "";
        thirdErrorMessage = "";
        forthErrorMessage = "";
        fifthErrorMessage = "";
        sixErrorMessage = "";
    }
});

        
        if (emptyFields.length > 0) {
            var errorMessage = "Please fill in the following required fields: " + emptyFields.join(', ');
            Swal.fire({
                icon: 'error',
                title: 'Error',
                html: '<span style="font-size: 18px; font-weight: bold;">' + errorMessage + '</span>',
            });
            return; 
        }

        if (firstErrorMessage) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        html: '<span style="font-size: 18px; font-weight: bold;">' + firstErrorMessage + '</span>',
    });
    return; 
}
if (secondErrorMessage) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        html: '<span style="font-size: 18px; font-weight: bold;">' + secondErrorMessage + '</span>',
    });
    return; 
}
if (thirdErrorMessage) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        html: '<span style="font-size: 18px; font-weight: bold;">' + thirdErrorMessage + '</span>',
    });
    return;
}
if (forthErrorMessage) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        html: '<span style="font-size: 18px; font-weight: bold;">' + forthErrorMessage + '</span>',
    });
    return; 
}
if (fifthErrorMessage) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        html: '<span style="font-size: 18px; font-weight: bold;">' + fifthErrorMessage + '</span>',
    });
    return; 
}
if (sixErrorMessage) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        html: '<span style="font-size: 18px; font-weight: bold;">' + sixErrorMessage + '</span>',
    });
    return; 
}


if (!anyQuestionTypeValid) {
    Swal.fire({
        icon: 'error',
        title: 'Error',
        html: '<span style="font-size: 18px; font-weight: bold;">' + generalErrorMessage + '</span>',
    });
    return; 
}

       
        $(this).unbind('submit'); 
        $(this).submit(); 
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>