<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('category', 'Api\CategoryController@index');
Route::get('subcategory/{cid}', 'Api\CategoryController@sublevel');
Route::get('sitesetting', 'Api\CategoryController@sitesetting');

Route::post('user/login', 'Api\UserController@login');
Route::post('user/signup', 'Api\UserController@signup');
Route::post('user/getprofile', 'Api\UserController@get_profile');
Route::post('user/update_profile', 'Api\UserController@update_profile');
Route::post('user/verifyotp', 'Api\UserController@verifyotp');
Route::post('user/reset_password', 'Api\UserController@reset_password');
Route::post('user/changepassword', 'Api\UserController@changepassword');
Route::post('user/checklogin', 'Api\UserController@checklogin');

Route::post('getstandard', 'Api\DropdownController@getstandard');
Route::get('getstate', 'Api\DropdownController@getstate');
Route::post('getcity', 'Api\DropdownController@getcity');
Route::get('getboard', 'Api\DropdownController@getboard');
Route::get('getmedium', 'Api\DropdownController@getmedium');
Route::post('getsubject', 'Api\DropdownController@getsubject');
Route::post('getchapter', 'Api\DropdownController@getchapter');
Route::get('getpaperstyle', 'Api\DropdownController@getpaperstyle');
Route::get('getquerytype', 'Api\DropdownController@getquerytype');
Route::get('getpapertype', 'Api\DropdownController@getpapertype');

Route::post('getquestion', 'Api\QuestionController@getquestion');
Route::post('pdf_settings', 'Api\UserController@pdf_settings');

Route::post('save_contribute', 'Api\ContributeController@save_contribute');
Route::get('getvideo', 'Api\VideoController@getvideo');
Route::post('save_contact', 'Api\ContactController@savecontact');

Route::post('savepaper', 'Api\PaperController@savepaper');
Route::post('updatepaper', 'Api\PaperController@updatepaper');
Route::post('mydownload', 'Api\PaperController@mydownload');
Route::post('getpreviouspaper', 'Api\PaperController@getpreviouspaper');
Route::post('auto_paper_generate', 'Api\PaperController@auto_paper_generate');
Route::post('deletepaper', 'Api\PaperController@deletepaper');

Route::post('check_question', 'Api\QuestionController@check_question');
Route::post('generatepdf', 'Api\QuestionController@generatepdf');