@extends('user.layouts.app')
@section('body')
<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet">

<style>
    .paper-step-tabs {
        display: flex;
        justify-content: center;
        margin-top: 30px;
    }

    .paper-step-tabs .paper-nav-item {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 250px;
    }

    .paper-step-tabs .paper-nav-link {
        display: flex;
        gap: 1rem;
        align-items: center;
        justify-content: center;
        padding: 10px;
        border: none;
        background: none;
    }

    .paper-step-tabs .paper-step-number {
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 0.5rem 1rem;
        border-radius: 10%;
        background-color: #ddd;
        color: white;
        font-size: 18px;
        font-weight: bold;
        margin-bottom: 8px;
    }

    .paper-step-tabs .paper-nav-link.active .paper-step-number {
        background-color: #4a52a3;
    }

    .paper-step-tabs .paper-nav-link.disabled .paper-step-number {
        background-color: #ddd;
    }

    .paper-step-tabs .paper-step-title {
        font-size: 14px;
        color: #6c757d;
    }

    .paper-step-tabs .paper-nav-link.active .paper-step-title {
        font-size: 14px;
        color: #4a52a3;
    }

    .paper-tab-content {
        text-align: center;
        margin-top: 20px;
    }

    .select2-container--bootstrap5 .select2-selection--single {
        height: 38px;
        padding: 6px 12px;
        border-radius: 0.25rem;
        border: 1px solid #ced4da;
    }

    /* For Accordion */
    .paper-accordion-body {
        padding: 15px;
        background-color: #f9f9f9;
        border: 1px solid #ddd;
        border-radius: 4px;
    }

    .paper-accordion-header button {
        display: block;
        width: 100%;
        text-align: left;
    }

    .paper-accordion-item {
        margin-bottom: 10px;
    }
</style>

<div class="container mt-5 paper_section shadow px-3 py-5">
    <div class="paper_title mb-5">
        <h3 class="text-center">Generate Paper</h3>
        <h5 class="text-center m-3 text-secondary">Generate Paper of Your Choice</h5>
    </div>

    <!-- Tab Navigation -->
    <ul class="nav nav-tabs paper-step-tabs" id="myTab" role="tablist">
        <li class="paper-nav-item">
            <a class="paper-nav-link active" id="step1-tab" data-toggle="tab" href="#step1" role="tab" aria-controls="step1" aria-selected="true">
                <div class="paper-step-number">1</div>
                <div class="paper-step-title">Step 1<br><small>Select Board, Standard, Semester, Subject</small></div>
            </a>
        </li>
        <li class="paper-nav-item">
            <a class="paper-nav-link" id="step2-tab" data-toggle="tab" href="#step2" role="tab" aria-controls="step2" aria-selected="false">
                <div class="paper-step-number">2</div>
                <div class="paper-step-title">Step 2<br><small>Manage Paper Details, Date, Time, Difficulty</small></div>
            </a>
        </li>
        <li class="paper-nav-item">
            <a class="paper-nav-link" id="step3-tab" data-toggle="tab" href="#step3" role="tab" aria-controls="step3" aria-selected="false">
                <div class="paper-step-number">3</div>
                <div class="paper-step-title">Step 3<br><small>Choose Questions of Chapters & Subjects</small></div>
            </a>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content paper-tab-content" id="myTabContent">
        <div class="tab-pane fade in active" id="step1" role="tabpanel" aria-labelledby="step1-tab">
            <form>
                <div class="text-center">
                    <div class="radio-inline">
                        <label><input type="radio" name="select_board" class="form-check-input"> GSEB-GUJ</label>
                    </div>
                    <div class="radio-inline">
                        <label><input type="radio" name="select_board" class="form-check-input"> GSEB-ENG</label>
                    </div>
                    <div class="radio-inline">
                        <label><input type="radio" name="select_board" class="form-check-input"> GSEB-ANJALI</label>
                    </div>
                </div>
                <div class="row mt-3 px-5">
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Standard</label>
                        <select class="form-control">
                            <option selected>STD 1</option>
                            <option value="1">STD 2</option>
                            <option value="2">STD 3</option>
                            <option value="3">STD 4</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Semester</label>
                        <select class="form-control">
                            <option selected>All</option>
                            <option value="1">Quarterly</option>
                            <option value="2">Annually</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Subject</label>
                        <select class="form-control">
                            <option selected>Maths</option>
                            <option value="1">Gujarati</option>
                            <option value="2">English</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Category</label>
                        <select class="form-control">
                            <option value="1">Tag 1</option>
                            <option value="2">Tag 2</option>
                            <option value="3">Tag 3</option>
                            <option value="4">Tag 4</option>
                            <option value="5">Tag 5</option>
                        </select>
                    </div>
                </div>
                <div class="text-right px-5">
                    <button class="btn btn-primary">Continue</button>
                </div>
            </form>
        </div>

        <div class="tab-pane fade" id="step2" role="tabpanel" aria-labelledby="step2-tab">
            <form>
                <div class="row mt-3 px-5">
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Paper Name</label>
                        <input type="date" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Paper Type</label>
                        <select class="form-control">
                            <option selected>Weekly</option>
                            <option value="1">Monthly</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="text-left float-start mb-1">Paper Difficulty</label>
                        <select class="form-control">
                            <option selected>Easy</option>
                            <option value="1">Medium</option>
                            <option value="2">Hard</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Generate As</label>
                            <div class="radio">
                                <label><input type="radio" name="generate_as"> Question Paper</label>
                            </div>
                            <div class="radio">
                                <label><input type="radio" name="generate_as"> Paper with Inline</label>
                            </div>
                            <div class="radio">
                                <label><input type="radio" name="generate_as"> Paper Answer Key</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-right px-5">
                    <button class="btn btn-success">Back</button>
                    <button class="btn btn-primary">Continue</button>
                </div>
            </form>
        </div>

        <div class="tab-pane fade" id="step3" role="tabpanel" aria-labelledby="step3-tab">
            <form>
                <div class="row mt-3 px-5">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Chapter</label>
                            <select class="form-control">
                                <option selected>Chapter 1</option>
                                <option value="1">Chapter 2</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Questions</label>
                            <select class="form-control">
                                <option selected>Q1</option>
                                <option value="1">Q2</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12">
                    <div class="accordion paper-accordion mt-5">
                            <div class="panel panel-default paper-accordion-item">
                                <div class="panel-heading paper-accordion-header" id="headingOne">
                                    <h4 class="panel-title">
                                        <a data-toggle="collapse" data-parent=".paper-accordion" href="#collapseOne">
                                            Paper Details Accordion
                                        </a>
                                    </h4>
                                </div>
                                <div id="collapseOne" class="panel-collapse collapse in">
                                    <div class="panel-body paper-accordion-body">
                                        Content for Paper Details Accordion goes here. You can add more input fields or descriptions inside this panel.
                                    </div>
                                </div>
                            </div>
                            <div class="panel panel-default paper-accordion-item">
                                <div class="panel-heading paper-accordion-header" id="headingTwo">
                                    <h4 class="panel-title">
                                        <a data-toggle="collapse" data-parent=".paper-accordion" href="#collapseTwo" class="collapsed">
                                            Questions and Chapters Accordion
                                        </a>
                                    </h4>
                                </div>
                                <div id="collapseTwo" class="panel-collapse collapse">
                                    <div class="panel-body paper-accordion-body">
                                        Content for Questions and Chapters Accordion goes here. You can dynamically load questions from the selected chapters.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-right px-5">
                    <button class="btn btn-success">Back</button>
                    <button class="btn btn-primary">Generate</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>





<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

@endsection