@extends('admin.layout.app')

@section('content')
<div class="content-wrapper">

	<section class="content-header">
		<h1 class="pull-left">
			{{ $title }} List
		</h1>
		<span class="pull-right">
			{{--<a href="{{ route($route.'index').'?export=csv' }}" class="btn btn-success"> <i class="fa fa-file-text-o "></i> CSV Export</a>--}}
			{{--<a href="{{ route($route.'index').'?export=xlsx' }}" class="btn btn-success"> <i class="fa fa-file-excel-o "></i> Excel Export</a>
			<a href="{{ route($route.'create') }}" class="btn btn-success"> <i class="fa fa-plus"></i> Add new</a>--}}
		</span>
		<p>&nbsp;</p>

	</section>

	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				@include('flash')
				<div class="box box-info">
					<div class="box-body   ">
						{{--<div class="table-responsive">--}}

						<table id="datatable1" class="table table-bordered table-striped ">
							<thead>
							<tr>
								<!--<th width="50px">Index</th>-->
								<th>Name</th>
								<th>Email</th>
								<th>Mobile</th>
								<th>State</th>
								<th>City</th>
								<!--<th>Created At</th>
								<th width="100px">Status</th>-->
								<th width="100px">Action</th>
							</tr>
							</thead>
							<tbody>
						   
							</tbody>
							<tfoot>
							<tr>
								<!--<th>Index</th>-->
								<th>Name</th>
								<th>Email</th>
								<th>Mobile</th>
								<th>State</th>
								<th>City</th>
								<!--<th>Created At</th>
								<th>Status</th>-->
								<th>Action</th>
							</tr>
							</tfoot>
						</table>
						{{--</div>--}}
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
@endsection

@section('js')
		<!-- DataTables -->
<script type="text/javascript">
	$(document).ready(function () {
		var oTable = $('#datatable1').DataTable({
			responsive: true,
			autoWidth: false,
			stateSave: true,
			processing: true,
			serverSide: true,
            //scrollY: 300,
			ajax: '{{ url('admin/user')  }}',
			columns: [
				/*{data: 'id', name: 'id'},*/
				{data: 'name', name: 'name'},
				{data: 'email', name: 'email'},
				{data: 'mbl', name: 'mbl'},
				{data: 'state.name', name: 'state.name',defaultContent:"-", searchable: false, orderable : false},
				{data: 'city.name', name: 'city.name',defaultContent:"-", searchable: false, orderable : false},
				/*{data: 'created_at', name: 'created_at'},
				{data: 'status', name: 'status', searchable: false,orderable : false,className : 'text-center'},*/
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			]
		});
		$('#datatable1').on('draw.dt', function () {
			$('.chk_status').each(function () {
				$(this).bootstrapToggle()
			});
		});
		$("body").on("change", ".chk_status", function () {
			var row_id = $(this).val();
			if ($(this).is(':checked')) {
				var status = $(this).attr('data-on');// If checked
			} else {
				var status = $(this).attr('data-off'); // If not checked
			}
			$.ajax({
				type: "PUT",
				url: '{{ url('admin/user') }}/' + row_id ,
				data: {
					"_token": "{{ csrf_token() }}",
					"id": row_id,
					"status": status,
				},
				beforeSend: function () {
					$('#datatable1').waitMe({effect: 'roundBounce'});
				},
				complete: function () {
					$('#datatable1').waitMe('hide');
				},
				error: function (result) {
				},
				success: function (result) {
					//Success Code.
				}
			});
		});
		$("#datatable1").on('click', '.data-delete', function () {
			var obj = $(this);
			var id = $(this).attr('data-id');
			if (confirm("Are you sure to Delete Data?")) {
				$.ajax({
					type: "DELETE",
					url: "{{ url('admin/user')  }}/" + id,
					data: {
						id: id,
						_token: "{{ csrf_token() }}"
					},
					dataType: 'json',
					beforeSend: function () {
						$(this).attr('disabled', true);
						$('.alert .msg-content').html('');
						$('.alert').hide();
					},
					success: function (resp) {
						oTable.ajax.reload();
						alert(resp.message);
					},
					error: function (e) {
						if (e.status == 403) {
							alert('Unauthorized: Access is denied due to invalid credentials.');
						}else{
							//alert('Error: ' + e);
							alert('internal error occurred.');
						}
					}
				});
			}
		});
	});
</script>
@endsection