@extends('admin.layout.app')

@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                Site
                <small>Setting</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="{{ url('admin/home') }}"><i class="fa fa-user"></i> Home</a></li>
                <li class="active">{{ $title }}</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-md-8 col-md-offset-1">
                    @include('flash')
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update {{ $title }}</h3>
                        </div>
                        {!! Form::model($record,['route' => 'admin.sitesetting_post', 'method' => 'post','files'=>true]) !!}
						{{ Form::hidden('id', $record->id) }}
                            <div class="box-body">
                                <div class="form-group {{ $errors->has('comp_name') ? ' has-error' : '' }}">
                                    <label class="control-label">Name <span class="text-danger"></span></label>
                                    {!! Form::text('comp_name',null, ['class' => 'form-control']) !!}
                                    <span class="help-block" id="error_name"><strong>{{ $errors->first('comp_name') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('meta_tag') ? ' has-error' : '' }}">
                                    <label class="control-label">Meta Tag <span class="text-danger"></span></label>
                                    {!! Form::text('meta_tag',null, ['class' => 'form-control']) !!}
                                    <span class="help-block" id="error_email"><strong>{{ $errors->first('meta_tag') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('image') ? ' has-error' : '' }}">
                                    <label class="control-label">Logo<span class="text-danger"></span></label>
                                    {!! Form::file('image', ['class' => ' thumb_image']) !!}
                                    <span class="help-block" id="error_image"><strong>{{ $errors->first('image') }}</strong></span>
                                </div>
								<div class="form-group {{ $errors->has('comp_address') ? ' has-error' : '' }}">
									<label class="control-label">Address</label>
									{!! Form::textarea('comp_address', null, ['class'=>'form-control','id'=>'comp_address', 'rows' => 4]) !!}
									<span class="help-block" id="error_comp_address"><strong>{{ $errors->first('comp_address') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('comp_email') ? ' has-error' : '' }}">
                                    <label class="control-label">Email <span class="text-danger"></span></label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-envelope-o"></i></button>
										</div>
                                        {!! Form::text('comp_email',null, ['class' => 'form-control']) !!}
									</div>	
                                    <span class="help-block" id="error_email"><strong>{{ $errors->first('comp_email') }}</strong></span>
                                </div>
								<div class="form-group {{ $errors->has('comp_phone') ? ' has-error' : '' }}">
									<label class="control-label">Phone </label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-phone-square"></i></button>
										</div>
									    {!! Form::text('comp_phone',null, ['class' => 'form-control']) !!}
									</div>	
									<span class="help-block" id="error_name"><strong>{{ $errors->first('comp_phone') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('comp_phone2') ? ' has-error' : '' }}">
									<label class="control-label">Phone 2 </label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-phone-square"></i></button>
										</div>
									    {!! Form::text('comp_phone2',null, ['class' => 'form-control']) !!}
									</div>
									<span class="help-block" id="error_name"><strong>{{ $errors->first('comp_phone2') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('comp_phone3') ? ' has-error' : '' }}">
									<label class="control-label">Phone 3 </label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-phone-square"></i></button>
										</div>
									    {!! Form::text('comp_phone3',null, ['class' => 'form-control']) !!}
									</div>
									<span class="help-block" id="error_name"><strong>{{ $errors->first('comp_phone3') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('comp_fb') ? ' has-error' : '' }}">
									<label class="control-label">Facebook Link</label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-facebook-square"></i></button>
										</div>
									    {!! Form::text('comp_fb',null, ['class' => 'form-control']) !!}
									</div>	
									<span class="help-block" id="error_name"><strong>{{ $errors->first('comp_fb') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('insta_link') ? ' has-error' : '' }}">
									<label class="control-label">Instagram Link</label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-instagram"></i></button>
										</div>
									    {!! Form::text('insta_link',null, ['class' => 'form-control']) !!}
									</div>	
									<span class="help-block" id="error_name"><strong>{{ $errors->first('insta_link') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('comp_tweeter') ? ' has-error' : '' }}">
									<label class="control-label">Twitter Link</label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-twitter"></i></button>
										</div>
									    {!! Form::text('comp_tweeter',null, ['class' => 'form-control']) !!}
									<span class="help-block" id="error_name"><strong>{{ $errors->first('comp_tweeter') }}</strong></span>
									</div>
								</div>
								<div class="form-group {{ $errors->has('linkdin_link') ? ' has-error' : '' }}">
									<label class="control-label">LinkedIn Link</label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-linkedin"></i></button>
										</div>
									    {!! Form::text('linkdin_link',null, ['class' => 'form-control']) !!}
									</div>	
									<span class="help-block" id="error_name"><strong>{{ $errors->first('linkdin_link') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('comp_gplus') ? ' has-error' : '' }}">
									<label class="control-label">Googgle Plus Link</label>
									<div class="input-group " >
										<div class="input-group-btn">
											<button type="button" class="btn btn-primary"><i class="fa fa-google"></i></button>
										</div>
									    {!! Form::text('comp_gplus',null, ['class' => 'form-control']) !!}
									</div>	
									<span class="help-block" id="error_name"><strong>{{ $errors->first('comp_gplus') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('abt_detail') ? ' has-error' : '' }}">
									<label class="control-label">About us Detail</label>
									{!! Form::textarea('abt_detail', null, ['class'=>'form-control','id'=>'abt_detail']) !!}
									<span class="help-block" id="error_name"><strong>{{ $errors->first('abt_detail') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('privacy_policy') ? ' has-error' : '' }}">
									<label class="control-label">Privacy Policy</label>
									{!! Form::textarea('privacy_policy', null, ['class'=>'form-control','id'=>'privacy_policy']) !!}
									<span class="help-block" id="error_name"><strong>{{ $errors->first('privacy_policy') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('tandc') ? ' has-error' : '' }}">
									<label class="control-label">Term and Condition</label>
									{!! Form::textarea('tandc', null, ['class'=>'form-control','id'=>'tandc']) !!}
									<span class="help-block" id="error_name"><strong>{{ $errors->first('tandc') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('help') ? ' has-error' : '' }}">
									<label class="control-label">Help</label>
									{!! Form::textarea('help', null, ['class'=>'form-control','id'=>'help']) !!}
									<span class="help-block" id="error_name"><strong>{{ $errors->first('help') }}</strong></span>
								</div>
								<div class="form-group {{ $errors->has('subscribe_name') ? ' has-error' : '' }}">
                                    <label class="control-label">Subscribe Name <span class="text-danger"></span></label>
                                    {!! Form::text('subscribe_name',null, ['class' => 'form-control']) !!}
                                    <span class="help-block" id="error_name"><strong>{{ $errors->first('subscribe_name') }}</strong></span>
                                </div>
								<div class="form-group {{ $errors->has('subscribe_price') ? ' has-error' : '' }}">
                                    <label class="control-label">Subscribe Price <span class="text-danger"></span></label>
                                    {!! Form::text('subscribe_price',null, ['class' => 'form-control']) !!}
                                    <span class="help-block" id="error_name"><strong>{{ $errors->first('subscribe_price') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('subscribe_detail') ? ' has-error' : '' }}">
									<label class="control-label">Subscribe Detail</label>
									{!! Form::textarea('subscribe_detail', null, ['class'=>'form-control','id'=>'subscribe_detail']) !!}
									<span class="help-block" id="error_name"><strong>{{ $errors->first('subscribe_detail') }}</strong></span>
								</div>
                            </div>
                            <div class="box-footer">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
                <div class="col-md-3 text-center">
                    <img src="{{ !empty($record['image'])?$record['image_url']:url('public/assets/admin/images/not-available.jpg') }}" id="thumb_image" width="100%" />
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
<script type="text/javascript">
    CKEDITOR.config.removeButtons = 'Image';
	CKEDITOR.replace('abt_detail');
	CKEDITOR.replace('privacy_policy');
	CKEDITOR.replace('tandc');
	CKEDITOR.replace('help');
	CKEDITOR.replace('subscribe_detail');
</script>
@endsection