@extends('admin.layout.app')

@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                Profile
                <small>Setting</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="{{ url('admin/home') }}"><i class="fa fa-user"></i> Home</a></li>
                <li class="active">Profile</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-md-6 col-md-offset-3">
                    @include('flash')
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Password  Reset</h3>
                        </div>
                        {!! Form::open(['route' => 'admin.profile.password', 'method' => 'post']) !!}
                            <div class="box-body">
                                <div class="form-group {{ $errors->has('password') ? ' has-error' : '' }}">
                                    <label class="control-label">Password <span class="text-danger">*</span></label>
                                    {!! Form::text('password',null, ['class' => 'form-control']) !!}
                                    <span class="help-block" id="error_password"><strong>{{ $errors->first('password') }}</strong></span>
                                </div>
                                
                               <div class="form-group {{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                   <label class="control-label">Password Confirmation <span class="text-danger">*</span></label>
                                   {!! Form::text('password_confirmation',null, ['class' => 'form-control']) !!}
                                   <span class="help-block" id="error_password_confirmation"><strong>{{ $errors->first('password_confirmation') }}</strong></span>
                               </div>
                            </div>
                            <div class="box-footer">
                                <button type="submit" class="btn btn-primary pull-right">Submit</button>
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection