<div class="row">
    <div class="col-md-6 col-md-offset-3">

        <div class="form-group {{ $errors->has('name') ? ' has-error' : '' }}">
            <label class="control-label">Name <span class="text-danger">*</span></label>
            {!! Form::text('name',null, ['class' => 'form-control','required'=>'required']) !!}
            <span class="help-block" id="error_name"><strong>{{ $errors->first('name') }}</strong></span>
        </div>
	    <div class="form-group {{ $errors->has('standard_id') ? ' has-error' : '' }}">
            <label class="control-label">Standard <span class="text-danger">*</span></label>
            {!! Form::select('standard_id',[''=>'-- Select Standard --']+$dropdown ,null, ['class' => 'form-control js-example-basic-multiple','id'=>'standard_id','required'=>'required']) !!}
            <span class="help-block" id="error_category_id"><strong>{{ $errors->first('standard_id') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('subject_id') ? ' has-error' : '' }}">
            <label class="control-label">Subject <span class="text-danger">*</span></label>
            {!! Form::select('subject_id',[''=>'-- Select Subject --']+App\Model\Subject::all()->pluck('name','id')->toArray() ,null, ['class' => 'form-control js-example-basic-multiple','id'=>'subject_id','required'=>'required']) !!}
            <span class="help-block" id="error_category_id"><strong>{{ $errors->first('subject_id') }}</strong></span>
        </div>
       
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('.js-example-basic-multiple').select2();
    });
</script>
@section('js')
<script>
    $(document).ready(function() {
    $('#standard_id').change(function() {
        var standardId = $(this).val();
        $('#subject_id').empty(); // Clear the subjects dropdown

        if (standardId) {
            $.ajax({
                url: "{{ url('admin/getsubject') }}/" + standardId, // Update with your route
                type: 'GET',
                success: function(data) {
                    // Populate subjects dropdown
                    $('#subject_id').append($('<option value="">-- Select Subject --</option>'))
                    $.each(data, function(key, value) {
                        $('#subject_id').append($('<option></option>').attr('value', key).text(value));
                    });
                },
                error: function() {
                    alert('Could not fetch subjects. Please try again later.');
                }
            });
        } else {
            $('#subject_id').empty(); // If no standard selected, clear subjects
        }
    });
    $('#subject_id').change(function() {
        var subjectId = $(this).val();
        $('#chapter_id').empty(); // Clear the subjects dropdown

        if (subjectId) {
            $.ajax({
                url: "{{ url('admin/getchapter') }}/" + subjectId, // Update with your route
                type: 'GET',
                success: function(data) {
                    // Populate subjects dropdown
                    $('#chapter_id').append($('<option value="">-- Select Chapter --</option>'))
                    $.each(data, function(key, value) {
                        $('#chapter_id').append($('<option></option>').attr('value', key).text(value));
                    });
                },
                error: function() {
                    alert('Could not fetch subjects. Please try again later.');
                }
            });
        } else {
            $('#chapter_id').empty(); // If no standard selected, clear subjects
        }
    });
});
</script>
@endsection 



