@extends('admin.layout.app')

@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <h1 class="pull-left">
               Update Question
            </h1>
            <p>&nbsp;</p>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    {!! Form::open(['url' => 'admin/question/updatequestiondata', 'files' =>true, 'method' => 'post','id'=>'myform' ,'class' => 'ajax_submit','autocomplete'=>'off']) !!}
                    <div class="box box-primary">
                        <div class="box-header with-border ">
                            <h3 class="box-title">Enter Details</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <input type="hidden" name="id" value="{{ $record->id }}">
                                <div class="col-md-6 col-md-offset-3">
								@include('flash')
									<div class="form-group {{ $errors->has('question') ? ' has-error' : '' }}">
										<label class="control-label">Question <span class="text-danger">*</span></label>
										{!! Form::textarea('question',$record->question, ['class' => 'form-control','required'=>'required','rows'=>'2','id'=>'question']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('question') }}</strong></span>
									</div>
									@if($record->question_type == 'Question')
									<div class="form-group answer {{ $errors->has('answer') ? ' has-error' : '' }}">
										<label class="control-label">Answer <span class="text-danger">*</span></label>
										{!! Form::textarea('answer',$record->answer, ['class' => 'form-control','rows'=>'2']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('answer') }}</strong></span>
									</div>
									@else
									<div class="form-group option {{ $errors->has('option1') ? ' has-error' : '' }}">
										<label class="control-label">Option 1 (True Answer)<span class="text-danger">*</span></label>
										{!! Form::text('option1',$record->option1, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option1') }}</strong></span>
									</div>
									<div class="form-group option {{ $errors->has('option2') ? ' has-error' : '' }}">
										<label class="control-label">Option 2 <span class="text-danger">*</span></label>
										{!! Form::text('option2',$record->option2, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option2') }}</strong></span>
									</div>
									<div class="form-group option {{ $errors->has('option3') ? ' has-error' : '' }}">
										<label class="control-label">Option 3 <span class="text-danger">*</span></label>
										{!! Form::text('option3',$record->option3, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option3') }}</strong></span>
									</div>
									<div class="form-group option {{ $errors->has('option4') ? ' has-error' : '' }}">
										<label class="control-label">Option 4 <span class="text-danger">*</span></label>
										{!! Form::text('option4',$record->option4, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option4') }}</strong></span>
									</div>
									@endif
									 <button type="submit" class="btn btn-primary pull-right">Submit</button>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <a href="{{url('admin/question/addquestion/'.$record->question_id) }}" type="submit"
                               class="btn btn-default pull-left">Back</a>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection

@section('js')
<script>

        /*ClassicEditor
            .create( document.querySelector( '#question' ), {} )
            .catch( error => {
                console.error( error );
            } );*/
    </script>
<script>

CKEDITOR.env.isCompatible = true; 
var mathElements = [
        'math',
        'maction',
        'maligngroup',
        'malignmark',
        'menclose',
        'merror',
        'mfenced',
        'mfrac',
        'mglyph',
        'mi',
        'mlabeledtr',
        'mlongdiv',
        'mmultiscripts',
        'mn',
        'mo',
        'mover',
        'mpadded',
        'mphantom',
        'mroot',
        'mrow',
        'ms',
        'mscarries',
        'mscarry',
        'msgroup',
        'msline',
        'mspace',
        'msqrt',
        'msrow',
        'mstack',
        'mstyle',
        'msub',
        'msup',
        'msubsup',
        'mtable',
        'mtd',
        'mtext',
        'mtr',
        'munder',
        'munderover',
        'semantics',
        'annotation',
        'annotation-xml'
      ];
	CKEDITOR.plugins.addExternal('ckeditor_wiris', 'https://ckeditor.com/docs/ckeditor4/4.16.2/examples/assets/plugins/ckeditor_wiris/', 'plugin.js');
	CKEDITOR.replace('question', {
		extraPlugins: 'ckeditor_wiris,image2,uploadimage',
		extraAllowedContent: mathElements.join(' ') + '(*)[*]{*};img[data-mathml,data-custom-editor,role](Wirisformula)',
		filebrowserUploadUrl: "{{route('admin.question.upload', ['_token' => csrf_token() ])}}",
		filebrowserUploadMethod: 'form',
		removeButtons: 'ExportPdf,Form,ImageButton',
		filebrowserBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=2&editor=ckeditor&fldr=",
		filebrowserImageBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=1&editor=ckeditor&fldr=",
	});
	CKEDITOR.replace('answer', {
		extraPlugins: 'ckeditor_wiris,image2,uploadimage',
		extraAllowedContent: mathElements.join(' ') + '(*)[*]{*};img[data-mathml,data-custom-editor,role](Wirisformula)',
		filebrowserUploadUrl: "{{route('admin.question.upload', ['_token' => csrf_token() ])}}",
		filebrowserUploadMethod: 'form',
		removeButtons: 'ExportPdf,Form,ImageButton',
		filebrowserBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=2&editor=ckeditor&fldr=",
		filebrowserImageBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=1&editor=ckeditor&fldr=",
	});
</script>
<script src="https://www.wiris.net/demo/plugins/app/WIRISplugins.js?viewer=image"></script>
@endsection
