@extends('admin.layout.app')

@section('content')
<style>
	.site_fullwi .select2-container{ width:100% !important;}
</style>
<?php
$session_paperstyle_id=Session::get('session_paperstyle_id');
?>
    <div class="content-wrapper">
        <section class="content-header">
            <h1 class="pull-left">
               Add Question
            </h1>
            <p>&nbsp;</p>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    {!! Form::open(['url' => 'admin/question/savequestion', 'files' =>true, 'method' => 'post','id'=>'myform' ,'class' => 'ajax_submit','autocomplete'=>'off', 'novalidate'=>'true']) !!}
                    <div class="box box-primary">
                        <div class="box-header with-border ">
                            <h3 class="box-title">Enter Details  <b>Board:-</b>{{ $question->board->name }} , <b>Medium:-</b>{{ $question->medium->name }}, <b>Standard:-</b>{{ $question->standard->name }}, <b>Subject:-</b>{{ $question->subject->name }}, <b>Chapter:-</b>{{ $question->chapter->name }}</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <input type="hidden" name="question_id" value="{{$question_id}}">
                                <div class="col-md-6 col-md-offset-3">
								   @include('flash')
                                    <div class="form-group site_fullwi {{ $errors->has('paperstyle_id') ? ' has-error' : '' }}">
										<label class="control-label">Paper Style <span class="text-danger">*</span></label>
										@if(!empty($session_paperstyle_id))
										{!! Form::select('paperstyle_id',['' => '---- Select Mark ----'] +App\Model\Paperstyle::all()->pluck('name','id')->toArray() ,$session_paperstyle_id, ['class' => 'form-control ','required'=>'required','id'=>'paperstyle_id','onchange'=>'setdata();']) !!}
									    @else
										{!! Form::select('paperstyle_id',['' => '---- Select Mark ----'] +App\Model\Paperstyle::all()->pluck('name','id')->toArray() ,null, ['class' => 'form-control ','required'=>'required','id'=>'paperstyle_id','onchange'=>'setdata();']) !!}
										@endif
										<span class="help-block" id="error_category_id"><strong>{{ $errors->first('paperstyle_id') }}</strong></span>
									</div>
									<div class="form-group question_type_view site_fullwi {{ $errors->has('question_type') ? ' has-error' : '' }}" style="display:none;">
										<label class="control-label">Question Type</label>
										{!! Form::select('question_type',array('Question' => 'Question','Option' => 'Option') ,null, ['class' => 'form-control ','id'=>'question_type','onchange'=>'setdata();']) !!}
										<span class="help-block" id="error_size"><strong>{{ $errors->first('question_type') }}</strong></span>
									</div>
									
									<div id="category_list">
									
									</div>
									<div class="form-group {{ $errors->has('question') ? ' has-error' : '' }}">
										<label class="control-label">Question <span class="text-danger">*</span></label>
										{!! Form::textarea('question',null, ['class' => 'form-control','required'=>'required','rows'=>'2','id'=>'question']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('question') }}</strong></span>
									</div>
									<div class="form-group answer {{ $errors->has('answer') ? ' has-error' : '' }}" style="display:none;">
										<label class="control-label">Answer <span class="text-danger">*</span></label>
										{!! Form::textarea('answer',null, ['class' => 'form-control','rows'=>'2']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('answer') }}</strong></span>
									</div>
									<div class="form-group option {{ $errors->has('option1') ? ' has-error' : '' }}" style="display:none;">
										<label class="control-label">Option 1 (True Answer)<span class="text-danger">*</span></label>
										{!! Form::text('option1',null, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option1') }}</strong></span>
									</div>
									<div class="form-group option {{ $errors->has('option2') ? ' has-error' : '' }}" style="display:none;">
										<label class="control-label">Option 2 <span class="text-danger">*</span></label>
										{!! Form::text('option2',null, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option2') }}</strong></span>
									</div>
									<div class="form-group option {{ $errors->has('option3') ? ' has-error' : '' }}" style="display:none;">
										<label class="control-label">Option 3 <span class="text-danger">*</span></label>
										{!! Form::text('option3',null, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option3') }}</strong></span>
									</div>
									<div class="form-group option {{ $errors->has('option4') ? ' has-error' : '' }}" style="display:none;">
										<label class="control-label">Option 4 <span class="text-danger">*</span></label>
										{!! Form::text('option4',null, ['class' => 'form-control']) !!}
										<span class="help-block" id="error_name"><strong>{{ $errors->first('option4') }}</strong></span>
									</div>
									 <button type="submit" class="btn btn-primary pull-right">Submit</button>
                                </div>
                            </div>
                        </div>
						@if(!$record->isEmpty())	
						<div class="box-body">
						    <div class="table-responsive">
    							<table class="table table-bordered" id="myTable">
    							<thead>
    							  <tr>
    								<th>Mark</th>
    								<th width="600px">Question</th>
    								<th width="800px">Answer</th>
    								<th>Action</th>
    							  </tr>
    							  @foreach($record as $key=>$r)
    							  <tr>
    								<td>{{ $r->paperstyle->name }}</td>
    								<td>{!! $r->question !!}</td>
    								@if($r->question_type == 'Question')
    								     <td>{!! $r->answer !!}</td>
    							    @else
    									<td><b>Option 1 (True Answer):-</b>{{ $r->option1 }}<br>
    									<b>Option 2:-</b>{{ $r->option2 }}<br>
    									<b>Option 3:-</b>{{ $r->option3 }}<br>
    									<b>Option 4:-</b>{{ $r->option4 }}</td>
    								@endif	
    								<td>
    								<a href="{{url('admin/question/updatequestion/'.$r->id) }}" class="btn btn-info btn-sm" title="Edit"><i class="fa fa-pencil"></i></a>
    								<a href="#" data-id="{{$r->id}}" class="btn btn-danger btn-sm data-delete btndelete" title="Delete"><i class="fa fa-trash"></i></a>
    								</td>
    							  </tr>
    							  @endforeach
    							</thead>
    							</table>
							</div>
							<div class="pull-right">
							{{ $record->links() }}
							</div>
						</div>
						@endif
                        <div class="box-footer">
                            <a href="{{ route($route.'index') }}" type="submit"
                               class="btn btn-default pull-left">Back</a>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection

@section('js')
<script>

        /*ClassicEditor
            .create( document.querySelector( '#question' ), {} )
            .catch( error => {
                console.error( error );
            } );*/
    </script>
<script>

CKEDITOR.env.isCompatible = true; 
var mathElements = [
        'math',
        'maction',
        'maligngroup',
        'malignmark',
        'menclose',
        'merror',
        'mfenced',
        'mfrac',
        'mglyph',
        'mi',
        'mlabeledtr',
        'mlongdiv',
        'mmultiscripts',
        'mn',
        'mo',
        'mover',
        'mpadded',
        'mphantom',
        'mroot',
        'mrow',
        'ms',
        'mscarries',
        'mscarry',
        'msgroup',
        'msline',
        'mspace',
        'msqrt',
        'msrow',
        'mstack',
        'mstyle',
        'msub',
        'msup',
        'msubsup',
        'mtable',
        'mtd',
        'mtext',
        'mtr',
        'munder',
        'munderover',
        'semantics',
        'annotation',
        'annotation-xml'
      ];
	CKEDITOR.plugins.addExternal('ckeditor_wiris', 'https://ckeditor.com/docs/ckeditor4/4.16.2/examples/assets/plugins/ckeditor_wiris/', 'plugin.js');
	CKEDITOR.replace('question', {
		extraPlugins: 'ckeditor_wiris,image2,uploadimage',
		extraAllowedContent: mathElements.join(' ') + '(*)[*]{*};img[data-mathml,data-custom-editor,role](Wirisformula)',
		filebrowserUploadUrl: "{{route('admin.question.upload', ['_token' => csrf_token() ])}}",
		filebrowserUploadMethod: 'form',
		removeButtons: 'ExportPdf,Form,ImageButton',
		filebrowserBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=2&editor=ckeditor&fldr=",
		filebrowserImageBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=1&editor=ckeditor&fldr=",
	});
	CKEDITOR.replace('answer', {
		extraPlugins: 'ckeditor_wiris,image2,uploadimage',
		extraAllowedContent: mathElements.join(' ') + '(*)[*]{*};img[data-mathml,data-custom-editor,role](Wirisformula)',
		filebrowserUploadUrl: "{{route('admin.question.upload', ['_token' => csrf_token() ])}}",
		filebrowserUploadMethod: 'form',
		removeButtons: 'ExportPdf,Form,ImageButton',
		filebrowserBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=2&editor=ckeditor&fldr=",
		filebrowserImageBrowseUrl : "{{asset('ckeditor/filemanager/dialog.php')}}?type=1&editor=ckeditor&fldr=",
	});
</script>
<script src="https://www.wiris.net/demo/plugins/app/WIRISplugins.js?viewer=image"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.js-example-basic-multiple').select2();
		setdata();
    });
	function setdata(){
		var paperstyle_id = $('#paperstyle_id').val();
		var question_type = $('#question_type').val();
		if(paperstyle_id == 1){
			$(".question_type_view").show();
			if(question_type == 'Question'){
				$(".answer").show();
				$(".option").hide();
			}
			else{
				$(".option").show();
				$(".answer").hide();
			}
		}
		else{
			$(".question_type_view").hide();
			$('#question_type').val('Question');
			$(".answer").show();
			$(".option").hide();
		}
		getcategory(paperstyle_id);
		
	}
	function savepaperstyle(paperstyle_id) {
		$.ajax({
			url: "{{ url('admin/savepaperstyle')  }}",
			type: 'POST',
			data: {
				"paperstyle_id": paperstyle_id, "_token": "{{ csrf_token() }}",
			},
			success: function (data) {
				
			}
		});
	}
	function getcategory(paperstyle_id) {
		$.ajax({
			url: "{{ url('admin/getcategory')  }}",
			type: 'POST',
			data: {
				"paperstyle_id": paperstyle_id, "_token": "{{ csrf_token() }}",
			},
			success: function (data) {
				savepaperstyle(paperstyle_id);
				$("#category_list").html(data);
			}
		});
	}
	/*CKEDITOR.config.removeButtons = 'Image';
	CKEDITOR.replace('question');*/
	
	/*$('#paperstyle_id').on('change', function() {
		paperstyle();
	});*/
	
	/*function paperstyle() {
		var paperstyle_id = $('#paperstyle_id').val();
		var question_type = $('#question_type').val();
		savepaperstyle(paperstyle_id);
	  
	  if(paperstyle_id == 1){
		  $(".question_type_view").show();
		  if(question_type == 'Question'){
			  getcategory(paperstyle_id);
			 $(".answer").show();
			 $(".option").hide();
			 $(".category_view_2").show();
			 $('.category_view_2').prop("disabled", false);
		  }else{
			  $(".answer").hide();
			  $(".category_view_2").hide();
			   $('.category_view_2').prop("disabled", true);
			  $(".option").show();
		  }
	  }else{
		  if((paperstyle_id == 2) || (paperstyle_id == 3)){
			  getcategory(paperstyle_id);
			  $(".category_view_2").show();
			  $('.category_view_2').prop("disabled", false);
		  }
		  else{
			  console.log(paperstyle_id);
			  $(".category_view_2").hide();
			  $('.category_view_2').prop("disabled", true);
		  }		  
		  $(".question_type_view").hide();
		  $('#question_type').val('Question').change();
		  console.log($('#question_type').val());
		  $(".answer").show();
		  $(".option").hide();
	  }
	}	
	
	$('#question_type').on('change', function() {
	  var question_type = $('#question_type').val();
	  if(question_type == 'Question'){
		  $(".option").hide();
		  $(".answer").show();
		  $(".category_view_2").show();
		  $('#paperstyle_id').val();
		  console.log(paperstyle_id);
		  $('.category_view_2').prop("disabled", false);
	  }else{
		  $(".option").show();
		  $(".answer").hide();
		  $(".category_view_2").hide();
		  $('.category_view_2').prop("disabled", true);
	  }
	});*/
	
	/*$(document).on('change', 'select[name=paperstyle_id]', function () {
		var paperstyle_id = $(this).val();
		savepaperstyle(paperstyle_id);
		getcategory(paperstyle_id);
	});*/

	/*function savepaperstyle(paperstyle_id) {
		$.ajax({
			url: "{{ url('admin/savepaperstyle')  }}",
			type: 'POST',
			data: {
				"paperstyle_id": paperstyle_id, "_token": "{{ csrf_token() }}",
			},
			success: function (data) {
				
			}
		});
	}*/
	/*function getcategory(paperstyle_id) {
		var question_type = $('#question_type').val();
		if( (question_type=='Question') || paperstyle_id == 1 || paperstyle_id == 2 || paperstyle_id == 3){
			$.ajax({
				url: "{{ url('admin/getcategory')  }}",
				type: 'POST',
				data: {
					"paperstyle_id": paperstyle_id, "_token": "{{ csrf_token() }}",
				},
				success: function (data) {
					$("#category_list").html(data);
				}
			});
		}

	}*/
</script>

<script type="text/javascript">
$(".btndelete").on('click', function () {
            var obj = $(this);
            var id = $(this).attr('data-id');

            if (confirm("Are you sure to Question?")) {
                $.ajax({
                    type: "DELETE",
                    url: "{{ url('admin/question/deletequestion')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    success: function (resp) {
                        alert(resp.message);
                        location.reload();
                    },
                    error: function (e) {
                        
                    }
                });
            }
        });
</script>
@endsection
