@extends('admin.layout.app')

@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                Profile
                <small>Setting</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="{{ url('admin/home') }}"><i class="fa fa-user"></i> Home</a></li>
                <li class="active">Profile</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-md-6 col-md-offset-1">
                    @include('flash')
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update Profile</h3>
                        </div>
                        {!! Form::model($record,['route' => 'admin.profile_post', 'method' => 'post','files'=>true]) !!}
                            <div class="box-body">
                                <div class="form-group {{ $errors->has('name') ? ' has-error' : '' }}">
                                    <label class="control-label">Name <span class="text-danger">*</span></label>
                                    {!! Form::text('name',null, ['class' => 'form-control']) !!}
                                    <span class="help-block" id="error_name"><strong>{{ $errors->first('name') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('email') ? ' has-error' : '' }}">
                                    <label class="control-label">Email <span class="text-danger">*</span></label>
                                    {!! Form::text('email',null, ['class' => 'form-control']) !!}
                                    <span class="help-block" id="error_email"><strong>{{ $errors->first('email') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('school_name') ? ' has-error' : '' }}">
                                    <label class="control-label">School Name <span class="text-danger"></span></label>
                                    {!! Form::text('school_name',null, ['class' => 'form-control','readonly'=>'readonly']) !!}
                                    <span class="help-block" id="error_email"><strong>{{ $errors->first('school_name') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('address') ? ' has-error' : '' }}">
                                    <label class="control-label">Address<span class="text-danger"></span></label>
                                    {!! Form::text('address',null, ['class' => 'form-control','readonly'=>'readonly']) !!}
                                    <span class="help-block" id="error_email"><strong>{{ $errors->first('address') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('start_date') ? ' has-error' : '' }}">
                                    <label class="control-label">Start Date<span class="text-danger"></span></label>
                                    {!! Form::text('start_date',(!empty($record) && !empty($record->start_date))?date('d-m-Y',strtotime($record->start_date)):null, ['class' => 'form-control datepicker','readonly'=>'readonly']) !!}
                                    <span class="help-block" id="error_email"><strong>{{ $errors->first('start_date') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('end_date') ? ' has-error' : '' }}">
                                    <label class="control-label">End Date<span class="text-danger"></span></label>
                                    {!! Form::text('end_date',(!empty($record) && !empty($record->end_date))?date('d-m-Y',strtotime($record->end_date)):null, ['class' => 'form-control datepicker','readonly'=>'readonly']) !!}
                                    <span class="help-block" id="error_email"><strong>{{ $errors->first('end_date') }}</strong></span>
                                </div>
                                <div class="form-group {{ $errors->has('logo') ? ' has-error' : '' }}">
                                    {{-- <label class="control-label">Logo <span class="text-danger">*</span></label>
                                    {!! Form::file('logo', ['class' => 'form-control thumb_image']) !!}
                                    <span class="help-block" id="error_image"><strong>{{ $errors->first('image') }}</strong></span> --}}
                                    <img src="{{ !empty($record['logo'])?$record['logo_url']:url('public/assets/admin/images/not-available.jpg') }}" id="thumb_logo" width="150" />
                                </div>


                                <div class="form-group {{ $errors->has('image') ? ' has-error' : '' }}">
                                    <label class="control-label">Image <span class="text-danger">*</span></label>
                                    {!! Form::file('image', ['class' => ' thumb_image']) !!}
                                    <span class="help-block" id="error_image"><strong>{{ $errors->first('image') }}</strong></span>
                                </div>
                            </div>
                            <div class="box-footer">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
                <div class="col-md-3 text-center" >
                    <img src="{{ !empty($record['image'])?$record['image_url']:url('public/assets/admin/images/not-available.jpg') }}" id="thumb_image" width="100%" />
                </div>
            </div>
        </section>
    </div>
@endsection