@extends('admin.layout.app')

@section('content')
<div class="content-wrapper">

	<section class="content-header">
		<h1 class="pull-left">
			Paper  List
		</h1>
		<span class="pull-right">
			{{--<a href="{{ route($route.'index').'?export=csv' }}" class="btn btn-success"> <i class="fa fa-file-text-o "></i> CSV Export</a>--}}
			{{--<a href="{{ route($route.'index').'?export=xlsx' }}" class="btn btn-success"> <i class="fa fa-file-excel-o "></i> Excel Export</a>
			<a onclick="deletemultiple();" class="btn btn-danger"> <i class="fa fa-trash"></i> Delete Selected</a>--}}
			<a href="{{ url('admin/paper/create') }}" class="btn btn-success"> <i class="fa fa-plus"></i> Add new</a>
		</span>
		<p>&nbsp;</p>

	</section>

	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				@include('flash')
				<div class="box box-info">
					<div class="box-body">
						{{--<div class="table-responsive">--}}

						<table id="datatable1" class="table table-bordered table-striped ">
							<thead>
							<tr>
							   
								<th>Board</th>
								<th>Standard</th>
                                <th>Semester</th>
								<th>Subject</th>
								<th width="100px">Action</th>
							</tr>
							</thead>
							<tbody>
							
							</tbody>
							<tfoot>
							<tr>
                                <th>Board</th>
								<th>Standard</th>
                                <th>Semester</th>
                                <th>Subject</th>
								<th>Action</th>
							</tr>
							</tfoot>
						</table>
						{{--</div>--}}
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
@endsection

@section('js')
		<!-- DataTables -->
<script type="text/javascript">

	$(document).ready(function () {
		var oTable = $('#datatable1').DataTable({
            responsive: true,
            autoWidth: false,
			stateSave: true,
			processing: true,
			serverSide: true,
			//scrollY: 300,
			ajax: '{{ url('admin/paper')  }}',
			columns: [
			    
				{data: 'board.name', name: 'board.name'},
				{data: 'standard.name', name: 'standard.name'},
                {data: 'semester.name', name: 'semester.name'},
                {data: 'subject.name', name: 'subject.name'},
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			],
			
		});

		$("body").on("change", ".inline_update", function () {
			var field = $(this).attr('field');
			var value = $(this).val();
			var row_id = $(this).attr('row_id');
			var obj = $(this)
			$.ajax({
				type: "PUT",
				url: $(obj).attr('ajax_url'),
				data: {
					"_token": "{{ csrf_token() }}",
					"id": row_id,
					"sequence": value,
				},
				beforeSend: function () {
					$('#datatable1').waitMe({effect: 'roundBounce'});
				},
				complete: function () {
					$('#datatable1').waitMe('hide');
				},
				error: function (e) {
					if (e.status == 403) {
						alert('Unauthorized: Access is denied due to invalid credentials.');
					}else{
						alert('internal error occurred.');
					}
				},
				success: function (result) {
					$(obj).after('<span class="text-success txt_inline_notification">Saved</span>');
					$('.txt_inline_notification').delay(1000).fadeOut('slow');
					//oTable.ajax.reload();
				}
			});
			
		});
		$('#datatable1').on('draw.dt', function () {
			$('.chk_status').each(function () {
				$(this).bootstrapToggle();
			});
		});
		


		$("#datatable1").on('click', '.data-delete', function () {
			var obj = $(this);
			var id = $(this).attr('data-id');

			if (confirm("Are you sure to Delete Data?")) {
				$.ajax({
					type: "DELETE",
					url: "{{ url('admin/category')  }}/" + id,
					data: {
						id: id,
						_token: "{{ csrf_token() }}"
					},
					dataType: 'json',
					beforeSend: function () {
						$(this).attr('disabled', true);
						$('.alert .msg-content').html('');
						$('.alert').hide();
					},
					success: function (resp) {
						oTable.ajax.reload();
						alert(resp.message);
					},
					error: function (e) {
						if (e.status == 403) {
							alert('Unauthorized: Access is denied due to invalid credentials.');
						}else{
							//alert('Error: ' + e);
							alert('internal error occurred.');
						}
					}
				});
			}
		});
	});
</script>
<script>
	function deletemultiple(){
		var id = $.map($('input[name="record_id"]:checked'), function(c){return c.value; });
		if( confirm( 'Are you sure to Delete Data?' ) ) {
			$.ajax(
				{
					url: '{{url('admin/deletemultiplecategory')}}',
					type: 'POST',
					data: {
						"id":id,
						_token: "{{ csrf_token() }}"
					},
					success: function (data)
					{
						alert("Deleted Data successfully!");
						$('#datatable1').DataTable().ajax.reload();
					}
				});
		}
	}
</script>
<script type="text/javascript">
	$(document).ready(function () {
		// $('#example1').DataTable();
		$("body").on('change', '.myswitch', function () {
			if ($(this).is(':checked')) {
				// If checked
				//alert($(this).val());
			} else {
				// If not checked
			}
		});
	});
</script>
@endsection