@extends('admin.layout.app')

@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                Dashboard
                <small>Control panel</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Dashboard</li>
            </ol>
        </section>
        <section class="content">
            <div class="row">
                <section class="col-lg-12 connectedSortable">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs pull-right">
                            <li class="pull-left header"><i class="fa fa-inbox"></i> Sales</li>
                        </ul>
                        <div class="tab-content no-padding">
                            <form class="ajax_chart" action="{{ url('admin/analytics') }}" method="post"> 
                                {{ csrf_field() }}
                                <div class="row">
                                    <br/>
                                    <div class="col-md-3" style="margin-left: 20px;">
                                        <div class="input-group " >
                                            <div class="input-group-btn">
                                                <button type="button" class="btn btn-primary"><i class="fa fa-calendar"></i></button>
                                            </div>
                                            <input name="start_date" class="form-control datepicker" type="text" placeholder="Start date" value="{{ \Carbon\Carbon::now()->subMonth('1')->format('d-m-Y') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="input-group">
                                            <div class="input-group-btn">
                                                <button type="button" class="btn btn-primary"><i class="fa fa-calendar"></i></button>
                                            </div>
                                            <input name="end_date" class="form-control datepicker" type="text" placeholder="End date" value="{{ \Carbon\Carbon::now()->format('d-m-Y') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-1">
                                        <div class="input-group">
                                            <select class="form-control" name="group_by">
                                                <option value="day">Day</option>
                                                <option value="month">Month</option>
                                                <option value="year">Year</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="input-group ">
                                            <button class="btn btn-primary " type="submit">Filter</button>
                                        </div>
                                    </div>
                                    <hr> 
                                </div>
                            </form>
                        </div>
                    </div>
                </section>
            </div>
        </section>
    </div>
@endsection
@section('js')
<script type="text/javascript">
$(document).ready(function () {
	$('.datepicker').datepicker({
		autoclose: true,
		format: 'dd-mm-yyyy',
		todayHighlight: true,
		todayBtn: true,
	});
});
</script>
@endsection


