<div class="row">
    <div class="col-md-6 col-md-offset-3">
        <div class="form-group {{ $errors->has('name') ? ' has-error' : '' }}">
            <label class="control-label">Name <span class="text-danger">*</span></label>
            {!! Form::text('name',null, ['class' => 'form-control']) !!}
            <span class="help-block" id="error_name"><strong>{{ $errors->first('name') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('email') ? ' has-error' : '' }}">
            <label class="control-label">Email <span class="text-danger">*</span></label>
            {!! Form::text('email',null, ['class' => 'form-control']) !!}
            <span class="help-block" id="error_email"><strong>{{ $errors->first('email') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('password') ? ' has-error' : '' }}">
            <label class="control-label">Password <span class="text-danger">*</span></label>
            {!! Form::password('password', ['class' => 'form-control']) !!}
            <span class="help-block" id="error_password"><strong>{{ $errors->first('password') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
            <label class="control-label">Password Confirmation <span class="text-danger">*</span></label>
            {!! Form::password('password_confirmation', ['class' => 'form-control']) !!}
            <span class="help-block" id="error_password_confirmation"><strong>{{ $errors->first('password_confirmation') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('school_name') ? ' has-error' : '' }}">
            <label class="control-label">School Name <span class="text-danger">*</span></label>
            {!! Form::text('school_name',null, ['class' => 'form-control']) !!}
            <span class="help-block" id="error_email"><strong>{{ $errors->first('school_name') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('address') ? ' has-error' : '' }}">
            <label class="control-label">Address<span class="text-danger">*</span></label>
            {!! Form::text('address',null, ['class' => 'form-control']) !!}
            <span class="help-block" id="error_email"><strong>{{ $errors->first('address') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('start_date') ? ' has-error' : '' }}">
            <label class="control-label">Start Date<span class="text-danger">*</span></label>
            {!! Form::text('start_date',(!empty($record) && !empty($record->start_date))?date('d-m-Y',strtotime($record->start_date)):null, ['class' => 'form-control datepicker','required'=>'required']) !!}
            <span class="help-block" id="error_email"><strong>{{ $errors->first('start_date') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('end_date') ? ' has-error' : '' }}">
            <label class="control-label">End Date<span class="text-danger">*</span></label>
            {!! Form::text('end_date',(!empty($record) && !empty($record->end_date))?date('d-m-Y',strtotime($record->end_date)):null, ['class' => 'form-control datepicker','required'=>'required']) !!}
            <span class="help-block" id="error_email"><strong>{{ $errors->first('end_date') }}</strong></span>
        </div>
        <div class="form-group {{ $errors->has('logo') ? ' has-error' : '' }}">
            <label class="control-label">Logo <span class="text-danger">*</span></label>
            {!! Form::file('logo', ['class' => 'form-control thumb_image']) !!}
            <span class="help-block" id="error_image"><strong>{{ $errors->first('image') }}</strong></span>
            <img src="{{ !empty($record['logo'])?$record['logo_url']:url('public/assets/admin/images/not-available.jpg') }}" id="thumb_logo" width="150" />
        </div>
        <div class="form-group {{ $errors->has('image') ? ' has-error' : '' }}">
            <label class="control-label">Image <span class="text-danger">*</span></label>
            {!! Form::file('image', ['class' => 'form-control thumb_image']) !!}
            <span class="help-block" id="error_image"><strong>{{ $errors->first('image') }}</strong></span>
        </div>
    </div>
    <div class="col-md-3 text-center" >
        <img src="{{ !empty($record['image'])?$record['image_url']:url('public/assets/admin/images/not-available.jpg') }}" id="thumb_image" width="150" />
    </div>

</div>
<hr/>
<b><center>User Role</center></b>
<div class="row">
    <div class="col-md-6 col-md-offset-3">
        <div class="form-group {{ $errors->has('role') ? ' has-error' : '' }}">
            <label class="control-label">Select Role <span class="text-danger">*</span></label>
            @if(!empty($record))
            {!! Form::select('role_id',\Spatie\Permission\Models\Role::all()->pluck('name','name'),$record->getRoleNames()->toArray(),['class' => 'form-control']) !!}
		    @else
			{!! Form::select('role_id',\Spatie\Permission\Models\Role::all()->pluck('name','name'),null,['class' => 'form-control']) !!}
		    @endif
            <span class="help-block" id="error_name"><strong>{{ $errors->first('name') }}</strong></span>
        </div>
    </div>    
</div>
@section('js')
<script>
    $(document).ready(function () {
	$('.datepicker').datepicker({
		autoclose: true,
		format: 'dd-mm-yyyy',
		todayHighlight: true,
		todayBtn: true,
	});
    
});
</script>
@endsection

