// Server generates a seed and stores its hash when a user starts a session
const crypto = require('crypto');
const serverSeed = crypto.randomBytes(32).toString('hex');
const serverSeedHash = crypto.createHash('sha256').update(serverSeed).digest('hex');
// Save `serverSeedHash` for this user session

// When a user plays (e.g., a slot spin)
app.post('/api/spin', async (req, res) => {
  const { clientSeed, bet } = req.body;
  const userId = req.user.id; // From verified Telegram initData

  // 1. Get user's balance from DB, check if they can afford the bet
  // 2. Calculate outcome
  const nonce = await getNextNonce(userId); // Incrementing nonce for each game
  const hash = crypto.createHash('sha256').update(serverSeed + clientSeed + nonce).digest('hex');
  
  // Use the hash to determine the slot result (e.g., first 5 characters convert to numbers)
  const outcome = calculateSlotOutcome(hash); 

  // 3. Calculate winnings based on outcome and bet
  const winAmount = calculateWin(outcome, bet);

  // 4. Update user's balance in the database
  await updateUserBalance(userId, -bet + winAmount);

  // 5. Send result to user. Later, they can verify with the revealed serverSeed.
  res.json({
    outcome,
    winAmount,
    currentBalance: await getUserBalance(userId),
    // Provide data for verification later
    nonce,
    serverSeedHash: getStoredServerSeedHash(userId) 
  });
});