/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/conversions.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/conversions.js ***!
  \***************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* MIT license */
/* eslint-disable no-mixed-operators */
const cssKeywords = __webpack_require__(/*! color-name */ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-name/index.js");

// NOTE: conversions should only return primitive values (i.e. arrays, or
//       values that give correct `typeof` results).
//       do not use box values types (i.e. Number(), String(), etc.)

const reverseKeywords = {};
for (const key of Object.keys(cssKeywords)) {
	reverseKeywords[cssKeywords[key]] = key;
}

const convert = {
	rgb: {channels: 3, labels: 'rgb'},
	hsl: {channels: 3, labels: 'hsl'},
	hsv: {channels: 3, labels: 'hsv'},
	hwb: {channels: 3, labels: 'hwb'},
	cmyk: {channels: 4, labels: 'cmyk'},
	xyz: {channels: 3, labels: 'xyz'},
	lab: {channels: 3, labels: 'lab'},
	lch: {channels: 3, labels: 'lch'},
	hex: {channels: 1, labels: ['hex']},
	keyword: {channels: 1, labels: ['keyword']},
	ansi16: {channels: 1, labels: ['ansi16']},
	ansi256: {channels: 1, labels: ['ansi256']},
	hcg: {channels: 3, labels: ['h', 'c', 'g']},
	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
	gray: {channels: 1, labels: ['gray']}
};

module.exports = convert;

// Hide .channels and .labels properties
for (const model of Object.keys(convert)) {
	if (!('channels' in convert[model])) {
		throw new Error('missing channels property: ' + model);
	}

	if (!('labels' in convert[model])) {
		throw new Error('missing channel labels property: ' + model);
	}

	if (convert[model].labels.length !== convert[model].channels) {
		throw new Error('channel and label counts mismatch: ' + model);
	}

	const {channels, labels} = convert[model];
	delete convert[model].channels;
	delete convert[model].labels;
	Object.defineProperty(convert[model], 'channels', {value: channels});
	Object.defineProperty(convert[model], 'labels', {value: labels});
}

convert.rgb.hsl = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const min = Math.min(r, g, b);
	const max = Math.max(r, g, b);
	const delta = max - min;
	let h;
	let s;

	if (max === min) {
		h = 0;
	} else if (r === max) {
		h = (g - b) / delta;
	} else if (g === max) {
		h = 2 + (b - r) / delta;
	} else if (b === max) {
		h = 4 + (r - g) / delta;
	}

	h = Math.min(h * 60, 360);

	if (h < 0) {
		h += 360;
	}

	const l = (min + max) / 2;

	if (max === min) {
		s = 0;
	} else if (l <= 0.5) {
		s = delta / (max + min);
	} else {
		s = delta / (2 - max - min);
	}

	return [h, s * 100, l * 100];
};

convert.rgb.hsv = function (rgb) {
	let rdif;
	let gdif;
	let bdif;
	let h;
	let s;

	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const v = Math.max(r, g, b);
	const diff = v - Math.min(r, g, b);
	const diffc = function (c) {
		return (v - c) / 6 / diff + 1 / 2;
	};

	if (diff === 0) {
		h = 0;
		s = 0;
	} else {
		s = diff / v;
		rdif = diffc(r);
		gdif = diffc(g);
		bdif = diffc(b);

		if (r === v) {
			h = bdif - gdif;
		} else if (g === v) {
			h = (1 / 3) + rdif - bdif;
		} else if (b === v) {
			h = (2 / 3) + gdif - rdif;
		}

		if (h < 0) {
			h += 1;
		} else if (h > 1) {
			h -= 1;
		}
	}

	return [
		h * 360,
		s * 100,
		v * 100
	];
};

convert.rgb.hwb = function (rgb) {
	const r = rgb[0];
	const g = rgb[1];
	let b = rgb[2];
	const h = convert.rgb.hsl(rgb)[0];
	const w = 1 / 255 * Math.min(r, Math.min(g, b));

	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

	return [h, w * 100, b * 100];
};

convert.rgb.cmyk = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;

	const k = Math.min(1 - r, 1 - g, 1 - b);
	const c = (1 - r - k) / (1 - k) || 0;
	const m = (1 - g - k) / (1 - k) || 0;
	const y = (1 - b - k) / (1 - k) || 0;

	return [c * 100, m * 100, y * 100, k * 100];
};

function comparativeDistance(x, y) {
	/*
		See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
	*/
	return (
		((x[0] - y[0]) ** 2) +
		((x[1] - y[1]) ** 2) +
		((x[2] - y[2]) ** 2)
	);
}

convert.rgb.keyword = function (rgb) {
	const reversed = reverseKeywords[rgb];
	if (reversed) {
		return reversed;
	}

	let currentClosestDistance = Infinity;
	let currentClosestKeyword;

	for (const keyword of Object.keys(cssKeywords)) {
		const value = cssKeywords[keyword];

		// Compute comparative distance
		const distance = comparativeDistance(rgb, value);

		// Check if its less, if so set as closest
		if (distance < currentClosestDistance) {
			currentClosestDistance = distance;
			currentClosestKeyword = keyword;
		}
	}

	return currentClosestKeyword;
};

convert.keyword.rgb = function (keyword) {
	return cssKeywords[keyword];
};

convert.rgb.xyz = function (rgb) {
	let r = rgb[0] / 255;
	let g = rgb[1] / 255;
	let b = rgb[2] / 255;

	// Assume sRGB
	r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
	g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
	b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);

	const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
	const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
	const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

	return [x * 100, y * 100, z * 100];
};

convert.rgb.lab = function (rgb) {
	const xyz = convert.rgb.xyz(rgb);
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.hsl.rgb = function (hsl) {
	const h = hsl[0] / 360;
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;
	let t2;
	let t3;
	let val;

	if (s === 0) {
		val = l * 255;
		return [val, val, val];
	}

	if (l < 0.5) {
		t2 = l * (1 + s);
	} else {
		t2 = l + s - l * s;
	}

	const t1 = 2 * l - t2;

	const rgb = [0, 0, 0];
	for (let i = 0; i < 3; i++) {
		t3 = h + 1 / 3 * -(i - 1);
		if (t3 < 0) {
			t3++;
		}

		if (t3 > 1) {
			t3--;
		}

		if (6 * t3 < 1) {
			val = t1 + (t2 - t1) * 6 * t3;
		} else if (2 * t3 < 1) {
			val = t2;
		} else if (3 * t3 < 2) {
			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
		} else {
			val = t1;
		}

		rgb[i] = val * 255;
	}

	return rgb;
};

convert.hsl.hsv = function (hsl) {
	const h = hsl[0];
	let s = hsl[1] / 100;
	let l = hsl[2] / 100;
	let smin = s;
	const lmin = Math.max(l, 0.01);

	l *= 2;
	s *= (l <= 1) ? l : 2 - l;
	smin *= lmin <= 1 ? lmin : 2 - lmin;
	const v = (l + s) / 2;
	const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

	return [h, sv * 100, v * 100];
};

convert.hsv.rgb = function (hsv) {
	const h = hsv[0] / 60;
	const s = hsv[1] / 100;
	let v = hsv[2] / 100;
	const hi = Math.floor(h) % 6;

	const f = h - Math.floor(h);
	const p = 255 * v * (1 - s);
	const q = 255 * v * (1 - (s * f));
	const t = 255 * v * (1 - (s * (1 - f)));
	v *= 255;

	switch (hi) {
		case 0:
			return [v, t, p];
		case 1:
			return [q, v, p];
		case 2:
			return [p, v, t];
		case 3:
			return [p, q, v];
		case 4:
			return [t, p, v];
		case 5:
			return [v, p, q];
	}
};

convert.hsv.hsl = function (hsv) {
	const h = hsv[0];
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;
	const vmin = Math.max(v, 0.01);
	let sl;
	let l;

	l = (2 - s) * v;
	const lmin = (2 - s) * vmin;
	sl = s * vmin;
	sl /= (lmin <= 1) ? lmin : 2 - lmin;
	sl = sl || 0;
	l /= 2;

	return [h, sl * 100, l * 100];
};

// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
convert.hwb.rgb = function (hwb) {
	const h = hwb[0] / 360;
	let wh = hwb[1] / 100;
	let bl = hwb[2] / 100;
	const ratio = wh + bl;
	let f;

	// Wh + bl cant be > 1
	if (ratio > 1) {
		wh /= ratio;
		bl /= ratio;
	}

	const i = Math.floor(6 * h);
	const v = 1 - bl;
	f = 6 * h - i;

	if ((i & 0x01) !== 0) {
		f = 1 - f;
	}

	const n = wh + f * (v - wh); // Linear interpolation

	let r;
	let g;
	let b;
	/* eslint-disable max-statements-per-line,no-multi-spaces */
	switch (i) {
		default:
		case 6:
		case 0: r = v;  g = n;  b = wh; break;
		case 1: r = n;  g = v;  b = wh; break;
		case 2: r = wh; g = v;  b = n; break;
		case 3: r = wh; g = n;  b = v; break;
		case 4: r = n;  g = wh; b = v; break;
		case 5: r = v;  g = wh; b = n; break;
	}
	/* eslint-enable max-statements-per-line,no-multi-spaces */

	return [r * 255, g * 255, b * 255];
};

convert.cmyk.rgb = function (cmyk) {
	const c = cmyk[0] / 100;
	const m = cmyk[1] / 100;
	const y = cmyk[2] / 100;
	const k = cmyk[3] / 100;

	const r = 1 - Math.min(1, c * (1 - k) + k);
	const g = 1 - Math.min(1, m * (1 - k) + k);
	const b = 1 - Math.min(1, y * (1 - k) + k);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.rgb = function (xyz) {
	const x = xyz[0] / 100;
	const y = xyz[1] / 100;
	const z = xyz[2] / 100;
	let r;
	let g;
	let b;

	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

	// Assume sRGB
	r = r > 0.0031308
		? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
		: r * 12.92;

	g = g > 0.0031308
		? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
		: g * 12.92;

	b = b > 0.0031308
		? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
		: b * 12.92;

	r = Math.min(Math.max(0, r), 1);
	g = Math.min(Math.max(0, g), 1);
	b = Math.min(Math.max(0, b), 1);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.lab = function (xyz) {
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.lab.xyz = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let x;
	let y;
	let z;

	y = (l + 16) / 116;
	x = a / 500 + y;
	z = y - b / 200;

	const y2 = y ** 3;
	const x2 = x ** 3;
	const z2 = z ** 3;
	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

	x *= 95.047;
	y *= 100;
	z *= 108.883;

	return [x, y, z];
};

convert.lab.lch = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let h;

	const hr = Math.atan2(b, a);
	h = hr * 360 / 2 / Math.PI;

	if (h < 0) {
		h += 360;
	}

	const c = Math.sqrt(a * a + b * b);

	return [l, c, h];
};

convert.lch.lab = function (lch) {
	const l = lch[0];
	const c = lch[1];
	const h = lch[2];

	const hr = h / 360 * 2 * Math.PI;
	const a = c * Math.cos(hr);
	const b = c * Math.sin(hr);

	return [l, a, b];
};

convert.rgb.ansi16 = function (args, saturation = null) {
	const [r, g, b] = args;
	let value = saturation === null ? convert.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

	value = Math.round(value / 50);

	if (value === 0) {
		return 30;
	}

	let ansi = 30
		+ ((Math.round(b / 255) << 2)
		| (Math.round(g / 255) << 1)
		| Math.round(r / 255));

	if (value === 2) {
		ansi += 60;
	}

	return ansi;
};

convert.hsv.ansi16 = function (args) {
	// Optimization here; we already know the value and don't need to get
	// it converted for us.
	return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
};

convert.rgb.ansi256 = function (args) {
	const r = args[0];
	const g = args[1];
	const b = args[2];

	// We use the extended greyscale palette here, with the exception of
	// black and white. normal palette only has 4 greyscale shades.
	if (r === g && g === b) {
		if (r < 8) {
			return 16;
		}

		if (r > 248) {
			return 231;
		}

		return Math.round(((r - 8) / 247) * 24) + 232;
	}

	const ansi = 16
		+ (36 * Math.round(r / 255 * 5))
		+ (6 * Math.round(g / 255 * 5))
		+ Math.round(b / 255 * 5);

	return ansi;
};

convert.ansi16.rgb = function (args) {
	let color = args % 10;

	// Handle greyscale
	if (color === 0 || color === 7) {
		if (args > 50) {
			color += 3.5;
		}

		color = color / 10.5 * 255;

		return [color, color, color];
	}

	const mult = (~~(args > 50) + 1) * 0.5;
	const r = ((color & 1) * mult) * 255;
	const g = (((color >> 1) & 1) * mult) * 255;
	const b = (((color >> 2) & 1) * mult) * 255;

	return [r, g, b];
};

convert.ansi256.rgb = function (args) {
	// Handle greyscale
	if (args >= 232) {
		const c = (args - 232) * 10 + 8;
		return [c, c, c];
	}

	args -= 16;

	let rem;
	const r = Math.floor(args / 36) / 5 * 255;
	const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
	const b = (rem % 6) / 5 * 255;

	return [r, g, b];
};

convert.rgb.hex = function (args) {
	const integer = ((Math.round(args[0]) & 0xFF) << 16)
		+ ((Math.round(args[1]) & 0xFF) << 8)
		+ (Math.round(args[2]) & 0xFF);

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.hex.rgb = function (args) {
	const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
	if (!match) {
		return [0, 0, 0];
	}

	let colorString = match[0];

	if (match[0].length === 3) {
		colorString = colorString.split('').map(char => {
			return char + char;
		}).join('');
	}

	const integer = parseInt(colorString, 16);
	const r = (integer >> 16) & 0xFF;
	const g = (integer >> 8) & 0xFF;
	const b = integer & 0xFF;

	return [r, g, b];
};

convert.rgb.hcg = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const max = Math.max(Math.max(r, g), b);
	const min = Math.min(Math.min(r, g), b);
	const chroma = (max - min);
	let grayscale;
	let hue;

	if (chroma < 1) {
		grayscale = min / (1 - chroma);
	} else {
		grayscale = 0;
	}

	if (chroma <= 0) {
		hue = 0;
	} else
	if (max === r) {
		hue = ((g - b) / chroma) % 6;
	} else
	if (max === g) {
		hue = 2 + (b - r) / chroma;
	} else {
		hue = 4 + (r - g) / chroma;
	}

	hue /= 6;
	hue %= 1;

	return [hue * 360, chroma * 100, grayscale * 100];
};

convert.hsl.hcg = function (hsl) {
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;

	const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));

	let f = 0;
	if (c < 1.0) {
		f = (l - 0.5 * c) / (1.0 - c);
	}

	return [hsl[0], c * 100, f * 100];
};

convert.hsv.hcg = function (hsv) {
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;

	const c = s * v;
	let f = 0;

	if (c < 1.0) {
		f = (v - c) / (1 - c);
	}

	return [hsv[0], c * 100, f * 100];
};

convert.hcg.rgb = function (hcg) {
	const h = hcg[0] / 360;
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	if (c === 0.0) {
		return [g * 255, g * 255, g * 255];
	}

	const pure = [0, 0, 0];
	const hi = (h % 1) * 6;
	const v = hi % 1;
	const w = 1 - v;
	let mg = 0;

	/* eslint-disable max-statements-per-line */
	switch (Math.floor(hi)) {
		case 0:
			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
		case 1:
			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
		case 2:
			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
		case 3:
			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
		case 4:
			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
		default:
			pure[0] = 1; pure[1] = 0; pure[2] = w;
	}
	/* eslint-enable max-statements-per-line */

	mg = (1.0 - c) * g;

	return [
		(c * pure[0] + mg) * 255,
		(c * pure[1] + mg) * 255,
		(c * pure[2] + mg) * 255
	];
};

convert.hcg.hsv = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const v = c + g * (1.0 - c);
	let f = 0;

	if (v > 0.0) {
		f = c / v;
	}

	return [hcg[0], f * 100, v * 100];
};

convert.hcg.hsl = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const l = g * (1.0 - c) + 0.5 * c;
	let s = 0;

	if (l > 0.0 && l < 0.5) {
		s = c / (2 * l);
	} else
	if (l >= 0.5 && l < 1.0) {
		s = c / (2 * (1 - l));
	}

	return [hcg[0], s * 100, l * 100];
};

convert.hcg.hwb = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;
	const v = c + g * (1.0 - c);
	return [hcg[0], (v - c) * 100, (1 - v) * 100];
};

convert.hwb.hcg = function (hwb) {
	const w = hwb[1] / 100;
	const b = hwb[2] / 100;
	const v = 1 - b;
	const c = v - w;
	let g = 0;

	if (c < 1) {
		g = (v - c) / (1 - c);
	}

	return [hwb[0], c * 100, g * 100];
};

convert.apple.rgb = function (apple) {
	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
};

convert.rgb.apple = function (rgb) {
	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
};

convert.gray.rgb = function (args) {
	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
};

convert.gray.hsl = function (args) {
	return [0, 0, args[0]];
};

convert.gray.hsv = convert.gray.hsl;

convert.gray.hwb = function (gray) {
	return [0, 100, gray[0]];
};

convert.gray.cmyk = function (gray) {
	return [0, 0, 0, gray[0]];
};

convert.gray.lab = function (gray) {
	return [gray[0], 0, 0];
};

convert.gray.hex = function (gray) {
	const val = Math.round(gray[0] / 100 * 255) & 0xFF;
	const integer = (val << 16) + (val << 8) + val;

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.rgb.gray = function (rgb) {
	const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
	return [val / 255 * 100];
};


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/index.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/index.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const conversions = __webpack_require__(/*! ./conversions */ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/conversions.js");
const route = __webpack_require__(/*! ./route */ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/route.js");

const convert = {};

const models = Object.keys(conversions);

function wrapRaw(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];
		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		return fn(args);
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

function wrapRounded(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];

		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		const result = fn(args);

		// We're assuming the result is an array here.
		// see notice in conversions.js; don't use box types
		// in conversion functions.
		if (typeof result === 'object') {
			for (let len = result.length, i = 0; i < len; i++) {
				result[i] = Math.round(result[i]);
			}
		}

		return result;
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

models.forEach(fromModel => {
	convert[fromModel] = {};

	Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
	Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

	const routes = route(fromModel);
	const routeModels = Object.keys(routes);

	routeModels.forEach(toModel => {
		const fn = routes[toModel];

		convert[fromModel][toModel] = wrapRounded(fn);
		convert[fromModel][toModel].raw = wrapRaw(fn);
	});
});

module.exports = convert;


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/route.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/route.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const conversions = __webpack_require__(/*! ./conversions */ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-convert/conversions.js");

/*
	This function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/

function buildGraph() {
	const graph = {};
	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
	const models = Object.keys(conversions);

	for (let len = models.length, i = 0; i < len; i++) {
		graph[models[i]] = {
			// http://jsperf.com/1-vs-infinity
			// micro-opt, but this is simple.
			distance: -1,
			parent: null
		};
	}

	return graph;
}

// https://en.wikipedia.org/wiki/Breadth-first_search
function deriveBFS(fromModel) {
	const graph = buildGraph();
	const queue = [fromModel]; // Unshift -> queue -> pop

	graph[fromModel].distance = 0;

	while (queue.length) {
		const current = queue.pop();
		const adjacents = Object.keys(conversions[current]);

		for (let len = adjacents.length, i = 0; i < len; i++) {
			const adjacent = adjacents[i];
			const node = graph[adjacent];

			if (node.distance === -1) {
				node.distance = graph[current].distance + 1;
				node.parent = current;
				queue.unshift(adjacent);
			}
		}
	}

	return graph;
}

function link(from, to) {
	return function (args) {
		return to(from(args));
	};
}

function wrapConversion(toModel, graph) {
	const path = [graph[toModel].parent, toModel];
	let fn = conversions[graph[toModel].parent][toModel];

	let cur = graph[toModel].parent;
	while (graph[cur].parent) {
		path.unshift(graph[cur].parent);
		fn = link(conversions[graph[cur].parent][cur], fn);
		cur = graph[cur].parent;
	}

	fn.conversion = path;
	return fn;
}

module.exports = function (fromModel) {
	const graph = deriveBFS(fromModel);
	const conversion = {};

	const models = Object.keys(graph);
	for (let len = models.length, i = 0; i < len; i++) {
		const toModel = models[i];
		const node = graph[toModel];

		if (node.parent === null) {
			// No possible conversion, or this node is the source model.
			continue;
		}

		conversion[toModel] = wrapConversion(toModel, graph);
	}

	return conversion;
};



/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-name/index.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-ui/node_modules/color-name/index.js ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/accessibility.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/accessibility.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Accessibility)
/* harmony export */ });
/* harmony import */ var _textcache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./textcache */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/textcache.js");
/* harmony import */ var _serviceprovider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./serviceprovider */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/serviceprovider.js");
/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./mathml */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js");
/* harmony import */ var _stringmanager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringmanager */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/stringmanager.js");





/**
 * @classdesc
 * This class represents MathType accessible class. Converts MathML to accessible text and manages
 * the associated client-side cache.
 */
class Accessibility {
  /**
   * Static property.
   * Accessibility cache, each entry contains a MathML and its correspondent accessibility text.
   * @type {TextCache}
   */
  static get cache() {
    return Accessibility._cache;
  }

  /**
   * Static property setter.
   * Set accessibility cache.
   * @param {TextCahe} value - The property value.
   * @ignore
   */
  static set cache(value) {
    Accessibility._cache = value;
  }

  /**
   * Converts MathML strings to its accessible text representation.
   * @param {String} mathML - MathML to be converted to accessible text.
   * @param {String} [language] - Language of the accessible text. 'en' by default.
   * @param {Array.<String>} [data] - Parameters to send to mathml2accessible service.
   * @return {String} Accessibility text.
   */
  static mathMLToAccessible(mathML, language, data) {
    if (typeof language === "undefined") {
      language = "en";
    }
    // Check MathML class. If the class is chemistry,
    // we add chemistry to data to force accessibility service
    // to load chemistry grammar.
    if (_mathml__WEBPACK_IMPORTED_MODULE_2__["default"].containClass(mathML, "wrs_chemistry")) {
      data.mode = "chemistry";
    }
    // Ignore accesibility styles
    data.ignoreStyles = true;
    let accessibleText = "";

    if (Accessibility.cache.get(mathML)) {
      accessibleText = Accessibility.cache.get(mathML);
    } else {
      data.service = "mathml2accessible";
      data.lang = language;
      const accessibleJsonResponse = JSON.parse(_serviceprovider__WEBPACK_IMPORTED_MODULE_1__["default"].getService("service", data));
      if (accessibleJsonResponse.status !== "error") {
        accessibleText = accessibleJsonResponse.result.text;
        Accessibility.cache.populate(mathML, accessibleText);
      } else {
        accessibleText = _stringmanager__WEBPACK_IMPORTED_MODULE_3__["default"].get("error_convert_accessibility");
      }
    }

    return accessibleText;
  }
}

/**
 * Contains an instance of TextCache class to manage the JavaScript accessible cache.
 * Each entry of the cache object contains the MathML and it's correspondent accessibility text.
 * @private
 * @type {TextCache}
 */
Accessibility._cache = new _textcache__WEBPACK_IMPORTED_MODULE_0__["default"]();


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Configuration)
/* harmony export */ });
/**
 * This class represents the configuration class.
 * Usually used to retrieve configuration properties generated in the backend into the frontend.
 */
class Configuration {
  /**
   * Adds a properties object to {@link Configuration.properties}.
   * @param {Object} properties - properties to append to current properties.
   */
  static addConfiguration(properties) {
    Object.assign(Configuration.properties, properties);
  }

  /**
   * Static property.
   * The configuration properties object.
   * @private
   * @type {Object}
   */
  static get properties() {
    return Configuration._properties;
  }

  /**
   * Static property setter.
   * Set configuration properties.
   * @param {Object} value - The property value.
   * @ignore
   */
  static set properties(value) {
    Configuration._properties = value;
  }

  /**
   * Returns the value of a property key.
   * @param {String} key - Property key
   * @returns {String} Property value
   */
  static get(key) {
    if (!Object.prototype.hasOwnProperty.call(Configuration.properties, key)) {
      // Backwards compatibility.
      if (Object.prototype.hasOwnProperty.call(Configuration.properties, "_wrs_conf_")) {
        return Configuration.properties[`_wrs_conf_${key}`];
      }
      return false;
    }
    return Configuration.properties[key];
  }

  /**
   * Adds a new property to Configuration class.
   * @param {String} key - Property key.
   * @param {Object} value - Property value.
   */
  static set(key, value) {
    Configuration.properties[key] = value;
  }

  /**
   * Updates a property object value with new values.
   * @param {String} key - The property key to be updated.
   * @param {Object} propertyValue - Object containing the new values.
   */
  static update(key, propertyValue) {
    if (!Configuration.get(key)) {
      Configuration.set(key, propertyValue);
    } else {
      const updateProperty = Object.assign(Configuration.get(key), propertyValue);
      Configuration.set(key, updateProperty);
    }
  }
}

/**
 * Static properties object. Stores all configuration properties.
 * Needed to attribute accessors.
 * @private
 * @type {Object}
 */
Configuration._properties = {};


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/constants.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/constants.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Constants)
/* harmony export */ });
/**
 * This class represents all the constants needed in a MathType integration among different classes.
 * If a constant should be used across different classes should be defined using attribute
 * accessors.
 */
class Constants {
  /**
   * Safe XML entities.
   * @type {Object}
   */
  static get safeXmlCharactersEntities() {
    return {
      tagOpener: "&laquo;",
      tagCloser: "&raquo;",
      doubleQuote: "&uml;",
      realDoubleQuote: "&quot;",
    };
  }

  /**
   * Blackboard invalid safe characters.
   * @type {Object}
   */
  static get safeBadBlackboardCharacters() {
    return {
      ltElement: "«mo»<«/mo»",
      gtElement: "«mo»>«/mo»",
      ampElement: "«mo»&«/mo»",
    };
  }

  /**
   * Blackboard valid safe characters.
   * @type{Object}
   */
  static get safeGoodBlackboardCharacters() {
    return {
      ltElement: "«mo»§lt;«/mo»",
      gtElement: "«mo»§gt;«/mo»",
      ampElement: "«mo»§amp;«/mo»",
    };
  }

  /**
   * Standard XML special characters.
   * @type {Object}
   */
  static get xmlCharacters() {
    return {
      id: "xmlCharacters",
      tagOpener: "<", // Hex: \x3C.
      tagCloser: ">", // Hex: \x3E.
      doubleQuote: '"', // Hex: \x22.
      ampersand: "&", // Hex: \x26.
      quote: "'", // Hex: \x27.
    };
  }

  /**
   * Safe XML special characters. This characters are used instead the standard
   * the standard to parse the  MathML if safeXML save mode is enable. Each XML
   * special character have a UTF-8 representation.
   * @type {Object}
   */
  static get safeXmlCharacters() {
    return {
      id: "safeXmlCharacters",
      tagOpener: "«", // Hex: \xAB.
      tagCloser: "»", // Hex: \xBB.
      doubleQuote: "¨", // Hex: \xA8.
      ampersand: "§", // Hex: \xA7.
      quote: "`", // Hex: \x60.
      realDoubleQuote: "¨",
    };
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/contentmanager.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/contentmanager.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContentManager)
/* harmony export */ });
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _core_src__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core.src */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/core.src.js");
/* harmony import */ var _editorlistener__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./editorlistener */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/editorlistener.js");
/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./listeners */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js");
/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./mathml */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");
/* harmony import */ var _telemeter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./telemeter */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/telemeter.js");








class ContentManager {
  /**
   * @classdesc
   * This class represents a modal dialog, managing the following:
   * - The insertion of content into the current instance of the {@link ModalDialog} class.
   * - The actions to be done once the modal object has been submitted
   *   (submitAction} method).
   * - The update of the content when the {@link ModalDialog} class is also updated,
   *   for example when ModalDialog is re-opened.
   * - The communication between the {@link ModalDialog} class and itself, if the content
   *   has been changed (hasChanges} method).
   * @constructs
   * @param {Object} contentManagerAttributes - Object containing all attributes needed to
   * create a new instance.
   */
  constructor(contentManagerAttributes) {
    /**
     * An object containing MathType editor parameters. See
     * http://docs.wiris.com/en/mathtype/mathtype_web/sdk-api/parameters for further information.
     * @type {Object}
     */
    this.editorAttributes = {};
    if ("editorAttributes" in contentManagerAttributes) {
      this.editorAttributes = contentManagerAttributes.editorAttributes;
    } else {
      throw new Error("ContentManager constructor error: editorAttributes property missed.");
    }

    /**
     * CustomEditors instance. Contains the custom editors.
     * @type {CustomEditors}
     */
    this.customEditors = null;
    if ("customEditors" in contentManagerAttributes) {
      this.customEditors = contentManagerAttributes.customEditors;
    }

    /**
     * Environment properties. This object contains data about the integration platform.
     * @type {Object}
     * @property {String} editor - Editor name. Usually the HTML editor.
     * @property {String} mode - Save mode. Xml by default.
     * @property {String} version - Plugin version.
     */
    this.environment = {};
    if ("environment" in contentManagerAttributes) {
      this.environment = contentManagerAttributes.environment;
    } else {
      throw new Error("ContentManager constructor error: environment property missed");
    }

    /**
     * ContentManager language.
     * @type {String}
     */
    this.language = "";
    if ("language" in contentManagerAttributes) {
      this.language = contentManagerAttributes.language;
    } else {
      throw new Error("ContentManager constructor error: language property missed");
    }

    /**
     * {@link EditorListener} instance. Manages the changes inside the editor.
     * @type {EditorListener}
     */
    this.editorListener = new _editorlistener__WEBPACK_IMPORTED_MODULE_2__["default"]();

    /**
     * MathType editor instance.
     * @type {JsEditor}
     */
    this.editor = null;

    /**
     * Navigator user agent.
     * @type {String}
     */
    this.ua = navigator.userAgent.toLowerCase();

    /**
     * Mobile device properties object
     * @type {DeviceProperties}
     */
    this.deviceProperties = {};
    this.deviceProperties.isAndroid = this.ua.indexOf("android") > -1;
    this.deviceProperties.isIOS = ContentManager.isIOS();

    /**
     * Custom editor toolbar.
     * @type {String}
     */
    this.toolbar = null;

    /**
     * Custom editor toolbar.
     * @type {String}
     */
    this.dbclick = null;

    /**
     * Instance of the {@link ModalDialog} class associated with the current
     * {@link ContentManager} instance.
     * @type {ModalDialog}
     */
    this.modalDialogInstance = null;

    /**
     * ContentManager listeners.
     * @type {Listeners}
     */
    this.listeners = new _listeners__WEBPACK_IMPORTED_MODULE_3__["default"]();

    /**
     * MathML associated to the ContentManager instance.
     * @type {String}
     */
    this.mathML = null;

    /**
     * Indicates if the edited element is a new one or not.
     * @type {Boolean}
     */
    this.isNewElement = true;

    /**
     * {@link IntegrationModel} instance. Needed to call wrapper methods.
     * @type {IntegrationModel}
     */
    this.integrationModel = null;
  }

  /**
   * Adds a new listener to the current {@link ContentManager} instance.
   * @param {Object} listener - The listener to be added.
   */
  addListener(listener) {
    this.listeners.add(listener);
  }

  /**
   * Sets an instance of {@link IntegrationModel} class to the current {@link ContentManager}
   * instance.
   * @param {IntegrationModel} integrationModel - The {@link IntegrationModel} instance.
   */
  setIntegrationModel(integrationModel) {
    this.integrationModel = integrationModel;
  }

  /**
   * Sets the {@link ModalDialog} instance into the current {@link ContentManager} instance.
   * @param {ModalDialog} modalDialogInstance - The {@link ModalDialog} instance
   */
  setModalDialogInstance(modalDialogInstance) {
    this.modalDialogInstance = modalDialogInstance;
  }

  /**
   * Inserts the content into the current {@link ModalDialog} instance updating
   * the title and inserting the JavaScript editor.
   */
  insert() {
    // Before insert the editor we update the modal object title to avoid weird render display.
    this.updateTitle(this.modalDialogInstance);
    this.insertEditor(this.modalDialogInstance);
  }

  /**
   * Inserts MathType editor into the {@link ModalDialog.contentContainer}. It waits until
   * editor's JavaScript is loaded.
   */
  insertEditor() {
    if (ContentManager.isEditorLoaded()) {
      this.editor = window.com.wiris.jsEditor.JsEditor.newInstance(this.editorAttributes);
      this.editor.insertInto(this.modalDialogInstance.contentContainer);
      this.editor.focus();
      if (this.modalDialogInstance.rtl) {
        this.editor.action("rtl");
      }
      // Setting div in rtl in case of it's activated.
      if (this.editor.getEditorModel().isRTL()) {
        this.editor.element.style.direction = "rtl";
      }

      // Editor listener: this object manages the changes logic of editor.
      this.editor.getEditorModel().addEditorListener(this.editorListener);

      // iOS events.
      if (this.modalDialogInstance.deviceProperties.isIOS) {
        setTimeout(function () {
          // Make sure the modalDialogInstance is available when the timeout is over
          // to avoid throw errors and stop execution.
          if (this.hasOwnProperty("modalDialogInstance")) this.modalDialogInstance.hideKeyboard(); // eslint-disable-line no-prototype-builtins
        }, 400);

        const formulaDisplayDiv = document.getElementsByClassName("wrs_formulaDisplay")[0];
        _util__WEBPACK_IMPORTED_MODULE_5__["default"].addEvent(formulaDisplayDiv, "focus", this.modalDialogInstance.handleOpenedIosSoftkeyboard);
        _util__WEBPACK_IMPORTED_MODULE_5__["default"].addEvent(formulaDisplayDiv, "blur", this.modalDialogInstance.handleClosedIosSoftkeyboard);
      }
      // Fire onLoad event. Necessary to set the MathML into the editor
      // after is loaded.
      this.listeners.fire("onLoad", {});
    } else {
      setTimeout(ContentManager.prototype.insertEditor.bind(this), 100);
    }
  }

  /**
   * Initializes the current class by loading MathType script.
   */
  init() {
    if (!ContentManager.isEditorLoaded()) {
      this.addEditorAsExternalDependency();
    }
  }

  /**
   * Adds script element to the DOM to include editor externally.
   */
  addEditorAsExternalDependency() {
    const script = document.createElement("script");
    script.type = "text/javascript";
    let editorUrl = _configuration__WEBPACK_IMPORTED_MODULE_0__["default"].get("editorUrl");

    // We create an object url for parse url string and work more efficiently.
    const anchorElement = document.createElement("a");

    ContentManager.setHrefToAnchorElement(anchorElement, editorUrl);
    ContentManager.setProtocolToAnchorElement(anchorElement);

    editorUrl = ContentManager.getURLFromAnchorElement(anchorElement);

    // Load editor URL. We add stats as GET params.
    const stats = this.getEditorStats();
    script.src = `${editorUrl}?lang=${this.language}&stats-editor=${stats.editor}&stats-mode=${stats.mode}&stats-version=${stats.version}`;

    document.getElementsByTagName("head")[0].appendChild(script);
  }

  /**
   * Sets the specified url to the anchor element.
   * @param {HTMLAnchorElement} anchorElement - Element where set 'url'.
   * @param {String} url - URL to set.
   */
  static setHrefToAnchorElement(anchorElement, url) {
    anchorElement.href = url;
  }

  /**
   * Sets the current protocol to the anchor element.
   * @param {HTMLAnchorElement} anchorElement - Element where set its protocol.
   */
  static setProtocolToAnchorElement(anchorElement) {
    // Change to https if necessary.
    if (window.location.href.indexOf("https://") === 0) {
      // It check if browser is https and configuration is http.
      // If this is so, we will replace protocol.
      if (anchorElement.protocol === "http:") {
        anchorElement.protocol = "https:";
      }
    }
  }

  /**
   * Returns the url of the anchor element adding the current port
   * if it is needed.
   * @param {HTMLAnchorElement} anchorElement - Element where extract the url.
   * @returns {String}
   */
  static getURLFromAnchorElement(anchorElement) {
    // Check protocol and remove port if it's standard.
    const removePort = anchorElement.port === "80" || anchorElement.port === "443" || anchorElement.port === "";
    return `${anchorElement.protocol}//${anchorElement.hostname}${removePort ? "" : `:${anchorElement.port}`}${anchorElement.pathname.startsWith("/") ? anchorElement.pathname : `/${anchorElement.pathname}`}`; // eslint-disable-line max-len
  }

  /**
   * Returns object with editor stats.
   *
   * @typedef {Object} EditorStatsObject
   * @property {string} editor - Editor name.
   * @property {string} mode - Current configuration for formula save mode.
   * @property {string} version - Current plugins version.
   * @returns {EditorStatsObject}
   */
  getEditorStats() {
    // Editor stats. Use environment property to set it.
    const stats = {};
    if ("editor" in this.environment) {
      stats.editor = this.environment.editor;
    } else {
      stats.editor = "unknown";
    }

    if ("mode" in this.environment) {
      stats.mode = this.environment.mode;
    } else {
      stats.mode = _configuration__WEBPACK_IMPORTED_MODULE_0__["default"].get("saveMode");
    }

    if ("version" in this.environment) {
      stats.version = this.environment.version;
    } else {
      stats.version = _configuration__WEBPACK_IMPORTED_MODULE_0__["default"].get("version");
    }

    return stats;
  }

  /**
   * Returns true if device is iOS. Otherwise, false.
   * @returns {Boolean}
   */
  static isIOS() {
    return (
      ["iPad Simulator", "iPhone Simulator", "iPod Simulator", "iPad", "iPhone", "iPod"].includes(navigator.platform) ||
      // iPad on iOS 13 detection
      (navigator.userAgent.includes("Mac") && "ontouchend" in document)
    );
  }

  /**
   * Returns true if device is Mobile. Otherwise, false.
   * @returns {Boolean}
   */
  static isMobile() {
    return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
  }

  /**
   * Returns true if editor is loaded. Otherwise, false.
   * @returns {Boolean}
   */
  static isEditorLoaded() {
    // To know if editor JavaScript is loaded we need to wait until
    // window.com.wiris.jsEditor.JsEditor.newInstance is ready.
    return (
      window.com &&
      window.com.wiris &&
      window.com.wiris.jsEditor &&
      window.com.wiris.jsEditor.JsEditor &&
      window.com.wiris.jsEditor.JsEditor.newInstance
    );
  }

  /**
   * Sets the {@link ContentManager.editor} initial content.
   */
  setInitialContent() {
    if (!this.isNewElement) {
      this.setMathML(this.mathML);
    }
  }

  /**
   * Sets a MathML into {@link ContentManager.editor} instance.
   * @param {String} mathml - MathML string.
   * @param {Boolean} focusDisabled - If true editor don't get focus after the MathML is set.
   * False by default.
   */
  setMathML(mathml, focusDisabled) {
    // By default focus is enabled.
    if (typeof focusDisabled === "undefined") {
      focusDisabled = false;
    }
    // Using setMathML method is not a change produced by the user but for the API
    // so we set to false the contentChange property of editorListener.
    this.editor.setMathMLWithCallback(mathml, () => {
      this.editorListener.setWaitingForChanges(true);
    });

    // We need to wait a little until the callback finish.
    setTimeout(() => {
      this.editorListener.setIsContentChanged(false);
    }, 500);

    // In some scenarios - like closing modal object - editor mustn't be focused.
    if (!focusDisabled) {
      this.onFocus();
    }
  }

  /**
   * Sets the focus to the current instance of {@link ContentManager.editor}. Triggered by
   * {@link ModalDialog.focus}.
   */
  onFocus() {
    if (typeof this.editor !== "undefined" && this.editor != null) {
      this.editor.focus();

      // On WordPress integration, the focus gets lost right after setting it.
      // To fix this, we enforce another focus some milliseconds after this behaviour.
      setTimeout(() => {
        this.editor.focus();
      }, 100);
    }
  }

  /**
   * Updates the edition area by calling {@link IntegrationModel.updateFormula}.
   * Triggered by {@link ModalDialog.submitAction}.
   */
  submitAction() {
    if (!this.editor.isFormulaEmpty()) {
      let mathML = this.editor.getMathMLWithSemantics();
      // Add class for custom editors.
      if (this.customEditors.getActiveEditor() !== null) {
        const { toolbar } = this.customEditors.getActiveEditor();
        mathML = _mathml__WEBPACK_IMPORTED_MODULE_4__["default"].addCustomEditorClassAttribute(mathML, toolbar);
      } else {
        // We need - if exists - the editor name from MathML
        // class attribute.
        Object.keys(this.customEditors.editors).forEach((key) => {
          mathML = _mathml__WEBPACK_IMPORTED_MODULE_4__["default"].removeCustomEditorClassAttribute(mathML, key);
        });
      }
      const mathmlEntitiesEncoded = _mathml__WEBPACK_IMPORTED_MODULE_4__["default"].mathMLEntities(mathML);
      this.integrationModel.updateFormula(mathmlEntitiesEncoded);
    } else {
      this.integrationModel.updateFormula(null);
    }

    this.customEditors.disable();
    this.integrationModel.notifyWindowClosed();

    // Set disabled focus to prevent lost focus.
    this.setEmptyMathML();
    this.customEditors.disable();
  }

  /**
   * Sets an empty MathML as {@link ContentManager.editor} content.
   * This will open the MT/CT editor with the hand mode.
   * It adds dir rtl in case of it's activated.
   */
  setEmptyMathML() {
    const isMobile = this.deviceProperties.isAndroid || this.deviceProperties.isIOS;
    const isRTL = this.editor.getEditorModel().isRTL();

    if (isMobile || this.integrationModel.forcedHandMode) {
      // For mobile devices or forced hand mode, set an empty annotation MATHML to maintain the editor in Hand mode.
      const mathML = `<math${isRTL ? ' dir="rtl"' : ""}><semantics><annotation encoding="application/json">[]</annotation></semantics></math>`;
      this.setMathML(mathML, true);
    } else {
      // For non-mobile devices or not forced hand mode, set the empty MathML without an annotation.
      const mathML = `<math${isRTL ? ' dir="rtl"' : ""}/>`;
      this.setMathML(mathML, true);
    }
  }

  /**
   * Open event. Triggered by {@link ModalDialog.open}. Does the following:
   * - Updates the {@link ContentManager.editor} content
   *   (with an empty MathML or an existing formula),
   * - Updates the {@link ContentManager.editor} toolbar.
   * - Recovers the the focus.
   */
  onOpen() {
    if (this.isNewElement) {
      this.setEmptyMathML();
    } else {
      this.setMathML(this.mathML);
    }
    let toolbar = this.updateToolbar();
    this.onFocus();

    if (this.deviceProperties.isIOS) {
      const zoom = document.documentElement.clientWidth / window.innerWidth;

      if (zoom !== 1) {
        // Open editor in Keyboard mode if user use iOS, Safari and page is zoomed.
        this.setKeyboardMode();
      }
    }

    let trigger = this.dbclick ? "formula" : "button";

    // Call Telemetry service to track the event.
    try {
      _telemeter__WEBPACK_IMPORTED_MODULE_6__["default"].telemeter.track("OPENED_MTCT_EDITOR", {
        toolbar: toolbar,
        trigger: trigger,
      });
    } catch (error) {
      console.error("Error tracking OPENED_MTCT_EDITOR", error);
    }

    _core_src__WEBPACK_IMPORTED_MODULE_1__["default"].globalListeners.fire("onModalOpen", {});

    if (this.integrationModel.forcedHandMode) {
      this.hideHandModeButton();

      // In case we have a keyboard written formula, we still want it to be opened with handMode.
      if (this.mathML && !this.mathML.includes('<annotation encoding="application/json">') && !this.isNewElement) {
        this.openHandOnKeyboardMathML(this.mathML, this.editor);
      }
    }
  }

  /**
   * Change Editor in keyboard mode when is loaded
   */
  setKeyboardMode() {
    const wrsEditor = document.getElementsByClassName("wrs_handOpen wrs_disablePalette")[0];
    if (wrsEditor) {
      wrsEditor.classList.remove("wrs_handOpen");
      wrsEditor.classList.remove("wrs_disablePalette");
    } else {
      setTimeout(ContentManager.prototype.setKeyboardMode.bind(this), 100);
    }
  }

  /**
   * Hides the hand <-> keyboard mode switch.
   *
   * This method relies completely on the classes used on different HTML elements within the editor itself, meaning
   * any change on those classes will make this code stop working properly.
   *
   * On top of that, some of those classes are changed on runtime (for example, the one that makes some buttons change).
   * This forces us to use some delayed code (this is, a timeout) to make sure everything exists when we need it.
   * @param {*} forced (boolean) Forces the user to stay in Hand mode by hiding the keyboard mode button.
   */
  hideHandModeButton(forced = true) {
    if (this.handSwitchHidden) {
      return; // hand <-> keyboard button already hidden.
    }

    // "Open hand mode" button takes a little bit to be available.
    // This selector gets the hand <-> keyboard mode switch
    const handModeButtonSelector =
      "div.wrs_editor.wrs_flexEditor.wrs_withHand.wrs_animated .wrs_handWrapper input[type=button]";

    // If in "forced mode", we hide the "keyboard button" so the user can't can't change between hand and keyboard modes.
    // We use an observer to ensure that the button it hidden as soon as it appears.
    if (forced) {
      const mutationInstance = new MutationObserver((mutations) => {
        const handModeButton = document.querySelector(handModeButtonSelector);
        if (handModeButton) {
          handModeButton.hidden = true;
          this.handSwitchHidden = true;
          mutationInstance.disconnect();
        }
      });
      mutationInstance.observe(document.body, {
        attributes: true,
        childList: true,
        characterData: true,
        subtree: true,
      });
    }
  }

  /**
   * It will open any formula written in Keyboard mode with the hand mode with the default hand trace.
   *
   * @param {String} mathml The original KeyBoard MathML
   * @param {Object} editor The editor object.
   */
  async openHandOnKeyboardMathML(mathml, editor) {
    // First, as an editor requirement, we need to update the editor object with the current MathML formula.
    // Once the MathML formula is updated to the one we want to open with handMode, we will be able to proceed.
    await new Promise((resolve) => {
      editor.setMathMLWithCallback(mathml, resolve);
    });

    // We wait until the hand editor object exists.
    await this.waitForHand(editor);

    // Logic to get the hand traces and open the formula in hand mode.
    // This logic comes from the editor.
    const handEditor = editor.hand;
    editor.handTemporalMathML = editor.getMathML();
    const handCoordinates = editor.editorModel.getHandStrokes();
    handEditor.setStrokes(handCoordinates);
    handEditor.fitStrokes(true);
    editor.openHand();
  }

  /**
   * Waits until the hand editor object exists.
   * @param {Obect} editor The editor object.
   */
  async waitForHand(editor) {
    while (!editor.hand) {
      await new Promise((resolve) => setTimeout(resolve, 100));
    }
  }

  /**
   * Sets the correct toolbar depending if exist other custom toolbars
   * at the same time (e.g: Chemistry).
   */
  updateToolbar() {
    this.updateTitle(this.modalDialogInstance);
    const customEditor = this.customEditors.getActiveEditor();

    let toolbar;
    if (customEditor) {
      toolbar = customEditor.toolbar ? customEditor.toolbar : _wrs_int_wirisProperties.toolbar;

      if (this.toolbar == null || this.toolbar !== toolbar) {
        this.setToolbar(toolbar);
      }
    } else {
      toolbar = this.getToolbar();
      if (this.toolbar == null || this.toolbar !== toolbar) {
        this.setToolbar(toolbar);
        this.customEditors.disable();
      }
    }

    return toolbar;
  }

  /**
   * Updates the current {@link ModalDialog.title}. If a {@link CustomEditors} is enabled
   * sets the custom editor title. Otherwise sets the default title.
   */
  updateTitle() {
    const customEditor = this.customEditors.getActiveEditor();
    if (customEditor) {
      this.modalDialogInstance.setTitle(customEditor.title);
    } else {
      this.modalDialogInstance.setTitle("MathType");
    }
  }

  /**
   * Returns the editor toolbar, depending on the configuration local or server side.
   * @returns {String} - Toolbar identifier.
   */
  getToolbar() {
    let toolbar = "general";
    if ("toolbar" in this.editorAttributes) {
      ({ toolbar } = this.editorAttributes);
    }
    // TODO: Change global integration variable for integration custom toolbar.
    if (toolbar === "general") {
      // eslint-disable-next-line camelcase
      toolbar =
        typeof _wrs_int_wirisProperties === "undefined" || typeof _wrs_int_wirisProperties.toolbar === "undefined"
          ? "general"
          : _wrs_int_wirisProperties.toolbar;
    }

    return toolbar;
  }

  /**
   * Sets the current {@link ContentManager.editor} instance toolbar.
   * @param {String} toolbar - The toolbar name.
   */
  setToolbar(toolbar) {
    this.toolbar = toolbar;
    this.editor.setParams({ toolbar: this.toolbar });
  }

  /**
   * Sets the custom headers added on editor requests.
   * @returns {Object} headers - key value headers.
   */
  setCustomHeaders(headers) {
    let headersObj = {};

    // We control that we only get String or Object as the input.
    if (typeof headers === "object") {
      headersObj = headers;
    } else if (typeof headers === "string") {
      headersObj = _util__WEBPACK_IMPORTED_MODULE_5__["default"].convertStringToObject(headers);
    }

    this.editor.setParams({ customHeaders: headersObj });
    return headersObj;
  }

  /**
   * Returns true if the content of the editor has been changed. The logic of the changes
   * is delegated to {@link EditorListener} class.
   * @returns {Boolean} True if the editor content has been changed. False otherwise.
   */
  hasChanges() {
    return !this.editor.isFormulaEmpty() && this.editorListener.getIsContentChanged();
  }

  /**
   * Handle keyboard events detected in modal when elements of this class intervene.
   * @param {KeyboardEvent} keyboardEvent - The keyboard event.
   */
  onKeyDown(keyboardEvent) {
    if (keyboardEvent.key !== undefined && keyboardEvent.repeat === false) {
      if (keyboardEvent.key === "Escape" || keyboardEvent.key === "Esc") {
        // Code to detect Esc event.
        // There should be only one element with class name 'wrs_pressed' at the same time.
        let list = document.getElementsByClassName("wrs_expandButton wrs_expandButtonFor3RowsLayout wrs_pressed");
        if (list.length === 0) {
          list = document.getElementsByClassName("wrs_expandButton wrs_expandButtonFor2RowsLayout wrs_pressed");
          if (list.length === 0) {
            list = document.getElementsByClassName("wrs_select wrs_pressed");
            if (list.length === 0) {
              this.modalDialogInstance.cancelAction();
              keyboardEvent.stopPropagation();
              keyboardEvent.preventDefault();
            }
          }
        }
      } else if (keyboardEvent.shiftKey && keyboardEvent.key === "Tab") {
        // Code to detect shift Tab event.
        if (document.activeElement === this.modalDialogInstance.submitButton) {
          // Focus is on OK button.
          this.editor.focus();
          keyboardEvent.stopPropagation();
          keyboardEvent.preventDefault();
        } else if (document.querySelector('[title="Manual"]') === document.activeElement) {
          // Focus is on minimize button (_).
          this.modalDialogInstance.closeDiv.focus();
          keyboardEvent.stopPropagation();
          keyboardEvent.preventDefault();
        } else {
          if (document.activeElement === this.modalDialogInstance.minimizeDiv) {
            // Focus on cancel button.
            if (!(this.modalDialogInstance.properties.state === "minimized")) {
              this.modalDialogInstance.cancelButton.focus();
              keyboardEvent.stopPropagation();
              keyboardEvent.preventDefault();
            }
          }
        }
      } else if (keyboardEvent.key === "Tab") {
        // Code to detect Tab event.
        if (document.activeElement === this.modalDialogInstance.cancelButton) {
          // Focus is on X button.
          this.modalDialogInstance.minimizeDiv.focus();
          keyboardEvent.stopPropagation();
          keyboardEvent.preventDefault();
        } else if (document.activeElement === this.modalDialogInstance.closeDiv) {
          // Focus on help button.
          if (!(this.modalDialogInstance.properties.state === "minimized")) {
            const element = document.querySelector('[title="Manual"]');
            element.focus();
            keyboardEvent.stopPropagation();
            keyboardEvent.preventDefault();
          }
        } else {
          // There should be only one element with class name 'wrs_formulaDisplay'.
          const element = document.getElementsByClassName("wrs_formulaDisplay")[0];
          if (element.getAttribute("class") === "wrs_formulaDisplay wrs_focused") {
            // Focus is on formuladisplay.
            this.modalDialogInstance.submitButton.focus();
            keyboardEvent.stopPropagation();
            keyboardEvent.preventDefault();
          }
        }
      }
    }
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/core.src.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/core.src.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Core)
/* harmony export */ });
/* harmony import */ var _parser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parser */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/parser.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");
/* harmony import */ var _stringmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./stringmanager */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/stringmanager.js");
/* harmony import */ var _contentmanager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./contentmanager */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/contentmanager.js");
/* harmony import */ var _latex__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./latex */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/latex.js");
/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./mathml */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js");
/* harmony import */ var _customeditors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./customeditors */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/customeditors.js");
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _jsvariables__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./jsvariables */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/jsvariables.js");
/* harmony import */ var _event__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./event */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/event.js");
/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./listeners */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js");
/* harmony import */ var _image__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./image */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/image.js");
/* harmony import */ var _serviceprovider__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./serviceprovider */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/serviceprovider.js");
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./modal */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/modal.js");
/* harmony import */ var _telemeter__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./telemeter */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/telemeter.js");
/* harmony import */ var _polyfills__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./polyfills */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/polyfills.js");
/* harmony import */ var _styles_styles_css__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../styles/styles.css */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/styles.css");


















/**
 * @typedef {Object} CoreProperties
 * @property {ServiceProviderProperties} serviceProviderProperties
 * - The ServiceProvider class properties. *
 */
class Core {
  /**
   * @classdesc
   * This class represents MathType integration Core, managing the following:
   * - Integration initialization.
   * - Event managing.
   * - Insertion of formulas into the edit area.
   * ```js
   *       let core = new Core();
   *       core.addListener(listener);
   *       core.language = 'en';
   *
   *       // Initializing Core class.
   *       core.init(configurationService);
   * ```
   * @constructs
   * Core constructor.
   * @param {CoreProperties}
   */
  constructor(coreProperties) {
    /**
     * Language. Needed for accessibility and locales. 'en' by default.
     * @type {String}
     */
    this.language = "en";

    /**
     * Edit mode, 'images' by default. Admits the following values:
     * - images
     * - latex
     * @type {String}
     */
    this.editMode = "images";

    /**
     * Modal dialog instance.
     * @type {ModalDialog}
     */
    this.modalDialog = null;

    /**
     * The instance of {@link CustomEditors}. By default
     * the only custom editor is the Chemistry editor.
     * @type {CustomEditors}
     */
    this.customEditors = new _customeditors__WEBPACK_IMPORTED_MODULE_6__["default"]();

    /**
     * Chemistry editor.
     * @type {CustomEditor}
     */
    const chemEditorParams = {
      name: "Chemistry",
      toolbar: "chemistry",
      icon: "chem.png",
      confVariable: "chemEnabled",
      title: "ChemType",
      tooltip: "Insert a chemistry formula - ChemType", // TODO: Localize tooltip.
    };

    this.customEditors.addEditor("chemistry", chemEditorParams);

    /**
     * Environment properties. This object contains data about the integration platform.
     * @typedef IntegrationEnvironment
     * @property {String} IntegrationEnvironment.editor - Editor name. For example the HTML editor.
     * @property {String} IntegrationEnvironment.mode - Integration save mode.
     * @property {String} IntegrationEnvironment.version - Integration version.
     *
     */

    /**
     * The environment properties object.
     * @type {IntegrationEnvironment}
     */
    this.environment = {};

    /**
     * @typedef EditionProperties
     * @property {Boolean} editionProperties.isNewElement - True if the formula is a new one.
     * False otherwise.
     * @property {HTMLImageElement} editionProperties.temporalImage- The image element.
     * Null if the formula is new.
     * @property {Range} editionProperties.latexRange - Tha range that contains the LaTeX formula.
     * @property {Range} editionProperties.range - The range that contains the image element.
     * @property {String} editionProperties.editMode - The edition mode. 'images' by default.
     */

    /**
     * The properties of the current edition process.
     * @type {EditionProperties}
     */
    this.editionProperties = {};

    this.editionProperties.isNewElement = true;
    this.editionProperties.temporalImage = null;
    this.editionProperties.latexRange = null;
    this.editionProperties.range = null;
    this.editionProperties.editionStartTime = null;

    /**
     * The {@link IntegrationModel} instance.
     * @type {IntegrationModel}
     */
    this.integrationModel = null;

    /**
     * The {@link ContentManager} instance.
     * @type {ContentManager}
     */
    this.contentManager = null;

    /**
     * The current browser.
     * @type {String}
     */
    this.browser = (() => {
      const ua = navigator.userAgent;
      let browser = "none";
      if (ua.search("Edge/") >= 0) {
        browser = "EDGE";
      } else if (ua.search("Chrome/") >= 0) {
        browser = "CHROME";
      } else if (ua.search("Trident/") >= 0) {
        browser = "IE";
      } else if (ua.search("Firefox/") >= 0) {
        browser = "FIREFOX";
      } else if (ua.search("Safari/") >= 0) {
        browser = "SAFARI";
      }
      return browser;
    })();

    /**
     * Plugin listeners.
     * @type {Array.<Object>}
     */
    this.listeners = new _listeners__WEBPACK_IMPORTED_MODULE_10__["default"]();

    /**
     * Service provider properties.
     * @type {ServiceProviderProperties}
     */
    this.serviceProviderProperties = {};
    if ("serviceProviderProperties" in coreProperties) {
      this.serviceProviderProperties = coreProperties.serviceProviderProperties;
    } else {
      throw new Error("serviceProviderProperties property missing.");
    }
  }

  /**
   * Static property.
   * Core listeners.
   * @private
   * @type {Listeners}
   */
  static get globalListeners() {
    return Core._globalListeners;
  }

  /**
   * Static property setter.
   * Set core listeners.
   * @param {Listeners} value - The property value.
   * @ignore
   */
  static set globalListeners(value) {
    Core._globalListeners = value;
  }

  /**
   * Core state. Says if it was loaded previously.
   * True when Core.init was called. Otherwise, false.
   * @private
   * @type {Boolean}
   */
  static get initialized() {
    return Core._initialized;
  }

  /**
   * Core state. Says if it was loaded previously.
   * @param {Boolean} value - True to say that Core.init was called. Otherwise, false.
   * @ignore
   */
  static set initialized(value) {
    Core._initialized = value;
  }

  /**
   * Sets the {@link Core.integrationModel} property.
   * @param {IntegrationModel} integrationModel - The {@link IntegrationModel} property.
   */
  setIntegrationModel(integrationModel) {
    this.integrationModel = integrationModel;
  }

  /**
   * Sets the {@link Core.environment} property.
   * @param {IntegrationEnvironment} integrationEnvironment -
   * The {@link IntegrationEnvironment} object.
   */
  setEnvironment(integrationEnvironment) {
    if ("editor" in integrationEnvironment) {
      this.environment.editor = integrationEnvironment.editor;
    }
    if ("mode" in integrationEnvironment) {
      this.environment.mode = integrationEnvironment.mode;
    }
    if ("version" in integrationEnvironment) {
      this.environment.version = integrationEnvironment.version;
    }
  }

  /**
   * Sets the custom headers added on editor requests if contentManager isn't undefined.
   * @returns {Object} headers - key value headers.
   */
  setHeaders(headers) {
    const headerObject = this?.contentManager?.setCustomHeaders(headers) || headers;
    _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].set("customHeaders", headerObject);
  }

  /**
   * Returns the current {@link ModalDialog} instance.
   * @returns {ModalDialog} The current {@link ModalDialog} instance.
   */
  getModalDialog() {
    return this.modalDialog;
  }

  /**
   * Inits the {@link Core} class, doing the following:
   * - Calls asynchronously configuration service, retrieving the backend configuration in a JSON.
   * - Updates {@link Configuration} class with the previous configuration properties.
   * - Updates the {@link ServiceProvider} class using the configuration service path as reference.
   * - Loads language strings.
   * - Fires onLoad event.
   * @param {Object} serviceParameters - Service parameters.
   */
  init() {
    if (!Core.initialized) {
      const serviceProviderListener = _listeners__WEBPACK_IMPORTED_MODULE_10__["default"].newListener("onInit", () => {
        const jsConfiguration = _serviceprovider__WEBPACK_IMPORTED_MODULE_12__["default"].getService("configurationjs", "", "get");
        const jsonConfiguration = JSON.parse(jsConfiguration);
        _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].addConfiguration(jsonConfiguration);
        // Adding JavaScript (not backend) configuration variables.
        _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].addConfiguration(_jsvariables__WEBPACK_IMPORTED_MODULE_8__["default"]);
        // Fire 'onLoad' event:
        // All integration must listen this event in order to know if the plugin
        // has been properly loaded.
        _stringmanager__WEBPACK_IMPORTED_MODULE_2__["default"].language = this.language;
        this.listeners.fire("onLoad", {});
      });

      _serviceprovider__WEBPACK_IMPORTED_MODULE_12__["default"].addListener(serviceProviderListener);
      _serviceprovider__WEBPACK_IMPORTED_MODULE_12__["default"].init(this.serviceProviderProperties);

      Core.initialized = true;
    } else {
      // Case when there are more than two editor instances.
      // After the first editor all the other editors don't need to load any file or service.
      this.listeners.fire("onLoad", {});
    }
  }

  /**
   * Adds a {@link Listener} to the current instance of the {@link Core} class.
   * @param {Listener} listener - The listener object.
   */
  addListener(listener) {
    this.listeners.add(listener);
  }

  /**
   * Adds the global {@link Listener} instance to {@link Core} class.
   * @param {Listener} listener - The event listener to be added.
   * @static
   */
  static addGlobalListener(listener) {
    Core.globalListeners.add(listener);
  }

  beforeUpdateFormula(mathml, wirisProperties) {
    /**
     * This event is fired before updating the formula.
     * @type {Object}
     * @property {String} mathml - MathML to be transformed.
     * @property {String} editMode - Edit mode.
     * @property {Object} wirisProperties - Extra attributes for the formula.
     * @property {String} language - Formula language.
     */
    const beforeUpdateEvent = new _event__WEBPACK_IMPORTED_MODULE_9__["default"]();

    beforeUpdateEvent.mathml = mathml;

    // Cloning wirisProperties object
    // We don't want wirisProperties object modified.
    beforeUpdateEvent.wirisProperties = {};

    if (wirisProperties != null) {
      Object.keys(wirisProperties).forEach((attr) => {
        beforeUpdateEvent.wirisProperties[attr] = wirisProperties[attr];
      });
    }

    // Read only.
    beforeUpdateEvent.language = this.language;
    beforeUpdateEvent.editMode = this.editMode;

    if (this.listeners.fire("onBeforeFormulaInsertion", beforeUpdateEvent)) {
      return {};
    }

    if (Core.globalListeners.fire("onBeforeFormulaInsertion", beforeUpdateEvent)) {
      return {};
    }

    return {
      mathml: beforeUpdateEvent.mathml,
      wirisProperties: beforeUpdateEvent.wirisProperties,
    };
  }

  /**
   * Converts a MathML into it's correspondent image and inserts the image is
   * inserted in a HTMLElement target by creating
   * a new image or updating an existing one.
   * @param {HTMLElement} focusElement - The HTMLElement to be focused after the insertion.
   * @param {Window} windowTarget - The window element where the editable content is.
   * @param {String} mathml - The MathML.
   * @param {Array.<Object>} wirisProperties - The extra attributes for the formula.
   * @returns {ReturnObject} - Object with the information of the node or latex to insert.
   */
  insertFormula(focusElement, windowTarget, mathml, wirisProperties) {
    /**
     * It is the object with the information of the node or latex to insert.
     * @typedef ReturnObject
     * @property {Node} [node] - The DOM node to insert.
     * @property {String} [latex] - The latex to insert.
     */
    const returnObject = {};

    if (!mathml) {
      this.insertElementOnSelection(null, focusElement, windowTarget);
    } else if (this.editMode === "latex") {
      returnObject.latex = _latex__WEBPACK_IMPORTED_MODULE_4__["default"].getLatexFromMathML(mathml);
      // this.integrationModel.getNonLatexNode is an integration wrapper
      // to have special behaviours for nonLatex.
      // Not all the integrations have special behaviours for nonLatex.
      if (!!this.integrationModel.fillNonLatexNode && !returnObject.latex) {
        const afterUpdateEvent = new _event__WEBPACK_IMPORTED_MODULE_9__["default"]();
        afterUpdateEvent.editMode = this.editMode;
        afterUpdateEvent.windowTarget = windowTarget;
        afterUpdateEvent.focusElement = focusElement;
        afterUpdateEvent.latex = returnObject.latex;
        this.integrationModel.fillNonLatexNode(afterUpdateEvent, windowTarget, mathml);
      } else {
        returnObject.node = windowTarget.document.createTextNode(`$$${returnObject.latex}$$`);
      }
      this.insertElementOnSelection(returnObject.node, focusElement, windowTarget);
    } else {
      returnObject.node = _parser__WEBPACK_IMPORTED_MODULE_0__["default"].mathmlToImgObject(windowTarget.document, mathml, wirisProperties, this.language);

      this.insertElementOnSelection(returnObject.node, focusElement, windowTarget);
    }

    return returnObject;
  }

  afterUpdateFormula(focusElement, windowTarget, node, latex) {
    /**
     * This event is fired after update the formula.
     * @type {Event}
     * @param {String} editMode - edit mode.
     * @param {Object} windowTarget - target window.
     * @param {Object} focusElement - target element to be focused after update.
     * @param {String} latex - LaTeX generated by the formula (editMode=latex).
     * @param {Object} node - node generated after update the formula (text if LaTeX img otherwise).
     */
    const afterUpdateEvent = new _event__WEBPACK_IMPORTED_MODULE_9__["default"]();
    afterUpdateEvent.editMode = this.editMode;
    afterUpdateEvent.windowTarget = windowTarget;
    afterUpdateEvent.focusElement = focusElement;
    afterUpdateEvent.node = node;
    afterUpdateEvent.latex = latex;

    if (this.listeners.fire("onAfterFormulaInsertion", afterUpdateEvent)) {
      return {};
    }

    if (Core.globalListeners.fire("onAfterFormulaInsertion", afterUpdateEvent)) {
      return {};
    }

    return {};
  }

  /**
   * Sets the caret after a given Node and set the focus to the owner document.
   * @param {Node} node - The Node element.
   */
  placeCaretAfterNode(node) {
    if (node === null) return;

    this.integrationModel.getSelection();
    const nodeDocument = node.ownerDocument;
    if (typeof nodeDocument.getSelection !== "undefined" && !!node.parentElement) {
      const range = nodeDocument.createRange();
      range.setStartAfter(node);
      range.collapse(true);
      const selection = nodeDocument.getSelection();
      selection.removeAllRanges();
      selection.addRange(range);
      nodeDocument.body.focus();
    }
  }

  /**
   * Replaces a Selection object with an HTMLElement.
   * @param {HTMLElement} element - The HTMLElement to replace the selection.
   * @param {HTMLElement} focusElement - The HTMLElement to be focused after the replace.
   * @param {Window} windowTarget - The window target.
   */
  insertElementOnSelection(element, focusElement, windowTarget) {
    let mathmlOrigin = null;
    if (this.editionProperties.isNewElement) {
      if (element) {
        if (focusElement.type === "textarea") {
          _util__WEBPACK_IMPORTED_MODULE_1__["default"].updateTextArea(focusElement, element.textContent);
        } else if (document.selection && document.getSelection === 0) {
          let range = windowTarget.document.selection.createRange();
          windowTarget.document.execCommand("InsertImage", false, element.src);

          if (!("parentElement" in range)) {
            windowTarget.document.execCommand("delete", false);
            range = windowTarget.document.selection.createRange();
            windowTarget.document.execCommand("InsertImage", false, element.src);
          }

          if ("parentElement" in range) {
            const temporalObject = range.parentElement();

            if (temporalObject.nodeName.toUpperCase() === "IMG") {
              temporalObject.parentNode.replaceChild(element, temporalObject);
            } else {
              // IE9 fix: parentNode() does not return the IMG node,
              // returns the parent DIV node. In IE < 9, pasteHTML does not work well.
              range.pasteHTML(_util__WEBPACK_IMPORTED_MODULE_1__["default"].createObjectCode(element));
            }
          }
        } else {
          let range = null;
          // In IE is needed keep the range due to after focus the modal window
          // it can't be retrieved the last selection.
          if (this.editionProperties.range) {
            ({ range } = this.editionProperties);
            this.editionProperties.range = null;
          } else {
            const editorSelection = this.integrationModel.getSelection();
            range = editorSelection.getRangeAt(0);
          }

          // Delete if something was surrounded.
          range.deleteContents();

          let node = range.startContainer;
          const position = range.startOffset;

          if (node.nodeType === 3) {
            // TEXT_NODE.
            node = node.splitText(position);
            node.parentNode.insertBefore(element, node);
          } else if (node.nodeType === 1) {
            // ELEMENT_NODE.
            node.insertBefore(element, node.childNodes[position]);
          }

          this.placeCaretAfterNode(element);
        }
      } else if (focusElement.type === "textarea") {
        focusElement.focus();
      } else {
        const editorSelection = this.integrationModel.getSelection();
        editorSelection.removeAllRanges();

        if (this.editionProperties.range) {
          const { range } = this.editionProperties;
          this.editionProperties.range = null;
          editorSelection.addRange(range);
        }
      }
    } else if (this.editionProperties.latexRange) {
      if (document.selection && document.getSelection === 0) {
        this.editionProperties.isNewElement = true;
        this.editionProperties.latexRange.select();
        this.insertElementOnSelection(element, focusElement, windowTarget);
      } else {
        this.editionProperties.latexRange.deleteContents();
        this.editionProperties.latexRange.insertNode(element);
        this.placeCaretAfterNode(element);
      }
    } else if (focusElement.type === "textarea") {
      let item;
      // Wrapper for some integrations that can have special behaviours to show latex.
      if (typeof this.integrationModel.getSelectedItem !== "undefined") {
        item = this.integrationModel.getSelectedItem(focusElement, false);
      } else {
        item = _util__WEBPACK_IMPORTED_MODULE_1__["default"].getSelectedItemOnTextarea(focusElement);
      }
      _util__WEBPACK_IMPORTED_MODULE_1__["default"].updateExistingTextOnTextarea(focusElement, element.textContent, item.startPosition, item.endPosition);
    } else {
      mathmlOrigin = this.editionProperties.temporalImage?.dataset.mathml;
      if (element && element.nodeName.toLowerCase() === "img") {
        // Editor empty, formula has been erased on edit.
        // There are editors (e.g: CKEditor) that put attributes in images.
        // We don't allow that behaviour in our images.
        _image__WEBPACK_IMPORTED_MODULE_11__["default"].removeImgDataAttributes(this.editionProperties.temporalImage);
        // Clone is needed to maintain event references to temporalImage.
        _image__WEBPACK_IMPORTED_MODULE_11__["default"].clone(element, this.editionProperties.temporalImage);
      } else {
        this.editionProperties.temporalImage.remove();
      }
      this.placeCaretAfterNode(this.editionProperties.temporalImage);
    }

    // Build the telemeter payload separated to delete null/undefined entries.
    const mathml = element?.dataset?.mathml;
    let payload = {
      mathml_origin: mathmlOrigin ? _mathml__WEBPACK_IMPORTED_MODULE_5__["default"].safeXmlDecode(mathmlOrigin) : mathmlOrigin,
      mathml: mathml ? _mathml__WEBPACK_IMPORTED_MODULE_5__["default"].safeXmlDecode(mathml) : mathml,
      elapsed_time: Date.now() - this.editionProperties.editionStartTime,
      editor_origin: null, // TODO read formula to find out whether it comes from Oxygen Desktop
      toolbar: this.modalDialog.contentManager.toolbar,
      size: mathml?.length,
    };

    // Remove the desired null keys.
    Object.keys(payload).forEach((key) => {
      if (key === "mathml_origin" || key === "editor_origin") !payload[key] ? delete payload[key] : {};
    });

    // Call Telemetry service to track the event.
    try {
      _telemeter__WEBPACK_IMPORTED_MODULE_14__["default"].telemeter.track("INSERTED_FORMULA", {
        ...payload,
      });
    } catch (error) {
      console.error("Error tracking INSERTED_FORMULA", error);
    }
  }

  /**
   * Opens a modal dialog containing MathType editor..
   * @param {HTMLElement} target - The target HTMLElement where formulas should be inserted.
   * @param {Boolean} isIframe - True if the target HTMLElement is an iframe. False otherwise.
   */
  openModalDialog(target, isIframe) {
    // Count the time since the editor is open
    this.editionProperties.editionStartTime = Date.now();

    // Textarea elements don't have normal document ranges. It only accepts latex edit.
    this.editMode = "images";

    // In IE is needed keep the range due to after focus the modal window
    // it can't be retrieved the last selection.
    try {
      if (isIframe) {
        // Is needed focus the target first.
        target.contentWindow.focus();
        const selection = target.contentWindow.getSelection();
        this.editionProperties.range = selection.getRangeAt(0);
      } else {
        // Is needed focus the target first.
        target.focus();
        const selection = getSelection();
        this.editionProperties.range = selection.getRangeAt(0);
      }
    } catch (e) {
      this.editionProperties.range = null;
    }

    if (isIframe === undefined) {
      isIframe = true;
    }

    this.editionProperties.latexRange = null;

    if (target) {
      let selectedItem;
      if (typeof this.integrationModel.getSelectedItem !== "undefined") {
        selectedItem = this.integrationModel.getSelectedItem(target, isIframe);
      } else {
        selectedItem = _util__WEBPACK_IMPORTED_MODULE_1__["default"].getSelectedItem(target, isIframe);
      }

      // Check LaTeX if and only if the node is a text node (nodeType==3).
      if (selectedItem) {
        // Case when image was selected and button pressed.
        if (!selectedItem.caretPosition && _util__WEBPACK_IMPORTED_MODULE_1__["default"].containsClass(selectedItem.node, _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("imageClassName"))) {
          this.editionProperties.temporalImage = selectedItem.node;
          this.editionProperties.isNewElement = false;
        } else if (selectedItem.node.nodeType === 3) {
          // If it's a text node means that editor is working with LaTeX.
          if (this.integrationModel.getMathmlFromTextNode) {
            // If integration has this function it isn't set range due to we don't
            // know if it will be put into a textarea as a text or image.
            const mathml = this.integrationModel.getMathmlFromTextNode(selectedItem.node, selectedItem.caretPosition);
            if (mathml) {
              this.editMode = "latex";
              this.editionProperties.isNewElement = false;
              this.editionProperties.temporalImage = document.createElement("img");
              this.editionProperties.temporalImage.setAttribute(
                _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("imageMathmlAttribute"),
                _mathml__WEBPACK_IMPORTED_MODULE_5__["default"].safeXmlEncode(mathml),
              );
            }
          } else {
            const latexResult = _latex__WEBPACK_IMPORTED_MODULE_4__["default"].getLatexFromTextNode(selectedItem.node, selectedItem.caretPosition);
            if (latexResult) {
              const mathml = _latex__WEBPACK_IMPORTED_MODULE_4__["default"].getMathMLFromLatex(latexResult.latex);
              this.editMode = "latex";
              this.editionProperties.isNewElement = false;
              this.editionProperties.temporalImage = document.createElement("img");
              this.editionProperties.temporalImage.setAttribute(
                _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("imageMathmlAttribute"),
                _mathml__WEBPACK_IMPORTED_MODULE_5__["default"].safeXmlEncode(mathml),
              );
              const windowTarget = isIframe ? target.contentWindow : window;

              if (target.tagName.toLowerCase() !== "textarea") {
                if (document.selection) {
                  let leftOffset = 0;
                  let previousNode = latexResult.startNode.previousSibling;

                  while (previousNode) {
                    leftOffset += _util__WEBPACK_IMPORTED_MODULE_1__["default"].getNodeLength(previousNode);
                    previousNode = previousNode.previousSibling;
                  }

                  this.editionProperties.latexRange = windowTarget.document.selection.createRange();
                  this.editionProperties.latexRange.moveToElementText(latexResult.startNode.parentNode);
                  this.editionProperties.latexRange.move("character", leftOffset + latexResult.startPosition);
                  this.editionProperties.latexRange.moveEnd("character", latexResult.latex.length + 4); // Plus 4 for the '$$' characters.
                } else {
                  this.editionProperties.latexRange = windowTarget.document.createRange();
                  this.editionProperties.latexRange.setStart(latexResult.startNode, latexResult.startPosition);
                  this.editionProperties.latexRange.setEnd(latexResult.endNode, latexResult.endPosition);
                }
              }
            }
          }
        }
      } else if (target.tagName.toLowerCase() === "textarea") {
        // By default editMode is 'images', but when target is a textarea it needs to be 'latex'.
        this.editMode = "latex";
      }
    }

    // Setting an object with the editor parameters.
    // Editor parameters can be customized in several ways:
    // 1 - editorAttributes: Contains the default editor attributes,
    //  usually the metrics in a comma separated string. Always exists.
    // 2 - editorParameters: Object containing custom editor parameters.
    // These parameters are defined in the backend. So they affects all integration instances.

    // The backend send the default editor attributes in a coma separated
    // with the following structure: key1=value1,key2=value2...
    const defaultEditorAttributesArray = _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("editorAttributes").split(", ");
    const defaultEditorAttributes = {};
    for (let i = 0, len = defaultEditorAttributesArray.length; i < len; i += 1) {
      const tempAttribute = defaultEditorAttributesArray[i].split("=");
      const key = tempAttribute[0];
      const value = tempAttribute[1];
      defaultEditorAttributes[key] = value;
    }
    // Custom editor parameters.
    const editorAttributes = {
      language: this.language, // Default language value
    };
    // Editor parameters in backend, usually configuration.ini.
    const serverEditorParameters = _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("editorParameters");
    // Editor parameters through JavaScript configuration.
    const clientEditorParameters = this.integrationModel.editorParameters;
    Object.assign(editorAttributes, defaultEditorAttributes, serverEditorParameters);
    Object.assign(editorAttributes, defaultEditorAttributes, clientEditorParameters);

    // Now, update backwards: if user has set a custom language, pass that back to core properties
    this.language = editorAttributes.language;
    _stringmanager__WEBPACK_IMPORTED_MODULE_2__["default"].language = this.language;

    editorAttributes.rtl = this.integrationModel.rtl;

    const customHeaders = _configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("customHeaders");
    // This is not being used in the code, we are keeping it just in case it's needed.
    // We check if it is a string since we have a setter that will make the customHeaders an object. And we do the conversion for the case when we get the headers from the backend.
    editorAttributes.customHeaders =
      typeof customHeaders === "string" ? _util__WEBPACK_IMPORTED_MODULE_1__["default"].convertStringToObject(customHeaders) : customHeaders;

    const contentManagerAttributes = {};
    contentManagerAttributes.editorAttributes = editorAttributes;
    contentManagerAttributes.language = this.language;
    contentManagerAttributes.customEditors = this.customEditors;
    contentManagerAttributes.environment = this.environment;

    if (this.modalDialog == null) {
      this.modalDialog = new _modal__WEBPACK_IMPORTED_MODULE_13__["default"](editorAttributes);
      this.contentManager = new _contentmanager__WEBPACK_IMPORTED_MODULE_3__["default"](contentManagerAttributes);
      // When an instance of ContentManager is created we need to wait until
      // the ContentManager is ready by listening 'onLoad' event.
      const listener = _listeners__WEBPACK_IMPORTED_MODULE_10__["default"].newListener("onLoad", () => {
        this.contentManager.dbclick = this.editionProperties.dbclick;
        this.contentManager.isNewElement = this.editionProperties.isNewElement;
        if (this.editionProperties.temporalImage != null) {
          const mathML = _mathml__WEBPACK_IMPORTED_MODULE_5__["default"].safeXmlDecode(
            this.editionProperties.temporalImage.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("imageMathmlAttribute")),
          );
          this.contentManager.mathML = mathML;
        }
      });
      this.contentManager.addListener(listener);
      this.contentManager.init();
      this.modalDialog.setContentManager(this.contentManager);
      this.contentManager.setModalDialogInstance(this.modalDialog);
    } else {
      this.contentManager.dbclick = this.editionProperties.dbclick;
      this.contentManager.isNewElement = this.editionProperties.isNewElement;
      if (this.editionProperties.temporalImage != null) {
        const mathML = _mathml__WEBPACK_IMPORTED_MODULE_5__["default"].safeXmlDecode(
          this.editionProperties.temporalImage.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_7__["default"].get("imageMathmlAttribute")),
        );
        this.contentManager.mathML = mathML;
      }
    }
    this.contentManager.setIntegrationModel(this.integrationModel);
    this.modalDialog.open();
  }

  /**
   * Returns the {@link CustomEditors} instance.
   * @return {CustomEditors} The current {@link CustomEditors} instance.
   */
  getCustomEditors() {
    return this.customEditors;
  }
}

/**
 * Core static listeners.
 * @type {Listeners}
 * @private
 */
Core._globalListeners = new _listeners__WEBPACK_IMPORTED_MODULE_10__["default"]();

/**
 * Resources state. Says if they were loaded or not.
 * @type {Boolean}
 * @private
 */
Core._initialized = false;


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/customeditors.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/customeditors.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CustomEditors)
/* harmony export */ });
/**
 * A custom editor is MathType editor with a different
 * @typedef {Object} CustomEditor
 * @property {String} CustomEditor.name - Custom editor name.
 * @property {String} CustomEditor.toolbar - Custom editor toolbar.
 * @property {String} CustomEditor.icon - Custom editor icon.
 * @property {String} CustomEditor.confVariable - Configuration property to manage
 * the availability of the custom editor.
 * @property {String} CustomEditor.title - Custom editor modal dialog title.
 * @property {String} CustomEditor.tooltip - Custom editor icon tooltip.
 */

class CustomEditors {
  /**
   * @classdesc
   * This class represents the MathType custom editors manager.
   * A custom editor is MathType editor with a custom  toolbar.
   * This class associates a {@link CustomEditor} to:
   * - It's own formulas
   * - A custom toolbar
   * - An icon to open it from a HTML editor.
   * - A tooltip for the icon.
   * - A global variable to enable or disable it globally.
   * @constructs
   */
  constructor() {
    /**
     * The custom editors.
     * @type {Array.<CustomEditor>}
     */

    this.editors = [];
    /**
     * The active editor name.
     * @type {String}
     */
    this.activeEditor = "default";
  }

  /**
   * Adds a {@link CustomEditor} to editors array.
   * @param {String} editorName - The editor name.
   * @param {CustomEditor} editorParams - The custom editor parameters.
   */
  addEditor(editorName, editorParams) {
    const customEditor = {};
    customEditor.name = editorParams.name;
    customEditor.toolbar = editorParams.toolbar;
    customEditor.icon = editorParams.icon;
    customEditor.confVariable = editorParams.confVariable;
    customEditor.title = editorParams.title;
    customEditor.tooltip = editorParams.tooltip;
    this.editors[editorName] = customEditor;
  }

  /**
   * Enables a {@link CustomEditor}.
   * @param {String} customEditorName - The custom editor name.
   */
  enable(customEditorName) {
    this.activeEditor = customEditorName;
  }

  /**
   * Disables a {@link CustomEditor}.
   */
  disable() {
    this.activeEditor = "default";
  }

  /**
   * Returns the active editor.
   * @return {CustomEditor} - A {@link CustomEditor} if a custom editor is enabled. Null otherwise.
   */
  getActiveEditor() {
    if (this.activeEditor !== "default") {
      return this.editors[this.activeEditor];
    }
    return null;
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/editorlistener.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/editorlistener.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EditorListener)
/* harmony export */ });
/* eslint-disable class-methods-use-this */
/* eslint-disable no-unused-vars */
/* eslint-disable no-extra-semi */

// The rules above are disabled because we are implementing
// an external interface.

class EditorListener {
  /**
   * @classdesc
   * Determines if the content of the
   * MathType Editor has changes.
   * @implements {EditorListeners}
   * @constructs
   */
  constructor() {
    /**
     * Indicates if the content of the editor has changed.
     * @type {Boolean}
     */
    this.isContentChanged = false;

    /**
     * Indicates if the listener should be waiting for changes in the editor.
     * @type {Boolean}
     */
    this.waitingForChanges = false;
  }

  /**
   * Sets {@link EditorListener.isContentChanged} property.
   * @param {Boolean} value - The new vlue.
   */
  setIsContentChanged(value) {
    this.isContentChanged = value;
  }

  /**
   * Returns true if the content of the editor has been changed, false otherwise.
   * @return {Boolean}
   */
  getIsContentChanged() {
    return this.isContentChanged;
  }

  /**
   * Determines if the EditorListener should wait for any changes.
   * @param {Boolean} value - True if the editor should wait for changes, false otherwise.
   */
  setWaitingForChanges(value) {
    this.waitingForChanges = value;
  }

  /**
   * EditorListener method to overwrite.
   * @type {JsEditor}
   * @ignore
   */
  caretPositionChanged(_editor) {}

  /**
   * EditorListener method to overwrite
   * @type {JsEditor}
   * @ignore
   */
  clipboardChanged(_editor) {}

  /**
   * Determines if the content of an editor has been changed.
   * @param {JsEditor} editor - editor object.
   */
  contentChanged(_editor) {
    if (this.waitingForChanges === true && this.isContentChanged === false) {
      this.isContentChanged = true;
    }
  }

  /**
   * EditorListener method to overwrite
   * @param {JsEditor} editor - The editor instance.
   */
  styleChanged(_editor) {}

  /**
   * EditorListener method to overwrite
   * @param {JsEditor} - The editor instance.
   */
  transformationReceived(_editor) {}
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/event.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/event.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Event)
/* harmony export */ });
class Event {
  /**
   * @classdesc
   * This class represents a custom event. Events should be fired by the {@link Listener} class.
   *
   * ```js
   *  let customEvent = new Event();
   *  customEvent.properties = {};
   *
   *  let listeners = new Listeners();
   *  listeners.newListener(eventName, callback);
   *
   *  listeners.fire(eventName, customEvent) *
   * ```
   * @constructs
   */
  constructor() {
    /**
     * Indicates if the event should be cancelled.
     * @type {Boolean}
     */

    this.cancelled = false;
    /**
     * Indicates if the event should be prevented.
     * @type {Boolean}
     */
    this.defaultPrevented = false;
  }

  /**
   * Cancels the event.
   */
  cancel() {
    this.cancelled = true;
  }

  /**
   * Prevents the default action.
   */
  preventDefault() {
    this.defaultPrevented = true;
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/image.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/image.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Image)
/* harmony export */ });
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");



/**
 * @classdesc
 * This class represents MathType Image class. Contains all the logic related
 * to MathType images manipulation.
 * All MathType images are generated using the appropriate MathType
 * integration service: showimage or createimage.
 *
 * There are two available image formats:
 * - svg (default)
 * - png
 *
 * There are two formats for the image src attribute:
 * - A data-uri scheme containing the URL-encoded SVG or a PNG's base64.
 * - A link to the showimage service.
 */
class Image {
  /**
   * Removes data attributes from an image.
   * @param {HTMLImageElement} img - Image where remove data attributes.
   */
  static removeImgDataAttributes(img) {
    const attributesToRemove = [];
    const { attributes } = img;

    Object.keys(attributes).forEach((key) => {
      const attribute = attributes[key];
      if (attribute !== undefined && attribute.name !== undefined && attribute.name.indexOf("data-") === 0) {
        // Is preferred keep an array and remove after the search
        // because when attribute is removed the array of attributes
        // is modified.
        attributesToRemove.push(attribute.name);
      }
    });

    attributesToRemove.forEach((attribute) => {
      img.removeAttribute(attribute);
    });
  }

  /**
   * @static
   * Clones all MathType image attributes from a HTMLImageElement to another.
   * @param {HTMLImageElement} originImg - The original image.
   * @param {HTMLImageElement} destImg - The destination image.
   */
  static clone(originImg, destImg) {
    const customEditorAttributeName = _configuration__WEBPACK_IMPORTED_MODULE_0__["default"].get("imageCustomEditorName");
    if (!originImg.hasAttribute(customEditorAttributeName)) {
      destImg.removeAttribute(customEditorAttributeName);
    }

    const mathmlAttributeName = _configuration__WEBPACK_IMPORTED_MODULE_0__["default"].get("imageMathmlAttribute");
    const imgAttributes = [
      mathmlAttributeName,
      customEditorAttributeName,
      "alt",
      "height",
      "width",
      "style",
      "src",
      "role",
    ];

    imgAttributes.forEach((iterator) => {
      const originAttribute = originImg.getAttribute(iterator);
      if (originAttribute) {
        destImg.setAttribute(iterator, originAttribute);
      }
    });
  }

  /**
   * Determines whether an img src contains an SVG.
   * @param {HTMLImageElement} img the img element to inspect
   * @returns true if the img src contains an SVG, false otherwise
   */
  static isSvg(img) {
    return img.src.startsWith("data:image/svg+xml;");
  }

  /**
   * Determines whether an img src is encoded in base64 or not.
   * @param {HTMLImageElement} img the img element to inspect
   * @returns true if the img src is encoded in base64, false otherwise
   */
  static isBase64(img) {
    return img.src.startsWith("data:image/svg+xml;base64,") || img.src.startsWith("data:image/png;base64,");
  }

  /**
   * Calculates the metrics of a MathType image given the the service response and the image format.
   * @param {HTMLImageElement} img - The HTMLImageElement.
   * @param {String} uri - The URI generated by the image service: can be a data URI scheme or a URL.
   * @param {Boolean} jsonResponse - True the response of the image service is a
   * JSON object. False otherwise.
   */
  static setImgSize(img, uri, jsonResponse) {
    let ar;
    let base64String;
    let bytes;
    let svgString;
    if (jsonResponse) {
      // Cleaning data:image/png;base64.
      if (Image.isSvg(img)) {
        // SVG format.
        // If SVG is encoded in base64 we need to convert the base64 bytes into a SVG string.
        if (!Image.isBase64(img)) {
          ar = Image.getMetricsFromSvgString(uri);
        } else {
          base64String = img.src.substr(img.src.indexOf("base64,") + 7, img.src.length);
          svgString = "";
          bytes = _util__WEBPACK_IMPORTED_MODULE_1__["default"].b64ToByteArray(base64String, base64String.length);
          for (let i = 0; i < bytes.length; i += 1) {
            svgString += String.fromCharCode(bytes[i]);
          }
          ar = Image.getMetricsFromSvgString(svgString);
        }
        // PNG format: we store all metrics information in the first 88 bytes.
      } else {
        base64String = img.src.substr(img.src.indexOf("base64,") + 7, img.src.length);
        bytes = _util__WEBPACK_IMPORTED_MODULE_1__["default"].b64ToByteArray(base64String, 88);
        ar = Image.getMetricsFromBytes(bytes);
      }
      // Backwards compatibility: we store the metrics into createimage response.
    } else {
      ar = _util__WEBPACK_IMPORTED_MODULE_1__["default"].urlToAssArray(uri);
    }
    let width = ar.cw;
    if (!width) {
      return;
    }
    let height = ar.ch;
    let baseline = ar.cb;
    const { dpi } = ar;
    if (dpi) {
      width = (width * 96) / dpi;
      height = (height * 96) / dpi;
      baseline = (baseline * 96) / dpi;
    }
    img.width = width;
    img.height = height;
    img.style.verticalAlign = `-${height - baseline}px`;
  }

  /**
   * Calculates the metrics of an image which has been resized. Is used to restore the original
   * metrics of a resized image.
   * @param {HTMLImageElement } img - The resized HTMLImageElement.
   */
  static fixAfterResize(img) {
    img.removeAttribute("style");
    img.removeAttribute("width");
    img.removeAttribute("height");
    // In order to avoid resize with max-width css property.
    img.style.maxWidth = "none";

    const processImg = (img) => {
      if (img.src.indexOf("data:image") !== -1) {
        if (img.src.indexOf("data:image/svg+xml") !== -1) {
          // Image is in base64: decode it in order to calculate the size, and then bring it back to base64
          // This is a bit of an ugly hack used to recycle the logic of Image.setImgSize instead of rewriting it
          // (which would actually make more sense for readibility and efficiency).
          if (img.src.indexOf("data:image/svg+xml;base64,") !== -1) {
            // 'data:image/svg+xml;base64,'.length === 26
            const base64String = img.getAttribute("src").substring(26);
            const svgString = window.atob(base64String);
            const encodedSvgString = encodeURIComponent(svgString);
            img.setAttribute("src", `data:image/svg+xml;charset=utf8,${encodedSvgString}`);
            // 'data:image/svg+xml;charset=utf8,'.length === 32.
            const svg = decodeURIComponent(img.src.substring(32, img.src.length));
            Image.setImgSize(img, svg, true);
            // Return src to base64!
            img.setAttribute("src", `data:image/svg+xml;base64,${base64String}`);
          } else {
            // 'data:image/svg+xml;charset=utf8,'.length === 32.
            const svg = decodeURIComponent(img.src.substring(32, img.src.length));
            Image.setImgSize(img, svg, true);
          }
        } else {
          // 'data:image/png;base64,' === 22.
          const base64 = img.src.substring(22, img.src.length);
          Image.setImgSize(img, base64, true);
        }
      } else {
        Image.setImgSize(img, img.src);
      }
    };

    // If the image doesn't contain a blob, just process it normally
    if (img.src.indexOf("blob:") === -1) {
      processImg(img);
      // if it does contain a blob, then read that, replace the src with the decoded content, and process it
    } else {
      let reader = new FileReader();
      reader.onload = function () {
        img.setAttribute("src", reader.result);
        processImg(img);
      };
      fetch(img.src)
        .then((r) => r.blob())
        .then((blob) => {
          reader.readAsDataURL(blob);
        });
    }
  }

  /**
   * Returns the metrics (height, width and baseline) contained in a SVG image generated
   * by the MathType image service. This image contains as an extra custom attribute:
   * the baseline (wrs:baseline).
   * @param {String} svgString - The SVG image.
   * @return {Array} - The image metrics.
   */
  static getMetricsFromSvgString(svgString) {
    let first = svgString.indexOf('height="');
    let last = svgString.indexOf('"', first + 8, svgString.length);
    const height = svgString.substring(first + 8, last);

    first = svgString.indexOf('width="');
    last = svgString.indexOf('"', first + 7, svgString.length);
    const width = svgString.substring(first + 7, last);

    first = svgString.indexOf('wrs:baseline="');
    last = svgString.indexOf('"', first + 14, svgString.length);
    const baseline = svgString.substring(first + 14, last);

    if (typeof width !== "undefined") {
      const arr = [];
      arr.cw = width;
      arr.ch = height;
      if (typeof baseline !== "undefined") {
        arr.cb = baseline;
      }
      return arr;
    }
    return [];
  }

  /**
   * Returns the metrics (width, height, baseline and dpi) contained in a PNG byte array.
   * @param  {Array.<Bytes>} bytes - png byte array.
   * @return {Array} The png metrics.
   */
  static getMetricsFromBytes(bytes) {
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].readBytes(bytes, 0, 8);
    let width;
    let height;
    let typ;
    let baseline;
    let dpi;
    while (bytes.length >= 4) {
      typ = _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
      if (typ === 0x49484452) {
        width = _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
        height = _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
        // Read 5 bytes.
        _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
        _util__WEBPACK_IMPORTED_MODULE_1__["default"].readByte(bytes);
      } else if (typ === 0x62615345) {
        // Baseline: 'baSE'.
        baseline = _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
      } else if (typ === 0x70485973) {
        // Dpis: 'pHYs'.
        dpi = _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
        dpi = Math.round(dpi / 39.37);
        _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
        _util__WEBPACK_IMPORTED_MODULE_1__["default"].readByte(bytes);
      }
      _util__WEBPACK_IMPORTED_MODULE_1__["default"].readInt32(bytes);
    }

    if (typeof width !== "undefined") {
      const arr = [];
      arr.cw = width;
      arr.ch = height;
      arr.dpi = dpi;
      if (baseline) {
        arr.cb = baseline;
      }

      return arr;
    }
    return [];
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/integrationmodel.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/integrationmodel.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IntegrationModel)
/* harmony export */ });
/* harmony import */ var _core_src__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core.src */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/core.src.js");
/* harmony import */ var _image__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./image */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/image.js");
/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./listeners */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _serviceprovider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./serviceprovider */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/serviceprovider.js");
/* harmony import */ var _telemeter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./telemeter */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/telemeter.js");
/* harmony import */ var _styles_icons_general_warn_icon_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../styles/icons/general/warn_icon.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/general/warn_icon.svg");
// eslint-disable-next-line no-unused-vars, import/named







 //eslint-disable-line

/**
 * @typedef {Object} IntegrationModelProperties
 * @property {string} configurationService - Configuration service path.
 * This parameter is needed to determine all services paths.
 * @property {HTMLElement} integrationModelProperties.target - HTML target.
 * @property {string} integrationModelProperties.scriptName - Integration script name.
 * Usually the name of the integration script.
 * @property {Object} integrationModelProperties.environment - integration environment properties.
 * @property {Object} [integrationModelProperties.callbackMethodArguments] - object containing
 * callback method arguments.
 * @property {string} [integrationModelProperties.version] - integration version number.
 * @property {Object} [integrationModelProperties.editorObject] - object containing
 * the integration editor instance.
 * @property {boolean} [integrationModelProperties.rtl] - true if the editor is in RTL mode.
 * false otherwise.
 * @property {ServiceProviderProperties} [integrationModelProperties.serviceProviderProperties]
 * - The service parameters.
 * @property {Object} [integrationModelProperties.integrationParameters]
 * - Overwritten integration parameters.
 */

class IntegrationModel {
  /**
   * @classdesc
   * This class represents an integration model, allowing the integration script to
   * communicate with Core class. Each integration must extend this class.
   * @constructs
   * @param {IntegrationModelProperties} integrationModelProperties
   */
  constructor(integrationModelProperties) {
    /**
     * Language. Needed for accessibility and locales. English by default.
     */
    this.language = "en";

    /**
     * Service parameters
     * @type {ServiceProviderProperties}
     */
    this.serviceProviderProperties = integrationModelProperties.serviceProviderProperties ?? {};

    /**
     * Configuration service path. The integration service is needed by Core class to
     * load all the backend configuration into the frontend and also to create the paths
     * of all services (all services lives in the same route). Mandatory property.
     */
    this.configurationService = "";
    if ("configurationService" in integrationModelProperties) {
      this.serviceProviderProperties.URI = integrationModelProperties.configurationService;
      console.warn("Deprecated property configurationService. Use serviceParameters on instead.", [
        integrationModelProperties.configurationService,
      ]);
    }

    /**
     * Plugin version. Needed to stats and caching.
     * @type {string}
     */
    this.version = "version" in integrationModelProperties ? integrationModelProperties.version : "";

    /**
     * DOM target in which the plugin works. Needed to associate events, insert formulas, etc.
     * Mandatory property.
     */
    this.target = null;
    if ("target" in integrationModelProperties) {
      this.target = integrationModelProperties.target;
    } else {
      throw new Error("IntegrationModel constructor error: target property missed.");
    }

    /**
     * Integration script name. Needed to know the plugin path.
     */
    if ("scriptName" in integrationModelProperties) {
      this.scriptName = integrationModelProperties.scriptName;
    }

    /**
     * Object containing the arguments needed by the callback function.
     */
    this.callbackMethodArguments = integrationModelProperties.callbackMethodArguments ?? {};

    /**
     * Contains information about the integration environment:
     * like the name of the editor, the version, etc.
     */
    this.environment = integrationModelProperties.environment ?? {};

    /**
     * Indicates if the DOM target is - or not - and iframe.
     */
    this.isIframe = false;
    if (this.target != null) {
      this.isIframe = this.target.tagName.toUpperCase() === "IFRAME";
    }

    /**
     * Instance of the integration editor object. Usually the entry point to access the API
     * of a HTML editor.
     */
    this.editorObject = integrationModelProperties.editorObject ?? null;

    /**
     * Specifies if the direction of the text is RTL. false by default.
     */
    this.rtl = integrationModelProperties.rtl ?? false;

    /**
     * Specifies if the integration model exposes the locale strings. false by default.
     */
    this.managesLanguage = integrationModelProperties.managesLanguage ?? false;

    /**
     * Specify if editor will open in hand mode only
     */
    this.forcedHandMode = integrationModelProperties?.integrationParameters?.forcedHandMode ?? false;

    /**
     * Indicates if an image is selected. Needed to resize the image to the original size in case
     * the image is resized.
     * @type {boolean}
     */
    this.temporalImageResizing = false;

    /**
     * The Core class instance associated to the integration model.
     * @type {Core}
     */
    this.core = null;

    /**
     * Integration model listeners.
     * @type {Listeners}
     */
    this.listeners = new _listeners__WEBPACK_IMPORTED_MODULE_2__["default"]();

    // Parameters overwrite.
    if ("integrationParameters" in integrationModelProperties) {
      IntegrationModel.integrationParameters.forEach((parameter) => {
        if (parameter in integrationModelProperties.integrationParameters) {
          // Don't add empty parameters.
          const value = integrationModelProperties.integrationParameters[parameter];
          if (Object.keys(value).length !== 0) {
            this[parameter] = value;
          }
        }
      });
    }
  }

  /**
   * Init function. Usually called from the integration side once the core.js file is loaded.
   */
  init() {
    // Check if language is an object and select the property necessary
    this.language = this.getLanguage();

    // We need to wait until Core class is loaded ('onLoad' event) before
    // call the callback method.
    const listener = _listeners__WEBPACK_IMPORTED_MODULE_2__["default"].newListener("onLoad", () => {
      this.callbackFunction(this.callbackMethodArguments);
    });

    // Backwards compatibility.
    if (this.serviceProviderProperties.URI.indexOf("configuration") !== -1) {
      const uri = this.serviceProviderProperties.URI;
      const server = _serviceprovider__WEBPACK_IMPORTED_MODULE_5__["default"].getServerLanguageFromService(uri);
      this.serviceProviderProperties.server = server;
      const configurationIndex = this.serviceProviderProperties.URI.indexOf("configuration");
      const subsTring = this.serviceProviderProperties.URI.substring(0, configurationIndex);
      this.serviceProviderProperties.URI = subsTring;
    }

    let serviceParametersURI = this.serviceProviderProperties.URI;
    serviceParametersURI =
      serviceParametersURI.indexOf("/") === 0 || serviceParametersURI.indexOf("http") === 0
        ? serviceParametersURI
        : _util__WEBPACK_IMPORTED_MODULE_3__["default"].concatenateUrl(this.getPath(), serviceParametersURI);

    this.serviceProviderProperties.URI = serviceParametersURI;

    const coreProperties = {};
    coreProperties.serviceProviderProperties = this.serviceProviderProperties;

    this.setCore(new _core_src__WEBPACK_IMPORTED_MODULE_0__["default"](coreProperties));
    this.core.addListener(listener);
    this.core.language = this.language;

    // Initializing Core class.
    this.core.init();
    // TODO: Move to Core constructor.
    this.core.setEnvironment(this.environment);

    // No internet connection modal.
    let attributes = {};
    attributes.class = attributes.id = "wrs_modal_offline";
    this.offlineModal = _util__WEBPACK_IMPORTED_MODULE_3__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_modal_content_offline";
    this.offlineModalContent = _util__WEBPACK_IMPORTED_MODULE_3__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_modal_offline_close";
    this.offlineModalClose = _util__WEBPACK_IMPORTED_MODULE_3__["default"].createElement("span", attributes);
    this.offlineModalClose.innerHTML = "&times;";

    attributes = {};
    attributes.class = "wrs_modal_offline_warn";
    this.offlineModalWarn = _util__WEBPACK_IMPORTED_MODULE_3__["default"].createElement("span", attributes);
    let generalStyle = `background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_warn_icon_svg__WEBPACK_IMPORTED_MODULE_7__)})`;
    this.offlineModalWarn.setAttribute("style", generalStyle);

    attributes = {};
    attributes.class = "wrs_modal_offline_text_container";
    this.offlineModalMessage = _util__WEBPACK_IMPORTED_MODULE_3__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_modal_offline_text_warn";
    this.offlineModalMessage1 = _util__WEBPACK_IMPORTED_MODULE_3__["default"].createElement("p", attributes);
    this.offlineModalMessage1.innerHTML = "You are not online!";

    attributes = {};
    attributes.class = "wrs_modal_offline_text";
    this.offlineModalMessage2 = _util__WEBPACK_IMPORTED_MODULE_3__["default"].createElement("p", attributes);
    this.offlineModalMessage2.innerHTML = `Thank you for using MathType. We have detected you are disconnected from the network. We remind you that you'll need to be connected to use MathType. <br /><br />Please refresh the page if this message continues appearing.`;

    //Append offline modal elements
    this.offlineModalContent.appendChild(this.offlineModalClose);
    this.offlineModalMessage.appendChild(this.offlineModalMessage1);
    this.offlineModalMessage.appendChild(this.offlineModalMessage2);
    this.offlineModalContent.appendChild(this.offlineModalMessage);
    this.offlineModalContent.appendChild(this.offlineModalWarn);
    this.offlineModal.appendChild(this.offlineModalContent);
    document.body.appendChild(this.offlineModal);

    let modal = document.getElementById("wrs_modal_offline");
    this.offlineModalClose.addEventListener("click", function () {
      modal.style.display = "none";
    });

    // Store editor name for telemetry purposes.
    let editorName = this.environment.editor;
    editorName = editorName.slice(0, -1); // Remove version number from editors
    if (editorName.includes("TinyMCE")) editorName = "TinyMCE"; // Remove version from Tinymce editor.
    if (editorName.includes("Generic")) editorName = "Generic"; // Remove version from Generic editor.
    let solutionTelemeter = editorName;

    // If moodle, add information to hosts and solution.
    let isMoodle = !!(typeof M === "object" && M !== null),
      lms;

    if (isMoodle) {
      solutionTelemeter = "Moodle";
      lms = {
        nam: "moodle",
        fam: "lms",
        ver: this.environment.moodleVersion,
        category: this.environment.moodleCourseCategory,
        course: this.environment.moodleCourseName,
      };
      if (!editorName.includes("TinyMCE")) {
        editorName = "Atto";
      }
    }

    // Get the OS and its version.
    let OSData = this.getOS();

    // Get the broswer and its version.
    let broswerData = this.getBrowser();

    // Create list of hosts to send to telemetry.
    let hosts = [
      {
        nam: broswerData.detectedBrowser,
        fam: "browser",
        ver: broswerData.versionBrowser,
      },
      {
        nam: editorName.toLowerCase(),
        fam: "html-editor",
        ver: this.environment.editorVersion,
      },
      {
        nam: OSData.detectedOS,
        fam: "os",
        ver: OSData.versionOS,
      },
      {
        nam: window.location.hostname,
        fam: "domain",
      },
      lms,
    ];

    // Filter hosts to remove empty objects and empty keys.
    hosts = hosts.filter(function (element) {
      if (element) Object.keys(element).forEach((key) => (element[key] === "unknown" ? delete element[key] : {}));
      return element !== undefined;
    });

    // Initialize telemeter
    _telemeter__WEBPACK_IMPORTED_MODULE_6__["default"].init({
      solution: {
        name: "MathType for " + solutionTelemeter,
        version: this.version,
      },
      hosts: hosts,
      config: {
        test: false, // True to use the staging Telemetry endpoint instead of the production one.
        debug: false, // True to show more information about Telemeter's execution and use dev-tools.
        dry_run: false, // True to skip sending data to the Telemetry endpoint (for example for unit tests).
        api_key: "eda2ce9b-0e8a-46f2-acdd-c228a615314e", // to auth against Telemetry. Data team is the responsible of providing it.
      },
      url: undefined,
    });
  }

  /**
   * Returns the Browser name and its version.
   * @return {array} - detectedBrowser = Operating System name.
   *                   versionBrowser = Operating System version.
   */
  getBrowser() {
    // default value for OS just in case nothing is detected
    let detectedBrowser = "unknown",
      versionBrowser = "unknown";

    let userAgent = window.navigator.userAgent;

    if (/Brave/.test(userAgent)) {
      detectedBrowser = "brave";
      if (userAgent.indexOf("Brave/")) {
        let start = userAgent.indexOf("Brave") + 6;
        let end = userAgent.substring(start).indexOf(" ");
        end = end === -1 ? userAgent.lastIndexOf("") : end;
        versionBrowser = userAgent
          .substring(start, end + start)
          .replace("_", ".")
          .replace(/[^\d.-]/g, "");
      }
    } else if (userAgent.indexOf("Edg/") !== -1) {
      detectedBrowser = "edge_chromium";
      let start = userAgent.indexOf("Edg/") + 4;
      versionBrowser = userAgent
        .substring(start)
        .replace("_", ".")
        .replace(/[^\d.-]/g, "");
    } else if (/Edg/.test(userAgent)) {
      detectedBrowser = "edge";
      let start = userAgent.indexOf("Edg") + 3;
      start = start + userAgent.substring(start).indexOf("/");
      let end = userAgent.substring(start).indexOf(" ");
      end = end === -1 ? userAgent.lastIndexOf("") : end;
      versionBrowser = userAgent
        .substring(start, end + start)
        .replace("_", ".")
        .replace(/[^\d.-]/g, "");
    } else if (/Firefox/.test(userAgent) || /FxiOS/.test(userAgent)) {
      detectedBrowser = "firefox";
      let start = userAgent.indexOf("Firefox");
      start = start === -1 ? userAgent.indexOf("FxiOS") : start;
      start = start + userAgent.substring(start).indexOf("/") + 1;
      let end = userAgent.substring(start).indexOf(" ");
      end = end === -1 ? userAgent.lastIndexOf("") : end;
      versionBrowser = userAgent.substring(start, end + start).replace("_", ".");
    } else if (/OPR/.test(userAgent)) {
      detectedBrowser = "opera";
      let start = userAgent.indexOf("OPR/") + 4;
      let end = userAgent.substring(start).indexOf(" ");
      end = end === -1 ? userAgent.lastIndexOf("") : end;
      versionBrowser = userAgent
        .substring(start, end + start)
        .replace("_", ".")
        .replace(/[^\d.-]/g, "");
    } else if (/Chrome/.test(userAgent) || /CriOS/.test(userAgent)) {
      detectedBrowser = "chrome";
      let start = userAgent.indexOf("Chrome");
      start = start === -1 ? userAgent.indexOf("CriOS") : start;
      start = start + userAgent.substring(start).indexOf("/") + 1;
      let end = userAgent.substring(start).indexOf(" ");
      end = end === -1 ? userAgent.lastIndexOf("") : end;
      versionBrowser = userAgent.substring(start, end + start).replace("_", ".");
    } else if (/Safari/.test(userAgent)) {
      detectedBrowser = "safari";
      let start = userAgent.indexOf("Version/");
      start = start + userAgent.substring(start).indexOf("/") + 1;
      let end = userAgent.substring(start).indexOf(" ");
      end = end === -1 ? userAgent.lastIndexOf("") : end;
      versionBrowser = userAgent.substring(start, end + start).replace("_", ".");
    }

    return { detectedBrowser, versionBrowser };
  }

  /**
   * Returns the operating system and its version.
   * @return {array} - detectedOS = Operating System name.
   *                   versionOS = Operating System version.
   */
  getOS() {
    // default value for OS just in case nothing is detected
    let detectedOS = "unknown",
      versionOS = "unknown";

    // Retrieve properties to easily detect the OS
    let userAgent = window.navigator.userAgent,
      platform = window.navigator.platform,
      macosPlatforms = ["Macintosh", "MacIntel", "MacPPC", "Mac68K"],
      windowsPlatforms = ["Win32", "Win64", "Windows", "WinCE"],
      iosPlatforms = ["iPhone", "iPad", "iPod"];

    // Find OS and their respective versions
    if (macosPlatforms.indexOf(platform) !== -1) {
      detectedOS = "macos";
      if (userAgent.indexOf("OS X") !== -1) {
        let start = userAgent.indexOf("OS X") + 5;
        let end = userAgent.substring(start).indexOf(" ");
        versionOS = userAgent
          .substring(start, end + start)
          .replace("_", ".")
          .replace(/[^\d.-]/g, "");
      }
    } else if (iosPlatforms.indexOf(platform) !== -1) {
      detectedOS = "ios";
      if (userAgent.indexOf("OS ") !== -1) {
        let start = userAgent.indexOf("OS ") + 3;
        let end = userAgent.substring(start).indexOf(")");
        versionOS = userAgent
          .substring(start, end + start)
          .replace("_", ".")
          .replace(/[^\d.-]/g, "");
      }
    } else if (windowsPlatforms.indexOf(platform) !== -1) {
      detectedOS = "windows";
      let start = userAgent.indexOf("Windows");
      let end = userAgent.substring(start).indexOf(";");
      if (end === -1) {
        end = userAgent.substring(start).indexOf(")");
      }
      versionOS = userAgent
        .substring(start, end + start)
        .replace("_", ".")
        .replace(/[^\d.-]/g, "");
    } else if (/Android/.test(userAgent)) {
      detectedOS = "android";
      let start = userAgent.indexOf("Android");
      let end = userAgent.substring(start).indexOf(";");
      if (end === -1) {
        end = userAgent.substring(start).indexOf(")");
      }
      versionOS = userAgent
        .substring(start, end + start)
        .replace("_", ".")
        .replace(/[^\d.-]/g, "");
    } else if (/CrOS/.test(userAgent)) {
      detectedOS = "chromeos";
      let start = userAgent.indexOf("CrOS ") + 5;
      start = start + userAgent.substring(start).indexOf(" ");
      let end = userAgent.substring(start).indexOf(")");
      versionOS = userAgent
        .substring(start, end + start)
        .replace("_", ".")
        .replace(/[^\d.-]/g, "");
    } else if (detectedOS === "unknown" && /Linux/.test(platform)) {
      detectedOS = "linux";
    }

    return { detectedOS, versionOS };
  }

  /**
   * Returns the absolute path of the integration script.
   * @return {string} - Absolute path for the integration script.
   */
  getPath() {
    if (typeof this.scriptName === "undefined") {
      throw new Error("scriptName property needed for getPath.");
    }
    const col = document.getElementsByTagName("script");
    let path = "";
    for (let i = 0; i < col.length; i += 1) {
      const j = col[i].src.lastIndexOf(this.scriptName);
      if (j >= 0) {
        path = col[i].src.substr(0, j - 1);
      }
    }
    return path;
  }

  /**
   * Returns integration model plugin version
   * @param {string} - Plugin version
   */
  getVersion() {
    return this.version;
  }

  /**
   * Sets the language property.
   * @param {string} language - language code.
   */
  setLanguage(language) {
    this.language = language;
  }

  /**
   * Sets a Core instance.
   * @param {Core} core - instance of Core class.
   */
  setCore(core) {
    this.core = core;
    core.setIntegrationModel(this);
  }

  /**
   * Returns the Core instance.
   * @returns {Core} instance of Core class.
   */
  getCore() {
    return this.core;
  }

  /**
   * Sets the object target and updates the iframe property.
   * @param {HTMLElement} target - target object.
   */
  setTarget(target) {
    this.target = target;
    this.isIframe = this.target.tagName.toUpperCase() === "IFRAME";
  }

  /**
   * Sets the editor object.
   * @param {Object} editorObject - The editor object.
   */
  setEditorObject(editorObject) {
    this.editorObject = editorObject;
  }

  /**
   * Opens formula editor to editing a new formula. Can be overwritten in order to make some
   * actions from integration part before the formula is edited.
   */
  openNewFormulaEditor() {
    if (window.navigator.onLine) {
      this.core.editionProperties.dbclick = false;
      this.core.editionProperties.isNewElement = true;
      this.core.openModalDialog(this.target, this.isIframe);
    } else {
      let modal = document.getElementById("wrs_modal_offline");
      modal.style.display = "block";
    }
  }

  /**
   * Opens formula editor to editing an existing formula. Can be overwritten in order to make some
   * actions from integration part before the formula is edited.
   */
  openExistingFormulaEditor() {
    if (window.navigator.onLine) {
      this.core.editionProperties.isNewElement = false;
      this.core.openModalDialog(this.target, this.isIframe);
    } else {
      let modal = document.getElementById("wrs_modal_offline");
      modal.style.display = "block";
    }
  }

  /**
   * Wrapper to Core.updateFormula method.
   * Transform a MathML into a image formula.
   * Then the image formula is inserted in the specified target, creating a new image (new formula)
   * or updating an existing one.
   * @param {string} mathml - MathML to generate the formula.
   * @param {string} editMode - Edit Mode (LaTeX or images).
   */
  updateFormula(mathml) {
    if (this.editorParameters) {
      mathml = com.wiris.editor.util.EditorUtils.addAnnotation(
        mathml,
        "application/vnd.wiris.mtweb-params+json",
        JSON.stringify(this.editorParameters),
      );
    }
    let focusElement;
    let windowTarget;
    const wirisProperties = null;

    if (this.isIframe) {
      focusElement = this.target.contentWindow;
      windowTarget = this.target.contentWindow;
    } else {
      focusElement = this.target;
      windowTarget = window;
    }

    let obj = this.core.beforeUpdateFormula(mathml, wirisProperties);

    if (!obj) {
      return "";
    }

    obj = this.insertFormula(focusElement, windowTarget, obj.mathml, obj.wirisProperties);

    if (!obj) {
      return "";
    }

    return this.core.afterUpdateFormula(obj.focusElement, obj.windowTarget, obj.node, obj.latex);
  }

  /**
   * Wrapper to Core.insertFormula method.
   * Inserts the formula in the specified target, creating
   * a new image (new formula) or updating an existing one.
   * @param {string} mathml - MathML to generate the formula.
   * @param {string} editMode - Edit Mode (LaTeX or images).
   * @returns {ReturnObject} - Object with the information of the node or latex to insert.
   */
  insertFormula(focusElement, windowTarget, mathml, wirisProperties) {
    const obj = this.core.insertFormula(focusElement, windowTarget, mathml, wirisProperties);

    // Delete temporal image when inserted
    this.core.editionProperties.temporalImage = null;

    return obj;
  }

  /**
   * Returns the target selection.
   * @returns {Selection} target selection.
   */
  getSelection() {
    if (this.isIframe) {
      this.target.contentWindow.focus();
      return this.target.contentWindow.getSelection();
    }
    this.target.focus();
    return window.getSelection();
  }

  /**
   * Add events to formulas in the DOM target. The events added are the following:
   * - doubleClickHandler: handles Double-click event on formulas by opening an editor
   * to edit them.
   * - mouseDownHandler: handles mouse down event on formulas by saving the size of the formula
   * in case the the formula is resized.
   * - mouseUpHandler: handles mouse up event on formulas by restoring the saved formula size
   * in case the formula is resized.
   */
  addEvents() {
    const eventTarget = this.isIframe ? this.target.contentWindow.document : this.target;
    _util__WEBPACK_IMPORTED_MODULE_3__["default"].addElementEvents(
      eventTarget,
      (element, event) => {
        this.doubleClickHandler(element, event);
        // Avoid creating the double click listener more than once for each element.
        event.stopImmediatePropagation();
      },
      (element, event) => {
        this.mousedownHandler(element, event);
      },
      (element, event) => {
        this.mouseupHandler(element, event);
      },
    );
  }

  /**
   * Remove events to formulas in the DOM target.
   */
  removeEvents() {
    const eventTarget =
      this.isIframe && this.target.contentWindow?.document ? this.target.contentWindow.document : this.target;

    if (!eventTarget) {
      return;
    }

    _util__WEBPACK_IMPORTED_MODULE_3__["default"].removeElementEvents(eventTarget);
  }

  /**
   * Remove events, modals and set this.editorObject to null in order to prevent memory leaks.
   */
  destroy() {
    this.removeEvents();
    // Destroy modal dialog if exists.
    if (this.core.modalDialog) {
      this.core.modalDialog.destroy();
    }

    // Remove offline modal dialog if exists.
    if (this.offlineModal) {
      this.offlineModal.remove();
    }

    this.editorObject = null;
  }

  /**
   * Handles a Double-click on the target element. Opens an editor
   * to re-edit the double-clicked formula.
   * @param {HTMLElement} element - DOM object target.
   */
  doubleClickHandler(element) {
    this.core.editionProperties.dbclick = true;
    if (element.nodeName.toLowerCase() === "img") {
      this.core.getCustomEditors().disable();
      const customEditorAttributeName = _configuration__WEBPACK_IMPORTED_MODULE_4__["default"].get("imageCustomEditorName");
      if (element.hasAttribute(customEditorAttributeName)) {
        const customEditor = element.getAttribute(customEditorAttributeName);
        this.core.getCustomEditors().enable(customEditor);
      }
      if (_util__WEBPACK_IMPORTED_MODULE_3__["default"].containsClass(element, _configuration__WEBPACK_IMPORTED_MODULE_4__["default"].get("imageClassName"))) {
        this.core.editionProperties.temporalImage = element;
        this.core.editionProperties.isNewElement = true;
        this.openExistingFormulaEditor();
      }
    }
  }

  /**
   * Handles a mouse up event on the target element. Restores the image size to avoid
   * resizing formulas.
   */
  mouseupHandler() {
    if (this.temporalImageResizing) {
      setTimeout(() => {
        _image__WEBPACK_IMPORTED_MODULE_1__["default"].fixAfterResize(this.temporalImageResizing);
      }, 10);
    }
  }

  /**
   * Handles a mouse down event on the target element. Saves the formula size to avoid
   * resizing formulas.
   * @param {HTMLElement} element - target element.
   */
  mousedownHandler(element) {
    if (element.nodeName.toLowerCase() === "img") {
      if (_util__WEBPACK_IMPORTED_MODULE_3__["default"].containsClass(element, _configuration__WEBPACK_IMPORTED_MODULE_4__["default"].get("imageClassName"))) {
        this.temporalImageResizing = element;
      }
    }
  }

  /**
   * Returns the integration language. By default the browser agent. This method
   * should be overwritten to obtain the integration language, for example using the
   * plugin API of an HTML editor.
   * @returns {string} integration language.
   */
  getLanguage() {
    return this.getBrowserLanguage();
  }

  /**
   * Returns the browser language.
   * @returns {string} the browser language.
   */
  // eslint-disable-next-line class-methods-use-this
  getBrowserLanguage() {
    let language = "en";
    if (navigator.userLanguage) {
      language = navigator.userLanguage.substring(0, 2);
    } else if (navigator.language) {
      language = navigator.language.substring(0, 2);
    } else {
      language = "en";
    }
    return language;
  }

  /**
   * This function is called once the {@link Core} is loaded. IntegrationModel class
   * will fire this method when {@link Core} 'onLoad' event is fired.
   * This method should content all the logic to init
   * the integration.
   */
  callbackFunction() {
    // It's needed to wait until the integration target is ready. The event is fired
    // from the integration side.
    const listener = _listeners__WEBPACK_IMPORTED_MODULE_2__["default"].newListener("onTargetReady", () => {
      this.addEvents(this.target);
    });
    this.listeners.add(listener);
  }

  /**
   * Function called when the content submits an action.
   */
  // eslint-disable-next-line class-methods-use-this
  notifyWindowClosed() {
    // Nothing.
  }

  /**
   * Wrapper.
   * Extracts mathml of a determined text node. This function is used as a wrapper inside core.js
   * in order to get mathml from a text node that can contain normal LaTeX or other chosen text.
   * @param {string} textNode - text node to extract the MathML.
   * @param {int} caretPosition - caret position inside the text node.
   * @returns {string} MathML inside the text node.
   */

  // eslint-disable-next-line class-methods-use-this, no-unused-vars
  getMathmlFromTextNode(textNode, caretPosition) {}

  /**
   * Wrapper
   * It fills wrs event object of nonLatex with the desired data.
   * @param {Object} event - event object.
   * @param {Object} window dom window object.
   * @param {string} mathml valid mathml.
   */
  // eslint-disable-next-line class-methods-use-this, no-unused-vars
  fillNonLatexNode(event, window, mathml) {}

  /**
    Wrapper.
   * Returns selected item from the target.
   * @param {HTMLElement} target - target element
   * @param {boolean} iframe
   */
  // eslint-disable-next-line class-methods-use-this, no-unused-vars
  getSelectedItem(target, isIframe) {}

  // Set temporal image to null and make focus come back.
  static setActionsOnCancelButtons() {
    // Make focus come back on the previous place it was when click cancel button
    const currentInstance = WirisPlugin.currentInstance;
    const editorSelection = currentInstance.getSelection();
    editorSelection.removeAllRanges();

    if (currentInstance.core.editionProperties.range) {
      const { range } = currentInstance.core.editionProperties;
      currentInstance.core.editionProperties.range = null;
      editorSelection.addRange(range);
      if (range.startOffset !== range.endOffset) {
        currentInstance.core.placeCaretAfterNode(currentInstance.core.editionProperties.temporalImage);
      }
    }

    // eslint-disable-next-line no-undef
    if (WirisPlugin.currentInstance) {
      WirisPlugin.currentInstance.core.editionProperties.temporalImage = null; // eslint-disable-line
    }
  }
}

// To know if the integration that extends this class implements
// wrapper methods, they are set as undefined.
IntegrationModel.prototype.getMathmlFromTextNode = undefined;
IntegrationModel.prototype.fillNonLatexNode = undefined;
IntegrationModel.prototype.getSelectedItem = undefined;

/**
 * An object containing a list with the overwritable class constructor properties.
 * @type {Object}
 */
IntegrationModel.integrationParameters = ["serviceProviderProperties", "editorParameters"];


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/jsvariables.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/jsvariables.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Represents the configuration properties generated from the frontend (JavaScript variables).
 * @type {Object}
 * @property {string} imageClassName - Default MathType formula image class.
 * @property {string} imageClassName - Default MathType CAS image class.
 * @ignore
 */
const jsProperties = {
  imageCustomEditorName: "data-custom-editor",
  imageClassName: "Wirisformula",
  CASClassName: "Wiriscas",
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (jsProperties);


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/latex.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/latex.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Latex)
/* harmony export */ });
/* harmony import */ var _textcache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./textcache */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/textcache.js");
/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mathml */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js");
/* harmony import */ var _serviceprovider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serviceprovider */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/serviceprovider.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/constants.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");






/**
 * @classdesc
 * This class represents a LaTeX parser. Manages the services which allows to convert
 * LaTeX into MathML and MathML into LaTeX.
 */
class Latex {
  /**
   * Static property.
   * Return latex cache.
   * @private
   * @type {Cache}
   */
  static get cache() {
    return Latex._cache;
  }

  /**
   * Static property setter.
   * Set latex cache.
   * @param {Cache} value - The property value.
   * @ignore
   */
  static set cache(value) {
    Latex._cache = value;
  }

  /**
   * Converts MathML to LaTeX by calling mathml2latex service. For text services
   * we call a text service with the param mathml2latex.
   * @param {String} mathml - MathML String.
   * @return {String} LaTeX string generated by the MathML argument.
   */
  static getLatexFromMathML(mathml) {
    const mathmlWithoutSemantics = _mathml__WEBPACK_IMPORTED_MODULE_1__["default"].removeSemantics(mathml);
    /**
     * @type {TextCache}
     */
    const { cache } = Latex;

    const data = {
      service: "mathml2latex",
      mml: mathmlWithoutSemantics,
    };

    const jsonResponse = JSON.parse(_serviceprovider__WEBPACK_IMPORTED_MODULE_2__["default"].getService("service", data));

    // TODO: Error handling.
    let latex = "";

    if (jsonResponse.status === "ok") {
      latex = jsonResponse.result.text;
      const latexHtmlEntitiesEncoded = _util__WEBPACK_IMPORTED_MODULE_4__["default"].htmlEntities(latex);
      // Inserting LaTeX semantics.
      const mathmlWithSemantics = _mathml__WEBPACK_IMPORTED_MODULE_1__["default"].addAnnotation(mathml, latexHtmlEntitiesEncoded, "LaTeX");
      cache.populate(latex, mathmlWithSemantics);
    }

    return latex;
  }

  /**
   * Converts LaTeX to MathML by calling latex2mathml service. For text services
   * we call a text service with the param latex2mathml.
   * @param {String} latex - String containing a LaTeX formula.
   * @param {Boolean} includeLatexOnSemantics
   * - If true LaTeX would me included into MathML semantics.
   * @return {String} MathML string generated by the LaTeX argument.
   */
  static getMathMLFromLatex(latex, includeLatexOnSemantics) {
    /**
     * @type {TextCache}
     */
    const latexCache = Latex.cache;

    if (Latex.cache.get(latex)) {
      return Latex.cache.get(latex);
    }
    const data = {
      service: "latex2mathml",
      latex,
    };

    if (includeLatexOnSemantics) {
      data.saveLatex = "";
    }

    const jsonResponse = JSON.parse(_serviceprovider__WEBPACK_IMPORTED_MODULE_2__["default"].getService("service", data));

    let output;
    if (jsonResponse.status === "ok") {
      let mathml = jsonResponse.result.text;
      mathml = mathml.split("\r").join("").split("\n").join(" ");

      // Populate LatexCache.
      if (mathml.indexOf("semantics") === -1 && mathml.indexOf("annotation") === -1) {
        const content = _util__WEBPACK_IMPORTED_MODULE_4__["default"].htmlEntities(latex);
        mathml = _mathml__WEBPACK_IMPORTED_MODULE_1__["default"].addAnnotation(mathml, content, "LaTeX");
        output = mathml;
      } else {
        output = mathml;
      }
      if (!latexCache.get(latex)) {
        latexCache.populate(latex, mathml);
      }
    } else {
      output = `$$${latex}$$`;
    }
    return output;
  }

  /**
   * Converts all occurrences of MathML code to LaTeX.
   * The MathML code should containing <annotation encoding="LaTeX"/> to be converted.
   * @param {String} content - A string containing MathML valid code.
   * @param {Object} characters - An object containing special characters.
   * @return {String} A string containing all MathML annotated occurrences
   * replaced by the corresponding LaTeX code.
   */
  static parseMathmlToLatex(content, characters) {
    let output = "";
    const mathTagBegin = `${characters.tagOpener}math`;
    const mathTagEnd = `${characters.tagOpener}/math${characters.tagCloser}`;
    const openTarget = `${characters.tagOpener}annotation encoding=${characters.doubleQuote}LaTeX${characters.doubleQuote}${characters.tagCloser}`;
    const closeTarget = `${characters.tagOpener}/annotation${characters.tagCloser}`;
    let start = content.indexOf(mathTagBegin);
    let end = 0;
    let mathml;
    let startAnnotation;
    let closeAnnotation;

    while (start !== -1) {
      output += content.substring(end, start);
      end = content.indexOf(mathTagEnd, start);

      if (end === -1) {
        end = content.length - 1;
      } else {
        end += mathTagEnd.length;
      }

      mathml = content.substring(start, end);

      startAnnotation = mathml.indexOf(openTarget);
      if (startAnnotation !== -1) {
        startAnnotation += openTarget.length;
        closeAnnotation = mathml.indexOf(closeTarget);
        let latex = mathml.substring(startAnnotation, closeAnnotation);
        if (characters === _constants__WEBPACK_IMPORTED_MODULE_3__["default"].safeXmlCharacters) {
          latex = _mathml__WEBPACK_IMPORTED_MODULE_1__["default"].safeXmlDecode(latex);
        }
        output += `$$${latex}$$`;
        // Populate latex into cache.

        Latex.cache.populate(latex, mathml);
      } else {
        output += mathml;
      }
      start = content.indexOf(mathTagBegin, end);
    }

    output += content.substring(end, content.length);
    return output;
  }

  /**
   * Extracts the latex of a determined position in a text.
   * @param {Node} textNode - textNode to extract the LaTeX
   * @param {Number} caretPosition - Starting position to find LaTeX.
   * @param {Object} latexTags - Optional parameter representing tags between latex is inserted.
   * It has the 'open' attribute for the open tag and the 'close' attribute for the close tag.
   * "$$" by default.
   * @return {Object} An object with 3 keys: 'latex', 'start' and 'end'. Null if latex is not found.
   * @static
   */
  static getLatexFromTextNode(textNode, caretPosition, latexTags) {
    // TODO: Set LaTeX Tags as Core variable. Fix the call to this function (third argument).
    // Tags used for LaTeX formulas.
    const defaultLatexTags = {
      open: "$$",
      close: "$$",
    };
    // latexTags is an optional parameter. If is not set, use default latexTags.
    if (typeof latexTags === "undefined" || latexTags == null) {
      latexTags = defaultLatexTags;
    }
    // Looking for the first textNode.
    let startNode = textNode;

    while (startNode.previousSibling && startNode.previousSibling.nodeType === 3) {
      // TEXT_NODE.
      startNode = startNode.previousSibling;
    }

    /**
     * Returns the next latex position and node from a specific node and position.
     * @param {Node} currentNode - Node where searching latex.
     * @param {Number} currentPosition - Current position inside the currentNode.
     * @param {Object} latexTagsToUse - Tags used at latex beginning and latex final.
     * "$$" by default.
     * @param {Boolean} tag - Tag containing the current search.
     * @returns {Object} Object containing the current node and the position.
     */
    function getNextLatexPosition(currentNode, currentPosition, tag) {
      let position = currentNode.nodeValue.indexOf(tag, currentPosition);

      while (position === -1) {
        currentNode = currentNode.nextSibling;

        if (!currentNode) {
          // TEXT_NODE.
          return null; // Not found.
        }

        position = currentNode.nodeValue ? currentNode.nodeValue.indexOf(latexTags.close) : -1;
      }

      return {
        node: currentNode,
        position,
      };
    }

    /**
     * Determines if a node is previous, or not, to a second one.
     * @param {Node} node - Start node.
     * @param {Number} position - Start node position.
     * @param {Node} endNode - End node.
     * @param {Number} endPosition - End node position.
     * @returns {Boolean} True if the starting node is previous thant the en node. false otherwise.
     */
    function isPrevious(node, position, endNode, endPosition) {
      if (node === endNode) {
        return position <= endPosition;
      }
      while (node && node !== endNode) {
        node = node.nextSibling;
      }

      return node === endNode;
    }

    let start;
    let end = {
      node: startNode,
      position: 0,
    };
    // Is supposed that open and close tags has the same length.
    const tagLength = latexTags.open.length;
    do {
      start = getNextLatexPosition(end.node, end.position, latexTags.open);

      if (start == null || isPrevious(textNode, caretPosition, start.node, start.position)) {
        return null;
      }

      end = getNextLatexPosition(start.node, start.position + tagLength, latexTags.close);

      if (end == null) {
        return null;
      }

      end.position += tagLength;
    } while (isPrevious(end.node, end.position, textNode, caretPosition));

    // Isolating latex.
    let latex;

    if (start.node === end.node) {
      latex = start.node.nodeValue.substring(start.position + tagLength, end.position - tagLength);
    } else {
      const index = start.position + tagLength;
      latex = start.node.nodeValue.substring(index, start.node.nodeValue.length);
      let currentNode = start.node;

      do {
        currentNode = currentNode.nextSibling;
        if (currentNode === end.node) {
          latex += end.node.nodeValue.substring(0, end.position - tagLength);
        } else {
          latex += currentNode.nodeValue ? currentNode.nodeValue : "";
        }
      } while (currentNode !== end.node);
    }

    return {
      latex,
      startNode: start.node,
      startPosition: start.position,
      endNode: end.node,
      endPosition: end.position,
    };
  }
}

/**
 * Text cache. Stores all processed LaTeX strings and it's correspondent MathML string.
 * @type {Cache}
 * @static
 */
Latex._cache = new _textcache__WEBPACK_IMPORTED_MODULE_0__["default"]();


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Listeners)
/* harmony export */ });
/**
 * This object represents a custom listener.
 * @typedef {Object} Listener
 * @property {String} Listener.eventName - The listener name.
 * @property {Function} Listener.callback - The listener callback function.
 */

class Listeners {
  /**
   * @classdesc
   * This class represents a custom listeners manager.
   * @constructs
   */
  constructor() {
    /**
     * Array containing all custom listeners.
     * @type {Object[]}
     */
    this.listeners = [];
  }

  /**
   * Add a listener to Listener class.
   * @param {Object} listener - A listener object.
   */
  add(listener) {
    this.listeners.push(listener);
  }

  /**
   * Fires MathType event listeners
   * @param {String} eventName - event name
   * @param {Event} event - event object.
   * @return {boolean} false if event has been prevented. true otherwise.
   */
  fire(eventName, event) {
    for (let i = 0; i < this.listeners.length && !event.cancelled; i += 1) {
      if (this.listeners[i].eventName === eventName) {
        // Calling listener.
        this.listeners[i].callback(event);
      }
    }
    return event.defaultPrevented;
  }

  /**
   * Creates a new listener object.
   * @param {string} eventName - Event name.
   * @param {Object} callback - Callback function.
   * @returns {object} the listener object.
   */
  static newListener(eventName, callback) {
    const listener = {};
    listener.eventName = eventName;
    listener.callback = callback;
    return listener;
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MathML)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/constants.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");



/**
 * @classdesc
 * This class represents a class to manage MathML objects.
 */
class MathML {
  /**
   * Checks if the mathml at position i is inside an HTML attribute or not.
   * @param {string} content - a string containing MathML code.
   * @param {number} i -  search index.
   * @return {boolean} true if is inside an HTML attribute. false otherwise.
   */
  static isMathmlInAttribute(content, i) {
    // Regex =
    // '^[\'"][\\s]*=[\\s]*[\\w-]+([\\s]*("[^"]*"|\'[^\']*\')[\\s]*
    // =[\\s]*[\\w-]+[\\s]*)*[\\s]+gmi<';
    const mathAtt = "['\"][\\s]*=[\\s]*[\\w-]+"; // "=att OR '=att
    const attContent = "\"[^\"]*\"|'[^']*'"; // "blabla" OR 'blabla'
    const att = `[\\s]*(${attContent})[\\s]*=[\\s]*[\\w-]+[\\s]*`; // "blabla"=att OR 'blabla'=att
    const atts = `('${att}')*`; // "blabla"=att1 "blabla"=att2
    const regex = `^${mathAtt}${atts}[\\s]+gmi<`; // "=att "blabla"=att1 "blabla"=att2 gmi< .
    const expression = new RegExp(regex);

    const actualContent = content.substring(0, i);
    const reversed = actualContent.split("").reverse().join("");
    const exists = expression.test(reversed);

    return exists;
  }

  /**
   * Decodes an encoded MathML with standard XML tags.
   * We use these entities because IE doesn't support html entities
   * on its attributes sometimes. Yes, sometimes.
   * @param {string} input - string to be decoded.
   * @return {string} decoded string.
   */
  static safeXmlDecode(input) {
    let { tagOpener } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharactersEntities;
    let { tagCloser } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharactersEntities;
    let { doubleQuote } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharactersEntities;
    let { realDoubleQuote } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharactersEntities;
    // Decoding entities.
    input = input.split(tagOpener).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.tagOpener);
    input = input.split(tagCloser).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.tagCloser);
    input = input.split(doubleQuote).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.doubleQuote);
    // Added to fix problem due to import from 1.9.x.
    input = input.split(realDoubleQuote).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.realDoubleQuote);

    // Blackboard.
    const { ltElement } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeBadBlackboardCharacters;
    const { gtElement } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeBadBlackboardCharacters;
    const { ampElement } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeBadBlackboardCharacters;
    if ("_wrs_blackboard" in window && window._wrs_blackboard) {
      input = input.split(ltElement).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeGoodBlackboardCharacters.ltElement);
      input = input.split(gtElement).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeGoodBlackboardCharacters.gtElement);
      input = input.split(ampElement).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeGoodBlackboardCharacters.ampElement);
    }

    ({ tagOpener } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters);
    ({ tagCloser } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters);
    ({ doubleQuote } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters);
    ({ realDoubleQuote } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters);
    const { ampersand } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters;
    const { quote } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters;

    // Decoding characters.
    input = input.split(tagOpener).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters.tagOpener);
    input = input.split(tagCloser).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters.tagCloser);
    input = input.split(doubleQuote).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters.doubleQuote);
    input = input.split(ampersand).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters.ampersand);
    input = input.split(quote).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters.quote);

    // We are replacing $ by & when its part of an entity for retro-compatibility.
    // Now, the standard is replace § by &.
    let returnValue = "";
    let currentEntity = null;

    for (let i = 0; i < input.length; i += 1) {
      const character = input.charAt(i);
      if (currentEntity == null) {
        if (character === "$") {
          currentEntity = "";
        } else {
          returnValue += character;
        }
      } else if (character === ";") {
        returnValue += `&${currentEntity}`;
        currentEntity = null;
      } else if (character.match(/([a-zA-Z0-9#._-] | '-')/)) {
        // Character is part of an entity.
        currentEntity += character;
      } else {
        returnValue += `$${currentEntity}`; // Is not an entity.
        currentEntity = null;
        i -= 1; // Parse again the current character.
      }
    }

    return returnValue;
  }

  /**
   * Encodes a MathML with standard XML tags to a MMathML encoded with safe XML tags.
   * We use these entities because IE doesn't support html entities on its attributes sometimes.
   * @param {string} input - input string to be encoded
   * @returns {string} encoded string.
   */
  static safeXmlEncode(input) {
    const { tagOpener } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters;
    const { tagCloser } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters;
    const { doubleQuote } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters;
    const { ampersand } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters;
    const { quote } = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters;

    input = input.split(tagOpener).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.tagOpener);
    input = input.split(tagCloser).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.tagCloser);
    input = input.split(doubleQuote).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.doubleQuote);
    input = input.split(ampersand).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.ampersand);
    input = input.split(quote).join(_constants__WEBPACK_IMPORTED_MODULE_0__["default"].safeXmlCharacters.quote);

    return input;
  }

  /**
   * Converts special symbols (> 128) to entities and replaces all textual
   * entities by its number entities.
   * @param {string} mathml - MathML string containing - or not - special symbols
   * @returns {string} MathML with all textual entities replaced.
   */
  static mathMLEntities(mathml) {
    let toReturn = "";

    for (let i = 0; i < mathml.length; i += 1) {
      const character = mathml.charAt(i);

      // Parsing > 128 characters.
      if (mathml.codePointAt(i) > 128) {
        toReturn += `&#${mathml.codePointAt(i)};`;
        // For UTF-32 characters we need to move the index one position.
        if (mathml.codePointAt(i) > 0xffff) {
          i += 1;
        }
      } else if (character === "&") {
        const end = mathml.indexOf(";", i + 1);
        if (end >= 0) {
          const container = document.createElement("span");
          container.innerHTML = mathml.substring(i, end + 1);
          toReturn += `&#${_util__WEBPACK_IMPORTED_MODULE_1__["default"].fixedCharCodeAt(container.textContent || container.innerText, 0)};`;
          i = end;
        } else {
          toReturn += character;
        }
      } else {
        toReturn += character;
      }
    }

    return toReturn;
  }

  /**
   * Add a custom editor name with the prefix wrs_ to a MathML class attribute.
   * @param {string} mathml - a MathML string created with a custom editor, like chemistry.
   * @param {string} customEditor - custom editor name.
   * @returns {string} MathML string with his class containing the editor toolbar string.
   */
  static addCustomEditorClassAttribute(mathml, customEditor) {
    let toReturn = "";

    const start = mathml.indexOf("<math");
    if (start === 0) {
      const end = mathml.indexOf(">");
      if (mathml.indexOf("class") === -1) {
        // Adding custom editor type.
        toReturn = `${mathml.substr(start, end)} class="wrs_${customEditor}">`;
        toReturn += mathml.substr(end + 1, mathml.length);
        return toReturn;
      }
    }
    return mathml;
  }

  /**
   * Remove a custom editor name from the MathML class attribute.
   * @param {string} mathml - a MathML string.
   * @param {string} customEditor - custom editor name.
   * @returns {string} The input MathML without customEditor name in his class.
   */
  static removeCustomEditorClassAttribute(mathml, customEditor) {
    // Discard MathML without the specified class.
    if (mathml.indexOf("class") === -1 || mathml.indexOf(`wrs_${customEditor}`) === -1) {
      return mathml;
    }

    // Trivial case: class attribute value equal to editor name. Then
    // class attribute is removed.
    // First try to remove it with a space before if there is one
    // Otherwise without the space
    if (mathml.indexOf(` class="wrs_${customEditor}"`) !== -1) {
      return mathml.replace(` class="wrs_${customEditor}"`, "");
    } else if (mathml.indexOf(`class="wrs_${customEditor}"`) !== -1) {
      return mathml.replace(`class="wrs_${customEditor}"`, "");
    }

    // Non Trivial case: class attribute contains editor name.
    return mathml.replace(`wrs_${customEditor}`, "");
  }

  /**
   * Adds annotation tag in MathML element.
   * @param {String} mathml - valid MathML.
   * @param {String} content - value to put inside annotation tag.
   * @param {String} annotationEncoding - annotation encoding.
   * @returns {String} - 'mathml' with an annotation that contains
   * 'content' and encoding 'encoding'.
   */
  static addAnnotation(mathml, content, annotationEncoding) {
    // If contains annotation, also contains semantics tag.
    const containsAnnotation = mathml.indexOf("<annotation");

    let mathmlWithAnnotation = "";
    if (containsAnnotation !== -1) {
      const closeSemanticsIndex = mathml.indexOf("</semantics>");
      mathmlWithAnnotation = `${mathml.substring(0, closeSemanticsIndex)}<annotation encoding="${annotationEncoding}">${content}</annotation>${mathml.substring(closeSemanticsIndex)}`;
    } else if (MathML.isEmpty(mathml)) {
      const endIndexInline = mathml.indexOf("/>");
      const endIndexNonInline = mathml.indexOf(">");
      const endIndex = endIndexNonInline === endIndexInline ? endIndexInline : endIndexNonInline;
      mathmlWithAnnotation = `${mathml.substring(0, endIndex)}><semantics><annotation encoding="${annotationEncoding}">${content}</annotation></semantics></math>`;
    } else {
      const beginMathMLContent = mathml.indexOf(">") + 1;
      const endMathmlContent = mathml.lastIndexOf("</math>");
      const mathmlContent = mathml.substring(beginMathMLContent, endMathmlContent);
      mathmlWithAnnotation = `${mathml.substring(0, beginMathMLContent)}<semantics><mrow>${mathmlContent}</mrow><annotation encoding="${annotationEncoding}">${content}</annotation></semantics></math>`; // eslint-disable-line max-len
    }

    return mathmlWithAnnotation;
  }

  /**
   * Removes specific annotation tag in MathML element.
   * In case of remove the unique annotation, also is removed semantics tag.
   * @param {String} mathml - valid MathML.
   * @param {String} annotationEncoding - annotation encoding to remove.
   * @returns {String} - 'mathml' without the annotation encoding specified.
   */
  static removeAnnotation(mathml, annotationEncoding) {
    let mathmlWithoutAnnotation = mathml;
    const openAnnotationTag = `<annotation encoding="${annotationEncoding}">`;
    const closeAnnotationTag = "</annotation>";
    const startAnnotationIndex = mathml.indexOf(openAnnotationTag);
    if (startAnnotationIndex !== -1) {
      let differentAnnotationFound = false;
      let differentAnnotationIndex = mathml.indexOf("<annotation");
      while (differentAnnotationIndex !== -1) {
        if (differentAnnotationIndex !== startAnnotationIndex) {
          differentAnnotationFound = true;
        }
        differentAnnotationIndex = mathml.indexOf("<annotation", differentAnnotationIndex + 1);
      }

      if (differentAnnotationFound) {
        const closeIndex = mathml.indexOf(closeAnnotationTag, startAnnotationIndex);
        const endAnnotationIndex = closeIndex + closeAnnotationTag.length;
        const startIndex = mathml.substring(0, startAnnotationIndex);
        mathmlWithoutAnnotation = startIndex + mathml.substring(endAnnotationIndex);
      } else {
        mathmlWithoutAnnotation = MathML.removeSemantics(mathml);
      }
    }

    return mathmlWithoutAnnotation;
  }

  /**
   * Removes semantics tag to mathml.
   * When using Hand to create formulas, it adds the mrow tag due to the semantics one, this one is also removed.
   * @param {string} mathml - MathML string.
   * @returns {string} - 'mathml' without semantics tag.
   */
  static removeSemantics(mathml) {
    // If `mrow` is found right before the `semantics` starting tag, it's removed as well
    const semanticsStartingTagRegex = /<semantics>\s*?(<mrow>)?/gm;

    // If `mrow` is found right after the `annotation` ending tag, it's removed as well
    // alongside `semantics` closing tag and the whole `annotation` tag and its contents.
    const semanticsEndingTagRegex = /(<\/mrow>)?\s*<annotation[\W\w]*?<\/semantics>/gm;

    return mathml.replace(semanticsStartingTagRegex, "").replace(semanticsEndingTagRegex, "");
  }

  /**
   * Removes semantics tag to element that contains mathml.
   * When using Hand to create formulas, it adds the mrow tag due to the semantics one, this one is also removed.
   * @param {string} element - Inner HTML text string.
   * @returns {string} - 'mathml' without semantics tag.
   */
  static removeSafeXMLSemantics(element) {
    // If `mrow` is found right before the `semantics` starting tag, it's removed as well
    const semanticsSafeStartingTagRegex = /«semantics»\s*?(«mrow»)?/gm;

    // If `mrow` is found right after the `annotation` ending tag, it's removed as well
    // alongside `semantics` closing tag and the whole `annotation` tag and its contents.
    const semanticsSafeEndingTagRegex = /(«\/mrow»)?\s*«annotation[\W\w]*?«\/semantics»/gm;

    return element.replace(semanticsSafeStartingTagRegex, "").replace(semanticsSafeEndingTagRegex, "");
  }

  /**
   * Transforms all xml mathml occurrences that contain semantics to the same
   * xml mathml occurrences without semantics.
   * @param {string} text - string that can contain xml mathml occurrences.
   * @param {Constants} [characters] - Constant object containing xmlCharacters
   * or safeXmlCharacters relation.
   * xmlCharacters by default.
   * @returns {string} - 'text' with all xml mathml occurrences without annotation tag.
   */
  static removeSemanticsOcurrences(text, characters = _constants__WEBPACK_IMPORTED_MODULE_0__["default"].xmlCharacters) {
    const mathTagStart = `${characters.tagOpener}math`;
    const mathTagEnd = `${characters.tagOpener}/math${characters.tagCloser}`;
    const mathTagEndline = `/${characters.tagCloser}`;
    const { tagCloser } = characters;
    const semanticsTagStart = `${characters.tagOpener}semantics${characters.tagCloser}`;
    const annotationTagStart = `${characters.tagOpener}annotation encoding=`;

    let output = "";
    let start = text.indexOf(mathTagStart);
    let end = 0;
    while (start !== -1) {
      output += text.substring(end, start);

      // MathML can be written as '<math></math>' or '<math />'.
      const mathTagEndIndex = text.indexOf(mathTagEnd, start);
      const mathTagEndlineIndex = text.indexOf(mathTagEndline, start);
      const firstTagCloser = text.indexOf(tagCloser, start);
      if (mathTagEndIndex !== -1) {
        end = mathTagEndIndex;
      } else if (mathTagEndlineIndex === firstTagCloser - 1) {
        end = mathTagEndlineIndex;
      }

      const semanticsIndex = text.indexOf(semanticsTagStart, start);
      if (semanticsIndex !== -1) {
        const mmlTagStart = text.substring(start, semanticsIndex);
        const annotationIndex = text.indexOf(annotationTagStart, start);
        if (annotationIndex !== -1) {
          const startIndex = semanticsIndex + semanticsTagStart.length;
          const mmlContent = text.substring(startIndex, annotationIndex);
          output += mmlTagStart + mmlContent + mathTagEnd;
          start = text.indexOf(mathTagStart, start + mathTagStart.length);
          end += mathTagEnd.length;
        } else {
          end = start;
          start = text.indexOf(mathTagStart, start + mathTagStart.length);
        }
      } else {
        end = start;
        start = text.indexOf(mathTagStart, start + mathTagStart.length);
      }
    }

    output += text.substring(end, text.length);
    return output;
  }

  /**
   * Returns true if a MathML contains a certain class.
   * @param {string} mathML - input MathML.
   * @param {string} className - className.
   * @returns {boolean} true if the input MathML contains the input class.
   * false otherwise.
   * @static
   */
  static containClass(mathML, className) {
    const classIndex = mathML.indexOf("class");
    if (classIndex === -1) {
      return false;
    }
    const classTagEndIndex = mathML.indexOf(">", classIndex);
    const classTag = mathML.substring(classIndex, classTagEndIndex);
    if (classTag.indexOf(className) !== -1) {
      return true;
    }
    return false;
  }

  /**
   * Returns true if mathml is empty. Otherwise, false.
   * @param {string} mathml - valid MathML with standard XML tags.
   * @returns {boolean} - true if mathml is empty. Otherwise, false.
   */
  static isEmpty(mathml) {
    // MathML can have the shape <math></math> or '<math />'.
    const closeTag = ">";
    const closeTagInline = "/>";
    const firstCloseTagIndex = mathml.indexOf(closeTag);
    const firstCloseTagInlineIndex = mathml.indexOf(closeTagInline);
    let empty = false;
    // MathML is always empty in the second shape.
    if (firstCloseTagInlineIndex !== -1) {
      if (firstCloseTagInlineIndex === firstCloseTagIndex - 1) {
        empty = true;
      }
    }

    // MathML is always empty in the first shape when there aren't elements
    // between math tags.
    if (!empty) {
      const mathTagEndRegex = new RegExp("</(.+:)?math>");
      const mathTagEndArray = mathTagEndRegex.exec(mathml);
      if (mathTagEndArray) {
        empty = firstCloseTagIndex + 1 === mathTagEndArray.index;
      }
    }

    return empty;
  }

  /**
   * Encodes html entities inside properties.
   * @param {String} mathml - valid MathML with standard XML tags.
   * @returns {String} - 'mathml' with property entities encoded.
   */
  static encodeProperties(mathml) {
    // Search all the properties.
    const regex = /\w+=".*?"/g;
    // Encode html entities.
    const replacer = (match) => {
      // It has the shape:
      // <math propertyOne="somethingOne"><children propertyTwo="somethingTwo"></children></math>.
      const quoteIndex = match.indexOf('"');
      const propertyValue = match.substring(quoteIndex + 1, match.length - 1);
      const propertyValueEncoded = _util__WEBPACK_IMPORTED_MODULE_1__["default"].htmlEntities(propertyValue);
      const matchEncoded = `${match.substring(0, quoteIndex + 1)}${propertyValueEncoded}"`;
      return matchEncoded;
    };

    const mathmlEncoded = mathml.replace(regex, replacer);
    return mathmlEncoded;
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/md5.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/md5.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable */
var md5;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (md5);

(function () {
  var HxOverrides = function () {};
  HxOverrides.__name__ = true;
  HxOverrides.dateStr = function (date) {
    var m = date.getMonth() + 1;
    var d = date.getDate();
    var h = date.getHours();
    var mi = date.getMinutes();
    var s = date.getSeconds();
    return (
      date.getFullYear() +
      "-" +
      (m < 10 ? "0" + m : "" + m) +
      "-" +
      (d < 10 ? "0" + d : "" + d) +
      " " +
      (h < 10 ? "0" + h : "" + h) +
      ":" +
      (mi < 10 ? "0" + mi : "" + mi) +
      ":" +
      (s < 10 ? "0" + s : "" + s)
    );
  };
  HxOverrides.strDate = function (s) {
    switch (s.length) {
      case 8:
        var k = s.split(":");
        var d = new Date();
        d.setTime(0);
        d.setUTCHours(k[0]);
        d.setUTCMinutes(k[1]);
        d.setUTCSeconds(k[2]);
        return d;
      case 10:
        var k = s.split("-");
        return new Date(k[0], k[1] - 1, k[2], 0, 0, 0);
      case 19:
        var k = s.split(" ");
        var y = k[0].split("-");
        var t = k[1].split(":");
        return new Date(y[0], y[1] - 1, y[2], t[0], t[1], t[2]);
      default:
        throw "Invalid date format : " + s;
    }
  };
  HxOverrides.cca = function (s, index) {
    var x = s.charCodeAt(index);
    if (x != x) return undefined;
    return x;
  };
  HxOverrides.substr = function (s, pos, len) {
    if (pos != null && pos != 0 && len != null && len < 0) return "";
    if (len == null) len = s.length;
    if (pos < 0) {
      pos = s.length + pos;
      if (pos < 0) pos = 0;
    } else if (len < 0) len = s.length + len - pos;
    return s.substr(pos, len);
  };
  HxOverrides.remove = function (a, obj) {
    var i = 0;
    var l = a.length;
    while (i < l) {
      if (a[i] == obj) {
        a.splice(i, 1);
        return true;
      }
      i++;
    }
    return false;
  };
  HxOverrides.iter = function (a) {
    return {
      cur: 0,
      arr: a,
      hasNext: function () {
        return this.cur < this.arr.length;
      },
      next: function () {
        return this.arr[this.cur++];
      },
    };
  };
  var IntIter = function (min, max) {
    this.min = min;
    this.max = max;
  };
  IntIter.__name__ = true;
  IntIter.prototype = {
    next: function () {
      return this.min++;
    },
    hasNext: function () {
      return this.min < this.max;
    },
    __class__: IntIter,
  };
  var Std = function () {};
  Std.__name__ = true;
  Std["is"] = function (v, t) {
    return js.Boot.__instanceof(v, t);
  };
  Std.string = function (s) {
    return js.Boot.__string_rec(s, "");
  };
  Std["int"] = function (x) {
    return x | 0;
  };
  Std.parseInt = function (x) {
    var v = parseInt(x, 10);
    if (v == 0 && (HxOverrides.cca(x, 1) == 120 || HxOverrides.cca(x, 1) == 88)) v = parseInt(x);
    if (isNaN(v)) return null;
    return v;
  };
  Std.parseFloat = function (x) {
    return parseFloat(x);
  };
  Std.random = function (x) {
    return Math.floor(Math.random() * x);
  };
  var com = com || {};
  if (!com.wiris) com.wiris = {};
  if (!com.wiris.js) com.wiris.js = {};
  com.wiris.js.JsPluginTools = function () {
    this.tryReady();
  };
  com.wiris.js.JsPluginTools.__name__ = true;
  com.wiris.js.JsPluginTools.main = function () {
    var ev;
    ev = com.wiris.js.JsPluginTools.getInstance();
    haxe.Timer.delay($bind(ev, ev.tryReady), 100);
  };
  com.wiris.js.JsPluginTools.getInstance = function () {
    if (com.wiris.js.JsPluginTools.instance == null)
      com.wiris.js.JsPluginTools.instance = new com.wiris.js.JsPluginTools();
    return com.wiris.js.JsPluginTools.instance;
  };
  com.wiris.js.JsPluginTools.bypassEncapsulation = function () {
    if (window.com == null) window.com = {};
    if (window.com.wiris == null) window.com.wiris = {};
    if (window.com.wiris.js == null) window.com.wiris.js = {};
    if (window.com.wiris.js.JsPluginTools == null)
      window.com.wiris.js.JsPluginTools = com.wiris.js.JsPluginTools.getInstance();
  };
  com.wiris.js.JsPluginTools.prototype = {
    md5encode: function (content) {
      return haxe.Md5.encode(content);
    },
    doLoad: function () {
      this.ready = true;
      com.wiris.js.JsPluginTools.instance = this;
      com.wiris.js.JsPluginTools.bypassEncapsulation();
    },
    tryReady: function () {
      this.ready = false;
      if (js.Lib.document.readyState) {
        this.doLoad();
        this.ready = true;
      }
      if (!this.ready) haxe.Timer.delay($bind(this, this.tryReady), 100);
    },
    __class__: com.wiris.js.JsPluginTools,
  };
  var haxe = haxe || {};
  haxe.Log = function () {};
  haxe.Log.__name__ = true;
  haxe.Log.trace = function (v, infos) {
    js.Boot.__trace(v, infos);
  };
  haxe.Log.clear = function () {
    js.Boot.__clear_trace();
  };
  haxe.Md5 = function () {};
  haxe.Md5.__name__ = true;
  haxe.Md5.encode = function (s) {
    return new haxe.Md5().doEncode(s);
  };
  haxe.Md5.prototype = {
    doEncode: function (str) {
      var x = this.str2blks(str);
      var a = 1732584193;
      var b = -271733879;
      var c = -1732584194;
      var d = 271733878;
      var step;
      var i = 0;
      while (i < x.length) {
        var olda = a;
        var oldb = b;
        var oldc = c;
        var oldd = d;
        step = 0;
        a = this.ff(a, b, c, d, x[i], 7, -680876936);
        d = this.ff(d, a, b, c, x[i + 1], 12, -389564586);
        c = this.ff(c, d, a, b, x[i + 2], 17, 606105819);
        b = this.ff(b, c, d, a, x[i + 3], 22, -1044525330);
        a = this.ff(a, b, c, d, x[i + 4], 7, -176418897);
        d = this.ff(d, a, b, c, x[i + 5], 12, 1200080426);
        c = this.ff(c, d, a, b, x[i + 6], 17, -1473231341);
        b = this.ff(b, c, d, a, x[i + 7], 22, -45705983);
        a = this.ff(a, b, c, d, x[i + 8], 7, 1770035416);
        d = this.ff(d, a, b, c, x[i + 9], 12, -1958414417);
        c = this.ff(c, d, a, b, x[i + 10], 17, -42063);
        b = this.ff(b, c, d, a, x[i + 11], 22, -1990404162);
        a = this.ff(a, b, c, d, x[i + 12], 7, 1804603682);
        d = this.ff(d, a, b, c, x[i + 13], 12, -40341101);
        c = this.ff(c, d, a, b, x[i + 14], 17, -1502002290);
        b = this.ff(b, c, d, a, x[i + 15], 22, 1236535329);
        a = this.gg(a, b, c, d, x[i + 1], 5, -165796510);
        d = this.gg(d, a, b, c, x[i + 6], 9, -1069501632);
        c = this.gg(c, d, a, b, x[i + 11], 14, 643717713);
        b = this.gg(b, c, d, a, x[i], 20, -373897302);
        a = this.gg(a, b, c, d, x[i + 5], 5, -701558691);
        d = this.gg(d, a, b, c, x[i + 10], 9, 38016083);
        c = this.gg(c, d, a, b, x[i + 15], 14, -660478335);
        b = this.gg(b, c, d, a, x[i + 4], 20, -405537848);
        a = this.gg(a, b, c, d, x[i + 9], 5, 568446438);
        d = this.gg(d, a, b, c, x[i + 14], 9, -1019803690);
        c = this.gg(c, d, a, b, x[i + 3], 14, -187363961);
        b = this.gg(b, c, d, a, x[i + 8], 20, 1163531501);
        a = this.gg(a, b, c, d, x[i + 13], 5, -1444681467);
        d = this.gg(d, a, b, c, x[i + 2], 9, -51403784);
        c = this.gg(c, d, a, b, x[i + 7], 14, 1735328473);
        b = this.gg(b, c, d, a, x[i + 12], 20, -1926607734);
        a = this.hh(a, b, c, d, x[i + 5], 4, -378558);
        d = this.hh(d, a, b, c, x[i + 8], 11, -2022574463);
        c = this.hh(c, d, a, b, x[i + 11], 16, 1839030562);
        b = this.hh(b, c, d, a, x[i + 14], 23, -35309556);
        a = this.hh(a, b, c, d, x[i + 1], 4, -1530992060);
        d = this.hh(d, a, b, c, x[i + 4], 11, 1272893353);
        c = this.hh(c, d, a, b, x[i + 7], 16, -155497632);
        b = this.hh(b, c, d, a, x[i + 10], 23, -1094730640);
        a = this.hh(a, b, c, d, x[i + 13], 4, 681279174);
        d = this.hh(d, a, b, c, x[i], 11, -358537222);
        c = this.hh(c, d, a, b, x[i + 3], 16, -722521979);
        b = this.hh(b, c, d, a, x[i + 6], 23, 76029189);
        a = this.hh(a, b, c, d, x[i + 9], 4, -640364487);
        d = this.hh(d, a, b, c, x[i + 12], 11, -421815835);
        c = this.hh(c, d, a, b, x[i + 15], 16, 530742520);
        b = this.hh(b, c, d, a, x[i + 2], 23, -995338651);
        a = this.ii(a, b, c, d, x[i], 6, -198630844);
        d = this.ii(d, a, b, c, x[i + 7], 10, 1126891415);
        c = this.ii(c, d, a, b, x[i + 14], 15, -1416354905);
        b = this.ii(b, c, d, a, x[i + 5], 21, -57434055);
        a = this.ii(a, b, c, d, x[i + 12], 6, 1700485571);
        d = this.ii(d, a, b, c, x[i + 3], 10, -1894986606);
        c = this.ii(c, d, a, b, x[i + 10], 15, -1051523);
        b = this.ii(b, c, d, a, x[i + 1], 21, -2054922799);
        a = this.ii(a, b, c, d, x[i + 8], 6, 1873313359);
        d = this.ii(d, a, b, c, x[i + 15], 10, -30611744);
        c = this.ii(c, d, a, b, x[i + 6], 15, -1560198380);
        b = this.ii(b, c, d, a, x[i + 13], 21, 1309151649);
        a = this.ii(a, b, c, d, x[i + 4], 6, -145523070);
        d = this.ii(d, a, b, c, x[i + 11], 10, -1120210379);
        c = this.ii(c, d, a, b, x[i + 2], 15, 718787259);
        b = this.ii(b, c, d, a, x[i + 9], 21, -343485551);
        a = this.addme(a, olda);
        b = this.addme(b, oldb);
        c = this.addme(c, oldc);
        d = this.addme(d, oldd);
        i += 16;
      }
      return this.rhex(a) + this.rhex(b) + this.rhex(c) + this.rhex(d);
    },
    ii: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitXOR(c, this.bitOR(b, ~d)), a, b, x, s, t);
    },
    hh: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitXOR(this.bitXOR(b, c), d), a, b, x, s, t);
    },
    gg: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitOR(this.bitAND(b, d), this.bitAND(c, ~d)), a, b, x, s, t);
    },
    ff: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitOR(this.bitAND(b, c), this.bitAND(~b, d)), a, b, x, s, t);
    },
    cmn: function (q, a, b, x, s, t) {
      return this.addme(this.rol(this.addme(this.addme(a, q), this.addme(x, t)), s), b);
    },
    rol: function (num, cnt) {
      return (num << cnt) | (num >>> (32 - cnt));
    },
    str2blks: function (str) {
      var nblk = ((str.length + 8) >> 6) + 1;
      var blks = new Array();
      var _g1 = 0,
        _g = nblk * 16;
      while (_g1 < _g) {
        var i = _g1++;
        blks[i] = 0;
      }
      var i = 0;
      while (i < str.length) {
        blks[i >> 2] |= HxOverrides.cca(str, i) << (((str.length * 8 + i) % 4) * 8);
        i++;
      }
      blks[i >> 2] |= 128 << (((str.length * 8 + i) % 4) * 8);
      var l = str.length * 8;
      var k = nblk * 16 - 2;
      blks[k] = l & 255;
      blks[k] |= ((l >>> 8) & 255) << 8;
      blks[k] |= ((l >>> 16) & 255) << 16;
      blks[k] |= ((l >>> 24) & 255) << 24;
      return blks;
    },
    rhex: function (num) {
      var str = "";
      var hex_chr = "0123456789abcdef";
      var _g = 0;
      while (_g < 4) {
        var j = _g++;
        str += hex_chr.charAt((num >> (j * 8 + 4)) & 15) + hex_chr.charAt((num >> (j * 8)) & 15);
      }
      return str;
    },
    addme: function (x, y) {
      var lsw = (x & 65535) + (y & 65535);
      var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
      return (msw << 16) | (lsw & 65535);
    },
    bitAND: function (a, b) {
      var lsb = a & 1 & (b & 1);
      var msb31 = (a >>> 1) & (b >>> 1);
      return (msb31 << 1) | lsb;
    },
    bitXOR: function (a, b) {
      var lsb = (a & 1) ^ (b & 1);
      var msb31 = (a >>> 1) ^ (b >>> 1);
      return (msb31 << 1) | lsb;
    },
    bitOR: function (a, b) {
      var lsb = (a & 1) | (b & 1);
      var msb31 = (a >>> 1) | (b >>> 1);
      return (msb31 << 1) | lsb;
    },
    __class__: haxe.Md5,
  };
  haxe.Timer = function (time_ms) {
    var me = this;
    this.id = window.setInterval(function () {
      me.run();
    }, time_ms);
  };
  haxe.Timer.__name__ = true;
  haxe.Timer.delay = function (f, time_ms) {
    var t = new haxe.Timer(time_ms);
    t.run = function () {
      t.stop();
      f();
    };
    return t;
  };
  haxe.Timer.measure = function (f, pos) {
    var t0 = haxe.Timer.stamp();
    var r = f();
    haxe.Log.trace(haxe.Timer.stamp() - t0 + "s", pos);
    return r;
  };
  haxe.Timer.stamp = function () {
    return new Date().getTime() / 1000;
  };
  haxe.Timer.prototype = {
    run: function () {},
    stop: function () {
      if (this.id == null) return;
      window.clearInterval(this.id);
      this.id = null;
    },
    __class__: haxe.Timer,
  };
  var js = js || {};
  js.Boot = function () {};
  js.Boot.__name__ = true;
  js.Boot.__unhtml = function (s) {
    return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
  };
  js.Boot.__trace = function (v, i) {
    var msg = i != null ? i.fileName + ":" + i.lineNumber + ": " : "";
    msg += js.Boot.__string_rec(v, "");
    var d;
    if (typeof document != "undefined" && (d = document.getElementById("haxe:trace")) != null)
      d.innerHTML += js.Boot.__unhtml(msg) + "<br/>";
    else if (typeof console != "undefined" && console.log != null) console.log(msg);
  };
  js.Boot.__clear_trace = function () {
    var d = document.getElementById("haxe:trace");
    if (d != null) d.innerHTML = "";
  };
  js.Boot.isClass = function (o) {
    return o.__name__;
  };
  js.Boot.isEnum = function (e) {
    return e.__ename__;
  };
  js.Boot.getClass = function (o) {
    return o.__class__;
  };
  js.Boot.__string_rec = function (o, s) {
    if (o == null) return "null";
    if (s.length >= 5) return "<...>";
    var t = typeof o;
    if (t == "function" && (o.__name__ || o.__ename__)) t = "object";
    switch (t) {
      case "object":
        if (o instanceof Array) {
          if (o.__enum__) {
            if (o.length == 2) return o[0];
            var str = o[0] + "(";
            s += "\t";
            var _g1 = 2,
              _g = o.length;
            while (_g1 < _g) {
              var i = _g1++;
              if (i != 2) str += "," + js.Boot.__string_rec(o[i], s);
              else str += js.Boot.__string_rec(o[i], s);
            }
            return str + ")";
          }
          var l = o.length;
          var i;
          var str = "[";
          s += "\t";
          var _g = 0;
          while (_g < l) {
            var i1 = _g++;
            str += (i1 > 0 ? "," : "") + js.Boot.__string_rec(o[i1], s);
          }
          str += "]";
          return str;
        }
        var tostr;
        try {
          tostr = o.toString;
        } catch (e) {
          return "???";
        }
        if (tostr != null && tostr != Object.toString) {
          var s2 = o.toString();
          if (s2 != "[object Object]") return s2;
        }
        var k = null;
        var str = "{\n";
        s += "\t";
        var hasp = o.hasOwnProperty != null;
        for (var k in o) {
          if (hasp && !o.hasOwnProperty(k)) {
            continue;
          }
          if (
            k == "prototype" ||
            k == "__class__" ||
            k == "__super__" ||
            k == "__interfaces__" ||
            k == "__properties__"
          ) {
            continue;
          }
          if (str.length != 2) str += ", \n";
          str += s + k + " : " + js.Boot.__string_rec(o[k], s);
        }
        s = s.substring(1);
        str += "\n" + s + "}";
        return str;
      case "function":
        return "<function>";
      case "string":
        return o;
      default:
        return String(o);
    }
  };
  js.Boot.__interfLoop = function (cc, cl) {
    if (cc == null) return false;
    if (cc == cl) return true;
    var intf = cc.__interfaces__;
    if (intf != null) {
      var _g1 = 0,
        _g = intf.length;
      while (_g1 < _g) {
        var i = _g1++;
        var i1 = intf[i];
        if (i1 == cl || js.Boot.__interfLoop(i1, cl)) return true;
      }
    }
    return js.Boot.__interfLoop(cc.__super__, cl);
  };
  js.Boot.__instanceof = function (o, cl) {
    try {
      if (o instanceof cl) {
        if (cl == Array) return o.__enum__ == null;
        return true;
      }
      if (js.Boot.__interfLoop(o.__class__, cl)) return true;
    } catch (e) {
      if (cl == null) return false;
    }
    switch (cl) {
      case Int:
        return Math.ceil(o % 2147483648.0) === o;
      case Float:
        return typeof o == "number";
      case Bool:
        return o === true || o === false;
      case String:
        return typeof o == "string";
      case Dynamic:
        return true;
      default:
        if (o == null) return false;
        if (cl == Class && o.__name__ != null) return true;
        else null;
        if (cl == Enum && o.__ename__ != null) return true;
        else null;
        return o.__enum__ == cl;
    }
  };
  js.Boot.__cast = function (o, t) {
    if (js.Boot.__instanceof(o, t)) return o;
    else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
  };
  js.Lib = function () {};
  js.Lib.__name__ = true;
  js.Lib.debug = function () {
    debugger;
  };
  js.Lib.alert = function (v) {
    alert(js.Boot.__string_rec(v, ""));
  };
  js.Lib.eval = function (code) {
    return eval(code);
  };
  js.Lib.setErrorHandler = function (f) {
    js.Lib.onerror = f;
  };
  var $_;
  function $bind(o, m) {
    var f = function () {
      return f.method.apply(f.scope, arguments);
    };
    f.scope = o;
    f.method = m;
    return f;
  }
  if (Array.prototype.indexOf)
    HxOverrides.remove = function (a, o) {
      var i = a.indexOf(o);
      if (i == -1) return false;
      a.splice(i, 1);
      return true;
    };
  else null;
  Math.__name__ = ["Math"];
  Math.NaN = Number.NaN;
  Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;
  Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;
  Math.isFinite = function (i) {
    return isFinite(i);
  };
  Math.isNaN = function (i) {
    return isNaN(i);
  };
  String.prototype.__class__ = String;
  String.__name__ = true;
  Array.prototype.__class__ = Array;
  Array.__name__ = true;
  Date.prototype.__class__ = Date;
  Date.__name__ = ["Date"];
  var Int = { __name__: ["Int"] };
  var Dynamic = { __name__: ["Dynamic"] };
  var Float = Number;
  Float.__name__ = ["Float"];
  var Bool = Boolean;
  Bool.__ename__ = ["Bool"];
  var Class = { __name__: ["Class"] };
  var Enum = {};
  var Void = { __ename__: ["Void"] };
  if (typeof document != "undefined") js.Lib.document = document;
  if (typeof window != "undefined") {
    js.Lib.window = window;
    js.Lib.window.onerror = function (msg, url, line) {
      var f = js.Lib.onerror;
      if (f == null) return false;
      return f(msg, [url + ":" + line]);
    };
  }
  com.wiris.js.JsPluginTools.main();
  delete Array.prototype.__class__;
})();

(function () {
  var HxOverrides = function () {};
  HxOverrides.__name__ = true;
  HxOverrides.dateStr = function (date) {
    var m = date.getMonth() + 1;
    var d = date.getDate();
    var h = date.getHours();
    var mi = date.getMinutes();
    var s = date.getSeconds();
    return (
      date.getFullYear() +
      "-" +
      (m < 10 ? "0" + m : "" + m) +
      "-" +
      (d < 10 ? "0" + d : "" + d) +
      " " +
      (h < 10 ? "0" + h : "" + h) +
      ":" +
      (mi < 10 ? "0" + mi : "" + mi) +
      ":" +
      (s < 10 ? "0" + s : "" + s)
    );
  };
  HxOverrides.strDate = function (s) {
    switch (s.length) {
      case 8:
        var k = s.split(":");
        var d = new Date();
        d.setTime(0);
        d.setUTCHours(k[0]);
        d.setUTCMinutes(k[1]);
        d.setUTCSeconds(k[2]);
        return d;
      case 10:
        var k = s.split("-");
        return new Date(k[0], k[1] - 1, k[2], 0, 0, 0);
      case 19:
        var k = s.split(" ");
        var y = k[0].split("-");
        var t = k[1].split(":");
        return new Date(y[0], y[1] - 1, y[2], t[0], t[1], t[2]);
      default:
        throw "Invalid date format : " + s;
    }
  };
  HxOverrides.cca = function (s, index) {
    var x = s.charCodeAt(index);
    if (x != x) return undefined;
    return x;
  };
  HxOverrides.substr = function (s, pos, len) {
    if (pos != null && pos != 0 && len != null && len < 0) return "";
    if (len == null) len = s.length;
    if (pos < 0) {
      pos = s.length + pos;
      if (pos < 0) pos = 0;
    } else if (len < 0) len = s.length + len - pos;
    return s.substr(pos, len);
  };
  HxOverrides.remove = function (a, obj) {
    var i = 0;
    var l = a.length;
    while (i < l) {
      if (a[i] == obj) {
        a.splice(i, 1);
        return true;
      }
      i++;
    }
    return false;
  };
  HxOverrides.iter = function (a) {
    return {
      cur: 0,
      arr: a,
      hasNext: function () {
        return this.cur < this.arr.length;
      },
      next: function () {
        return this.arr[this.cur++];
      },
    };
  };
  var IntIter = function (min, max) {
    this.min = min;
    this.max = max;
  };
  IntIter.__name__ = true;
  IntIter.prototype = {
    next: function () {
      return this.min++;
    },
    hasNext: function () {
      return this.min < this.max;
    },
    __class__: IntIter,
  };
  var Std = function () {};
  Std.__name__ = true;
  Std["is"] = function (v, t) {
    return js.Boot.__instanceof(v, t);
  };
  Std.string = function (s) {
    return js.Boot.__string_rec(s, "");
  };
  Std["int"] = function (x) {
    return x | 0;
  };
  Std.parseInt = function (x) {
    var v = parseInt(x, 10);
    if (v == 0 && (HxOverrides.cca(x, 1) == 120 || HxOverrides.cca(x, 1) == 88)) v = parseInt(x);
    if (isNaN(v)) return null;
    return v;
  };
  Std.parseFloat = function (x) {
    return parseFloat(x);
  };
  Std.random = function (x) {
    return Math.floor(Math.random() * x);
  };
  var com = com || {};
  if (!com.wiris) com.wiris = {};
  if (!com.wiris.js) com.wiris.js = {};
  com.wiris.js.JsPluginTools = function () {
    this.tryReady();
  };
  com.wiris.js.JsPluginTools.__name__ = true;
  com.wiris.js.JsPluginTools.main = function () {
    var ev;
    ev = com.wiris.js.JsPluginTools.getInstance();
    haxe.Timer.delay($bind(ev, ev.tryReady), 100);
  };
  com.wiris.js.JsPluginTools.getInstance = function () {
    if (com.wiris.js.JsPluginTools.instance == null)
      com.wiris.js.JsPluginTools.instance = new com.wiris.js.JsPluginTools();
    return com.wiris.js.JsPluginTools.instance;
  };
  com.wiris.js.JsPluginTools.bypassEncapsulation = function () {
    if (window.com == null) window.com = {};
    if (window.com.wiris == null) window.com.wiris = {};
    if (window.com.wiris.js == null) window.com.wiris.js = {};
    if (window.com.wiris.js.JsPluginTools == null)
      window.com.wiris.js.JsPluginTools = com.wiris.js.JsPluginTools.getInstance();
  };
  com.wiris.js.JsPluginTools.prototype = {
    md5encode: function (content) {
      return haxe.Md5.encode(content);
    },
    doLoad: function () {
      this.ready = true;
      com.wiris.js.JsPluginTools.instance = this;
      com.wiris.js.JsPluginTools.bypassEncapsulation();
    },
    tryReady: function () {
      this.ready = false;
      if (js.Lib.document.readyState) {
        this.doLoad();
        this.ready = true;
      }
      if (!this.ready) haxe.Timer.delay($bind(this, this.tryReady), 100);
    },
    __class__: com.wiris.js.JsPluginTools,
  };
  var haxe = haxe || {};
  haxe.Log = function () {};
  haxe.Log.__name__ = true;
  haxe.Log.trace = function (v, infos) {
    js.Boot.__trace(v, infos);
  };
  haxe.Log.clear = function () {
    js.Boot.__clear_trace();
  };
  haxe.Md5 = function () {};
  haxe.Md5.__name__ = true;
  haxe.Md5.encode = function (s) {
    return new haxe.Md5().doEncode(s);
  };
  haxe.Md5.prototype = {
    doEncode: function (str) {
      var x = this.str2blks(str);
      var a = 1732584193;
      var b = -271733879;
      var c = -1732584194;
      var d = 271733878;
      var step;
      var i = 0;
      while (i < x.length) {
        var olda = a;
        var oldb = b;
        var oldc = c;
        var oldd = d;
        step = 0;
        a = this.ff(a, b, c, d, x[i], 7, -680876936);
        d = this.ff(d, a, b, c, x[i + 1], 12, -389564586);
        c = this.ff(c, d, a, b, x[i + 2], 17, 606105819);
        b = this.ff(b, c, d, a, x[i + 3], 22, -1044525330);
        a = this.ff(a, b, c, d, x[i + 4], 7, -176418897);
        d = this.ff(d, a, b, c, x[i + 5], 12, 1200080426);
        c = this.ff(c, d, a, b, x[i + 6], 17, -1473231341);
        b = this.ff(b, c, d, a, x[i + 7], 22, -45705983);
        a = this.ff(a, b, c, d, x[i + 8], 7, 1770035416);
        d = this.ff(d, a, b, c, x[i + 9], 12, -1958414417);
        c = this.ff(c, d, a, b, x[i + 10], 17, -42063);
        b = this.ff(b, c, d, a, x[i + 11], 22, -1990404162);
        a = this.ff(a, b, c, d, x[i + 12], 7, 1804603682);
        d = this.ff(d, a, b, c, x[i + 13], 12, -40341101);
        c = this.ff(c, d, a, b, x[i + 14], 17, -1502002290);
        b = this.ff(b, c, d, a, x[i + 15], 22, 1236535329);
        a = this.gg(a, b, c, d, x[i + 1], 5, -165796510);
        d = this.gg(d, a, b, c, x[i + 6], 9, -1069501632);
        c = this.gg(c, d, a, b, x[i + 11], 14, 643717713);
        b = this.gg(b, c, d, a, x[i], 20, -373897302);
        a = this.gg(a, b, c, d, x[i + 5], 5, -701558691);
        d = this.gg(d, a, b, c, x[i + 10], 9, 38016083);
        c = this.gg(c, d, a, b, x[i + 15], 14, -660478335);
        b = this.gg(b, c, d, a, x[i + 4], 20, -405537848);
        a = this.gg(a, b, c, d, x[i + 9], 5, 568446438);
        d = this.gg(d, a, b, c, x[i + 14], 9, -1019803690);
        c = this.gg(c, d, a, b, x[i + 3], 14, -187363961);
        b = this.gg(b, c, d, a, x[i + 8], 20, 1163531501);
        a = this.gg(a, b, c, d, x[i + 13], 5, -1444681467);
        d = this.gg(d, a, b, c, x[i + 2], 9, -51403784);
        c = this.gg(c, d, a, b, x[i + 7], 14, 1735328473);
        b = this.gg(b, c, d, a, x[i + 12], 20, -1926607734);
        a = this.hh(a, b, c, d, x[i + 5], 4, -378558);
        d = this.hh(d, a, b, c, x[i + 8], 11, -2022574463);
        c = this.hh(c, d, a, b, x[i + 11], 16, 1839030562);
        b = this.hh(b, c, d, a, x[i + 14], 23, -35309556);
        a = this.hh(a, b, c, d, x[i + 1], 4, -1530992060);
        d = this.hh(d, a, b, c, x[i + 4], 11, 1272893353);
        c = this.hh(c, d, a, b, x[i + 7], 16, -155497632);
        b = this.hh(b, c, d, a, x[i + 10], 23, -1094730640);
        a = this.hh(a, b, c, d, x[i + 13], 4, 681279174);
        d = this.hh(d, a, b, c, x[i], 11, -358537222);
        c = this.hh(c, d, a, b, x[i + 3], 16, -722521979);
        b = this.hh(b, c, d, a, x[i + 6], 23, 76029189);
        a = this.hh(a, b, c, d, x[i + 9], 4, -640364487);
        d = this.hh(d, a, b, c, x[i + 12], 11, -421815835);
        c = this.hh(c, d, a, b, x[i + 15], 16, 530742520);
        b = this.hh(b, c, d, a, x[i + 2], 23, -995338651);
        a = this.ii(a, b, c, d, x[i], 6, -198630844);
        d = this.ii(d, a, b, c, x[i + 7], 10, 1126891415);
        c = this.ii(c, d, a, b, x[i + 14], 15, -1416354905);
        b = this.ii(b, c, d, a, x[i + 5], 21, -57434055);
        a = this.ii(a, b, c, d, x[i + 12], 6, 1700485571);
        d = this.ii(d, a, b, c, x[i + 3], 10, -1894986606);
        c = this.ii(c, d, a, b, x[i + 10], 15, -1051523);
        b = this.ii(b, c, d, a, x[i + 1], 21, -2054922799);
        a = this.ii(a, b, c, d, x[i + 8], 6, 1873313359);
        d = this.ii(d, a, b, c, x[i + 15], 10, -30611744);
        c = this.ii(c, d, a, b, x[i + 6], 15, -1560198380);
        b = this.ii(b, c, d, a, x[i + 13], 21, 1309151649);
        a = this.ii(a, b, c, d, x[i + 4], 6, -145523070);
        d = this.ii(d, a, b, c, x[i + 11], 10, -1120210379);
        c = this.ii(c, d, a, b, x[i + 2], 15, 718787259);
        b = this.ii(b, c, d, a, x[i + 9], 21, -343485551);
        a = this.addme(a, olda);
        b = this.addme(b, oldb);
        c = this.addme(c, oldc);
        d = this.addme(d, oldd);
        i += 16;
      }
      return this.rhex(a) + this.rhex(b) + this.rhex(c) + this.rhex(d);
    },
    ii: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitXOR(c, this.bitOR(b, ~d)), a, b, x, s, t);
    },
    hh: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitXOR(this.bitXOR(b, c), d), a, b, x, s, t);
    },
    gg: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitOR(this.bitAND(b, d), this.bitAND(c, ~d)), a, b, x, s, t);
    },
    ff: function (a, b, c, d, x, s, t) {
      return this.cmn(this.bitOR(this.bitAND(b, c), this.bitAND(~b, d)), a, b, x, s, t);
    },
    cmn: function (q, a, b, x, s, t) {
      return this.addme(this.rol(this.addme(this.addme(a, q), this.addme(x, t)), s), b);
    },
    rol: function (num, cnt) {
      return (num << cnt) | (num >>> (32 - cnt));
    },
    str2blks: function (str) {
      var nblk = ((str.length + 8) >> 6) + 1;
      var blks = new Array();
      var _g1 = 0,
        _g = nblk * 16;
      while (_g1 < _g) {
        var i = _g1++;
        blks[i] = 0;
      }
      var i = 0;
      while (i < str.length) {
        blks[i >> 2] |= HxOverrides.cca(str, i) << (((str.length * 8 + i) % 4) * 8);
        i++;
      }
      blks[i >> 2] |= 128 << (((str.length * 8 + i) % 4) * 8);
      var l = str.length * 8;
      var k = nblk * 16 - 2;
      blks[k] = l & 255;
      blks[k] |= ((l >>> 8) & 255) << 8;
      blks[k] |= ((l >>> 16) & 255) << 16;
      blks[k] |= ((l >>> 24) & 255) << 24;
      return blks;
    },
    rhex: function (num) {
      var str = "";
      var hex_chr = "0123456789abcdef";
      var _g = 0;
      while (_g < 4) {
        var j = _g++;
        str += hex_chr.charAt((num >> (j * 8 + 4)) & 15) + hex_chr.charAt((num >> (j * 8)) & 15);
      }
      return str;
    },
    addme: function (x, y) {
      var lsw = (x & 65535) + (y & 65535);
      var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
      return (msw << 16) | (lsw & 65535);
    },
    bitAND: function (a, b) {
      var lsb = a & 1 & (b & 1);
      var msb31 = (a >>> 1) & (b >>> 1);
      return (msb31 << 1) | lsb;
    },
    bitXOR: function (a, b) {
      var lsb = (a & 1) ^ (b & 1);
      var msb31 = (a >>> 1) ^ (b >>> 1);
      return (msb31 << 1) | lsb;
    },
    bitOR: function (a, b) {
      var lsb = (a & 1) | (b & 1);
      var msb31 = (a >>> 1) | (b >>> 1);
      return (msb31 << 1) | lsb;
    },
    __class__: haxe.Md5,
  };
  haxe.Timer = function (time_ms) {
    var me = this;
    this.id = window.setInterval(function () {
      me.run();
    }, time_ms);
  };
  haxe.Timer.__name__ = true;
  haxe.Timer.delay = function (f, time_ms) {
    var t = new haxe.Timer(time_ms);
    t.run = function () {
      t.stop();
      f();
    };
    return t;
  };
  haxe.Timer.measure = function (f, pos) {
    var t0 = haxe.Timer.stamp();
    var r = f();
    haxe.Log.trace(haxe.Timer.stamp() - t0 + "s", pos);
    return r;
  };
  haxe.Timer.stamp = function () {
    return new Date().getTime() / 1000;
  };
  haxe.Timer.prototype = {
    run: function () {},
    stop: function () {
      if (this.id == null) return;
      window.clearInterval(this.id);
      this.id = null;
    },
    __class__: haxe.Timer,
  };
  var js = js || {};
  js.Boot = function () {};
  js.Boot.__name__ = true;
  js.Boot.__unhtml = function (s) {
    return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
  };
  js.Boot.__trace = function (v, i) {
    var msg = i != null ? i.fileName + ":" + i.lineNumber + ": " : "";
    msg += js.Boot.__string_rec(v, "");
    var d;
    if (typeof document != "undefined" && (d = document.getElementById("haxe:trace")) != null)
      d.innerHTML += js.Boot.__unhtml(msg) + "<br/>";
    else if (typeof console != "undefined" && console.log != null) console.log(msg);
  };
  js.Boot.__clear_trace = function () {
    var d = document.getElementById("haxe:trace");
    if (d != null) d.innerHTML = "";
  };
  js.Boot.isClass = function (o) {
    return o.__name__;
  };
  js.Boot.isEnum = function (e) {
    return e.__ename__;
  };
  js.Boot.getClass = function (o) {
    return o.__class__;
  };
  js.Boot.__string_rec = function (o, s) {
    if (o == null) return "null";
    if (s.length >= 5) return "<...>";
    var t = typeof o;
    if (t == "function" && (o.__name__ || o.__ename__)) t = "object";
    switch (t) {
      case "object":
        if (o instanceof Array) {
          if (o.__enum__) {
            if (o.length == 2) return o[0];
            var str = o[0] + "(";
            s += "\t";
            var _g1 = 2,
              _g = o.length;
            while (_g1 < _g) {
              var i = _g1++;
              if (i != 2) str += "," + js.Boot.__string_rec(o[i], s);
              else str += js.Boot.__string_rec(o[i], s);
            }
            return str + ")";
          }
          var l = o.length;
          var i;
          var str = "[";
          s += "\t";
          var _g = 0;
          while (_g < l) {
            var i1 = _g++;
            str += (i1 > 0 ? "," : "") + js.Boot.__string_rec(o[i1], s);
          }
          str += "]";
          return str;
        }
        var tostr;
        try {
          tostr = o.toString;
        } catch (e) {
          return "???";
        }
        if (tostr != null && tostr != Object.toString) {
          var s2 = o.toString();
          if (s2 != "[object Object]") return s2;
        }
        var k = null;
        var str = "{\n";
        s += "\t";
        var hasp = o.hasOwnProperty != null;
        for (var k in o) {
          if (hasp && !o.hasOwnProperty(k)) {
            continue;
          }
          if (
            k == "prototype" ||
            k == "__class__" ||
            k == "__super__" ||
            k == "__interfaces__" ||
            k == "__properties__"
          ) {
            continue;
          }
          if (str.length != 2) str += ", \n";
          str += s + k + " : " + js.Boot.__string_rec(o[k], s);
        }
        s = s.substring(1);
        str += "\n" + s + "}";
        return str;
      case "function":
        return "<function>";
      case "string":
        return o;
      default:
        return String(o);
    }
  };
  js.Boot.__interfLoop = function (cc, cl) {
    if (cc == null) return false;
    if (cc == cl) return true;
    var intf = cc.__interfaces__;
    if (intf != null) {
      var _g1 = 0,
        _g = intf.length;
      while (_g1 < _g) {
        var i = _g1++;
        var i1 = intf[i];
        if (i1 == cl || js.Boot.__interfLoop(i1, cl)) return true;
      }
    }
    return js.Boot.__interfLoop(cc.__super__, cl);
  };
  js.Boot.__instanceof = function (o, cl) {
    try {
      if (o instanceof cl) {
        if (cl == Array) return o.__enum__ == null;
        return true;
      }
      if (js.Boot.__interfLoop(o.__class__, cl)) return true;
    } catch (e) {
      if (cl == null) return false;
    }
    switch (cl) {
      case Int:
        return Math.ceil(o % 2147483648.0) === o;
      case Float:
        return typeof o == "number";
      case Bool:
        return o === true || o === false;
      case String:
        return typeof o == "string";
      case Dynamic:
        return true;
      default:
        if (o == null) return false;
        if (cl == Class && o.__name__ != null) return true;
        else null;
        if (cl == Enum && o.__ename__ != null) return true;
        else null;
        return o.__enum__ == cl;
    }
  };
  js.Boot.__cast = function (o, t) {
    if (js.Boot.__instanceof(o, t)) return o;
    else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
  };
  js.Lib = function () {};
  js.Lib.__name__ = true;
  js.Lib.debug = function () {
    debugger;
  };
  js.Lib.alert = function (v) {
    alert(js.Boot.__string_rec(v, ""));
  };
  js.Lib.eval = function (code) {
    return eval(code);
  };
  js.Lib.setErrorHandler = function (f) {
    js.Lib.onerror = f;
  };
  var $_;
  function $bind(o, m) {
    var f = function () {
      return f.method.apply(f.scope, arguments);
    };
    f.scope = o;
    f.method = m;
    return f;
  }
  if (Array.prototype.indexOf)
    HxOverrides.remove = function (a, o) {
      var i = a.indexOf(o);
      if (i == -1) return false;
      a.splice(i, 1);
      return true;
    };
  else null;
  Math.__name__ = ["Math"];
  Math.NaN = Number.NaN;
  Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;
  Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;
  Math.isFinite = function (i) {
    return isFinite(i);
  };
  Math.isNaN = function (i) {
    return isNaN(i);
  };
  String.prototype.__class__ = String;
  String.__name__ = true;
  Array.prototype.__class__ = Array;
  Array.__name__ = true;
  Date.prototype.__class__ = Date;
  Date.__name__ = ["Date"];
  var Int = { __name__: ["Int"] };
  var Dynamic = { __name__: ["Dynamic"] };
  var Float = Number;
  Float.__name__ = ["Float"];
  var Bool = Boolean;
  Bool.__ename__ = ["Bool"];
  var Class = { __name__: ["Class"] };
  var Enum = {};
  var Void = { __ename__: ["Void"] };
  if (typeof document != "undefined") js.Lib.document = document;
  if (typeof window != "undefined") {
    js.Lib.window = window;
    js.Lib.window.onerror = function (msg, url, line) {
      var f = js.Lib.onerror;
      if (f == null) return false;
      return f(msg, [url + ":" + line]);
    };
  }
  com.wiris.js.JsPluginTools.main();
})();
delete Array.prototype.__class__;
// @codingStandardsIgnoreEnd


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/modal.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/modal.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModalDialog)
/* harmony export */ });
/* harmony import */ var _popupmessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./popupmessage */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/popupmessage.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./listeners */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js");
/* harmony import */ var _stringmanager__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./stringmanager */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/stringmanager.js");
/* harmony import */ var _contentmanager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./contentmanager */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/contentmanager.js");
/* harmony import */ var _telemeter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./telemeter */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/telemeter.js");
/* harmony import */ var _integrationmodel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./integrationmodel */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/integrationmodel.js");
/* harmony import */ var _core_src__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./core.src */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/core.src.js");
/* harmony import */ var _styles_icons_general_close_icon_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../styles/icons/general/close_icon.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/general/close_icon.svg");
/* harmony import */ var _styles_icons_hover_close_icon_h_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../styles/icons/hover/close_icon_h.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/hover/close_icon_h.svg");
/* harmony import */ var _styles_icons_general_fulls_icon_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../styles/icons/general/fulls_icon.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/general/fulls_icon.svg");
/* harmony import */ var _styles_icons_hover_fulls_icon_h_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../styles/icons/hover/fulls_icon_h.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/hover/fulls_icon_h.svg");
/* harmony import */ var _styles_icons_general_min_icon_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../styles/icons/general/min_icon.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/general/min_icon.svg");
/* harmony import */ var _styles_icons_hover_min_icon_h_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../styles/icons/hover/min_icon_h.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/hover/min_icon_h.svg");
/* harmony import */ var _styles_icons_general_mins_icon_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../styles/icons/general/mins_icon.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/general/mins_icon.svg");
/* harmony import */ var _styles_icons_hover_mins_icon_h_svg__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../styles/icons/hover/mins_icon_h.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/hover/mins_icon_h.svg");
/* harmony import */ var _styles_icons_general_max_icon_svg__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../styles/icons/general/max_icon.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/general/max_icon.svg");
/* harmony import */ var _styles_icons_hover_max_icon_h_svg__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../styles/icons/hover/max_icon_h.svg */ "./node_modules/@wiris/mathtype-html-integration-devkit/styles/icons/hover/max_icon_h.svg");
// eslint-disable-next-line max-classes-per-file










 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line
 //eslint-disable-line

/**
 * @typedef {Object} DeviceProperties
 * @property {String} DeviceProperties.orientation - Indicates of the orientation of the device.
 * @property {Boolean} DeviceProperties.isAndroid - True if the device is Android. False otherwise.
 * @property {Boolean} DeviceProperties.isIOS - True if the device is iOS. False otherwise.
 * @property {Boolean} DeviceProperties.isMobile - True if the device is a mobile one.
 * False otherwise.
 * @property {Boolean} DeviceProperties.isDesktop - True if the device is a desktop one.
 * False otherwise.
 */

class ModalDialog {
  /**
   * @classdesc
   * This class represents a modal dialog. The modal dialog admits
   * a {@link ContentManager} instance to manage the content of the dialog.
   * @constructs
   * @param {Object} modalDialogAttributes  - An object containing all modal dialog attributes.
   */
  constructor(modalDialogAttributes) {
    this.attributes = modalDialogAttributes;

    // Metrics.
    const ua = navigator.userAgent.toLowerCase();
    const isAndroid = ua.indexOf("android") > -1;
    const isIOS = _contentmanager__WEBPACK_IMPORTED_MODULE_5__["default"].isIOS();
    this.iosSoftkeyboardOpened = false;
    this.iosMeasureUnit = ua.indexOf("crios") === -1 ? "%" : "vh";
    this.iosDivHeight = `100%${this.iosMeasureUnit}`;

    const deviceWidth = window.outerWidth;
    const deviceHeight = window.outerHeight;

    const landscape = deviceWidth > deviceHeight;
    const portrait = deviceWidth < deviceHeight;

    // TODO: Detect isMobile without using editor metrics.
    const isLandscape = landscape && this.attributes.height > deviceHeight;
    const isPortrait = portrait && this.attributes.width > deviceWidth;
    const isMobile = _contentmanager__WEBPACK_IMPORTED_MODULE_5__["default"].isMobile();

    // Obtain number of current instance.
    this.instanceId = document.getElementsByClassName("wrs_modal_dialogContainer").length;

    // Device object properties.

    /**
     * @type {DeviceProperties}
     */
    this.deviceProperties = {
      orientation: landscape ? "landscape" : "portrait",
      isAndroid,
      isIOS,
      isMobile,
      isDesktop: !isMobile && !isIOS && !isAndroid,
    };

    this.properties = {
      created: false,
      state: "",
      previousState: "",
      position: { bottom: 0, right: 10 },
      size: { height: 338, width: 580 },
    };

    /**
     * Object to keep website's style before change it on lock scroll for mobile devices.
     * @type {Object}
     * @property {String} bodyStylePosition - Previous body style position.
     * @property {String} bodyStyleOverflow - Previous body style overflow.
     * @property {String} htmlStyleOverflow - Previous body style overflow.
     * @property {String} windowScrollX - Previous window's scroll Y.
     * @property {String} windowScrollY - Previous window's scroll X.
     */
    this.websiteBeforeLockParameters = null;

    let attributes = {};
    attributes.class = "wrs_modal_overlay";
    attributes.id = this.getElementId(attributes.class);
    this.overlay = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_modal_title_bar";
    attributes.id = this.getElementId(attributes.class);
    this.titleBar = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_modal_title";
    attributes.id = this.getElementId(attributes.class);
    this.title = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);
    this.title.innerHTML = "offline";

    attributes = {};
    attributes.class = "wrs_modal_close_button";
    attributes.id = this.getElementId(attributes.class);
    attributes.title = _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("close");
    attributes.style = {};
    this.closeDiv = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("a", attributes);
    this.closeDiv.setAttribute("role", "button");
    this.closeDiv.setAttribute("tabindex", 3);
    // Apply styles and events after the creation as createElement doesn't process them correctly
    let generalStyle = `background-size: 10px; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_close_icon_svg__WEBPACK_IMPORTED_MODULE_9__)})`;
    let hoverStyle = `background-size: 10px; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_hover_close_icon_h_svg__WEBPACK_IMPORTED_MODULE_10__)})`;
    this.closeDiv.setAttribute("style", generalStyle);
    this.closeDiv.setAttribute("onmouseover", `this.style = "${hoverStyle}";`);
    this.closeDiv.setAttribute("onmouseout", `this.style = "${generalStyle}";`);
    // To identifiy the element in automated testing
    this.closeDiv.setAttribute("data-testid", "mtcteditor-close-button");

    attributes = {};
    attributes.class = "wrs_modal_stack_button";
    attributes.id = this.getElementId(attributes.class);
    attributes.title = _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("exit_fullscreen");
    this.stackDiv = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("a", attributes);
    this.stackDiv.setAttribute("role", "button");
    this.stackDiv.setAttribute("tabindex", 2);
    generalStyle = `background-size: 10px; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_mins_icon_svg__WEBPACK_IMPORTED_MODULE_15__)})`;
    hoverStyle = `background-size: 10px; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_hover_mins_icon_h_svg__WEBPACK_IMPORTED_MODULE_16__)})`;
    this.stackDiv.setAttribute("style", generalStyle);
    this.stackDiv.setAttribute("onmouseover", `this.style = "${hoverStyle}";`);
    this.stackDiv.setAttribute("onmouseout", `this.style = "${generalStyle}";`);
    // To identifiy the element in automated testing
    this.stackDiv.setAttribute("data-testid", "mtcteditor-fullscreen-disable-button");

    attributes = {};
    attributes.class = "wrs_modal_maximize_button";
    attributes.id = this.getElementId(attributes.class);
    attributes.title = _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("fullscreen");
    this.maximizeDiv = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("a", attributes);
    this.maximizeDiv.setAttribute("role", "button");
    this.maximizeDiv.setAttribute("tabindex", 2);
    generalStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_fulls_icon_svg__WEBPACK_IMPORTED_MODULE_11__)})`;
    hoverStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_hover_fulls_icon_h_svg__WEBPACK_IMPORTED_MODULE_12__)})`;
    this.maximizeDiv.setAttribute("style", generalStyle);
    this.maximizeDiv.setAttribute("onmouseover", `this.style = "${hoverStyle}";`);
    this.maximizeDiv.setAttribute("onmouseout", `this.style = "${generalStyle}";`);
    // To identifiy the element in automated testing
    this.maximizeDiv.setAttribute("data-testid", "mtcteditor-fullscreen-enable-button");

    attributes = {};
    attributes.class = "wrs_modal_minimize_button";
    attributes.id = this.getElementId(attributes.class);
    attributes.title = _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("minimize");
    this.minimizeDiv = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("a", attributes);
    this.minimizeDiv.setAttribute("role", "button");
    this.minimizeDiv.setAttribute("tabindex", 1);
    generalStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_min_icon_svg__WEBPACK_IMPORTED_MODULE_13__)})`;
    hoverStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_hover_min_icon_h_svg__WEBPACK_IMPORTED_MODULE_14__)})`;
    this.minimizeDiv.setAttribute("style", generalStyle);
    this.minimizeDiv.setAttribute("onmouseover", `this.style = "${hoverStyle}";`);
    this.minimizeDiv.setAttribute("onmouseout", `this.style = "${generalStyle}";`);
    // To identify the element in automated testing
    this.minimizeDiv.setAttribute("data-testid", "mtcteditor-minimize-button");

    attributes = {};
    attributes.class = "wrs_modal_dialogContainer";
    attributes.id = this.getElementId(attributes.class);
    attributes.role = "dialog";
    this.container = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);
    this.container.setAttribute("aria-labeledby", "wrs_modal_title[0]");

    attributes = {};
    attributes.class = "wrs_modal_wrapper";
    attributes.id = this.getElementId(attributes.class);
    this.wrapper = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_content_container";
    attributes.id = this.getElementId(attributes.class);
    this.contentContainer = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_modal_controls";
    attributes.id = this.getElementId(attributes.class);
    this.controls = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);

    attributes = {};
    attributes.class = "wrs_modal_buttons_container";
    attributes.id = this.getElementId(attributes.class);
    this.buttonContainer = _util__WEBPACK_IMPORTED_MODULE_1__["default"].createElement("div", attributes);

    // Buttons: all button must be created using createSubmitButton method.
    this.submitButton = this.createSubmitButton(
      {
        id: this.getElementId("wrs_modal_button_accept"),
        class: "wrs_modal_button_accept",
        innerHTML: _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("accept"),
        // To identifiy the element in automated testing
        "data-testid": "mtcteditor-insert-button",
      },
      this.submitAction.bind(this),
    );

    this.cancelButton = this.createSubmitButton(
      {
        id: this.getElementId("wrs_modal_button_cancel"),
        class: "wrs_modal_button_cancel",
        innerHTML: _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("cancel"),
        // To identifiy the element in automated testing
        "data-testid": "mtcteditor-cancel-button",
      },
      this.cancelAction.bind(this),
    );

    this.contentManager = null;

    // Overlay popup.
    const popupStrings = {
      cancelString: _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("cancel"),
      submitString: _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("close"),
      message: _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("close_modal_warning"),
    };

    const callbacks = {
      closeCallback: () => {
        this.close("mtc_close");
      },
      cancelCallback: () => {
        this.focus();
      },
    };

    const popupupProperties = {
      overlayElement: this.container,
      callbacks,
      strings: popupStrings,
    };

    this.popup = new _popupmessage__WEBPACK_IMPORTED_MODULE_0__["default"](popupupProperties);

    /**
     * Indicates if directionality of the modal dialog is RTL. false by default.
     * @type {Boolean}
     */
    this.rtl = false;
    if ("rtl" in this.attributes) {
      this.rtl = this.attributes.rtl;
    }

    // Event handlers need modal instance context.
    this.handleOpenedIosSoftkeyboard = this.handleOpenedIosSoftkeyboard.bind(this);
    this.handleClosedIosSoftkeyboard = this.handleClosedIosSoftkeyboard.bind(this);
  }

  /**
   * This method sets an ContentManager instance to ModalDialog. ContentManager
   * manages the logic of ModalDialog content: submit, update, close and changes.
   * @param {ContentManager} contentManager - ContentManager instance.
   */
  setContentManager(contentManager) {
    this.contentManager = contentManager;
  }

  /**
   * Returns the modal contentElement object.
   * @returns {ContentManager} the instance of the ContentManager class.
   */
  getContentManager() {
    return this.contentManager;
  }

  /**
   * This method is called when the modal object has been submitted. Calls
   * contentElement submitAction method - if exists - and closes the modal
   * object. No logic about the content should be placed here,
   * contentElement.submitAction is the responsible of the content logic.
   */
  async submitAction() {
    if (typeof this.contentManager.submitAction !== "undefined") {
      this.contentManager.submitAction();
    }

    await this.close("mtc_insert");
  }

  /**
   * Performs the cancel action.
   * If there are no changes in the content, it closes the modal.
   * Otherwise, it shows a pop-up message to confirm the cancel action.
   * @returns {Promise<void>} - A promise that resolves when the modal is closed.
   */
  async cancelAction() {
    if (typeof this.contentManager.hasChanges === "undefined" || !this.contentManager.hasChanges()) {
      _integrationmodel__WEBPACK_IMPORTED_MODULE_7__["default"].setActionsOnCancelButtons();
      await this.close("mtc_close");
    } else {
      this.showPopUpMessage();
    }
  }

  /**
   * Returns a button element.
   * @param {Object} properties - Input button properties.
   * @param {String} properties.class - Input button class.
   * @param {String} properties.innerHTML - Input button innerHTML.
   * @param {Object} callback - Callback function associated to click event.
   * @returns {HTMLButtonElement} The button element.
   *
   */
  // eslint-disable-next-line class-methods-use-this
  createSubmitButton(properties, callback) {
    class SubmitButton {
      constructor() {
        this.element = document.createElement("button");
        this.element.id = properties.id;
        this.element.className = properties.class;
        this.element.innerHTML = properties.innerHTML;
        this.element.dataset.testid = properties["data-testid"];
        _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(this.element, "click", callback);
      }

      getElement() {
        return this.element;
      }
    }
    return new SubmitButton(properties, callback).getElement();
  }

  /**
   * Creates the modal window object inserting a contentElement object.
   */
  create() {
    /* Modal Window Structure
    _____________________________________________________________________________________
    |wrs_modal_dialog_Container                                                         |
    | _________________________________________________________________________________ |
    | |title_bar                          minimize_button  stack_button  close_button | |
    | |_______________________________________________________________________________| |
    | |wrapper                                                                        | |
    | | _____________________________________________________________________________ | |
    | | |content                                                                    | | |
    | | |                                                                           | | |
    | | |                                                                           | | |
    | | |___________________________________________________________________________| | |
    | | _____________________________________________________________________________ | |
    | | |controls                                                                   | | |
    | | | ___________________________________                                       | | |
    | | | |buttonContainer                  |                                       | | |
    | | | | _______________________________ |                                       | | |
    | | | | |button_accept | button_cancel| |                                       | | |
    | | | |_|_____________ |______________|_|                                       | | |
    | | |___________________________________________________________________________| | |
    | |_______________________________________________________________________________| |
    |___________________________________________________________________________________| */

    this.titleBar.appendChild(this.closeDiv);
    this.titleBar.appendChild(this.stackDiv);
    this.titleBar.appendChild(this.maximizeDiv);
    this.titleBar.appendChild(this.minimizeDiv);
    this.titleBar.appendChild(this.title);

    if (this.deviceProperties.isDesktop) {
      this.container.appendChild(this.titleBar);
    }

    this.wrapper.appendChild(this.contentContainer);
    this.wrapper.appendChild(this.controls);

    this.controls.appendChild(this.buttonContainer);

    this.buttonContainer.appendChild(this.submitButton);
    this.buttonContainer.appendChild(this.cancelButton);

    this.container.appendChild(this.wrapper);

    // Check if browser has scrollBar before modal has modified.
    this.recalculateScrollBar();

    document.body.appendChild(this.container);
    document.body.appendChild(this.overlay);

    if (this.deviceProperties.isDesktop) {
      // Desktop.
      this.createModalWindowDesktop();
      this.createResizeButtons();

      this.addListeners();
      // Maximize window only when the configuration is set and the device is not iOS or Android.
      if (_configuration__WEBPACK_IMPORTED_MODULE_2__["default"].get("modalWindowFullScreen")) {
        this.maximize();
      }
    } else if (this.deviceProperties.isAndroid) {
      this.createModalWindowAndroid();
    } else if (this.deviceProperties.isIOS) {
      this.createModalWindowIos();
    }

    if (this.contentManager != null) {
      this.contentManager.insert(this);
    }

    this.properties.open = true;
    this.properties.created = true;

    // Checks language directionality.
    if (this.isRTL()) {
      this.container.style.right = `${window.innerWidth - this.scrollbarWidth - this.container.offsetWidth}px`;
      this.container.className += " wrs_modal_rtl";
    }
  }

  /**
   * Creates a button in the modal object to resize it.
   */
  createResizeButtons() {
    // This is a definition of Resize Button Bottom-Right.
    this.resizerBR = document.createElement("div");
    this.resizerBR.className = "wrs_bottom_right_resizer";
    this.resizerBR.innerHTML = "◢";
    // To identifiy the element in automated testing
    this.resizerBR.dataset.testid = "mtcteditor-resize-button-right";
    // This is a definition of Resize Button Top-Left.
    this.resizerTL = document.createElement("div");
    this.resizerTL.className = "wrs_bottom_left_resizer";
    // To identifiy the element in automated testing
    this.resizerTL.dataset.testid = "mtcteditor-resize-button-left";
    // Append resize buttons to modal.
    this.container.appendChild(this.resizerBR);
    this.titleBar.appendChild(this.resizerTL);
    // Add events to resize on click and drag.
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(this.resizerBR, "mousedown", this.activateResizeStateBR.bind(this));
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(this.resizerTL, "mousedown", this.activateResizeStateTL.bind(this));
  }

  /**
   * Initialize variables for Bottom-Right resize button
   * @param {MouseEvent} mouseEvent - Mouse event.
   */
  activateResizeStateBR(mouseEvent) {
    this.initializeResizeProperties(mouseEvent, false);
  }

  /**
   * Initialize variables for Top-Left resize button
   * @param {MouseEvent} mouseEvent - Mouse event.
   */
  activateResizeStateTL(mouseEvent) {
    this.initializeResizeProperties(mouseEvent, true);
  }

  /**
   * Common method to initialize variables at resize.
   * @param {MouseEvent} mouseEvent - Mouse event.
   */
  initializeResizeProperties(mouseEvent, leftOption) {
    // Apply class for disable involuntary select text when drag.
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(document.body, "wrs_noselect");
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.overlay, "wrs_overlay_active");
    this.resizeDataObject = {
      x: this.eventClient(mouseEvent).X,
      y: this.eventClient(mouseEvent).Y,
    };
    // Save Initial state of modal to compare on drag and obtain the difference.
    this.initialWidth = parseInt(this.container.style.width, 10);
    this.initialHeight = parseInt(this.container.style.height, 10);
    if (!leftOption) {
      this.initialRight = parseInt(this.container.style.right, 10);
      this.initialBottom = parseInt(this.container.style.bottom, 10);
    } else {
      this.leftScale = true;
    }
    if (!this.initialRight) {
      this.initialRight = 0;
    }
    if (!this.initialBottom) {
      this.initialBottom = 0;
    }
    // Disable mouse events on editor when we start to drag modal.
    document.body.style["user-select"] = "none";
  }

  /**
   * This method opens the modal window, restoring the previous state, position and metrics,
   * if exists. By default the modal object opens in stack mode.
   */
  open() {
    // Removing close class.
    this.removeClass("wrs_closed");
    // Hiding keyboard for mobile devices.
    const { isIOS } = this.deviceProperties;
    const { isAndroid } = this.deviceProperties;
    const { isMobile } = this.deviceProperties;
    if (isIOS || isAndroid || isMobile) {
      // Restore scale to 1.
      this.restoreWebsiteScale();
      this.lockWebsiteScroll();
      // Due to editor wait we need to wait until editor focus.
      setTimeout(() => {
        this.hideKeyboard();
      }, 400);
    }

    // New modal window. He need to create the whole object.
    if (!this.properties.created) {
      this.create();
    } else {
      // Previous state closed. Open method can be called even the previous state is open,
      // for example updating the content of the modal object.
      if (!this.properties.open) {
        this.properties.open = true;

        // Restoring the previous open state: if the modal object has been closed
        // re-open it should preserve the state and the metrics.
        if (!this.deviceProperties.isAndroid && !this.deviceProperties.isIOS) {
          this.restoreState();
        }
      }

      // Maximize window only when the configuration is set and the device is not iOs or Android.
      if (this.deviceProperties.isDesktop && _configuration__WEBPACK_IMPORTED_MODULE_2__["default"].get("modalWindowFullScreen")) {
        this.maximize();
      }

      // In iOS we need to recalculate the size of the modal object because
      // iOS keyboard is a float div which can overlay the modal object.
      if (this.deviceProperties.isIOS) {
        this.iosSoftkeyboardOpened = false;
        this.setContainerHeight(`${100 + this.iosMeasureUnit}`);
      }
    }

    if (!_contentmanager__WEBPACK_IMPORTED_MODULE_5__["default"].isEditorLoaded()) {
      const listener = _listeners__WEBPACK_IMPORTED_MODULE_3__["default"].newListener("onLoad", () => {
        this.contentManager.onOpen(this);
      });
      this.contentManager.addListener(listener);
    } else {
      this.contentManager.onOpen(this);
    }
  }

  /**
   * Closes the modal.
   * Removes specific CSS classes, saves modal properties, unlocks website scroll,
   * sets the 'open' property to false, and triggers the 'onModalClose' event.
   * If a close trigger is defined, it tracks the telemetry event 'CLOSED_MTCT_EDITOR' with the trigger.
   * @returns {Promise<void>} A promise that resolves when the modal is closed.
   */
  async close(trigger) {
    this.removeClass("wrs_maximized");
    this.removeClass("wrs_minimized");
    this.removeClass("wrs_stack");
    this.addClass("wrs_closed");
    this.saveModalProperties();
    this.unlockWebsiteScroll();
    this.properties.open = false;

    if (trigger) {
      try {
        await _telemeter__WEBPACK_IMPORTED_MODULE_6__["default"].telemeter.track("CLOSED_MTCT_EDITOR", {
          toolbar: this.contentManager.toolbar,
          trigger: trigger,
        });
      } catch (error) {
        console.error("Error tracking CLOSED_MTCT_EDITOR", error);
      }
    }

    _core_src__WEBPACK_IMPORTED_MODULE_8__["default"].globalListeners.fire("onModalClose", {});
  }
  /**
   * Closes modal window and destroys the object.
   */
  destroy() {
    // Close modal window.
    this.close();
    // Remove listeners and destroy the object.
    this.removeListeners();
    this.overlay.remove();
    this.container.remove();
    // Reset properties to allow open again.
    this.properties.created = false;
  }

  /**
   * Sets the website scale to one.
   */
  // eslint-disable-next-line class-methods-use-this
  restoreWebsiteScale() {
    let viewportmeta = document.querySelector("meta[name=viewport]");
    // Let the equal symbols in order to search and make meta's final content.
    const contentAttrsToUpdate = ["initial-scale=", "minimum-scale=", "maximum-scale="];
    const contentAttrsValuesToUpdate = ["1.0", "1.0", "1.0"];
    const setMetaAttrFunc = (viewportelement, contentAttrs) => {
      const contentAttr = viewportelement.getAttribute("content");
      // If it exists, we need to maintain old values and put our values.
      if (contentAttr) {
        const attrArray = contentAttr.split(",");
        let finalContentMeta = "";
        const oldAttrs = [];
        for (let i = 0; i < attrArray.length; i += 1) {
          let isAttrToUpdate = false;
          let j = 0;
          while (!isAttrToUpdate && j < contentAttrs.length) {
            if (attrArray[i].indexOf(contentAttrs[j])) {
              isAttrToUpdate = true;
            }
            j += 1;
          }

          if (!isAttrToUpdate) {
            oldAttrs.push(attrArray[i]);
          }
        }

        for (let i = 0; i < contentAttrs.length; i += 1) {
          const attr = contentAttrs[i] + contentAttrsValuesToUpdate[i];
          finalContentMeta += i === 0 ? attr : `,${attr}`;
        }

        for (let i = 0; i < oldAttrs.length; i += 1) {
          finalContentMeta += `,${oldAttrs[i]}`;
        }
        viewportelement.setAttribute("content", finalContentMeta);
        // It needs to set to empty because setAttribute refresh only when attribute is different.
        viewportelement.setAttribute("content", "");
        viewportelement.setAttribute("content", contentAttr);
      } else {
        viewportelement.setAttribute("content", "initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0");
        viewportelement.removeAttribute("content");
      }
    };

    if (!viewportmeta) {
      viewportmeta = document.createElement("meta");
      document.getElementsByTagName("head")[0].appendChild(viewportmeta);
      setMetaAttrFunc(viewportmeta, contentAttrsToUpdate, contentAttrsValuesToUpdate);
      viewportmeta.remove();
    } else {
      setMetaAttrFunc(viewportmeta, contentAttrsToUpdate, contentAttrsValuesToUpdate);
    }
  }

  /**
   * Locks website scroll for mobile devices.
   */
  lockWebsiteScroll() {
    this.websiteBeforeLockParameters = {
      bodyStylePosition: document.body.style.position ? document.body.style.position : "",
      bodyStyleOverflow: document.body.style.overflow ? document.body.style.overflow : "",
      htmlStyleOverflow: document.documentElement.style.overflow ? document.documentElement.style.overflow : "",
      windowScrollX: window.scrollX,
      windowScrollY: window.scrollY,
    };
  }

  /**
   * Unlocks website scroll for mobile devices.
   */
  unlockWebsiteScroll() {
    if (this.websiteBeforeLockParameters) {
      document.body.style.position = this.websiteBeforeLockParameters.bodyStylePosition;
      document.body.style.overflow = this.websiteBeforeLockParameters.bodyStyleOverflow;
      document.documentElement.style.overflow = this.websiteBeforeLockParameters.htmlStyleOverflow;
      const { windowScrollX } = this.websiteBeforeLockParameters;
      const { windowScrollY } = this.websiteBeforeLockParameters;
      window.scrollTo(windowScrollX, windowScrollY);
      this.websiteBeforeLockParameters = null;
    }
  }

  /**
   * Util function to known if browser is IE11.
   * @returns {Boolean} true if the browser is IE11. false otherwise.
   */
  // eslint-disable-next-line class-methods-use-this
  isIE11() {
    if (
      navigator.userAgent.search("Msie/") >= 0 ||
      navigator.userAgent.search("Trident/") >= 0 ||
      navigator.userAgent.search("Edge/") >= 0
    ) {
      return true;
    }
    return false;
  }

  /**
   * Returns if the current language type is RTL.
   * @return {Boolean} true if current language is RTL. false otherwise.
   */
  isRTL() {
    if (this.attributes.language === "ar" || this.attributes.language === "he") {
      return true;
    }
    return this.rtl;
  }

  /**
   * Adds a class to all modal ModalDialog DOM elements.
   * @param {String} className - Class name.
   */
  addClass(className) {
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.overlay, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.titleBar, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.overlay, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.container, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.contentContainer, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.stackDiv, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.minimizeDiv, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.maximizeDiv, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.wrapper, className);
  }

  /**
   * Remove a class from all modal DOM elements.
   * @param {String} className - Class name.
   */
  removeClass(className) {
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.overlay, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.titleBar, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.overlay, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.container, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.contentContainer, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.stackDiv, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.minimizeDiv, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.maximizeDiv, className);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.wrapper, className);
  }

  /**
   * Create modal dialog for desktop.
   */
  createModalWindowDesktop() {
    this.addClass("wrs_modal_desktop");
    this.stack();
  }

  /**
   * Create modal dialog for non android devices.
   */
  createModalWindowAndroid() {
    this.addClass("wrs_modal_android");
    window.addEventListener("resize", this.orientationChangeAndroidSoftkeyboard.bind(this));
  }

  /**
   * Create modal dialog for iOS devices.
   */
  createModalWindowIos() {
    this.addClass("wrs_modal_ios");
    // Refresh the size when the orientation is changed.
    window.addEventListener("resize", this.orientationChangeIosSoftkeyboard.bind(this));
  }

  /**
   * Restore previous state, position and size of previous stacked modal dialog.
   */
  restoreState() {
    if (this.properties.state === "maximized") {
      // Reset states for prevent return to stack state.
      this.maximize();
    } else if (this.properties.state === "minimized") {
      // Reset states for prevent return to stack state.
      this.properties.state = this.properties.previousState;
      this.properties.previousState = "";
      this.minimize();
    } else {
      this.stack();
    }
  }

  /**
   * Stacks the modal object.
   */
  stack() {
    this.properties.previousState = this.properties.state;
    this.properties.state = "stack";
    this.removeClass("wrs_maximized");
    this.minimizeDiv.title = _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("minimize");
    this.removeClass("wrs_minimized");
    this.addClass("wrs_stack");

    // Change maximize/minimize icon to minimize icon
    const generalStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_min_icon_svg__WEBPACK_IMPORTED_MODULE_13__)})`;
    const hoverStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_hover_min_icon_h_svg__WEBPACK_IMPORTED_MODULE_14__)})`;
    this.minimizeDiv.setAttribute("style", generalStyle);
    this.minimizeDiv.setAttribute("onmouseover", `this.style = "${hoverStyle}";`);
    this.minimizeDiv.setAttribute("onmouseout", `this.style = "${generalStyle}";`);

    this.restoreModalProperties();

    if (typeof this.resizerBR !== "undefined" && typeof this.resizerTL !== "undefined") {
      this.setResizeButtonsVisibility();
    }

    // Need recalculate position of actual modal because window can was changed in fullscreenmode.
    this.recalculateScrollBar();
    this.recalculatePosition();
    this.recalculateScale();
    this.focus();
  }

  /**
   * Minimizes the modal object.
   */
  minimize() {
    // Saving width, height, top and bottom parameters to restore when opening.
    this.saveModalProperties();
    this.title.style.cursor = "pointer";
    if (this.properties.state === "minimized" && this.properties.previousState === "stack") {
      this.stack();
    } else if (this.properties.state === "minimized" && this.properties.previousState === "maximized") {
      this.maximize();
    } else {
      // Setting css to prevent important tag into css style.
      this.container.style.height = "30px";
      this.container.style.width = "250px";
      this.container.style.bottom = "0px";
      this.container.style.right = "10px";

      this.removeListeners();
      this.properties.previousState = this.properties.state;
      this.properties.state = "minimized";
      this.setResizeButtonsVisibility();
      this.minimizeDiv.title = _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("maximize");

      if (_util__WEBPACK_IMPORTED_MODULE_1__["default"].containsClass(this.overlay, "wrs_stack")) {
        this.removeClass("wrs_stack");
      } else {
        this.removeClass("wrs_maximized");
      }
      this.addClass("wrs_minimized");

      // Change minimize icon to maximize icon
      const generalStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_max_icon_svg__WEBPACK_IMPORTED_MODULE_17__)})`;
      const hoverStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_hover_max_icon_h_svg__WEBPACK_IMPORTED_MODULE_18__)})`;
      this.minimizeDiv.setAttribute("style", generalStyle);
      this.minimizeDiv.setAttribute("onmouseover", `this.style = "${hoverStyle}";`);
      this.minimizeDiv.setAttribute("onmouseout", `this.style = "${generalStyle}";`);
    }
  }

  /**
   * Maximizes the modal object.
   */
  maximize() {
    // Saving width, height, top and bottom parameters to restore when opening.
    this.saveModalProperties();
    if (this.properties.state !== "maximized") {
      this.properties.previousState = this.properties.state;
      this.properties.state = "maximized";
    }
    // Don't permit resize on maximize mode.
    this.setResizeButtonsVisibility();

    if (_util__WEBPACK_IMPORTED_MODULE_1__["default"].containsClass(this.overlay, "wrs_minimized")) {
      this.minimizeDiv.title = _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("minimize");
      this.removeClass("wrs_minimized");
    } else if (_util__WEBPACK_IMPORTED_MODULE_1__["default"].containsClass(this.overlay, "wrs_stack")) {
      this.container.style.left = null;
      this.container.style.top = null;
      this.removeClass("wrs_stack");
    }

    this.addClass("wrs_maximized");

    // Change maximize icon to minimize icon
    const generalStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_general_min_icon_svg__WEBPACK_IMPORTED_MODULE_13__)})`;
    const hoverStyle = `background-size: 10px; background-repeat: no-repeat; background-image: url(data:image/svg+xml;base64,${window.btoa(_styles_icons_hover_min_icon_h_svg__WEBPACK_IMPORTED_MODULE_14__)})`;
    this.minimizeDiv.setAttribute("style", generalStyle);
    this.minimizeDiv.setAttribute("onmouseover", `this.style = "${hoverStyle}";`);
    this.minimizeDiv.setAttribute("onmouseout", `this.style = "${generalStyle}";`);

    // Set size to 80% screen with a max size.
    this.setSize(parseInt(window.innerHeight * 0.8, 10), parseInt(window.innerWidth * 0.8, 10));
    if (this.container.clientHeight > 700) {
      this.container.style.height = "700px";
    }
    if (this.container.clientWidth > 1200) {
      this.container.style.width = "1200px";
    }

    // Setting modal position in center on screen.
    const { innerHeight } = window;
    const { innerWidth } = window;
    const { offsetHeight } = this.container;
    const { offsetWidth } = this.container;
    const bottom = innerHeight / 2 - offsetHeight / 2;
    const right = innerWidth / 2 - offsetWidth / 2;

    this.setPosition(bottom, right);
    this.recalculateScale();
    this.recalculatePosition();
    this.recalculateSize();
    this.focus();
  }

  /**
   * Expand again the modal object from a minimized state.
   */
  reExpand() {
    if (this.properties.state === "minimized") {
      if (this.properties.previousState === "maximized") {
        this.maximize();
      } else {
        this.stack();
      }
      this.title.style.cursor = "";
    }
  }

  /**
   * Sets modal size.
   * @param {Number} height - Height of the ModalDialog
   * @param {Number} width - Width of the ModalDialog.
   */
  setSize(height, width) {
    this.container.style.height = `${height}px`;
    this.container.style.width = `${width}px`;
    this.recalculateSize();
  }

  /**
   * Sets modal position using bottom and right style attributes.
   * @param  {number} bottom - bottom attribute.
   * @param  {number} right - right attribute.
   */
  setPosition(bottom, right) {
    this.container.style.bottom = `${bottom}px`;
    this.container.style.right = `${right}px`;
  }

  /**
   * Saves position and size parameters of and open ModalDialog. This attributes
   * are needed to restore it on re-open.
   */
  saveModalProperties() {
    // Saving values of modal only when modal is in stack state.
    if (this.properties.state === "stack") {
      this.properties.position.bottom = parseInt(this.container.style.bottom, 10);
      this.properties.position.right = parseInt(this.container.style.right, 10);
      this.properties.size.width = parseInt(this.container.style.width, 10);
      this.properties.size.height = parseInt(this.container.style.height, 10);
    }
  }

  /**
   * Restore ModalDialog position and size parameters.
   */
  restoreModalProperties() {
    if (this.properties.state === "stack") {
      // Restoring Bottom and Right values from last modal.
      this.setPosition(this.properties.position.bottom, this.properties.position.right);
      // Restoring Height and Left values from last modal.
      this.setSize(this.properties.size.height, this.properties.size.width);
    }
  }

  /**
   * Sets the modal dialog initial size.
   */
  recalculateSize() {
    this.wrapper.style.width = `${this.container.clientWidth - 12}px`;
    this.wrapper.style.height = `${this.container.clientHeight - 38}px`;
    this.contentContainer.style.height = `${parseInt(this.wrapper.offsetHeight - 50, 10)}px`;
  }

  /**
   * Enable or disable visibility of resize buttons in modal window depend on state.
   */
  setResizeButtonsVisibility() {
    if (this.properties.state === "stack") {
      this.resizerTL.style.visibility = "visible";
      this.resizerBR.style.visibility = "visible";
    } else {
      this.resizerTL.style.visibility = "hidden";
      this.resizerBR.style.visibility = "hidden";
    }
  }

  /**
   * Makes an object draggable adding mouse and touch events.
   */
  addListeners() {
    // Button events (maximize, minimize, stack and close).
    this.maximizeDiv.addEventListener("click", this.maximize.bind(this), true);
    this.stackDiv.addEventListener("click", this.stack.bind(this), true);
    this.minimizeDiv.addEventListener("click", this.minimize.bind(this), true);
    this.closeDiv.addEventListener("click", this.cancelAction.bind(this));
    this.maximizeDiv.addEventListener(
      "keypress",
      function (e) {
        if (e.key === "Enter" || e.key === " " || e.keyCode === 13 || e.keyCode === 32) {
          // Handle enter and space.
          e.target.click();
        }
      },
      true,
    );
    this.stackDiv.addEventListener(
      "keypress",
      function (e) {
        if (e.key === "Enter" || e.key === " " || e.keyCode === 13 || e.keyCode === 32) {
          // Handle enter and space.
          e.target.click();
          e.preventDefault();
        }
      },
      true,
    );
    this.minimizeDiv.addEventListener(
      "keypress",
      function (e) {
        if (e.key === "Enter" || e.key === " " || e.keyCode === 13 || e.keyCode === 32) {
          // Handle enter and space.
          e.target.click();
          e.preventDefault();
        }
      },
      true,
    );
    this.closeDiv.addEventListener("keypress", function (e) {
      if (e.key === "Enter" || e.key === " " || e.keyCode === 13 || e.keyCode === 32) {
        // Handle enter and space.
        e.target.click();
        e.preventDefault();
      }
    });
    this.title.addEventListener("click", this.reExpand.bind(this));

    // Overlay events (close).
    this.overlay.addEventListener("click", this.cancelAction.bind(this));

    // Mouse events.
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(window, "mousedown", this.startDrag.bind(this));
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(window, "mouseup", this.stopDrag.bind(this));
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(window, "mousemove", this.drag.bind(this));
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(window, "resize", this.onWindowResize.bind(this));
    // Key events.
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].addEvent(window, "keydown", this.onKeyDown.bind(this));
  }

  /**
   * Removes draggable events from an object.
   */
  removeListeners() {
    // Mouse events.
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeEvent(window, "mousedown", this.startDrag);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeEvent(window, "mouseup", this.stopDrag);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeEvent(window, "mousemove", this.drag);
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeEvent(window, "resize", this.onWindowResize);
    // Key events.
    _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeEvent(window, "keydown", this.onKeyDown);
  }

  /**
   * Returns mouse or touch coordinates (on touch events ev.ClientX doesn't exists)
   * @param {MouseEvent} mouseEvent - Mouse event.
   * @return {Object} With the X and Y coordinates.
   */
  // eslint-disable-next-line class-methods-use-this
  eventClient(mouseEvent) {
    if (typeof mouseEvent.clientX === "undefined" && mouseEvent.changedTouches) {
      const client = {
        X: mouseEvent.changedTouches[0].clientX,
        Y: mouseEvent.changedTouches[0].clientY,
      };
      return client;
    }
    const client = {
      X: mouseEvent.clientX,
      Y: mouseEvent.clientY,
    };
    return client;
  }

  /**
   * Start drag function: set the object dragDataObject with the draggable
   * object offsets coordinates.
   * when drag starts (on touchstart or mousedown events).
   * @param {MouseEvent} mouseEvent - Touchstart or mousedown event.
   */
  startDrag(mouseEvent) {
    if (this.properties.state === "minimized") {
      return;
    }
    if (mouseEvent.target === this.title) {
      if (typeof this.dragDataObject === "undefined" || this.dragDataObject === null) {
        // Save first click mouse point on screen.
        this.dragDataObject = {
          x: this.eventClient(mouseEvent).X,
          y: this.eventClient(mouseEvent).Y,
        };
        // Reset last drag position when start drag.
        this.lastDrag = {
          x: "0px",
          y: "0px",
        };
        // Init right and bottom values for window modal if it isn't exist.
        if (this.container.style.right === "") {
          this.container.style.right = "0px";
        }
        if (this.container.style.bottom === "") {
          this.container.style.bottom = "0px";
        }

        // Needed for IE11 for apply disabled mouse events on editor because
        // internet explorer needs a dynamic object to apply this property.
        if (this.isIE11()) {
          // this.iframe.style['position'] = 'relative';
        }
        // Apply class for disable involuntary select text when drag.
        _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(document.body, "wrs_noselect");
        _util__WEBPACK_IMPORTED_MODULE_1__["default"].addClass(this.overlay, "wrs_overlay_active");
        // Obtain screen limits for prevent overflow.
        this.limitWindow = this.getLimitWindow();
      }
    }
  }

  /**
   * Updates dragDataObject with the draggable object coordinates when
   * the draggable object is being moved.
   * @param {MouseEvent} mouseEvent - The mouse event.
   */
  drag(mouseEvent) {
    if (this.dragDataObject) {
      mouseEvent.preventDefault();
      // Calculate max and min between actual mouse position and limit of screeen.
      // It restric the movement of modal into window.
      let limitY = Math.min(this.eventClient(mouseEvent).Y, this.limitWindow.minPointer.y);
      limitY = Math.max(this.limitWindow.maxPointer.y, limitY);
      let limitX = Math.min(this.eventClient(mouseEvent).X, this.limitWindow.minPointer.x);
      limitX = Math.max(this.limitWindow.maxPointer.x, limitX);
      // Subtract limit with first position to obtain relative pixels increment
      // to the anchor point.
      const dragX = `${limitX - this.dragDataObject.x}px`;
      const dragY = `${limitY - this.dragDataObject.y}px`;
      // Save last valid position of modal before window overflow.
      this.lastDrag = {
        x: dragX,
        y: dragY,
      };
      // This move modal with hardware acceleration.
      this.container.style.transform = `translate3d(${dragX},${dragY},0)`;
    }
    if (this.resizeDataObject) {
      const { innerWidth } = window;
      const { innerHeight } = window;
      let limitX = Math.min(this.eventClient(mouseEvent).X, innerWidth - this.scrollbarWidth - 7);
      let limitY = Math.min(this.eventClient(mouseEvent).Y, innerHeight - 7);
      if (limitX < 0) {
        limitX = 0;
      }

      if (limitY < 0) {
        limitY = 0;
      }

      let scaleMultiplier;
      if (this.leftScale) {
        scaleMultiplier = -1;
      } else {
        scaleMultiplier = 1;
      }

      this.container.style.width = `${this.initialWidth + scaleMultiplier * (limitX - this.resizeDataObject.x)}px`;
      this.container.style.height = `${this.initialHeight + scaleMultiplier * (limitY - this.resizeDataObject.y)}px`;
      if (!this.leftScale) {
        if (this.resizeDataObject.x - limitX - this.initialWidth < -580) {
          this.container.style.right = `${this.initialRight - (limitX - this.resizeDataObject.x)}px`;
        } else {
          this.container.style.right = `${this.initialRight + this.initialWidth - 580}px`;
          this.container.style.width = "580px";
        }
        if (this.resizeDataObject.y - limitY < this.initialHeight - 338) {
          this.container.style.bottom = `${this.initialBottom - (limitY - this.resizeDataObject.y)}px`;
        } else {
          this.container.style.bottom = `${this.initialBottom + this.initialHeight - 338}px`;
          this.container.style.height = "338px";
        }
      }
      this.recalculateScale();
      this.recalculatePosition();
    }
  }

  /**
   * Returns the boundaries of actual window to limit modal movement.
   * @return {Object} Object containing mouseX and mouseY coordinates of actual mouse on screen.
   */
  getLimitWindow() {
    // Obtain dimensions of window page.
    const maxWidth = window.innerWidth;
    const maxHeight = window.innerHeight;

    // Calculate relative position of mouse point into window.
    const { offsetHeight } = this.container;
    const contStyleBottom = parseInt(this.container.style.bottom, 10);
    const contStyleRight = parseInt(this.container.style.right, 10);

    const { pageXOffset } = window;
    const dragY = this.dragDataObject.y;
    const dragX = this.dragDataObject.x;

    const offSetToolbarY = offsetHeight + contStyleBottom - (maxHeight - (dragY - pageXOffset));
    const offSetToolbarX = maxWidth - this.scrollbarWidth - (dragX - pageXOffset) - contStyleRight;

    // Calculate limits with sizes of window, modal and mouse position.
    const minPointerY = maxHeight - this.container.offsetHeight + offSetToolbarY;
    const maxPointerY = this.title.offsetHeight - (this.title.offsetHeight - offSetToolbarY);
    const minPointerX = maxWidth - offSetToolbarX - this.scrollbarWidth;
    const maxPointerX = this.container.offsetWidth - offSetToolbarX;
    const minPointer = { x: minPointerX, y: minPointerY };
    const maxPointer = { x: maxPointerX, y: maxPointerY };
    return { minPointer, maxPointer };
  }

  /**
   * Returns the scrollbar width size of browser
   * @returns {Number} The scrollbar width.
   */
  // eslint-disable-next-line class-methods-use-this
  getScrollBarWidth() {
    // Create a paragraph with full width of page.
    const inner = document.createElement("p");
    inner.style.width = "100%";
    inner.style.height = "200px";

    // Create a hidden div to compare sizes.
    const outer = document.createElement("div");
    outer.style.position = "absolute";
    outer.style.top = "0px";
    outer.style.left = "0px";
    outer.style.visibility = "hidden";
    outer.style.width = "200px";
    outer.style.height = "150px";
    outer.style.overflow = "hidden";
    outer.appendChild(inner);

    document.body.appendChild(outer);
    const widthOuter = inner.offsetWidth;

    // Change type overflow of paragraph for measure scrollbar.
    outer.style.overflow = "scroll";
    let widthInner = inner.offsetWidth;

    // If measure is the same, we compare with internal div.
    if (widthOuter === widthInner) {
      widthInner = outer.clientWidth;
    }
    document.body.removeChild(outer);

    return widthOuter - widthInner;
  }

  /**
   * Set the dragDataObject to null.
   */
  stopDrag() {
    // Due to we have multiple events that call this function, we need only to execute
    // the next modifiers one time,
    // when the user stops to drag and dragDataObject is not null (the object to drag is attached).
    if (this.dragDataObject || this.resizeDataObject) {
      // If modal doesn't change, it's not necessary to set position with interpolation.
      this.container.style.transform = "";
      if (this.dragDataObject) {
        this.container.style.right = `${parseInt(this.container.style.right, 10) - parseInt(this.lastDrag.x, 10)}px`;
        this.container.style.bottom = `${parseInt(this.container.style.bottom, 10) - parseInt(this.lastDrag.y, 10)}px`;
      }
      // We make focus on editor after drag modal windows to prevent lose focus.
      this.focus();
      // Restore mouse events on iframe.
      // this.iframe.style['pointer-events'] = 'auto';
      document.body.style["user-select"] = "";
      // Restore static state of iframe if we use Internet Explorer.
      if (this.isIE11()) {
        // this.iframe.style['position'] = null;
      }
      // Active text select event.
      _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(document.body, "wrs_noselect");
      _util__WEBPACK_IMPORTED_MODULE_1__["default"].removeClass(this.overlay, "wrs_overlay_active");
    }
    this.dragDataObject = null;
    this.resizeDataObject = null;
    this.initialWidth = null;
    this.leftScale = null;
  }

  /**
   * Recalculates scale for modal when resize browser window.
   */
  onWindowResize() {
    this.recalculateScrollBar();
    this.recalculatePosition();
    this.recalculateScale();
  }

  /**
   * Triggers keyboard events:
   * - Tab key tab to go to submit button.
   * - Esc key to close the modal dialog.
   * @param {KeyboardEvent} keyboardEvent - The keyboard event.
   */
  onKeyDown(keyboardEvent) {
    if (keyboardEvent.key !== undefined) {
      // Popupmessage is not oppened.
      if (this.popup.overlayWrapper.style.display !== "block") {
        // Code to detect Esc event
        if (keyboardEvent.key === "Escape" || keyboardEvent.key === "Esc") {
          if (this.properties.open) {
            this.contentManager.onKeyDown(keyboardEvent);
          }
        } else if (keyboardEvent.shiftKey && keyboardEvent.key === "Tab") {
          // Code to detect shift Tab event.
          if (document.activeElement === this.cancelButton) {
            this.submitButton.focus();
            keyboardEvent.stopPropagation();
            keyboardEvent.preventDefault();
          } else {
            this.contentManager.onKeyDown(keyboardEvent);
          }
        } else if (keyboardEvent.key === "Tab") {
          // Code to detect Tab event.
          if (document.activeElement === this.submitButton) {
            this.cancelButton.focus();
            keyboardEvent.stopPropagation();
            keyboardEvent.preventDefault();
          } else {
            this.contentManager.onKeyDown(keyboardEvent);
          }
        }
      } else {
        // Popupmessage oppened.
        this.popup.onKeyDown(keyboardEvent);
      }
    }
  }

  /**
   * Recalculating position for modal dialog when the browser is resized.
   */
  recalculatePosition() {
    this.container.style.right = `${Math.min(parseInt(this.container.style.right, 10), window.innerWidth - this.scrollbarWidth - this.container.offsetWidth)}px`;
    if (parseInt(this.container.style.right, 10) < 0) {
      this.container.style.right = "0px";
    }
    this.container.style.bottom = `${Math.min(parseInt(this.container.style.bottom, 10), window.innerHeight - this.container.offsetHeight)}px`;
    if (parseInt(this.container.style.bottom, 10) < 0) {
      this.container.style.bottom = "0px";
    }
  }

  /**
   * Recalculating scale for modal when the browser is resized.
   */
  recalculateScale() {
    let sizeModified = false;

    if (parseInt(this.container.style.width, 10) > 580) {
      this.container.style.width = `${Math.min(parseInt(this.container.style.width, 10), window.innerWidth - this.scrollbarWidth)}px`;
      sizeModified = true;
    } else {
      this.container.style.width = "580px";
      sizeModified = true;
    }

    if (parseInt(this.container.style.height, 10) > 338) {
      this.container.style.height = `${Math.min(parseInt(this.container.style.height, 10), window.innerHeight)}px`;
      sizeModified = true;
    } else {
      this.container.style.height = "338px";
      sizeModified = true;
    }

    if (sizeModified) {
      this.recalculateSize();
    }
  }

  /**
   * Recalculating width of browser scroll bar.
   */
  recalculateScrollBar() {
    this.hasScrollBar = window.innerWidth > document.documentElement.clientWidth;
    if (this.hasScrollBar) {
      this.scrollbarWidth = this.getScrollBarWidth();
    } else {
      this.scrollbarWidth = 0;
    }
  }

  /**
   * Hide soft keyboards on iOS devices.
   */
  // eslint-disable-next-line class-methods-use-this
  hideKeyboard() {
    // iOS keyboard can't be detected or hide directly from JavaScript.
    // So, this method simulates that user focus a text input and blur
    // the selection.
    const inputField = document.createElement("input");
    this.container.appendChild(inputField);
    inputField.focus();
    inputField.blur();
    // Is removed to not see it.
    inputField.remove();
  }

  /**
   * Focus to contentManager object.
   */
  focus() {
    if (this.contentManager != null && typeof this.contentManager.onFocus !== "undefined") {
      this.contentManager.onFocus();
    }
  }

  /**
   * Returns true when the device is on portrait mode.
   */
  // eslint-disable-next-line class-methods-use-this
  portraitMode() {
    return window.innerHeight > window.innerWidth;
  }

  /**
   * Event handler that change container size when IOS soft keyboard is opened.
   */
  handleOpenedIosSoftkeyboard() {
    if (!this.iosSoftkeyboardOpened && this.iosDivHeight != null && this.iosDivHeight === `100${this.iosMeasureUnit}`) {
      if (this.portraitMode()) {
        this.setContainerHeight(`63${this.iosMeasureUnit}`);
      } else {
        this.setContainerHeight(`40${this.iosMeasureUnit}`);
      }
    }
    this.iosSoftkeyboardOpened = true;
  }

  /**
   * Event handler that change container size when IOS soft keyboard is closed.
   */
  handleClosedIosSoftkeyboard() {
    this.iosSoftkeyboardOpened = false;
    this.setContainerHeight(`100${this.iosMeasureUnit}`);
  }

  /**
   * Change container sizes when orientation is changed on iOS.
   */
  orientationChangeIosSoftkeyboard() {
    if (this.iosSoftkeyboardOpened) {
      if (this.portraitMode()) {
        this.setContainerHeight(`63${this.iosMeasureUnit}`);
      } else {
        this.setContainerHeight(`40${this.iosMeasureUnit}`);
      }
    } else {
      this.setContainerHeight(`100${this.iosMeasureUnit}`);
    }
  }

  /**
   * Change container sizes when orientation is changed on Android.
   */
  orientationChangeAndroidSoftkeyboard() {
    this.setContainerHeight("100%");
  }

  /**
   * Set iframe container height.
   * @param {Number} height - New height.
   */
  setContainerHeight(height) {
    this.iosDivHeight = height;
    this.wrapper.style.height = height;
  }

  /**
   * Check content of editor before close action.
   */
  showPopUpMessage() {
    if (this.properties.state === "minimized") {
      this.stack();
    }
    this.popup.show();
  }

  /**
   * Sets the title of the modal dialog.
   * @param {String} title - Modal dialog title.
   */
  setTitle(title) {
    this.title.innerHTML = title;
  }

  /**
   * Returns the id of an element, adding the instance number to
   * the element class name:
   * className --> className[idNumber]
   * @param {String} className - The element class name.
   * @returns {String} A string appending the instance id to the className.
   */
  getElementId(className) {
    return `${className}[${this.instanceId}]`;
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/parser.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/parser.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Parser)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");
/* harmony import */ var _latex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./latex */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/latex.js");
/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./mathml */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js");
/* harmony import */ var _image__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./image */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/image.js");
/* harmony import */ var _accessibility__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./accessibility */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/accessibility.js");
/* harmony import */ var _serviceprovider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./serviceprovider */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/serviceprovider.js");
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./constants */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/constants.js");
/* harmony import */ var _md5__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./md5 */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/md5.js");








// eslint-disable-next-line no-unused-vars


/**
 * @classdesc
 * This class represent a MahML parser. Converts MathML into formulas depending on the
 * image format (SVG, PNG, base64) and the save mode (XML, safeXML, Image) configured
 * in the backend.
 */
class Parser {
  /**
   * Converts a MathML string to an img element.
   * @param {Document} creator - Document object to call createElement method.
   * @param {string} mathml - MathML code
   * @param {Object[]} wirisProperties - object containing WIRIS custom properties
   * @param {language} language - custom language for accessibility.
   * @returns {HTMLImageElement} the formula image corresponding to initial MathML string.
   * @static
   */
  static mathmlToImgObject(creator, mathml, wirisProperties, language) {
    const imgObject = creator.createElement("img");
    imgObject.align = "middle";
    imgObject.style.maxWidth = "none";
    let data = wirisProperties || {};

    // Take into account the backend config
    const wirisEditorProperties = _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("editorParameters");
    data = { ...wirisEditorProperties, ...data };

    data.mml = mathml;
    data.lang = language;
    // Request metrics of the generated image.
    data.metrics = "true";
    data.centerbaseline = "false";

    // Full base64 method (edit & save).
    if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "base64" && _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("base64savemode") === "default") {
      data.base64 = true;
    }

    // Render js params: _wrs_int_wirisProperties contains some js render params.
    // Since MathML can support render params, js params should be send only to editor.

    imgObject.className = _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageClassName");

    if (mathml.indexOf('class="') !== -1) {
      // We check here if the MathML has been created from a customEditor (such chemistry)
      // to add custom editor name attribute to img object (if necessary).
      let mathmlSubstring = mathml.substring(mathml.indexOf('class="') + 'class="'.length, mathml.length);
      mathmlSubstring = mathmlSubstring.substring(0, mathmlSubstring.indexOf('"'));
      mathmlSubstring = mathmlSubstring.substring(4, mathmlSubstring.length);
      imgObject.setAttribute(_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageCustomEditorName"), mathmlSubstring);
    }

    // Performance enabled.
    if (
      _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("wirisPluginPerformance") &&
      (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "xml" || _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "safeXml")
    ) {
      let result = JSON.parse(Parser.createShowImageSrc(data, language));
      if (result.status === "warning") {
        // POST call.
        // if the mathml is malformed, this function will throw an exception.
        try {
          result = JSON.parse(_serviceprovider__WEBPACK_IMPORTED_MODULE_5__["default"].getService("showimage", data));
        } catch (e) {
          return null;
        }
      }
      ({ result } = result);
      if (result.format === "png") {
        imgObject.src = `data:image/png;base64,${result.content}`;
      } else {
        imgObject.src = `data:image/svg+xml;charset=utf8,${_util__WEBPACK_IMPORTED_MODULE_0__["default"].urlEncode(result.content)}`;
      }
      imgObject.setAttribute(_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageMathmlAttribute"), _mathml__WEBPACK_IMPORTED_MODULE_2__["default"].safeXmlEncode(mathml));
      _image__WEBPACK_IMPORTED_MODULE_3__["default"].setImgSize(imgObject, result.content, true);

      if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("enableAccessibility")) {
        if (typeof result.alt === "undefined") {
          imgObject.alt = _accessibility__WEBPACK_IMPORTED_MODULE_4__["default"].mathMLToAccessible(mathml, language, data);
        } else {
          imgObject.alt = result.alt;
        }
      }
    } else {
      const result = Parser.createImageSrc(mathml, data);
      imgObject.setAttribute(_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageMathmlAttribute"), _mathml__WEBPACK_IMPORTED_MODULE_2__["default"].safeXmlEncode(mathml));
      imgObject.src = result;
      _image__WEBPACK_IMPORTED_MODULE_3__["default"].setImgSize(
        imgObject,
        result,
        _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "base64" && _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("base64savemode") === "default",
      );
      if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("enableAccessibility")) {
        imgObject.alt = _accessibility__WEBPACK_IMPORTED_MODULE_4__["default"].mathMLToAccessible(mathml, language, data);
      }
    }

    if (typeof Parser.observer !== "undefined") {
      Parser.observer.observe(imgObject);
    }

    // Role math https://www.w3.org/TR/wai-aria/roles#math.
    imgObject.setAttribute("role", "math");
    return imgObject;
  }

  /**
   * Returns the source to showimage service by calling createimage service. The
   * output of the createimage service is a URL path pointing to showimage service.
   * This method is called when performance is disabled.
   * @param {string} mathml - MathML code.
   * @param {Object[]} data - data object containing service parameters.
   * @returns {string} the showimage path.
   */
  static createImageSrc(mathml, data) {
    // Full base64 method (edit & save).
    if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "base64" && _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("base64savemode") === "default") {
      data.base64 = true;
    }

    let result = _serviceprovider__WEBPACK_IMPORTED_MODULE_5__["default"].getService("createimage", data);

    if (result.indexOf("@BASE@") !== -1) {
      // Replacing '@BASE@' with the base URL of createimage.
      const baseParts = _serviceprovider__WEBPACK_IMPORTED_MODULE_5__["default"].getServicePath("createimage").split("/");
      baseParts.pop();
      result = result.split("@BASE@").join(baseParts.join("/"));
    }

    return result;
  }

  /**
   * Parses initial HTML code. If the HTML contains data generated by WIRIS,
   * this data would be converted as following:
   * <pre>
   * MathML code: Image containing the corresponding MathML formulas.
   * MathML code with LaTeX annotation : LaTeX string.
   * </pre>
   * @param {string} code - HTML code containing MathML data.
   * @param {string} language - language to create image alt text.
   * @returns {string} HTML code with the original MathML converted into LaTeX and images.
   */
  static initParse(code, language) {
    /* Note: The code inside this function has been inverted.
    If you invert again the code then you cannot use correctly LaTeX
    in Moodle.
    */
    code = Parser.initParseSaveMode(code, language);
    return Parser.initParseEditMode(code);
  }

  /**
   * Parses initial HTML code depending on the save mode. Transforms all MathML
   * occurrences for it's correspondent image or LaTeX.
   * @param {string} code - HTML code to be parsed
   * @param {string} language - language to create image alt text.
   * @returns {string} HTML code parsed.
   */
  static initParseSaveMode(code, language) {
    if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode")) {
      // Converting XML to tags.
      code = _latex__WEBPACK_IMPORTED_MODULE_1__["default"].parseMathmlToLatex(code, _constants__WEBPACK_IMPORTED_MODULE_7__["default"].safeXmlCharacters);
      code = _latex__WEBPACK_IMPORTED_MODULE_1__["default"].parseMathmlToLatex(code, _constants__WEBPACK_IMPORTED_MODULE_7__["default"].xmlCharacters);
      code = Parser.parseMathmlToImg(code, _constants__WEBPACK_IMPORTED_MODULE_7__["default"].safeXmlCharacters, language);
      code = Parser.parseMathmlToImg(code, _constants__WEBPACK_IMPORTED_MODULE_7__["default"].xmlCharacters, language);
      if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "base64" && _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("base64savemode") === "image") {
        code = Parser.codeImgTransform(code, "base642showimage");
      }
    }
    return code;
  }

  /**
   * Parses initial HTML code depending on the edit mode.
   * If 'latex' parseMode is enabled all MathML containing an annotation with encoding='LaTeX' will
   * be converted into a LaTeX string instead of an image.
   * @param {string} code - HTML code containing MathML.
   * @returns {string} parsed HTML code.
   */
  static initParseEditMode(code) {
    if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("parseModes").indexOf("latex") !== -1) {
      const imgList = _util__WEBPACK_IMPORTED_MODULE_0__["default"].getElementsByNameFromString(code, "img", true);
      const token = 'encoding="LaTeX">';
      // While replacing images with latex, the indexes of the found images changes
      // respecting the original code, so this carry is needed.
      let carry = 0;

      for (let i = 0; i < imgList.length; i += 1) {
        const imgCode = code.substring(imgList[i].start + carry, imgList[i].end + carry);

        if (imgCode.indexOf(` class="${_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageClassName")}"`) !== -1) {
          let mathmlStartToken = ` ${_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageMathmlAttribute")}="`;
          let mathmlStart = imgCode.indexOf(mathmlStartToken);

          if (mathmlStart === -1) {
            mathmlStartToken = ' alt="';
            mathmlStart = imgCode.indexOf(mathmlStartToken);
          }

          if (mathmlStart !== -1) {
            mathmlStart += mathmlStartToken.length;
            const mathmlEnd = imgCode.indexOf('"', mathmlStart);
            const mathml = _util__WEBPACK_IMPORTED_MODULE_0__["default"].htmlSanitize(_mathml__WEBPACK_IMPORTED_MODULE_2__["default"].safeXmlDecode(imgCode.substring(mathmlStart, mathmlEnd)));
            let latexStartPosition = mathml.indexOf(token);

            if (latexStartPosition !== -1) {
              latexStartPosition += token.length;
              const latexEndPosition = mathml.indexOf("</annotation>", latexStartPosition);
              const latex = mathml.substring(latexStartPosition, latexEndPosition);

              const replaceText = `$$${_util__WEBPACK_IMPORTED_MODULE_0__["default"].htmlEntitiesDecode(latex)}$$`;
              const start = code.substring(0, imgList[i].start + carry);
              const end = code.substring(imgList[i].end + carry);
              code = start + replaceText + end;
              carry += replaceText.length - (imgList[i].end - imgList[i].start);
            }
          }
        }
      }
    }

    return code;
  }

  /**
   * Parses end HTML code. The end HTML code is HTML code with embedded images
   * or LaTeX formulas created with MathType. <br>
   * By default this method converts the formula images and LaTeX strings in MathML. <br>
   * If image mode is enabled the images will not be converted into MathML. For further information see {@link https://docs.wiris.com/mathtype/en/mathtype-integrations/mathtype-web-interface-features/full-mathml-mode---wirisplugins-js.html}.
   * @param {string} code - HTML to be parsed
   * @returns {string} the HTML code parsed.
   */
  static endParse(code) {
    // Transform LaTeX ocurrences to MathML elements.
    const codeEndParsedEditMode = Parser.endParseEditMode(code);
    // Transform img elements to MathML elements.
    const codeEndParseSaveMode = Parser.endParseSaveMode(codeEndParsedEditMode);
    return codeEndParseSaveMode;
  }

  /**
   * Parses end HTML code depending on the edit mode.
   * - LaTeX is an enabled parse mode, all LaTeX occurrences will be converted into MathML.
   * @param {string} code - HTML code to be parsed.
   * @returns {string} HTML code parsed.
   */
  static endParseEditMode(code) {
    // Converting LaTeX to images.
    if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("parseModes").indexOf("latex") !== -1) {
      let output = "";
      let endPosition = 0;
      let startPosition = code.indexOf("$$");
      while (startPosition !== -1) {
        output += code.substring(endPosition, startPosition);
        endPosition = code.indexOf("$$", startPosition + 2);

        if (endPosition !== -1) {
          // Before, it was a condition here to execute the next codelines
          // 'latex.indexOf('<') == -1'.
          // We don't know why it was used, but seems to have a conflict with
          // latex formulas that contains '<'.
          const latex = code.substring(startPosition + 2, endPosition);
          const decodedLatex = _util__WEBPACK_IMPORTED_MODULE_0__["default"].htmlEntitiesDecode(latex);
          let mathml = _util__WEBPACK_IMPORTED_MODULE_0__["default"].htmlSanitize(_latex__WEBPACK_IMPORTED_MODULE_1__["default"].getMathMLFromLatex(decodedLatex, true));
          if (!_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveHandTraces")) {
            // Remove hand traces.
            mathml = _mathml__WEBPACK_IMPORTED_MODULE_2__["default"].removeAnnotation(mathml, "application/json");
          }
          output += mathml;
          endPosition += 2;
        } else {
          output += "$$";
          endPosition = startPosition + 2;
        }

        startPosition = code.indexOf("$$", endPosition);
      }

      output += code.substring(endPosition, code.length);
      code = output;
    }

    return code;
  }

  /**
   * Parses end HTML code depending on the save mode. Converts all
   * images into the element determined by the save mode:
   * - xml: Parses images formulas into MathML.
   * - safeXml: Parses images formulas into safeMAthML
   * - base64: Parses images into base64 images.
   * - image: Parse images into images (no parsing)
   * @param {string} code - HTML code to be parsed
   * @returns {string} HTML code parsed.
   */
  static endParseSaveMode(code) {
    const savemode = _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode");
    const base64savemode = _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("base64savemode");

    if (savemode) {
      if (savemode === "safeXml") {
        code = Parser.codeImgTransform(code, "img2mathml");
      } else if (savemode === "xml") {
        code = Parser.codeImgTransform(code, "img2mathml");
      } else if (savemode === "base64" && base64savemode === "image") {
        code = Parser.codeImgTransform(code, "img264");
      }
    }

    return code;
  }

  /**
   * Auxiliar function that builds the data object to send to the showimage endpoint
   * @param {Object[]} data - object containing showimage service parameters.
   * @param {string} language - string containing the language of the formula.
   * @returns {Object} JSON object with the data to send to showimage.
   */
  static createShowImageSrcData(data, language) {
    const dataMd5 = {};
    const renderParams = [
      "mml",
      "color",
      "centerbaseline",
      "zoom",
      "dpi",
      "fontSize",
      "fontFamily",
      "defaultStretchy",
      "backgroundColor",
      "format",
    ];
    renderParams.forEach((param) => {
      if (typeof data[param] !== "undefined") {
        dataMd5[param] = data[param];
      }
    });
    // Data variables to get.
    const dataObject = {};
    Object.keys(data).forEach((key) => {
      // We don't need mathml in this request we try to get cached.
      // Only need the formula md5 calculated before.
      if (key !== "mml") {
        dataObject[key] = data[key];
      }
    });

    dataObject.formula = com.wiris.js.JsPluginTools.md5encode(_util__WEBPACK_IMPORTED_MODULE_0__["default"].propertiesToString(dataMd5));
    dataObject.lang = typeof language === "undefined" ? "en" : language;
    dataObject.version = _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("version");

    return dataObject;
  }

  /**
   * Returns the result to call showimage service with the formula md5 as parameter.
   *  The result could be:
   * - {'status' : warning'} : The image associated to the MathML md5 is not in cache.
   * - {'status' : 'ok' ...} : The image associated to the MathML md5 is in cache.
   * @param {Object[]} data - object containing showimage service parameters.
   * @param {string} language - string containing the language of the formula.
   * @returns {Object} JSON object containing showimage response.
   */
  static createShowImageSrc(data, language) {
    const dataObject = this.createShowImageSrcData(data, language);
    const result = _serviceprovider__WEBPACK_IMPORTED_MODULE_5__["default"].getService("showimage", _util__WEBPACK_IMPORTED_MODULE_0__["default"].httpBuildQuery(dataObject), true);
    return result;
  }

  /**
   * Transform html img tags inside a html code to mathml, base64 img tags (i.e with base64 on src)
   * or showimage img tags (i.e with showimage.php on src)
   * @param  {string} code - HTML code
   * @param  {string} mode - base642showimage or img2mathml or img264 transform.
   * @returns {string} html - code transformed.
   */
  static codeImgTransform(code, mode) {
    let output = "";
    let endPosition = 0;
    const pattern = /<img/gi;
    const patternLength = pattern.source.length;

    while (pattern.test(code)) {
      const startPosition = pattern.lastIndex - patternLength;
      output += code.substring(endPosition, startPosition);

      let i = startPosition + 1;

      while (i < code.length && endPosition <= startPosition) {
        const character = code.charAt(i);

        if (character === '"' || character === "'") {
          const characterNextPosition = code.indexOf(character, i + 1);

          if (characterNextPosition === -1) {
            i = code.length; // End while.
          } else {
            i = characterNextPosition;
          }
        } else if (character === ">") {
          endPosition = i + 1;
        }

        i += 1;
      }

      if (endPosition < startPosition) {
        // The img tag is stripped.
        output += code.substring(startPosition, code.length);
        return output;
      }
      let imgCode = code.substring(startPosition, endPosition);
      const imgObject = _util__WEBPACK_IMPORTED_MODULE_0__["default"].createObject(imgCode);
      let xmlCode = imgObject.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageMathmlAttribute"));
      let convertToXml;
      let convertToSafeXml;

      if (mode === "base642showimage") {
        if (xmlCode == null) {
          xmlCode = imgObject.getAttribute("alt");
        }
        xmlCode = _mathml__WEBPACK_IMPORTED_MODULE_2__["default"].safeXmlDecode(xmlCode);
        imgCode = Parser.mathmlToImgObject(document, xmlCode, null, null);
        output += _util__WEBPACK_IMPORTED_MODULE_0__["default"].createObjectCode(imgCode);
      } else if (mode === "img2mathml") {
        if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode")) {
          if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "safeXml") {
            convertToXml = true;
            convertToSafeXml = true;
          } else if (_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("saveMode") === "xml") {
            convertToXml = true;
            convertToSafeXml = false;
          }
        }
        output += _util__WEBPACK_IMPORTED_MODULE_0__["default"].getWIRISImageOutput(imgCode, convertToXml, convertToSafeXml);
      } else if (mode === "img264") {
        if (xmlCode === null) {
          xmlCode = imgObject.getAttribute("alt");
        }
        xmlCode = _mathml__WEBPACK_IMPORTED_MODULE_2__["default"].safeXmlDecode(xmlCode);

        const properties = {};
        properties.base64 = "true";
        imgCode = Parser.mathmlToImgObject(document, xmlCode, properties, null);
        // Metrics.
        _image__WEBPACK_IMPORTED_MODULE_3__["default"].setImgSize(imgCode, imgCode.src, true);
        output += _util__WEBPACK_IMPORTED_MODULE_0__["default"].createObjectCode(imgCode);
      }
    }
    output += code.substring(endPosition, code.length);
    return output;
  }

  /**
   * Converts all occurrences of MathML to the corresponding image.
   * @param {string} content - string with valid MathML code.
   * The MathML code doesn't contain semantics.
   * @param {Constants} characters - Constant object containing xmlCharacters
   * or safeXmlCharacters relation.
   * @param {string} language - a valid language code
   * in order to generate formula accessibility.
   * @returns {string} The input string with all the MathML
   * occurrences replaced by the corresponding image.
   */
  static parseMathmlToImg(content, characters, language) {
    let output = "";
    const mathTagBegin = `${characters.tagOpener}math`;
    const mathTagEnd = `${characters.tagOpener}/math${characters.tagCloser}`;
    let start = content.indexOf(mathTagBegin);
    let end = 0;

    while (start !== -1) {
      output += content.substring(end, start);
      // Avoid WIRIS images to be parsed.
      const imageMathmlAtrribute = content.indexOf(_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageMathmlAttribute"));
      end = content.indexOf(mathTagEnd, start);

      if (end === -1) {
        end = content.length - 1;
      } else if (imageMathmlAtrribute !== -1) {
        // First close tag of img attribute
        // If a mathmlAttribute exists should be inside a img tag.
        end += content.indexOf("/>", start);
      } else {
        end += mathTagEnd.length;
      }

      if (!_mathml__WEBPACK_IMPORTED_MODULE_2__["default"].isMathmlInAttribute(content, start) && imageMathmlAtrribute === -1) {
        let mathml = content.substring(start, end);
        mathml =
          characters.id === _constants__WEBPACK_IMPORTED_MODULE_7__["default"].safeXmlCharacters.id
            ? _mathml__WEBPACK_IMPORTED_MODULE_2__["default"].safeXmlDecode(mathml)
            : _mathml__WEBPACK_IMPORTED_MODULE_2__["default"].mathMLEntities(mathml);
        output += _util__WEBPACK_IMPORTED_MODULE_0__["default"].createObjectCode(Parser.mathmlToImgObject(document, mathml, null, language));
      } else {
        output += content.substring(start, end);
      }

      start = content.indexOf(mathTagBegin, end);
    }

    output += content.substring(end, content.length);
    return output;
  }
}

// Mutation observers to avoid wiris image formulas class be removed.
if (typeof MutationObserver !== "undefined") {
  const mutationObserver = new MutationObserver((mutations) => {
    mutations.forEach((mutation) => {
      if (
        mutation.oldValue === _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageClassName") &&
        mutation.attributeName === "class" &&
        mutation.target.className.indexOf(_configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageClassName")) === -1
      ) {
        mutation.target.className = _configuration__WEBPACK_IMPORTED_MODULE_6__["default"].get("imageClassName");
      }
    });
  });

  Parser.observer = Object.create(mutationObserver);
  Parser.observer.Config = { attributes: true, attributeOldValue: true };
  // We use own default config.
  Parser.observer.observe = function (target) {
    Object.getPrototypeOf(this).observe(target, this.Config);
  };
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/polyfills.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/polyfills.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable */
var polyfills;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (polyfills);

// Polyfills.
/*! http://mths.be/codepointat v0.1.0 by @mathias */
if (!String.prototype.codePointAt) {
  (function () {
    "use strict"; // needed to support `apply`/`call` with `undefined`/`null`
    var codePointAt = function (position) {
      if (this == null) {
        throw TypeError();
      }
      var string = String(this);
      var size = string.length;
      // `ToInteger`
      var index = position ? Number(position) : 0;
      if (index != index) {
        // better `isNaN`
        index = 0;
      }
      // Account for out-of-bounds indices:
      if (index < 0 || index >= size) {
        return undefined;
      }
      // Get the first code unit
      var first = string.charCodeAt(index);
      var second;
      if (
        // check if it’s the start of a surrogate pair
        first >= 0xd800 &&
        first <= 0xdbff && // high surrogate
        size > index + 1 // there is a next code unit
      ) {
        second = string.charCodeAt(index + 1);
        if (second >= 0xdc00 && second <= 0xdfff) {
          // low surrogate
          // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
          return (first - 0xd800) * 0x400 + second - 0xdc00 + 0x10000;
        }
      }
      return first;
    };
    if (Object.defineProperty) {
      Object.defineProperty(String.prototype, "codePointAt", {
        value: codePointAt,
        configurable: true,
        writable: true,
      });
    } else {
      String.prototype.codePointAt = codePointAt;
    }
  })();
}

// Object.assign polyfill.
if (typeof Object.assign != "function") {
  // Must be writable: true, enumerable: false, configurable: true
  Object.defineProperty(Object, "assign", {
    value: function assign(target, varArgs) {
      // .length of function is 2
      "use strict";
      if (target == null) {
        // TypeError if undefined or null
        throw new TypeError("Cannot convert undefined or null to object");
      }

      var to = Object(target);

      for (var index = 1; index < arguments.length; index++) {
        var nextSource = arguments[index];

        if (nextSource != null) {
          // Skip over if undefined or null
          for (var nextKey in nextSource) {
            // Avoid bugs when hasOwnProperty is shadowed
            if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
              to[nextKey] = nextSource[nextKey];
            }
          }
        }
      }
      return to;
    },
    writable: true,
    configurable: true,
  });
}

// https://tc39.github.io/ecma262/#sec-array.prototype.includes
if (!Array.prototype.includes) {
  Object.defineProperty(Array.prototype, "includes", {
    value: function (searchElement, fromIndex) {
      if (this == null) {
        throw new TypeError('"this" s null or is not defined');
      }

      // 1. Let O be ? ToObject(this value).
      var o = Object(this);

      // 2. Let len be ? ToLength(? Get(O, "length")).
      var len = o.length >>> 0;

      // 3. if len is 0, return false.
      if (len === 0) {
        return false;
      }

      // 4. Let n be ? ToInteger(fromIndex).
      //    (if fromIndex is undefinedo, this step generates the value 0.)
      var n = fromIndex | 0;

      // 5. if n ≥ 0, then
      //  a. Let k be n.
      // 6. Else n < 0,
      //  a. Let k be len + n.
      //  b. if k < 0, let k be 0.
      var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);

      function sameValueZero(x, y) {
        return x === y || (typeof x === "number" && typeof y === "number" && isNaN(x) && isNaN(y));
      }

      // 7. Repeat while k < len
      while (k < len) {
        // a. let element k be the result of ? Get(O, ! ToString(k)).
        // b. if SameValueZero(searchElement, elementK) is true, return true.
        if (sameValueZero(o[k], searchElement)) {
          return true;
        }
        // c. Increase k by 1.
        k++;
      }

      // 8. Return false
      return false;
    },
  });
}

if (!String.prototype.includes) {
  String.prototype.includes = function (search, start) {
    "use strict";

    if (search instanceof RegExp) {
      throw TypeError("first argument must not be a RegExp");
    }
    if (start === undefined) {
      start = 0;
    }
    return this.indexOf(search, start) !== -1;
  };
}

if (!String.prototype.startsWith) {
  Object.defineProperty(String.prototype, "startsWith", {
    value: function (search, rawPos) {
      var pos = rawPos > 0 ? rawPos | 0 : 0;
      return this.substring(pos, pos + search.length) === search;
    },
  });
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/popupmessage.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/popupmessage.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PopUpMessage)
/* harmony export */ });
/* harmony import */ var _integrationmodel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./integrationmodel */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/integrationmodel.js");


/**

 */
class PopUpMessage {
  /**
   * @classdesc
   * This class represents a dialog message overlaying a DOM element in order to
   * accept / cancel discard changes. The dialog can be closed i.e the overlay disappears
   * o canceled. In this last case a callback function should be called.
   * @constructs
   * @param {Object} popupMessageAttributes - Object containing popup properties.
   * @param {HTMLElement} popupMessageAttributes.overlayElement - Element to overlay.
   * @param {Object} popupMessageAttributes.callbacks - Contains callback
   * methods for close and cancel actions.
   * @param {Object} popupMessageAttributes.strings - Contains all the strings needed.
   */
  constructor(popupMessageAttributes) {
    /**
     * Element to be overlaid when the popup appears.
     */
    this.overlayElement = popupMessageAttributes.overlayElement;

    this.callbacks = popupMessageAttributes.callbacks;

    /**
     * HTMLElement element to wrap all HTML elements inside the popupMessage.
     */
    this.overlayWrapper = this.overlayElement.appendChild(document.createElement("div"));
    this.overlayWrapper.setAttribute("class", "wrs_popupmessage_overlay_envolture");

    /**
     * HTMLElement to display the popup message, close button and cancel button.
     */
    this.message = this.overlayWrapper.appendChild(document.createElement("div"));
    this.message.id = "wrs_popupmessage";
    this.message.setAttribute("class", "wrs_popupmessage_panel");
    this.message.setAttribute("role", "dialog");
    this.message.setAttribute("aria-describedby", "description_txt");
    const paragraph = document.createElement("p");
    const text = document.createTextNode(popupMessageAttributes.strings.message);
    paragraph.appendChild(text);
    paragraph.id = "description_txt";
    this.message.appendChild(paragraph);

    /**
     * HTML element overlaying the overlayElement.
     */
    const overlay = this.overlayWrapper.appendChild(document.createElement("div"));
    overlay.setAttribute("class", "wrs_popupmessage_overlay");
    // We create a overlay that close popup message on click in there
    overlay.addEventListener("click", this.cancelAction.bind(this));

    /**
     * HTML element containing cancel and close buttons.
     */
    this.buttonArea = this.message.appendChild(document.createElement("div"));
    this.buttonArea.setAttribute("class", "wrs_popupmessage_button_area");
    this.buttonArea.id = "wrs_popup_button_area";

    // Close button arguments.
    const buttonSubmitArguments = {
      class: "wrs_button_accept",
      innerHTML: popupMessageAttributes.strings.submitString,
      id: "wrs_popup_accept_button",
      // To identifiy the element in automated testing
      "data-testid": "mtcteditor-cd-close-button",
    };

    /**
     * Close button arguments.
     */
    this.closeButton = this.createButton(buttonSubmitArguments, this.closeAction.bind(this));
    this.buttonArea.appendChild(this.closeButton);

    // Cancel button arguments.
    const buttonCancelArguments = {
      class: "wrs_button_cancel",
      innerHTML: popupMessageAttributes.strings.cancelString,
      id: "wrs_popup_cancel_button",
      // To identifiy the element in automated testing
      "data-testid": "mtcteditor-cd-cancel-button",
    };

    /**
     * Cancel button.
     */
    this.cancelButton = this.createButton(buttonCancelArguments, this.cancelAction.bind(this));
    this.buttonArea.appendChild(this.cancelButton);
  }

  /**
   * This method create a button with arguments and return button dom object
   * @param {Object} parameters - An object containing id, class and innerHTML button text.
   * @param {String} parameters.id - Button id.
   * @param {String} parameters.class - Button class name.
   * @param {String} parameters.innerHTML - Button innerHTML text.
   * @param {Object} callback- Callback method to call on click event.
   * @returns {HTMLElement} HTML button.
   */
  // eslint-disable-next-line class-methods-use-this
  createButton(parameters, callback) {
    let element = {};
    element = document.createElement("button");
    element.setAttribute("id", parameters.id);
    element.setAttribute("class", parameters.class);
    element.innerHTML = parameters.innerHTML;
    element.addEventListener("click", callback);
    if (parameters["data-testid"]) {
      element.setAttribute("data-testid", parameters["data-testid"]);
    }

    return element;
  }

  /**
   * Shows the popupmessage containing a message, and two buttons
   * to cancel the action or close the modal dialog.
   */
  show() {
    if (this.overlayWrapper.style.display !== "block") {
      // Clear focus with blur for prevent press any key.
      document.activeElement.blur();
      this.overlayWrapper.style.display = "block";
      this.closeButton.focus();
    } else {
      this.overlayWrapper.style.display = "none";
      // _wrs_modalWindow.focus(); This throws an error of not existing _wrs_modalWindow
    }
  }

  /**
   * This method cancels the popupMessage: the dialog disappears revealing the overlaid element.
   * A callback method is called (if defined). For example a method to focus the overlaid element.
   */
  cancelAction() {
    this.overlayWrapper.style.display = "none";
    if (typeof this.callbacks.cancelCallback !== "undefined") {
      this.callbacks.cancelCallback();
      // Set temporal image to null to prevent loading
      // an existent formula when starting one from scratch. Make focus come back too.
      // IntegrationModel.setActionsOnCancelButtons();
    }
  }

  /**
   * This method closes the popupMessage: the dialog disappears and the close callback is called.
   * For example to close the overlaid element.
   */
  closeAction() {
    this.cancelAction();
    if (typeof this.callbacks.closeCallback !== "undefined") {
      this.callbacks.closeCallback();
    }
    _integrationmodel__WEBPACK_IMPORTED_MODULE_0__["default"].setActionsOnCancelButtons();
  }

  /**
   * Handle keyboard events detected in modal when elements of this class intervene.
   * @param {KeyboardEvent} keyboardEvent - The keyboard event.
   */
  onKeyDown(keyboardEvent) {
    if (keyboardEvent.key !== undefined) {
      // Code to detect Esc event.
      if (keyboardEvent.key === "Escape" || keyboardEvent.key === "Esc") {
        this.cancelAction();
        keyboardEvent.stopPropagation();
        keyboardEvent.preventDefault();
      } else if (keyboardEvent.key === "Tab") {
        // Code to detect Tab event.
        if (document.activeElement === this.closeButton) {
          this.cancelButton.focus();
        } else {
          this.closeButton.focus();
        }
        keyboardEvent.stopPropagation();
        keyboardEvent.preventDefault();
      }
    }
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/serviceprovider.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/serviceprovider.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ServiceProvider)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");
/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./listeners */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js");
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");




/**
 * @typedef {Object} ServiceProviderProperties
 * @property {String} URI - Service URI.
 * @property {String} server - Service server language.
 */

/**
 * @classdesc
 * Class representing a serviceProvider. A serviceProvider is a class containing
 * an arbitrary number of services with the correspondent path.
 */
class ServiceProvider {
  /**
   * Returns Service Provider listeners.
   * @type {Listeners}
   */
  static get listeners() {
    return ServiceProvider._listeners;
  }

  /**
   * Adds a {@link Listener} instance to {@link ServiceProvider} class.
   * @param {Listener} listener - Instance of {@link Listener}.
   */
  static addListener(listener) {
    ServiceProvider.listeners.add(listener);
  }

  /**
   * Fires events in Service Provider.
   * @param {String} eventName - Event name.
   * @param {Event} event - Event object.
   */
  static fireEvent(eventName, event) {
    ServiceProvider.listeners.fire(eventName, event);
  }

  /**
   * Service parameters.
   * @type {ServiceProviderProperties}
   *
   */
  static get parameters() {
    return ServiceProvider._parameters;
  }

  /**
   * Service parameters.
   * @private
   * @type {ServiceProviderProperties}
   */
  static set parameters(parameters) {
    ServiceProvider._parameters = parameters;
  }

  /**
   * Static property.
   * Return service provider paths.
   * @private
   * @type {String}
   */
  static get servicePaths() {
    return ServiceProvider._servicePaths;
  }

  /**
   * Static property setter.
   * Set service paths.
   * @param {String} value - The property value.
   * @ignore
   */
  static set servicePaths(value) {
    ServiceProvider._servicePaths = value;
  }

  /**
   * Adds a new service to the ServiceProvider.
   * @param {String} service - Service name.
   * @param {String} path - Service path.
   * @static
   */
  static setServicePath(service, path) {
    ServiceProvider.servicePaths[service] = path;
  }

  /**
   * Returns the service path for a certain service.
   * @param {String} serviceName - Service name.
   * @returns {String} The service path.
   * @static
   */
  static getServicePath(serviceName) {
    return ServiceProvider.servicePaths[serviceName];
  }

  /**
   * Static property.
   * Service provider integration path.
   * @type {String}
   */
  static get integrationPath() {
    return ServiceProvider._integrationPath;
  }

  /**
   * Static property setter.
   * Set service provider integration path.
   * @param {String} value - The property value.
   * @ignore
   */
  static set integrationPath(value) {
    ServiceProvider._integrationPath = value;
  }

  /**
   * Returns the server URL in the form protocol://serverName:serverPort.
   * @return {String} The client side server path.
   */
  static getServerURL() {
    const url = window.location.href;
    const arr = url.split("/");
    const result = `${arr[0]}//${arr[2]}`;
    return result;
  }

  /**
   * Inits {@link this} class. Uses {@link this.integrationPath} as
   * base path to generate all backend services paths.
   * @param {Object} parameters - Function parameters.
   * @param {String} parameters.integrationPath - Service path.
   */
  static init(parameters) {
    ServiceProvider.parameters = parameters;
    // Services path (tech dependant).
    let configurationURI = ServiceProvider.createServiceURI("configurationjs");
    let createImageURI = ServiceProvider.createServiceURI("createimage");
    let showImageURI = ServiceProvider.createServiceURI("showimage");
    let getMathMLURI = ServiceProvider.createServiceURI("getmathml");
    let serviceURI = ServiceProvider.createServiceURI("service");

    // Some backend integrations (like Java o Ruby) have an absolute backend path,
    // for example: /app/service. For them we calculate the absolute URL path, i.e
    // protocol://domain:port/app/service
    if (ServiceProvider.parameters.URI.indexOf("/") === 0) {
      const serverPath = ServiceProvider.getServerURL();
      configurationURI = serverPath + configurationURI;
      showImageURI = serverPath + showImageURI;
      createImageURI = serverPath + createImageURI;
      getMathMLURI = serverPath + getMathMLURI;
      serviceURI = serverPath + serviceURI;
    }

    ServiceProvider.setServicePath("configurationjs", configurationURI);
    ServiceProvider.setServicePath("showimage", showImageURI);
    ServiceProvider.setServicePath("createimage", createImageURI);
    ServiceProvider.setServicePath("service", serviceURI);
    ServiceProvider.setServicePath("getmathml", getMathMLURI);
    ServiceProvider.setServicePath("configurationjs", configurationURI);

    ServiceProvider.listeners.fire("onInit", {});
  }

  /**
   * Gets the content from an URL.
   * @param {String} url - Target URL.
   * @param {Object} [postVariables] - Object containing post variables.
   * null if a GET query should be done.
   * @returns {String} Content of the target URL.
   * @private
   * @static
   */
  static getUrl(url, postVariables) {
    const currentPath = window.location.toString().substr(0, window.location.toString().lastIndexOf("/") + 1);
    const httpRequest = _util__WEBPACK_IMPORTED_MODULE_0__["default"].createHttpRequest();

    if (httpRequest) {
      if (typeof postVariables === "undefined" || typeof postVariables === "undefined") {
        httpRequest.open("GET", url, false);
      } else if (url.substr(0, 1) === "/" || url.substr(0, 7) === "http://" || url.substr(0, 8) === "https://") {
        httpRequest.open("POST", url, false);
      } else {
        httpRequest.open("POST", currentPath + url, false);
      }

      let header = _configuration__WEBPACK_IMPORTED_MODULE_2__["default"].get("customHeaders");
      if (header) {
        if (typeof header === "string") {
          header = _util__WEBPACK_IMPORTED_MODULE_0__["default"].convertStringToObject(header);
        }
        Object.entries(header).forEach(([key, val]) => httpRequest.setRequestHeader(key, val));
      }

      if (typeof postVariables !== "undefined" && postVariables) {
        httpRequest.setRequestHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        httpRequest.send(_util__WEBPACK_IMPORTED_MODULE_0__["default"].httpBuildQuery(postVariables));
      } else {
        httpRequest.send(null);
      }

      return httpRequest.responseText;
    }
    return "";
  }

  /**
   * Returns the response text of a certain service.
   * @param {String} service - Service name.
   * @param {String} postVariables - Post variables.
   * @param {Boolean} get - True if the request is GET instead of POST. false otherwise.
   * @returns {String} Service response text.
   */
  static getService(service, postVariables, get) {
    let response;
    if (get === true) {
      const getVariables = postVariables ? `?${postVariables}` : "";
      const serviceUrl = `${ServiceProvider.getServicePath(service)}${getVariables}`;
      response = ServiceProvider.getUrl(serviceUrl);
    } else {
      const serviceUrl = ServiceProvider.getServicePath(service);
      response = ServiceProvider.getUrl(serviceUrl, postVariables);
    }
    return response;
  }

  /**
   * Returns the server language of a certain service. The possible values
   * are: php, aspx, java and ruby.
   * This method has backward compatibility purposes.
   * @param {String} service - The configuration service.
   * @returns {String} - The server technology associated with the configuration service.
   */
  static getServerLanguageFromService(service) {
    if (service.indexOf(".php") !== -1) {
      return "php";
    }
    if (service.indexOf(".aspx") !== -1) {
      return "aspx";
    }
    if (service.indexOf("wirispluginengine") !== -1) {
      return "ruby";
    }
    return "java";
  }

  /**
   * Returns the URI associated with a certain service.
   * @param {String} service - The service name.
   * @return {String} The service path.
   */
  static createServiceURI(service) {
    const extension = ServiceProvider.serverExtension();
    return _util__WEBPACK_IMPORTED_MODULE_0__["default"].concatenateUrl(ServiceProvider.parameters.URI, service) + extension;
  }

  static serverExtension() {
    if (ServiceProvider.parameters.server.indexOf("php") !== -1) {
      return ".php";
    }
    if (ServiceProvider.parameters.server.indexOf("aspx") !== -1) {
      return ".aspx";
    }
    return "";
  }
}

/**
 * @property {String} service - The service name.
 * @property {String} path - The service path.
 * @static
 */
ServiceProvider._servicePaths = {};

/**
 * The integration path. Contains the path of the configuration service.
 * Used to define the path for all services.
 * @type {String}
 * @private
 */
ServiceProvider._integrationPath = "";

/**
 * ServiceProvider static listeners.
 * @type {Listeners}
 * @private
 */
ServiceProvider._listeners = new _listeners__WEBPACK_IMPORTED_MODULE_1__["default"]();

/**
 * Service provider parameters.
 * @type {ServiceProviderParameters}
 */
ServiceProvider._parameters = {};


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/stringmanager.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/stringmanager.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ StringManager)
/* harmony export */ });
/* harmony import */ var _lang_strings_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../lang/strings.json */ "./node_modules/@wiris/mathtype-html-integration-devkit/lang/strings.json");

/**
 * This class represents a string manager. It's used to load localized strings.
 */
class StringManager {
  constructor() {
    throw new Error("Static class StringManager can not be instantiated.");
  }

  /**
   * Returns the associated value of certain string key. If the associated value
   * doesn't exits returns the original key.
   * @param {string} key - string key
   * @param {string} lang - DEFAULT = null. Specify the language to translate the string
   * @returns {string} correspondent value. If doesn't exists original key.
   */
  static get(key, lang) {
    // Default language definition
    let { language } = this;

    // If parameter language, use it
    if (lang) {
      language = lang;
    }

    // Cut down on strings. e.g. en_US -> en
    if (language && language.length > 2) {
      language = language.slice(0, 2);
    }

    // Check if we support the language
    if (!this.strings.hasOwnProperty(language)) {
      // eslint-disable-line no-prototype-builtins
      console.warn(`Unknown language ${language} set in StringManager.`);
      language = "en";
    }

    // Check if the key is supported in the given language
    if (!this.strings[language].hasOwnProperty(key)) {
      // eslint-disable-line no-prototype-builtins
      console.warn(`Unknown key ${key} for language ${language} in StringManager.`);
      return key;
    }

    return this.strings[language][key];
  }
}

/**
 * Dictionary of dictionaries:
 * Key: language code
 * Value: Key: id of the string
 *        Value: translation of the string
 */
StringManager.strings = _lang_strings_json__WEBPACK_IMPORTED_MODULE_0__;

/**
 * Language of the translations; English by default
 */
StringManager.language = "en";


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/telemeter.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/telemeter.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Telemeter)
/* harmony export */ });
/* harmony import */ var _telemeter_wasm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../telemeter-wasm */ "./node_modules/@wiris/mathtype-html-integration-devkit/telemeter-wasm/telemeter_wasm.js");


/**
 * @classdesc
 * This class implements the @wiris/telemeter-wasm. A utility that helps our Solutions to send the data
 * to Telemetry in a more comfortable and homogeneous way.
 */
class Telemeter {
  /**
   * Inits Telemeter class.
   * The parameters structures are defiended on {@link [Telemeter API](https://github.com/wiris/telemeter/blob/main/docs/USAGE.md#telemeter-api)}
   * @param {Object} telemeterAttributes.solution - The product that send data to Telemetry.
   * @param {Object} telemeterAttributes.hosts - Data about the environment where solution is integrated.
   * @param {Object} telemeterAttributes.config - Configuration parameters.
   */
  static init(telemeterAttributes) {
    if (!this.telemeter && !this.waitingForInit) {
      this.waitingForInit = true;
      (0,_telemeter_wasm__WEBPACK_IMPORTED_MODULE_0__["default"])(telemeterAttributes.url)
        .then(() => {
          this.telemeter = new _telemeter_wasm__WEBPACK_IMPORTED_MODULE_0__.Telemeter(
            telemeterAttributes.solution,
            telemeterAttributes.hosts,
            telemeterAttributes.config,
          );
        })
        .catch((error) => {
          console.log(error);
        })
        .finally(() => (this.waitingForInit = false));
    }
  }

  /**
   * Closes the Telemetry Session. After calling this method no data will be added to the Telemetry Session.
   */
  static async finish() {
    if (!this.telemeter) return;

    try {
      let local_telemeter = this.telemeter;
      this.telemeter = undefined;
      await local_telemeter.finish();
    } catch (e) {
      console.error(e);
    }
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/textcache.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/textcache.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextCache)
/* harmony export */ });
class TextCache {
  /**
   * @classdesc
   * This class represent a client-side text cache class. Contains pairs of
   * strings (key/value) which can be retrieved in any moment. Usually used
   * to store AJAX responses for text services like mathml2latex
   * (c.f {@link Latex} class) or mathml2accessible (c.f {@link Accessibility} class).
   * @constructs
   */
  constructor() {
    /**
     * Cache array property storing the cache entries.
     * @type {Array.<String>}
     */
    this.cache = [];
  }

  /**
   * This method populates a key/value pair into the {@link this.cache} property.
   * @param {String} key - Cache key, usually the service string parameter.
   * @param {String} value - Cache value, usually the service response.
   */
  populate(key, value) {
    this.cache[key] = value;
  }

  /**
   * Returns the cache value associated to certain cache key.
   * @param {String} key - Cache key, usually the service string parameter.
   * @return {String} value - Cache value, if exists. False otherwise.
   */
  get(key) {
    if (Object.prototype.hasOwnProperty.call(this.cache, key)) {
      return this.cache[key];
    }
    return false;
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Util)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "./node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mathml */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js");
/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./configuration */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _latex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./latex */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/latex.js");
/* harmony import */ var _stringmanager__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./stringmanager */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/stringmanager.js");
/* eslint-disable no-bitwise */






/**
 * This class represents an utility class.
 */
class Util {
  /**
   * Fires an event in a target.
   * @param {EventTarget} eventTarget - target where event should be fired.
   * @param {string} eventName event to fire.
   * @static
   */
  static fireEvent(eventTarget, eventName) {
    if (document.createEvent) {
      const eventObject = document.createEvent("HTMLEvents");
      eventObject.initEvent(eventName, true, true);
      return !eventTarget.dispatchEvent(eventObject);
    }

    const eventObject = document.createEventObject();
    return eventTarget.fireEvent(`on${eventName}`, eventObject);
  }

  /**
   * Cross-browser addEventListener/attachEvent function.
   * @param {EventTarget} eventTarget - target to add the event.
   * @param {string} eventName - specifies the type of event.
   * @param {Function} callBackFunction - callback function.
   * @static
   */
  static addEvent(eventTarget, eventName, callBackFunction) {
    if (eventTarget.addEventListener) {
      eventTarget.addEventListener(eventName, callBackFunction, true);
    } else if (eventTarget.attachEvent) {
      // Backwards compatibility.
      eventTarget.attachEvent(`on${eventName}`, callBackFunction);
    }
  }

  /**
   * Cross-browser removeEventListener/detachEvent function.
   * @param {EventTarget} eventTarget - target to add the event.
   * @param {string} eventName - specifies the type of event.
   * @param {Function} callBackFunction - function to remove from the event target.
   * @static
   */
  static removeEvent(eventTarget, eventName, callBackFunction) {
    if (eventTarget.removeEventListener) {
      eventTarget.removeEventListener(eventName, callBackFunction, true);
    } else if (eventTarget.detachEvent) {
      eventTarget.detachEvent(`on${eventName}`, callBackFunction);
    }
  }

  /**
   * Adds the a callback function, for a certain event target, to the following event types:
   * - dblclick
   * - mousedown
   * - mouseup
   * @param {EventTarget} eventTarget - event target.
   * @param {Function} doubleClickHandler - function to run when on dblclick event.
   * @param {Function} mousedownHandler - function to run when on mousedown event.
   * @param {Function} mouseupHandler - function to run when on mouseup event.
   * @static
   */
  static addElementEvents(eventTarget, doubleClickHandler, mousedownHandler, mouseupHandler) {
    if (doubleClickHandler) {
      this.callbackDblclick = (event) => {
        const realEvent = event || window.event;
        const element = realEvent.srcElement ? realEvent.srcElement : realEvent.target;
        doubleClickHandler(element, realEvent);
      };

      Util.addEvent(eventTarget, "dblclick", this.callbackDblclick);
    }

    if (mousedownHandler) {
      this.callbackMousedown = (event) => {
        const realEvent = event || window.event;
        const element = realEvent.srcElement ? realEvent.srcElement : realEvent.target;
        mousedownHandler(element, realEvent);
      };

      Util.addEvent(eventTarget, "mousedown", this.callbackMousedown);
    }

    if (mouseupHandler) {
      this.callbackMouseup = (event) => {
        const realEvent = event || window.event;
        const element = realEvent.srcElement ? realEvent.srcElement : realEvent.target;
        mouseupHandler(element, realEvent);
      };
      // Chrome doesn't trigger this event for eventTarget if we release the mouse button
      // while the mouse is outside the editor text field.
      // This is a workaround: we trigger the event independently of where the mouse
      // is when we release its button.
      Util.addEvent(document, "mouseup", this.callbackMouseup);
      Util.addEvent(eventTarget, "mouseup", this.callbackMouseup);
    }
  }

  /**
   * Remove all callback function, for a certain event target, to the following event types:
   * - dblclick
   * - mousedown
   * - mouseup
   * @param {EventTarget} eventTarget - event target.
   * @static
   */
  static removeElementEvents(eventTarget) {
    Util.removeEvent(eventTarget, "dblclick", this.callbackDblclick);
    Util.removeEvent(eventTarget, "mousedown", this.callbackMousedown);
    Util.removeEvent(document, "mouseup", this.callbackMouseup);
    Util.removeEvent(eventTarget, "mouseup", this.callbackMouseup);
  }

  /**
   * Adds a class name to a HTMLElement.
   * @param {HTMLElement} element - the HTML element.
   * @param {string} className - the class name.
   * @static
   */
  static addClass(element, className) {
    if (!Util.containsClass(element, className)) {
      element.className += ` ${className}`;
    }
  }

  /**
   * Checks if a HTMLElement contains a certain class.
   * @param {HTMLElement} element - the HTML element.
   * @param {string} className - the className.
   * @returns {boolean} true if the HTMLElement contains the class name. false otherwise.
   * @static
   */
  static containsClass(element, className) {
    if (element == null || !("className" in element)) {
      return false;
    }

    const currentClasses = element.className.split(" ");

    for (let i = currentClasses.length - 1; i >= 0; i -= 1) {
      if (currentClasses[i] === className) {
        return true;
      }
    }

    return false;
  }

  /**
   * Remove a certain class for a HTMLElement.
   * @param {HTMLElement} element - the HTML element.
   * @param {string} className - the class name.
   * @static
   */
  static removeClass(element, className) {
    let newClassName = "";
    const classes = element.className.split(" ");

    for (let i = 0; i < classes.length; i += 1) {
      if (classes[i] !== className) {
        newClassName += `${classes[i]} `;
      }
    }
    element.className = newClassName.trim();
  }

  /**
   * Converts old xml initial text attribute (with «») to the correct one(with §lt;§gt;). It's
   * used to parse old applets.
   * @param {string} text - string containing safeXml characters
   * @returns {string} a string with safeXml characters parsed.
   * @static
   */
  static convertOldXmlinitialtextAttribute(text) {
    // Used to fix a bug with Cas imported from Moodle 1.9 to Moodle 2.x.
    // This could be removed in future.
    const val = "value=";

    const xitpos = text.indexOf("xmlinitialtext");
    const valpos = text.indexOf(val, xitpos);
    const quote = text.charAt(valpos + val.length);
    const startquote = valpos + val.length + 1;
    const endquote = text.indexOf(quote, startquote);

    const value = text.substring(startquote, endquote);

    let newvalue = value.split("«").join("§lt;");
    newvalue = newvalue.split("»").join("§gt;");
    newvalue = newvalue.split("&").join("§");
    newvalue = newvalue.split("¨").join("§quot;");

    text = text.split(value).join(newvalue);
    return text;
  }

  /**
   * Convert a string representation of key-value pairs to an object.
   * @param {string} keyValueString - String with key-value pairs in the format key1='value1', key2='value2'
   * @returns {Object} - Object containing the key-value pairs
   */
  static convertStringToObject(keyValueString) {
    if (!keyValueString || typeof keyValueString !== "string") {
      return {};
    }

    return keyValueString
      .split(",")
      .map((pair) => pair.trim().split("="))
      .reduce((resultObject, [key, value]) => {
        if (key && value) {
          resultObject[key] = value;
        }
        return resultObject;
      }, {});
  }

  /**
   * Cross-browser solution for creating new elements.
   * @param {string} tagName - tag name of the wished element.
   * @param {Object} attributes - an object where each key is a wished
   * attribute name and each value is its value.
   * @param {Object} [creator] - if supplied, this function will use
   * the "createElement" method from this param. Otherwise
   * document will be used as creator.
   * @returns {Element} The DOM element with the specified attributes assigned.
   * @static
   */
  static createElement(tagName, attributes, creator) {
    if (attributes === undefined) {
      attributes = {};
    }

    if (creator === undefined) {
      creator = document;
    }

    let element;

    /*
     * Internet Explorer fix:
     * If you create a new object dynamically, you can't set a non-standard attribute.
     * For example, you can't set the "src" attribute on an "applet" object.
     * Other browsers will throw an exception and will run the standard code.
     */
    try {
      let html = `<${tagName}`;

      Object.keys(attributes).forEach((attributeName) => {
        html += ` ${attributeName}="${Util.htmlEntities(attributes[attributeName])}"`;
      });
      html += ">";
      element = creator.createElement(html);
    } catch (e) {
      element = creator.createElement(tagName);
      Object.keys(attributes).forEach((attributeName) => {
        element.setAttribute(attributeName, attributes[attributeName]);
      });
    }
    return element;
  }

  /**
   * Creates new HTML from it's HTML code as string.
   * @param {string} objectCode - html code
   * @returns {Element} the HTML element.
   * @static
   */
  static createObject(objectCode, creator) {
    if (creator === undefined) {
      creator = document;
    }

    // Internet Explorer can't include "param" tag when is setting an innerHTML property.
    objectCode = objectCode
      .split("<applet ")
      .join('<span wirisObject="WirisApplet" ')
      .split("<APPLET ")
      .join('<span wirisObject="WirisApplet" '); // It is a 'span' because 'span' objects can contain 'br' nodes.
    objectCode = objectCode.split("</applet>").join("</span>").split("</APPLET>").join("</span>");

    objectCode = objectCode
      .split("<param ")
      .join('<br wirisObject="WirisParam" ')
      .split("<PARAM ")
      .join('<br wirisObject="WirisParam" '); // It is a 'br' because 'br' can't contain nodes.
    objectCode = objectCode.split("</param>").join("</br>").split("</PARAM>").join("</br>");

    const container = Util.createElement("div", {}, creator);
    container.innerHTML = objectCode;

    function recursiveParamsFix(object) {
      if (object.getAttribute && object.getAttribute("wirisObject") === "WirisParam") {
        const attributesParsed = {};

        for (let i = 0; i < object.attributes.length; i += 1) {
          if (object.attributes[i].nodeValue !== null) {
            attributesParsed[object.attributes[i].nodeName] = object.attributes[i].nodeValue;
          }
        }

        const param = Util.createElement("param", attributesParsed, creator);

        // IE fix.
        if (param.NAME) {
          param.name = param.NAME;
          param.value = param.VALUE;
        }

        param.removeAttribute("wirisObject");
        object.parentNode.replaceChild(param, object);
      } else if (object.getAttribute && object.getAttribute("wirisObject") === "WirisApplet") {
        const attributesParsed = {};

        for (let i = 0; i < object.attributes.length; i += 1) {
          if (object.attributes[i].nodeValue !== null) {
            attributesParsed[object.attributes[i].nodeName] = object.attributes[i].nodeValue;
          }
        }

        const applet = Util.createElement("applet", attributesParsed, creator);
        applet.removeAttribute("wirisObject");

        for (let i = 0; i < object.childNodes.length; i += 1) {
          recursiveParamsFix(object.childNodes[i]);

          if (object.childNodes[i].nodeName.toLowerCase() === "param") {
            applet.appendChild(object.childNodes[i]);
            i -= 1; // When we insert the object child into the applet, object loses one child.
          }
        }

        object.parentNode.replaceChild(applet, object);
      } else {
        for (let i = 0; i < object.childNodes.length; i += 1) {
          recursiveParamsFix(object.childNodes[i]);
        }
      }
    }

    recursiveParamsFix(container);
    return container.firstChild;
  }

  /**
   * Converts an Element to its HTML code.
   * @param {Element} element - entry element.
   * @return {string} the HTML code of the input element.
   * @static
   */
  static createObjectCode(element) {
    // In case that the image was not created, the object can be null or undefined.
    if (typeof element === "undefined" || element === null) {
      return null;
    }

    if (element.nodeType === 1) {
      // ELEMENT_NODE.
      let output = `<${element.tagName}`;

      for (let i = 0; i < element.attributes.length; i += 1) {
        if (element.attributes[i].specified) {
          output += ` ${element.attributes[i].name}="${Util.htmlEntities(element.attributes[i].value)}"`;
        }
      }

      if (element.childNodes.length > 0) {
        output += ">";

        for (let i = 0; i < element.childNodes.length; i += 1) {
          output += Util.createObject(element.childNodes[i]);
        }

        output += `</${element.tagName}>`;
      } else if (element.nodeName === "DIV" || element.nodeName === "SCRIPT") {
        output += `></${element.tagName}>`;
      } else {
        output += "/>";
      }

      return output;
    }

    if (element.nodeType === 3) {
      // TEXT_NODE.
      return Util.htmlEntities(element.nodeValue);
    }

    return "";
  }

  /**
   * Concatenates two URL paths.
   * @param {string} path1 - first URL path
   * @param {string} path2 - second URL path
   * @returns {string} new URL.
   */
  static concatenateUrl(path1, path2) {
    let separator = "";
    if (path1.indexOf("/") !== path1.length && path2.indexOf("/") !== 0) {
      separator = "/";
    }
    return (path1 + separator + path2).replace(/([^:]\/)\/+/g, "$1");
  }

  /**
   * Parses a text and replaces all HTML special characters by their correspondent entities.
   * @param {string} input - text to be parsed.
   * @returns {string} the input text with all their special characters replaced by their entities.
   * @static
   */
  static htmlEntities(input) {
    return input.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;").split('"').join("&quot;");
  }

  /**
   * Sanitize HTML to prevent XSS injections.
   * @param {string} html - html to be sanitize.
   * @returns {string} html sanitized.
   * @static
   */
  static htmlSanitize(html) {
    let annotationRegex = /\<annotation.+\<\/annotation\>/;
    // Get all the annotation content including the tags.
    let annotation = html.match(annotationRegex);
    // Sanitize html code without removing our supported MathML tags and attributes.
    html = dompurify__WEBPACK_IMPORTED_MODULE_0___default().sanitize(html, {
      ADD_TAGS: ["semantics", "annotation", "mstack", "msline", "msrow", "none"],
      ADD_ATTR: ["linebreak", "charalign", "stackalign"],
    });
    // Readd old annotation content.
    return html.replace(annotationRegex, annotation);
  }

  /**
   * Parses a text and replaces all the HTML entities by their characters.
   * @param {string} input - text to be parsed
   * @returns {string} the input text with all their entities replaced by characters.
   * @static
   */
  static htmlEntitiesDecode(input) {
    // Textarea element decodes when inner html is set.
    const textarea = document.createElement("textarea");
    textarea.innerHTML = input;
    return textarea.value;
  }

  /**
   * Returns a cross-browser http request.
   * @return {object} httpRequest request object.
   * @returns {XMLHttpRequest|ActiveXObject} the proper request object.
   */
  static createHttpRequest() {
    const currentPath = window.location.toString().substr(0, window.location.toString().lastIndexOf("/") + 1);
    if (currentPath.substr(0, 7) === "file://") {
      throw _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("exception_cross_site");
    }

    if (typeof XMLHttpRequest !== "undefined") {
      return new XMLHttpRequest();
    }

    try {
      return new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
      try {
        return new ActiveXObject("Microsoft.XMLHTTP");
      } catch (oc) {
        return null;
      }
    }
  }

  /**
   * Converts a hash to a HTTP query.
   * @param {Object[]} properties - a key/value object.
   * @returns {string} a HTTP query containing all the key value pairs with
   * all the special characters replaced by their entities.
   * @static
   */
  static httpBuildQuery(properties) {
    let result = "";

    Object.keys(properties).forEach((i) => {
      if (properties[i] != null) {
        result += `${Util.urlEncode(i)}=${Util.urlEncode(properties[i])}&`;
      }
    });

    // Deleting last '&' empty character.
    if (result.substring(result.length - 1) === "&") {
      result = result.substring(0, result.length - 1);
    }

    return result;
  }

  /**
   * Convert a hash to string sorting keys to get a deterministic output
   * @param {Object[]} hash - a key/value object.
   * @returns {string} a string with the form key1=value1...keyn=valuen
   * @static
   */
  static propertiesToString(hash) {
    // 1. Sort keys. We sort the keys because we want a deterministic output.
    const keys = [];
    Object.keys(hash).forEach((key) => {
      if (Object.prototype.hasOwnProperty.call(hash, key)) {
        keys.push(key);
      }
    });

    const n = keys.length;
    for (let i = 0; i < n; i += 1) {
      for (let j = i + 1; j < n; j += 1) {
        const s1 = keys[i];
        const s2 = keys[j];
        if (Util.compareStrings(s1, s2) > 0) {
          // Swap.
          keys[i] = s2;
          keys[j] = s1;
        }
      }
    }

    // 2. Generate output.
    let output = "";
    for (let i = 0; i < n; i += 1) {
      const key = keys[i];
      output += key;
      output += "=";
      let value = hash[key];
      value = value.replace("\\", "\\\\");
      value = value.replace("\n", "\\n");
      value = value.replace("\r", "\\r");
      value = value.replace("\t", "\\t");

      output += value;
      output += "\n";
    }
    return output;
  }

  /**
   * Compare two strings using charCodeAt method
   * @param {string} a - first string to compare.
   * @param {string} b - second string to compare.
   * @returns {number} the difference between a and b
   * @static
   */
  static compareStrings(a, b) {
    let i;
    const an = a.length;
    const bn = b.length;
    const n = an > bn ? bn : an;
    for (i = 0; i < n; i += 1) {
      const c = Util.fixedCharCodeAt(a, i) - Util.fixedCharCodeAt(b, i);
      if (c !== 0) {
        return c;
      }
    }
    return a.length - b.length;
  }

  /**
   * Fix charCodeAt() JavaScript function to handle non-Basic-Multilingual-Plane characters.
   * @param {string} string - input string
   * @param {number} idx - an integer greater than or equal to 0
   * and less than the length of the string
   * @returns {number} an integer representing the UTF-16 code of the string at the given index.
   * @static
   */
  static fixedCharCodeAt(string, idx) {
    idx = idx || 0;
    const code = string.charCodeAt(idx);
    let hi;
    let low;

    /* High surrogate (could change last hex to 0xDB7F to treat high
    private surrogates as single characters) */

    if (code >= 0xd800 && code <= 0xdbff) {
      hi = code;
      low = string.charCodeAt(idx + 1);
      if (Number.isNaN(low)) {
        throw _stringmanager__WEBPACK_IMPORTED_MODULE_4__["default"].get("exception_high_surrogate");
      }
      return (hi - 0xd800) * 0x400 + (low - 0xdc00) + 0x10000;
    }

    if (code >= 0xdc00 && code <= 0xdfff) {
      // Low surrogate.
      /* We return false to allow loops to skip this iteration since should have
      already handled high surrogate above in the previous iteration. */
      return false;
    }
    return code;
  }

  /**
   * Returns an URL with it's query params converted into array.
   * @param {string} url - input URL.
   * @returns {Object[]} an array containing all URL query params.
   * @static
   */
  static urlToAssArray(url) {
    let i;
    i = url.indexOf("?");
    if (i > 0) {
      const query = url.substring(i + 1);
      const ss = query.split("&");
      const h = {};
      for (i = 0; i < ss.length; i += 1) {
        const s = ss[i];
        const kv = s.split("=");
        if (kv.length > 1) {
          h[kv[0]] = decodeURIComponent(kv[1].replace(/\+/g, " "));
        }
      }
      return h;
    }
    return {};
  }

  /**
   * Returns an encoded URL by replacing each instance of certain characters by
   * one, two, three or four escape sequences using encodeURIComponent method.
   * !'()* . will not be encoded.
   *
   * @param {string} clearString - URL string to be encoded
   * @returns {string} URL with it's special characters replaced.
   * @static
   */
  static urlEncode(clearString) {
    let output = "";
    // Method encodeURIComponent doesn't encode !'()*~ .
    output = encodeURIComponent(clearString);
    return output;
  }

  // TODO: To parser?
  /**
   * Converts the HTML of a image into the output code that WIRIS must return.
   * By default returns the MathML stored on data-mahml attribute (if imgCode is a formula)
   * or the Wiriscas attribute of a WIRIS applet.
   * @param {string} imgCode - the html code from a formula or a CAS image.
   * @param {boolean} convertToXml - true if the image should be converted to XML.
   * @param {boolean} convertToSafeXml - true if the image should be converted to safeXML.
   * @returns {string} the XML or safeXML of a WIRIS image.
   * @static
   */
  static getWIRISImageOutput(imgCode, convertToXml, convertToSafeXml) {
    const imgObject = Util.createObject(imgCode);
    if (imgObject) {
      if (
        imgObject.className === _configuration__WEBPACK_IMPORTED_MODULE_2__["default"].get("imageClassName") ||
        imgObject.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_2__["default"].get("imageMathmlAttribute"))
      ) {
        if (!convertToXml) {
          return imgCode;
        }

        const dataMathML = imgObject.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_2__["default"].get("imageMathmlAttribute"));
        // To handle annotations, first we need the MathML in XML.
        let mathML = _mathml__WEBPACK_IMPORTED_MODULE_1__["default"].safeXmlDecode(dataMathML);

        if (!_configuration__WEBPACK_IMPORTED_MODULE_2__["default"].get("saveHandTraces")) {
          mathML = _mathml__WEBPACK_IMPORTED_MODULE_1__["default"].removeAnnotation(mathML, "application/json");
        }

        if (mathML == null) {
          mathML = imgObject.getAttribute("alt");
        }

        if (convertToSafeXml) {
          const safeMathML = _mathml__WEBPACK_IMPORTED_MODULE_1__["default"].safeXmlEncode(mathML);
          return safeMathML;
        }

        return mathML;
      }
    }
    return imgCode;
  }

  /**
   * Gets the node length in characters.
   * @param {Node} node - HTML node.
   * @returns {number} node length.
   * @static
   */
  static getNodeLength(node) {
    const staticNodeLengths = {
      IMG: 1,
      BR: 1,
    };

    if (node.nodeType === 3) {
      // TEXT_NODE.
      return node.nodeValue.length;
    }

    if (node.nodeType === 1) {
      // ELEMENT_NODE.
      let length = staticNodeLengths[node.nodeName.toUpperCase()];

      if (length === undefined) {
        length = 0;
      }

      for (let i = 0; i < node.childNodes.length; i += 1) {
        length += Util.getNodeLength(node.childNodes[i]);
      }
      return length;
    }
    return 0;
  }

  /**
   * Gets a selected node or text from an editable HTMLElement.
   * If the caret is on a text node, concatenates it with all the previous and next text nodes.
   * @param {HTMLElement} target - the editable HTMLElement.
   * @param {boolean} isIframe  - specifies if the target is an iframe or not
   * @param {boolean} forceGetSelection - if true, ignores IE system to get
   * the current selection and uses window.getSelection()
   * @returns {object} an object with the 'node' key set if the item is an
   * element or the keys 'node' and 'caretPosition' if the element is text.
   * @static
   */
  static getSelectedItem(target, isIframe, forceGetSelection) {
    let windowTarget;

    if (isIframe) {
      windowTarget = target.contentWindow;
      windowTarget.focus();
    } else {
      windowTarget = window;
      target.focus();
    }

    if (document.selection && !forceGetSelection) {
      const range = windowTarget.document.selection.createRange();

      if (range.parentElement) {
        if (range.htmlText.length > 0) {
          if (range.text.length === 0) {
            return Util.getSelectedItem(target, isIframe, true);
          }

          return null;
        }

        windowTarget.document.execCommand("InsertImage", false, "#");
        let temporalObject = range.parentElement();

        if (temporalObject.nodeName.toUpperCase() !== "IMG") {
          // IE9 fix: parentElement() does not return the IMG node,
          // returns the parent DIV node. In IE < 9, pasteHTML does not work well.
          range.pasteHTML('<span id="wrs_openEditorWindow_temporalObject"></span>');
          temporalObject = windowTarget.document.getElementById("wrs_openEditorWindow_temporalObject");
        }

        let node;
        let caretPosition;

        if (temporalObject.nextSibling && temporalObject.nextSibling.nodeType === 3) {
          // TEXT_NODE.
          node = temporalObject.nextSibling;
          caretPosition = 0;
        } else if (temporalObject.previousSibling && temporalObject.previousSibling.nodeType === 3) {
          node = temporalObject.previousSibling;
          caretPosition = node.nodeValue.length;
        } else {
          node = windowTarget.document.createTextNode("");
          temporalObject.parentNode.insertBefore(node, temporalObject);
          caretPosition = 0;
        }

        temporalObject.parentNode.removeChild(temporalObject);

        return {
          node,
          caretPosition,
        };
      }

      if (range.length > 1) {
        return null;
      }

      return {
        node: range.item(0),
      };
    }

    if (windowTarget.getSelection) {
      let range;
      const selection = windowTarget.getSelection();

      try {
        range = selection.getRangeAt(0);
      } catch (e) {
        range = windowTarget.document.createRange();
      }

      const node = range.startContainer;

      if (node.nodeType === 3) {
        // TEXT_NODE.
        return {
          node,
          caretPosition: range.startOffset,
        };
      }

      if (node !== range.endContainer) {
        return null;
      }

      if (node.nodeType === 1) {
        // ELEMENT_NODE.
        const position = range.startOffset;

        if (node.childNodes[position]) {
          // In case that a formula is detected but not selected,
          // we create an empty span where we could insert the new formula.
          if (range.startOffset === range.endOffset) {
            if (
              position !== 0 &&
              node.childNodes[position - 1].localName === "span" &&
              node.childNodes[position].classList?.contains("Wirisformula")
            ) {
              node.childNodes[position - 1].remove();
              return Util.getSelectedItem(target, isIframe, forceGetSelection);
            } else if (node.childNodes[position].classList?.contains("Wirisformula")) {
              if (
                (position > 0 && node.childNodes[position - 1].classList?.contains("Wirisformula")) ||
                position === 0
              ) {
                var emptySpan = document.createElement("span");
                node.insertBefore(emptySpan, node.childNodes[position]);
                return {
                  node: node.childNodes[position],
                };
              }
            }
          }
          return {
            node: node.childNodes[position],
          };
        }
      }
    }

    return null;
  }

  /**
   * Returns null if there isn't any item or if it is malformed.
   * Otherwise returns an object containing the node with the MathML image
   * and the cursor position inside the textarea.
   * @param {HTMLTextAreaElement} textarea - textarea element.
   * @returns {Object} An object containing the node, the index of the
   * beginning  of the selected text, caret position and the start and end position of the
   * text node.
   * @static
   */
  static getSelectedItemOnTextarea(textarea) {
    const textNode = document.createTextNode(textarea.value);
    const textNodeValues = _latex__WEBPACK_IMPORTED_MODULE_3__["default"].getLatexFromTextNode(textNode, textarea.selectionStart);
    if (textNodeValues === null) {
      return null;
    }

    return {
      node: textNode,
      caretPosition: textarea.selectionStart,
      startPosition: textNodeValues.startPosition,
      endPosition: textNodeValues.endPosition,
    };
  }

  /**
   * Looks for elements that match the given name in a HTML code string.
   * Important: this function is very concrete for WIRIS code.
   * It takes as preconditions lots of behaviors that are not the general case.
   * @param {string} code -  HTML code.
   * @param {string} name - element name.
   * @param {boolean} autoClosed - true if the elements are autoClosed.
   * @return {Object[]} an object containing all HTML elements of code matching the name argument.
   * @static
   */
  static getElementsByNameFromString(code, name, autoClosed) {
    const elements = [];
    code = code.toLowerCase();
    name = name.toLowerCase();
    let start = code.indexOf(`<${name} `);

    while (start !== -1) {
      // Look for nodes.
      let endString;

      if (autoClosed) {
        endString = ">";
      } else {
        endString = `</${name}>`;
      }

      let end = code.indexOf(endString, start);

      if (end !== -1) {
        end += endString.length;
        elements.push({
          start,
          end,
        });
      } else {
        end = start + 1;
      }

      start = code.indexOf(`<${name} `, end);
    }

    return elements;
  }

  /**
   * Returns the numeric value of a base64 character.
   * @param  {string} character - base64 character.
   * @returns {number} base64 character numeric value.
   * @static
   */
  static decode64(character) {
    const PLUS = "+".charCodeAt(0);
    const SLASH = "/".charCodeAt(0);
    const NUMBER = "0".charCodeAt(0);
    const LOWER = "a".charCodeAt(0);
    const UPPER = "A".charCodeAt(0);
    const PLUS_URL_SAFE = "-".charCodeAt(0);
    const SLASH_URL_SAFE = "_".charCodeAt(0);
    const code = character.charCodeAt(0);

    if (code === PLUS || code === PLUS_URL_SAFE) {
      return 62; // Char '+'.
    }
    if (code === SLASH || code === SLASH_URL_SAFE) {
      return 63; // Char '/'.
    }
    if (code < NUMBER) {
      return -1; // No match.
    }
    if (code < NUMBER + 10) {
      return code - NUMBER + 26 + 26;
    }
    if (code < UPPER + 26) {
      return code - UPPER;
    }
    if (code < LOWER + 26) {
      return code - LOWER + 26;
    }

    return null;
  }

  /**
   * Converts a base64 string to a array of bytes.
   * @param {string} b64String - base64 string.
   * @param {number} length - dimension of byte array (by default whole string).
   * @return {Object[]} the resultant byte array.
   * @static
   */
  static b64ToByteArray(b64String, length) {
    let tmp;

    if (b64String.length % 4 > 0) {
      throw new Error("Invalid string. Length must be a multiple of 4"); // Tipped base64. Length is fixed.
    }

    const arr = [];

    let l;
    let placeHolders;
    if (!length) {
      // All b64String string.
      if (b64String.charAt(b64String.length - 2) === "=") {
        placeHolders = 2;
      } else if (b64String.charAt(b64String.length - 1) === "=") {
        placeHolders = 1;
      } else {
        placeHolders = 0;
      }
      l = placeHolders > 0 ? b64String.length - 4 : b64String.length;
    } else {
      l = length;
    }

    let i;
    for (i = 0; i < l; i += 4) {
      // Ignoring code checker standards (bitewise operators).
      // See https://tracker.moodle.org/browse/CONTRIB-5862 for further information.
      // @codingStandardsIgnoreStart
      // eslint-disable-next-line max-len
      tmp =
        (Util.decode64(b64String.charAt(i)) << 18) |
        (Util.decode64(b64String.charAt(i + 1)) << 12) |
        (Util.decode64(b64String.charAt(i + 2)) << 6) |
        Util.decode64(b64String.charAt(i + 3));

      arr.push((tmp >> 16) & 0xff);
      arr.push((tmp >> 8) & 0xff);
      arr.push(tmp & 0xff);
      // @codingStandardsIgnoreEnd
    }

    if (placeHolders) {
      if (placeHolders === 2) {
        // Ignoring code checker standards (bitewise operators).
        // @codingStandardsIgnoreStart
        // eslint-disable-next-line max-len
        tmp = (Util.decode64(b64String.charAt(i)) << 2) | (Util.decode64(b64String.charAt(i + 1)) >> 4);
        arr.push(tmp & 0xff);
      } else if (placeHolders === 1) {
        // eslint-disable-next-line max-len
        tmp =
          (Util.decode64(b64String.charAt(i)) << 10) |
          (Util.decode64(b64String.charAt(i + 1)) << 4) |
          (Util.decode64(b64String.charAt(i + 2)) >> 2);
        arr.push((tmp >> 8) & 0xff);
        arr.push(tmp & 0xff);
        // @codingStandardsIgnoreEnd
      }
    }
    return arr;
  }

  /**
   * Returns the first 32-bit signed integer from a byte array.
   * @param {Object[]} bytes - array of bytes.
   * @returns {number} the 32-bit signed integer.
   * @static
   */
  static readInt32(bytes) {
    if (bytes.length < 4) {
      return false;
    }
    const int32 = bytes.splice(0, 4);
    // @codingStandardsIgnoreStart¡
    return (int32[0] << 24) | (int32[1] << 16) | (int32[2] << 8) | (int32[3] << 0);
    // @codingStandardsIgnoreEnd
  }

  /**
   * Read the first byte from a byte array.
   * @param {Object} bytes - input byte array.
   * @returns {number} first byte of the byte array.
   * @static
   */
  static readByte(bytes) {
    // @codingStandardsIgnoreStart
    return bytes.shift() << 0;
    // @codingStandardsIgnoreEnd
  }

  /**
   * Read an arbitrary number of bytes, from a fixed position on a byte array.
   * @param  {Object[]} bytes - byte array.
   * @param  {number} pos - start position.
   * @param  {number} len - number of bytes to read.
   * @returns {Object[]} the byte array.
   * @static
   */
  static readBytes(bytes, pos, len) {
    return bytes.splice(pos, len);
  }

  /**
   * Inserts or modifies formulas or CAS on a textarea.
   * @param {HTMLTextAreaElement} textarea - textarea target.
   * @param {string} text - text to add in the textarea. For example, to add the link to the image,
   * call this function as (textarea, Parser.createImageSrc(mathml));
   * @static
   */
  static updateTextArea(textarea, text) {
    if (textarea && text) {
      textarea.focus();

      if (textarea.selectionStart != null) {
        const { selectionEnd } = textarea;
        const selectionStart = textarea.value.substring(0, textarea.selectionStart);
        const selectionEndSub = textarea.value.substring(selectionEnd, textarea.value.length);
        textarea.value = selectionStart + text + selectionEndSub;
        textarea.selectionEnd = selectionEnd + text.length;
      } else {
        const selection = document.selection.createRange();
        selection.text = text;
      }
    }
  }

  /**
   * Modifies existing formula on a textarea.
   * @param {HTMLTextAreaElement} textarea - text area target.
   * @param {string} text - text to add in the textarea. For example, if you want to add the link
   * to the image,you can call this function as
   * Util.updateTextarea(textarea, Parser.createImageSrc(mathml));
   * @param {number} start - beginning index from textarea where it needs to be replaced by text.
   * @param {number} end - ending index from textarea where it needs to be replaced by text
   * @static
   */
  static updateExistingTextOnTextarea(textarea, text, start, end) {
    textarea.focus();
    const textareaStart = textarea.value.substring(0, start);
    textarea.value = textareaStart + text + textarea.value.substring(end, textarea.value.length);
    textarea.selectionEnd = start + text.length;
  }

  /**
   * Add a parameter with it's correspondent value to an URL (GET).
   * @param {string} path - URL path
   * @param {string} parameter - parameter
   * @param {string} value - value
   * @static
   */
  static addArgument(path, parameter, value) {
    let sep;
    if (path.indexOf("?") > 0) {
      sep = "&";
    } else {
      sep = "?";
    }
    return `${path + sep + parameter}=${value}`;
  }
}


/***/ }),

/***/ "./node_modules/@wiris/mathtype-html-integration-devkit/telemeter-wasm/telemeter_wasm.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@wiris/mathtype-html-integration-devkit/telemeter-wasm/telemeter_wasm.js ***!
  \***********************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Level: () => (/* binding */ Level),
/* harmony export */   Telemeter: () => (/* binding */ Telemeter),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initSync: () => (/* binding */ initSync),
/* harmony export */   main_js: () => (/* binding */ main_js)
/* harmony export */ });
/* module decorator */ module = __webpack_require__.hmd(module);
let wasm;

const cachedTextDecoder =
  typeof TextDecoder !== "undefined"
    ? new TextDecoder("utf-8", { ignoreBOM: true, fatal: true })
    : {
        decode: () => {
          throw Error("TextDecoder not available");
        },
      };

if (typeof TextDecoder !== "undefined") {
  cachedTextDecoder.decode();
}

let cachedUint8Memory0 = null;

function getUint8Memory0() {
  if (cachedUint8Memory0 === null || cachedUint8Memory0.byteLength === 0) {
    cachedUint8Memory0 = new Uint8Array(wasm.memory.buffer);
  }
  return cachedUint8Memory0;
}

function getStringFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return cachedTextDecoder.decode(getUint8Memory0().subarray(ptr, ptr + len));
}

const heap = new Array(128).fill(undefined);

heap.push(undefined, null, true, false);

let heap_next = heap.length;

function addHeapObject(obj) {
  if (heap_next === heap.length) heap.push(heap.length + 1);
  const idx = heap_next;
  heap_next = heap[idx];

  heap[idx] = obj;
  return idx;
}

function getObject(idx) {
  return heap[idx];
}

function dropObject(idx) {
  if (idx < 132) return;
  heap[idx] = heap_next;
  heap_next = idx;
}

function takeObject(idx) {
  const ret = getObject(idx);
  dropObject(idx);
  return ret;
}

let WASM_VECTOR_LEN = 0;

const cachedTextEncoder =
  typeof TextEncoder !== "undefined"
    ? new TextEncoder("utf-8")
    : {
        encode: () => {
          throw Error("TextEncoder not available");
        },
      };

const encodeString =
  typeof cachedTextEncoder.encodeInto === "function"
    ? function (arg, view) {
        return cachedTextEncoder.encodeInto(arg, view);
      }
    : function (arg, view) {
        const buf = cachedTextEncoder.encode(arg);
        view.set(buf);
        return {
          read: arg.length,
          written: buf.length,
        };
      };

function passStringToWasm0(arg, malloc, realloc) {
  if (realloc === undefined) {
    const buf = cachedTextEncoder.encode(arg);
    const ptr = malloc(buf.length, 1) >>> 0;
    getUint8Memory0()
      .subarray(ptr, ptr + buf.length)
      .set(buf);
    WASM_VECTOR_LEN = buf.length;
    return ptr;
  }

  let len = arg.length;
  let ptr = malloc(len, 1) >>> 0;

  const mem = getUint8Memory0();

  let offset = 0;

  for (; offset < len; offset++) {
    const code = arg.charCodeAt(offset);
    if (code > 0x7f) break;
    mem[ptr + offset] = code;
  }

  if (offset !== len) {
    if (offset !== 0) {
      arg = arg.slice(offset);
    }
    ptr = realloc(ptr, len, (len = offset + arg.length * 3), 1) >>> 0;
    const view = getUint8Memory0().subarray(ptr + offset, ptr + len);
    const ret = encodeString(arg, view);

    offset += ret.written;
  }

  WASM_VECTOR_LEN = offset;
  return ptr;
}

function isLikeNone(x) {
  return x === undefined || x === null;
}

let cachedInt32Memory0 = null;

function getInt32Memory0() {
  if (cachedInt32Memory0 === null || cachedInt32Memory0.byteLength === 0) {
    cachedInt32Memory0 = new Int32Array(wasm.memory.buffer);
  }
  return cachedInt32Memory0;
}

let cachedFloat64Memory0 = null;

function getFloat64Memory0() {
  if (cachedFloat64Memory0 === null || cachedFloat64Memory0.byteLength === 0) {
    cachedFloat64Memory0 = new Float64Array(wasm.memory.buffer);
  }
  return cachedFloat64Memory0;
}

let cachedBigInt64Memory0 = null;

function getBigInt64Memory0() {
  if (cachedBigInt64Memory0 === null || cachedBigInt64Memory0.byteLength === 0) {
    cachedBigInt64Memory0 = new BigInt64Array(wasm.memory.buffer);
  }
  return cachedBigInt64Memory0;
}

function debugString(val) {
  // primitive types
  const type = typeof val;
  if (type == "number" || type == "boolean" || val == null) {
    return `${val}`;
  }
  if (type == "string") {
    return `"${val}"`;
  }
  if (type == "symbol") {
    const description = val.description;
    if (description == null) {
      return "Symbol";
    } else {
      return `Symbol(${description})`;
    }
  }
  if (type == "function") {
    const name = val.name;
    if (typeof name == "string" && name.length > 0) {
      return `Function(${name})`;
    } else {
      return "Function";
    }
  }
  // objects
  if (Array.isArray(val)) {
    const length = val.length;
    let debug = "[";
    if (length > 0) {
      debug += debugString(val[0]);
    }
    for (let i = 1; i < length; i++) {
      debug += ", " + debugString(val[i]);
    }
    debug += "]";
    return debug;
  }
  // Test for built-in
  const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
  let className;
  if (builtInMatches.length > 1) {
    className = builtInMatches[1];
  } else {
    // Failed to match the standard '[object ClassName]'
    return toString.call(val);
  }
  if (className == "Object") {
    // we're a user defined class or Object
    // JSON.stringify avoids problems with cycles, and is generally much
    // easier than looping through ownProperties of `val`.
    try {
      return "Object(" + JSON.stringify(val) + ")";
    } catch (_) {
      return "Object";
    }
  }
  // errors
  if (val instanceof Error) {
    return `${val.name}: ${val.message}\n${val.stack}`;
  }
  // TODO we could test for more things here, like `Set`s and `Map`s.
  return className;
}

function makeClosure(arg0, arg1, dtor, f) {
  const state = { a: arg0, b: arg1, cnt: 1, dtor };
  const real = (...args) => {
    // First up with a closure we increment the internal reference
    // count. This ensures that the Rust closure environment won't
    // be deallocated while we're invoking it.
    state.cnt++;
    try {
      return f(state.a, state.b, ...args);
    } finally {
      if (--state.cnt === 0) {
        wasm.__wbindgen_export_2.get(state.dtor)(state.a, state.b);
        state.a = 0;
      }
    }
  };
  real.original = state;

  return real;
}
function __wbg_adapter_46(arg0, arg1, arg2) {
  wasm.__wbindgen_export_3(arg0, arg1, addHeapObject(arg2));
}

function makeMutClosure(arg0, arg1, dtor, f) {
  const state = { a: arg0, b: arg1, cnt: 1, dtor };
  const real = (...args) => {
    // First up with a closure we increment the internal reference
    // count. This ensures that the Rust closure environment won't
    // be deallocated while we're invoking it.
    state.cnt++;
    const a = state.a;
    state.a = 0;
    try {
      return f(a, state.b, ...args);
    } finally {
      if (--state.cnt === 0) {
        wasm.__wbindgen_export_2.get(state.dtor)(a, state.b);
      } else {
        state.a = a;
      }
    }
  };
  real.original = state;

  return real;
}
function __wbg_adapter_49(arg0, arg1) {
  wasm.__wbindgen_export_4(arg0, arg1);
}

function __wbg_adapter_52(arg0, arg1, arg2) {
  wasm.__wbindgen_export_5(arg0, arg1, addHeapObject(arg2));
}

function handleError(f, args) {
  try {
    return f.apply(this, args);
  } catch (e) {
    wasm.__wbindgen_export_6(addHeapObject(e));
  }
}
function __wbg_adapter_103(arg0, arg1, arg2, arg3) {
  wasm.__wbindgen_export_7(arg0, arg1, addHeapObject(arg2), addHeapObject(arg3));
}

/**
 */
function main_js() {
  wasm.main_js();
}

function getArrayU8FromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return getUint8Memory0().subarray(ptr / 1, ptr / 1 + len);
}
/**
 */
const Level = Object.freeze({
  Err: 0,
  0: "Err",
  Warn: 1,
  1: "Warn",
  Info: 2,
  2: "Info",
  Debug: 3,
  3: "Debug",
});
/**
 */
class Telemeter {
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;

    return ptr;
  }

  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_telemeter_free(ptr);
  }
  /**
   * @param {any} solution
   * @param {any} hosts
   * @param {any} config
   */
  constructor(solution, hosts, config) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.telemeter_new(retptr, addHeapObject(solution), addHeapObject(hosts), addHeapObject(config));
      var r0 = getInt32Memory0()[retptr / 4 + 0];
      var r1 = getInt32Memory0()[retptr / 4 + 1];
      var r2 = getInt32Memory0()[retptr / 4 + 2];
      if (r2) {
        throw takeObject(r1);
      }
      this.__wbg_ptr = r0 >>> 0;
      return this;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string} sender_id
   * @returns {Promise<any>}
   */
  identify(sender_id) {
    const ptr0 = passStringToWasm0(sender_id, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.telemeter_identify(this.__wbg_ptr, ptr0, len0);
    return takeObject(ret);
  }
  /**
   * @param {string} event_type
   * @param {any} event_payload
   * @returns {Promise<any>}
   */
  track(event_type, event_payload) {
    const ptr0 = passStringToWasm0(event_type, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.telemeter_track(this.__wbg_ptr, ptr0, len0, addHeapObject(event_payload));
    return takeObject(ret);
  }
  /**
   * @param {any} level
   * @param {string} message
   * @param {any} payload
   * @returns {Promise<any>}
   */
  log(level, message, payload) {
    const ptr0 = passStringToWasm0(message, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.telemeter_log(this.__wbg_ptr, addHeapObject(level), ptr0, len0, addHeapObject(payload));
    return takeObject(ret);
  }
  /**
   * @returns {Promise<any>}
   */
  finish() {
    const ptr = this.__destroy_into_raw();
    const ret = wasm.telemeter_finish(ptr);
    return takeObject(ret);
  }
  /**
   * @param {boolean | undefined} [new_debug_status]
   */
  debug(new_debug_status) {
    wasm.telemeter_debug(this.__wbg_ptr, isLikeNone(new_debug_status) ? 0xffffff : new_debug_status ? 1 : 0);
  }
}

async function __wbg_load(module, imports) {
  if (typeof Response === "function" && module instanceof Response) {
    if (typeof WebAssembly.instantiateStreaming === "function") {
      try {
        return await WebAssembly.instantiateStreaming(module, imports);
      } catch (e) {
        if (module.headers.get("Content-Type") != "application/wasm") {
          console.warn(
            "`WebAssembly.instantiateStreaming` failed because your server does not serve wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n",
            e,
          );
        } else {
          throw e;
        }
      }
    }

    const bytes = await module.arrayBuffer();
    return await WebAssembly.instantiate(bytes, imports);
  } else {
    const instance = await WebAssembly.instantiate(module, imports);

    if (instance instanceof WebAssembly.Instance) {
      return { instance, module };
    } else {
      return instance;
    }
  }
}

function __wbg_get_imports() {
  const imports = {};
  imports.wbg = {};
  imports.wbg.__wbindgen_string_new = function (arg0, arg1) {
    const ret = getStringFromWasm0(arg0, arg1);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_c728d68b8b34487e = function () {
    const ret = new Object();
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_status_7841bb47be2a8f16 = function (arg0) {
    const ret = getObject(arg0).status;
    return ret;
  };
  imports.wbg.__wbg_headers_ea7ef583d1564b08 = function (arg0) {
    const ret = getObject(arg0).headers;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new0_ad75dd38f92424e2 = function () {
    const ret = new Date();
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_getTime_ed6ee333b702f8fc = function (arg0) {
    const ret = getObject(arg0).getTime();
    return ret;
  };
  imports.wbg.__wbindgen_object_drop_ref = function (arg0) {
    takeObject(arg0);
  };
  imports.wbg.__wbindgen_is_object = function (arg0) {
    const val = getObject(arg0);
    const ret = typeof val === "object" && val !== null;
    return ret;
  };
  imports.wbg.__wbg_crypto_58f13aa23ffcb166 = function (arg0) {
    const ret = getObject(arg0).crypto;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_process_5b786e71d465a513 = function (arg0) {
    const ret = getObject(arg0).process;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_versions_c2ab80650590b6a2 = function (arg0) {
    const ret = getObject(arg0).versions;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_node_523d7bd03ef69fba = function (arg0) {
    const ret = getObject(arg0).node;
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_is_string = function (arg0) {
    const ret = typeof getObject(arg0) === "string";
    return ret;
  };
  imports.wbg.__wbg_msCrypto_abcb1295e768d1f2 = function (arg0) {
    const ret = getObject(arg0).msCrypto;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_require_2784e593a4674877 = function () {
    return handleError(function () {
      const ret = module.require;
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_newwithlength_13b5319ab422dcf6 = function (arg0) {
    const ret = new Uint8Array(arg0 >>> 0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_get_4a9aa5157afeb382 = function (arg0, arg1) {
    const ret = getObject(arg0)[arg1 >>> 0];
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_next_1989a20442400aaa = function () {
    return handleError(function (arg0) {
      const ret = getObject(arg0).next();
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_done_bc26bf4ada718266 = function (arg0) {
    const ret = getObject(arg0).done;
    return ret;
  };
  imports.wbg.__wbg_value_0570714ff7d75f35 = function (arg0) {
    const ret = getObject(arg0).value;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_iterator_7ee1a391d310f8e4 = function () {
    const ret = Symbol.iterator;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_get_2aff440840bb6202 = function () {
    return handleError(function (arg0, arg1) {
      const ret = Reflect.get(getObject(arg0), getObject(arg1));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_next_15da6a3df9290720 = function (arg0) {
    const ret = getObject(arg0).next;
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_is_function = function (arg0) {
    const ret = typeof getObject(arg0) === "function";
    return ret;
  };
  imports.wbg.__wbg_call_669127b9d730c650 = function () {
    return handleError(function (arg0, arg1) {
      const ret = getObject(arg0).call(getObject(arg1));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbindgen_object_clone_ref = function (arg0) {
    const ret = getObject(arg0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_self_3fad056edded10bd = function () {
    return handleError(function () {
      const ret = self.self;
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_window_a4f46c98a61d4089 = function () {
    return handleError(function () {
      const ret = window.window;
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_globalThis_17eff828815f7d84 = function () {
    return handleError(function () {
      const ret = globalThis.globalThis;
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_global_46f939f6541643c5 = function () {
    return handleError(function () {
      const ret = __webpack_require__.g.global;
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbindgen_is_undefined = function (arg0) {
    const ret = getObject(arg0) === undefined;
    return ret;
  };
  imports.wbg.__wbg_newnoargs_ccdcae30fd002262 = function (arg0, arg1) {
    const ret = new Function(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_isArray_38525be7442aa21e = function (arg0) {
    const ret = Array.isArray(getObject(arg0));
    return ret;
  };
  imports.wbg.__wbg_call_53fc3abd42e24ec8 = function () {
    return handleError(function (arg0, arg1, arg2) {
      const ret = getObject(arg0).call(getObject(arg1), getObject(arg2));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_isSafeInteger_c38b0a16d0c7cef7 = function (arg0) {
    const ret = Number.isSafeInteger(getObject(arg0));
    return ret;
  };
  imports.wbg.__wbg_new_feb65b865d980ae2 = function (arg0, arg1) {
    try {
      var state0 = { a: arg0, b: arg1 };
      var cb0 = (arg0, arg1) => {
        const a = state0.a;
        state0.a = 0;
        try {
          return __wbg_adapter_103(a, state0.b, arg0, arg1);
        } finally {
          state0.a = a;
        }
      };
      const ret = new Promise(cb0);
      return addHeapObject(ret);
    } finally {
      state0.a = state0.b = 0;
    }
  };
  imports.wbg.__wbindgen_memory = function () {
    const ret = wasm.memory;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_buffer_344d9b41efe96da7 = function (arg0) {
    const ret = getObject(arg0).buffer;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_d8a000788389a31e = function (arg0) {
    const ret = new Uint8Array(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_set_dcfd613a3420f908 = function (arg0, arg1, arg2) {
    getObject(arg0).set(getObject(arg1), arg2 >>> 0);
  };
  imports.wbg.__wbg_length_a5587d6cd79ab197 = function (arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbindgen_string_get = function (arg0, arg1) {
    const obj = getObject(arg1);
    const ret = typeof obj === "string" ? obj : undefined;
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    var len1 = WASM_VECTOR_LEN;
    getInt32Memory0()[arg0 / 4 + 1] = len1;
    getInt32Memory0()[arg0 / 4 + 0] = ptr1;
  };
  imports.wbg.__wbg_stringify_4039297315a25b00 = function () {
    return handleError(function (arg0) {
      const ret = JSON.stringify(getObject(arg0));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_set_40f7786a25a9cc7e = function () {
    return handleError(function (arg0, arg1, arg2) {
      const ret = Reflect.set(getObject(arg0), getObject(arg1), getObject(arg2));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_has_cdf8b85f6e903c80 = function () {
    return handleError(function (arg0, arg1) {
      const ret = Reflect.has(getObject(arg0), getObject(arg1));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_fetch_701fcd2bde06379a = function (arg0, arg1) {
    const ret = getObject(arg0).fetch(getObject(arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_fetch_b5d6bebed1e6c2d2 = function (arg0) {
    const ret = fetch(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_newwithbyteoffsetandlength_2dc04d99088b15e3 = function (arg0, arg1, arg2) {
    const ret = new Uint8Array(getObject(arg0), arg1 >>> 0, arg2 >>> 0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_e4960143e41697a4 = function () {
    return handleError(function () {
      const ret = new AbortController();
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_signal_1ed842bebd6ae322 = function (arg0) {
    const ret = getObject(arg0).signal;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_abort_8355f201f30300bb = function (arg0) {
    getObject(arg0).abort();
  };
  imports.wbg.__wbindgen_error_new = function (arg0, arg1) {
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_jsval_loose_eq = function (arg0, arg1) {
    const ret = getObject(arg0) == getObject(arg1);
    return ret;
  };
  imports.wbg.__wbindgen_boolean_get = function (arg0) {
    const v = getObject(arg0);
    const ret = typeof v === "boolean" ? (v ? 1 : 0) : 2;
    return ret;
  };
  imports.wbg.__wbindgen_number_get = function (arg0, arg1) {
    const obj = getObject(arg1);
    const ret = typeof obj === "number" ? obj : undefined;
    getFloat64Memory0()[arg0 / 8 + 1] = isLikeNone(ret) ? 0 : ret;
    getInt32Memory0()[arg0 / 4 + 0] = !isLikeNone(ret);
  };
  imports.wbg.__wbg_instanceof_Uint8Array_19e6f142a5e7e1e1 = function (arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof Uint8Array;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_ArrayBuffer_c7cc317e5c29cc0d = function (arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof ArrayBuffer;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_entries_6d727b73ee02b7ce = function (arg0) {
    const ret = Object.entries(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_String_917f38a1211cf44b = function (arg0, arg1) {
    const ret = String(getObject(arg1));
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    const len1 = WASM_VECTOR_LEN;
    getInt32Memory0()[arg0 / 4 + 1] = len1;
    getInt32Memory0()[arg0 / 4 + 0] = ptr1;
  };
  imports.wbg.__wbg_warn_ade8d3b7ecee11ff = function (arg0, arg1) {
    console.warn(getObject(arg0), getObject(arg1));
  };
  imports.wbg.__wbg_readyState_13e55da5ad6d64e2 = function (arg0) {
    const ret = getObject(arg0).readyState;
    return ret;
  };
  imports.wbg.__wbg_warn_4affe1093892a4ef = function (arg0) {
    console.warn(getObject(arg0));
  };
  imports.wbg.__wbg_close_f4135085ec3fc8f0 = function () {
    return handleError(function (arg0) {
      getObject(arg0).close();
    }, arguments);
  };
  imports.wbg.__wbg_new_b9b318679315404f = function () {
    return handleError(function (arg0, arg1) {
      const ret = new WebSocket(getStringFromWasm0(arg0, arg1));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_setbinaryType_dcb62e0f2b346301 = function (arg0, arg1) {
    getObject(arg0).binaryType = takeObject(arg1);
  };
  imports.wbg.__wbg_log_7811587c4c6d2844 = function (arg0) {
    console.log(getObject(arg0));
  };
  imports.wbg.__wbg_error_f0a6627f4b23c19d = function (arg0) {
    console.error(getObject(arg0));
  };
  imports.wbg.__wbg_info_3ca7870690403fee = function (arg0) {
    console.info(getObject(arg0));
  };
  imports.wbg.__wbg_document_183cf1eecfdbffee = function (arg0) {
    const ret = getObject(arg0).document;
    return isLikeNone(ret) ? 0 : addHeapObject(ret);
  };
  imports.wbg.__wbg_visibilityState_9721703a5ef75faf = function (arg0) {
    const ret = getObject(arg0).visibilityState;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_getwithrefkey_3b3c46ba20582127 = function (arg0, arg1) {
    const ret = getObject(arg0)[getObject(arg1)];
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_length_cace2e0b3ddc0502 = function (arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbg_addEventListener_0f2891b0794e07fa = function () {
    return handleError(function (arg0, arg1, arg2, arg3) {
      getObject(arg0).addEventListener(getStringFromWasm0(arg1, arg2), getObject(arg3));
    }, arguments);
  };
  imports.wbg.__wbg_removeEventListener_104d11302bb212d1 = function () {
    return handleError(function (arg0, arg1, arg2, arg3) {
      getObject(arg0).removeEventListener(getStringFromWasm0(arg1, arg2), getObject(arg3));
    }, arguments);
  };
  imports.wbg.__wbindgen_is_bigint = function (arg0) {
    const ret = typeof getObject(arg0) === "bigint";
    return ret;
  };
  imports.wbg.__wbindgen_bigint_from_i64 = function (arg0) {
    const ret = arg0;
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_in = function (arg0, arg1) {
    const ret = getObject(arg0) in getObject(arg1);
    return ret;
  };
  imports.wbg.__wbindgen_bigint_from_u64 = function (arg0) {
    const ret = BigInt.asUintN(64, arg0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_jsval_eq = function (arg0, arg1) {
    const ret = getObject(arg0) === getObject(arg1);
    return ret;
  };
  imports.wbg.__wbg_localStorage_e11f72e996a4f5d9 = function () {
    return handleError(function (arg0) {
      const ret = getObject(arg0).localStorage;
      return isLikeNone(ret) ? 0 : addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_getItem_c81cd3ae30cd579a = function () {
    return handleError(function (arg0, arg1, arg2, arg3) {
      const ret = getObject(arg1).getItem(getStringFromWasm0(arg2, arg3));
      var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
      var len1 = WASM_VECTOR_LEN;
      getInt32Memory0()[arg0 / 4 + 1] = len1;
      getInt32Memory0()[arg0 / 4 + 0] = ptr1;
    }, arguments);
  };
  imports.wbg.__wbg_navigator_7078da62d92ff5ad = function (arg0) {
    const ret = getObject(arg0).navigator;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_mediaDevices_e00b1f64d2b9939f = function () {
    return handleError(function (arg0) {
      const ret = getObject(arg0).mediaDevices;
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_enumerateDevices_619d52f5eef34c2f = function () {
    return handleError(function (arg0) {
      const ret = getObject(arg0).enumerateDevices();
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_setItem_fe04f524052a3839 = function () {
    return handleError(function (arg0, arg1, arg2, arg3, arg4) {
      getObject(arg0).setItem(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
    }, arguments);
  };
  imports.wbg.__wbindgen_cb_drop = function (arg0) {
    const obj = takeObject(arg0).original;
    if (obj.cnt-- == 1) {
      obj.a = 0;
      return true;
    }
    const ret = false;
    return ret;
  };
  imports.wbg.__wbg_deviceId_58f7da2228a26c02 = function (arg0, arg1) {
    const ret = getObject(arg1).deviceId;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    const len1 = WASM_VECTOR_LEN;
    getInt32Memory0()[arg0 / 4 + 1] = len1;
    getInt32Memory0()[arg0 / 4 + 0] = ptr1;
  };
  imports.wbg.__wbg_instanceof_Response_944e2745b5db71f5 = function (arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof Response;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_randomFillSync_a0d98aa11c81fe89 = function () {
    return handleError(function (arg0, arg1) {
      getObject(arg0).randomFillSync(takeObject(arg1));
    }, arguments);
  };
  imports.wbg.__wbg_subarray_6ca5cfa7fbb9abbe = function (arg0, arg1, arg2) {
    const ret = getObject(arg0).subarray(arg1 >>> 0, arg2 >>> 0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_getRandomValues_504510b5564925af = function () {
    return handleError(function (arg0, arg1) {
      getObject(arg0).getRandomValues(getObject(arg1));
    }, arguments);
  };
  imports.wbg.__wbindgen_bigint_get_as_i64 = function (arg0, arg1) {
    const v = getObject(arg1);
    const ret = typeof v === "bigint" ? v : undefined;
    getBigInt64Memory0()[arg0 / 8 + 1] = isLikeNone(ret) ? BigInt(0) : ret;
    getInt32Memory0()[arg0 / 4 + 0] = !isLikeNone(ret);
  };
  imports.wbg.__wbindgen_debug_string = function (arg0, arg1) {
    const ret = debugString(getObject(arg1));
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    const len1 = WASM_VECTOR_LEN;
    getInt32Memory0()[arg0 / 4 + 1] = len1;
    getInt32Memory0()[arg0 / 4 + 0] = ptr1;
  };
  imports.wbg.__wbindgen_throw = function (arg0, arg1) {
    throw new Error(getStringFromWasm0(arg0, arg1));
  };
  imports.wbg.__wbg_then_89e1c559530b85cf = function (arg0, arg1) {
    const ret = getObject(arg0).then(getObject(arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_queueMicrotask_e5949c35d772a669 = function (arg0) {
    queueMicrotask(getObject(arg0));
  };
  imports.wbg.__wbg_then_1bbc9edafd859b06 = function (arg0, arg1, arg2) {
    const ret = getObject(arg0).then(getObject(arg1), getObject(arg2));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_queueMicrotask_2be8b97a81fe4d00 = function (arg0) {
    const ret = getObject(arg0).queueMicrotask;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_resolve_a3252b2860f0a09e = function (arg0) {
    const ret = Promise.resolve(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_url_1f609e63ff1a7983 = function (arg0, arg1) {
    const ret = getObject(arg1).url;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_export_0, wasm.__wbindgen_export_1);
    const len1 = WASM_VECTOR_LEN;
    getInt32Memory0()[arg0 / 4 + 1] = len1;
    getInt32Memory0()[arg0 / 4 + 0] = ptr1;
  };
  imports.wbg.__wbg_send_2860805104507701 = function () {
    return handleError(function (arg0, arg1, arg2) {
      getObject(arg0).send(getArrayU8FromWasm0(arg1, arg2));
    }, arguments);
  };
  imports.wbg.__wbg_instanceof_Window_cde2416cf5126a72 = function (arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof Window;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_new_19676474aa414d62 = function () {
    return handleError(function () {
      const ret = new Headers();
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_append_feec4143bbf21904 = function () {
    return handleError(function (arg0, arg1, arg2, arg3, arg4) {
      getObject(arg0).append(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
    }, arguments);
  };
  imports.wbg.__wbg_newwithstrandinit_29038da14d09e330 = function () {
    return handleError(function (arg0, arg1, arg2) {
      const ret = new Request(getStringFromWasm0(arg0, arg1), getObject(arg2));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbindgen_closure_wrapper1532 = function (arg0, arg1, arg2) {
    const ret = makeClosure(arg0, arg1, 76, __wbg_adapter_46);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_closure_wrapper1602 = function (arg0, arg1, arg2) {
    const ret = makeMutClosure(arg0, arg1, 76, __wbg_adapter_49);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_closure_wrapper1834 = function (arg0, arg1, arg2) {
    const ret = makeMutClosure(arg0, arg1, 76, __wbg_adapter_52);
    return addHeapObject(ret);
  };

  return imports;
}

function __wbg_init_memory(imports, maybe_memory) {}

function __wbg_finalize_init(instance, module) {
  wasm = instance.exports;
  __wbg_init.__wbindgen_wasm_module = module;
  cachedBigInt64Memory0 = null;
  cachedFloat64Memory0 = null;
  cachedInt32Memory0 = null;
  cachedUint8Memory0 = null;

  wasm.__wbindgen_start();
  return wasm;
}

function initSync(module) {
  if (wasm !== undefined) return wasm;

  const imports = __wbg_get_imports();

  __wbg_init_memory(imports);

  if (!(module instanceof WebAssembly.Module)) {
    module = new WebAssembly.Module(module);
  }

  const instance = new WebAssembly.Instance(module, imports);

  return __wbg_finalize_init(instance, module);
}

async function __wbg_init(input) {
  if (wasm !== undefined) return wasm;

  if (typeof input === "undefined") {
    input = new URL(/* asset import */ __webpack_require__(/*! telemeter_wasm_bg.wasm */ "./node_modules/@wiris/mathtype-html-integration-devkit/telemeter-wasm/telemeter_wasm_bg.wasm"), __webpack_require__.b);
  }
  const imports = __wbg_get_imports();

  if (
    typeof input === "string" ||
    (typeof Request === "function" && input instanceof Request) ||
    (typeof URL === "function" && input instanceof URL)
  ) {
    input = fetch(input);
  }

  __wbg_init_memory(imports);

  const { instance, module } = await __wbg_load(await input, imports);

  return __wbg_finalize_init(instance, module);
}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__wbg_init);


/***/ }),

/***/ "./index.js":
/*!******************!*\
  !*** ./index.js ***!
  \******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MathType)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_core_dist_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/dist/index.js */ "./node_modules/@ckeditor/ckeditor5-core/dist/index.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_dist_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/dist/index.js */ "./node_modules/@ckeditor/ckeditor5-ui/dist/index.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_dist_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/dist/index.js */ "./node_modules/@ckeditor/ckeditor5-engine/dist/index.js");
/* harmony import */ var _ckeditor_ckeditor5_widget_dist_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-widget/dist/index.js */ "./node_modules/@ckeditor/ckeditor5-widget/dist/index.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_integrationmodel_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/integrationmodel.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/integrationmodel.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_core_src_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/core.src.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/core.src.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_parser_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/parser.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/parser.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_util_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/util.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/util.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_image_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/image.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/image.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_configuration_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/configuration.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/configuration.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_listeners_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/listeners.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/listeners.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/mathml.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/mathml.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_latex_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/latex.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/latex.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_stringmanager_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/stringmanager.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/stringmanager.js");
/* harmony import */ var _wiris_mathtype_html_integration_devkit_src_telemeter_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wiris/mathtype-html-integration-devkit/src/telemeter.js */ "./node_modules/@wiris/mathtype-html-integration-devkit/src/telemeter.js");
















/**
 * This class represents the MathType integration for CKEditor5.
 * @extends {IntegrationModel}
 */
class CKEditor5Integration extends _wiris_mathtype_html_integration_devkit_src_integrationmodel_js__WEBPACK_IMPORTED_MODULE_4__["default"] {
  constructor(ckeditorIntegrationModelProperties) {
    const editor = ckeditorIntegrationModelProperties.editorObject;
    if (typeof editor.config !== "undefined" && typeof editor.config.get("mathTypeParameters") !== "undefined") {
      ckeditorIntegrationModelProperties.integrationParameters = editor.config.get("mathTypeParameters");
    }
    /**
    * CKEditor5 Integration.
    *
    * @param {integrationModelProperties} integrationModelAttributes
    */
    super(ckeditorIntegrationModelProperties);
    /**
    * Folder name used for the integration inside CKEditor plugins folder.
    */
    this.integrationFolderName = "ckeditor_wiris";
  }
  /**
  * @inheritdoc
  * @returns {string} - The CKEditor instance language.
  * @override
  */
  getLanguage() {
    // Returns the CKEDitor instance language taking into account that the language can be an object.
    // Try to get editorParameters.language, fail silently otherwise
    try {
      return this.editorParameters.language;
    } catch (e) {}
    const languageObject = this.editorObject.config.get("language");
    if (languageObject != null) {
      if (typeof languageObject === "object") {
        // eslint-disable-next-line no-prototype-builtins
        if (languageObject.hasOwnProperty("ui")) {
          return languageObject.ui;
        }
        return languageObject;
      }
      return languageObject;
    }
    return super.getLanguage();
  }
  /**
  * Adds callbacks to the following CKEditor listeners:
  * - 'focus' - updates the current instance.
  * - 'contentDom' - adds 'doubleclick' callback.
  * - 'doubleclick' - sets to null data.dialog property to avoid modifications for MathType formulas.
  * - 'setData' - parses the data converting MathML into images.
  * - 'afterSetData' - adds an observer to MathType formulas to avoid modifications.
  * - 'getData' - parses the data converting images into selected save mode (MathML by default).
  * - 'mode' - recalculates the active element.
  */
  addEditorListeners() {
    const editor = this.editorObject;
    if (typeof editor.config.wirislistenersdisabled === "undefined" || !editor.config.wirislistenersdisabled) {
      this.checkElement();
    }
  }
  /**
  * Checks the current container and assign events in case that it doesn't have them.
  * CKEditor replaces several times the element element during its execution,
  * so we must assign the events again to editor element.
  */
  checkElement() {
    const editor = this.editorObject;
    const newElement = editor.sourceElement;
    // If the element wasn't treated, add the events.
    if (!newElement.wirisActive) {
      this.setTarget(newElement);
      this.addEvents();
      // Set the element as treated
      newElement.wirisActive = true;
    }
  }
  /**
  * @inheritdoc
  * @param {HTMLElement} element - HTMLElement target.
  * @param {MouseEvent} event - event which trigger the handler.
  */
  doubleClickHandler(element, event) {
    this.core.editionProperties.dbclick = true;
    if (this.editorObject.isReadOnly === false) {
      if (element.nodeName.toLowerCase() === "img") {
        if (_wiris_mathtype_html_integration_devkit_src_util_js__WEBPACK_IMPORTED_MODULE_7__["default"].containsClass(element, _wiris_mathtype_html_integration_devkit_src_configuration_js__WEBPACK_IMPORTED_MODULE_9__["default"].get("imageClassName"))) {
          // Some plugins (image2, image) open a dialog on Double-click. On formulas
          // doubleclick event ends here.
          if (typeof event.stopPropagation !== "undefined") {
            // old I.E compatibility.
            event.stopPropagation();
          } else {
            event.returnValue = false;
          }
          this.core.getCustomEditors().disable();
          const customEditorAttr = element.getAttribute(_wiris_mathtype_html_integration_devkit_src_configuration_js__WEBPACK_IMPORTED_MODULE_9__["default"].get("imageCustomEditorName"));
          if (customEditorAttr) {
            this.core.getCustomEditors().enable(customEditorAttr);
          }
          this.core.editionProperties.temporalImage = element;
          this.openExistingFormulaEditor();
        }
      }
    }
  }
  /** @inheritdoc */
  static getCorePath() {
    return null; // TODO
  }
  /** @inheritdoc */
  callbackFunction() {
    super.callbackFunction();
    this.addEditorListeners();
  }
  openNewFormulaEditor() {
    // Store the editor selection as it will be lost upon opening the modal
    this.core.editionProperties.selection = this.editorObject.editing.view.document.selection;
    // Focus on the selected editor when multiple editor instances are present
    WirisPlugin.currentInstance = this;
    return super.openNewFormulaEditor();
  }
  /**
  * Replaces old formula with new MathML or inserts it in caret position if new
  * @param {String} mathml MathML to update old one or insert
  * @returns {module:engine/model/element~Element} The model element corresponding to the inserted image
  */
  insertMathml(mathml) {
    // This returns the value returned by the callback function (writer => {...})
    return this.editorObject.model.change(writer => {
      const core = this.getCore();
      const selection = this.editorObject.model.document.selection;
      const modelElementNew = writer.createElement("mathml", {
        formula: mathml,
        ...Object.fromEntries(selection.getAttributes())
      });
      // Obtain the DOM <span><img ... /></span> object corresponding to the formula
      if (core.editionProperties.isNewElement) {
        // Don't bother inserting anything at all if the MathML is empty.
        if (!mathml) return;
        const viewSelection = this.core.editionProperties.selection || this.editorObject.editing.view.document.selection;
        const modelPosition = this.editorObject.editing.mapper.toModelPosition(viewSelection.getLastPosition());
        this.editorObject.model.insertObject(modelElementNew, modelPosition);
        // Remove selection
        if (!viewSelection.isCollapsed) {
          for (const range of viewSelection.getRanges()) {
            writer.remove(this.editorObject.editing.mapper.toModelRange(range));
          }
        }
        // Set carret after the formula
        const position = this.editorObject.model.createPositionAfter(modelElementNew);
        writer.setSelection(position);
      } else {
        const img = core.editionProperties.temporalImage;
        const viewElement = this.editorObject.editing.view.domConverter.domToView(img).parent;
        const modelElementOld = this.editorObject.editing.mapper.toModelElement(viewElement);
        // Insert the new <mathml> and remove the old one
        const position = this.editorObject.model.createPositionBefore(modelElementOld);
        // If the given MathML is empty, don't insert a new formula.
        if (mathml) {
          this.editorObject.model.insertObject(modelElementNew, position);
        }
        writer.remove(modelElementOld);
      }
      // eslint-disable-next-line consistent-return
      return modelElementNew;
    });
  }
  /**
  * Finds the text node corresponding to given DOM text element.
  * @param {element} viewElement Element to find corresponding text node of.
  * @returns {module:engine/model/text~Text|undefined} Text node corresponding to the given element or undefined if it doesn't exist.
  */
  findText(viewElement) {
    // eslint-disable-line consistent-return
    // mapper always converts text nodes to *new* model elements so we need to convert the text's parents and then come back down
    let pivot = viewElement;
    let element;
    while (!element) {
      element = this.editorObject.editing.mapper.toModelElement(this.editorObject.editing.view.domConverter.domToView(pivot));
      pivot = pivot.parentElement;
    }
    // Navigate through all the subtree under `pivot` in order to find the correct text node
    const range = this.editorObject.model.createRangeIn(element);
    const descendants = Array.from(range.getItems());
    for (const node of descendants) {
      let viewElementData = viewElement.data;
      if (viewElement.nodeType === 3) {
        // Remove invisible white spaces
        viewElementData = viewElementData.replaceAll(String.fromCharCode(8288), "");
      }
      if (node.is("textProxy") && node.data === viewElementData.replace(String.fromCharCode(160), " ")) {
        return node.textNode;
      }
    }
  }
  /** @inheritdoc */
  insertFormula(focusElement, windowTarget, mathml, wirisProperties) {
    // eslint-disable-line no-unused-vars
    const returnObject = {};
    let mathmlOrigin;
    if (!mathml) {
      this.insertMathml("");
    } else if (this.core.editMode === "latex") {
      returnObject.latex = _wiris_mathtype_html_integration_devkit_src_latex_js__WEBPACK_IMPORTED_MODULE_12__["default"].getLatexFromMathML(mathml);
      returnObject.node = windowTarget.document.createTextNode(`$$${returnObject.latex}$$`);
      this.editorObject.model.change(writer => {
        const {
          latexRange
        } = this.core.editionProperties;
        const startNode = this.findText(latexRange.startContainer);
        const endNode = this.findText(latexRange.endContainer);
        let startPosition = writer.createPositionAt(startNode.parent, startNode.startOffset + latexRange.startOffset);
        let endPosition = writer.createPositionAt(endNode.parent, endNode.startOffset + latexRange.endOffset);
        let range = writer.createRange(startPosition, endPosition);
        // When Latex is next to image/formula.
        if (latexRange.startContainer.nodeType === 3 && latexRange.startContainer.previousSibling?.nodeType === 1) {
          // Get the position of the latex to be replaced.
          let latexEdited = "$$" + _wiris_mathtype_html_integration_devkit_src_latex_js__WEBPACK_IMPORTED_MODULE_12__["default"].getLatexFromMathML(_wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__["default"].safeXmlDecode(this.core.editionProperties.temporalImage.dataset.mathml)) + "$$";
          let data = latexRange.startContainer.data;
          // Remove invisible characters.
          data = data.replaceAll(String.fromCharCode(8288), "");
          // Get to the start of the latex we are editing.
          let offset = data.indexOf(latexEdited);
          let dataOffset = data.substring(offset);
          let second$ = dataOffset.substring(2).indexOf("$$") + 4;
          let substring = dataOffset.substr(0, second$);
          data = data.replace(substring, "");
          if (!data) {
            startPosition = writer.createPositionBefore(startNode);
            range = startNode;
          } else {
            startPosition = startPosition = writer.createPositionAt(startNode.parent, startNode.startOffset + offset);
            endPosition = writer.createPositionAt(endNode.parent, endNode.startOffset + second$ + offset);
            range = writer.createRange(startPosition, endPosition);
          }
        }
        writer.remove(range);
        writer.insertText(`$$${returnObject.latex}$$`, startNode.getAttributes(), startPosition);
      });
    } else {
      mathmlOrigin = this.core.editionProperties.temporalImage?.dataset.mathml;
      try {
        returnObject.node = this.editorObject.editing.view.domConverter.viewToDom(this.editorObject.editing.mapper.toViewElement(this.insertMathml(mathml)), windowTarget.document);
      } catch (e) {
        const x = e.toString();
        if (x.includes("CKEditorError: Cannot read property 'parent' of undefined")) {
          this.core.modalDialog.cancelAction();
        }
      }
    }
    // Build the telemeter payload separated to delete null/undefined entries.
    let payload = {
      mathml_origin: mathmlOrigin ? _wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__["default"].safeXmlDecode(mathmlOrigin) : mathmlOrigin,
      mathml: mathml ? _wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__["default"].safeXmlDecode(mathml) : mathml,
      elapsed_time: Date.now() - this.core.editionProperties.editionStartTime,
      editor_origin: null,
      toolbar: this.core.modalDialog.contentManager.toolbar,
      size: mathml?.length
    };
    // Remove desired null keys.
    Object.keys(payload).forEach(key => {
      if (key === "mathml_origin" || key === "editor_origin") !payload[key] ? delete payload[key] : {};
    });
    // Call Telemetry service to track the event.
    try {
      _wiris_mathtype_html_integration_devkit_src_telemeter_js__WEBPACK_IMPORTED_MODULE_14__["default"].telemeter.track("INSERTED_FORMULA", {
        ...payload
      });
    } catch (error) {
      console.error("Error tracking INSERTED_FORMULA", error);
    }
    /* Due to PLUGINS-1329, we add the onChange event to the CK4 insertFormula.
    We probably should add it here as well, but we should look further into how */ // this.editorObject.fire('change');
    // Remove temporal image of inserted formula
    this.core.editionProperties.temporalImage = null;
    return returnObject;
  }
  /**
  * Function called when the content submits an action.
  */
  notifyWindowClosed() {
    this.editorObject.editing.view.focus();
  }
}

/**
 * Command for opening the MathType editor
 */
class MathTypeCommand extends _ckeditor_ckeditor5_core_dist_index_js__WEBPACK_IMPORTED_MODULE_0__.Command {
  execute(options = {}) {
    // Check we get a valid integration
    // eslint-disable-next-line no-prototype-builtins
    if (!options.hasOwnProperty("integration") || !(options.integration instanceof CKEditor5Integration)) {
      throw 'Must pass a valid CKEditor5Integration instance as attribute "integration" of options';
    }
    // Save the integration instance as a property of the command.
    this.integration = options.integration;
    // Set custom editor or disable it
    this.setEditor();
    // Open the editor
    this.openEditor();
  }
  /**
  * Sets the appropriate custom editor, if any, or disables them.
  */
  setEditor() {
    // It's possible that a custom editor was last used.
    // We need to disable it to avoid wrong behaviors.
    this.integration.core.getCustomEditors().disable();
  }
  /**
  * Checks whether we are editing an existing formula or a new one and opens the editor.
  */
  openEditor() {
    this.integration.core.editionProperties.dbclick = false;
    const image = this._getSelectedImage();
    if (typeof image !== "undefined" && image !== null && image.classList.contains(WirisPlugin.Configuration.get("imageClassName"))) {
      this.integration.core.editionProperties.temporalImage = image;
      this.integration.openExistingFormulaEditor();
    } else {
      this.integration.openNewFormulaEditor();
    }
  }
  /**
  * Gets the currently selected formula image
  * @returns {Element} selected image, if any, undefined otherwise
  */
  _getSelectedImage() {
    const {
      selection
    } = this.editor.editing.view.document;
    // If we can not extract the formula, fall back to default behavior.
    if (selection.isCollapsed || selection.rangeCount !== 1) {
      return;
    }
    // Look for the <span> wrapping the formula and then for the <img/> inside
    const range = selection.getFirstRange();
    let image;
    for (const span of range) {
      if (span.item.name !== "span") {
        return;
      }
      image = span.item.getChild(0);
      break;
    }
    if (!image) {
      return;
    }
    // eslint-disable-next-line consistent-return
    return this.editor.editing.view.domConverter.mapViewToDom(image);
  }
}
/**
 * Command for opening the ChemType editor
 */
class ChemTypeCommand extends MathTypeCommand {
  setEditor() {
    this.integration.core.getCustomEditors().enable("chemistry");
  }
}
var mathIcon = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!-- Generator: Adobe Illustrator 22.0.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t viewBox=\"0 0 300 261.7\" style=\"enable-background:new 0 0 300 261.7;\" xml:space=\"preserve\">\n<style type=\"text/css\">\n\t.st0{fill:#FFFFFF;}\n\t.st1{fill:#EF4A5F;}\n\t.st2{fill:#C8202F;}\n</style>\n<path class=\"st0\" d=\"M300,32.8c0-16.4-13.4-29.7-29.9-29.7c-2.9,0-7.2,0.8-7.2,0.8c-37.9,9.1-71.3,14-112,14c-0.3,0-0.6,0-1,0\n\tc-16.5,0-29.9,13.3-29.9,29.7c0,16.4,13.4,29.7,29.9,29.7l0,0c45.3,0,83.1-5.3,125.3-15.3h0C289.3,59.5,300,47.4,300,32.8\"/>\n<path class=\"st0\" d=\"M90.2,257.7c-11.4,0-21.9-6.4-27-16.7l-60-119.9c-7.5-14.9-1.4-33.1,13.5-40.5c14.9-7.5,33.1-1.4,40.5,13.5\n\tl27.3,54.7L121.1,39c5.3-15.8,22.4-24.4,38.2-19.1c15.8,5.3,24.4,22.4,19.1,38.2l-59.6,179c-3.9,11.6-14.3,19.7-26.5,20.6\n\tC91.6,257.7,90.9,257.7,90.2,257.7\"/>\n<g>\n\t<g>\n\t\t<path class=\"st1\" d=\"M90.2,257.7c-11.4,0-21.9-6.4-27-16.7l-60-119.9c-7.5-14.9-1.4-33.1,13.5-40.5c14.9-7.5,33.1-1.4,40.5,13.5\n\t\t\tl27.3,54.7L121.1,39c5.3-15.8,22.4-24.4,38.2-19.1c15.8,5.3,24.4,22.4,19.1,38.2l-59.6,179c-3.9,11.6-14.3,19.7-26.5,20.6\n\t\t\tC91.6,257.7,90.9,257.7,90.2,257.7\"/>\n\t</g>\n</g>\n<g>\n\t<g>\n\t\t<path class=\"st2\" d=\"M300,32.8c0-16.4-13.4-29.7-29.9-29.7c-2.9,0-7.2,0.8-7.2,0.8c-37.9,9.1-71.3,14-112,14c-0.3,0-0.6,0-1,0\n\t\t\tc-16.5,0-29.9,13.3-29.9,29.7c0,16.4,13.4,29.7,29.9,29.7l0,0c45.3,0,83.1-5.3,125.3-15.3h0C289.3,59.5,300,47.4,300,32.8\"/>\n\t</g>\n</g>\n</svg>\n";
var chemIcon = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!-- Generator: Adobe Illustrator 22.0.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t viewBox=\"0 0 40.3 49.5\" style=\"enable-background:new 0 0 40.3 49.5;\" xml:space=\"preserve\">\n<style type=\"text/css\">\n\t.st0{fill:#A4CF61;}\n</style>\n<path class=\"st0\" d=\"M39.2,12.1c0-1.9-1.1-3.6-2.7-4.4L24.5,0.9l0,0c-0.7-0.4-1.5-0.6-2.4-0.6c-0.9,0-1.7,0.2-2.4,0.6l0,0L2.3,10.8\n\tl0,0C0.9,11.7,0,13.2,0,14.9h0v19.6h0c0,1.7,0.9,3.3,2.3,4.1l0,0l17.4,9.9l0,0c0.7,0.4,1.5,0.6,2.4,0.6c0.9,0,1.7-0.2,2.4-0.6l0,0\n\tl12.2-6.9h0c1.5-0.8,2.6-2.5,2.6-4.3c0-2.7-2.2-4.9-4.9-4.9c-0.9,0-1.8,0.3-2.5,0.7l0,0l-9.7,5.6l-12.3-7V17.8l12.3-7l9.9,5.7l0,0\n\tc0.7,0.4,1.5,0.6,2.4,0.6C37,17,39.2,14.8,39.2,12.1\"/>\n</svg>\n";
var name = "@wiris/mathtype-ckeditor5";
var version = "8.11.1";
var description = "MathType Web for CKEditor5 editor";
var keywords = ["chem", "chemistry", "chemtype", "ckeditor", "ckeditor5", "editor", "equation", "latex", "math", "mathml", "maths", "mathtype", "wiris"];
var repository = "https://github.com/wiris/html-integrations/tree/stable/packages/mathtype-ckeditor5";
var homepage = "https://www.wiris.com/";
var bugs = {
  email: "support@wiris.com"
};
var license = "MIT";
var author = "WIRIS Team (http://www.wiris.com)";
var files = ["dist", "src", "icons", "theme", "lang"];
var main = "src/plugin.js";
var type = "module";
var exports = {
  ".": "./src/plugin.js",
  "./dist/*": "./dist/*",
  "./browser/*": null,
  "./src/*": "./src/*",
  "./theme/*": "./theme/*",
  "./package.json": "./package.json"
};
var scripts = {
  build: "node ./scripts/build-dist.mjs",
  "build:dist": "node ./scripts/build-dist.mjs",
  prepare: "npm run build:dist"
};
var dependencies = {
  "@wiris/mathtype-html-integration-devkit": "1.17.5"
};
var devDependencies = {
  "@ckeditor/ckeditor5-dev-build-tools": "^42.1.0",
  ckeditor5: ">=43.0.0"
};
var peerDependencies = {
  ckeditor5: ">=43.0.0"
};
var packageInfo = {
  name: name,
  version: version,
  description: description,
  keywords: keywords,
  repository: repository,
  homepage: homepage,
  bugs: bugs,
  license: license,
  author: author,
  files: files,
  main: main,
  type: type,
  exports: exports,
  scripts: scripts,
  dependencies: dependencies,
  devDependencies: devDependencies,
  peerDependencies: peerDependencies
};

// CKEditor imports
let currentInstance = null; // eslint-disable-line import/no-mutable-exports
class MathType extends _ckeditor_ckeditor5_core_dist_index_js__WEBPACK_IMPORTED_MODULE_0__.Plugin {
  static get requires() {
    return [_ckeditor_ckeditor5_widget_dist_index_js__WEBPACK_IMPORTED_MODULE_3__.Widget];
  }
  static get pluginName() {
    return "MathType";
  }
  init() {
    // Create the MathType API Integration object
    const integration = this._addIntegration();
    currentInstance = integration;
    // Add the MathType and ChemType commands to the editor
    this._addCommands();
    // Add the buttons for MathType and ChemType
    this._addViews(integration);
    // Registers the <mathml> element in the schema
    this._addSchema();
    // Add the downcast and upcast converters
    this._addConverters(integration);
    // Expose the WirisPlugin variable to the window
    this._exposeWiris();
  }
  /**
  * Inherited from Plugin class: Executed when CKEditor5 is destroyed
  */
  destroy() {
    // eslint-disable-line class-methods-use-this
    currentInstance.destroy();
  }
  /**
  * Create the MathType API Integration object
  * @returns {CKEditor5Integration} the integration object
  */
  _addIntegration() {
    const {
      editor
    } = this;
    /**
    * Integration model constructor attributes.
    * @type {integrationModelProperties}
    */
    const integrationProperties = {};
    integrationProperties.environment = {};
    integrationProperties.environment.editor = "CKEditor5";
    integrationProperties.environment.editorVersion = "5.x";
    integrationProperties.version = packageInfo.version;
    integrationProperties.editorObject = editor;
    integrationProperties.serviceProviderProperties = {};
    integrationProperties.serviceProviderProperties.URI = "https://www.wiris.net/demo/plugins/app";
    integrationProperties.serviceProviderProperties.server = "java";
    integrationProperties.target = editor.sourceElement;
    integrationProperties.scriptName = "bundle.js";
    integrationProperties.managesLanguage = true;
    // etc
    // There are platforms like Drupal that initialize CKEditor but they hide or remove the container element.
    // To avoid a wrong behaviour, this integration only starts if the workspace container exists.
    let integration;
    if (integrationProperties.target) {
      // Instance of the integration associated to this editor instance
      integration = new CKEditor5Integration(integrationProperties);
      integration.init();
      integration.listeners.fire("onTargetReady", {});
      integration.checkElement();
      this.listenTo(editor.editing.view.document, "click", (evt, data) => {
        // Is Double-click
        if (data.domEvent.detail === 2) {
          integration.doubleClickHandler(data.domTarget, data.domEvent);
          evt.stop();
        }
      }, {
        priority: "highest"
      });
    }
    return integration;
  }
  /**
  * Add the MathType and ChemType commands to the editor
  */
  _addCommands() {
    const {
      editor
    } = this;
    // Add command to open the formula editor
    editor.commands.add("MathType", new MathTypeCommand(editor));
    // Add command to open the chemistry formula editor
    editor.commands.add("ChemType", new ChemTypeCommand(editor));
  }
  /**
  * Add the buttons for MathType and ChemType
  * @param {CKEditor5Integration} integration the integration object
  */
  _addViews(integration) {
    const {
      editor
    } = this;
    // Check if MathType editor is enabled
    if (_wiris_mathtype_html_integration_devkit_src_configuration_js__WEBPACK_IMPORTED_MODULE_9__["default"].get("editorEnabled")) {
      // Add button for the formula editor
      editor.ui.componentFactory.add("MathType", locale => {
        const view = new _ckeditor_ckeditor5_ui_dist_index_js__WEBPACK_IMPORTED_MODULE_1__.ButtonView(locale);
        // View is enabled iff command is enabled
        view.bind("isEnabled").to(editor.commands.get("MathType"), "isEnabled");
        view.set({
          label: _wiris_mathtype_html_integration_devkit_src_stringmanager_js__WEBPACK_IMPORTED_MODULE_13__["default"].get("insert_math", integration.getLanguage()),
          icon: mathIcon,
          tooltip: true
        });
        // Callback executed once the image is clicked.
        view.on("execute", () => {
          editor.execute("MathType", {
            integration
          });
        });
        return view;
      });
    }
    // Check if ChemType editor is enabled
    if (_wiris_mathtype_html_integration_devkit_src_configuration_js__WEBPACK_IMPORTED_MODULE_9__["default"].get("chemEnabled")) {
      // Add button for the chemistry formula editor
      editor.ui.componentFactory.add("ChemType", locale => {
        const view = new _ckeditor_ckeditor5_ui_dist_index_js__WEBPACK_IMPORTED_MODULE_1__.ButtonView(locale);
        // View is enabled iff command is enabled
        view.bind("isEnabled").to(editor.commands.get("ChemType"), "isEnabled");
        view.set({
          label: _wiris_mathtype_html_integration_devkit_src_stringmanager_js__WEBPACK_IMPORTED_MODULE_13__["default"].get("insert_chem", integration.getLanguage()),
          icon: chemIcon,
          tooltip: true
        });
        // Callback executed once the image is clicked.
        view.on("execute", () => {
          editor.execute("ChemType", {
            integration
          });
        });
        return view;
      });
    }
    // Observer for the Double-click event
    editor.editing.view.addObserver(_ckeditor_ckeditor5_engine_dist_index_js__WEBPACK_IMPORTED_MODULE_2__.ClickObserver);
  }
  /**
  * Registers the <mathml> element in the schema
  */
  _addSchema() {
    const {
      schema
    } = this.editor.model;
    schema.register("mathml", {
      inheritAllFrom: "$inlineObject",
      allowAttributes: ["formula", "htmlContent"]
    });
  }
  /**
  * Add the downcast and upcast converters
  */
  _addConverters(integration) {
    const {
      editor
    } = this;
    // Editing view -> Model
    editor.conversion.for("upcast").elementToElement({
      view: {
        name: "span",
        classes: "ck-math-widget"
      },
      model: (viewElement, {
        writer: modelWriter
      }) => {
        const formula = _wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__["default"].safeXmlDecode(viewElement.getChild(0).getAttribute("data-mathml"));
        return modelWriter.createElement("mathml", {
          formula
        });
      }
    });
    // Data view -> Model
    editor.data.upcastDispatcher.on("element:math", (evt, data, conversionApi) => {
      const {
        consumable,
        writer
      } = conversionApi;
      const {
        viewItem
      } = data;
      // When element was already consumed then skip it.
      if (!consumable.test(viewItem, {
        name: true
      })) {
        return;
      }
      // If we encounter any <math> with a LaTeX annotation inside,
      // convert it into a "$$...$$" string.
      const isLatex = mathIsLatex(viewItem); // eslint-disable-line no-use-before-define
      // Get the formula of the <math> (which is all its children).
      const processor = new _ckeditor_ckeditor5_engine_dist_index_js__WEBPACK_IMPORTED_MODULE_2__.XmlDataProcessor(editor.editing.view.document);
      // Only god knows why the following line makes viewItem lose all of its children,
      // so we obtain isLatex before doing this because we need viewItem's children for that.
      const upcastWriter = new _ckeditor_ckeditor5_engine_dist_index_js__WEBPACK_IMPORTED_MODULE_2__.UpcastWriter(editor.editing.view.document);
      const viewDocumentFragment = upcastWriter.createDocumentFragment(viewItem.getChildren());
      // and obtain the attributes of <math> too!
      const mathAttributes = [...viewItem.getAttributes()].map(([key, value]) => ` ${key}="${value}"`).join("");
      // We process the document fragment
      let formula = processor.toData(viewDocumentFragment) || "";
      // And obtain the complete formula
      formula = _wiris_mathtype_html_integration_devkit_src_util_js__WEBPACK_IMPORTED_MODULE_7__["default"].htmlSanitize(`<math${mathAttributes}>${formula}</math>`);
      // Replaces the < & > characters to its HTMLEntity to avoid render issues.
      formula = formula.replaceAll('"<"', '"&lt;"').replaceAll('">"', '"&gt;"').replaceAll("><<", ">&lt;<");
      /* Model node that contains what's going to actually be inserted. This can be either:
      - A <mathml> element with a formula attribute set to the given formula, or
      - If the original <math> had a LaTeX annotation, then the annotation surrounded by "$$...$$" */
      const modelNode = isLatex ? writer.createText(_wiris_mathtype_html_integration_devkit_src_parser_js__WEBPACK_IMPORTED_MODULE_6__["default"].initParse(formula, integration.getLanguage())) : writer.createElement("mathml", {
        formula
      });
      // Find allowed parent for element that we are going to insert.
      // If current parent does not allow to insert element but one of the ancestors does
      // then split nodes to allowed parent.
      const splitResult = conversionApi.splitToAllowedParent(modelNode, data.modelCursor);
      // When there is no split result it means that we can't insert element to model tree, so let's skip it.
      if (!splitResult) {
        return;
      }
      // Insert element on allowed position.
      conversionApi.writer.insert(modelNode, splitResult.position);
      // Consume appropriate value from consumable values list.
      consumable.consume(viewItem, {
        name: true
      });
      const parts = conversionApi.getSplitParts(modelNode);
      // Set conversion result range.
      data.modelRange = writer.createRange(conversionApi.writer.createPositionBefore(modelNode), conversionApi.writer.createPositionAfter(parts[parts.length - 1]));
      // Now we need to check where the `modelCursor` should be.
      if (splitResult.cursorParent) {
        // If we split parent to insert our element then we want to continue conversion in the new part of the split parent.
        //
        // before: <allowed><notAllowed>foo[]</notAllowed></allowed>
        // after:  <allowed><notAllowed>foo</notAllowed><converted></converted><notAllowed>[]</notAllowed></allowed>
        data.modelCursor = conversionApi.writer.createPositionAt(splitResult.cursorParent, 0);
      } else {
        // Otherwise just continue after inserted element.
        data.modelCursor = data.modelRange.end;
      }
    });
    // Data view -> Model
    editor.data.upcastDispatcher.on("element:img", (evt, data, conversionApi) => {
      const {
        consumable,
        writer
      } = conversionApi;
      const {
        viewItem
      } = data;
      // Only upcast when is wiris formula
      if (viewItem.getClassNames().next().value !== "Wirisformula") {
        return;
      }
      const mathAttributes = [...viewItem.getAttributes()].map(([key, value]) => ` ${key}="${value}"`).join("");
      let htmlContent = _wiris_mathtype_html_integration_devkit_src_util_js__WEBPACK_IMPORTED_MODULE_7__["default"].htmlSanitize(`<img${mathAttributes}>`);
      const modelNode = writer.createElement("mathml", {
        htmlContent
      });
      // Find allowed parent for element that we are going to insert.
      // If current parent does not allow to insert element but one of the ancestors does
      // then split nodes to allowed parent.
      const splitResult = conversionApi.splitToAllowedParent(modelNode, data.modelCursor);
      // When there is no split result it means that we can't insert element to model tree, so let's skip it.
      if (!splitResult) {
        return;
      }
      // Insert element on allowed position.
      conversionApi.writer.insert(modelNode, splitResult.position);
      // Consume appropriate value from consumable values list.
      consumable.consume(viewItem, {
        name: true
      });
      const parts = conversionApi.getSplitParts(modelNode);
      // Set conversion result range.
      data.modelRange = writer.createRange(conversionApi.writer.createPositionBefore(modelNode), conversionApi.writer.createPositionAfter(parts[parts.length - 1]));
      // Now we need to check where the `modelCursor` should be.
      if (splitResult.cursorParent) {
        // If we split parent to insert our element then we want to continue conversion in the new part of the split parent.
        //
        // before: <allowed><notAllowed>foo[]</notAllowed></allowed>
        // after:  <allowed><notAllowed>foo</notAllowed><converted></converted><notAllowed>[]</notAllowed></allowed>
        data.modelCursor = conversionApi.writer.createPositionAt(splitResult.cursorParent, 0);
      } else {
        // Otherwise just continue after inserted element.
        data.modelCursor = data.modelRange.end;
      }
    });
    /**
    * Whether the given view <math> element has a LaTeX annotation element.
    * @param {*} math
    * @returns {bool}
    */
    function mathIsLatex(math) {
      const semantics = math.getChild(0);
      if (!semantics || semantics.name !== "semantics") return false;
      for (const child of semantics.getChildren()) {
        if (child.name === "annotation" && child.getAttribute("encoding") === "LaTeX") {
          return true;
        }
      }
      return false;
    }
    function createViewWidget(modelItem, {
      writer: viewWriter
    }) {
      const widgetElement = viewWriter.createContainerElement("span", {
        class: "ck-math-widget"
      });
      const mathUIElement = createViewImage(modelItem, {
        writer: viewWriter
      }); // eslint-disable-line no-use-before-define
      if (mathUIElement) {
        viewWriter.insert(viewWriter.createPositionAt(widgetElement, 0), mathUIElement);
      }
      return (0,_ckeditor_ckeditor5_widget_dist_index_js__WEBPACK_IMPORTED_MODULE_3__.toWidget)(widgetElement, viewWriter);
    }
    function createViewImage(modelItem, {
      writer: viewWriter
    }) {
      const htmlDataProcessor = new _ckeditor_ckeditor5_engine_dist_index_js__WEBPACK_IMPORTED_MODULE_2__.HtmlDataProcessor(viewWriter.document);
      const formula = modelItem.getAttribute("formula");
      const htmlContent = modelItem.getAttribute("htmlContent");
      if (!formula && !htmlContent) {
        return null;
      }
      let imgElement = null;
      if (htmlContent) {
        imgElement = htmlDataProcessor.toView(htmlContent).getChild(0);
      } else if (formula) {
        const mathString = formula.replaceAll('ref="<"', 'ref="&lt;"');
        const imgHtml = _wiris_mathtype_html_integration_devkit_src_parser_js__WEBPACK_IMPORTED_MODULE_6__["default"].initParse(mathString, integration.getLanguage());
        imgElement = htmlDataProcessor.toView(imgHtml).getChild(0);
        // Add HTML element (<img>) to model
        viewWriter.setAttribute("htmlContent", imgHtml, modelItem);
      }
      /* Although we use the HtmlDataProcessor to obtain the attributes,
      *  we must create a new EmptyElement which is independent of the
      *  DataProcessor being used by this editor instance
      */
      if (imgElement) {
        return viewWriter.createEmptyElement("img", imgElement.getAttributes(), {
          renderUnsafeAttributes: ["src"]
        });
      }
      return null;
    }
    // Model -> Editing view
    editor.conversion.for("editingDowncast").elementToElement({
      model: "mathml",
      view: createViewWidget
    });
    // Model -> Data view
    editor.conversion.for("dataDowncast").elementToElement({
      model: "mathml",
      view: createDataString
    });
    /**
    * Makes a copy of the given view node.
    * @param {module:engine/view/node~Node} sourceNode Node to copy.
    * @returns {module:engine/view/node~Node} Copy of the node.
    */
    function clone(viewWriter, sourceNode) {
      if (sourceNode.is("text")) {
        return viewWriter.createText(sourceNode.data);
      }
      if (sourceNode.is("element")) {
        if (sourceNode.is("emptyElement")) {
          return viewWriter.createEmptyElement(sourceNode.name, sourceNode.getAttributes());
        }
        const element = viewWriter.createContainerElement(sourceNode.name, sourceNode.getAttributes());
        for (const child of sourceNode.getChildren()) {
          viewWriter.insert(viewWriter.createPositionAt(element, "end"), clone(viewWriter, child));
        }
        return element;
      }
      throw new Exception("Given node has unsupported type."); // eslint-disable-line no-undef
    }
    function createDataString(modelItem, {
      writer: viewWriter
    }) {
      const htmlDataProcessor = new _ckeditor_ckeditor5_engine_dist_index_js__WEBPACK_IMPORTED_MODULE_2__.HtmlDataProcessor(viewWriter.document);
      // Load img element
      let mathString = modelItem.getAttribute("htmlContent");
      const sourceMathElement = htmlDataProcessor.toView(mathString).getChild(0);
      return clone(viewWriter, sourceMathElement);
    }
    // This stops the view selection getting into the <span>s and messing up caret movement
    editor.editing.mapper.on("viewToModelPosition", (0,_ckeditor_ckeditor5_widget_dist_index_js__WEBPACK_IMPORTED_MODULE_3__.viewToModelPositionOutsideModelElement)(editor.model, viewElement => viewElement.hasClass("ck-math-widget")));
    // Keep a reference to the original get and set function.
    editor.data;
    /**
    * Hack to transform $$latex$$ into <math> in editor.getData()'s output.
    */
    editor.data.on("get", e => {
      let output = e.return;
      const parsedResult = _wiris_mathtype_html_integration_devkit_src_parser_js__WEBPACK_IMPORTED_MODULE_6__["default"].endParse(output);
      // Cleans all the semantics tag for safexml
      // including the handwritten data points
      e.return = _wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__["default"].removeSafeXMLSemantics(parsedResult);
    }, {
      priority: "low"
    });
    /**
    * Hack to transform <math> with LaTeX into $$LaTeX$$ and formula images in editor.setData().
    */
    editor.data.on("set", (e, args) => {
      // Retrieve the data to be set on the CKEditor.
      let modifiedData = args[0];
      // Regex to find all mathml formulas.
      const regexp = /(<img\b[^>]*>)|(<math(.*?)<\/math>)/gm;
      const formulas = [];
      let formula;
      // Both data.set from the source plugin and console command are taken into account as the data received is MathML or an image containing the MathML.
      while ((formula = regexp.exec(modifiedData)) !== null) {
        formulas.push(formula[0]);
      }
      // Loop to find LaTeX and formula images and replace the MathML for the both.
      formulas.forEach(formula => {
        if (formula.includes('encoding="LaTeX"')) {
          // LaTeX found.
          let latex = "$$$" + _wiris_mathtype_html_integration_devkit_src_latex_js__WEBPACK_IMPORTED_MODULE_12__["default"].getLatexFromMathML(formula) + "$$$"; // We add $$$ instead of $$ because the replace function ignores one $.
          modifiedData = modifiedData.replace(formula, latex);
        } else if (formula.includes("<img")) {
          // If we found a formula image, we should find MathML data, and then substitute the entire image.
          const regexp = /«math\b[^»]*»(.*?)«\/math»/g;
          const safexml = formula.match(regexp);
          if (safexml !== null) {
            let decodeXML = _wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__["default"].safeXmlDecode(safexml[0]);
            modifiedData = modifiedData.replace(formula, decodeXML);
          }
        }
      });
      args[0] = modifiedData;
    }, {
      priority: "high"
    });
  }
  /**
  * Expose the WirisPlugin variable to the window
  */ // eslint-disable-next-line class-methods-use-this
  _exposeWiris() {
    window.WirisPlugin = {
      Core: _wiris_mathtype_html_integration_devkit_src_core_src_js__WEBPACK_IMPORTED_MODULE_5__["default"],
      Parser: _wiris_mathtype_html_integration_devkit_src_parser_js__WEBPACK_IMPORTED_MODULE_6__["default"],
      Image: _wiris_mathtype_html_integration_devkit_src_image_js__WEBPACK_IMPORTED_MODULE_8__["default"],
      MathML: _wiris_mathtype_html_integration_devkit_src_mathml_js__WEBPACK_IMPORTED_MODULE_11__["default"],
      Util: _wiris_mathtype_html_integration_devkit_src_util_js__WEBPACK_IMPORTED_MODULE_7__["default"],
      Configuration: _wiris_mathtype_html_integration_devkit_src_configuration_js__WEBPACK_IMPORTED_MODULE_9__["default"],
      Listeners: _wiris_mathtype_html_integration_devkit_src_listeners_js__WEBPACK_IMPORTED_MODULE_10__["default"],
      IntegrationModel: _wiris_mathtype_html_integration_devkit_src_integrationmodel_js__WEBPACK_IMPORTED_MODULE_4__["default"],
      currentInstance,
      Latex: _wiris_mathtype_html_integration_devkit_src_latex_js__WEBPACK_IMPORTED_MODULE_12__["default"]
    };
  }
}


/***/ }),

/***/ "./node_modules/blurhash/dist/esm/index.js":
/*!*************************************************!*\
  !*** ./node_modules/blurhash/dist/esm/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ValidationError: () => (/* binding */ d),
/* harmony export */   decode: () => (/* binding */ j),
/* harmony export */   encode: () => (/* binding */ S),
/* harmony export */   isBlurhashValid: () => (/* binding */ N)
/* harmony export */ });
var q=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","#","$","%","*","+",",","-",".",":",";","=","?","@","[","]","^","_","{","|","}","~"],x=t=>{let e=0;for(let r=0;r<t.length;r++){let n=t[r],l=q.indexOf(n);e=e*83+l}return e},p=(t,e)=>{var r="";for(let n=1;n<=e;n++){let l=Math.floor(t)/Math.pow(83,e-n)%83;r+=q[Math.floor(l)]}return r};var f=t=>{let e=t/255;return e<=.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)},h=t=>{let e=Math.max(0,Math.min(1,t));return e<=.0031308?Math.trunc(e*12.92*255+.5):Math.trunc((1.055*Math.pow(e,.4166666666666667)-.055)*255+.5)},F=t=>t<0?-1:1,M=(t,e)=>F(t)*Math.pow(Math.abs(t),e);var d=class extends Error{constructor(e){super(e),this.name="ValidationError",this.message=e}};var C=t=>{if(!t||t.length<6)throw new d("The blurhash string must be at least 6 characters");let e=x(t[0]),r=Math.floor(e/9)+1,n=e%9+1;if(t.length!==4+2*n*r)throw new d(`blurhash length mismatch: length is ${t.length} but it should be ${4+2*n*r}`)},N=t=>{try{C(t)}catch(e){return{result:!1,errorReason:e.message}}return{result:!0}},z=t=>{let e=t>>16,r=t>>8&255,n=t&255;return[f(e),f(r),f(n)]},L=(t,e)=>{let r=Math.floor(t/361),n=Math.floor(t/19)%19,l=t%19;return[M((r-9)/9,2)*e,M((n-9)/9,2)*e,M((l-9)/9,2)*e]},U=(t,e,r,n)=>{C(t),n=n|1;let l=x(t[0]),m=Math.floor(l/9)+1,b=l%9+1,i=(x(t[1])+1)/166,u=new Array(b*m);for(let o=0;o<u.length;o++)if(o===0){let a=x(t.substring(2,6));u[o]=z(a)}else{let a=x(t.substring(4+o*2,6+o*2));u[o]=L(a,i*n)}let c=e*4,s=new Uint8ClampedArray(c*r);for(let o=0;o<r;o++)for(let a=0;a<e;a++){let y=0,B=0,R=0;for(let w=0;w<m;w++)for(let P=0;P<b;P++){let G=Math.cos(Math.PI*a*P/e)*Math.cos(Math.PI*o*w/r),T=u[P+w*b];y+=T[0]*G,B+=T[1]*G,R+=T[2]*G}let V=h(y),I=h(B),E=h(R);s[4*a+0+o*c]=V,s[4*a+1+o*c]=I,s[4*a+2+o*c]=E,s[4*a+3+o*c]=255}return s},j=U;var A=4,D=(t,e,r,n)=>{let l=0,m=0,b=0,g=e*A;for(let u=0;u<e;u++){let c=A*u;for(let s=0;s<r;s++){let o=c+s*g,a=n(u,s);l+=a*f(t[o]),m+=a*f(t[o+1]),b+=a*f(t[o+2])}}let i=1/(e*r);return[l*i,m*i,b*i]},$=t=>{let e=h(t[0]),r=h(t[1]),n=h(t[2]);return(e<<16)+(r<<8)+n},H=(t,e)=>{let r=Math.floor(Math.max(0,Math.min(18,Math.floor(M(t[0]/e,.5)*9+9.5)))),n=Math.floor(Math.max(0,Math.min(18,Math.floor(M(t[1]/e,.5)*9+9.5)))),l=Math.floor(Math.max(0,Math.min(18,Math.floor(M(t[2]/e,.5)*9+9.5))));return r*19*19+n*19+l},O=(t,e,r,n,l)=>{if(n<1||n>9||l<1||l>9)throw new d("BlurHash must have between 1 and 9 components");if(e*r*4!==t.length)throw new d("Width and height must match the pixels array");let m=[];for(let s=0;s<l;s++)for(let o=0;o<n;o++){let a=o==0&&s==0?1:2,y=D(t,e,r,(B,R)=>a*Math.cos(Math.PI*o*B/e)*Math.cos(Math.PI*s*R/r));m.push(y)}let b=m[0],g=m.slice(1),i="",u=n-1+(l-1)*9;i+=p(u,1);let c;if(g.length>0){let s=Math.max(...g.map(a=>Math.max(...a))),o=Math.floor(Math.max(0,Math.min(82,Math.floor(s*166-.5))));c=(o+1)/166,i+=p(o,1)}else c=1,i+=p(0,1);return i+=p($(b),4),g.forEach(s=>{i+=p(H(s,c),2)}),i},S=O;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/color-name/index.js":
/*!******************************************!*\
  !*** ./node_modules/color-name/index.js ***!
  \******************************************/
/***/ ((module) => {

"use strict";


module.exports = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/@wiris/mathtype-html-integration-devkit/styles/styles.css":
/*!**********************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/@wiris/mathtype-html-integration-devkit/styles/styles.css ***!
  \**********************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.wrs_modal_overlay {
  position: fixed;
  font-family: arial, sans-serif;
  top: 0;
  right: 0;
  left: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.8);
  z-index: 999998;
  opacity: 0.65;
  pointer-events: auto;
}

.wrs_modal_overlay.wrs_modal_ios {
  visibility: hidden;
  display: none;
}

.wrs_modal_overlay.wrs_modal_android {
  visibility: hidden;
  display: none;
}

.wrs_modal_overlay.wrs_modal_ios.moodle {
  position: fixed;
}

.wrs_modal_overlay.wrs_modal_desktop.wrs_stack {
  background: rgba(0, 0, 0, 0);
  display: none;
}

.wrs_modal_overlay.wrs_modal_desktop.wrs_maximized {
  background: rgba(0, 0, 0, 0.8);
}

.wrs_modal_overlay.wrs_modal_desktop.wrs_minimized {
  background: rgba(0, 0, 0, 0);
  display: none;
}

.wrs_modal_overlay.wrs_modal_desktop.wrs_closed {
  background: rgba(0, 0, 0, 0);
  display: none;
}

.wrs_modal_title {
  color: #fff;
  padding: 5px 0 5px 10px;
  -moz-user-select: none;
  -webkit-user-select: none;
  -ms-user-select: none;
  user-select: none;
  text-align: left;
}

.wrs_modal_close_button {
  float: right;
  cursor: pointer;
  color: #fff;
  padding: 5px 10px 5px 0;
  margin: 10px 7px 0 0;
  background-repeat: no-repeat;
}

.wrs_modal_minimize_button {
  float: right;
  cursor: pointer;
  color: #fff;
  padding: 5px 10px 5px 0;
  top: inherit;
  margin: 10px 7px 0 0;
}

.wrs_modal_stack_button {
  float: right;
  cursor: pointer;
  color: #fff;
  margin: 10px 7px 0 0;
  padding: 5px 10px 5px 0;
  top: inherit;
}

.wrs_modal_stack_button.wrs_stack {
  visibility: hidden;
  margin: 0;
  padding: 0;
}

.wrs_modal_stack_button.wrs_minimized {
  visibility: hidden;
  margin: 0;
  padding: 0;
}

.wrs_modal_maximize_button {
  float: right;
  cursor: pointer;
  color: #fff;
  margin: 10px 7px 0 0;
  padding: 5px 10px 5px 0;
  top: inherit;
}

.wrs_modal_maximize_button.wrs_maximized {
  visibility: hidden;
  margin: 0;
  padding: 0;
}

.wrs_modal_title_bar {
  display: block;
  background-color: #778e9a;
}

.wrs_modal_dialogContainer {
  border: none;
  background: #fafafa;
  z-index: 999999;
}

.wrs_modal_dialogContainer.wrs_modal_desktop {
  font-size: 14px;
}

.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_maximized {
  position: fixed;
}

.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_minimized {
  position: fixed;
  top: inherit;
  margin: 0;
  margin-right: 10px;
}

.wrs_modal_dialogContainer.wrs_closed {
  visibility: hidden;
  display: none;
  opacity: 0;
}

/* Class that exists but hasn't got css properties defined
.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_minimized.wrs_drag {} */

.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_stack {
  position: fixed;
  bottom: 0;
  right: 0;
  box-shadow: rgba(0, 0, 0, 0.5) 0 2px 8px;
}

.wrs_modal_dialogContainer.wrs_drag {
  box-shadow: rgba(0, 0, 0, 0.5) 0 2px 8px;
}

.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_drag {
  box-shadow: rgba(0, 0, 0, 0.5) 0 2px 8px;
}

.wrs_modal_dialogContainer.wrs_modal_android {
  margin: auto;
  position: fixed;
  width: 99%;
  height: 99%;
  overflow: hidden;
  transform: translate(50%, -50%);
  top: 50%;
  right: 50% !important;
}

.wrs_modal_dialogContainer.wrs_modal_ios {
  margin: auto;
  position: fixed;
  width: 100%;
  height: 100%;
  overflow: hidden;
  transform: translate(50%, -50%);
  top: 50%;
  right: 50% !important;
}

/* Class that exists but hasn't got css properties defined
.wrs_content_container.wrs_maximized {} */

.wrs_content_container.wrs_minimized {
  display: none;
}

/* .wrs_editor {
    flex-grow: 1;
} */

.wrs_content_container.wrs_modal_android {
  width: 100%;
  height: 0%;
  flex-grow: 1;
  display: flex;
  flex-direction: column;
}

.wrs_content_container.wrs_modal_android > div:first-child {
  flex-grow: 1;
}

.wrs_content_container.wrs_modal_ios > div:first-child {
  flex-grow: 1;
}

.wrs_content_container.wrs_modal_desktop > div:first-child {
  flex-grow: 1;
}

.wrs_modal_wrapper.wrs_modal_android {
  margin: auto;
  display: flex;
  flex-direction: column;
  height: 100%;
  width: 100%;
}

.wrs_content_container.wrs_modal_desktop {
  width: 100%;
  flex-grow: 1;
  display: flex;
  flex-direction: column;
}

.wrs_content_container.wrs_modal_ios {
  width: 100%;
  height: 0%;
  flex-grow: 1;
  display: flex;
  flex-direction: column;
}

.wrs_modal_wrapper.wrs_modal_ios {
  margin: auto;
  display: flex;
  flex-direction: column;
  height: 100%;
  width: 100%;
}

.wrs_virtual_keyboard {
  height: 100%;
  width: 100%;
  top: 0;
  left: 50%;
  transform: translate(-50%, 0%);
}

@media all and (orientation: portrait) {
  .wrs_modal_dialogContainer.wrs_modal_mobile {
    width: 100vmin;
    height: 100vmin;
    margin: auto;
    border-width: 0;
  }

  .wrs_modal_wrapper.wrs_modal_mobile {
    width: 100vmin;
    height: 100vmin;
    margin: auto;
  }
}

@media all and (orientation: landscape) {
  .wrs_modal_dialogContainer.wrs_modal_mobile {
    width: 100vmin;
    height: 100vmin;
    margin: auto;
    border-width: 0;
  }

  .wrs_modal_wrapper.wrs_modal_mobile {
    width: 100vmin;
    height: 100vmin;
    margin: auto;
  }
}

.wrs_modal_dialogContainer.wrs_modal_badStock {
  width: 100%;
  height: 280px;
  margin: 0 auto;
  border-width: 0;
}

.wrs_modal_wrapper.wrs_modal_badStock {
  width: 100%;
  height: 280px;
  margin: 0 auto;
  border-width: 0;
}

.wrs_noselect {
  -moz-user-select: none;
  -khtml-user-select: none;
  -webkit-user-select: none;
  -ms-user-select: none;
  user-select: none;
}

.wrs_bottom_right_resizer {
  width: 10px;
  height: 10px;
  color: #778e9a;
  position: absolute;
  right: 4px;
  bottom: 8px;
  cursor: se-resize;
  -moz-user-select: none;
  -webkit-user-select: none;
  -ms-user-select: none;
  user-select: none;
}

.wrs_bottom_left_resizer {
  width: 15px;
  height: 15px;
  color: #778e9a;
  position: absolute;
  left: 0;
  top: 0;
  cursor: se-resize;
}

.wrs_modal_controls {
  height: 42px;
  margin: 3px 0;
  overflow: hidden;
  line-height: normal;
}

.wrs_modal_links {
  margin: 10px auto;
  margin-bottom: 0;
  font-family: arial, sans-serif;
  padding: 6px;
  display: inline;
  float: right;
  text-align: right;
}

.wrs_modal_links > a {
  text-decoration: none;
  color: #778e9a;
  font-size: 16px;
}

.wrs_modal_button_cancel,
.wrs_modal_button_cancel:hover,
.wrs_modal_button_cancel:visited,
.wrs_modal_button_cancel:active,
.wrs_modal_button_cancel:focus {
  min-width: 80px;
  font-size: 14px;
  border-radius: 3px;
  border: 1px solid #778e9a;
  padding: 6px 8px;
  margin: 10px auto;
  margin-left: 5px;
  margin-bottom: 0;
  cursor: pointer;
  font-family: arial, sans-serif;
  background-color: #ddd;
  height: 32px;
}

.wrs_modal_button_accept,
.wrs_modal_button_accept:hover,
.wrs_modal_button_accept:visited,
.wrs_modal_button_accept:active,
.wrs_modal_button_accept:focus {
  min-width: 80px;
  font-size: 14px;
  border-radius: 3px;
  border: 1px solid #778e9a;
  padding: 6px 8px;
  margin: 10px auto;
  margin-right: 5px;
  margin-bottom: 0;
  color: #fff;
  background: #778e9a;
  cursor: pointer;
  font-family: arial, sans-serif;
  height: 32px;
}

.wrs_editor_vertical_bar {
  height: 20px;
  float: right;
  background: none;
  width: 20px;
  cursor: pointer;
}

.wrs_modal_buttons_container {
  display: inline;
  float: left;
}

.wrs_modal_buttons_container.wrs_modalAndroid {
  padding-left: 6px;
}

.wrs_modal_buttons_container.wrs_modalDesktop {
  padding-left: 0;
}

.wrs_modal_buttons_container > button {
  line-height: normal;
  background-image: none;
}

.wrs_modal_wrapper {
  margin: 6px;
  display: flex;
  flex-direction: column;
}

.wrs_modal_wrapper.wrs_modal_desktop.wrs_minimized {
  display: none;
}

@media only screen and (max-device-width: 480px) and (orientation: portrait) {
  #wrs_modal_wrapper {
    width: 140%;
  }
}

.wrs_popupmessage_overlay_envolture {
  display: none;
  width: 100%;
}

.wrs_popupmessage_overlay {
  position: absolute;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  z-index: 4;
  cursor: pointer;
}

.wrs_popupmessage_panel {
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  position: absolute;
  background: white;
  max-width: 500px;
  width: 75%;
  border-radius: 2px;
  padding: 20px;
  font-family: sans-serif;
  font-size: 15px;
  text-align: left;
  color: #2e2e2e;
  z-index: 5;
  max-height: 75%;
  overflow: auto;
}

.wrs_popupmessage_button_area {
  margin: 10px 0 0 0;
}

.wrs_panelContainer * {
  border: 0;
}

.wrs_button_cancel,
.wrs_button_cancel:hover,
.wrs_button_cancel:visited,
.wrs_button_cancel:active,
.wrs_button_cancel:focus {
  min-width: 80px;
  font-size: 14px;
  border-radius: 3px;
  border: 1px solid #778e9a;
  padding: 6px 8px;
  margin: 10px auto;
  margin-left: 5px;
  margin-bottom: 0;
  cursor: pointer;
  font-family: arial, sans-serif;
  background-color: #ddd;
  background-image: none;
  height: 32px;
}

.wrs_button_accept,
.wrs_button_accept:hover,
.wrs_button_accept:visited,
.wrs_button_accept:active,
.wrs_button_accept:focus {
  min-width: 80px;
  font-size: 14px;
  border-radius: 3px;
  border: 1px solid #778e9a;
  padding: 6px 8px;
  margin: 10px auto;
  margin-right: 5px;
  margin-bottom: 0;
  color: #fff;
  background: #778e9a;
  cursor: pointer;
  font-family: arial, sans-serif;
  height: 32px;
}

.wrs_editor button {
  box-shadow: none;
}

.wrs_editor .wrs_header button {
  border-bottom: none;
  border-bottom-left-radius: 0;
  border-bottom-right-radius: 0;
}

.wrs_modal_overlay.wrs_modal_desktop.wrs_stack.wrs_overlay_active {
  display: block;
}

/* Fix selection in drupal style */
.wrs_toolbar tr:focus {
  background: none;
}

.wrs_toolbar tr:hover {
  background: none;
}

/* End of fix drupal */
.wrs_modal_rtl .wrs_modal_button_cancel {
  margin-right: 5px;
  margin-left: 0;
}

.wrs_modal_rtl .wrs_modal_button_accept {
  margin-right: 0;
  margin-left: 5px;
}

.wrs_modal_rtl .wrs_button_cancel {
  margin-right: 5px;
  margin-left: 0;
}

.wrs_modal_rtl .wrs_button_accept {
  margin-right: 0;
  margin-left: 5px;
}

/* The Offline Modal (background) */
.wrs_modal_offline {
  display: none; /* Hidden by default */
  position: fixed; /* Stay in place */
  z-index: 2; /* Sit on top */
  padding-top: 150px; /* Location of the box */
  left: 0;
  top: 0;
  width: 100%; /* Full width */
  height: 100%; /* Full height */
  overflow: auto; /* Enable scroll if needed */
  background-color: rgb(0, 0, 0); /* Fallback color */
  background-color: rgba(0, 0, 0, 0.4); /* Black w/ opacity */
  margin: auto;
}

/* Modal Content */
.wrs_modal_content_offline {
  margin: auto;
  padding: 16px;
  background: #fff7ed;
  border-radius: 6px;
  width: 517px;
  height: 100px;
  position: relative;
}

/* The Close Button */
.wrs_modal_offline_close {
  color: #c2410c;
  font-size: 24px;
  font-weight: bold;
  left: 95.7%;
  right: 2.08%;
  top: 7.6%;
  bottom: 75%;
  font-family: "Inter";
  font-style: normal;
  font-weight: 400;
  position: absolute;
}

/* The Warn Icon */
.wrs_modal_offline_warn {
  position: absolute;
  left: 2.08%;
  right: 94%;
  top: 11.6%;
  bottom: 75%;
  font-size: 24px;
  color: #fb923c;
  background-repeat: no-repeat;
}

.wrs_modal_offline_text_container {
  position: absolute;
  left: 6.8%;
  right: 6.08%;
  top: 10.4%;
  bottom: 2%;
}

.wrs_modal_offline_text {
  font-family: "Inter";
  font-style: normal;
  font-weight: 400;
  font-size: 14px;
  line-height: 20px;
  color: #c2410c;
}

.wrs_modal_offline_text_warn {
  height: 25px;
  font-family: "Inter";
  font-style: normal;
  font-size: 14px;
  line-height: 20px;
  font-weight: bold;
  color: #c2410c;
}

.wrs_modal_offline_close:hover,
.wrs_modal_offline_close:focus {
  color: #000;
  text-decoration: none;
  cursor: pointer;
}
`, "",{"version":3,"sources":["webpack://./node_modules/@wiris/mathtype-html-integration-devkit/styles/styles.css"],"names":[],"mappings":"AAAA;EACE,eAAe;EACf,8BAA8B;EAC9B,MAAM;EACN,QAAQ;EACR,OAAO;EACP,SAAS;EACT,8BAA8B;EAC9B,eAAe;EACf,aAAa;EACb,oBAAoB;AACtB;;AAEA;EACE,kBAAkB;EAClB,aAAa;AACf;;AAEA;EACE,kBAAkB;EAClB,aAAa;AACf;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,4BAA4B;EAC5B,aAAa;AACf;;AAEA;EACE,8BAA8B;AAChC;;AAEA;EACE,4BAA4B;EAC5B,aAAa;AACf;;AAEA;EACE,4BAA4B;EAC5B,aAAa;AACf;;AAEA;EACE,WAAW;EACX,uBAAuB;EACvB,sBAAsB;EACtB,yBAAyB;EACzB,qBAAqB;EACrB,iBAAiB;EACjB,gBAAgB;AAClB;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,WAAW;EACX,uBAAuB;EACvB,oBAAoB;EACpB,4BAA4B;AAC9B;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,WAAW;EACX,uBAAuB;EACvB,YAAY;EACZ,oBAAoB;AACtB;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,WAAW;EACX,oBAAoB;EACpB,uBAAuB;EACvB,YAAY;AACd;;AAEA;EACE,kBAAkB;EAClB,SAAS;EACT,UAAU;AACZ;;AAEA;EACE,kBAAkB;EAClB,SAAS;EACT,UAAU;AACZ;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,WAAW;EACX,oBAAoB;EACpB,uBAAuB;EACvB,YAAY;AACd;;AAEA;EACE,kBAAkB;EAClB,SAAS;EACT,UAAU;AACZ;;AAEA;EACE,cAAc;EACd,yBAAyB;AAC3B;;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,eAAe;AACjB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,eAAe;EACf,YAAY;EACZ,SAAS;EACT,kBAAkB;AACpB;;AAEA;EACE,kBAAkB;EAClB,aAAa;EACb,UAAU;AACZ;;AAEA;wEACwE;;AAExE;EACE,eAAe;EACf,SAAS;EACT,QAAQ;EACR,wCAAwC;AAC1C;;AAEA;EACE,wCAAwC;AAC1C;;AAEA;EACE,wCAAwC;AAC1C;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,UAAU;EACV,WAAW;EACX,gBAAgB;EAChB,+BAA+B;EAC/B,QAAQ;EACR,qBAAqB;AACvB;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,WAAW;EACX,YAAY;EACZ,gBAAgB;EAChB,+BAA+B;EAC/B,QAAQ;EACR,qBAAqB;AACvB;;AAEA;yCACyC;;AAEzC;EACE,aAAa;AACf;;AAEA;;GAEG;;AAEH;EACE,WAAW;EACX,UAAU;EACV,YAAY;EACZ,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,YAAY;EACZ,aAAa;EACb,sBAAsB;EACtB,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,WAAW;EACX,UAAU;EACV,YAAY;EACZ,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,YAAY;EACZ,aAAa;EACb,sBAAsB;EACtB,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,YAAY;EACZ,WAAW;EACX,MAAM;EACN,SAAS;EACT,8BAA8B;AAChC;;AAEA;EACE;IACE,cAAc;IACd,eAAe;IACf,YAAY;IACZ,eAAe;EACjB;;EAEA;IACE,cAAc;IACd,eAAe;IACf,YAAY;EACd;AACF;;AAEA;EACE;IACE,cAAc;IACd,eAAe;IACf,YAAY;IACZ,eAAe;EACjB;;EAEA;IACE,cAAc;IACd,eAAe;IACf,YAAY;EACd;AACF;;AAEA;EACE,WAAW;EACX,aAAa;EACb,cAAc;EACd,eAAe;AACjB;;AAEA;EACE,WAAW;EACX,aAAa;EACb,cAAc;EACd,eAAe;AACjB;;AAEA;EACE,sBAAsB;EACtB,wBAAwB;EACxB,yBAAyB;EACzB,qBAAqB;EACrB,iBAAiB;AACnB;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,cAAc;EACd,kBAAkB;EAClB,UAAU;EACV,WAAW;EACX,iBAAiB;EACjB,sBAAsB;EACtB,yBAAyB;EACzB,qBAAqB;EACrB,iBAAiB;AACnB;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,cAAc;EACd,kBAAkB;EAClB,OAAO;EACP,MAAM;EACN,iBAAiB;AACnB;;AAEA;EACE,YAAY;EACZ,aAAa;EACb,gBAAgB;EAChB,mBAAmB;AACrB;;AAEA;EACE,iBAAiB;EACjB,gBAAgB;EAChB,8BAA8B;EAC9B,YAAY;EACZ,eAAe;EACf,YAAY;EACZ,iBAAiB;AACnB;;AAEA;EACE,qBAAqB;EACrB,cAAc;EACd,eAAe;AACjB;;AAEA;;;;;EAKE,eAAe;EACf,eAAe;EACf,kBAAkB;EAClB,yBAAyB;EACzB,gBAAgB;EAChB,iBAAiB;EACjB,gBAAgB;EAChB,gBAAgB;EAChB,eAAe;EACf,8BAA8B;EAC9B,sBAAsB;EACtB,YAAY;AACd;;AAEA;;;;;EAKE,eAAe;EACf,eAAe;EACf,kBAAkB;EAClB,yBAAyB;EACzB,gBAAgB;EAChB,iBAAiB;EACjB,iBAAiB;EACjB,gBAAgB;EAChB,WAAW;EACX,mBAAmB;EACnB,eAAe;EACf,8BAA8B;EAC9B,YAAY;AACd;;AAEA;EACE,YAAY;EACZ,YAAY;EACZ,gBAAgB;EAChB,WAAW;EACX,eAAe;AACjB;;AAEA;EACE,eAAe;EACf,WAAW;AACb;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,mBAAmB;EACnB,sBAAsB;AACxB;;AAEA;EACE,WAAW;EACX,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE;IACE,WAAW;EACb;AACF;;AAEA;EACE,aAAa;EACb,WAAW;AACb;;AAEA;EACE,kBAAkB;EAClB,WAAW;EACX,YAAY;EACZ,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;EACT,oCAAoC;EACpC,UAAU;EACV,eAAe;AACjB;;AAEA;EACE,QAAQ;EACR,SAAS;EACT,gCAAgC;EAChC,kBAAkB;EAClB,iBAAiB;EACjB,gBAAgB;EAChB,UAAU;EACV,kBAAkB;EAClB,aAAa;EACb,uBAAuB;EACvB,eAAe;EACf,gBAAgB;EAChB,cAAc;EACd,UAAU;EACV,eAAe;EACf,cAAc;AAChB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,SAAS;AACX;;AAEA;;;;;EAKE,eAAe;EACf,eAAe;EACf,kBAAkB;EAClB,yBAAyB;EACzB,gBAAgB;EAChB,iBAAiB;EACjB,gBAAgB;EAChB,gBAAgB;EAChB,eAAe;EACf,8BAA8B;EAC9B,sBAAsB;EACtB,sBAAsB;EACtB,YAAY;AACd;;AAEA;;;;;EAKE,eAAe;EACf,eAAe;EACf,kBAAkB;EAClB,yBAAyB;EACzB,gBAAgB;EAChB,iBAAiB;EACjB,iBAAiB;EACjB,gBAAgB;EAChB,WAAW;EACX,mBAAmB;EACnB,eAAe;EACf,8BAA8B;EAC9B,YAAY;AACd;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,mBAAmB;EACnB,4BAA4B;EAC5B,6BAA6B;AAC/B;;AAEA;EACE,cAAc;AAChB;;AAEA,kCAAkC;AAClC;EACE,gBAAgB;AAClB;;AAEA;EACE,gBAAgB;AAClB;;AAEA,sBAAsB;AACtB;EACE,iBAAiB;EACjB,cAAc;AAChB;;AAEA;EACE,eAAe;EACf,gBAAgB;AAClB;;AAEA;EACE,iBAAiB;EACjB,cAAc;AAChB;;AAEA;EACE,eAAe;EACf,gBAAgB;AAClB;;AAEA,mCAAmC;AACnC;EACE,aAAa,EAAE,sBAAsB;EACrC,eAAe,EAAE,kBAAkB;EACnC,UAAU,EAAE,eAAe;EAC3B,kBAAkB,EAAE,wBAAwB;EAC5C,OAAO;EACP,MAAM;EACN,WAAW,EAAE,eAAe;EAC5B,YAAY,EAAE,gBAAgB;EAC9B,cAAc,EAAE,4BAA4B;EAC5C,8BAA8B,EAAE,mBAAmB;EACnD,oCAAoC,EAAE,qBAAqB;EAC3D,YAAY;AACd;;AAEA,kBAAkB;AAClB;EACE,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,kBAAkB;EAClB,YAAY;EACZ,aAAa;EACb,kBAAkB;AACpB;;AAEA,qBAAqB;AACrB;EACE,cAAc;EACd,eAAe;EACf,iBAAiB;EACjB,WAAW;EACX,YAAY;EACZ,SAAS;EACT,WAAW;EACX,oBAAoB;EACpB,kBAAkB;EAClB,gBAAgB;EAChB,kBAAkB;AACpB;;AAEA,kBAAkB;AAClB;EACE,kBAAkB;EAClB,WAAW;EACX,UAAU;EACV,UAAU;EACV,WAAW;EACX,eAAe;EACf,cAAc;EACd,4BAA4B;AAC9B;;AAEA;EACE,kBAAkB;EAClB,UAAU;EACV,YAAY;EACZ,UAAU;EACV,UAAU;AACZ;;AAEA;EACE,oBAAoB;EACpB,kBAAkB;EAClB,gBAAgB;EAChB,eAAe;EACf,iBAAiB;EACjB,cAAc;AAChB;;AAEA;EACE,YAAY;EACZ,oBAAoB;EACpB,kBAAkB;EAClB,eAAe;EACf,iBAAiB;EACjB,iBAAiB;EACjB,cAAc;AAChB;;AAEA;;EAEE,WAAW;EACX,qBAAqB;EACrB,eAAe;AACjB","sourcesContent":[".wrs_modal_overlay {\n  position: fixed;\n  font-family: arial, sans-serif;\n  top: 0;\n  right: 0;\n  left: 0;\n  bottom: 0;\n  background: rgba(0, 0, 0, 0.8);\n  z-index: 999998;\n  opacity: 0.65;\n  pointer-events: auto;\n}\n\n.wrs_modal_overlay.wrs_modal_ios {\n  visibility: hidden;\n  display: none;\n}\n\n.wrs_modal_overlay.wrs_modal_android {\n  visibility: hidden;\n  display: none;\n}\n\n.wrs_modal_overlay.wrs_modal_ios.moodle {\n  position: fixed;\n}\n\n.wrs_modal_overlay.wrs_modal_desktop.wrs_stack {\n  background: rgba(0, 0, 0, 0);\n  display: none;\n}\n\n.wrs_modal_overlay.wrs_modal_desktop.wrs_maximized {\n  background: rgba(0, 0, 0, 0.8);\n}\n\n.wrs_modal_overlay.wrs_modal_desktop.wrs_minimized {\n  background: rgba(0, 0, 0, 0);\n  display: none;\n}\n\n.wrs_modal_overlay.wrs_modal_desktop.wrs_closed {\n  background: rgba(0, 0, 0, 0);\n  display: none;\n}\n\n.wrs_modal_title {\n  color: #fff;\n  padding: 5px 0 5px 10px;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  text-align: left;\n}\n\n.wrs_modal_close_button {\n  float: right;\n  cursor: pointer;\n  color: #fff;\n  padding: 5px 10px 5px 0;\n  margin: 10px 7px 0 0;\n  background-repeat: no-repeat;\n}\n\n.wrs_modal_minimize_button {\n  float: right;\n  cursor: pointer;\n  color: #fff;\n  padding: 5px 10px 5px 0;\n  top: inherit;\n  margin: 10px 7px 0 0;\n}\n\n.wrs_modal_stack_button {\n  float: right;\n  cursor: pointer;\n  color: #fff;\n  margin: 10px 7px 0 0;\n  padding: 5px 10px 5px 0;\n  top: inherit;\n}\n\n.wrs_modal_stack_button.wrs_stack {\n  visibility: hidden;\n  margin: 0;\n  padding: 0;\n}\n\n.wrs_modal_stack_button.wrs_minimized {\n  visibility: hidden;\n  margin: 0;\n  padding: 0;\n}\n\n.wrs_modal_maximize_button {\n  float: right;\n  cursor: pointer;\n  color: #fff;\n  margin: 10px 7px 0 0;\n  padding: 5px 10px 5px 0;\n  top: inherit;\n}\n\n.wrs_modal_maximize_button.wrs_maximized {\n  visibility: hidden;\n  margin: 0;\n  padding: 0;\n}\n\n.wrs_modal_title_bar {\n  display: block;\n  background-color: #778e9a;\n}\n\n.wrs_modal_dialogContainer {\n  border: none;\n  background: #fafafa;\n  z-index: 999999;\n}\n\n.wrs_modal_dialogContainer.wrs_modal_desktop {\n  font-size: 14px;\n}\n\n.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_maximized {\n  position: fixed;\n}\n\n.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_minimized {\n  position: fixed;\n  top: inherit;\n  margin: 0;\n  margin-right: 10px;\n}\n\n.wrs_modal_dialogContainer.wrs_closed {\n  visibility: hidden;\n  display: none;\n  opacity: 0;\n}\n\n/* Class that exists but hasn't got css properties defined\n.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_minimized.wrs_drag {} */\n\n.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_stack {\n  position: fixed;\n  bottom: 0;\n  right: 0;\n  box-shadow: rgba(0, 0, 0, 0.5) 0 2px 8px;\n}\n\n.wrs_modal_dialogContainer.wrs_drag {\n  box-shadow: rgba(0, 0, 0, 0.5) 0 2px 8px;\n}\n\n.wrs_modal_dialogContainer.wrs_modal_desktop.wrs_drag {\n  box-shadow: rgba(0, 0, 0, 0.5) 0 2px 8px;\n}\n\n.wrs_modal_dialogContainer.wrs_modal_android {\n  margin: auto;\n  position: fixed;\n  width: 99%;\n  height: 99%;\n  overflow: hidden;\n  transform: translate(50%, -50%);\n  top: 50%;\n  right: 50% !important;\n}\n\n.wrs_modal_dialogContainer.wrs_modal_ios {\n  margin: auto;\n  position: fixed;\n  width: 100%;\n  height: 100%;\n  overflow: hidden;\n  transform: translate(50%, -50%);\n  top: 50%;\n  right: 50% !important;\n}\n\n/* Class that exists but hasn't got css properties defined\n.wrs_content_container.wrs_maximized {} */\n\n.wrs_content_container.wrs_minimized {\n  display: none;\n}\n\n/* .wrs_editor {\n    flex-grow: 1;\n} */\n\n.wrs_content_container.wrs_modal_android {\n  width: 100%;\n  height: 0%;\n  flex-grow: 1;\n  display: flex;\n  flex-direction: column;\n}\n\n.wrs_content_container.wrs_modal_android > div:first-child {\n  flex-grow: 1;\n}\n\n.wrs_content_container.wrs_modal_ios > div:first-child {\n  flex-grow: 1;\n}\n\n.wrs_content_container.wrs_modal_desktop > div:first-child {\n  flex-grow: 1;\n}\n\n.wrs_modal_wrapper.wrs_modal_android {\n  margin: auto;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  width: 100%;\n}\n\n.wrs_content_container.wrs_modal_desktop {\n  width: 100%;\n  flex-grow: 1;\n  display: flex;\n  flex-direction: column;\n}\n\n.wrs_content_container.wrs_modal_ios {\n  width: 100%;\n  height: 0%;\n  flex-grow: 1;\n  display: flex;\n  flex-direction: column;\n}\n\n.wrs_modal_wrapper.wrs_modal_ios {\n  margin: auto;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  width: 100%;\n}\n\n.wrs_virtual_keyboard {\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 50%;\n  transform: translate(-50%, 0%);\n}\n\n@media all and (orientation: portrait) {\n  .wrs_modal_dialogContainer.wrs_modal_mobile {\n    width: 100vmin;\n    height: 100vmin;\n    margin: auto;\n    border-width: 0;\n  }\n\n  .wrs_modal_wrapper.wrs_modal_mobile {\n    width: 100vmin;\n    height: 100vmin;\n    margin: auto;\n  }\n}\n\n@media all and (orientation: landscape) {\n  .wrs_modal_dialogContainer.wrs_modal_mobile {\n    width: 100vmin;\n    height: 100vmin;\n    margin: auto;\n    border-width: 0;\n  }\n\n  .wrs_modal_wrapper.wrs_modal_mobile {\n    width: 100vmin;\n    height: 100vmin;\n    margin: auto;\n  }\n}\n\n.wrs_modal_dialogContainer.wrs_modal_badStock {\n  width: 100%;\n  height: 280px;\n  margin: 0 auto;\n  border-width: 0;\n}\n\n.wrs_modal_wrapper.wrs_modal_badStock {\n  width: 100%;\n  height: 280px;\n  margin: 0 auto;\n  border-width: 0;\n}\n\n.wrs_noselect {\n  -moz-user-select: none;\n  -khtml-user-select: none;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n\n.wrs_bottom_right_resizer {\n  width: 10px;\n  height: 10px;\n  color: #778e9a;\n  position: absolute;\n  right: 4px;\n  bottom: 8px;\n  cursor: se-resize;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n\n.wrs_bottom_left_resizer {\n  width: 15px;\n  height: 15px;\n  color: #778e9a;\n  position: absolute;\n  left: 0;\n  top: 0;\n  cursor: se-resize;\n}\n\n.wrs_modal_controls {\n  height: 42px;\n  margin: 3px 0;\n  overflow: hidden;\n  line-height: normal;\n}\n\n.wrs_modal_links {\n  margin: 10px auto;\n  margin-bottom: 0;\n  font-family: arial, sans-serif;\n  padding: 6px;\n  display: inline;\n  float: right;\n  text-align: right;\n}\n\n.wrs_modal_links > a {\n  text-decoration: none;\n  color: #778e9a;\n  font-size: 16px;\n}\n\n.wrs_modal_button_cancel,\n.wrs_modal_button_cancel:hover,\n.wrs_modal_button_cancel:visited,\n.wrs_modal_button_cancel:active,\n.wrs_modal_button_cancel:focus {\n  min-width: 80px;\n  font-size: 14px;\n  border-radius: 3px;\n  border: 1px solid #778e9a;\n  padding: 6px 8px;\n  margin: 10px auto;\n  margin-left: 5px;\n  margin-bottom: 0;\n  cursor: pointer;\n  font-family: arial, sans-serif;\n  background-color: #ddd;\n  height: 32px;\n}\n\n.wrs_modal_button_accept,\n.wrs_modal_button_accept:hover,\n.wrs_modal_button_accept:visited,\n.wrs_modal_button_accept:active,\n.wrs_modal_button_accept:focus {\n  min-width: 80px;\n  font-size: 14px;\n  border-radius: 3px;\n  border: 1px solid #778e9a;\n  padding: 6px 8px;\n  margin: 10px auto;\n  margin-right: 5px;\n  margin-bottom: 0;\n  color: #fff;\n  background: #778e9a;\n  cursor: pointer;\n  font-family: arial, sans-serif;\n  height: 32px;\n}\n\n.wrs_editor_vertical_bar {\n  height: 20px;\n  float: right;\n  background: none;\n  width: 20px;\n  cursor: pointer;\n}\n\n.wrs_modal_buttons_container {\n  display: inline;\n  float: left;\n}\n\n.wrs_modal_buttons_container.wrs_modalAndroid {\n  padding-left: 6px;\n}\n\n.wrs_modal_buttons_container.wrs_modalDesktop {\n  padding-left: 0;\n}\n\n.wrs_modal_buttons_container > button {\n  line-height: normal;\n  background-image: none;\n}\n\n.wrs_modal_wrapper {\n  margin: 6px;\n  display: flex;\n  flex-direction: column;\n}\n\n.wrs_modal_wrapper.wrs_modal_desktop.wrs_minimized {\n  display: none;\n}\n\n@media only screen and (max-device-width: 480px) and (orientation: portrait) {\n  #wrs_modal_wrapper {\n    width: 140%;\n  }\n}\n\n.wrs_popupmessage_overlay_envolture {\n  display: none;\n  width: 100%;\n}\n\n.wrs_popupmessage_overlay {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(0, 0, 0, 0.5);\n  z-index: 4;\n  cursor: pointer;\n}\n\n.wrs_popupmessage_panel {\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  position: absolute;\n  background: white;\n  max-width: 500px;\n  width: 75%;\n  border-radius: 2px;\n  padding: 20px;\n  font-family: sans-serif;\n  font-size: 15px;\n  text-align: left;\n  color: #2e2e2e;\n  z-index: 5;\n  max-height: 75%;\n  overflow: auto;\n}\n\n.wrs_popupmessage_button_area {\n  margin: 10px 0 0 0;\n}\n\n.wrs_panelContainer * {\n  border: 0;\n}\n\n.wrs_button_cancel,\n.wrs_button_cancel:hover,\n.wrs_button_cancel:visited,\n.wrs_button_cancel:active,\n.wrs_button_cancel:focus {\n  min-width: 80px;\n  font-size: 14px;\n  border-radius: 3px;\n  border: 1px solid #778e9a;\n  padding: 6px 8px;\n  margin: 10px auto;\n  margin-left: 5px;\n  margin-bottom: 0;\n  cursor: pointer;\n  font-family: arial, sans-serif;\n  background-color: #ddd;\n  background-image: none;\n  height: 32px;\n}\n\n.wrs_button_accept,\n.wrs_button_accept:hover,\n.wrs_button_accept:visited,\n.wrs_button_accept:active,\n.wrs_button_accept:focus {\n  min-width: 80px;\n  font-size: 14px;\n  border-radius: 3px;\n  border: 1px solid #778e9a;\n  padding: 6px 8px;\n  margin: 10px auto;\n  margin-right: 5px;\n  margin-bottom: 0;\n  color: #fff;\n  background: #778e9a;\n  cursor: pointer;\n  font-family: arial, sans-serif;\n  height: 32px;\n}\n\n.wrs_editor button {\n  box-shadow: none;\n}\n\n.wrs_editor .wrs_header button {\n  border-bottom: none;\n  border-bottom-left-radius: 0;\n  border-bottom-right-radius: 0;\n}\n\n.wrs_modal_overlay.wrs_modal_desktop.wrs_stack.wrs_overlay_active {\n  display: block;\n}\n\n/* Fix selection in drupal style */\n.wrs_toolbar tr:focus {\n  background: none;\n}\n\n.wrs_toolbar tr:hover {\n  background: none;\n}\n\n/* End of fix drupal */\n.wrs_modal_rtl .wrs_modal_button_cancel {\n  margin-right: 5px;\n  margin-left: 0;\n}\n\n.wrs_modal_rtl .wrs_modal_button_accept {\n  margin-right: 0;\n  margin-left: 5px;\n}\n\n.wrs_modal_rtl .wrs_button_cancel {\n  margin-right: 5px;\n  margin-left: 0;\n}\n\n.wrs_modal_rtl .wrs_button_accept {\n  margin-right: 0;\n  margin-left: 5px;\n}\n\n/* The Offline Modal (background) */\n.wrs_modal_offline {\n  display: none; /* Hidden by default */\n  position: fixed; /* Stay in place */\n  z-index: 2; /* Sit on top */\n  padding-top: 150px; /* Location of the box */\n  left: 0;\n  top: 0;\n  width: 100%; /* Full width */\n  height: 100%; /* Full height */\n  overflow: auto; /* Enable scroll if needed */\n  background-color: rgb(0, 0, 0); /* Fallback color */\n  background-color: rgba(0, 0, 0, 0.4); /* Black w/ opacity */\n  margin: auto;\n}\n\n/* Modal Content */\n.wrs_modal_content_offline {\n  margin: auto;\n  padding: 16px;\n  background: #fff7ed;\n  border-radius: 6px;\n  width: 517px;\n  height: 100px;\n  position: relative;\n}\n\n/* The Close Button */\n.wrs_modal_offline_close {\n  color: #c2410c;\n  font-size: 24px;\n  font-weight: bold;\n  left: 95.7%;\n  right: 2.08%;\n  top: 7.6%;\n  bottom: 75%;\n  font-family: \"Inter\";\n  font-style: normal;\n  font-weight: 400;\n  position: absolute;\n}\n\n/* The Warn Icon */\n.wrs_modal_offline_warn {\n  position: absolute;\n  left: 2.08%;\n  right: 94%;\n  top: 11.6%;\n  bottom: 75%;\n  font-size: 24px;\n  color: #fb923c;\n  background-repeat: no-repeat;\n}\n\n.wrs_modal_offline_text_container {\n  position: absolute;\n  left: 6.8%;\n  right: 6.08%;\n  top: 10.4%;\n  bottom: 2%;\n}\n\n.wrs_modal_offline_text {\n  font-family: \"Inter\";\n  font-style: normal;\n  font-weight: 400;\n  font-size: 14px;\n  line-height: 20px;\n  color: #c2410c;\n}\n\n.wrs_modal_offline_text_warn {\n  height: 25px;\n  font-family: \"Inter\";\n  font-style: normal;\n  font-size: 14px;\n  line-height: 20px;\n  font-weight: bold;\n  color: #c2410c;\n}\n\n.wrs_modal_offline_close:hover,\n.wrs_modal_offline_close:focus {\n  color: #000;\n  text-decoration: none;\n  cursor: pointer;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/ckeditor5/dist/ckeditor5.css":
/*!*****************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/ckeditor5/dist/ckeditor5.css ***!
  \*****************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../css-loader/dist/runtime/getUrl.js */ "./node_modules/css-loader/dist/runtime/getUrl.js");
/* harmony import */ var _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__);
// Imports



var ___CSS_LOADER_URL_IMPORT_0___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;base64,PHN2ZyB2aWV3Qm94PSIwIDAgMjAgMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZmlsbD0iI2ZmZiIgZD0ibTExLjA3NyAxNSAuOTkxLTEuNDE2YS43NS43NSAwIDEgMSAxLjIyOS44NmwtMS4xNDggMS42NGEuNzQ4Ljc0OCAwIDAgMS0uMjE3LjIwNiA1LjI1MSA1LjI1MSAwIDAgMS04LjUwMy01Ljk1NS43NDEuNzQxIDAgMCAxIC4xMi0uMjc0bDEuMTQ3LTEuNjM5YS43NS43NSAwIDEgMSAxLjIyOC44Nkw0LjkzMyAxMC43bC4wMDYuMDAzYTMuNzUgMy43NSAwIDAgMCA2LjEzMiA0LjI5NGwuMDA2LjAwNHptNS40OTQtNS4zMzVhLjc0OC43NDggMCAwIDEtLjEyLjI3NGwtMS4xNDcgMS42MzlhLjc1Ljc1IDAgMSAxLTEuMjI4LS44NmwuODYtMS4yM2EzLjc1IDMuNzUgMCAwIDAtNi4xNDQtNC4zMDFsLS44NiAxLjIyOWEuNzUuNzUgMCAwIDEtMS4yMjktLjg2bDEuMTQ4LTEuNjRhLjc0OC43NDggMCAwIDEgLjIxNy0uMjA2IDUuMjUxIDUuMjUxIDAgMCAxIDguNTAzIDUuOTU1em0tNC41NjMtMi41MzJhLjc1Ljc1IDAgMCAxIC4xODQgMS4wNDVsLTMuMTU1IDQuNTA1YS43NS43NSAwIDEgMS0xLjIyOS0uODZsMy4xNTUtNC41MDZhLjc1Ljc1IDAgMCAxIDEuMDQ1LS4xODR6Ii8+PC9zdmc+ */ "data:image/svg+xml;base64,PHN2ZyB2aWV3Qm94PSIwIDAgMjAgMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZmlsbD0iI2ZmZiIgZD0ibTExLjA3NyAxNSAuOTkxLTEuNDE2YS43NS43NSAwIDEgMSAxLjIyOS44NmwtMS4xNDggMS42NGEuNzQ4Ljc0OCAwIDAgMS0uMjE3LjIwNiA1LjI1MSA1LjI1MSAwIDAgMS04LjUwMy01Ljk1NS43NDEuNzQxIDAgMCAxIC4xMi0uMjc0bDEuMTQ3LTEuNjM5YS43NS43NSAwIDEgMSAxLjIyOC44Nkw0LjkzMyAxMC43bC4wMDYuMDAzYTMuNzUgMy43NSAwIDAgMCA2LjEzMiA0LjI5NGwuMDA2LjAwNHptNS40OTQtNS4zMzVhLjc0OC43NDggMCAwIDEtLjEyLjI3NGwtMS4xNDcgMS42MzlhLjc1Ljc1IDAgMSAxLTEuMjI4LS44NmwuODYtMS4yM2EzLjc1IDMuNzUgMCAwIDAtNi4xNDQtNC4zMDFsLS44NiAxLjIyOWEuNzUuNzUgMCAwIDEtMS4yMjktLjg2bDEuMTQ4LTEuNjRhLjc0OC43NDggMCAwIDEgLjIxNy0uMjA2IDUuMjUxIDUuMjUxIDAgMCAxIDguNTAzIDUuOTU1em0tNC41NjMtMi41MzJhLjc1Ljc1IDAgMCAxIC4xODQgMS4wNDVsLTMuMTU1IDQuNTA1YS43NS43NSAwIDEgMS0xLjIyOS0uODZsMy4xNTUtNC41MDZhLjc1Ljc1IDAgMCAxIDEuMDQ1LS4xODR6Ii8+PC9zdmc+"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_1___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;base64,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 */ "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNTAuMzc4IiBoZWlnaHQ9IjI1NC4xNjciIHZpZXdCb3g9IjAgMCA2Ni4yNDYgNjcuMjQ4Ij48ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtMTcyLjUzMSAtMjE4LjQ1NSkgc2NhbGUoLjk4MDEyKSI+PHJlY3Qgcnk9IjUuMjM4IiByeD0iNS4yMzgiIHk9IjIzMS4zOTkiIHg9IjE3Ni4wMzEiIGhlaWdodD0iNjAuMDk5IiB3aWR0aD0iNjAuMDk5IiBmaWxsPSIjMzRhNjY4IiBwYWludC1vcmRlcj0ibWFya2VycyBzdHJva2UgZmlsbCIvPjxwYXRoIGQ9Ik0yMDYuNDc3IDI2MC45bC0yOC45ODcgMjguOTg3YTUuMjE4IDUuMjE4IDAgMCAwIDMuNzggMS42MWg0OS42MjFjMS42OTQgMCAzLjE5LS43OTggNC4xNDYtMi4wMzd6IiBmaWxsPSIjNWM4OGM1Ii8+PHBhdGggZD0iTTIyNi43NDIgMjIyLjk4OGMtOS4yNjYgMC0xNi43NzcgNy4xNy0xNi43NzcgMTYuMDE0LjAwNyAyLjc2Mi42NjMgNS40NzQgMi4wOTMgNy44NzUuNDMuNzAzLjgzIDEuNDA4IDEuMTkgMi4xMDcuMzMzLjUwMi42NSAxLjAwNS45NSAxLjUwOC4zNDMuNDc3LjY3My45NTcuOTg4IDEuNDQgMS4zMSAxLjc2OSAyLjUgMy41MDIgMy42MzcgNS4xNjguNzkzIDEuMjc1IDEuNjgzIDIuNjQgMi40NjYgMy45OSAyLjM2MyA0LjA5NCA0LjAwNyA4LjA5MiA0LjYgMTMuOTE0di4wMTJjLjE4Mi40MTIuNTE2LjY2Ni44NzkuNjY3LjQwMy0uMDAxLjc2OC0uMzE0LjkzLS43OTkuNjAzLTUuNzU2IDIuMjM4LTkuNzI5IDQuNTg1LTEzLjc5NC43ODItMS4zNSAxLjY3My0yLjcxNSAyLjQ2NS0zLjk5IDEuMTM3LTEuNjY2IDIuMzI4LTMuNCAzLjYzOC01LjE2OS4zMTUtLjQ4Mi42NDUtLjk2Mi45ODgtMS40MzkuMy0uNTAzLjYxNy0xLjAwNi45NS0xLjUwOC4zNTktLjcuNzYtMS40MDQgMS4xOS0yLjEwNyAxLjQyNi0yLjQwMiAyLTUuMTE0IDIuMDA0LTcuODc1IDAtOC44NDQtNy41MTEtMTYuMDE0LTE2Ljc3Ni0xNi4wMTR6IiBmaWxsPSIjZGQ0YjNlIiBwYWludC1vcmRlcj0ibWFya2VycyBzdHJva2UgZmlsbCIvPjxlbGxpcHNlIHJ5PSI1LjU2NCIgcng9IjUuODI4IiBjeT0iMjM5LjAwMiIgY3g9IjIyNi43NDIiIGZpbGw9IiM4MDJkMjciIHBhaW50LW9yZGVyPSJtYXJrZXJzIHN0cm9rZSBmaWxsIi8+PHBhdGggZD0iTTE5MC4zMDEgMjM3LjI4M2MtNC42NyAwLTguNDU3IDMuODUzLTguNDU3IDguNjA2czMuNzg2IDguNjA3IDguNDU3IDguNjA3YzMuMDQzIDAgNC44MDYtLjk1OCA2LjMzNy0yLjUxNiAxLjUzLTEuNTU3IDIuMDg3LTMuOTEzIDIuMDg3LTYuMjkgMC0uMzYyLS4wMjMtLjcyMi0uMDY0LTEuMDc5aC04LjI1N3YzLjA0M2g0Ljg1Yy0uMTk3Ljc1OS0uNTMxIDEuNDUtMS4wNTggMS45ODYtLjk0Mi45NTgtMi4wMjggMS41NDgtMy45MDEgMS41NDgtMi44NzYgMC01LjIwOC0yLjM3Mi01LjIwOC01LjI5OSAwLTIuOTI2IDIuMzMyLTUuMjk5IDUuMjA4LTUuMjk5IDEuMzk5IDAgMi42MTguNDA3IDMuNTg0IDEuMjkzbDIuMzgxLTIuMzhjMC0uMDAyLS4wMDMtLjAwNC0uMDA0LS4wMDUtMS41ODgtMS41MjQtMy42Mi0yLjIxNS01Ljk1NS0yLjIxNXptNC40MyA1LjY2bC4wMDMuMDA2di0uMDAzeiIgZmlsbD0iI2ZmZiIgcGFpbnQtb3JkZXI9Im1hcmtlcnMgc3Ryb2tlIGZpbGwiLz48cGF0aCBkPSJNMjE1LjE4NCAyNTEuOTI5bC03Ljk4IDcuOTc5IDI4LjQ3NyAyOC40NzVjLjI4Ny0uNjQ5LjQ0OS0xLjM2Ni40NDktMi4xMjN2LTMxLjE2NWMtLjQ2OS42NzUtLjkzNCAxLjM0OS0xLjM4MiAyLjAwNS0uNzkyIDEuMjc1LTEuNjgyIDIuNjQtMi40NjUgMy45OS0yLjM0NyA0LjA2NS0zLjk4MiA4LjAzOC00LjU4NSAxMy43OTQtLjE2Mi40ODUtLjUyNy43OTgtLjkzLjc5OS0uMzYzLS4wMDEtLjY5Ny0uMjU1LS44NzktLjY2N3YtLjAxMmMtLjU5My01LjgyMi0yLjIzNy05LjgyLTQuNi0xMy45MTQtLjc4My0xLjM1LTEuNjczLTIuNzE1LTIuNDY2LTMuOTktMS4xMzctMS42NjYtMi4zMjctMy40LTMuNjM3LTUuMTY5bC0uMDAyLS4wMDN6IiBmaWxsPSIjYzNjM2MzIi8+PHBhdGggZD0iTTIxMi45ODMgMjQ4LjQ5NWwtMzYuOTUyIDM2Ljk1M3YuODEyYTUuMjI3IDUuMjI3IDAgMCAwIDUuMjM4IDUuMjM4aDEuMDE1bDM1LjY2Ni0zNS42NjZhMTM2LjI3NSAxMzYuMjc1IDAgMCAwLTIuNzY0LTMuOSAzNy41NzUgMzcuNTc1IDAgMCAwLS45ODktMS40NGMtLjI5OS0uNTAzLS42MTYtMS4wMDYtLjk1LTEuNTA4LS4wODMtLjE2Mi0uMTc2LS4zMjYtLjI2NC0uNDg5eiIgZmlsbD0iI2ZkZGM0ZiIgcGFpbnQtb3JkZXI9Im1hcmtlcnMgc3Ryb2tlIGZpbGwiLz48cGF0aCBkPSJNMjExLjk5OCAyNjEuMDgzbC02LjE1MiA2LjE1MSAyNC4yNjQgMjQuMjY0aC43ODFhNS4yMjcgNS4yMjcgMCAwIDAgNS4yMzktNS4yMzh2LTEuMDQ1eiIgZmlsbD0iI2ZmZiIgcGFpbnQtb3JkZXI9Im1hcmtlcnMgc3Ryb2tlIGZpbGwiLz48L2c+PC9zdmc+"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_2___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48c3ZnIHdpZHRoPSIxMDI0cHgiIGhlaWdodD0iMTAyNHB4IiB2aWV3Qm94PSIwIDAgMTAyNCAxMDI0IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPiAgICAgICAgPHRpdGxlPkZpbGwgMTwvdGl0bGU+ICAgIDxkZXNjPkNyZWF0ZWQgd2l0aCBTa2V0Y2guPC9kZXNjPiAgICA8ZGVmcz48L2RlZnM+ICAgIDxnIGlkPSJQYWdlLTEiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPiAgICAgICAgPGcgaWQ9ImZMb2dvX1doaXRlIiBmaWxsPSIjRkZGRkZFIj4gICAgICAgICAgICA8cGF0aCBkPSJNOTY3LjQ4NCwwIEw1Ni41MTcsMCBDMjUuMzA0LDAgMCwyNS4zMDQgMCw1Ni41MTcgTDAsOTY3LjQ4MyBDMCw5OTguNjk0IDI1LjI5NywxMDI0IDU2LjUyMiwxMDI0IEw1NDcsMTAyNCBMNTQ3LDYyOCBMNDE0LDYyOCBMNDE0LDQ3MyBMNTQ3LDQ3MyBMNTQ3LDM1OS4wMjkgQzU0NywyMjYuNzY3IDYyNy43NzMsMTU0Ljc0NyA3NDUuNzU2LDE1NC43NDcgQzgwMi4yNjksMTU0Ljc0NyA4NTAuODQyLDE1OC45NTUgODY1LDE2MC44MzYgTDg2NSwyOTkgTDc4My4zODQsMjk5LjAzNyBDNzE5LjM5MSwyOTkuMDM3IDcwNywzMjkuNTI5IDcwNywzNzQuMjczIEw3MDcsNDczIEw4NjAuNDg3LDQ3MyBMODQwLjUwMSw2MjggTDcwNyw2MjggTDcwNywxMDI0IEw5NjcuNDg0LDEwMjQgQzk5OC42OTcsMTAyNCAxMDI0LDk5OC42OTcgMTAyNCw5NjcuNDg0IEwxMDI0LDU2LjUxNSBDMTAyNCwyNS4zMDMgOTk4LjY5NywwIDk2Ny40ODQsMCIgaWQ9IkZpbGwtMSI+PC9wYXRoPiAgICAgICAgPC9nPiAgICA8L2c+PC9zdmc+ */ "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48c3ZnIHdpZHRoPSIxMDI0cHgiIGhlaWdodD0iMTAyNHB4IiB2aWV3Qm94PSIwIDAgMTAyNCAxMDI0IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPiAgICAgICAgPHRpdGxlPkZpbGwgMTwvdGl0bGU+ICAgIDxkZXNjPkNyZWF0ZWQgd2l0aCBTa2V0Y2guPC9kZXNjPiAgICA8ZGVmcz48L2RlZnM+ICAgIDxnIGlkPSJQYWdlLTEiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPiAgICAgICAgPGcgaWQ9ImZMb2dvX1doaXRlIiBmaWxsPSIjRkZGRkZFIj4gICAgICAgICAgICA8cGF0aCBkPSJNOTY3LjQ4NCwwIEw1Ni41MTcsMCBDMjUuMzA0LDAgMCwyNS4zMDQgMCw1Ni41MTcgTDAsOTY3LjQ4MyBDMCw5OTguNjk0IDI1LjI5NywxMDI0IDU2LjUyMiwxMDI0IEw1NDcsMTAyNCBMNTQ3LDYyOCBMNDE0LDYyOCBMNDE0LDQ3MyBMNTQ3LDQ3MyBMNTQ3LDM1OS4wMjkgQzU0NywyMjYuNzY3IDYyNy43NzMsMTU0Ljc0NyA3NDUuNzU2LDE1NC43NDcgQzgwMi4yNjksMTU0Ljc0NyA4NTAuODQyLDE1OC45NTUgODY1LDE2MC44MzYgTDg2NSwyOTkgTDc4My4zODQsMjk5LjAzNyBDNzE5LjM5MSwyOTkuMDM3IDcwNywzMjkuNTI5IDcwNywzNzQuMjczIEw3MDcsNDczIEw4NjAuNDg3LDQ3MyBMODQwLjUwMSw2MjggTDcwNyw2MjggTDcwNywxMDI0IEw5NjcuNDg0LDEwMjQgQzk5OC42OTcsMTAyNCAxMDI0LDk5OC42OTcgMTAyNCw5NjcuNDg0IEwxMDI0LDU2LjUxNSBDMTAyNCwyNS4zMDMgOTk4LjY5NywwIDk2Ny40ODQsMCIgaWQ9IkZpbGwtMSI+PC9wYXRoPiAgICAgICAgPC9nPiAgICA8L2c+PC9zdmc+"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_3___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;base64,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 */ "data:image/svg+xml;base64,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"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_4___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz48c3ZnIHZlcnNpb249IjEuMSIgaWQ9IldoaXRlIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCIgdmlld0JveD0iMCAwIDQwMCA0MDAiIHN0eWxlPSJlbmFibGUtYmFja2dyb3VuZDpuZXcgMCAwIDQwMCA0MDA7IiB4bWw6c3BhY2U9InByZXNlcnZlIj48c3R5bGUgdHlwZT0idGV4dC9jc3MiPi5zdDB7ZmlsbDojRkZGRkZGO308L3N0eWxlPjxwYXRoIGNsYXNzPSJzdDAiIGQ9Ik00MDAsMjAwYzAsMTEwLjUtODkuNSwyMDAtMjAwLDIwMFMwLDMxMC41LDAsMjAwUzg5LjUsMCwyMDAsMFM0MDAsODkuNSw0MDAsMjAweiBNMTYzLjQsMzA1LjVjODguNywwLDEzNy4yLTczLjUsMTM3LjItMTM3LjJjMC0yLjEsMC00LjItMC4xLTYuMmM5LjQtNi44LDE3LjYtMTUuMywyNC4xLTI1Yy04LjYsMy44LTE3LjksNi40LTI3LjcsNy42YzEwLTYsMTcuNi0xNS40LDIxLjItMjYuN2MtOS4zLDUuNS0xOS42LDkuNS0zMC42LDExLjdjLTguOC05LjQtMjEuMy0xNS4yLTM1LjItMTUuMmMtMjYuNiwwLTQ4LjIsMjEuNi00OC4yLDQ4LjJjMCwzLjgsMC40LDcuNSwxLjMsMTFjLTQwLjEtMi03NS42LTIxLjItOTkuNC01MC40Yy00LjEsNy4xLTYuNSwxNS40LTYuNSwyNC4yYzAsMTYuNyw4LjUsMzEuNSwyMS41LDQwLjFjLTcuOS0wLjItMTUuMy0yLjQtMjEuOC02YzAsMC4yLDAsMC40LDAsMC42YzAsMjMuNCwxNi42LDQyLjgsMzguNyw0Ny4zYy00LDEuMS04LjMsMS43LTEyLjcsMS43Yy0zLjEsMC02LjEtMC4zLTkuMS0wLjljNi4xLDE5LjIsMjMuOSwzMy4xLDQ1LDMzLjVjLTE2LjUsMTIuOS0zNy4zLDIwLjYtNTkuOSwyMC42Yy0zLjksMC03LjctMC4yLTExLjUtMC43QzExMC44LDI5Ny41LDEzNi4yLDMwNS41LDE2My40LDMwNS41Ii8+PC9zdmc+ */ "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz48c3ZnIHZlcnNpb249IjEuMSIgaWQ9IldoaXRlIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCIgdmlld0JveD0iMCAwIDQwMCA0MDAiIHN0eWxlPSJlbmFibGUtYmFja2dyb3VuZDpuZXcgMCAwIDQwMCA0MDA7IiB4bWw6c3BhY2U9InByZXNlcnZlIj48c3R5bGUgdHlwZT0idGV4dC9jc3MiPi5zdDB7ZmlsbDojRkZGRkZGO308L3N0eWxlPjxwYXRoIGNsYXNzPSJzdDAiIGQ9Ik00MDAsMjAwYzAsMTEwLjUtODkuNSwyMDAtMjAwLDIwMFMwLDMxMC41LDAsMjAwUzg5LjUsMCwyMDAsMFM0MDAsODkuNSw0MDAsMjAweiBNMTYzLjQsMzA1LjVjODguNywwLDEzNy4yLTczLjUsMTM3LjItMTM3LjJjMC0yLjEsMC00LjItMC4xLTYuMmM5LjQtNi44LDE3LjYtMTUuMywyNC4xLTI1Yy04LjYsMy44LTE3LjksNi40LTI3LjcsNy42YzEwLTYsMTcuNi0xNS40LDIxLjItMjYuN2MtOS4zLDUuNS0xOS42LDkuNS0zMC42LDExLjdjLTguOC05LjQtMjEuMy0xNS4yLTM1LjItMTUuMmMtMjYuNiwwLTQ4LjIsMjEuNi00OC4yLDQ4LjJjMCwzLjgsMC40LDcuNSwxLjMsMTFjLTQwLjEtMi03NS42LTIxLjItOTkuNC01MC40Yy00LjEsNy4xLTYuNSwxNS40LTYuNSwyNC4yYzAsMTYuNyw4LjUsMzEuNSwyMS41LDQwLjFjLTcuOS0wLjItMTUuMy0yLjQtMjEuOC02YzAsMC4yLDAsMC40LDAsMC42YzAsMjMuNCwxNi42LDQyLjgsMzguNyw0Ny4zYy00LDEuMS04LjMsMS43LTEyLjcsMS43Yy0zLjEsMC02LjEtMC4zLTkuMS0wLjljNi4xLDE5LjIsMjMuOSwzMy4xLDQ1LDMzLjVjLTE2LjUsMTIuOS0zNy4zLDIwLjYtNTkuOSwyMC42Yy0zLjksMC03LjctMC4yLTExLjUtMC43QzExMC44LDI5Ny41LDEzNi4yLDMwNS41LDE2My40LDMwNS41Ii8+PC9zdmc+"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_5___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>ADDRESS</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>ADDRESS</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_6___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>ASIDE</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>ASIDE</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_7___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>BLOCKQUOTE</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>BLOCKQUOTE</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_8___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>DETAILS</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>DETAILS</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_9___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>DIV</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>DIV</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_10___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>FOOTER</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>FOOTER</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_11___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H1</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H1</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_12___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H2</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H2</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_13___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H3</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H3</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_14___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H4</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H4</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_15___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H5</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H5</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_16___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H6</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>H6</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_17___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>HEADER</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>HEADER</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_18___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>MAIN</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>MAIN</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_19___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>NAV</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>NAV</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_20___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>PRE</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>PRE</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_21___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>OL</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>OL</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_22___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>UL</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>UL</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_23___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>P</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>P</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_24___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>SECTION</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>SECTION</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_25___ = new URL(/* asset import */ __webpack_require__(/*! data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>FIGCAPTION</text></svg> */ "data:image/svg+xml;utf8,<svg width=%27120%27 height=%2712%27 xmlns=%27http://www.w3.org/2000/svg%27 ><text style=%27paint-order:stroke fill; clip-path: inset%28-3px%29%27 stroke=%27%23EAEAEA%27 stroke-width=%2713%27 dominant-baseline=%27middle%27 fill=%27black%27 x=%273%27 y=%277%27 font-size=%279px%27 font-family=%27Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace%27>FIGCAPTION</text></svg>"), __webpack_require__.b);
var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_0___);
var ___CSS_LOADER_URL_REPLACEMENT_1___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_1___);
var ___CSS_LOADER_URL_REPLACEMENT_2___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_2___);
var ___CSS_LOADER_URL_REPLACEMENT_3___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_3___);
var ___CSS_LOADER_URL_REPLACEMENT_4___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_4___);
var ___CSS_LOADER_URL_REPLACEMENT_5___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_5___);
var ___CSS_LOADER_URL_REPLACEMENT_6___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_6___);
var ___CSS_LOADER_URL_REPLACEMENT_7___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_7___);
var ___CSS_LOADER_URL_REPLACEMENT_8___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_8___);
var ___CSS_LOADER_URL_REPLACEMENT_9___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_9___);
var ___CSS_LOADER_URL_REPLACEMENT_10___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_10___);
var ___CSS_LOADER_URL_REPLACEMENT_11___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_11___);
var ___CSS_LOADER_URL_REPLACEMENT_12___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_12___);
var ___CSS_LOADER_URL_REPLACEMENT_13___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_13___);
var ___CSS_LOADER_URL_REPLACEMENT_14___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_14___);
var ___CSS_LOADER_URL_REPLACEMENT_15___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_15___);
var ___CSS_LOADER_URL_REPLACEMENT_16___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_16___);
var ___CSS_LOADER_URL_REPLACEMENT_17___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_17___);
var ___CSS_LOADER_URL_REPLACEMENT_18___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_18___);
var ___CSS_LOADER_URL_REPLACEMENT_19___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_19___);
var ___CSS_LOADER_URL_REPLACEMENT_20___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_20___);
var ___CSS_LOADER_URL_REPLACEMENT_21___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_21___);
var ___CSS_LOADER_URL_REPLACEMENT_22___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_22___);
var ___CSS_LOADER_URL_REPLACEMENT_23___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_23___);
var ___CSS_LOADER_URL_REPLACEMENT_24___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_24___);
var ___CSS_LOADER_URL_REPLACEMENT_25___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_25___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* Reset */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-base-foreground: 								hsl(0, 0%, 98%);
	--ck-color-base-background: 								hsl(0, 0%, 100%);
	--ck-color-base-border: 									hsl(220, 6%, 81%);
	--ck-color-base-action: 									hsl(104, 50.2%, 42.5%);
	--ck-color-base-focus: 										hsl(209, 92%, 70%);
	--ck-color-base-text: 										hsl(0, 0%, 20%);
	--ck-color-base-active: 									hsl(218.1, 100%, 58%);
	--ck-color-base-active-focus:								hsl(218.2, 100%, 52.5%);
	--ck-color-base-error:										hsl(15, 100%, 43%);

	/* -- Generic colors ------------------------------------------------------------------------ */

	--ck-color-focus-border-coordinates: 						218, 81.8%, 56.9%;
	--ck-color-focus-border: 									hsl(var(--ck-color-focus-border-coordinates));
	--ck-color-focus-outer-shadow:								hsl(212.4, 89.3%, 89%);
	--ck-color-focus-disabled-shadow:							hsla(209, 90%, 72%,.3);
	--ck-color-focus-error-shadow:								hsla(9,100%,56%,.3);
	--ck-color-text: 											var(--ck-color-base-text);
	--ck-color-shadow-drop: 									hsla(0, 0%, 0%, 0.15);
	--ck-color-shadow-drop-active:								hsla(0, 0%, 0%, 0.2);
	--ck-color-shadow-inner: 									hsla(0, 0%, 0%, 0.1);

	/* -- Buttons ------------------------------------------------------------------------------- */

	--ck-color-button-default-background: 						transparent;
	--ck-color-button-default-hover-background: 				hsl(0, 0%, 94.1%);
	--ck-color-button-default-active-background: 				hsl(0, 0%, 94.1%);
	--ck-color-button-default-disabled-background: 				transparent;

	--ck-color-button-on-background: 							hsl(212, 100%, 97.1%);
	--ck-color-button-on-hover-background: 						hsl(211.7, 100%, 92.9%);
	--ck-color-button-on-active-background: 					hsl(211.7, 100%, 92.9%);
	--ck-color-button-on-disabled-background: 					hsl(211, 15%, 95%);
	--ck-color-button-on-color:									hsl(218.1, 100%, 58%);


	--ck-color-button-action-background: 						var(--ck-color-base-action);
	--ck-color-button-action-hover-background: 					hsl(104, 53.2%, 40.2%);
	--ck-color-button-action-active-background: 				hsl(104, 53.2%, 40.2%);
	--ck-color-button-action-disabled-background: 				hsl(104, 44%, 58%);
	--ck-color-button-action-text: 								var(--ck-color-base-background);

	--ck-color-button-save: 									hsl(120, 100%, 27%);
	--ck-color-button-cancel: 									hsl(15, 100%, 43%);

	--ck-color-switch-button-off-background:					hsl(0, 0%, 57.6%);
	--ck-color-switch-button-off-hover-background:				hsl(0, 0%, 49%);
	--ck-color-switch-button-on-background:						var(--ck-color-button-action-background);
	--ck-color-switch-button-on-hover-background:				hsl(104, 53.2%, 40.2%);
	--ck-color-switch-button-inner-background:					var(--ck-color-base-background);
	--ck-color-switch-button-inner-shadow:						hsla(0, 0%, 0%, 0.1);

	/* -- Dropdown ------------------------------------------------------------------------------ */

	--ck-color-dropdown-panel-background: 						var(--ck-color-base-background);
	--ck-color-dropdown-panel-border: 							var(--ck-color-base-border);

	/* -- Dialog -------------------------------------------------------------------------------- */

	--ck-color-dialog-background: 								var(--ck-custom-background);
	--ck-color-dialog-form-header-border: 						var(--ck-custom-border);

	/* -- Input --------------------------------------------------------------------------------- */

	--ck-color-input-background: 								var(--ck-color-base-background);
	--ck-color-input-border: 									var(--ck-color-base-border);
	--ck-color-input-error-border:								var(--ck-color-base-error);
	--ck-color-input-text: 										var(--ck-color-base-text);
	--ck-color-input-disabled-background: 						hsl(0, 0%, 95%);
	--ck-color-input-disabled-border: 							var(--ck-color-base-border);
	--ck-color-input-disabled-text: 							hsl(0, 0%, 46%);

	/* -- List ---------------------------------------------------------------------------------- */

	--ck-color-list-background: 								var(--ck-color-base-background);
	--ck-color-list-button-hover-background: 					var(--ck-color-button-default-hover-background);
	--ck-color-list-button-on-background: 						var(--ck-color-button-on-color);
	--ck-color-list-button-on-background-focus: 				var(--ck-color-button-on-color);
	--ck-color-list-button-on-text:								var(--ck-color-base-background);

	/* -- Panel --------------------------------------------------------------------------------- */

	--ck-color-panel-background: 								var(--ck-color-base-background);
	--ck-color-panel-border: 									var(--ck-color-base-border);

	/* -- Toolbar ------------------------------------------------------------------------------- */

	--ck-color-toolbar-background: 								var(--ck-color-base-background);
	--ck-color-toolbar-border: 									var(--ck-color-base-border);

	/* -- Tooltip ------------------------------------------------------------------------------- */

	--ck-color-tooltip-background: 								var(--ck-color-base-text);
	--ck-color-tooltip-text: 									var(--ck-color-base-background);

	/* -- Engine -------------------------------------------------------------------------------- */

	--ck-color-engine-placeholder-text: 						hsl(0, 0%, 44%);

	/* -- Upload -------------------------------------------------------------------------------- */

	--ck-color-upload-bar-background:		 					hsl(209, 92%, 70%);

	/* -- Link -------------------------------------------------------------------------------- */

	--ck-color-link-default:									hsl(240, 100%, 47%);
	--ck-color-link-selected-background:						hsla(201, 100%, 56%, 0.1);
	--ck-color-link-fake-selection:								hsla(201, 100%, 56%, 0.3);

	/* -- Search result highlight ---------------------------------------------------------------- */

	--ck-color-highlight-background:							hsl(60, 100%, 50%);

	/* -- Generic colors ------------------------------------------------------------------------- */

	--ck-color-light-red:										hsl(0, 100%, 90%);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	/**
	 * An opacity value of disabled UI item.
	 */
	--ck-disabled-opacity: .5;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	/**
	 * The geometry of the of focused element's outer shadow.
	 */
	--ck-focus-outer-shadow-geometry: 0 0 0 3px;

	/**
	 * A visual style of focused element's outer shadow.
	 */
	--ck-focus-outer-shadow: var(--ck-focus-outer-shadow-geometry) var(--ck-color-focus-outer-shadow);

	/**
	 * A visual style of focused element's outer shadow (when disabled).
	 */
	--ck-focus-disabled-outer-shadow: var(--ck-focus-outer-shadow-geometry) var(--ck-color-focus-disabled-shadow);

	/**
	 * A visual style of focused element's outer shadow (when has errors).
	 */
	--ck-focus-error-outer-shadow: var(--ck-focus-outer-shadow-geometry) var(--ck-color-focus-error-shadow);

	/**
	 * A visual style of focused element's border or outline.
	 */
	--ck-focus-ring: 1px solid var(--ck-color-focus-border);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-font-size-base: 13px;
	--ck-line-height-base: 1.84615;
	--ck-font-face: Helvetica, Arial, Tahoma, Verdana, Sans-Serif;

	--ck-font-size-tiny: 0.7em;
	--ck-font-size-small: 0.75em;
	--ck-font-size-normal: 1em;
	--ck-font-size-big: 1.4em;
	--ck-font-size-large: 1.8em;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	/* This is super-important. This is **manually** adjusted so a button without an icon
	is never smaller than a button with icon, additionally making sure that text-less buttons
	are perfect squares. The value is also shared by other components which should stay "in-line"
	with buttons. */
	--ck-ui-component-min-height: 2.3em;
}
/**
 * Resets an element, ignoring its children.
 */
.ck.ck-reset,
.ck.ck-reset_all,
.ck-reset_all *:not(.ck-reset_all-excluded *) {
	box-sizing: border-box;
	width: auto;
	height: auto;
	position: static;

	/* Do not include inheritable rules here. */
	margin: 0;
	padding: 0;
	border: 0;
	background: transparent;
	text-decoration: none;
	vertical-align: middle;
	transition: none;

	/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/105 */
	word-wrap: break-word;
}
/**
 * Resets an element AND its children.
 */
.ck.ck-reset_all,
.ck-reset_all *:not(.ck-reset_all-excluded *) {
	/* These are rule inherited by all children elements. */
	border-collapse: collapse;
	font: normal normal normal var(--ck-font-size-base)/var(--ck-line-height-base) var(--ck-font-face);
	color: var(--ck-color-text);
	text-align: left;
	white-space: nowrap;
	cursor: auto;
	float: none;
}
.ck-reset_all .ck-rtl *:not(.ck-reset_all-excluded *) {
		text-align: right;
	}
.ck-reset_all iframe:not(.ck-reset_all-excluded *) {
		/* For IE */
		vertical-align: inherit;
	}
.ck-reset_all textarea:not(.ck-reset_all-excluded *) {
		white-space: pre-wrap;
	}
.ck-reset_all textarea:not(.ck-reset_all-excluded *),
	.ck-reset_all input[type="text"]:not(.ck-reset_all-excluded *),
	.ck-reset_all input[type="password"]:not(.ck-reset_all-excluded *) {
		cursor: text;
	}
.ck-reset_all textarea[disabled]:not(.ck-reset_all-excluded *),
	.ck-reset_all input[type="text"][disabled]:not(.ck-reset_all-excluded *),
	.ck-reset_all input[type="password"][disabled]:not(.ck-reset_all-excluded *) {
		cursor: default;
	}
.ck-reset_all fieldset:not(.ck-reset_all-excluded *) {
		padding: 10px;
		border: 2px groove hsl(255, 7%, 88%);
	}
.ck-reset_all button:not(.ck-reset_all-excluded *)::-moz-focus-inner {
		/* See http://stackoverflow.com/questions/5517744/remove-extra-button-spacing-padding-in-firefox */
		padding: 0;
		border: 0
	}
/**
 * Default UI rules for RTL languages.
 */
.ck[dir="rtl"],
.ck[dir="rtl"] .ck {
	text-align: right;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Default border-radius value.
 */
:root{
	--ck-border-radius: 2px;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	/**
	 * A visual style of element's inner shadow (i.e. input).
	 */
	--ck-inner-shadow: 2px 2px 3px var(--ck-color-shadow-inner) inset;

	/**
	 * A visual style of element's drop shadow (i.e. panel).
	 */
	--ck-drop-shadow: 0 1px 2px 1px var(--ck-color-shadow-drop);

	/**
	 * A visual style of element's active shadow (i.e. comment or suggestion).
	 */
	--ck-drop-shadow-active: 0 3px 6px 1px var(--ck-color-shadow-drop-active);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-spacing-unit: 						0.6em;
	--ck-spacing-large: 					calc(var(--ck-spacing-unit) * 1.5);
	--ck-spacing-standard: 					var(--ck-spacing-unit);
	--ck-spacing-medium: 					calc(var(--ck-spacing-unit) * 0.8);
	--ck-spacing-small: 					calc(var(--ck-spacing-unit) * 0.5);
	--ck-spacing-tiny: 						calc(var(--ck-spacing-unit) * 0.3);
	--ck-spacing-extra-tiny: 				calc(var(--ck-spacing-unit) * 0.16);
}

/* Components */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
.ck.ck-autocomplete > .ck-search__results {
		border-radius: 0;
	}
.ck-rounded-corners .ck.ck-autocomplete > .ck-search__results, .ck.ck-autocomplete > .ck-search__results.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
	}
.ck.ck-autocomplete > .ck-search__results {
		box-shadow: var(--ck-drop-shadow), 0 0;

		max-height: 200px;
		overflow-y: auto;
		background: var(--ck-color-base-background);
		border: 1px solid var(--ck-color-dropdown-panel-border);
		min-width: auto;
	}
.ck.ck-autocomplete > .ck-search__results.ck-search__results_n {
			border-bottom-left-radius: 0;
			border-bottom-right-radius: 0;

			/* Prevent duplicated borders between the input and the results pane. */
			margin-bottom: -1px;
		}
.ck.ck-autocomplete > .ck-search__results.ck-search__results_s {
			border-top-left-radius: 0;
			border-top-right-radius: 0;

			/* Prevent duplicated borders between the input and the results pane. */
			margin-top: -1px;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class which indicates that an element holding it is disabled.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements a button of given background color.
 *
 * @param {String} \$background - Background color of the button.
 * @param {String} \$border - Border color of the button.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-button,
a.ck.ck-button {
	background: var(--ck-color-button-default-background);
	border-radius: 0;

	white-space: nowrap;
	cursor: default;
	vertical-align: middle;
	padding: var(--ck-spacing-tiny);
	text-align: center;

	/* A very important piece of styling. Go to variable declaration to learn more. */
	min-width: var(--ck-ui-component-min-height);
	min-height: var(--ck-ui-component-min-height);

	/* Normalize the height of the line. Removing this will break consistent height
	among text and text-less buttons (with icons). */
	line-height: 1;

	/* Enable font size inheritance, which allows fluid UI scaling. */
	font-size: inherit;

	/* Avoid flickering when the foucs border shows up. */
	border: 1px solid transparent;

	/* Apply some smooth transition to the box-shadow and border. */
	transition: box-shadow .2s ease-in-out, border .2s ease-in-out;

	/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/189 */
	-webkit-appearance: none;
}
.ck.ck-button:not(.ck-disabled):hover, a.ck.ck-button:not(.ck-disabled):hover {
			background: var(--ck-color-button-default-hover-background);
		}
.ck.ck-button:not(.ck-disabled):active, a.ck.ck-button:not(.ck-disabled):active {
			background: var(--ck-color-button-default-active-background);
		}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/98 */
.ck.ck-button.ck-disabled, a.ck.ck-button.ck-disabled {
		background: var(--ck-color-button-default-disabled-background);
	}
.ck-rounded-corners .ck.ck-button,
.ck-rounded-corners a.ck.ck-button,
.ck.ck-button.ck-rounded-corners,
a.ck.ck-button.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
@media (prefers-reduced-motion: reduce) {
.ck.ck-button,
a.ck.ck-button {
		transition: none;
}
	}
.ck.ck-button:active,
	a.ck.ck-button:active,
	.ck.ck-button:focus,
	a.ck.ck-button:focus {
		/* Disable native outline. */
		outline: none;
		border: var(--ck-focus-ring);
		box-shadow: var(--ck-focus-outer-shadow), 0 0;
	}
/* Allow icon coloring using the text "color" property. */
.ck.ck-button .ck-button__icon use,
		a.ck.ck-button .ck-button__icon use,
		.ck.ck-button .ck-button__icon use *,
		a.ck.ck-button .ck-button__icon use * {
			color: inherit;
		}
.ck.ck-button .ck-button__label, a.ck.ck-button .ck-button__label {
		/* Enable font size inheritance, which allows fluid UI scaling. */
		font-size: inherit;
		font-weight: inherit;
		color: inherit;
		cursor: inherit;

		/* Must be consistent with .ck-icon's vertical align. Otherwise, buttons with and
		without labels (but with icons) have different sizes in Chrome */
		vertical-align: middle;
	}
[dir="ltr"] .ck.ck-button .ck-button__label, [dir="ltr"] a.ck.ck-button .ck-button__label {
			text-align: left;
	}
[dir="rtl"] .ck.ck-button .ck-button__label, [dir="rtl"] a.ck.ck-button .ck-button__label {
			text-align: right;
	}
.ck.ck-button .ck-button__keystroke, a.ck.ck-button .ck-button__keystroke {
		color: inherit;
	}
[dir="ltr"] .ck.ck-button .ck-button__keystroke, [dir="ltr"] a.ck.ck-button .ck-button__keystroke {
			margin-left: var(--ck-spacing-large);
	}
[dir="rtl"] .ck.ck-button .ck-button__keystroke, [dir="rtl"] a.ck.ck-button .ck-button__keystroke {
			margin-right: var(--ck-spacing-large);
	}
.ck.ck-button .ck-button__keystroke, a.ck.ck-button .ck-button__keystroke {

		opacity: .5;
	}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/70 */
.ck.ck-button.ck-disabled:active,
		a.ck.ck-button.ck-disabled:active,
		.ck.ck-button.ck-disabled:focus,
		a.ck.ck-button.ck-disabled:focus {
			/* The disabled button should have a slightly less visible shadow when focused. */
			box-shadow: var(--ck-focus-disabled-outer-shadow), 0 0;
		}
.ck.ck-button.ck-disabled .ck-button__icon, a.ck.ck-button.ck-disabled .ck-button__icon {
			opacity: var(--ck-disabled-opacity);
		}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/98 */
.ck.ck-button.ck-disabled .ck-button__label, a.ck.ck-button.ck-disabled .ck-button__label {
			opacity: var(--ck-disabled-opacity);
		}
.ck.ck-button.ck-disabled .ck-button__keystroke, a.ck.ck-button.ck-disabled .ck-button__keystroke {
			opacity: .3;
		}
.ck.ck-button.ck-button_with-text, a.ck.ck-button.ck-button_with-text {
		padding: var(--ck-spacing-tiny) var(--ck-spacing-standard);

		/* stylelint-disable-next-line no-descending-specificity */
	}
[dir="ltr"] .ck.ck-button.ck-button_with-text .ck-button__icon, [dir="ltr"] a.ck.ck-button.ck-button_with-text .ck-button__icon {
				margin-right: var(--ck-spacing-medium);
		}
[dir="rtl"] .ck.ck-button.ck-button_with-text .ck-button__icon, [dir="rtl"] a.ck.ck-button.ck-button_with-text .ck-button__icon {
				margin-left: var(--ck-spacing-medium);
		}
/* stylelint-disable-next-line no-descending-specificity */
.ck.ck-button.ck-button_with-keystroke .ck-button__label, a.ck.ck-button.ck-button_with-keystroke .ck-button__label {
			flex-grow: 1;
		}
/* A style of the button which is currently on, e.g. its feature is active. */
.ck.ck-button.ck-on, a.ck.ck-button.ck-on {
		background: var(--ck-color-button-on-background);

		color: var(--ck-color-button-on-color);
	}
.ck.ck-button.ck-on:not(.ck-disabled):hover, a.ck.ck-button.ck-on:not(.ck-disabled):hover {
			background: var(--ck-color-button-on-hover-background);
		}
.ck.ck-button.ck-on:not(.ck-disabled):active, a.ck.ck-button.ck-on:not(.ck-disabled):active {
			background: var(--ck-color-button-on-active-background);
		}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/98 */
.ck.ck-button.ck-on.ck-disabled, a.ck.ck-button.ck-on.ck-disabled {
		background: var(--ck-color-button-on-disabled-background);
	}
.ck.ck-button.ck-button-save, a.ck.ck-button.ck-button-save {
		color: var(--ck-color-button-save);
	}
.ck.ck-button.ck-button-cancel, a.ck.ck-button.ck-button-cancel {
		color: var(--ck-color-button-cancel);
	}
/* A style of the button which handles the primary action. */
.ck.ck-button-action,
a.ck.ck-button-action {
	background: var(--ck-color-button-action-background);

	color: var(--ck-color-button-action-text);
}
.ck.ck-button-action:not(.ck-disabled):hover, a.ck.ck-button-action:not(.ck-disabled):hover {
			background: var(--ck-color-button-action-hover-background);
		}
.ck.ck-button-action:not(.ck-disabled):active, a.ck.ck-button-action:not(.ck-disabled):active {
			background: var(--ck-color-button-action-active-background);
		}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/98 */
.ck.ck-button-action.ck-disabled, a.ck.ck-button-action.ck-disabled {
		background: var(--ck-color-button-action-disabled-background);
	}
.ck.ck-button-bold,
a.ck.ck-button-bold {
	font-weight: bold;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class which indicates that an element holding it is disabled.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* Note: To avoid rendering issues (aliasing) but to preserve the responsive nature
of the component, floating–point numbers have been used which, for the default font size
(see: --ck-font-size-base), will generate simple integers. */
:root {
	/* 34px at 13px font-size */
	--ck-switch-button-toggle-width: 2.6153846154em;
	/* 14px at 13px font-size */
	--ck-switch-button-toggle-inner-size: calc(1.0769230769em + 1px);
	--ck-switch-button-translation: calc(
		var(--ck-switch-button-toggle-width) -
		var(--ck-switch-button-toggle-inner-size) -
		2px /* Border */
	);
	--ck-switch-button-inner-hover-shadow: 0 0 0 5px var(--ck-color-switch-button-inner-shadow);
}
/* Unlike a regular button, the switch button text color and background should never change.
	 * Changing toggle switch (background, outline) is enough to carry the information about the
	 * state of the entire component (https://github.com/ckeditor/ckeditor5/issues/12519)
	 */
.ck.ck-button.ck-switchbutton, .ck.ck-button.ck-switchbutton:hover, .ck.ck-button.ck-switchbutton:focus, .ck.ck-button.ck-switchbutton:active, .ck.ck-button.ck-switchbutton.ck-on:hover, .ck.ck-button.ck-switchbutton.ck-on:focus, .ck.ck-button.ck-switchbutton.ck-on:active {
		color: inherit;
		background: transparent;
	}
[dir="ltr"] .ck.ck-button.ck-switchbutton .ck-button__label {
			/* Separate the label from the switch */
			margin-right: calc(2 * var(--ck-spacing-large));
	}
[dir="rtl"] .ck.ck-button.ck-switchbutton .ck-button__label {
			/* Separate the label from the switch */
			margin-left: calc(2 * var(--ck-spacing-large));
	}
.ck.ck-button.ck-switchbutton .ck-button__toggle {
		border-radius: 0;
	}
.ck-rounded-corners .ck.ck-button.ck-switchbutton .ck-button__toggle, .ck.ck-button.ck-switchbutton .ck-button__toggle.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
	}
[dir="ltr"] .ck.ck-button.ck-switchbutton .ck-button__toggle {
			/* Make sure the toggle is always to the right as far as possible. */
			margin-left: auto;
	}
[dir="rtl"] .ck.ck-button.ck-switchbutton .ck-button__toggle {
			/* Make sure the toggle is always to the left as far as possible. */
			margin-right: auto;
	}
.ck.ck-button.ck-switchbutton .ck-button__toggle {

		/* Apply some smooth transition to the box-shadow and border. */
		/* Gently animate the background color of the toggle switch */
		transition: background 400ms ease, box-shadow .2s ease-in-out, outline .2s ease-in-out;
		border: 1px solid transparent;
		width: var(--ck-switch-button-toggle-width);
		background: var(--ck-color-switch-button-off-background);
	}
.ck.ck-button.ck-switchbutton .ck-button__toggle .ck-button__toggle__inner {
			border-radius: 0;
		}
.ck-rounded-corners .ck.ck-button.ck-switchbutton .ck-button__toggle .ck-button__toggle__inner, .ck.ck-button.ck-switchbutton .ck-button__toggle .ck-button__toggle__inner.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
				border-radius: calc(.5 * var(--ck-border-radius));
		}
.ck.ck-button.ck-switchbutton .ck-button__toggle .ck-button__toggle__inner {

			width: var(--ck-switch-button-toggle-inner-size);
			height: var(--ck-switch-button-toggle-inner-size);
			background: var(--ck-color-switch-button-inner-background);

			/* Gently animate the inner part of the toggle switch */
			transition: all 300ms ease;
		}
@media (prefers-reduced-motion: reduce) {
.ck.ck-button.ck-switchbutton .ck-button__toggle .ck-button__toggle__inner {
				transition: none;
		}
			}
.ck.ck-button.ck-switchbutton .ck-button__toggle:hover {
			background: var(--ck-color-switch-button-off-hover-background);
		}
.ck.ck-button.ck-switchbutton .ck-button__toggle:hover .ck-button__toggle__inner {
				box-shadow: var(--ck-switch-button-inner-hover-shadow);
			}
.ck.ck-button.ck-switchbutton.ck-disabled .ck-button__toggle {
		opacity: var(--ck-disabled-opacity);
	}
/* Overriding default .ck-button:focus styles + an outline around the toogle */
.ck.ck-button.ck-switchbutton:focus {
		border-color: transparent;
		outline: none;
		box-shadow: none;
	}
.ck.ck-button.ck-switchbutton:focus .ck-button__toggle {
			box-shadow: 0 0 0 1px var(--ck-color-base-background), 0 0 0 5px var(--ck-color-focus-outer-shadow);
			outline-offset: 1px;
			outline: var(--ck-focus-ring);
		}
/* stylelint-disable-next-line no-descending-specificity */
.ck.ck-button.ck-switchbutton.ck-on .ck-button__toggle {
			background: var(--ck-color-switch-button-on-background);
		}
.ck.ck-button.ck-switchbutton.ck-on .ck-button__toggle:hover {
				background: var(--ck-color-switch-button-on-hover-background);
			}
/*
				* Move the toggle switch to the right. It will be animated.
				*/
[dir="ltr"] .ck.ck-button.ck-switchbutton.ck-on .ck-button__toggle .ck-button__toggle__inner {
					transform: translateX( var( --ck-switch-button-translation ) );
			}
[dir="rtl"] .ck.ck-button.ck-switchbutton.ck-on .ck-button__toggle .ck-button__toggle__inner {
					transform: translateX( calc( -1 * var( --ck-switch-button-translation ) ) );
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-button.ck-list-item-button {
	padding: var(--ck-spacing-tiny) calc(2 * var(--ck-spacing-standard));
}
.ck.ck-button.ck-list-item-button,
	.ck.ck-button.ck-list-item-button.ck-on {
		background: var(--ck-color-list-background);
		color: var(--ck-color-text);
	}
[dir="ltr"] .ck.ck-button.ck-list-item-button:has(.ck-list-item-button__check-holder) {
			padding-left: var(--ck-spacing-small);
	}
[dir="rtl"] .ck.ck-button.ck-list-item-button:has(.ck-list-item-button__check-holder) {
			padding-right: var(--ck-spacing-small);
	}
/*
	 * \`.ck-on\` class and background styling is overridden for \`ck-button\` in many places.
	 * This is a workaround to make sure that the background is not overridden and uses similar
	 * selector specificity as the other overrides.
	 */
.ck.ck-button.ck-list-item-button:hover:not(.ck-disabled),
	.ck.ck-button.ck-list-item-button.ck-button.ck-on:hover,
	.ck.ck-button.ck-list-item-button.ck-on:not(.ck-list-item-button_toggleable),
	.ck.ck-button.ck-list-item-button.ck-on:hover {
		background: var(--ck-color-list-button-hover-background);
	}
.ck.ck-button.ck-list-item-button:hover:not(.ck-disabled):not(.ck-disabled), .ck.ck-button.ck-list-item-button.ck-button.ck-on:hover:not(.ck-disabled), .ck.ck-button.ck-list-item-button.ck-on:not(.ck-list-item-button_toggleable):not(.ck-disabled), .ck.ck-button.ck-list-item-button.ck-on:hover:not(.ck-disabled) {
			color: var(--ck-color-text);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-collapsible-arrow-size: calc(0.5 * var(--ck-icon-size));
}
.ck.ck-collapsible > .ck.ck-button {
		width: 100%;
		font-weight: bold;
		border-radius: 0;
		color: inherit;
	}
.ck.ck-collapsible > .ck.ck-button:focus {
			background: transparent;
		}
.ck.ck-collapsible > .ck.ck-button:active, .ck.ck-collapsible > .ck.ck-button:not(:focus), .ck.ck-collapsible > .ck.ck-button:hover:not(:focus) {
			background: transparent;
			border-color: transparent;
			box-shadow: none;
		}
.ck.ck-collapsible > .ck.ck-button > .ck-icon {
			margin-right: var(--ck-spacing-medium);
			width: var(--ck-collapsible-arrow-size);
		}
.ck.ck-collapsible > .ck-collapsible__children {
		padding: var(--ck-spacing-medium) var(--ck-spacing-large) var(--ck-spacing-large);
	}
.ck.ck-collapsible.ck-collapsible_collapsed > .ck.ck-button .ck-icon {
			transform: rotate(-90deg);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-grid-tile-size: 24px;

	/* Not using global colors here because these may change but some colors in a pallette
	 * require special treatment. For instance, this ensures no matter what the UI text color is,
	 * the check icon will look good on the black color tile. */
	--ck-color-color-grid-check-icon: hsl(212, 81%, 46%);
}
.ck.ck-color-grid {
	grid-gap: 5px;
	padding: 8px;
}
.ck.ck-color-grid__tile {
	transition: .2s ease box-shadow;
}
@media (forced-colors: none) {
		.ck.ck-color-grid__tile {
		width: var(--ck-color-grid-tile-size);
		height: var(--ck-color-grid-tile-size);
		min-width: var(--ck-color-grid-tile-size);
		min-height: var(--ck-color-grid-tile-size);
		padding: 0;
		border: 0;
		}

		.ck.ck-color-grid__tile.ck-on,
		.ck.ck-color-grid__tile:focus:not( .ck-disabled ),
		.ck.ck-color-grid__tile:hover:not( .ck-disabled ) {
			/* Disable the default .ck-button's border ring. */
			border: 0;
		}

		.ck.ck-color-grid__tile.ck-color-selector__color-tile_bordered {
			box-shadow: 0 0 0 1px var(--ck-color-base-border);
		}

		.ck.ck-color-grid__tile.ck-on {
			box-shadow: inset 0 0 0 1px var(--ck-color-base-background), 0 0 0 2px var(--ck-color-base-text);
		}

		.ck.ck-color-grid__tile:focus:not( .ck-disabled ),
		.ck.ck-color-grid__tile:hover:not( .ck-disabled ) {
			box-shadow: inset 0 0 0 1px var(--ck-color-base-background), 0 0 0 2px var(--ck-color-focus-border);
		}
	}
/*
	 * In high contrast mode, the colors are replaced with text labels.
	 * See https://github.com/ckeditor/ckeditor5/issues/14907.
	 */
@media (forced-colors: active) {
		.ck.ck-color-grid__tile {
		width: unset;
		height: unset;
		min-width: unset;
		min-height: unset;
		padding: 0 var(--ck-spacing-small);
		}

		.ck.ck-color-grid__tile .ck-button__label {
			display: inline-block;
		}
	}
@media (prefers-reduced-motion: reduce) {
.ck.ck-color-grid__tile {
		transition: none;
}
	}
.ck.ck-color-grid__tile.ck-disabled {
		cursor: unset;
		transition: unset;
	}
.ck.ck-color-grid__tile .ck.ck-icon {
		display: none;
		color: var(--ck-color-color-grid-check-icon);
	}
.ck.ck-color-grid__tile.ck-on .ck.ck-icon {
			display: block;
		}
.ck.ck-color-grid__label {
	padding: 0 var(--ck-spacing-standard);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* View fragment with color grids. */
.ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__remove-color,
		.ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__color-picker {
			width: 100%;
		}
.ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__color-picker {
			padding: calc(var(--ck-spacing-standard) / 2) var(--ck-spacing-standard);
			border-bottom-left-radius: 0;
			border-bottom-right-radius: 0;
		}
.ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__color-picker:not(:focus) {
				border-top: 1px solid var(--ck-color-base-border);
			}
[dir="ltr"] .ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__color-picker .ck.ck-icon {
					margin-right: var(--ck-spacing-standard);
			}
[dir="rtl"] .ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__color-picker .ck.ck-icon {
					margin-left: var(--ck-spacing-standard);
			}
.ck.ck-color-selector .ck-color-grids-fragment label.ck.ck-color-grid__label {
			font-weight: unset;
		}
/* View fragment with a color picker. */
.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-picker {
			padding: 8px;
		}
.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-picker .hex-color-picker {
				height: 100px;
				min-width: 180px;
			}
.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-picker .hex-color-picker::part(saturation) {
					border-radius: var(--ck-border-radius) var(--ck-border-radius) 0 0;
				}
.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-picker .hex-color-picker::part(hue) {
					border-radius: 0 0 var(--ck-border-radius) var(--ck-border-radius);
				}
.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-picker .hex-color-picker::part(saturation-pointer),
				.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-picker .hex-color-picker::part(hue-pointer) {
					width: 15px;
					height: 15px;
				}
.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-selector_action-bar {
			padding: 0 8px 8px;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-dialog-overlay-background-color: hsla( 0, 0%, 0%, .5 );
	--ck-dialog-drop-shadow: 0px 0px 6px 2px hsl(0deg 0% 0% / 15%);
	--ck-dialog-max-width: 100vw;
	--ck-dialog-max-height: 90vh;
	--ck-color-dialog-background: var(--ck-color-base-background);
	--ck-color-dialog-form-header-border: var(--ck-color-base-border);
}
.ck.ck-dialog-overlay {
	animation: ck-dialog-fade-in .3s;
	background: var(--ck-dialog-overlay-background-color);
	z-index: var(--ck-z-dialog);
}
.ck.ck-dialog {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-dialog, .ck.ck-dialog.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-dialog {
	box-shadow: var(--ck-drop-shadow), 0 0;

	--ck-drop-shadow: var(--ck-dialog-drop-shadow);

	background: var(--ck-color-dialog-background);
	max-height: var(--ck-dialog-max-height);
	max-width: var(--ck-dialog-max-width);
	border: 1px solid var(--ck-color-base-border);
}
.ck.ck-dialog .ck.ck-form__header {
		border-bottom: 1px solid var(--ck-color-dialog-form-header-border);
	}
@keyframes ck-dialog-fade-in {
	0% {
		background: hsla( 0, 0%, 0%, 0 );
	}

	100% {
		background: var(--ck-dialog-overlay-background-color);
	}
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-dialog .ck.ck-dialog__actions {
		padding: var(--ck-spacing-large);
	}
.ck.ck-dialog .ck.ck-dialog__actions > * + * {
			margin-left: var(--ck-spacing-large);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class which indicates that an element holding it is disabled.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-dropdown-arrow-size: calc(0.5 * var(--ck-icon-size));
}
.ck.ck-dropdown {
	/* Enable font size inheritance, which allows fluid UI scaling. */
	font-size: inherit;
}
.ck.ck-dropdown .ck-dropdown__arrow {
		width: var(--ck-dropdown-arrow-size);
	}
[dir="ltr"] .ck.ck-dropdown .ck-dropdown__arrow {
			right: var(--ck-spacing-standard);

			/* A space to accommodate the triangle. */
			margin-left: var(--ck-spacing-standard);
		}
[dir="rtl"] .ck.ck-dropdown .ck-dropdown__arrow {
			left: var(--ck-spacing-standard);

			/* A space to accommodate the triangle. */
			margin-right: var(--ck-spacing-small);
		}
.ck.ck-dropdown.ck-disabled .ck-dropdown__arrow {
		opacity: var(--ck-disabled-opacity);
	}
[dir="ltr"] .ck.ck-dropdown .ck-button.ck-dropdown__button:not(.ck-button_with-text) {
				/* Make sure dropdowns with just an icon have the right inner spacing */
				padding-left: var(--ck-spacing-small);
			}
[dir="rtl"] .ck.ck-dropdown .ck-button.ck-dropdown__button:not(.ck-button_with-text) {
				/* Make sure dropdowns with just an icon have the right inner spacing */
				padding-right: var(--ck-spacing-small);
			}
/* #23 */
.ck.ck-dropdown .ck-button.ck-dropdown__button .ck-button__label {
			width: 7em;
			overflow: hidden;
			text-overflow: ellipsis;
		}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/70 */
.ck.ck-dropdown .ck-button.ck-dropdown__button.ck-disabled .ck-button__label {
			opacity: var(--ck-disabled-opacity);
		}
/* https://github.com/ckeditor/ckeditor5/issues/816 */
.ck.ck-dropdown .ck-button.ck-dropdown__button.ck-on {
			border-bottom-left-radius: 0;
			border-bottom-right-radius: 0;
		}
.ck.ck-dropdown .ck-button.ck-dropdown__button.ck-dropdown__button_label-width_auto .ck-button__label {
			width: auto;
		}
/* https://github.com/ckeditor/ckeditor5/issues/8699 */
.ck.ck-dropdown .ck-button.ck-dropdown__button.ck-off:active,
		.ck.ck-dropdown .ck-button.ck-dropdown__button.ck-on:active {
			box-shadow: none;
		}
.ck.ck-dropdown .ck-button.ck-dropdown__button.ck-off:active:focus, .ck.ck-dropdown .ck-button.ck-dropdown__button.ck-on:active:focus {
				box-shadow: var(--ck-focus-outer-shadow), 0 0;
			}
.ck.ck-dropdown__panel {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-dropdown__panel, .ck.ck-dropdown__panel.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-dropdown__panel {
	box-shadow: var(--ck-drop-shadow), 0 0;

	background: var(--ck-color-dropdown-panel-background);
	border: 1px solid var(--ck-color-dropdown-panel-border);
	bottom: 0;

	/* Make sure the panel is at least as wide as the drop-down's button. */
	min-width: 100%;

	/* Disabled corner border radius to be consistent with the .dropdown__button
	https://github.com/ckeditor/ckeditor5/issues/816 */
}
.ck.ck-dropdown__panel.ck-dropdown__panel_se {
		border-top-left-radius: 0;
	}
.ck.ck-dropdown__panel.ck-dropdown__panel_sw {
		border-top-right-radius: 0;
	}
.ck.ck-dropdown__panel.ck-dropdown__panel_ne {
		border-bottom-left-radius: 0;
	}
.ck.ck-dropdown__panel.ck-dropdown__panel_nw {
		border-bottom-right-radius: 0;
	}
.ck.ck-dropdown__panel:focus {
		outline: none;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
.ck.ck-dropdown > .ck-dropdown__panel > .ck-list {
	/* Disabled radius of top-left border to be consistent with .dropdown__button
	https://github.com/ckeditor/ckeditor5/issues/816 */
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-dropdown > .ck-dropdown__panel > .ck-list, .ck.ck-dropdown > .ck-dropdown__panel > .ck-list.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
		border-top-left-radius: 0;
}
/* Make sure the button belonging to the first/last child of the list goes well with the
	border radius of the entire panel. */
.ck.ck-dropdown > .ck-dropdown__panel > .ck-list .ck-list__item:first-child > .ck-button {
			border-radius: 0;
		}
.ck-rounded-corners .ck.ck-dropdown > .ck-dropdown__panel > .ck-list .ck-list__item:first-child > .ck-button, .ck.ck-dropdown > .ck-dropdown__panel > .ck-list .ck-list__item:first-child > .ck-button.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
				border-top-left-radius: 0;
				border-bottom-left-radius: 0;
				border-bottom-right-radius: 0;
		}
.ck.ck-dropdown > .ck-dropdown__panel > .ck-list .ck-list__item:last-child > .ck-button {
			border-radius: 0;
		}
.ck-rounded-corners .ck.ck-dropdown > .ck-dropdown__panel > .ck-list .ck-list__item:last-child > .ck-button, .ck.ck-dropdown > .ck-dropdown__panel > .ck-list .ck-list__item:last-child > .ck-button.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
				border-top-left-radius: 0;
				border-top-right-radius: 0;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
:root {
	--ck-color-split-button-hover-background: hsl(0, 0%, 92%);
	--ck-color-split-button-hover-border: hsl(0, 0%, 70%);
}
/*
	 * Note: ck-rounded and ck-dir mixins don't go together (because they both use @nest).
	 */
[dir="ltr"] .ck.ck-splitbutton:hover > .ck-splitbutton__action,
	[dir="ltr"] .ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__action {
			/* Don't round the action button on the right side */
			border-top-right-radius: unset;
			border-bottom-right-radius: unset;
	}
[dir="rtl"] .ck.ck-splitbutton:hover > .ck-splitbutton__action,
	[dir="rtl"] .ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__action {
			/* Don't round the action button on the left side */
			border-top-left-radius: unset;
			border-bottom-left-radius: unset;
	}
.ck.ck-splitbutton > .ck-splitbutton__arrow {
		/* It's a text-less button and since the icon is positioned absolutely in such situation,
		it must get some arbitrary min-width. */
		min-width: unset;
	}
[dir="ltr"] .ck.ck-splitbutton > .ck-splitbutton__arrow {
			/* Don't round the arrow button on the left side */
			border-top-left-radius: unset;
			border-bottom-left-radius: unset;
	}
[dir="rtl"] .ck.ck-splitbutton > .ck-splitbutton__arrow {
			/* Don't round the arrow button on the right side */
			border-top-right-radius: unset;
			border-bottom-right-radius: unset;
	}
.ck.ck-splitbutton > .ck-splitbutton__arrow svg {
			width: var(--ck-dropdown-arrow-size);
		}
/* Make sure the divider stretches 100% height of the button
	https://github.com/ckeditor/ckeditor5/issues/10936 */
.ck.ck-splitbutton > .ck-splitbutton__arrow:not(:focus) {
		border-top-width: 0px;
		border-bottom-width: 0px;
	}
/* When the split button is "open" (the arrow is on) or being hovered, it should get some styling
	as a whole. The background of both buttons should stand out and there should be a visual
	separation between both buttons. */
/* When the split button hovered as a whole, not as individual buttons. */
.ck.ck-splitbutton.ck-splitbutton_open > .ck-button:not(.ck-on):not(.ck-disabled):not(:hover), .ck.ck-splitbutton:hover > .ck-button:not(.ck-on):not(.ck-disabled):not(:hover) {
			background: var(--ck-color-split-button-hover-background);
		}
/* Splitbutton separator needs to be set with the ::after pseudoselector
		to display properly the borders on focus */
.ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__arrow:not(.ck-disabled)::after, .ck.ck-splitbutton:hover > .ck-splitbutton__arrow:not(.ck-disabled)::after {
			content: '';
			position: absolute;
			width: 1px;
			height: 100%;
			background-color: var(--ck-color-split-button-hover-border);
		}
/* Make sure the divider between the buttons looks fine when the button is focused */
.ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__arrow:focus::after, .ck.ck-splitbutton:hover > .ck-splitbutton__arrow:focus::after {
			--ck-color-split-button-hover-border: var(--ck-color-focus-border);
		}
[dir="ltr"] .ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__arrow:not(.ck-disabled)::after, [dir="ltr"] .ck.ck-splitbutton:hover > .ck-splitbutton__arrow:not(.ck-disabled)::after {
				left: -1px;
			}
[dir="rtl"] .ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__arrow:not(.ck-disabled)::after, [dir="rtl"] .ck.ck-splitbutton:hover > .ck-splitbutton__arrow:not(.ck-disabled)::after {
				right: -1px;
			}
/* Don't round the bottom left and right corners of the buttons when "open"
	https://github.com/ckeditor/ckeditor5/issues/816 */
.ck.ck-splitbutton.ck-splitbutton_open {
		border-radius: 0;
	}
.ck-rounded-corners .ck.ck-splitbutton.ck-splitbutton_open, .ck.ck-splitbutton.ck-splitbutton_open.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
	}
.ck-rounded-corners .ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__action, .ck.ck-splitbutton.ck-splitbutton_open.ck-rounded-corners > .ck-splitbutton__action {
				border-bottom-left-radius: 0;
			}
.ck-rounded-corners .ck.ck-splitbutton.ck-splitbutton_open > .ck-splitbutton__arrow, .ck.ck-splitbutton.ck-splitbutton_open.ck-rounded-corners > .ck-splitbutton__arrow {
				border-bottom-right-radius: 0;
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-toolbar-dropdown .ck-toolbar {
	border: 0;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class which indicates that an element holding it is disabled.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements a button of given background color.
 *
 * @param {String} \$background - Background color of the button.
 * @param {String} \$border - Border color of the button.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * All menu buttons.
 */
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button {
	width: 100%;
	padding: var(--ck-spacing-tiny) calc(2 * var(--ck-spacing-standard));
	border-radius: 0;
}
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button:focus {
		border-color: transparent;
		box-shadow: none;
	}
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button:focus:not(.ck-on) {
			background: var(--ck-color-button-default-hover-background);
		}
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button > .ck-button__label {
		flex-grow: 1;
		overflow: hidden;
		text-overflow: ellipsis;
	}
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button.ck-disabled > .ck-button__label {
		opacity: var(--ck-disabled-opacity);
	}
/* Spacing in buttons that miss the icon. */
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button.ck-icon-spacing:not(:has(.ck-button__icon)) > .ck-button__label {
		margin-left: calc(var(--ck-icon-size) - var(--ck-spacing-small));
	}
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button > .ck-dropdown-menu-list__nested-menu__button__arrow {
		width: var(--ck-dropdown-arrow-size);
	}
[dir="ltr"] .ck.ck-button.ck-dropdown-menu-list__nested-menu__button > .ck-dropdown-menu-list__nested-menu__button__arrow {
			transform: rotate(-90deg);

			/* Nudge the arrow gently to the right because its center of gravity is to the left */
			margin-right: calc(-1 * var(--ck-spacing-small));
	}
[dir="rtl"] .ck.ck-button.ck-dropdown-menu-list__nested-menu__button > .ck-dropdown-menu-list__nested-menu__button__arrow {
			transform: rotate(90deg);

			/* Nudge the arrow gently to the left because its center of gravity is to the right (after rotation). */
			margin-left: calc(-1 * var(--ck-spacing-small));
	}
.ck.ck-button.ck-dropdown-menu-list__nested-menu__button.ck-disabled > .ck-dropdown-menu-list__nested-menu__button__arrow {
		opacity: var(--ck-disabled-opacity);
	}
[dir="ltr"] .ck.ck-button.ck-dropdown-menu-list__nested-menu__button:not(.ck-button_with-text) {
			padding-left: var(--ck-spacing-small);
		}
[dir="ltr"] .ck.ck-button.ck-dropdown-menu-list__nested-menu__button > .ck-dropdown-menu-list__nested-menu__button__arrow {
			right: var(--ck-spacing-standard);

			/* A space to accommodate the triangle. */
			margin-left: var(--ck-spacing-standard);
		}
[dir="rtl"] .ck.ck-button.ck-dropdown-menu-list__nested-menu__button:not(.ck-button_with-text) {
			padding-right: var(--ck-spacing-small);
		}
[dir="rtl"] .ck.ck-button.ck-dropdown-menu-list__nested-menu__button > .ck-dropdown-menu-list__nested-menu__button__arrow {
			left: var(--ck-spacing-standard);

			/* A space to accommodate the triangle. */
			margin-right: var(--ck-spacing-small);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-dropdown-menu-menu-item-min-width: 18em;
}
.ck.ck-dropdown-menu-list__nested-menu__item {
	min-width: var(--ck-dropdown-menu-menu-item-min-width);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * List item buttons.
 */
.ck-button.ck-dropdown-menu-list__nested-menu__item__button {
	border-radius: 0;
}
.ck-button.ck-dropdown-menu-list__nested-menu__item__button > .ck-spinner-container,
	.ck-button.ck-dropdown-menu-list__nested-menu__item__button > .ck-spinner-container .ck-spinner {
		/* These styles correspond to .ck-icon so that the spinner seamlessly replaces the icon. */
		--ck-toolbar-spinner-size: 20px;
	}
.ck-button.ck-dropdown-menu-list__nested-menu__item__button > .ck-spinner-container {
		/* These margins are the same as for .ck-icon. */
		margin-left: calc(-1 * var(--ck-spacing-small));
		margin-right: var(--ck-spacing-small);
	}
/*
	 * Hovered items automatically get focused. Default focus styles look odd
	 * while moving across a huge list of items so let's get rid of them
	 */
.ck-button.ck-dropdown-menu-list__nested-menu__item__button:focus {
		border-color: transparent;
		box-shadow: none;
	}
.ck-button.ck-dropdown-menu-list__nested-menu__item__button:focus:not(.ck-on) {
			background: var(--ck-color-button-default-hover-background);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
:root {
	--ck-dropdown-menu-menu-panel-max-width: 75vw;
}
.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel {
	box-shadow: var(--ck-drop-shadow), 0 0;

	background: var(--ck-color-dropdown-panel-background);
	border: 1px solid var(--ck-color-dropdown-panel-border);
	bottom: 0;
	height: fit-content;
	max-width: var(--ck-dropdown-menu-menu-panel-max-width);

	/* Reset balloon styling */
}
.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel::after,
	.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel::before {
		display: none;
	}
/* Corner border radius consistent with the button. */
.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_es,
	.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_se {
		border-top-left-radius: 0;
	}
.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_ws,
	.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_sw {
		border-top-right-radius: 0;
	}
.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_en,
	.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_ne {
		border-bottom-left-radius: 0;
	}
.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_wn,
	.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel.ck-balloon-panel_nw {
		border-bottom-right-radius: 0;
	}
.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel:focus {
		outline: none;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
:root {
	--ck-accessibility-help-dialog-max-width: 600px;
	--ck-accessibility-help-dialog-max-height: 400px;
	--ck-accessibility-help-dialog-border-color: hsl(220, 6%, 81%);
	--ck-accessibility-help-dialog-code-background-color: hsl(0deg 0% 92.94%);
	--ck-accessibility-help-dialog-kbd-shadow-color: hsl(0deg 0% 61%);
}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content {
	padding: var(--ck-spacing-large);
	max-width: var(--ck-accessibility-help-dialog-max-width);
	max-height: var(--ck-accessibility-help-dialog-max-height);
	overflow: auto;
	user-select: text;

	border: 1px solid transparent;
}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content:focus {
		/* Disable native outline. */
		outline: none;
		border: var(--ck-focus-ring);
		box-shadow: var(--ck-focus-outer-shadow), 0 0;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content * {
		white-space: normal;
	}
/* Hide the main label of the content container. */
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content .ck-label {
		display: none;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content h3 {
		font-weight: bold;
		font-size: 1.2em;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content h4 {
		font-weight: bold;
		font-size: 1em;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content p,
	.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content h3,
	.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content h4,
	.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content table {
		margin: 1em 0;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content dl {
		display: grid;
		grid-template-columns: 2fr 1fr;
		border-top: 1px solid var(--ck-accessibility-help-dialog-border-color);
		border-bottom: none;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content dl dt, .ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content dl dd {
			border-bottom: 1px solid var(--ck-accessibility-help-dialog-border-color);
			padding: .4em 0;
		}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content dl dt {
			grid-column-start: 1;
		}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content dl dd {
			grid-column-start: 2;
			text-align: right;
		}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content kbd, .ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content code {
		display: inline-block;
		background: var(--ck-accessibility-help-dialog-code-background-color);
		padding: .4em;
		vertical-align: middle;
		line-height: 1;
		border-radius: 2px;
		text-align: center;
		font-size: .9em;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content code {
		font-family: monospace;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content kbd {
		min-width: 1.8em;
		box-shadow: 0px 1px 1px var(--ck-accessibility-help-dialog-kbd-shadow-color);
		margin: 0 1px;
	}
.ck.ck-accessibility-help-dialog .ck-accessibility-help-dialog__content kbd + kbd {
			margin-left: 2px;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class which indicates that an element holding it is disabled.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements a button of given background color.
 *
 * @param {String} \$background - Background color of the button.
 * @param {String} \$border - Border color of the button.
 */
:root {
	--ck-color-editable-blur-selection: hsl(0, 0%, 85%);
}
.ck.ck-editor__editable:not(.ck-editor__nested-editable) {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-editor__editable:not(.ck-editor__nested-editable), .ck.ck-editor__editable.ck-rounded-corners:not(.ck-editor__nested-editable) {
		border-radius: var(--ck-border-radius);
}
.ck.ck-editor__editable.ck-focused:not(.ck-editor__nested-editable) {
		/* Disable native outline. */
		outline: none;
		border: var(--ck-focus-ring);
		box-shadow: var(--ck-inner-shadow), 0 0;
	}
.ck.ck-editor__editable_inline {
	overflow: auto;
	padding: 0 var(--ck-spacing-standard);
	border: 1px solid transparent;
}
.ck.ck-editor__editable_inline[dir="ltr"] {
		text-align: left;
	}
.ck.ck-editor__editable_inline[dir="rtl"] {
		text-align: right;
	}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/116 */
.ck.ck-editor__editable_inline > *:first-child {
		margin-top: var(--ck-spacing-large);
	}
/* https://github.com/ckeditor/ckeditor5/issues/847 */
.ck.ck-editor__editable_inline > *:last-child {
		/*
		 * This value should match with the default margins of the block elements (like .media or .image)
		 * to avoid a content jumping when the fake selection container shows up (See https://github.com/ckeditor/ckeditor5/issues/9825).
		 */
		margin-bottom: var(--ck-spacing-large);
	}
/* https://github.com/ckeditor/ckeditor5/issues/6517 */
.ck.ck-editor__editable_inline.ck-blurred ::selection {
		background: var(--ck-color-editable-blur-selection);
	}
/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/111 */
.ck.ck-balloon-panel.ck-toolbar-container[class*="arrow_n"]::after {
		border-bottom-color: var(--ck-color-panel-background);
	}
.ck.ck-balloon-panel.ck-toolbar-container[class*="arrow_s"]::after {
		border-top-color: var(--ck-color-panel-background);
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-form-header-height: 44px;
}
.ck.ck-form__header {
	padding: var(--ck-spacing-small) var(--ck-spacing-large);
	height: var(--ck-form-header-height);
	line-height: var(--ck-form-header-height);
	border-bottom: 1px solid var(--ck-color-base-border);
}
[dir="ltr"] .ck.ck-form__header > .ck-icon {
			margin-right: var(--ck-spacing-medium);
	}
[dir="rtl"] .ck.ck-form__header > .ck-icon {
			margin-left: var(--ck-spacing-medium);
	}
.ck.ck-form__header .ck-form__header__label {
		--ck-font-size-base: 15px;
		font-weight: bold;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-icon-size: calc(var(--ck-line-height-base) * var(--ck-font-size-normal));
	--ck-icon-font-size: .8333350694em;
}
.ck.ck-icon {
	width: var(--ck-icon-size);
	height: var(--ck-icon-size);

	/* Multiplied by the height of the line in "px" should give SVG "viewport" dimensions */
	font-size: var(--ck-icon-font-size);

	/* Inherit cursor style (#5). */
	cursor: inherit;

	/* This will prevent blurry icons on Firefox. See #340. */
	will-change: transform;
}
.ck.ck-icon * {
		/* Inherit cursor style (#5). */
		cursor: inherit;
	}
/* Allows dynamic coloring of an icon by inheriting its color from the parent. */
.ck.ck-icon.ck-icon_inherit-color {
		color: inherit;
	}
.ck.ck-icon.ck-icon_inherit-color * {
			color: inherit;
		}
.ck.ck-icon.ck-icon_inherit-color *:not([fill]) {
				/* Needed by FF. */
				fill: currentColor;
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
:root {
	--ck-input-width: 18em;

	/* Backward compatibility. */
	--ck-input-text-width: var(--ck-input-width);
}
.ck.ck-input {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-input, .ck.ck-input.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-input {

	background: var(--ck-color-input-background);
	border: 1px solid var(--ck-color-input-border);
	padding: var(--ck-spacing-extra-tiny) var(--ck-spacing-medium);
	min-width: var(--ck-input-width);

	/* This is important to stay of the same height as surrounding buttons */
	min-height: var(--ck-ui-component-min-height);

	/* Apply some smooth transition to the box-shadow and border. */
	transition: box-shadow .1s ease-in-out, border .1s ease-in-out;
}
@media (prefers-reduced-motion: reduce) {
.ck.ck-input {
		transition: none;
}
	}
.ck.ck-input:focus {
		/* Disable native outline. */
		outline: none;
		border: var(--ck-focus-ring);
		box-shadow: var(--ck-focus-outer-shadow), 0 0;
	}
.ck.ck-input[readonly] {
		border: 1px solid var(--ck-color-input-disabled-border);
		background: var(--ck-color-input-disabled-background);
		color: var(--ck-color-input-disabled-text);
	}
.ck.ck-input[readonly]:focus {
			/* The read-only input should have a slightly less visible shadow when focused. */
			box-shadow: var(--ck-focus-disabled-outer-shadow), 0 0;
		}
.ck.ck-input.ck-error {
		border-color: var(--ck-color-input-error-border);
		animation: ck-input-shake .3s ease both;
	}
@media (prefers-reduced-motion: reduce) {
.ck.ck-input.ck-error {
			animation: none;
	}
		}
.ck.ck-input.ck-error:focus {
			box-shadow: var(--ck-focus-error-outer-shadow), 0 0;
		}
@keyframes ck-input-shake {
	20% {
		transform: translateX(-2px);
	}

	40% {
		transform: translateX(2px);
	}

	60% {
		transform: translateX(-1px);
	}

	80% {
		transform: translateX(1px);
	}
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-label {
	font-weight: bold;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
:root {
	--ck-labeled-field-view-transition: .1s cubic-bezier(0, 0, 0.24, 0.95);
	--ck-labeled-field-empty-unfocused-max-width: 100% - 2 * var(--ck-spacing-medium);
	--ck-labeled-field-label-default-position-x: var(--ck-spacing-medium);
	--ck-labeled-field-label-default-position-y: calc(0.6 * var(--ck-font-size-base));
	--ck-color-labeled-field-label-background: var(--ck-color-base-background);
}
.ck.ck-labeled-field-view {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-labeled-field-view, .ck.ck-labeled-field-view.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper {
		width: 100%;
	}
.ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
			top: 0px;
		}
[dir="ltr"] .ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
				left: 0px;
				transform-origin: 0 0;
				/* By default, display the label scaled down above the field. */
				transform: translate(var(--ck-spacing-medium), -6px) scale(.75);
		}
[dir="rtl"] .ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
				right: 0px;
				transform-origin: 100% 0;
				transform: translate(calc(-1 * var(--ck-spacing-medium)), -6px) scale(.75);
		}
.ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {

			pointer-events: none;

			background: var(--ck-color-labeled-field-label-background);
			padding: 0 calc(.5 * var(--ck-font-size-tiny));
			line-height: initial;
			font-weight: normal;

			/* Prevent overflow when the label is longer than the input */
			text-overflow: ellipsis;
			overflow: hidden;

			max-width: 100%;

			transition:
				transform var(--ck-labeled-field-view-transition),
				padding var(--ck-labeled-field-view-transition),
				background var(--ck-labeled-field-view-transition);
		}
@media (prefers-reduced-motion: reduce) {
.ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
				transition: none;
		}
			}
.ck.ck-labeled-field-view.ck-error > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
			color: var(--ck-color-base-error);
		}
.ck.ck-labeled-field-view.ck-error .ck-input:not([readonly]) + .ck.ck-label {
			color: var(--ck-color-base-error);
		}
.ck.ck-labeled-field-view .ck-labeled-field-view__status {
		font-size: var(--ck-font-size-small);
		margin-top: var(--ck-spacing-small);

		/* Let the info wrap to the next line to avoid stretching the layout horizontally.
		The status could be very long. */
		white-space: normal;
	}
.ck.ck-labeled-field-view .ck-labeled-field-view__status.ck-labeled-field-view__status_error {
			color: var(--ck-color-base-error);
		}
/* Disabled fields and fields that have no focus should fade out. */
.ck.ck-labeled-field-view.ck-disabled > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label,
	.ck.ck-labeled-field-view.ck-labeled-field-view_empty:not(.ck-labeled-field-view_focused) > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
		color: var(--ck-color-input-disabled-text);
	}
/* Fields that are disabled or not focused and without a placeholder should have full-sized labels. */
/* stylelint-disable-next-line no-descending-specificity */
[dir="ltr"] .ck.ck-labeled-field-view.ck-disabled.ck-labeled-field-view_empty:not(.ck-labeled-field-view_placeholder) > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label,
	[dir="ltr"] .ck.ck-labeled-field-view.ck-labeled-field-view_empty:not(.ck-labeled-field-view_focused):not(.ck-labeled-field-view_placeholder):not(.ck-error) > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
			transform: translate(var(--ck-labeled-field-label-default-position-x), var(--ck-labeled-field-label-default-position-y)) scale(1);
	}
[dir="rtl"] .ck.ck-labeled-field-view.ck-disabled.ck-labeled-field-view_empty:not(.ck-labeled-field-view_placeholder) > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label,
	[dir="rtl"] .ck.ck-labeled-field-view.ck-labeled-field-view_empty:not(.ck-labeled-field-view_focused):not(.ck-labeled-field-view_placeholder):not(.ck-error) > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {
			transform: translate(calc(-1 * var(--ck-labeled-field-label-default-position-x)), var(--ck-labeled-field-label-default-position-y)) scale(1);
	}
.ck.ck-labeled-field-view.ck-disabled.ck-labeled-field-view_empty:not(.ck-labeled-field-view_placeholder) > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label,
	.ck.ck-labeled-field-view.ck-labeled-field-view_empty:not(.ck-labeled-field-view_focused):not(.ck-labeled-field-view_placeholder):not(.ck-error) > .ck.ck-labeled-field-view__input-wrapper > .ck.ck-label {

		/* Compensate for the default translate position. */
		max-width: calc(var(--ck-labeled-field-empty-unfocused-max-width));

		background: transparent;
		padding: 0;
	}
/*------ DropdownView integration ----------------------------------------------------------------------------------- */
/* Make sure dropdown' background color in any of dropdown's state does not collide with labeled field. */
.ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper > .ck-dropdown > .ck.ck-button {
		background: transparent;
	}
/* When the dropdown is "empty", the labeled field label replaces its label. */
.ck.ck-labeled-field-view.ck-labeled-field-view_empty > .ck.ck-labeled-field-view__input-wrapper > .ck-dropdown > .ck-button > .ck-button__label {
		opacity: 0;
	}
/* Make sure the label of the empty, unfocused input does not cover the dropdown arrow. */
.ck.ck-labeled-field-view.ck-labeled-field-view_empty:not(.ck-labeled-field-view_focused):not(.ck-labeled-field-view_placeholder) > .ck.ck-labeled-field-view__input-wrapper > .ck-dropdown + .ck-label {
		max-width: calc(var(--ck-labeled-field-empty-unfocused-max-width) - var(--ck-dropdown-arrow-size) - var(--ck-spacing-standard));
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-labeled-input .ck-labeled-input__status {
	font-size: var(--ck-font-size-small);
	margin-top: var(--ck-spacing-small);

	/* Let the info wrap to the next line to avoid stretching the layout horizontally.
	The status could be very long. */
	white-space: normal;
}
.ck.ck-labeled-input .ck-labeled-input__status_error {
	color: var(--ck-color-base-error);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class which indicates that an element holding it is disabled.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-list {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-list, .ck.ck-list.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-list {

	list-style-type: none;
	background: var(--ck-color-list-background);

	/* A spacing at the beginning and end of the list */
	padding: var(--ck-spacing-small) 0;
}
.ck.ck-list__item {
	cursor: default;

	/* Almost as wide as menu bar items. */
	min-width: 15em;
}
.ck.ck-list__item > .ck-button:not(.ck-list-item-button) {
		padding: var(--ck-spacing-tiny) calc(2 * var(--ck-spacing-standard));
		min-height: unset;
		width: 100%;
		border-radius: 0;
	}
[dir="ltr"] .ck.ck-list__item > .ck-button:not(.ck-list-item-button) {
			text-align: left;
	}
[dir="rtl"] .ck.ck-list__item > .ck-button:not(.ck-list-item-button) {
			text-align: right;
	}
.ck.ck-list__item > .ck-button:not(.ck-list-item-button) .ck-button__label {
			/* https://github.com/ckeditor/ckeditor5-heading/issues/63 */
			line-height: calc(var(--ck-line-height-base) * var(--ck-font-size-base));
		}
.ck.ck-list__item > .ck-button:not(.ck-list-item-button):active {
			box-shadow: none;
		}
.ck.ck-list__item > .ck-button.ck-on:not(.ck-list-item-button) {
			background: var(--ck-color-list-button-on-background);
			color: var(--ck-color-list-button-on-text);
		}
.ck.ck-list__item > .ck-button.ck-on:not(.ck-list-item-button):active {
				box-shadow: none;
			}
.ck.ck-list__item > .ck-button.ck-on:not(.ck-list-item-button):hover:not(.ck-disabled) {
				background: var(--ck-color-list-button-on-background-focus);
			}
.ck.ck-list__item > .ck-button.ck-on:not(.ck-list-item-button):focus:not(.ck-disabled) {
				border-color: var(--ck-color-base-background);
			}
.ck.ck-list__item > .ck-button:not(.ck-list-item-button):hover:not(.ck-disabled) {
			background: var(--ck-color-list-button-hover-background);
		}
/* It's unnecessary to change the background/text of a switch toggle; it has different ways
	of conveying its state (like the switcher) */
.ck.ck-list__item > .ck-button.ck-switchbutton.ck-on {
			background: var(--ck-color-list-background);
			color: inherit;
		}
.ck.ck-list__item > .ck-button.ck-switchbutton.ck-on:hover:not(.ck-disabled) {
				background: var(--ck-color-list-button-hover-background);
				color: inherit;
			}
.ck-list .ck-list__group {
	padding-top: var(--ck-spacing-medium);

	/* Lists come with an inner vertical padding. Don't duplicate it. */
}
.ck-list .ck-list__group:first-child {
		padding-top: 0;
	}
/* The group should have a border when it's not the first item. */
*:not(.ck-hidden) ~ .ck-list .ck-list__group {
		border-top: 1px solid var(--ck-color-base-border);
	}
.ck-list .ck-list__group > .ck-label {
		font-size: 11px;
		font-weight: bold;
		padding: var(--ck-spacing-medium) var(--ck-spacing-large) 0;
	}
.ck.ck-list__separator {
	height: 1px;
	width: 100%;
	background: var(--ck-color-base-border);

	/* Give the separator some air */
	margin: var(--ck-spacing-small) 0;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-menu-bar {
	display: flex;
	flex-wrap: wrap;
	justify-content: flex-start;
	background: var(--ck-color-base-background);
	padding: var(--ck-spacing-small);
	gap: var(--ck-spacing-small);
	border: 1px solid var(--ck-color-toolbar-border);
	width: 100%;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-menu-bar__menu {
	/* Enable font size inheritance, which allows fluid UI scaling. */
	font-size: inherit;
}
.ck.ck-menu-bar__menu.ck-menu-bar__menu_top-level {
		max-width: 100%;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class which indicates that an element holding it is disabled.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements a button of given background color.
 *
 * @param {String} \$background - Background color of the button.
 * @param {String} \$border - Border color of the button.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
	 * All menu buttons.
	 */
.ck.ck-menu-bar__menu > .ck-menu-bar__menu__button {
		width: 100%;
	}
.ck.ck-menu-bar__menu > .ck-menu-bar__menu__button > .ck-button__label {
			flex-grow: 1;
			overflow: hidden;
			text-overflow: ellipsis;
		}
.ck.ck-menu-bar__menu > .ck-menu-bar__menu__button.ck-disabled > .ck-button__label {
			opacity: var(--ck-disabled-opacity);
		}
[dir="ltr"] .ck.ck-menu-bar__menu > .ck-menu-bar__menu__button:not(.ck-button_with-text) {
				padding-left: var(--ck-spacing-small);
			}
[dir="rtl"] .ck.ck-menu-bar__menu > .ck-menu-bar__menu__button:not(.ck-button_with-text) {
				padding-right: var(--ck-spacing-small);
			}
/*
	 * Top-level menu buttons only.
	 */
.ck.ck-menu-bar__menu.ck-menu-bar__menu_top-level > .ck-menu-bar__menu__button {
		padding: var(--ck-spacing-small) var(--ck-spacing-medium);
		min-height: unset;
	}
.ck.ck-menu-bar__menu.ck-menu-bar__menu_top-level > .ck-menu-bar__menu__button .ck-button__label {
			width: unset;
			line-height: unset;
		}
.ck.ck-menu-bar__menu.ck-menu-bar__menu_top-level > .ck-menu-bar__menu__button.ck-on {
			border-bottom-left-radius: 0;
			border-bottom-right-radius: 0;
		}
.ck.ck-menu-bar__menu.ck-menu-bar__menu_top-level > .ck-menu-bar__menu__button .ck-icon {
			display: none;
		}
/*
	 * Sub-menu buttons.
	 */
.ck.ck-menu-bar__menu:not(.ck-menu-bar__menu_top-level) .ck-menu-bar__menu__button {
		border-radius: 0;
	}
.ck.ck-menu-bar__menu:not(.ck-menu-bar__menu_top-level) .ck-menu-bar__menu__button > .ck-menu-bar__menu__button__arrow {
			width: var(--ck-dropdown-arrow-size);
		}
[dir="ltr"] .ck.ck-menu-bar__menu:not(.ck-menu-bar__menu_top-level) .ck-menu-bar__menu__button > .ck-menu-bar__menu__button__arrow {
				transform: rotate(-90deg);

				/* A space to accommodate the triangle. */
				margin-left: var(--ck-spacing-standard);

				/* Nudge the arrow gently to the right because its center of gravity is to the left */
				margin-right: calc(-1 * var(--ck-spacing-small));
		}
[dir="rtl"] .ck.ck-menu-bar__menu:not(.ck-menu-bar__menu_top-level) .ck-menu-bar__menu__button > .ck-menu-bar__menu__button__arrow {
				transform: rotate(90deg);

				left: var(--ck-spacing-standard);

				/* A space to accommodate the triangle. */
				margin-right: var(--ck-spacing-small);

				/* Nudge the arrow gently to the left because its center of gravity is to the right (after rotation). */
				margin-left: calc(-1 * var(--ck-spacing-small));
		}
.ck.ck-menu-bar__menu:not(.ck-menu-bar__menu_top-level) .ck-menu-bar__menu__button.ck-disabled > .ck-menu-bar__menu__button__arrow {
			opacity: var(--ck-disabled-opacity);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-menu-bar-menu-item-min-width: 18em;
}
.ck.ck-menu-bar__menu .ck.ck-menu-bar__menu__item {
	min-width: var(--ck-menu-bar-menu-item-min-width);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
	 * List item buttons.
	 */
.ck.ck-menu-bar__menu .ck-button.ck-menu-bar__menu__item__button {
		border-radius: 0;
	}
.ck.ck-menu-bar__menu .ck-button.ck-menu-bar__menu__item__button > .ck-spinner-container,
		.ck.ck-menu-bar__menu .ck-button.ck-menu-bar__menu__item__button > .ck-spinner-container .ck-spinner {
			/* These styles correspond to .ck-icon so that the spinner seamlessly replaces the icon. */
			--ck-toolbar-spinner-size: 20px;
		}
.ck.ck-menu-bar__menu .ck-button.ck-menu-bar__menu__item__button > .ck-spinner-container {
			/* This ensures margins corresponding to the .ck-icon. */
			font-size: var(--ck-icon-font-size);
		}
[dir="ltr"] .ck.ck-menu-bar__menu .ck-button.ck-menu-bar__menu__item__button > .ck-spinner-container {
				margin-right: var(--ck-spacing-medium);
		}
[dir="rtl"] .ck.ck-menu-bar__menu .ck-button.ck-menu-bar__menu__item__button > .ck-spinner-container {
				margin-left: var(--ck-spacing-medium);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
:root {
	--ck-menu-bar-menu-panel-max-width: 75vw;
}
.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel, .ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel {
	box-shadow: var(--ck-drop-shadow), 0 0;

	background: var(--ck-color-dropdown-panel-background);
	border: 1px solid var(--ck-color-dropdown-panel-border);
	bottom: 0;
	height: fit-content;
	max-width: var(--ck-menu-bar-menu-panel-max-width);

	/* Corner border radius consistent with the button. */
}
.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_es,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_se {
		border-top-left-radius: 0;
	}
.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_ws,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_sw {
		border-top-right-radius: 0;
	}
.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_en,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_ne {
		border-bottom-left-radius: 0;
	}
.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_wn,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_nw {
		border-bottom-right-radius: 0;
	}
.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel:focus {
		outline: none;
	}
.ck.ck-menu-bar .ck-list-item-button:focus,
		.ck.ck-menu-bar .ck-list-item-button:active {
			border-color: transparent;
			box-shadow: none;
		}
.ck.ck-menu-bar.ck-menu-bar_focus-border-enabled .ck-list-item-button:focus,
		.ck.ck-menu-bar.ck-menu-bar_focus-border-enabled .ck-list-item-button:active {
			/* Fix truncated shadows due to rendering order. */
			position: relative;
			z-index: 2;

			/* Disable native outline. */

			outline: none;

			border: var(--ck-focus-ring);
			box-shadow: var(--ck-focus-outer-shadow), 0 0;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
:root {
	--ck-balloon-border-width: 1px;
	--ck-balloon-arrow-offset: 2px;
	--ck-balloon-arrow-height: 10px;
	--ck-balloon-arrow-half-width: 8px;
	--ck-balloon-arrow-drop-shadow: 0 2px 2px var(--ck-color-shadow-drop);
}
.ck.ck-balloon-panel {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-balloon-panel, .ck.ck-balloon-panel.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-balloon-panel {
	box-shadow: var(--ck-drop-shadow), 0 0;

	min-height: 15px;

	background: var(--ck-color-panel-background);
	border: var(--ck-balloon-border-width) solid var(--ck-color-panel-border);
}
.ck.ck-balloon-panel.ck-balloon-panel_with-arrow::before,
		.ck.ck-balloon-panel.ck-balloon-panel_with-arrow::after {
			width: 0;
			height: 0;
			border-style: solid;
		}
.ck.ck-balloon-panel[class*="arrow_n"]::before,
		.ck.ck-balloon-panel[class*="arrow_n"]::after {
			border-width: 0 var(--ck-balloon-arrow-half-width) var(--ck-balloon-arrow-height) var(--ck-balloon-arrow-half-width);
		}
.ck.ck-balloon-panel[class*="arrow_n"]::before {
			border-color: transparent transparent var(--ck-color-panel-border) transparent;
			margin-top: calc( -1 * var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel[class*="arrow_n"]::after {
			border-color: transparent transparent var(--ck-color-panel-background) transparent;
			margin-top: calc( var(--ck-balloon-arrow-offset) - var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel[class*="arrow_s"]::before,
		.ck.ck-balloon-panel[class*="arrow_s"]::after {
			border-width: var(--ck-balloon-arrow-height) var(--ck-balloon-arrow-half-width) 0 var(--ck-balloon-arrow-half-width);
		}
.ck.ck-balloon-panel[class*="arrow_s"]::before {
			border-color: var(--ck-color-panel-border) transparent transparent;
			filter: drop-shadow(var(--ck-balloon-arrow-drop-shadow));
			margin-bottom: calc( -1 * var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel[class*="arrow_s"]::after {
			border-color: var(--ck-color-panel-background) transparent transparent transparent;
			margin-bottom: calc( var(--ck-balloon-arrow-offset) - var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel[class*="arrow_e"]::before,
		.ck.ck-balloon-panel[class*="arrow_e"]::after {
			border-width: var(--ck-balloon-arrow-half-width) 0 var(--ck-balloon-arrow-half-width) var(--ck-balloon-arrow-height);
		}
.ck.ck-balloon-panel[class*="arrow_e"]::before {
			border-color: transparent transparent transparent var(--ck-color-panel-border);
			margin-right: calc( -1 * var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel[class*="arrow_e"]::after {
			border-color: transparent transparent transparent var(--ck-color-panel-background);
			margin-right: calc( var(--ck-balloon-arrow-offset) - var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel[class*="arrow_w"]::before,
		.ck.ck-balloon-panel[class*="arrow_w"]::after {
			border-width: var(--ck-balloon-arrow-half-width) var(--ck-balloon-arrow-height) var(--ck-balloon-arrow-half-width) 0;
		}
.ck.ck-balloon-panel[class*="arrow_w"]::before {
			border-color: transparent var(--ck-color-panel-border) transparent transparent;
			margin-left: calc( -1 * var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel[class*="arrow_w"]::after {
			border-color: transparent var(--ck-color-panel-background) transparent transparent;
			margin-left: calc( var(--ck-balloon-arrow-offset) - var(--ck-balloon-border-width) );
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_n::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_n::after {
			left: 50%;
			margin-left: calc(-1 * var(--ck-balloon-arrow-half-width));
			top: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_nw::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_nw::after {
			left: calc(2 * var(--ck-balloon-arrow-half-width));
			top: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_ne::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_ne::after {
			right: calc(2 * var(--ck-balloon-arrow-half-width));
			top: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_s::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_s::after {
			left: 50%;
			margin-left: calc(-1 * var(--ck-balloon-arrow-half-width));
			bottom: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_sw::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_sw::after {
			left: calc(2 * var(--ck-balloon-arrow-half-width));
			bottom: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_se::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_se::after {
			right: calc(2 * var(--ck-balloon-arrow-half-width));
			bottom: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_sme::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_sme::after {
			right: 25%;
			margin-right: calc(2 * var(--ck-balloon-arrow-half-width));
			bottom: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_smw::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_smw::after {
			left: 25%;
			margin-left: calc(2 * var(--ck-balloon-arrow-half-width));
			bottom: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_nme::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_nme::after {
			right: 25%;
			margin-right: calc(2 * var(--ck-balloon-arrow-half-width));
			top: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_nmw::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_nmw::after {
			left: 25%;
			margin-left: calc(2 * var(--ck-balloon-arrow-half-width));
			top: calc(-1 * var(--ck-balloon-arrow-height));
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_e::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_e::after {
			right: calc(-1 * var(--ck-balloon-arrow-height));
			margin-top: calc(-1 * var(--ck-balloon-arrow-half-width));
			top: 50%;
		}
.ck.ck-balloon-panel.ck-balloon-panel_arrow_w::before,
		.ck.ck-balloon-panel.ck-balloon-panel_arrow_w::after {
			left: calc(-1 * var(--ck-balloon-arrow-height));
			margin-top: calc(-1 * var(--ck-balloon-arrow-half-width));
			top: 50%;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck .ck-balloon-rotator__navigation {
	background: var(--ck-color-toolbar-background);
	border-bottom: 1px solid var(--ck-color-toolbar-border);
	padding: 0 var(--ck-spacing-small);

	/* Let's keep similar appearance to \`ck-toolbar\`. */
}
.ck .ck-balloon-rotator__navigation > * {
		margin-right: var(--ck-spacing-small);
		margin-top: var(--ck-spacing-small);
		margin-bottom: var(--ck-spacing-small);
	}
/* Gives counter more breath than buttons. */
.ck .ck-balloon-rotator__navigation .ck-balloon-rotator__counter {
		margin-right: var(--ck-spacing-standard);

		/* We need to use smaller margin because of previous button's right margin. */
		margin-left: var(--ck-spacing-small);
	}
/* Disable default annotation shadow inside rotator with fake panels. */
.ck .ck-balloon-rotator__content .ck.ck-annotation-wrapper {
		box-shadow: none;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
:root {
	--ck-balloon-fake-panel-offset-horizontal: 6px;
	--ck-balloon-fake-panel-offset-vertical: 6px;
}
/* Let's use \`.ck-balloon-panel\` appearance. See: balloonpanel.css. */
.ck .ck-fake-panel div {
	box-shadow: var(--ck-drop-shadow), 0 0;

	min-height: 15px;

	background: var(--ck-color-panel-background);
	border: 1px solid var(--ck-color-panel-border);
	border-radius: var(--ck-border-radius);

	width: 100%;
	height: 100%;
}
.ck .ck-fake-panel div:nth-child( 1 ) {
	margin-left: var(--ck-balloon-fake-panel-offset-horizontal);
	margin-top: var(--ck-balloon-fake-panel-offset-vertical);
}
.ck .ck-fake-panel div:nth-child( 2 ) {
	margin-left: calc(var(--ck-balloon-fake-panel-offset-horizontal) * 2);
	margin-top: calc(var(--ck-balloon-fake-panel-offset-vertical) * 2);
}
.ck .ck-fake-panel div:nth-child( 3 ) {
	margin-left: calc(var(--ck-balloon-fake-panel-offset-horizontal) * 3);
	margin-top: calc(var(--ck-balloon-fake-panel-offset-vertical) * 3);
}
/* If balloon is positioned above element, we need to move fake panel to the top. */
.ck .ck-balloon-panel_arrow_s + .ck-fake-panel,
.ck .ck-balloon-panel_arrow_se + .ck-fake-panel,
.ck .ck-balloon-panel_arrow_sw + .ck-fake-panel {
	--ck-balloon-fake-panel-offset-vertical: -6px;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
.ck.ck-sticky-panel .ck-sticky-panel__content_sticky {
		box-shadow: var(--ck-drop-shadow), 0 0;

		border-width: 0 1px 1px;
		border-top-left-radius: 0;
		border-top-right-radius: 0;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck-vertical-form > .ck-button:nth-last-child(2)::after {
	border-right: 1px solid var(--ck-color-base-border);
}
.ck.ck-responsive-form {
	padding: var(--ck-spacing-large);
}
.ck.ck-responsive-form:focus {
		/* See: https://github.com/ckeditor/ckeditor5/issues/4773 */
		outline: none;
	}
[dir="ltr"] .ck.ck-responsive-form > :not(:first-child) {
			margin-left: var(--ck-spacing-standard);
		}
[dir="rtl"] .ck.ck-responsive-form > :not(:last-child) {
			margin-left: var(--ck-spacing-standard);
		}
@media screen and (max-width: 600px) {
.ck.ck-responsive-form {
		padding: 0;
		width: calc(.8 * var(--ck-input-width));
}

		.ck.ck-responsive-form .ck-labeled-field-view {
			margin: var(--ck-spacing-large) var(--ck-spacing-large) 0;
		}

			.ck.ck-responsive-form .ck-labeled-field-view .ck-input-text,
			.ck.ck-responsive-form .ck-labeled-field-view .ck-input-number {
				min-width: 0;
				width: 100%;
			}

			/* Let the long error messages wrap in the narrow form. */
			.ck.ck-responsive-form .ck-labeled-field-view .ck-labeled-field-view__error {
				white-space: normal;
			}

		/* Styles for two last buttons in the form (save&cancel, edit&unlink, etc.). */
			.ck.ck-responsive-form > .ck-button:nth-last-child(2)::after {
				border-right: 1px solid var(--ck-color-base-border);
			}

		.ck.ck-responsive-form > .ck-button:nth-last-child(1),
		.ck.ck-responsive-form > .ck-button:nth-last-child(2) {
			padding: var(--ck-spacing-standard);
			margin-top: var(--ck-spacing-large);
			border-radius: 0;
		}

			.ck.ck-responsive-form > .ck-button:nth-last-child(1):not(:focus), .ck.ck-responsive-form > .ck-button:nth-last-child(2):not(:focus) {
				border-top: 1px solid var(--ck-color-base-border);
			}

		[dir="ltr"] .ck.ck-responsive-form > .ck-button:nth-last-child(1),
		[dir="ltr"] .ck.ck-responsive-form > .ck-button:nth-last-child(2) {
				margin-left: 0;
		}

		[dir="rtl"] .ck.ck-responsive-form > .ck-button:nth-last-child(1),
		[dir="rtl"] .ck.ck-responsive-form > .ck-button:nth-last-child(2) {
				margin-left: 0;
		}

				[dir="rtl"] .ck.ck-responsive-form > .ck-button:nth-last-child(1):last-of-type, [dir="rtl"] .ck.ck-responsive-form > .ck-button:nth-last-child(2):last-of-type {
					border-right: 1px solid var(--ck-color-base-border);
				}
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-search-field-view-horizontal-spacing: calc(var(--ck-icon-size) + var(--ck-spacing-medium));
}
.ck.ck-search > .ck-labeled-field-view .ck-input {
			width: 100%;
		}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-icon {
			--ck-labeled-field-label-default-position-x: var(--ck-search-field-view-horizontal-spacing);
		}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-icon > .ck-labeled-field-view__input-wrapper > .ck-icon {
				opacity: .5;
				pointer-events: none;
			}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-icon .ck-input {
				width: 100%;
			}
[dir="ltr"] .ck.ck-search > .ck-labeled-field-view.ck-search__query_with-icon .ck-input {
					padding-left: var(--ck-search-field-view-horizontal-spacing);
			}
[dir="rtl"] .ck.ck-search > .ck-labeled-field-view.ck-search__query_with-icon .ck-input:not(.ck-input-text_empty) {
						padding-left: var(--ck-search-field-view-horizontal-spacing);
					}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset {
			--ck-labeled-field-empty-unfocused-max-width: 100% - 2 * var(--ck-search-field-view-horizontal-spacing);
		}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset.ck-labeled-field-view_empty {
				--ck-labeled-field-empty-unfocused-max-width: 100% - var(--ck-search-field-view-horizontal-spacing) - var(--ck-spacing-medium);
			}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset .ck-search__reset {
				min-width: auto;
				min-height: auto;

				background: none;
				opacity: .5;
				padding: 0;
			}
[dir="ltr"] .ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset .ck-search__reset {
					right: var(--ck-spacing-medium);
			}
[dir="rtl"] .ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset .ck-search__reset {
					left: var(--ck-spacing-medium);
			}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset .ck-search__reset:hover {
					opacity: 1;
				}
.ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset .ck-input {
				width: 100%;
			}
[dir="ltr"] .ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset .ck-input:not(.ck-input-text_empty) {
						padding-right: var(--ck-search-field-view-horizontal-spacing);
					}
[dir="rtl"] .ck.ck-search > .ck-labeled-field-view.ck-search__query_with-reset .ck-input {
					padding-right: var(--ck-search-field-view-horizontal-spacing);
			}
.ck.ck-search > .ck-search__results {
		min-width: 100%;
	}
.ck.ck-search > .ck-search__results > .ck-search__info {
			width: 100%;
			padding: var(--ck-spacing-medium) var(--ck-spacing-large);
		}
.ck.ck-search > .ck-search__results > .ck-search__info * {
				white-space: normal;
			}
.ck.ck-search > .ck-search__results > .ck-search__info > span:first-child {
				font-weight: bold;
			}
.ck.ck-search > .ck-search__results > .ck-search__info > span:last-child {
				margin-top: var(--ck-spacing-medium);
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-toolbar-spinner-size: 18px;
}
.ck.ck-spinner-container {
	width: var(--ck-toolbar-spinner-size);
	height: var(--ck-toolbar-spinner-size);
	animation: 1.5s infinite ck-spinner-rotate linear;
}
@media (prefers-reduced-motion: reduce) {
.ck.ck-spinner-container {
		animation-duration: 3s;
}
	}
.ck.ck-spinner {
	width: var(--ck-toolbar-spinner-size);
	height: var(--ck-toolbar-spinner-size);
	border-radius: 50%;
	border: 2px solid var(--ck-color-text);
	border-top-color: transparent;
}
@keyframes ck-spinner-rotate {
	to {
		transform: rotate(360deg)
	}
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * This fixes a problem in Firefox when the initial height of the complement does not match the number of rows.
 * This bug is especially visible when rows=1.
 */
.ck-textarea {
	overflow-x: hidden
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-block-toolbar-button: var(--ck-color-text);
	--ck-block-toolbar-button-size: var(--ck-font-size-normal);
}
.ck.ck-block-toolbar-button {
	color: var(--ck-color-block-toolbar-button);
	font-size: var(--ck-block-toolbar-size);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-toolbar {
	border-radius: 0;
}
.ck-rounded-corners .ck.ck-toolbar, .ck.ck-toolbar.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
}
.ck.ck-toolbar {

	background: var(--ck-color-toolbar-background);
	padding: 0 var(--ck-spacing-small);
	border: 1px solid var(--ck-color-toolbar-border);
}
.ck.ck-toolbar .ck.ck-toolbar__separator {
		height: var(--ck-icon-size);
		width: 1px;
		min-width: 1px;
		background: var(--ck-color-toolbar-border);

		/*
		 * These margins make the separators look better in balloon toolbars (when aligned with the "tip").
		 * See https://github.com/ckeditor/ckeditor5/issues/7493.
		 */
		margin-top: var(--ck-spacing-small);
		margin-bottom: var(--ck-spacing-small);
	}
.ck.ck-toolbar .ck-toolbar__line-break {
		height: 0;
	}
.ck.ck-toolbar > .ck-toolbar__items > *:not(.ck-toolbar__line-break) {
			/* (#11) Separate toolbar items. */
			margin-right: var(--ck-spacing-small);
		}
/* Don't display a separator after an empty items container, for instance,
		when all items were grouped */
.ck.ck-toolbar > .ck-toolbar__items:empty + .ck.ck-toolbar__separator {
			display: none;
		}
.ck.ck-toolbar > .ck-toolbar__items > *:not(.ck-toolbar__line-break),
	.ck.ck-toolbar > .ck.ck-toolbar__grouped-dropdown {
		/* Make sure items wrapped to the next line have v-spacing */
		margin-top: var(--ck-spacing-small);
		margin-bottom: var(--ck-spacing-small);
	}
.ck.ck-toolbar.ck-toolbar_vertical {
		/* Items in a vertical toolbar span the entire width. */
		padding: 0;

		/* Specificity matters here. See https://github.com/ckeditor/ckeditor5-theme-lark/issues/168. */
	}
.ck.ck-toolbar.ck-toolbar_vertical > .ck-toolbar__items > .ck {
			/* Items in a vertical toolbar should span the horizontal space. */
			width: 100%;

			/* Items in a vertical toolbar should have no margin. */
			margin: 0;

			/* Items in a vertical toolbar span the entire width so rounded corners are pointless. */
			border-radius: 0;
		}
.ck.ck-toolbar.ck-toolbar_compact {
		/* No spacing around items. */
		padding: 0;
	}
.ck.ck-toolbar.ck-toolbar_compact > .ck-toolbar__items > * {
			/* Compact toolbar items have no spacing between them. */
			margin: 0;

			/* "Middle" children should have no rounded corners. */
		}
.ck.ck-toolbar.ck-toolbar_compact > .ck-toolbar__items > *:not(:first-child):not(:last-child) {
				border-radius: 0;
			}
/*
		 * Dropdown button has asymmetric padding to fit the arrow.
		 * This button has no arrow so let's revert that padding back to normal.
		 */
.ck.ck-toolbar > .ck.ck-toolbar__grouped-dropdown > .ck.ck-button.ck-dropdown__button {
			padding-left: var(--ck-spacing-tiny);
		}
/* A drop-down containing the nested toolbar with configured items. */
/* Prevent empty space in the panel when the dropdown label is visible and long but the toolbar has few items. */
.ck.ck-toolbar .ck-toolbar__nested-toolbar-dropdown > .ck-dropdown__panel {
			min-width: auto;
		}
.ck.ck-toolbar .ck-toolbar__nested-toolbar-dropdown > .ck-button > .ck-button__label {
			max-width: 7em;
			width: auto;
		}
.ck.ck-toolbar:focus {
		outline: none;
	}
.ck-toolbar-container .ck.ck-toolbar {
		border: 0;
}
/* stylelint-disable */
/*
 * Styles for RTL toolbars.
 *
 * Note: In some cases (e.g. a decoupled editor), the toolbar has its own "dir"
 * because its parent is not controlled by the editor framework.
 */
[dir="rtl"] .ck.ck-toolbar > .ck-toolbar__items > .ck, .ck.ck-toolbar[dir="rtl"] > .ck-toolbar__items > .ck {
		margin-right: 0;
	}
[dir="rtl"] .ck.ck-toolbar:not(.ck-toolbar_compact) > .ck-toolbar__items > .ck, .ck.ck-toolbar[dir="rtl"]:not(.ck-toolbar_compact) > .ck-toolbar__items > .ck {
		/* (#11) Separate toolbar items. */
		margin-left: var(--ck-spacing-small);
	}
[dir="rtl"] .ck.ck-toolbar > .ck-toolbar__items > .ck:last-child, .ck.ck-toolbar[dir="rtl"] > .ck-toolbar__items > .ck:last-child {
		margin-left: 0;
	}
/* No rounded corners on the right side of the first child. */
[dir="rtl"] .ck.ck-toolbar.ck-toolbar_compact > .ck-toolbar__items > .ck:first-child, .ck.ck-toolbar.ck-toolbar_compact[dir="rtl"] > .ck-toolbar__items > .ck:first-child {
			border-top-left-radius: 0;
			border-bottom-left-radius: 0;
		}
/* No rounded corners on the left side of the last child. */
[dir="rtl"] .ck.ck-toolbar.ck-toolbar_compact > .ck-toolbar__items > .ck:last-child, .ck.ck-toolbar.ck-toolbar_compact[dir="rtl"] > .ck-toolbar__items > .ck:last-child {
			border-top-right-radius: 0;
			border-bottom-right-radius: 0;
		}
/* Separate the the separator form the grouping dropdown when some items are grouped. */
[dir="rtl"] .ck.ck-toolbar > .ck.ck-toolbar__separator, .ck.ck-toolbar[dir="rtl"] > .ck.ck-toolbar__separator {
		margin-left: var(--ck-spacing-small);
	}
/* Some spacing between the items and the separator before the grouped items dropdown. */
[dir="rtl"] .ck.ck-toolbar.ck-toolbar_grouping > .ck-toolbar__items:not(:empty):not(:only-child), .ck.ck-toolbar.ck-toolbar_grouping[dir="rtl"] > .ck-toolbar__items:not(:empty):not(:only-child) {
		margin-left: var(--ck-spacing-small);
	}
/*
 * Styles for LTR toolbars.
 *
 * Note: In some cases (e.g. a decoupled editor), the toolbar has its own "dir"
 * because its parent is not controlled by the editor framework.
 */
[dir="ltr"] .ck.ck-toolbar > .ck-toolbar__items > .ck:last-child, .ck.ck-toolbar[dir="ltr"] > .ck-toolbar__items > .ck:last-child {
		margin-right: 0;
	}
/* No rounded corners on the right side of the first child. */
[dir="ltr"] .ck.ck-toolbar.ck-toolbar_compact > .ck-toolbar__items > .ck:first-child, .ck.ck-toolbar.ck-toolbar_compact[dir="ltr"] > .ck-toolbar__items > .ck:first-child {
			border-top-right-radius: 0;
			border-bottom-right-radius: 0;
		}
/* No rounded corners on the left side of the last child. */
[dir="ltr"] .ck.ck-toolbar.ck-toolbar_compact > .ck-toolbar__items > .ck:last-child, .ck.ck-toolbar.ck-toolbar_compact[dir="ltr"] > .ck-toolbar__items > .ck:last-child {
			border-top-left-radius: 0;
			border-bottom-left-radius: 0;
		}
/* Separate the the separator form the grouping dropdown when some items are grouped. */
[dir="ltr"] .ck.ck-toolbar > .ck.ck-toolbar__separator, .ck.ck-toolbar[dir="ltr"] > .ck.ck-toolbar__separator {
		margin-right: var(--ck-spacing-small);
	}
/* Some spacing between the items and the separator before the grouped items dropdown. */
[dir="ltr"] .ck.ck-toolbar.ck-toolbar_grouping > .ck-toolbar__items:not(:empty):not(:only-child), .ck.ck-toolbar.ck-toolbar_grouping[dir="ltr"] > .ck-toolbar__items:not(:empty):not(:only-child) {
		margin-right: var(--ck-spacing-small);
	}
/* stylelint-enable */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
.ck.ck-balloon-panel.ck-tooltip {
	--ck-balloon-border-width: 0px;
	--ck-balloon-arrow-offset: 0px;
	--ck-balloon-arrow-half-width: 4px;
	--ck-balloon-arrow-height: 4px;
	--ck-tooltip-text-padding: 4px;
	--ck-color-panel-background: var(--ck-color-tooltip-background);

	padding: 0 var(--ck-spacing-medium);

	/* Reset balloon panel styles */
	box-shadow: none;
}
.ck.ck-balloon-panel.ck-tooltip .ck-tooltip__text {
		font-size: .9em;
		line-height: 1.5;
		color: var(--ck-color-tooltip-text);
	}
.ck.ck-balloon-panel.ck-tooltip.ck-tooltip_multi-line .ck-tooltip__text {
		white-space: break-spaces;
		display: inline-block;
		padding: var(--ck-tooltip-text-padding) 0;
		max-width: 200px;
	}
/* Hide the default shadow of the .ck-balloon-panel tip */
.ck.ck-balloon-panel.ck-tooltip::before {
		display: none;
	}

/* Editor */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
.ck.ck-editor__top .ck-sticky-panel .ck-sticky-panel__content {
			border-radius: 0;
		}
.ck-rounded-corners .ck.ck-editor__top .ck-sticky-panel .ck-sticky-panel__content, .ck.ck-editor__top .ck-sticky-panel .ck-sticky-panel__content.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
				border-bottom-left-radius: 0;
				border-bottom-right-radius: 0;
		}
.ck.ck-editor__top .ck-sticky-panel .ck-sticky-panel__content {

			border: 1px solid var(--ck-color-base-border);
			border-bottom-width: 0;
		}
.ck.ck-editor__top .ck-sticky-panel .ck-sticky-panel__content.ck-sticky-panel__content_sticky {
				border-bottom-width: 1px;
			}
.ck.ck-editor__top .ck-sticky-panel .ck-sticky-panel__content .ck-menu-bar {
				border: 0;
				border-bottom: 1px solid var(--ck-color-base-border);
			}
.ck.ck-editor__top .ck-sticky-panel .ck-sticky-panel__content .ck-toolbar {
				border: 0;
			}
/* Note: Use ck-editor__main to make sure these styles don't apply to other editor types */
.ck.ck-editor__main > .ck-editor__editable {
	/* https://github.com/ckeditor/ckeditor5-theme-lark/issues/113 */
	background: var(--ck-color-base-background);

	border-radius: 0;
}
.ck-rounded-corners .ck.ck-editor__main > .ck-editor__editable, .ck.ck-editor__main > .ck-editor__editable.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
		border-top-left-radius: 0;
		border-top-right-radius: 0;
}
.ck.ck-editor__main > .ck-editor__editable:not(.ck-focused) {
		border-color: var(--ck-color-base-border);
	}

/* Plugins */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-clipboard-drop-target-dot-width: 12px;
	--ck-clipboard-drop-target-dot-height: 8px;
	--ck-clipboard-drop-target-color: var(--ck-color-focus-border);
}
/*
	 * Vertical drop target (in text).
	 */
.ck.ck-editor__editable .ck.ck-clipboard-drop-target-position span {
			bottom: calc(-.5 * var(--ck-clipboard-drop-target-dot-height));
			top: calc(-.5 * var(--ck-clipboard-drop-target-dot-height));
			border: 1px solid var(--ck-clipboard-drop-target-color);
			background: var(--ck-clipboard-drop-target-color);
			margin-left: -1px;

			/* The triangle above the marker */
		}
.ck.ck-editor__editable .ck.ck-clipboard-drop-target-position span::after {
				content: '';
				width: 0;
				height: 0;

				display: block;
				position: absolute;
				left: 50%;
				top: calc(-.5 * var(--ck-clipboard-drop-target-dot-height));

				transform: translateX(-50%);
				border-color: var(--ck-clipboard-drop-target-color) transparent transparent transparent;
				border-width: calc(var(--ck-clipboard-drop-target-dot-height)) calc(.5 * var(--ck-clipboard-drop-target-dot-width)) 0 calc(.5 * var(--ck-clipboard-drop-target-dot-width));
				border-style: solid;
			}
/*
	 * Styles of the widget that it a drop target.
	 */
.ck.ck-editor__editable .ck-widget.ck-clipboard-drop-target-range {
		outline: var(--ck-widget-outline-thickness) solid var(--ck-clipboard-drop-target-color) !important;
	}
/*
	 * Styles of the widget being dragged (its preview).
	 */
.ck.ck-editor__editable .ck-widget:-webkit-drag {
		zoom: 0.6;
		outline: none !important;
	}
.ck.ck-clipboard-drop-target-line {
	height: 0;
	border: 1px solid var(--ck-clipboard-drop-target-color);
	background: var(--ck-clipboard-drop-target-color);
	margin-top: -1px;
}
.ck.ck-clipboard-drop-target-line::before {
		content: '';
		position: absolute;
		top: calc(-.5 * var(--ck-clipboard-drop-target-dot-width));
		width: 0;
		height: 0;
		border-style: solid;
	}
[dir="ltr"] .ck.ck-clipboard-drop-target-line::before {
			left: -1px;

			border-width: calc(.5 * var(--ck-clipboard-drop-target-dot-width)) 0 calc(.5 * var(--ck-clipboard-drop-target-dot-width)) var(--ck-clipboard-drop-target-dot-height);
			border-color: transparent transparent transparent var(--ck-clipboard-drop-target-color);
	}
[dir="rtl"] .ck.ck-clipboard-drop-target-line::before {
			right: -1px;

			border-width:calc(.5 * var(--ck-clipboard-drop-target-dot-width)) var(--ck-clipboard-drop-target-dot-height) calc(.5 * var(--ck-clipboard-drop-target-dot-width)) 0;
			border-color: transparent var(--ck-clipboard-drop-target-color) transparent transparent;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-code-block-label-background: hsl(0, 0%, 46%);
}
.ck.ck-editor__editable pre[data-language]::after {
	top: -1px;
	right: 10px;
	background: var(--ck-color-code-block-label-background);

	font-size: 10px;
	font-family: var(--ck-font-face);
	line-height: 16px;
	padding: var(--ck-spacing-tiny) var(--ck-spacing-medium);
	color: hsl(0, 0%, 100%);
	white-space: nowrap;
}
.ck.ck-code-block-dropdown .ck-dropdown__panel {
	/* There could be dozens of languages available. Use scroll to prevent a 10e6px dropdown. */
	max-height: 250px;
	overflow-y: auto;
	overflow-x: hidden;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* See ckeditor/ckeditor5#936. */
@media (forced-colors: active) {
		.ck.ck-placeholder, .ck .ck-placeholder {
		/*
		 * This is needed for Edge on Windows to use the right color for the placeholder content (::before).
		 * See https://github.com/ckeditor/ckeditor5/issues/14907.
		 */
		forced-color-adjust: preserve-parent-color;
		}
	}
.ck.ck-placeholder::before, .ck .ck-placeholder::before {
		cursor: text;
	}
@media (forced-colors: none) {
		.ck.ck-placeholder::before, .ck .ck-placeholder::before {
			color: var(--ck-color-engine-placeholder-text);
		}
	}
@media (forced-colors: active) {
		.ck.ck-placeholder::before, .ck .ck-placeholder::before {
			/*
			 * In the high contrast mode there is no telling between regular and placeholder text. Using
			 * italic text to address that issue. See https://github.com/ckeditor/ckeditor5/issues/14907.
			 */
			font-style: italic;

			/*
			 * Without this margin, the caret will not show up and blink when the user puts the selection
			 * in the placeholder (Edge on Windows). See https://github.com/ckeditor/ckeditor5/issues/14907.
			 */
			margin-left: 1px;
		}
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-find-and-replace-form {
	width: 400px;

	/*
	 * The <form> needs tabindex="-1" for proper Esc handling after being clicked
	 * but the side effect is that this creates a nasty focus outline in some browsers.
	 */
}
.ck.ck-find-and-replace-form:focus {
		outline: none;
	}
/* Generic styles for the form inputs and actions. */
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs,
	.ck.ck-find-and-replace-form .ck-find-and-replace-form__actions {
		flex: 1 1 auto;
		flex-direction: row;
		flex-wrap: wrap;
		align-items: center;
		align-content: stretch;

		padding: var(--ck-spacing-large);
		margin: 0;

	}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > .ck-button, .ck.ck-find-and-replace-form .ck-find-and-replace-form__actions > .ck-button {
			flex: 0 0 auto;
		}
[dir="ltr"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > * + *, [dir="ltr"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__actions > * + * {
				margin-left: var(--ck-spacing-standard);
			}
[dir="rtl"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > * + *, [dir="rtl"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__actions > * + * {
				margin-right: var(--ck-spacing-standard);
			}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs .ck-labeled-field-view, .ck.ck-find-and-replace-form .ck-find-and-replace-form__actions .ck-labeled-field-view {
			flex: 1 1 auto;
		}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs .ck-labeled-field-view .ck-input, .ck.ck-find-and-replace-form .ck-find-and-replace-form__actions .ck-labeled-field-view .ck-input {
				width: 100%;
				min-width: 50px;
			}
/* Styles specific for inputs area. */
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs {
		/* To display all controls in line when there's an error under the input */
		align-items: flex-start;
	}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > .ck-button-prev > .ck-icon {
			transform: rotate(90deg);
		}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > .ck-button-next > .ck-icon {
			transform: rotate(-90deg);
		}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs .ck-results-counter {
			top: 50%;
			transform: translateY(-50%);
		}
[dir="ltr"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs .ck-results-counter {
				right: var(--ck-spacing-standard);
		}
[dir="rtl"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs .ck-results-counter {
				left: var(--ck-spacing-standard);
		}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs .ck-results-counter {

			color: var(--ck-color-base-border);
		}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > .ck-labeled-field-replace {
			flex: 0 0 100%;
			padding-top: var(--ck-spacing-standard);
		}
[dir="ltr"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > .ck-labeled-field-replace {
				margin-left: 0;
		}
[dir="rtl"] .ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs > .ck-labeled-field-replace {
				margin-right: 0;
		}
/* Styles specific for actions area. */
.ck.ck-find-and-replace-form .ck-find-and-replace-form__actions {
		flex-wrap: wrap;
		justify-content: flex-end;
		margin-top: calc( -1 * var(--ck-spacing-large) );
	}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__actions > .ck-button-find {
			font-weight: bold;

			/* Beef the find button up a little. It's the main action button in the form */
		}
.ck.ck-find-and-replace-form .ck-find-and-replace-form__actions > .ck-button-find .ck-button__label {
				padding-left: var(--ck-spacing-large);
				padding-right: var(--ck-spacing-large);
			}
.ck.ck-find-and-replace-form .ck-switchbutton {
		width: 100%;
		display: flex;
		flex-direction: row;
		flex-wrap: nowrap;
		justify-content: space-between;
		align-items: center;
	}
@media screen and (max-width: 600px) {
	.ck.ck-find-and-replace-form {
		width: 300px;

		/* Don't let the form overflow from the dialog (https://github.com/cksource/ckeditor5-commercial/issues/5913) */
		max-width: 100%;

		/* Styles specific for inputs area. */
	}
		.ck.ck-find-and-replace-form.ck-find-and-replace-form__input {
			flex-wrap: wrap;
		}

			.ck.ck-find-and-replace-form.ck-find-and-replace-form__input .ck-labeled-field-view {
				flex: 1 0 auto;
				width: 100%;
				margin-bottom: var(--ck-spacing-standard);
			}

			.ck.ck-find-and-replace-form.ck-find-and-replace-form__input > .ck-button {
				text-align: center;
			}

				.ck.ck-find-and-replace-form.ck-find-and-replace-form__input > .ck-button:first-of-type {
					flex: 1 1 auto;
				}

				[dir="ltr"] .ck.ck-find-and-replace-form.ck-find-and-replace-form__input > .ck-button:first-of-type {
						margin-left: 0;
				}

				[dir="rtl"] .ck.ck-find-and-replace-form.ck-find-and-replace-form__input > .ck-button:first-of-type {
						margin-right: 0;
				}

					.ck.ck-find-and-replace-form.ck-find-and-replace-form__input > .ck-button:first-of-type .ck-button__label {
						width: 100%;
						text-align: center;
					}

		/* Styles specific for actions area. */
		.ck.ck-find-and-replace-form.ck-find-and-replace-form__actions > :not(.ck-labeled-field-view) {
			flex-wrap: wrap;
			flex: 1 1 auto;
		}

			.ck.ck-find-and-replace-form.ck-find-and-replace-form__actions > :not(.ck-labeled-field-view) > .ck-button {
				text-align: center;
			}

				.ck.ck-find-and-replace-form.ck-find-and-replace-form__actions > :not(.ck-labeled-field-view) > .ck-button:first-of-type {
					flex: 1 1 auto;
				}

				[dir="ltr"] .ck.ck-find-and-replace-form.ck-find-and-replace-form__actions > :not(.ck-labeled-field-view) > .ck-button:first-of-type {
						margin-left: 0;
				}

				[dir="rtl"] .ck.ck-find-and-replace-form.ck-find-and-replace-form__actions > :not(.ck-labeled-field-view) > .ck-button:first-of-type {
						margin-right: 0;
				}

				.ck.ck-find-and-replace-form.ck-find-and-replace-form__actions > :not(.ck-labeled-field-view) > .ck-button .ck-button__label {
					width: 100%;
					text-align: center;
				}
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* Resize dropdown's button label. */
.ck.ck-dropdown.ck-heading-dropdown .ck-dropdown__button .ck-button__label {
		width: 8em;
	}
.ck.ck-dropdown.ck-heading-dropdown .ck-dropdown__panel .ck-list__item {
		min-width: 18em;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Note: This file should contain the wireframe styles only. But since there are no such styles,
 * it acts as a message to the builder telling that it should look for the corresponding styles
 * **in the theme** when compiling the editor.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-html-embed-content-width: calc(100% - 1.5 * var(--ck-icon-size));
	--ck-html-embed-source-height: 10em;
	--ck-html-embed-unfocused-outline-width: 1px;
	--ck-html-embed-content-min-height: calc(var(--ck-icon-size) + var(--ck-spacing-standard));

	--ck-html-embed-source-disabled-background: var(--ck-color-base-foreground);
	--ck-html-embed-source-disabled-color: hsl(0deg 0% 45%);
}
/* The feature container. */
.ck-widget.raw-html-embed {
	font-size: var(--ck-font-size-base);
	background-color: var(--ck-color-base-foreground);
}
.ck-widget.raw-html-embed:not(.ck-widget_selected):not(:hover) {
		outline: var(--ck-html-embed-unfocused-outline-width) dashed var(--ck-color-widget-blurred-border);
	}
/* HTML embed widget itself should respect UI language direction */
.ck-widget.raw-html-embed[dir="ltr"] {
		text-align: left;
	}
.ck-widget.raw-html-embed[dir="rtl"] {
		text-align: right;
	}
/* ----- Embed label in the upper left corner ----------------------------------------------- */
.ck-widget.raw-html-embed::before {
		content: attr(data-html-embed-label);
		top: calc(-1 * var(--ck-html-embed-unfocused-outline-width));
		left: var(--ck-spacing-standard);
		background: hsl(0deg 0% 60%);
		transition: background var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve);
		padding: calc(var(--ck-spacing-tiny) + var(--ck-html-embed-unfocused-outline-width)) var(--ck-spacing-small) var(--ck-spacing-tiny);
		border-radius: 0 0 var(--ck-border-radius) var(--ck-border-radius);
		color: var(--ck-color-base-background);
		font-size: var(--ck-font-size-tiny);
		font-family: var(--ck-font-face);
	}
.ck-widget.raw-html-embed[dir="rtl"]::before {
		left: auto;
		right: var(--ck-spacing-standard);
	}
/* Make space for label but it only collides in LTR languages */
.ck-widget.raw-html-embed[dir="ltr"] .ck-widget__type-around .ck-widget__type-around__button.ck-widget__type-around__button_before {
		margin-left: 50px;
	}
.ck.ck-editor__editable.ck-blurred .ck-widget.raw-html-embed.ck-widget_selected::before {
		top: 0px;
		padding: var(--ck-spacing-tiny) var(--ck-spacing-small);
}
.ck.ck-editor__editable:not(.ck-blurred) .ck-widget.raw-html-embed.ck-widget_selected::before {
		top: 0;
		padding: var(--ck-spacing-tiny) var(--ck-spacing-small);
		background: var(--ck-color-focus-border);
}
.ck.ck-editor__editable .ck-widget.raw-html-embed:not(.ck-widget_selected):hover::before {
		top: 0px;
		padding: var(--ck-spacing-tiny) var(--ck-spacing-small);
}
/* ----- Emebed internals --------------------------------------------------------------------- */
.ck-widget.raw-html-embed .raw-html-embed__content-wrapper {
		padding: var(--ck-spacing-standard);
	}
/* The switch mode button wrapper. */
.ck-widget.raw-html-embed .raw-html-embed__buttons-wrapper {
		top: var(--ck-spacing-standard);
		right: var(--ck-spacing-standard);
	}
.ck-widget.raw-html-embed .raw-html-embed__buttons-wrapper .ck-button.raw-html-embed__save-button {
			color: var(--ck-color-button-save);
		}
.ck-widget.raw-html-embed .raw-html-embed__buttons-wrapper .ck-button.raw-html-embed__cancel-button {
			color: var(--ck-color-button-cancel);
		}
.ck-widget.raw-html-embed .raw-html-embed__buttons-wrapper .ck-button:not(:first-child) {
			margin-top: var(--ck-spacing-small);
		}
.ck-widget.raw-html-embed[dir="rtl"] .raw-html-embed__buttons-wrapper {
		left: var(--ck-spacing-standard);
		right: auto;
	}
/* The edit source element. */
.ck-widget.raw-html-embed .raw-html-embed__source {
		box-sizing: border-box;
		height: var(--ck-html-embed-source-height);
		width: var(--ck-html-embed-content-width);
		resize: none;
		min-width: 0;
		padding: var(--ck-spacing-standard);

		font-family: monospace;
		tab-size: 4;
		white-space: pre-wrap;
		font-size: var(--ck-font-size-base); /* Safari needs this. */

		/* HTML code is direction–agnostic. */
		text-align: left;
		direction: ltr;
	}
.ck-widget.raw-html-embed .raw-html-embed__source[disabled] {
			background: var(--ck-html-embed-source-disabled-background);
			color: var(--ck-html-embed-source-disabled-color);

			/* Safari needs this for the proper text color in disabled input (https://github.com/ckeditor/ckeditor5/issues/8320). */
			-webkit-text-fill-color: var(--ck-html-embed-source-disabled-color);
			opacity: 1;
		}
/* The preview data container. */
.ck-widget.raw-html-embed .raw-html-embed__preview {
		min-height: var(--ck-html-embed-content-min-height);
		width: var(--ck-html-embed-content-width);

		/* Disable all mouse interaction as long as the editor is not read–only. */
	}
.ck-editor__editable:not(.ck-read-only) .ck-widget.raw-html-embed .raw-html-embed__preview {
			pointer-events: none;
	}
.ck-widget.raw-html-embed .raw-html-embed__preview-content {
		box-sizing: border-box;
		background-color: var(--ck-color-base-foreground);
	}
.ck-widget.raw-html-embed .raw-html-embed__preview-content > * {
			margin-left: auto;
			margin-right: auto;
		}
.ck-widget.raw-html-embed .raw-html-embed__preview-placeholder {
		color: var(--ck-html-embed-source-disabled-color)
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-image-insert-insert-by-url-width: 250px;
}
.ck.ck-image-insert-url {
	--ck-input-width: 100%;
}
.ck.ck-image-insert-url .ck-image-insert-url__action-row {
		grid-column-gap: var(--ck-spacing-large);
		margin-top: var(--ck-spacing-large);
	}
.ck.ck-image-insert-url .ck-image-insert-url__action-row .ck-button-save,
		.ck.ck-image-insert-url .ck-image-insert-url__action-row .ck-button-cancel {
			justify-content: center;
			min-width: auto;
		}
.ck.ck-image-insert-url .ck-image-insert-url__action-row .ck-button .ck-button__label {
			color: var(--ck-color-text);
		}
.ck.ck-image-insert-form > .ck.ck-button {
		display: block;
		width: 100%;
	}
[dir="ltr"] .ck.ck-image-insert-form > .ck.ck-button {
			text-align: left;
	}
[dir="rtl"] .ck.ck-image-insert-form > .ck.ck-button {
			text-align: right;
	}
.ck.ck-image-insert-form > .ck.ck-collapsible {

		min-width: var(--ck-image-insert-insert-by-url-width);
	}
.ck.ck-image-insert-form > .ck.ck-collapsible:not(:first-child) {
			border-top: 1px solid var(--ck-color-base-border);
		}
.ck.ck-image-insert-form > .ck.ck-collapsible:not(:last-child) {
			border-bottom: 1px solid var(--ck-color-base-border);
		}
/* This is the case when there are no other integrations configured than insert by URL */
.ck.ck-image-insert-form > .ck.ck-image-insert-url {
		min-width: var(--ck-image-insert-insert-by-url-width);
		padding: var(--ck-spacing-large);
	}
.ck.ck-image-insert-form:focus {
		outline: none;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-image-upload-icon: hsl(0, 0%, 100%);
	--ck-color-image-upload-icon-background: hsl(120, 100%, 27%);

	/* Match the icon size with the linked image indicator brought by the link image feature. */
	--ck-image-upload-icon-size: 20;
	--ck-image-upload-icon-width: 2px;
	--ck-image-upload-icon-is-visible: clamp(0px, 100% - 50px, 1px);
}
.ck-image-upload-complete-icon {
	opacity: 0;
	background: var(--ck-color-image-upload-icon-background);
	animation-name: ck-upload-complete-icon-show, ck-upload-complete-icon-hide;
	animation-fill-mode: forwards, forwards;
	animation-duration: 500ms, 500ms;

	/* To make animation scalable. */
	font-size: calc(1px * var(--ck-image-upload-icon-size));

	/* Hide completed upload icon after 3 seconds. */
	animation-delay: 0ms, 3000ms;

	/*
	 * Use CSS math to simulate container queries.
	 * https://css-tricks.com/the-raven-technique-one-step-closer-to-container-queries/#what-about-showing-and-hiding-things
	 */
	overflow: hidden;
	width: calc(var(--ck-image-upload-icon-is-visible) * var(--ck-image-upload-icon-size));
	height: calc(var(--ck-image-upload-icon-is-visible) * var(--ck-image-upload-icon-size));

	/* This is check icon element made from border-width mixed with animations. */
}
.ck-image-upload-complete-icon::after {
		/* Because of border transformation we need to "hard code" left position. */
		left: 25%;

		top: 50%;
		opacity: 0;
		height: 0;
		width: 0;

		transform: scaleX(-1) rotate(135deg);
		transform-origin: left top;
		border-top: var(--ck-image-upload-icon-width) solid var(--ck-color-image-upload-icon);
		border-right: var(--ck-image-upload-icon-width) solid var(--ck-color-image-upload-icon);

		animation-name: ck-upload-complete-icon-check;
		animation-duration: 500ms;
		animation-delay: 500ms;
		animation-fill-mode: forwards;

		/* #1095. While reset is not providing proper box-sizing for pseudoelements, we need to handle it. */
		box-sizing: border-box;
	}
@media (prefers-reduced-motion: reduce) {
.ck-image-upload-complete-icon {
		animation-duration: 0ms;
}

		.ck-image-upload-complete-icon::after {
			animation: none;
			opacity: 1;
			width: 0.3em;
			height: 0.45em;
		}
	}
@keyframes ck-upload-complete-icon-show {
	from {
		opacity: 0;
	}

	to {
		opacity: 1;
	}
}
@keyframes ck-upload-complete-icon-hide {
	from {
		opacity: 1;
	}

	to {
		opacity: 0;
	}
}
@keyframes ck-upload-complete-icon-check {
	0% {
		opacity: 1;
		width: 0;
		height: 0;
	}
	33% {
		width: 0.3em;
		height: 0;
	}
	100% {
		opacity: 1;
		width: 0.3em;
		height: 0.45em;
	}
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-upload-placeholder-loader: hsl(0, 0%, 70%);
	--ck-upload-placeholder-loader-size: 32px;
	--ck-upload-placeholder-image-aspect-ratio: 2.8;
}
.ck .ck-image-upload-placeholder {
	/* We need to control the full width of the SVG gray background. */
	width: 100%;
	margin: 0;
}
.ck .ck-image-upload-placeholder.image-inline {
		width: calc( 2 * var(--ck-upload-placeholder-loader-size) * var(--ck-upload-placeholder-image-aspect-ratio) );
	}
.ck .ck-image-upload-placeholder img {
		/*
		 * This is an arbitrary aspect for a 1x1 px GIF to display to the user. Not too tall, not too short.
		 * There's nothing special about this number except that it should make the image placeholder look like
		 * a real image during this short period after the upload started and before the image was read from the
		 * file system (and a rich preview was loaded).
		 */
		aspect-ratio: var(--ck-upload-placeholder-image-aspect-ratio);
	}
.ck .ck-upload-placeholder-loader {
	width: 100%;
	height: 100%;
}
.ck .ck-upload-placeholder-loader::before {
		width: var(--ck-upload-placeholder-loader-size);
		height: var(--ck-upload-placeholder-loader-size);
		border-radius: 50%;
		border-top: 3px solid var(--ck-color-upload-placeholder-loader);
		border-right: 2px solid transparent;
		animation: ck-upload-placeholder-loader 1s linear infinite;
	}
@keyframes ck-upload-placeholder-loader {
	to {
		transform: rotate( 360deg );
	}
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* Showing animation. */
.ck.ck-editor__editable .image.ck-appear, .ck.ck-editor__editable .image-inline.ck-appear {
			animation: fadeIn 700ms;
		}
@media (prefers-reduced-motion: reduce) {
.ck.ck-editor__editable .image.ck-appear, .ck.ck-editor__editable .image-inline.ck-appear {
				opacity: 1;
				animation: none;
		}
			}
/* Upload progress bar. */
.ck.ck-editor__editable .image .ck-progress-bar,
	.ck.ck-editor__editable .image-inline .ck-progress-bar {
		height: 2px;
		width: 0;
		background: var(--ck-color-upload-bar-background);
		transition: width 100ms;
	}
@keyframes fadeIn {
	from { opacity: 0; }
	to   { opacity: 1; }
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* Class added to span element surrounding currently selected link. */
.ck .ck-link_selected {
	background: var(--ck-color-link-selected-background);

	/* Give linked inline images some outline to let the user know they are also part of the link. */
}
.ck .ck-link_selected span.image-inline {
		outline: var(--ck-widget-outline-thickness) solid var(--ck-color-link-selected-background);
	}
/*
 * Classes used by the "fake visual selection" displayed in the content when an input
 * in the link UI has focus (the browser does not render the native selection in this state).
 */
.ck .ck-fake-link-selection {
	background: var(--ck-color-link-fake-selection);
}
/* A collapsed fake visual selection. */
.ck .ck-fake-link-selection_collapsed {
	height: 100%;
	border-right: 1px solid var(--ck-color-base-text);
	margin-right: -1px;
	outline: solid 1px hsla(0, 0%, 100%, .5);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Makes element unselectable.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-link-actions .ck-button.ck-link-actions__preview {
		padding-left: 0;
		padding-right: 0;
	}
.ck.ck-link-actions .ck-button.ck-link-actions__preview .ck-button__label {
			padding: 0 var(--ck-spacing-medium);
			color: var(--ck-color-link-default);
			text-overflow: ellipsis;
			cursor: pointer;

			/* Match the box model of the link editor form's input so the balloon
			does not change width when moving between actions and the form. */
			max-width: var(--ck-input-width);
			min-width: 3em;
			text-align: center;
		}
.ck.ck-link-actions .ck-button.ck-link-actions__preview .ck-button__label:hover {
				text-decoration: underline;
			}
.ck.ck-link-actions .ck-button.ck-link-actions__preview,
		.ck.ck-link-actions .ck-button.ck-link-actions__preview:hover,
		.ck.ck-link-actions .ck-button.ck-link-actions__preview:focus,
		.ck.ck-link-actions .ck-button.ck-link-actions__preview:active {
			background: none;
		}
.ck.ck-link-actions .ck-button.ck-link-actions__preview:active {
			box-shadow: none;
		}
.ck.ck-link-actions .ck-button.ck-link-actions__preview:focus .ck-button__label {
				text-decoration: underline;
			}
[dir="ltr"] .ck.ck-link-actions .ck-button:not(:first-child) {
			margin-left: var(--ck-spacing-standard);
		}
[dir="rtl"] .ck.ck-link-actions .ck-button:not(:last-child) {
			margin-left: var(--ck-spacing-standard);
		}
@media screen and (max-width: 600px) {
		.ck.ck-link-actions .ck-button.ck-link-actions__preview {
			margin: var(--ck-spacing-standard) var(--ck-spacing-standard) 0;
		}

			.ck.ck-link-actions .ck-button.ck-link-actions__preview .ck-button__label {
				min-width: 0;
				max-width: 100%;
			}

		[dir="ltr"] .ck.ck-link-actions .ck-button:not(.ck-link-actions__preview) {
				margin-left: 0;
		}

		[dir="rtl"] .ck.ck-link-actions .ck-button:not(.ck-link-actions__preview) {
				margin-left: 0;
		}
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Style link form differently when manual decorators are available.
 * See: https://github.com/ckeditor/ckeditor5-link/issues/186.
 */
.ck.ck-link-form_layout-vertical {
	padding: 0;
	min-width: var(--ck-input-width);
}
.ck.ck-link-form_layout-vertical .ck-labeled-field-view {
		margin: var(--ck-spacing-large) var(--ck-spacing-large) var(--ck-spacing-small);
	}
.ck.ck-link-form_layout-vertical .ck-labeled-field-view .ck-input-text {
			min-width: 0;
			width: 100%;
		}
.ck.ck-link-form_layout-vertical > .ck-button {
		padding: var(--ck-spacing-standard);
		margin: 0;
		width: 50%;
		border-radius: 0;
	}
.ck.ck-link-form_layout-vertical > .ck-button:not(:focus) {
			border-top: 1px solid var(--ck-color-base-border);
		}
[dir="ltr"] .ck.ck-link-form_layout-vertical > .ck-button {
			margin-left: 0;
	}
[dir="rtl"] .ck.ck-link-form_layout-vertical > .ck-button {
			margin-left: 0;
	}
[dir="rtl"] .ck.ck-link-form_layout-vertical > .ck-button:last-of-type {
				border-right: 1px solid var(--ck-color-base-border);
			}
/* Using additional \`.ck\` class for stronger CSS specificity than \`.ck.ck-link-form > :not(:first-child)\`. */
.ck.ck-link-form_layout-vertical .ck.ck-list {
		margin: 0 var(--ck-spacing-large);
	}
.ck.ck-link-form_layout-vertical .ck.ck-list .ck-button.ck-switchbutton {
			padding: 0;
			width: 100%;
		}
.ck.ck-link-form_layout-vertical .ck.ck-list .ck-button.ck-switchbutton:hover {
				background: none;
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	/* Match the icon size with the upload indicator brought by the image upload feature. */
	--ck-link-image-indicator-icon-size: 20;
	--ck-link-image-indicator-icon-is-visible: clamp(0px, 100% - 50px, 1px);
}
/* Linked image indicator */
.ck.ck-editor__editable figure.image > a::after, .ck.ck-editor__editable a span.image-inline::after {
			content: "";

			/*
			 * Smaller images should have the icon closer to the border.
			 * Match the icon position with the upload indicator brought by the image upload feature.
			 */
			top: min(var(--ck-spacing-medium), 6%);
			right: min(var(--ck-spacing-medium), 6%);

			background-color: hsla(0, 0%, 0%, .4);
			background-image: url(${___CSS_LOADER_URL_REPLACEMENT_0___});
			background-size: 14px;
			background-repeat: no-repeat;
			background-position: center;
			border-radius: 100%;

			/*
			* Use CSS math to simulate container queries.
			* https://css-tricks.com/the-raven-technique-one-step-closer-to-container-queries/#what-about-showing-and-hiding-things
			*/
			overflow: hidden;
			width: calc(var(--ck-link-image-indicator-icon-is-visible) * var(--ck-link-image-indicator-icon-size));
			height: calc(var(--ck-link-image-indicator-icon-is-visible) * var(--ck-link-image-indicator-icon-size));
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* When there are no list styles and there is no collapsible. */
.ck.ck-list-properties.ck-list-properties_without-styles {
		padding: var(--ck-spacing-large);
	}
.ck.ck-list-properties.ck-list-properties_without-styles > * {
			min-width: 14em;
		}
.ck.ck-list-properties.ck-list-properties_without-styles > * + * {
				margin-top: var(--ck-spacing-standard);
			}
/*
	 * When the numbered list property fields (start at, reversed) should be displayed,
	 * more horizontal space is needed. Reconfigure the style grid to create that space.
	 */
.ck.ck-list-properties.ck-list-properties_with-numbered-properties > .ck-list-styles-list {
			grid-template-columns: repeat( 4, auto );
		}
/* When list styles are rendered and property fields are in a collapsible. */
.ck.ck-list-properties.ck-list-properties_with-numbered-properties > .ck-collapsible {
			border-top: 1px solid var(--ck-color-base-border);
		}
.ck.ck-list-properties.ck-list-properties_with-numbered-properties > .ck-collapsible > .ck-collapsible__children > * {
					width: 100%;
				}
.ck.ck-list-properties.ck-list-properties_with-numbered-properties > .ck-collapsible > .ck-collapsible__children > * + * {
						margin-top: var(--ck-spacing-standard);
					}
.ck.ck-list-properties .ck.ck-numbered-list-properties__start-index .ck-input {
		min-width: auto;
		width: 100%;
	}
.ck.ck-list-properties .ck.ck-numbered-list-properties__reversed-order {
		background: transparent;
		padding-left: 0;
		padding-right: 0;
		margin-bottom: calc(-1 * var(--ck-spacing-tiny));
	}
.ck.ck-list-properties .ck.ck-numbered-list-properties__reversed-order:active, .ck.ck-list-properties .ck.ck-numbered-list-properties__reversed-order:hover {
			box-shadow: none;
			border-color: transparent;
			background: none;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-list-style-button-size: 44px;
}
.ck.ck-list-styles-list {
	grid-template-columns: repeat( 3, auto );
	row-gap: var(--ck-spacing-medium);
	column-gap: var(--ck-spacing-medium);
	padding: var(--ck-spacing-large);
}
.ck.ck-list-styles-list .ck-button {
		/* Make the button look like a thumbnail (the icon "takes it all"). */
		width: var(--ck-list-style-button-size);
		height: var(--ck-list-style-button-size);
		padding: 0;

		/*
		 * Buttons are aligned by the grid so disable default button margins to not collide with the
		 * gaps in the grid.
		 */
		margin: 0;

		/*
		 * Make sure the button border (which is displayed on focus, BTW) does not steal pixels
		 * from the button dimensions and, as a result, decrease the size of the icon
		 * (which becomes blurry as it scales down).
		 */
		box-sizing: content-box;
	}
.ck.ck-list-styles-list .ck-button .ck-icon {
			width: var(--ck-list-style-button-size);
			height: var(--ck-list-style-button-size);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-media-embed-placeholder-icon-size: 3em;

	--ck-color-media-embed-placeholder-url-text: hsl(0, 0%, 46%);
	--ck-color-media-embed-placeholder-url-text-hover: var(--ck-color-base-text);
}
.ck-media__wrapper {
	margin: 0 auto;
}
.ck-media__wrapper .ck-media__placeholder {
		padding: calc( 3 * var(--ck-spacing-standard) );
		background: var(--ck-color-base-foreground);
	}
.ck-media__wrapper .ck-media__placeholder .ck-media__placeholder__icon {
			min-width: var(--ck-media-embed-placeholder-icon-size);
			height: var(--ck-media-embed-placeholder-icon-size);
			margin-bottom: var(--ck-spacing-large);
			background-position: center;
			background-size: cover;
		}
.ck-media__wrapper .ck-media__placeholder .ck-media__placeholder__icon .ck-icon {
				width: 100%;
				height: 100%;
			}
.ck-media__wrapper .ck-media__placeholder .ck-media__placeholder__url__text {
			color: var(--ck-color-media-embed-placeholder-url-text);
			white-space: nowrap;
			text-align: center;
			font-style: italic;
			text-overflow: ellipsis;
		}
.ck-media__wrapper .ck-media__placeholder .ck-media__placeholder__url__text:hover {
				color: var(--ck-color-media-embed-placeholder-url-text-hover);
				cursor: pointer;
				text-decoration: underline;
			}
.ck-media__wrapper[data-oembed-url*="open.spotify.com"] {
		max-width: 300px;
		max-height: 380px;
	}
.ck-media__wrapper[data-oembed-url*="google.com/maps"] .ck-media__placeholder__icon,
	.ck-media__wrapper[data-oembed-url*="goo.gl/maps"] .ck-media__placeholder__icon,
	.ck-media__wrapper[data-oembed-url*="maps.google.com"] .ck-media__placeholder__icon,
	.ck-media__wrapper[data-oembed-url*="maps.app.goo.gl"] .ck-media__placeholder__icon {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_1___});
	}
.ck-media__wrapper[data-oembed-url*="facebook.com"] .ck-media__placeholder {
		background: hsl(220, 46%, 48%);
	}
.ck-media__wrapper[data-oembed-url*="facebook.com"] .ck-media__placeholder .ck-media__placeholder__icon {
			background-image: url(${___CSS_LOADER_URL_REPLACEMENT_2___});
		}
.ck-media__wrapper[data-oembed-url*="facebook.com"] .ck-media__placeholder .ck-media__placeholder__url__text {
			color: hsl(220, 100%, 90%);
		}
.ck-media__wrapper[data-oembed-url*="facebook.com"] .ck-media__placeholder .ck-media__placeholder__url__text:hover {
				color: hsl(0, 0%, 100%);
			}
.ck-media__wrapper[data-oembed-url*="instagram.com"] .ck-media__placeholder {
		background: linear-gradient(-135deg,hsl(246, 100%, 39%),hsl(302, 100%, 36%),hsl(0, 100%, 48%));
	}
.ck-media__wrapper[data-oembed-url*="instagram.com"] .ck-media__placeholder .ck-media__placeholder__icon {
			background-image: url(${___CSS_LOADER_URL_REPLACEMENT_3___});
		}
/* stylelint-disable-next-line no-descending-specificity */
.ck-media__wrapper[data-oembed-url*="instagram.com"] .ck-media__placeholder .ck-media__placeholder__url__text {
			color: hsl(302, 100%, 94%);
		}
.ck-media__wrapper[data-oembed-url*="instagram.com"] .ck-media__placeholder .ck-media__placeholder__url__text:hover {
				color: hsl(0, 0%, 100%);
			}
.ck-media__wrapper[data-oembed-url*="twitter.com"] .ck.ck-media__placeholder {
		/* Use gradient to contrast with focused widget (ckeditor/ckeditor5-media-embed#22). */
		background: linear-gradient( to right, hsl(201, 85%, 70%), hsl(201, 85%, 35%) );
	}
.ck-media__wrapper[data-oembed-url*="twitter.com"] .ck.ck-media__placeholder .ck-media__placeholder__icon {
			background-image: url(${___CSS_LOADER_URL_REPLACEMENT_4___});
		}
.ck-media__wrapper[data-oembed-url*="twitter.com"] .ck.ck-media__placeholder .ck-media__placeholder__url__text {
			color: hsl(201, 100%, 86%);
		}
.ck-media__wrapper[data-oembed-url*="twitter.com"] .ck.ck-media__placeholder .ck-media__placeholder__url__text:hover {
				color: hsl(0, 0%, 100%);
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-mention-background: hsla(341, 100%, 30%, 0.1);
	--ck-color-mention-text: hsl(341, 100%, 30%);
}
.ck-content .mention {
	background: var(--ck-color-mention-background);
	color: var(--ck-color-mention-text);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-restricted-editing-exception-background: hsla(31, 100%, 65%, .2);
	--ck-color-restricted-editing-exception-hover-background: hsla(31, 100%, 65%, .35);
	--ck-color-restricted-editing-exception-brackets: hsla(31, 100%, 40%, .4);
	--ck-color-restricted-editing-selected-exception-background: hsla(31, 100%, 65%, .5);
	--ck-color-restricted-editing-selected-exception-brackets: hsla(31, 100%, 40%, .6);
}
.ck-editor__editable .restricted-editing-exception {
	transition: .2s ease-in-out background;
	background-color: var(--ck-color-restricted-editing-exception-background);
	border: 1px solid;
	border-image: linear-gradient(
		to right,
		var(--ck-color-restricted-editing-exception-brackets) 0%,
		var(--ck-color-restricted-editing-exception-brackets) 5px,
		hsla(0, 0%, 0%, 0) 6px,
		hsla(0, 0%, 0%, 0) calc(100% - 6px),
		var(--ck-color-restricted-editing-exception-brackets) calc(100% - 5px),
		var(--ck-color-restricted-editing-exception-brackets) 100%
	) 1;
}
@media (prefers-reduced-motion: reduce) {
.ck-editor__editable .restricted-editing-exception {
		transition: none;
}
	}
.ck-editor__editable .restricted-editing-exception.restricted-editing-exception_selected {
		background-color: var(--ck-color-restricted-editing-selected-exception-background);
		border-image: linear-gradient(
			to right,
			var(--ck-color-restricted-editing-selected-exception-brackets) 0%,
			var(--ck-color-restricted-editing-selected-exception-brackets) 5px,
			var(--ck-color-restricted-editing-selected-exception-brackets) calc(100% - 5px),
			var(--ck-color-restricted-editing-selected-exception-brackets) 100%
		) 1;
	}
.ck-editor__editable .restricted-editing-exception.restricted-editing-exception_collapsed {
		/* Empty exception should have the same width as exception with at least 1 char */
		padding-left: 1ch;
	}
.ck-restricted-editing_mode_restricted {
	cursor: default;

	/* We also have to override all elements inside the restricted editable to prevent cursor switching between default and text
	during the pointer movement. */
}
.ck-restricted-editing_mode_restricted * {
		cursor: default;
	}
.ck-restricted-editing_mode_restricted .restricted-editing-exception {
		cursor: text;
	}
.ck-restricted-editing_mode_restricted .restricted-editing-exception * {
			cursor: text;
		}
.ck-restricted-editing_mode_restricted .restricted-editing-exception:hover {
			background: var(--ck-color-restricted-editing-exception-hover-background);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
:root {
	--ck-character-grid-tile-size: 24px;
}
.ck.ck-character-grid {
	overflow-y: auto;
	overflow-x: hidden;
}
.ck.ck-character-grid .ck-character-grid__tiles {
		grid-template-columns: repeat(auto-fill, minmax(var(--ck-character-grid-tile-size), 1fr));
		margin: var(--ck-spacing-standard) var(--ck-spacing-large);
		grid-gap: var(--ck-spacing-standard);
	}
.ck.ck-character-grid .ck-character-grid__tile {
		width: var(--ck-character-grid-tile-size);
		height: var(--ck-character-grid-tile-size);
		min-width: var(--ck-character-grid-tile-size);
		min-height: var(--ck-character-grid-tile-size);
		font-size: 1.5em;
		padding: 0;
		transition: .2s ease box-shadow;
		border: 0;
	}
@media (prefers-reduced-motion: reduce) {
.ck.ck-character-grid .ck-character-grid__tile {
			transition: none;
	}
		}
.ck.ck-character-grid .ck-character-grid__tile:focus:not( .ck-disabled ),
		.ck.ck-character-grid .ck-character-grid__tile:hover:not( .ck-disabled ) {
			/* Disable the default .ck-button's border ring. */
			border: 0;
			box-shadow: inset 0 0 0 1px var(--ck-color-base-background), 0 0 0 2px var(--ck-color-focus-border);
		}
/* Make sure the glyph is rendered in the center of the button */
.ck.ck-character-grid .ck-character-grid__tile .ck-button__label {
			line-height: var(--ck-character-grid-tile-size);
			width: 100%;
			text-align: center;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-character-info {
	padding: var(--ck-spacing-small) var(--ck-spacing-large);
	border-top: 1px solid var(--ck-color-base-border);
}
.ck.ck-character-info > * {
		text-transform: uppercase;
		font-size: var(--ck-font-size-small);
	}
.ck.ck-character-info .ck-character-info__name {
		max-width: 280px;
		text-overflow: ellipsis;
		overflow: hidden;
	}
.ck.ck-character-info .ck-character-info__code {
		opacity: .6;
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-special-characters-navigation > .ck-label {
		max-width: 160px;
		text-overflow: ellipsis;
		overflow: hidden;
	}
.ck.ck-special-characters-navigation > .ck-dropdown .ck-dropdown__panel {
		/* There could be dozens of categories available. Use scroll to prevent a 10e6px dropdown. */
		max-height: 250px;
		overflow-y: auto;
		overflow-x: hidden;
	}
@media screen and (max-width: 600px) {
.ck.ck-special-characters-navigation {
		max-width: 190px;
}

		.ck.ck-special-characters-navigation > .ck-form__header__label {
			text-overflow: ellipsis;
			overflow: hidden;
		}
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-dropdown.ck-style-dropdown.ck-style-dropdown_multiple-active > .ck-button > .ck-button__label {
	font-style: italic;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-style-panel-button-width: 120px;
	--ck-style-panel-button-height: 80px;
	--ck-style-panel-button-label-background: hsl(0, 0%, 94.1%);
	--ck-style-panel-button-hover-label-background: hsl(0, 0%, 92.1%);
	--ck-style-panel-button-hover-border-color: hsl(0, 0%, 70%);
}
.ck.ck-style-panel .ck-style-grid {
	row-gap: var(--ck-spacing-large);
	column-gap: var(--ck-spacing-large);
}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button {
		--ck-color-button-default-hover-background: var(--ck-color-base-background);
		--ck-color-button-default-active-background: var(--ck-color-base-background);

		padding: 0;
		width: var(--ck-style-panel-button-width);
		height: var(--ck-style-panel-button-height);

		/* Let default .ck-button :focus styles apply */
	}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button:not(:focus) {
			border: 1px solid var(--ck-color-base-border);
		}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button .ck-button__label {
			height: 22px;
			line-height: 22px;
			width: 100%;
			padding: 0 var(--ck-spacing-medium);
			overflow: hidden;
			text-overflow: ellipsis;
			flex-shrink: 0;
		}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button .ck-style-grid__button__preview {
			width: 100%;
			overflow: hidden;
			opacity: .9;

			padding: var(--ck-spacing-medium);
			background: var(--ck-color-base-background);
			border: 2px solid var(--ck-color-base-background);
		}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button.ck-disabled {
			--ck-color-button-default-disabled-background: var(--ck-color-base-foreground);

			/* Let default .ck-button :focus styles apply */
		}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button.ck-disabled:not(:focus) {
				border-color: var(--ck-style-panel-button-label-background);
			}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button.ck-disabled .ck-style-grid__button__preview {
				opacity: .4;

				border-color: var(--ck-color-base-foreground);
				filter: saturate(.3);
			}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button.ck-on {
			border-color: var(--ck-color-base-active);
		}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button.ck-on .ck-button__label {
				box-shadow: 0 -1px 0 var(--ck-color-base-active);
				z-index: 1; /* Stay on top of the preview with the shadow. */
			}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button.ck-on:hover {
				border-color: var(--ck-color-base-active-focus);
			}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button:not(.ck-on) .ck-button__label {
				background: var(--ck-style-panel-button-label-background);
			}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button:not(.ck-on):hover .ck-button__label {
				background: var(--ck-style-panel-button-hover-label-background);
			}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button:hover:not(.ck-disabled):not(.ck-on) {
			border-color: var(--ck-style-panel-button-hover-border-color);
		}
.ck.ck-style-panel .ck-style-grid .ck-style-grid__button:hover:not(.ck-disabled):not(.ck-on) .ck-style-grid__button__preview {
				opacity: 1;
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-style-panel .ck-style-panel__style-group > .ck-label {
		margin: var(--ck-spacing-large) 0;
	}
.ck.ck-style-panel .ck-style-panel__style-group:first-child > .ck-label {
			margin-top: 0;
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-style-panel-max-height: 470px;
}
.ck.ck-style-panel {
	padding: var(--ck-spacing-large);
	overflow-y: auto;
	max-height: var(--ck-style-panel-max-height);
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
[dir="ltr"] .ck.ck-input-color > .ck.ck-input-text {
			border-top-right-radius: 0;
			border-bottom-right-radius: 0;
	}
[dir="rtl"] .ck.ck-input-color > .ck.ck-input-text {
			border-top-left-radius: 0;
			border-bottom-left-radius: 0;
	}
/* Make sure the focused input is always on top of the dropdown button so its
		   outline and border are never cropped (also when the input is read-only). */
.ck.ck-input-color > .ck.ck-input-text:focus {
			z-index: 0;
		}
.ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button {
			padding: 0;
		}
[dir="ltr"] .ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button {
				border-top-left-radius: 0;
				border-bottom-left-radius: 0;
		}
[dir="ltr"] .ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button:not(:focus) {
					border-left: 1px solid transparent;
				}
[dir="rtl"] .ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button {
				border-top-right-radius: 0;
				border-bottom-right-radius: 0;
		}
[dir="rtl"] .ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button:not(:focus) {
					border-right: 1px solid transparent;
				}
.ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button.ck-disabled {
				background: var(--ck-color-input-disabled-background);
			}
.ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button > .ck.ck-input-color__button__preview {
				border-radius: 0;
			}
.ck-rounded-corners .ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button > .ck.ck-input-color__button__preview, .ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button > .ck.ck-input-color__button__preview.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
			}
.ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button > .ck.ck-input-color__button__preview {

				width: 20px;
				height: 20px;
				border: 1px solid var(--ck-color-input-border);
			}
.ck.ck-input-color > .ck.ck-dropdown > .ck.ck-button.ck-input-color__button > .ck.ck-input-color__button__preview > .ck.ck-input-color__button__preview__no-color-indicator {
					top: -30%;
					left: 50%;
					height: 150%;
					width: 8%;
					background: hsl(0, 100%, 50%);
					border-radius: 2px;
					transform: rotate(45deg);
					transform-origin: 50%;
				}
.ck.ck-input-color .ck.ck-input-color__remove-color {
		width: 100%;
		padding: calc(var(--ck-spacing-standard) / 2) var(--ck-spacing-standard);

		border-bottom-left-radius: 0;
		border-bottom-right-radius: 0;
	}
.ck.ck-input-color .ck.ck-input-color__remove-color:not(:focus) {
			border-bottom: 1px solid var(--ck-color-input-border);
		}
[dir="ltr"] .ck.ck-input-color .ck.ck-input-color__remove-color {
			border-top-right-radius: 0;
	}
[dir="rtl"] .ck.ck-input-color .ck.ck-input-color__remove-color {
			border-top-left-radius: 0;
	}
.ck.ck-input-color .ck.ck-input-color__remove-color .ck.ck-icon {
			margin-right: var(--ck-spacing-standard);
		}
[dir="rtl"] .ck.ck-input-color .ck.ck-input-color__remove-color .ck.ck-icon {
				margin-right: 0;
				margin-left: var(--ck-spacing-standard);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-form {
	padding: 0 0 var(--ck-spacing-large);
}
.ck.ck-form:focus {
		/* See: https://github.com/ckeditor/ckeditor5/issues/4773 */
		outline: none;
	}
.ck.ck-form .ck.ck-input-text {
		min-width: 100%;
		width: 0;
	}
.ck.ck-form .ck.ck-dropdown {
		min-width: 100%;
	}
.ck.ck-form .ck.ck-dropdown .ck-dropdown__button:not(:focus) {
				border: 1px solid var(--ck-color-base-border);
			}
.ck.ck-form .ck.ck-dropdown .ck-dropdown__button .ck-button__label {
				width: 100%;
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-form__row {
	padding: var(--ck-spacing-standard) var(--ck-spacing-large) 0;

	/* Ignore labels that work as fieldset legends */
}
[dir="ltr"] .ck.ck-form__row > *:not(.ck-label) + * {
				margin-left: var(--ck-spacing-large);
		}
[dir="rtl"] .ck.ck-form__row > *:not(.ck-label) + * {
				margin-right: var(--ck-spacing-large);
		}
.ck.ck-form__row > .ck-label {
		width: 100%;
		min-width: 100%;
	}
.ck.ck-form__row.ck-table-form__action-row {
		margin-top: var(--ck-spacing-large);
	}
.ck.ck-form__row.ck-table-form__action-row .ck-button .ck-button__label {
			color: var(--ck-color-text);
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-insert-table-dropdown-padding: 10px;
	--ck-insert-table-dropdown-box-height: 11px;
	--ck-insert-table-dropdown-box-width: 12px;
	--ck-insert-table-dropdown-box-margin: 1px;
}
.ck .ck-insert-table-dropdown__grid {
	/* The width of a container should match 10 items in a row so there will be a 10x10 grid. */
	width: calc(var(--ck-insert-table-dropdown-box-width) * 10 + var(--ck-insert-table-dropdown-box-margin) * 20 + var(--ck-insert-table-dropdown-padding) * 2);
	padding: var(--ck-insert-table-dropdown-padding) var(--ck-insert-table-dropdown-padding) 0;
}
.ck .ck-insert-table-dropdown__label,
.ck[dir=rtl] .ck-insert-table-dropdown__label {
	text-align: center;
}
.ck .ck-insert-table-dropdown-grid-box {
	min-width: var(--ck-insert-table-dropdown-box-width);
	min-height: var(--ck-insert-table-dropdown-box-height);
	margin: var(--ck-insert-table-dropdown-box-margin);
	border: 1px solid var(--ck-color-base-border);
	border-radius: 1px;
	outline: none;
	transition: none;
}
@media (prefers-reduced-motion: reduce) {
.ck .ck-insert-table-dropdown-grid-box {
		transition: none;
}
	}
.ck .ck-insert-table-dropdown-grid-box:focus {
		box-shadow: none;
	}
.ck .ck-insert-table-dropdown-grid-box.ck-on {
		border-color: var(--ck-color-focus-border);
		background: var(--ck-color-focus-outer-shadow);
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-table-cell-properties-form {
	width: 320px;
}
.ck.ck-table-cell-properties-form .ck-form__row.ck-table-cell-properties-form__padding-row {
			align-self: flex-end;
			padding: 0;
			width: 25%;
		}
.ck.ck-table-cell-properties-form .ck-form__row.ck-table-cell-properties-form__alignment-row .ck.ck-toolbar {
				background: none;

				/* Compensate for missing input label that would push the margin (toolbar has no inputs). */
				margin-top: var(--ck-spacing-standard);
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-color-selector-focused-cell-background: hsla(212, 90%, 80%, .3);
}
/**
		 * While setting outline is fine, the border should not be modified here
		 * because it overrides the default table cell border color which is not expected.
		 * So do not use \`@mixin ck-focus-ring;\` here, or any other border styles.
		 * See more: https://github.com/ckeditor/ckeditor5/issues/16979
		 */
.ck-widget.table td.ck-editor__nested-editable.ck-editor__nested-editable_focused,
		.ck-widget.table th.ck-editor__nested-editable.ck-editor__nested-editable_focused,
		.ck-widget.table td.ck-editor__nested-editable:focus,
		.ck-widget.table th.ck-editor__nested-editable:focus {
			/* A very slight background to highlight the focused cell */
			background: var(--ck-color-selector-focused-cell-background);
			outline: 1px solid var(--ck-color-focus-border);
			outline-offset: -1px; /* progressive enhancement - no IE support */
		}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
:root {
	--ck-table-properties-error-arrow-size: 6px;
	--ck-table-properties-min-error-width: 150px;
}
.ck.ck-table-form .ck-form__row.ck-table-form__border-row .ck-labeled-field-view > .ck-label {
					font-size: var(--ck-font-size-tiny);
					text-align: center;
				}
.ck.ck-table-form .ck-form__row.ck-table-form__border-row .ck-table-form__border-style,
			.ck.ck-table-form .ck-form__row.ck-table-form__border-row .ck-table-form__border-width {
				width: 80px;
				min-width: 80px;
				max-width: 80px;
			}
.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row {
			padding: 0;
		}
.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row .ck-table-form__dimensions-row__width,
			.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row .ck-table-form__dimensions-row__height {
				margin: 0
			}
.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row .ck-table-form__dimension-operator {
				align-self: flex-end;
				display: inline-block;
				height: var(--ck-ui-component-min-height);
				line-height: var(--ck-ui-component-min-height);
				margin: 0 var(--ck-spacing-small);
			}
.ck.ck-table-form .ck.ck-labeled-field-view {
		padding-top: var(--ck-spacing-standard);
	}
.ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status {
			border-radius: 0;
		}
.ck-rounded-corners .ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status, .ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
		}
.ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status {

			background: var(--ck-color-base-error);
			color: var(--ck-color-base-background);
			padding: var(--ck-spacing-small) var(--ck-spacing-medium);
			min-width: var(--ck-table-properties-min-error-width);
			text-align: center;

			animation: ck-table-form-labeled-view-status-appear .15s ease both;

			/* The arrow pointing towards the field. */
		}
.ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status::after {
				border-color: transparent transparent var(--ck-color-base-error) transparent;
				border-width: 0 var(--ck-table-properties-error-arrow-size) var(--ck-table-properties-error-arrow-size) var(--ck-table-properties-error-arrow-size);
				border-style: solid;
			}
@media (prefers-reduced-motion: reduce) {
.ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status {
				animation: none;
		}
			}
/* Hide the error balloon when the field is blurred. Makes the experience much more clear. */
.ck.ck-table-form .ck.ck-labeled-field-view .ck-input.ck-error:not(:focus) + .ck.ck-labeled-field-view__status {
			display: none;
		}
@keyframes ck-table-form-labeled-view-status-appear {
	0% {
		opacity: 0;
	}

	100% {
		opacity: 1;
	}
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
.ck.ck-table-properties-form {
	width: 320px;
}
.ck.ck-table-properties-form .ck-form__row.ck-table-properties-form__alignment-row {
			align-self: flex-end;
			padding: 0;
		}
.ck.ck-table-properties-form .ck-form__row.ck-table-properties-form__alignment-row .ck.ck-toolbar {
				background: none;

				/* Compensate for missing input label that would push the margin (toolbar has no inputs). */
				margin-top: var(--ck-spacing-standard);
			}
.ck.ck-table-properties-form .ck-form__row.ck-table-properties-form__alignment-row .ck.ck-toolbar .ck-toolbar__items > * {
					width: 40px;
				}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-table-selected-cell-background: hsla(208, 90%, 80%, .3);
}
.ck.ck-editor__editable .table table td.ck-editor__editable_selected,
	.ck.ck-editor__editable .table table th.ck-editor__editable_selected {
		position: relative;
		caret-color: transparent;
		outline: unset;
		box-shadow: unset;

		/* https://github.com/ckeditor/ckeditor5/issues/6446 */
	}
.ck.ck-editor__editable .table table td.ck-editor__editable_selected:after, .ck.ck-editor__editable .table table th.ck-editor__editable_selected:after {
			content: '';
			pointer-events: none;
			background-color: var(--ck-table-selected-cell-background);
			position: absolute;
			top: 0;
			left: 0;
			right: 0;
			bottom: 0;
		}
.ck.ck-editor__editable .table table td.ck-editor__editable_selected ::selection,
		.ck.ck-editor__editable .table table th.ck-editor__editable_selected ::selection,
		.ck.ck-editor__editable .table table td.ck-editor__editable_selected:focus,
		.ck.ck-editor__editable .table table th.ck-editor__editable_selected:focus {
			background-color: transparent;
		}
/*
		 * To reduce the amount of noise, all widgets in the table selection have no outline and no selection handle.
		 * See https://github.com/ckeditor/ckeditor5/issues/9491.
		 */
.ck.ck-editor__editable .table table td.ck-editor__editable_selected .ck-widget, .ck.ck-editor__editable .table table th.ck-editor__editable_selected .ck-widget {
			outline: unset;
		}
.ck.ck-editor__editable .table table td.ck-editor__editable_selected .ck-widget > .ck-widget__selection-handle, .ck.ck-editor__editable .table table th.ck-editor__editable_selected .ck-widget > .ck-widget__selection-handle {
				display: none;
			}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-widget-outline-thickness: 3px;
	--ck-widget-handler-icon-size: 16px;
	--ck-widget-handler-animation-duration: 200ms;
	--ck-widget-handler-animation-curve: ease;

	--ck-color-widget-blurred-border: hsl(0, 0%, 87%);
	--ck-color-widget-hover-border: hsl(43, 100%, 62%);
	--ck-color-widget-editable-focus-background: var(--ck-color-base-background);
	--ck-color-widget-drag-handler-icon-color: var(--ck-color-base-background);
}
.ck .ck-widget {
	outline-width: var(--ck-widget-outline-thickness);
	outline-style: solid;
	outline-color: transparent;
	transition: outline-color var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve);
}
@media (prefers-reduced-motion: reduce) {
.ck .ck-widget {
		transition: none;
}
	}
.ck .ck-widget.ck-widget_selected,
	.ck .ck-widget.ck-widget_selected:hover {
		outline: var(--ck-widget-outline-thickness) solid var(--ck-color-focus-border);
	}
.ck .ck-widget:hover {
		outline-color: var(--ck-color-widget-hover-border);
	}
.ck .ck-editor__nested-editable {
	border: 1px solid transparent;

	/* The :focus style is applied before .ck-editor__nested-editable_focused class is rendered in the view.
	These styles show a different border for a blink of an eye, so \`:focus\` need to have same styles applied. */
}
.ck .ck-editor__nested-editable.ck-editor__nested-editable_focused,
	.ck .ck-editor__nested-editable:focus {
		box-shadow: var(--ck-inner-shadow), 0 0;
	}
@media (forced-colors: none) {
		.ck .ck-editor__nested-editable.ck-editor__nested-editable_focused, .ck .ck-editor__nested-editable:focus {
			background-color: var(--ck-color-widget-editable-focus-background);
		}
	}
/**
		 * Focus border should not be applied to table cells because it overrides the default table cell border color.
		 * In other words - in some scenarios, the part of the table cell border has focus color style, which is not expected behavior
		 * because it should be the same as the table cell border color.
		 */
.ck .ck-editor__nested-editable.ck-editor__nested-editable_focused:not(td, th), .ck .ck-editor__nested-editable:focus:not(td, th) {
			/* Disable native outline. */
			outline: none;
			border: var(--ck-focus-ring);
		}
.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle {
		padding: 4px;
		box-sizing: border-box;

		/* Background and opacity will be animated as the handler shows up or the widget gets selected. */
		background-color: transparent;
		opacity: 0;

		/* Transition:
		   * background-color for the .ck-widget_selected state change,
		   * visibility for hiding the handler,
		   * opacity for the proper look of the icon when the handler disappears. */
		transition:
			background-color var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve),
			visibility var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve),
			opacity var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve);

		/* Make only top corners round. */
		border-radius: var(--ck-border-radius) var(--ck-border-radius) 0 0;

		/* Place the drag handler outside the widget wrapper. */
		transform: translateY(-100%);
		left: calc(0px - var(--ck-widget-outline-thickness));
		top: 0;
	}
@media (prefers-reduced-motion: reduce) {
.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle {
			transition: none;
	}
		}
.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle .ck-icon {
			/* Make sure the dimensions of the icon are independent of the fon-size of the content. */
			width: var(--ck-widget-handler-icon-size);
			height: var(--ck-widget-handler-icon-size);
			color: var(--ck-color-widget-drag-handler-icon-color);

			/* The "selected" part of the icon is invisible by default */
		}
.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle .ck-icon .ck-icon__selected-indicator {
				opacity: 0;

				/* Note: The animation is longer on purpose. Simply feels better. */
				transition: opacity 300ms var(--ck-widget-handler-animation-curve);
			}
@media (prefers-reduced-motion: reduce) {
.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle .ck-icon .ck-icon__selected-indicator {
					transition: none;
			}
				}
/* Advertise using the look of the icon that once clicked the handler, the widget will be selected. */
.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle:hover .ck-icon .ck-icon__selected-indicator {
			opacity: 1;
		}
/* Show the selection handler on mouse hover over the widget, but not for nested widgets. */
.ck .ck-widget.ck-widget_with-selection-handle:hover > .ck-widget__selection-handle {
		opacity: 1;
		background-color: var(--ck-color-widget-hover-border);
	}
/* Show the selection handler when the widget is selected, but not for nested widgets. */
.ck .ck-widget.ck-widget_with-selection-handle.ck-widget_selected > .ck-widget__selection-handle, .ck .ck-widget.ck-widget_with-selection-handle.ck-widget_selected:hover > .ck-widget__selection-handle {
			opacity: 1;
			background-color: var(--ck-color-focus-border);

			/* When the widget is selected, notify the user using the proper look of the icon. */
		}
.ck .ck-widget.ck-widget_with-selection-handle.ck-widget_selected > .ck-widget__selection-handle .ck-icon .ck-icon__selected-indicator, .ck .ck-widget.ck-widget_with-selection-handle.ck-widget_selected:hover > .ck-widget__selection-handle .ck-icon .ck-icon__selected-indicator {
				opacity: 1;
			}
/* In a RTL environment, align the selection handler to the right side of the widget */
/* stylelint-disable-next-line no-descending-specificity */
.ck[dir="rtl"] .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle {
	left: auto;
	right: calc(0px - var(--ck-widget-outline-thickness));
}
/* https://github.com/ckeditor/ckeditor5/issues/6415 */
.ck.ck-editor__editable.ck-read-only .ck-widget {
	/* Prevent the :hover outline from showing up because of the used outline-color transition. */
	transition: none;
}
.ck.ck-editor__editable.ck-read-only .ck-widget:not(.ck-widget_selected) {
		/* Disable visual effects of hover/active widget when CKEditor is in readOnly mode.
		 * See: https://github.com/ckeditor/ckeditor5/issues/1261
		 *
		 * Leave the unit because this custom property is used in calc() by other features.
		 * See: https://github.com/ckeditor/ckeditor5/issues/6775
		 */
		--ck-widget-outline-thickness: 0px;
	}
.ck.ck-editor__editable.ck-read-only .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle,
		.ck.ck-editor__editable.ck-read-only .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle:hover {
			background: var(--ck-color-widget-blurred-border);
		}
/* Style the widget when it's selected but the editable it belongs to lost focus. */
/* stylelint-disable-next-line no-descending-specificity */
.ck.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected,
	.ck.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected:hover {
		outline-color: var(--ck-color-widget-blurred-border);
	}
.ck.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected.ck-widget_with-selection-handle > .ck-widget__selection-handle,
			.ck.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected.ck-widget_with-selection-handle:hover > .ck-widget__selection-handle,
			.ck.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected.ck-widget_with-selection-handle > .ck-widget__selection-handle:hover,
			.ck.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected.ck-widget_with-selection-handle:hover > .ck-widget__selection-handle:hover {
				background: var(--ck-color-widget-blurred-border);
			}
.ck.ck-editor__editable > .ck-widget.ck-widget_with-selection-handle:first-child,
.ck.ck-editor__editable blockquote > .ck-widget.ck-widget_with-selection-handle:first-child {
	/* Do not crop selection handler if a widget is a first-child in the blockquote or in the root editable.
	In fact, anything with overflow: hidden.
	https://github.com/ckeditor/ckeditor5-block-quote/issues/28
	https://github.com/ckeditor/ckeditor5-widget/issues/44
	https://github.com/ckeditor/ckeditor5-widget/issues/66 */
	margin-top: calc(1em + var(--ck-widget-handler-icon-size));
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-resizer-size: 10px;

	/* Set the resizer with a 50% offset. */
	--ck-resizer-offset: calc( ( var(--ck-resizer-size) / -2 ) - 2px);
	--ck-resizer-border-width: 1px;
}
.ck .ck-widget__resizer {
	outline: 1px solid var(--ck-color-resizer);
}
.ck .ck-widget__resizer__handle {
	width: var(--ck-resizer-size);
	height: var(--ck-resizer-size);
	background: var(--ck-color-focus-border);
	border: var(--ck-resizer-border-width) solid hsl(0, 0%, 100%);
	border-radius: var(--ck-resizer-border-radius);
}
.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-top-left {
		top: var(--ck-resizer-offset);
		left: var(--ck-resizer-offset);
	}
.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-top-right {
		top: var(--ck-resizer-offset);
		right: var(--ck-resizer-offset);
	}
.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-bottom-right {
		bottom: var(--ck-resizer-offset);
		right: var(--ck-resizer-offset);
	}
.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-bottom-left {
		bottom: var(--ck-resizer-offset);
		left: var(--ck-resizer-offset);
	}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-widget-type-around-button-size: 20px;
	--ck-color-widget-type-around-button-active: var(--ck-color-focus-border);
	--ck-color-widget-type-around-button-hover: var(--ck-color-widget-hover-border);
	--ck-color-widget-type-around-button-blurred-editable: var(--ck-color-widget-blurred-border);
	--ck-color-widget-type-around-button-radar-start-alpha: 0;
	--ck-color-widget-type-around-button-radar-end-alpha: .3;
	--ck-color-widget-type-around-button-icon: var(--ck-color-base-background);
}
/*
	 * Styles of the type around buttons
	 */
.ck .ck-widget .ck-widget__type-around__button {
		width: var(--ck-widget-type-around-button-size);
		height: var(--ck-widget-type-around-button-size);
		background: var(--ck-color-widget-type-around-button);
		border-radius: 100px;
		transition: opacity var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve), background var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve);

		opacity: 0;

		pointer-events: none;
	}
@media (prefers-reduced-motion: reduce) {
.ck .ck-widget .ck-widget__type-around__button {
			transition: none;
	}
		}
.ck .ck-widget .ck-widget__type-around__button svg {
			width: 10px;
			height: 8px;
			transform: translate(-50%,-50%);
			transition: transform .5s ease;
			margin-top: 1px;
		}
@media (prefers-reduced-motion: reduce) {
.ck .ck-widget .ck-widget__type-around__button svg {
				transition: none;
		}
			}
.ck .ck-widget .ck-widget__type-around__button svg * {
				stroke-dasharray: 10;
				stroke-dashoffset: 0;

				fill: none;
				stroke: var(--ck-color-widget-type-around-button-icon);
				stroke-width: 1.5px;
				stroke-linecap: round;
				stroke-linejoin: round;
			}
.ck .ck-widget .ck-widget__type-around__button svg line {
				stroke-dasharray: 7;
			}
.ck .ck-widget .ck-widget__type-around__button:hover {
			/*
			 * Display the "sonar" around the button when hovered.
			 */
			animation: ck-widget-type-around-button-sonar 1s ease infinite;

			/*
			 * Animate active button's icon.
			 */
		}
.ck .ck-widget .ck-widget__type-around__button:hover svg polyline {
					animation: ck-widget-type-around-arrow-dash 2s linear;
				}
.ck .ck-widget .ck-widget__type-around__button:hover svg line {
					animation: ck-widget-type-around-arrow-tip-dash 2s linear;
				}
@media (prefers-reduced-motion: reduce) {
.ck .ck-widget .ck-widget__type-around__button:hover {
				animation: none;
		}
					.ck .ck-widget .ck-widget__type-around__button:hover svg polyline {
						animation: none;
					}

					.ck .ck-widget .ck-widget__type-around__button:hover svg line {
						animation: none;
					}
			}
/*
	 * Show type around buttons when the widget gets selected or being hovered.
	 */
.ck .ck-widget.ck-widget_selected > .ck-widget__type-around > .ck-widget__type-around__button, .ck .ck-widget:hover > .ck-widget__type-around > .ck-widget__type-around__button {
			opacity: 1;
			pointer-events: auto;
		}
/*
	 * Styles for the buttons when the widget is NOT selected (but the buttons are visible
	 * and still can be hovered).
	 */
.ck .ck-widget:not(.ck-widget_selected) > .ck-widget__type-around > .ck-widget__type-around__button {
		background: var(--ck-color-widget-type-around-button-hover);
	}
/*
	 * Styles for the buttons when:
	 * - the widget is selected,
	 * - or the button is being hovered (regardless of the widget state).
	 */
.ck .ck-widget.ck-widget_selected > .ck-widget__type-around > .ck-widget__type-around__button,
	.ck .ck-widget > .ck-widget__type-around > .ck-widget__type-around__button:hover {
		background: var(--ck-color-widget-type-around-button-active);
	}
.ck .ck-widget.ck-widget_selected > .ck-widget__type-around > .ck-widget__type-around__button::after, .ck .ck-widget > .ck-widget__type-around > .ck-widget__type-around__button:hover::after {
			width: calc(var(--ck-widget-type-around-button-size) - 2px);
			height: calc(var(--ck-widget-type-around-button-size) - 2px);
			border-radius: 100px;
			background: linear-gradient(135deg, hsla(0,0%,100%,0) 0%, hsla(0,0%,100%,.3) 100%);
		}
/*
	 * Styles for the "before" button when the widget has a selection handle. Because some space
	 * is consumed by the handle, the button must be moved slightly to the right to let it breathe.
	 */
.ck .ck-widget.ck-widget_with-selection-handle > .ck-widget__type-around > .ck-widget__type-around__button_before {
		margin-left: 20px;
	}
/*
	 * Styles for the horizontal "fake caret" which is displayed when the user navigates using the keyboard.
	 */
.ck .ck-widget .ck-widget__type-around__fake-caret {
		pointer-events: none;
		height: 1px;
		animation: ck-widget-type-around-fake-caret-pulse linear 1s infinite normal forwards;

		/*
		 * The semi-transparent-outline+background combo improves the contrast
		 * when the background underneath the fake caret is dark.
		 */
		outline: solid 1px hsla(0, 0%, 100%, .5);
		background: var(--ck-color-base-text);
	}
/*
	 * Styles of the widget when the "fake caret" is blinking (e.g. upon keyboard navigation).
	 * Despite the widget being physically selected in the model, its outline should disappear.
	 */
.ck .ck-widget.ck-widget_selected.ck-widget_type-around_show-fake-caret_before,
		.ck .ck-widget.ck-widget_selected.ck-widget_type-around_show-fake-caret_after {
			outline-color: transparent;
		}
/*
		 * When the "fake caret" is visible we simulate that the widget is not selected
		 * (despite being physically selected), so the outline color should be for the
		 * unselected widget.
		 */
.ck .ck-widget.ck-widget_type-around_show-fake-caret_before.ck-widget_selected:hover, .ck .ck-widget.ck-widget_type-around_show-fake-caret_after.ck-widget_selected:hover {
			outline-color: var(--ck-color-widget-hover-border);
		}
/*
		 * Styles of the type around buttons when the "fake caret" is blinking (e.g. upon keyboard navigation).
		 * In this state, the type around buttons would collide with the fake carets so they should disappear.
		 */
.ck .ck-widget.ck-widget_type-around_show-fake-caret_before > .ck-widget__type-around > .ck-widget__type-around__button, .ck .ck-widget.ck-widget_type-around_show-fake-caret_after > .ck-widget__type-around > .ck-widget__type-around__button {
			opacity: 0;
			pointer-events: none;
		}
/*
		 * Fake horizontal caret integration with the selection handle. When the caret is visible, simply
		 * hide the handle because it intersects with the caret (and does not make much sense anyway).
		 */
.ck .ck-widget.ck-widget_type-around_show-fake-caret_before.ck-widget_with-selection-handle.ck-widget_selected > .ck-widget__selection-handle, .ck .ck-widget.ck-widget_type-around_show-fake-caret_after.ck-widget_with-selection-handle.ck-widget_selected > .ck-widget__selection-handle, .ck .ck-widget.ck-widget_type-around_show-fake-caret_before.ck-widget_with-selection-handle.ck-widget_selected:hover > .ck-widget__selection-handle, .ck .ck-widget.ck-widget_type-around_show-fake-caret_after.ck-widget_with-selection-handle.ck-widget_selected:hover > .ck-widget__selection-handle {
					opacity: 0
				}
/*
		 * Fake horizontal caret integration with the resize UI. When the caret is visible, simply
		 * hide the resize UI because it creates too much noise. It can be visible when the user
		 * hovers the widget, though.
		 */
.ck .ck-widget.ck-widget_type-around_show-fake-caret_before.ck-widget_selected.ck-widget_with-resizer > .ck-widget__resizer, .ck .ck-widget.ck-widget_type-around_show-fake-caret_after.ck-widget_selected.ck-widget_with-resizer > .ck-widget__resizer {
			opacity: 0
		}
/*
 * Styles for the "before" button when the widget has a selection handle in an RTL environment.
 * The selection handler is aligned to the right side of the widget so there is no need to create
 * additional space for it next to the "before" button.
 */
.ck[dir="rtl"] .ck-widget.ck-widget_with-selection-handle .ck-widget__type-around > .ck-widget__type-around__button_before {
	margin-left: 0;
	margin-right: 20px;
}
/*
 * Hide type around buttons when the widget is selected as a child of a selected
 * nested editable (e.g. mulit-cell table selection).
 *
 * See https://github.com/ckeditor/ckeditor5/issues/7263.
 */
.ck-editor__nested-editable.ck-editor__editable_selected .ck-widget.ck-widget_selected > .ck-widget__type-around > .ck-widget__type-around__button, .ck-editor__nested-editable.ck-editor__editable_selected .ck-widget:hover > .ck-widget__type-around > .ck-widget__type-around__button {
				opacity: 0;
				pointer-events: none;
			}
/*
 * Styles for the buttons when the widget is selected but the user clicked outside of the editor (blurred the editor).
 */
.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected > .ck-widget__type-around > .ck-widget__type-around__button:not(:hover) {
	background: var(--ck-color-widget-type-around-button-blurred-editable);
}
.ck-editor__editable.ck-blurred .ck-widget.ck-widget_selected > .ck-widget__type-around > .ck-widget__type-around__button:not(:hover) svg * {
		stroke: hsl(0,0%,60%);
	}
@keyframes ck-widget-type-around-arrow-dash {
	0% {
		stroke-dashoffset: 10;
	}
	20%, 100% {
		stroke-dashoffset: 0;
	}
}
@keyframes ck-widget-type-around-arrow-tip-dash {
	0%, 20% {
		stroke-dashoffset: 7;
	}
	40%, 100% {
		stroke-dashoffset: 0;
	}
}
@keyframes ck-widget-type-around-button-sonar {
	0% {
		box-shadow: 0 0 0 0 hsla(var(--ck-color-focus-border-coordinates), var(--ck-color-widget-type-around-button-radar-start-alpha));
	}
	50% {
		box-shadow: 0 0 0 5px hsla(var(--ck-color-focus-border-coordinates), var(--ck-color-widget-type-around-button-radar-end-alpha));
	}
	100% {
		box-shadow: 0 0 0 5px hsla(var(--ck-color-focus-border-coordinates), var(--ck-color-widget-type-around-button-radar-start-alpha));
	}
}
@keyframes ck-widget-type-around-fake-caret-pulse {
	0% {
		opacity: 1;
	}
	49% {
		opacity: 1;
	}
	50% {
		opacity: 0;
	}
	99% {
		opacity: 0;
	}
	100% {
		opacity: 1;
	}
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content code {
	background-color: hsla(0, 0%, 78%, 0.3);
	padding: .15em;
	border-radius: 2px;
}

.ck.ck-editor__editable .ck-code_selected  {
	background-color: hsla(0, 0%, 78%, 0.5);
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content blockquote {
	/* See #12 */
	overflow: hidden;

	/* https://github.com/ckeditor/ckeditor5-block-quote/issues/15 */
	padding-right: 1.5em;
	padding-left: 1.5em;

	margin-left: 0;
	margin-right: 0;
	font-style: italic;
	border-left: solid 5px hsl(0, 0%, 80%);
}

.ck-content[dir="rtl"] blockquote {
	border-left: 0;
	border-right: solid 5px hsl(0, 0%, 80%);
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	/* Based on default CKBox theme colors */
	--ck-image-processing-highlight-color: hsl(220, 10%, 98%);
	--ck-image-processing-background-color: hsl(220, 10%, 90%);
}

.ck.ck-editor__editable .image.image-processing {
			position: relative;
		}

.ck.ck-editor__editable .image.image-processing:before {
				content: '';

				position: absolute;
				top: 0;
				left: 0;
				z-index: 1;

				height: 100%;
				width: 100%;

				background: linear-gradient(
					90deg,
					var(--ck-image-processing-background-color),
					var(--ck-image-processing-highlight-color),
					var(--ck-image-processing-background-color)
				);
				background-size: 200% 100%;

				animation: ck-image-processing-animation 2s linear infinite;
			}

.ck.ck-editor__editable .image.image-processing img {
				height: 100%;
			}

@keyframes ck-image-processing-animation {
	0% {
		background-position: 200% 0;
	}
	100% {
		background-position: -200% 0;
	}
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
	 * Vertical drop target (in text).
	 */

.ck.ck-editor__editable .ck.ck-clipboard-drop-target-position {
		display: inline;
		position: relative;
		pointer-events: none;
	}

.ck.ck-editor__editable .ck.ck-clipboard-drop-target-position span {
			position: absolute;
			width: 0;
		}

/*
	 * Styles of the widget being dragged (its preview).
	 */

.ck.ck-editor__editable .ck-widget:-webkit-drag > .ck-widget__selection-handle {
			display: none;
		}

.ck.ck-editor__editable .ck-widget:-webkit-drag > .ck-widget__type-around {
			display: none;
		}

.ck.ck-clipboard-drop-target-line {
	position: absolute;
	pointer-events: none;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content pre {
	padding: 1em;
	color: hsl(0, 0%, 20.8%);
	background: hsla(0, 0%, 78%, 0.3);
	border: 1px solid hsl(0, 0%, 77%);
	border-radius: 2px;

	/* Code block are language direction–agnostic. */
	text-align: left;
	direction: ltr;

	tab-size: 4;
	white-space: pre-wrap;

	/* Don't inherit the style, e.g. when in a block quote. */
	font-style: normal;

	/* Don't let the code be squashed e.g. when in a table cell. */
	min-width: 200px;
}

.ck-content pre code {
		background: unset;
		padding: 0;
		border-radius: 0;
	}

.ck.ck-editor__editable pre {
	position: relative;
}

.ck.ck-editor__editable pre[data-language]::after {
		content: attr(data-language);
		position: absolute;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-editor {
	/* All the elements within \`.ck-editor\` are positioned relatively to it.
	 If any element needs to be positioned with respect to the <body>, etc.,
	 it must land outside of the \`.ck-editor\` in DOM. */
	position: relative;
}

.ck.ck-editor .ck-editor__top .ck-sticky-panel .ck-toolbar {
		/* https://github.com/ckeditor/ckeditor5-editor-classic/issues/62 */
		z-index: var(--ck-z-panel);
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-menu-bar {
	border: none;
	border-bottom: 1px solid var(--ck-color-toolbar-border);
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* See ckeditor/ckeditor5#936. */
.ck.ck-placeholder,
.ck .ck-placeholder {
	position: relative;
}
.ck.ck-placeholder::before, .ck .ck-placeholder::before {
		position: absolute;
		left: 0;
		right: 0;
		content: attr(data-placeholder);

		/* See ckeditor/ckeditor5#469. */
		pointer-events: none;
	}

/* See ckeditor/ckeditor5#1987. */
.ck.ck-read-only .ck-placeholder::before {
		display: none;
	}

/*
 * Rules for the \`ck-placeholder\` are loaded before the rules for \`ck-reset_all\` in the base CKEditor 5 DLL build.
 * This fix overwrites the incorrectly set \`position: static\` from \`ck-reset_all\`.
 * See https://github.com/ckeditor/ckeditor5/issues/11418.
 */
.ck.ck-reset_all .ck-placeholder {
	position: relative;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* Elements marked by the Renderer as hidden should be invisible in the editor. */
.ck.ck-editor__editable span[data-ck-unsafe-element] {
	display: none;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-find-result {
	background: var(--ck-color-highlight-background);
	color: var(--ck-color-text);
}

.ck-find-result_selected {
	background: hsl(29, 100%, 60%);
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-find-and-replace-form {
	max-width: 100%;
}

.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs, .ck.ck-find-and-replace-form .ck-find-and-replace-form__actions {
		display: flex;

		/* The inputs area styles */
	}

.ck.ck-find-and-replace-form .ck-find-and-replace-form__inputs.ck-find-and-replace-form__inputs .ck-results-counter, .ck.ck-find-and-replace-form .ck-find-and-replace-form__actions.ck-find-and-replace-form__inputs .ck-results-counter {
			position: absolute;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* The values should be synchronized with the "FONT_SIZE_PRESET_UNITS" object in the "/src/fontsize/utils.js" file. */

/* Styles should be prefixed with the \`.ck-content\` class.
See https://github.com/ckeditor/ckeditor5/issues/6636 */
.ck-content .text-tiny {
		font-size: .7em;
	}
.ck-content .text-small {
		font-size: .85em;
	}
.ck-content .text-big {
		font-size: 1.4em;
	}
.ck-content .text-huge {
		font-size: 1.8em;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-heading_heading1 .ck-button__label {
	font-size: 20px;
}

.ck.ck-heading_heading2 .ck-button__label {
	font-size: 17px;
}

.ck.ck-heading_heading3 .ck-button__label {
	font-size: 14px;
}

.ck[class*="ck-heading_heading"] {
	font-weight: bold;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-highlight-marker-yellow: hsl(60, 97%, 73%);
	--ck-highlight-marker-green: hsl(120, 93%, 68%);
	--ck-highlight-marker-pink: hsl(345, 96%, 73%);
	--ck-highlight-marker-blue: hsl(201, 97%, 72%);
	--ck-highlight-pen-red: hsl(0, 85%, 49%);
	--ck-highlight-pen-green: hsl(112, 100%, 27%);
}

.ck-content .marker-yellow {
		background-color: var(--ck-highlight-marker-yellow);
	}
.ck-content .marker-green {
		background-color: var(--ck-highlight-marker-green);
	}
.ck-content .marker-pink {
		background-color: var(--ck-highlight-marker-pink);
	}
.ck-content .marker-blue {
		background-color: var(--ck-highlight-marker-blue);
	}

.ck-content .pen-red {
		color: var(--ck-highlight-pen-red);

		/* Override default yellow background of \`<mark>\` from user agent stylesheet */
		background-color: transparent;
	}
.ck-content .pen-green {
		color: var(--ck-highlight-pen-green);

		/* Override default yellow background of \`<mark>\` from user agent stylesheet */
		background-color: transparent;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */


.ck-editor__editable .ck-horizontal-line {
	/* Necessary to render properly next to floated objects, e.g. side image case. */
	display: flow-root;
}

.ck-content hr {
	margin: 15px 0;
	height: 4px;
	background: hsl(0, 0%, 87%);
	border: 0;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* The feature container. */
.ck-widget.raw-html-embed {
	/* Give the embed some air. */
	/* The first value should be equal to --ck-spacing-large variable if used in the editor context
	to avoid the content jumping (See https://github.com/ckeditor/ckeditor5/issues/9825). */
	margin: 0.9em auto;
	position: relative;
	display: flow-root;

	/* Give the html embed some minimal width in the content to prevent them
	from being "squashed" in tight spaces, e.g. in table cells (https://github.com/ckeditor/ckeditor5/issues/8331) */
	min-width: 15em;

	/* Don't inherit the style, e.g. when in a block quote. */
	font-style: normal;

	/* ----- Emebed label in the upper left corner ----------------------------------------------- */
}
.ck-widget.raw-html-embed::before {
		position: absolute;

		/* Make sure the content does not cover the label. */
		z-index: 1;
	}
/* ----- Emebed internals --------------------------------------------------------------------- */
/* The switch mode button wrapper. */
.ck-widget.raw-html-embed .raw-html-embed__buttons-wrapper {
		position: absolute;
		display: flex;
		flex-direction: column;
	}
.ck-widget.raw-html-embed .raw-html-embed__preview {
		position: relative;
		overflow: hidden;
		display: flex;
	}
.ck-widget.raw-html-embed .raw-html-embed__preview-content {
		width: 100%;
		position: relative;
		margin: auto;

		/* Gives spacing to the small renderable elements, so they always cover the placeholder. */
		display: table;
		border-collapse: separate;
		border-spacing: 7px;
	}
.ck-widget.raw-html-embed .raw-html-embed__preview-placeholder {
		position: absolute;
		left: 0;
		top: 0;
		right: 0;
		bottom: 0;

		display: flex;
		align-items: center;
		justify-content: center;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-html-object-embed-unfocused-outline-width: 1px;
}

.ck-widget.html-object-embed {
	font-size: var(--ck-font-size-base);
	background-color: var(--ck-color-base-foreground);
	padding: var(--ck-spacing-small);
	/* Leave space for label */
	padding-top: calc(var(--ck-font-size-tiny) + var(--ck-spacing-large));
	min-width: calc(76px + var(--ck-spacing-standard));
}

.ck-widget.html-object-embed:not(.ck-widget_selected):not(:hover) {
		outline: var(--ck-html-object-embed-unfocused-outline-width) dashed var(--ck-color-widget-blurred-border);
	}

.ck-widget.html-object-embed::before {
		font-weight: normal;
		font-style: normal;
		position: absolute;
		content: attr(data-html-object-embed-label);
		top: 0;
		left: var(--ck-spacing-standard);
		background: hsl(0deg 0% 60%);
		transition: background var(--ck-widget-handler-animation-duration) var(--ck-widget-handler-animation-curve);
		padding: calc(var(--ck-spacing-tiny) + var(--ck-html-object-embed-unfocused-outline-width)) var(--ck-spacing-small) var(--ck-spacing-tiny);
		border-radius: 0 0 var(--ck-border-radius) var(--ck-border-radius);
		color: var(--ck-color-base-background);
		font-size: var(--ck-font-size-tiny);
		font-family: var(--ck-font-face);
	}

/* Make space for label. */

.ck-widget.html-object-embed .ck-widget__type-around .ck-widget__type-around__button.ck-widget__type-around__button_before {
		margin-left: 50px;
	}

.ck-widget.html-object-embed .html-object-embed__content {
		/* Disable user interaction with embed content */
		pointer-events: none;
	}

div.ck-widget.html-object-embed {
	margin: 1em auto;
}

span.ck-widget.html-object-embed {
	display: inline-block;
}


/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-color-image-caption-background: hsl(0, 0%, 97%);
	--ck-color-image-caption-text: hsl(0, 0%, 20%);
	--ck-color-image-caption-highlighted-background: hsl(52deg 100% 50%);
}

/* Content styles */
.ck-content .image > figcaption {
	display: table-caption;
	caption-side: bottom;
	word-break: break-word;
	color: var(--ck-color-image-caption-text);
	background-color: var(--ck-color-image-caption-background);
	padding: .6em;
	font-size: .75em;
	outline-offset: -1px;

	/* Improve placeholder rendering in high-constrast mode (https://github.com/ckeditor/ckeditor5/issues/14907). */
}
@media (forced-colors: active) {
.ck-content .image > figcaption {
		background-color: unset;
		color: unset;
}
	}

/* Editing styles */
@media (forced-colors: none) {
		.ck.ck-editor__editable .image > figcaption.image__caption_highlighted {
		animation: ck-image-caption-highlight .6s ease-out;
		}
	}
@media (prefers-reduced-motion: reduce) {
.ck.ck-editor__editable .image > figcaption.image__caption_highlighted {
		animation: none;
}
	}

@keyframes ck-image-caption-highlight {
	0% {
		background-color: var(--ck-color-image-caption-highlighted-background);
	}

	100% {
		background-color: var(--ck-color-image-caption-background);
	}
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-image-insert-url {
	width: 400px;
	padding: var(--ck-spacing-large) var(--ck-spacing-large) 0;
}

.ck.ck-image-insert-url .ck-image-insert-url__action-row {
		display: grid;
		grid-template-columns: repeat(2, 1fr);
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* Preserve aspect ratio of the resized image after introducing image height attribute. */
.ck-content img.image_resized {
	height: auto;
}

.ck-content .image.image_resized {
	max-width: 100%;
	/*
	The \`<figure>\` element for resized images must not use \`display:table\` as browsers do not support \`max-width\` for it well.
	See https://stackoverflow.com/questions/4019604/chrome-safari-ignoring-max-width-in-table/14420691#14420691 for more.
	Fortunately, since we control the width, there is no risk that the image will look bad.
	*/
	display: block;
	box-sizing: border-box;
}

.ck-content .image.image_resized img {
		/* For resized images it is the \`<figure>\` element that determines the image width. */
		width: 100%;
	}

.ck-content .image.image_resized > figcaption {
		/* The \`<figure>\` element uses \`display:block\`, so \`<figcaption>\` also has to. */
		display: block;
	}

/* The resized inline image nested in the table should respect its parent size.
	See https://github.com/ckeditor/ckeditor5/issues/9117. */

.ck.ck-editor__editable td .image-inline.image_resized img, .ck.ck-editor__editable th .image-inline.image_resized img {
			max-width: 100%;
		}

[dir="ltr"] .ck.ck-button.ck-button_with-text.ck-resize-image-button .ck-button__icon {
	margin-right: var(--ck-spacing-standard);
}

[dir="rtl"] .ck.ck-button.ck-button_with-text.ck-resize-image-button .ck-button__icon {
	margin-left: var(--ck-spacing-standard);
}

.ck.ck-dropdown .ck-button.ck-resize-image-button .ck-button__label {
	width: 4em;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-image-custom-resize-form {
	display: flex;
	flex-direction: row;
	flex-wrap: nowrap;
	align-items: flex-start;
}

.ck.ck-image-custom-resize-form .ck-labeled-field-view {
		display: inline-block;
	}

.ck.ck-image-custom-resize-form .ck-label {
		display: none;
	}

@media screen and (max-width: 600px) {

.ck.ck-image-custom-resize-form {
		flex-wrap: wrap;
}

		.ck.ck-image-custom-resize-form .ck-labeled-field-view {
			flex-basis: 100%;
		}

		.ck.ck-image-custom-resize-form .ck-button {
			flex-basis: 50%;
		}
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-image-style-spacing: 1.5em;
	--ck-inline-image-style-spacing: calc(var(--ck-image-style-spacing) / 2);
}

/* See: https://github.com/ckeditor/ckeditor5/issues/16317 */

/* Provides a minimal side margin for the left and right aligned images, so that the user has a visual feedback
		confirming successful application of the style if image width exceeds the editor's size.
		See https://github.com/ckeditor/ckeditor5/issues/9342 */

.ck-content .image.image-style-block-align-left,
		.ck-content .image.image-style-block-align-right {
			max-width: calc(100% - var(--ck-image-style-spacing));
		}

/* Allows displaying multiple floating images in the same line.
		See https://github.com/ckeditor/ckeditor5/issues/9183#issuecomment-804988132 */

.ck-content .image.image-style-align-left,
		.ck-content .image.image-style-align-right {
			clear: none;
		}

.ck-content .image.image-style-side {
			float: right;
			margin-left: var(--ck-image-style-spacing);
			max-width: 50%;
		}

.ck-content .image.image-style-align-left {
			float: left;
			margin-right: var(--ck-image-style-spacing);
		}

.ck-content .image.image-style-align-right {
			float: right;
			margin-left: var(--ck-image-style-spacing);
		}

.ck-content .image.image-style-block-align-right {
			margin-right: 0;
			margin-left: auto;
		}

.ck-content .image.image-style-block-align-left {
			margin-left: 0;
			margin-right: auto;
		}

.ck-content .image-style-align-center {
		margin-left: auto;
		margin-right: auto;
	}

.ck-content .image-style-align-left {
		float: left;
		margin-right: var(--ck-image-style-spacing);
	}

.ck-content .image-style-align-right {
		float: right;
		margin-left: var(--ck-image-style-spacing);
	}

/* Simulates margin collapsing with the preceding paragraph, which does not work for the floating elements. */

.ck-content p + .image.image-style-align-left,
	.ck-content p + .image.image-style-align-right,
	.ck-content p + .image.image-style-side {
		margin-top: 0;
	}

.ck-content .image-inline.image-style-align-left,
		.ck-content .image-inline.image-style-align-right {
			margin-top: var(--ck-inline-image-style-spacing);
			margin-bottom: var(--ck-inline-image-style-spacing);
		}

.ck-content .image-inline.image-style-align-left {
			margin-right: var(--ck-inline-image-style-spacing);
		}

.ck-content .image-inline.image-style-align-right {
			margin-left: var(--ck-inline-image-style-spacing);
		}

/* The button should display as a regular drop-down if the action button
	is forced to fire the same action as the arrow button. */

.ck.ck-splitbutton.ck-splitbutton_flatten:hover > .ck-splitbutton__action:not(.ck-disabled),
			.ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open > .ck-splitbutton__action:not(.ck-disabled),
			.ck.ck-splitbutton.ck-splitbutton_flatten:hover > .ck-splitbutton__arrow:not(.ck-disabled),
			.ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open > .ck-splitbutton__arrow:not(.ck-disabled),
			.ck.ck-splitbutton.ck-splitbutton_flatten:hover > .ck-splitbutton__arrow:not(.ck-disabled):not(:hover),
			.ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open > .ck-splitbutton__arrow:not(.ck-disabled):not(:hover) {
				background-color: var(--ck-color-button-on-background);
			}

.ck.ck-splitbutton.ck-splitbutton_flatten:hover > .ck-splitbutton__action:not(.ck-disabled)::after, .ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open > .ck-splitbutton__action:not(.ck-disabled)::after, .ck.ck-splitbutton.ck-splitbutton_flatten:hover > .ck-splitbutton__arrow:not(.ck-disabled)::after, .ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open > .ck-splitbutton__arrow:not(.ck-disabled)::after, .ck.ck-splitbutton.ck-splitbutton_flatten:hover > .ck-splitbutton__arrow:not(.ck-disabled):not(:hover)::after, .ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open > .ck-splitbutton__arrow:not(.ck-disabled):not(:hover)::after {
					display: none;
				}

.ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open:hover > .ck-splitbutton__action:not(.ck-disabled),
			.ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open:hover > .ck-splitbutton__arrow:not(.ck-disabled),
			.ck.ck-splitbutton.ck-splitbutton_flatten.ck-splitbutton_open:hover > .ck-splitbutton__arrow:not(.ck-disabled):not(:hover) {
				background-color: var(--ck-color-button-on-hover-background);
			}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-text-alternative-form {
	display: flex;
	flex-direction: row;
	flex-wrap: nowrap;
}

.ck.ck-text-alternative-form .ck-labeled-field-view {
		display: inline-block;
	}

.ck.ck-text-alternative-form .ck-label {
		display: none;
	}

@media screen and (max-width: 600px) {

.ck.ck-text-alternative-form {
		flex-wrap: wrap;
}

		.ck.ck-text-alternative-form .ck-labeled-field-view {
			flex-basis: 100%;
		}

		.ck.ck-text-alternative-form .ck-button {
			flex-basis: 50%;
		}
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-editor__editable .image,
	.ck.ck-editor__editable .image-inline {
		position: relative;
	}

/* Upload progress bar. */

.ck.ck-editor__editable .image .ck-progress-bar,
	.ck.ck-editor__editable .image-inline .ck-progress-bar {
		position: absolute;
		top: 0;
		left: 0;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-image-upload-complete-icon {
	display: block;
	position: absolute;

	/*
	 * Smaller images should have the icon closer to the border.
	 * Match the icon position with the linked image indicator brought by the link image feature.
	 */
	top: min(var(--ck-spacing-medium), 6%);
	right: min(var(--ck-spacing-medium), 6%);
	border-radius: 50%;
	z-index: 1;
}

.ck-image-upload-complete-icon::after {
		content: "";
		position: absolute;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck .ck-upload-placeholder-loader {
	position: absolute;
	display: flex;
	align-items: center;
	justify-content: center;
	top: 0;
	left: 0;
}

.ck .ck-upload-placeholder-loader::before {
		content: '';
		position: relative;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content .image {
		display: table;
		clear: both;
		text-align: center;

		/* Make sure there is some space between the content and the image. Center image by default. */
		/* The first value should be equal to --ck-spacing-large variable if used in the editor context
	 	to avoid the content jumping (See https://github.com/ckeditor/ckeditor5/issues/9825). */
		margin: 0.9em auto;

		/* Make sure the caption will be displayed properly (See: https://github.com/ckeditor/ckeditor5/issues/1870). */
		min-width: 50px;
	}

.ck-content .image img {
			/* Prevent unnecessary margins caused by line-height (see #44). */
			display: block;

			/* Center the image if its width is smaller than the content's width. */
			margin: 0 auto;

			/* Make sure the image never exceeds the size of the parent container (ckeditor/ckeditor5-ui#67). */
			max-width: 100%;

			/* Make sure the image is never smaller than the parent container (See: https://github.com/ckeditor/ckeditor5/issues/9300). */
			min-width: 100%;

			/* Keep proportions of the block image if the height is set and the image is wider than the editor width.
			See https://github.com/ckeditor/ckeditor5/issues/14542. */
			height: auto;
		}

.ck-content .image-inline {
		/*
		 * Normally, the .image-inline would have "display: inline-block" and "img { width: 100% }" (to follow the wrapper while resizing).
		 * Unfortunately, together with "srcset", it gets automatically stretched up to the width of the editing root.
		 * This strange behavior does not happen with inline-flex.
		 */
		display: inline-flex;

		/* While being resized, don't allow the image to exceed the width of the editing root. */
		max-width: 100%;

		/* This is required by Safari to resize images in a sensible way. Without this, the browser breaks the ratio. */
		align-items: flex-start;

		/* When the picture is present it must act as a flex container to let the img resize properly */
	}

.ck-content .image-inline picture {
			display: flex;
		}

/* When the picture is present, it must act like a resizable img. */

.ck-content .image-inline picture,
		.ck-content .image-inline img {
			/* This is necessary for the img to span the entire .image-inline wrapper and to resize properly. */
			flex-grow: 1;
			flex-shrink: 1;

			/* Prevents overflowing the editing root boundaries when an inline image is very wide. */
			max-width: 100%;
		}

/*
	 * Inhertit the content styles padding of the <figcaption> in case the integration overrides \`text-align: center\`
	 * of \`.image\` (e.g. to the left/right). This ensures the placeholder stays at the padding just like the native
	 * caret does, and not at the edge of <figcaption>.
	 */

.ck.ck-editor__editable .image > figcaption.ck-placeholder::before {
		padding-left: inherit;
		padding-right: inherit;

		/*
		 * Make sure the image caption placeholder doesn't overflow the placeholder area.
		 * See https://github.com/ckeditor/ckeditor5/issues/9162.
		 */
		white-space: nowrap;
		overflow: hidden;
		text-overflow: ellipsis;
	}

/*
	 * See https://github.com/ckeditor/ckeditor5/issues/15115.
	 */

.ck.ck-editor__editable .image {
		z-index: 1;

		/*
		 * Make sure the selected image always stays on top of its siblings.
		 * See https://github.com/ckeditor/ckeditor5/issues/9108.
		 */
	}

.ck.ck-editor__editable .image.ck-widget_selected {
			z-index: 2;
		}

/*
	 * See https://github.com/ckeditor/ckeditor5/issues/15115.
	 */

.ck.ck-editor__editable .image-inline {
		z-index: 1;

		/*
		 * Make sure the selected inline image always stays on top of its siblings.
		 * See https://github.com/ckeditor/ckeditor5/issues/9108.
		 */
	}

.ck.ck-editor__editable .image-inline.ck-widget_selected {
			z-index: 2;

			/*
			 * Make sure the native browser selection style is not displayed.
			 * Inline image widgets have their own styles for the selected state and
			 * leaving this up to the browser is asking for a visual collision.
			 */
		}

.ck.ck-editor__editable .image-inline.ck-widget_selected ::selection {
				display: none;
			}

/* Keep proportions of the inline image if the height is set and the image is wider than the editor width.
	See https://github.com/ckeditor/ckeditor5/issues/14542. */

.ck.ck-editor__editable .image-inline img {
		height: auto;
	}

/* The inline image nested in the table should have its original size if not resized.
	See https://github.com/ckeditor/ckeditor5/issues/9117. */

.ck.ck-editor__editable td .image-inline img, .ck.ck-editor__editable th .image-inline img {
			max-width: none;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-editor__editable img.image_placeholder {
		background-size: 100% 100%;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* Linked image indicator */

.ck.ck-editor__editable figure.image > a::after, .ck.ck-editor__editable a span.image-inline::after {
			display: block;
			position: absolute;
		}


/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-link-actions {
	display: flex;
	flex-direction: row;
	flex-wrap: nowrap;
}

.ck.ck-link-actions .ck-link-actions__preview {
		display: inline-block;
	}

.ck.ck-link-actions .ck-link-actions__preview .ck-button__label {
			overflow: hidden;
		}

@media screen and (max-width: 600px) {

.ck.ck-link-actions {
		flex-wrap: wrap;
}

		.ck.ck-link-actions .ck-link-actions__preview {
			flex-basis: 100%;
		}

		.ck.ck-link-actions .ck-button:not(.ck-link-actions__preview) {
			flex-basis: 50%;
		}
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-link-form {
	display: flex;
	align-items: flex-start;
}

.ck.ck-link-form .ck-label {
		display: none;
	}

@media screen and (max-width: 600px) {

.ck.ck-link-form {
		flex-wrap: wrap;
}

		.ck.ck-link-form .ck-labeled-field-view {
			flex-basis: 100%;
		}

		.ck.ck-link-form .ck-button {
			flex-basis: 50%;
		}
	}

/*
 * Style link form differently when manual decorators are available.
 * See: https://github.com/ckeditor/ckeditor5-link/issues/186.
 */
.ck.ck-link-form_layout-vertical {
	display: block;

	/*
	 * Whether the form is in the responsive mode or not, if there are decorator buttons
	 * keep the top margin of action buttons medium.
	 */
}
.ck.ck-link-form_layout-vertical .ck-button.ck-button-save,
		.ck.ck-link-form_layout-vertical .ck-button.ck-button-cancel {
			margin-top: var(--ck-spacing-medium);
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-editor__editable .ck-list-bogus-paragraph {
	display: block;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-list-styles-list {
	display: grid;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content ol {
	list-style-type: decimal;
}

.ck-content ol ol {
		list-style-type: lower-latin;
	}

.ck-content ol ol ol {
			list-style-type: lower-roman;
		}

.ck-content ol ol ol ol {
				list-style-type: upper-latin;
			}

.ck-content ol ol ol ol ol {
					list-style-type: upper-roman;
				}

.ck-content ul {
	list-style-type: disc;
}

.ck-content ul ul {
		list-style-type: circle;
	}

.ck-content ul ul ul {
			list-style-type: square;
		}

.ck-content ul ul ul ul {
				list-style-type: square;
			}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-todo-list-checkmark-size: 16px;
}

/*
 * To-do list content styles.
 */
.ck-content .todo-list {
	list-style: none;
}
.ck-content .todo-list li {
		position: relative;
		margin-bottom: 5px;
	}
.ck-content .todo-list li .todo-list {
			margin-top: 5px;
		}
.ck-content .todo-list .todo-list__label > input {
			-webkit-appearance: none;
			display: inline-block;
			position: relative;
			width: var(--ck-todo-list-checkmark-size);
			height: var(--ck-todo-list-checkmark-size);
			vertical-align: middle;
			/* Needed on iOS */
			border: 0;
			/* LTR styles */
			left: -25px;
			margin-right: -15px;
			right: 0;
			margin-left: 0;
			/* RTL styles */
		}
.ck-content[dir=rtl] .todo-list .todo-list__label > input {
		left: 0;
		margin-right: 0;
		right: -25px;
		margin-left: -15px;
		}
.ck-content .todo-list .todo-list__label > input::before {
		display: block;
		position: absolute;
		box-sizing: border-box;
		content: '';
		width: 100%;
		height: 100%;
		border: 1px solid hsl(0, 0%, 20%);
		border-radius: 2px;
		transition: 250ms ease-in-out box-shadow;
	}
@media (prefers-reduced-motion: reduce) {
.ck-content .todo-list .todo-list__label > input::before {
			transition: none;
	}
		}
.ck-content .todo-list .todo-list__label > input::after {
		display: block;
		position: absolute;
		box-sizing: content-box;
		pointer-events: none;
		content: '';

		/* Calculate tick position, size and border-width proportional to the checkmark size. */
		left: calc( var(--ck-todo-list-checkmark-size) / 3 );
		top: calc( var(--ck-todo-list-checkmark-size) / 5.3 );
		width: calc( var(--ck-todo-list-checkmark-size) / 5.3 );
		height: calc( var(--ck-todo-list-checkmark-size) / 2.6 );
		border-style: solid;
		border-color: transparent;
		border-width: 0 calc( var(--ck-todo-list-checkmark-size) / 8 ) calc( var(--ck-todo-list-checkmark-size) / 8 ) 0;
		transform: rotate(45deg);
	}
.ck-content .todo-list .todo-list__label > input[checked]::before {
			background: hsl(126, 64%, 41%);
			border-color: hsl(126, 64%, 41%);
		}
.ck-content .todo-list .todo-list__label > input[checked]::after {
			border-color: hsl(0, 0%, 100%);
		}
.ck-content .todo-list .todo-list__label .todo-list__label__description {
			vertical-align: middle;
		}
.ck-content .todo-list .todo-list__label.todo-list__label_without-description input[type=checkbox] {
			position: absolute;
		}

/*
 * To-do list editing view styles.
 */
/*
	 * To-do list should be interactive only during the editing
	 * (https://github.com/ckeditor/ckeditor5/issues/2090).
	 */
.ck-editor__editable.ck-content .todo-list .todo-list__label > input,
	.ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input {
		cursor: pointer;
	}
.ck-editor__editable.ck-content .todo-list .todo-list__label > input:hover::before, .ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input:hover::before {
			box-shadow: 0 0 0 5px hsla(0, 0%, 0%, 0.1);
		}
/*
	 * Document Lists - editing view has an additional span around checkbox.
	 */
.ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input {
		-webkit-appearance: none;
		display: inline-block;
		position: relative;
		width: var(--ck-todo-list-checkmark-size);
		height: var(--ck-todo-list-checkmark-size);
		vertical-align: middle;
		/* Needed on iOS */
		border: 0;
		/* LTR styles */
		left: -25px;
		margin-right: -15px;
		right: 0;
		margin-left: 0;
		/* RTL styles */
	}
.ck-editor__editable.ck-content[dir=rtl] .todo-list .todo-list__label > span[contenteditable=false] > input {
		left: 0;
		margin-right: 0;
		right: -25px;
		margin-left: -15px;
	}
.ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input::before {
		display: block;
		position: absolute;
		box-sizing: border-box;
		content: '';
		width: 100%;
		height: 100%;
		border: 1px solid hsl(0, 0%, 20%);
		border-radius: 2px;
		transition: 250ms ease-in-out box-shadow;
	}
@media (prefers-reduced-motion: reduce) {
.ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input::before {
			transition: none;
	}
		}
.ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input::after {
		display: block;
		position: absolute;
		box-sizing: content-box;
		pointer-events: none;
		content: '';

		/* Calculate tick position, size and border-width proportional to the checkmark size. */
		left: calc( var(--ck-todo-list-checkmark-size) / 3 );
		top: calc( var(--ck-todo-list-checkmark-size) / 5.3 );
		width: calc( var(--ck-todo-list-checkmark-size) / 5.3 );
		height: calc( var(--ck-todo-list-checkmark-size) / 2.6 );
		border-style: solid;
		border-color: transparent;
		border-width: 0 calc( var(--ck-todo-list-checkmark-size) / 8 ) calc( var(--ck-todo-list-checkmark-size) / 8 ) 0;
		transform: rotate(45deg);
	}
.ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input[checked]::before {
			background: hsl(126, 64%, 41%);
			border-color: hsl(126, 64%, 41%);
		}
.ck-editor__editable.ck-content .todo-list .todo-list__label > span[contenteditable=false] > input[checked]::after {
			border-color: hsl(0, 0%, 100%);
		}
.ck-editor__editable.ck-content .todo-list .todo-list__label.todo-list__label_without-description input[type=checkbox] {
			position: absolute;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content .media {
	/* Don't allow floated content overlap the media.
	https://github.com/ckeditor/ckeditor5-media-embed/issues/53 */
	clear: both;

	/* Make sure there is some space between the content and the media. */
	/* The first value should be equal to --ck-spacing-large variable if used in the editor context
	to avoid the content jumping (See https://github.com/ckeditor/ckeditor5/issues/9825). */
	margin: 0.9em 0;

	/* Make sure media is not overriden with Bootstrap default \`flex\` value.
	See: https://github.com/ckeditor/ckeditor5/issues/1373. */
	display: block;

	/* Give the media some minimal width in the content to prevent them
	from being "squashed" in tight spaces, e.g. in table cells (#44) */
	min-width: 15em;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-media__wrapper .ck-media__placeholder {
		display: flex;
		flex-direction: column;
		align-items: center;
	}

.ck-media__wrapper .ck-media__placeholder .ck-media__placeholder__url {
			/* Otherwise the URL will overflow when the content is very narrow. */
			max-width: 100%;

			position: relative;
		}

.ck-media__wrapper .ck-media__placeholder .ck-media__placeholder__url .ck-media__placeholder__url__text {
				overflow: hidden;
				display: block;
			}

.ck-media__wrapper[data-oembed-url*="twitter.com"] .ck-media__placeholder__icon *, .ck-media__wrapper[data-oembed-url*="google.com/maps"] .ck-media__placeholder__icon *, .ck-media__wrapper[data-oembed-url*="goo.gl/maps"] .ck-media__placeholder__icon *, .ck-media__wrapper[data-oembed-url*="maps.google.com"] .ck-media__placeholder__icon *, .ck-media__wrapper[data-oembed-url*="maps.app.goo.gl"] .ck-media__placeholder__icon *, .ck-media__wrapper[data-oembed-url*="facebook.com"] .ck-media__placeholder__icon *, .ck-media__wrapper[data-oembed-url*="instagram.com"] .ck-media__placeholder__icon * {
			display: none;
		}

/* Disable all mouse interaction as long as the editor is not read–only.
   https://github.com/ckeditor/ckeditor5-media-embed/issues/58 */
.ck-editor__editable:not(.ck-read-only) .ck-media__wrapper > *:not(.ck-media__placeholder) {
	pointer-events: none;
}

/* Disable all mouse interaction when the widget is not selected (e.g. to avoid opening links by accident).
   https://github.com/ckeditor/ckeditor5-media-embed/issues/18 */
.ck-editor__editable:not(.ck-read-only) .ck-widget:not(.ck-widget_selected) .ck-media__placeholder {
	pointer-events: none;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-vertical-form .ck-button::after {
		content: "";
		width: 0;
		position: absolute;
		right: -1px;
		top: -1px;
		bottom: -1px;
		z-index: 1;
	}

.ck-vertical-form .ck-button:focus::after {
		display: none;
	}

@media screen and (max-width: 600px) {
			.ck.ck-responsive-form .ck-button::after {
				content: "";
				width: 0;
				position: absolute;
				right: -1px;
				top: -1px;
				bottom: -1px;
				z-index: 1;
			}

			.ck.ck-responsive-form .ck-button:focus::after {
				display: none;
			}
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-media-form {
	display: flex;
	align-items: flex-start;
	flex-direction: row;
	flex-wrap: nowrap;
	width: 400px;
}

.ck.ck-media-form .ck-labeled-field-view {
		display: inline-block;
		width: 100%;
	}

.ck.ck-media-form .ck-label {
		display: none;
	}

.ck.ck-media-form .ck-input {
		width: 100%;
	}

@media screen and (max-width: 600px) {

.ck.ck-media-form {
		flex-wrap: wrap;
}

		.ck.ck-media-form .ck-labeled-field-view {
			flex-basis: 100%;
		}

		.ck.ck-media-form .ck-button {
			flex-basis: 50%;
		}
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-mention-list-max-height: 300px;
}

.ck.ck-mentions {
	max-height: var(--ck-mention-list-max-height);

	overflow-y: auto;

	/* Prevent unnecessary horizontal scrollbar in Safari
	https://github.com/ckeditor/ckeditor5-mention/issues/41 */
	overflow-x: hidden;

	overscroll-behavior: contain;

	/* Prevent unnecessary vertical scrollbar in Safari
	https://github.com/ckeditor/ckeditor5-mention/issues/41 */
}

.ck.ck-mentions > .ck-list__item {
		overflow: hidden;
		flex-shrink: 0;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-color-minimap-tracker-background: 208, 0%, 51%;
	--ck-color-minimap-iframe-outline: hsl(0deg 0% 75%);
	--ck-color-minimap-iframe-shadow: hsl(0deg 0% 0% / 11%);
	--ck-color-minimap-progress-background: hsl(0,0%,40%);
}

.ck.ck-minimap {
	position: absolute;
	user-select: none;
	background: var(--ck-color-base-background);
}

.ck.ck-minimap,
	.ck.ck-minimap iframe {
		width: 100%;
		height: 100%;
	}

.ck.ck-minimap iframe {
		border: 0;
		pointer-events: none;
		position: relative;
		outline: 1px solid var(--ck-color-minimap-iframe-outline);
		box-shadow: 0 2px 5px var(--ck-color-minimap-iframe-shadow);
		margin: 0;
	}

.ck.ck-minimap .ck.ck-minimap__position-tracker {
		position: absolute;
		width: 100%;
		top: 0;
		background: hsla( var(--ck-color-minimap-tracker-background), .2 );
		z-index: 1;
		transition: background 100ms ease-in-out;
	}

@media (prefers-reduced-motion: reduce) {

.ck.ck-minimap .ck.ck-minimap__position-tracker {
			transition: none;
	}
		}

.ck.ck-minimap .ck.ck-minimap__position-tracker:hover {
			background:hsla( var(--ck-color-minimap-tracker-background), .3 );
		}

.ck.ck-minimap .ck.ck-minimap__position-tracker.ck-minimap__position-tracker_dragging,
		.ck.ck-minimap .ck.ck-minimap__position-tracker.ck-minimap__position-tracker_dragging:hover {
			background:hsla( var(--ck-color-minimap-tracker-background), .4 );
		}

.ck.ck-minimap .ck.ck-minimap__position-tracker.ck-minimap__position-tracker_dragging::after, .ck.ck-minimap .ck.ck-minimap__position-tracker.ck-minimap__position-tracker_dragging:hover::after {
				opacity: 1;
			}

.ck.ck-minimap .ck.ck-minimap__position-tracker::after {
			content: attr(data-progress) "%";
			position: absolute;
			top: 5px;
			right: 5px;
			background: var(--ck-color-minimap-progress-background);
			color: var(--ck-color-base-background);
			border: 1px solid var(--ck-color-base-background);
			padding: 2px 4px;
			font-size: 10px;
			border-radius: 3px;
			opacity: 0;
			transition: opacity 100ms ease-in-out;
		}

@media (prefers-reduced-motion: reduce) {

.ck.ck-minimap .ck.ck-minimap__position-tracker::after {
				transition: none;
		}
			}


/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content .page-break {
	position: relative;
	clear: both;
	padding: 5px 0;
	display: flex;
	align-items: center;
	justify-content: center;
}

.ck-content .page-break::after {
		content: '';
		position: absolute;
		border-bottom: 2px dashed hsl(0, 0%, 77%);
		width: 100%;
	}

.ck-content .page-break__label {
	position: relative;
	z-index: 1;
	padding: .3em .6em;
	display: block;
	text-transform: uppercase;
	border: 1px solid hsl(0, 0%, 77%);
	border-radius: 2px;
	font-family: Helvetica, Arial, Tahoma, Verdana, Sans-Serif;
	font-size: 0.75em;
	font-weight: bold;
	color: hsl(0, 0%, 20%);
	background: hsl(0, 0%, 100%);
	box-shadow: 2px 2px 1px hsla(0, 0%, 0%, 0.15);

	/* Disable the possibility to select the label text by the user. */
	-webkit-user-select: none;
	-moz-user-select: none;
	-ms-user-select: none;
	user-select: none;
}

/* Do not show the page break element inside the print preview window. */
@media print {
	.ck-content .page-break {
		padding: 0;
	}

		.ck-content .page-break::after {
			display: none;
		}

	/*
	 * From time to time placing page-break directly after a block element with margin causes appending a new blank page in pagination mode.
	 * Removing margin-bottom from the block element fixes that issue and the margin is not being moved to the next blank page.
	 *
	 * Keep this in sync with the pagination plugins.
	 */
	.ck-content *:has(+ .page-break) {
		margin-bottom: 0;
	}
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-show-blocks-border-color: hsl(0, 0%, 46%);
}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) address {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) address {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_5___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) address {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>ADDRESS</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) address:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) address {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_5___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) address {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>ADDRESS</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) aside {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) aside {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_6___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) aside {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>ASIDE</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) aside:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) aside {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_6___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) aside {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>ASIDE</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) blockquote {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) blockquote {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_7___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) blockquote {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>BLOCKQUOTE</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) blockquote:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) blockquote {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_7___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) blockquote {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>BLOCKQUOTE</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) details {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) details {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_8___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) details {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>DETAILS</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) details:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) details {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_8___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) details {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>DETAILS</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) div:not(.ck-widget, .ck-widget *) {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) div:not(.ck-widget, .ck-widget *) {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_9___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) div:not(.ck-widget, .ck-widget *) {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>DIV</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) div:not(.ck-widget, .ck-widget *):not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) div:not(.ck-widget, .ck-widget *) {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_9___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) div:not(.ck-widget, .ck-widget *) {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>DIV</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) footer {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) footer {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_10___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) footer {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>FOOTER</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) footer:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) footer {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_10___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) footer {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>FOOTER</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h1 {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h1 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_11___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h1 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H1</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h1:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h1 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_11___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h1 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H1</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h2 {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h2 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_12___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h2 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H2</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h2:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h2 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_12___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h2 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H2</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h3 {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h3 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_13___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h3 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H3</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h3:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h3 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_13___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h3 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H3</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h4 {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h4 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_14___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h4 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H4</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h4:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h4 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_14___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h4 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H4</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h5 {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h5 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_15___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h5 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H5</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h5:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h5 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_15___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h5 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H5</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h6 {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h6 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_16___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h6 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H6</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h6:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h6 {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_16___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) h6 {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>H6</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) header {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) header {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_17___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) header {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>HEADER</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) header:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) header {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_17___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) header {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>HEADER</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) main {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) main {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_18___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) main {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>MAIN</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) main:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) main {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_18___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) main {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>MAIN</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) nav {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) nav {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_19___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) nav {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>NAV</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) nav:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) nav {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_19___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) nav {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>NAV</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) pre {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) pre {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_20___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) pre {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>PRE</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) pre:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) pre {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_20___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) pre {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>PRE</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ol {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ol {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_21___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ol {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>OL</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ol:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ol {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_21___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ol {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>OL</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ul {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ul {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_22___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ul {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>UL</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ul:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ul {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_22___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) ul {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>UL</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) p {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) p {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_23___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) p {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>P</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) p:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) p {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_23___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) p {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>P</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) section {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) section {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_24___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) section {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>SECTION</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) section:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) section {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_24___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) section {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>SECTION</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) :where(figure.image, figure.table) figcaption {
		background-repeat: no-repeat;
		padding-top: 15px;
		/* Fix for Multi-root editor
	https://github.com/ckeditor/ckeditor5/issues/15969 */
	}

[dir=ltr] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) :where(figure.image, figure.table) figcaption {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_25___});
		background-position: 1px 1px;
	}

[dir=rtl] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) :where(figure.image, figure.table) figcaption {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>FIGCAPTION</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

.ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) :where(figure.image, figure.table) figcaption:not(.ck-widget_selected):not(.ck-widget:hover) {
		outline: 1px dashed var(--ck-show-blocks-border-color);
	}

[dir="ltr"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) :where(figure.image, figure.table) figcaption {
		background-image: url(${___CSS_LOADER_URL_REPLACEMENT_25___});
		background-position: 1px 1px;
	}

[dir="rtl"] .ck.ck-editor__editable.ck-editor__editable_inline.ck-show-blocks:not(.ck-widget) :where(figure.image, figure.table) figcaption {
		background-image: url("data:image/svg+xml;utf8,<svg width='120' height='12' xmlns='http://www.w3.org/2000/svg' ><text style='paint-order:stroke fill; clip-path: inset(-3px); transform:translate(-2px, 0)' stroke='%23EAEAEA' stroke-width='13' dominant-baseline='middle' fill='black' x='100%' text-anchor='end' y='7' font-size='9px' font-family='Consolas, %22Lucida Console%22, %22Lucida Sans Typewriter%22, %22DejaVu Sans Mono%22, %22Bitstream Vera Sans Mono%22, %22Liberation Mono%22, Monaco, %22Courier New%22, Courier, monospace'>FIGCAPTION</text></svg>");
		background-position: calc(100% - 1px) 1px;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * Implements rounded corner interface for .ck-rounded-corners class.
 *
 * @see \$ck-border-radius
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A visual style of focused element's border.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A helper to combine multiple shadows.
 */
/**
 * Gives an element a drop shadow so it looks like a floating panel.
 */

.ck-source-editing-area {
	position: relative;
	overflow: hidden;
}

.ck-source-editing-area::after,
.ck-source-editing-area textarea {
	padding: var(--ck-spacing-large);
	margin: 0;
	border: 1px solid transparent;
	line-height: var(--ck-line-height-base);
	font-size: var(--ck-font-size-normal);
	font-family: monospace;
	white-space: pre-wrap;
}

.ck-source-editing-area::after {
	content: attr(data-value) " ";
	visibility: hidden;
	display: block;
}

.ck-source-editing-area textarea {
	position: absolute;
	width: 100%;
	height: 100%;
	resize: none;
	outline: none;
	overflow: hidden;
	box-sizing: border-box;

	border-color: var(--ck-color-base-border);

	border-radius: 0;
}

.ck-rounded-corners .ck-source-editing-area textarea, .ck-source-editing-area textarea.ck-rounded-corners {
		border-radius: var(--ck-border-radius);
		border-top-left-radius: 0;
		border-top-right-radius: 0;
}

.ck-source-editing-area textarea:not([readonly]):focus {
		/* Disable native outline. */
		outline: none;
		border: var(--ck-focus-ring);
		box-shadow: var(--ck-inner-shadow), 0 0;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-character-grid {
	max-width: 100%;
}

.ck.ck-character-grid .ck-character-grid__tiles {
		display: grid;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-character-info {
	display: flex;
	justify-content: space-between;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Note: This file should contain the wireframe styles only. But since there are no such styles,
 * it acts as a message to the builder telling that it should look for the corresponding styles
 * **in the theme** when compiling the editor.
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-special-characters > .ck-dialog__content > div {
		width: 350px;
		max-width: 100%;
		height: 100%;

		display: grid;
		grid-column-gap: 0px;
		grid-row-gap: 0px;
		grid-template-columns: 1fr;
		grid-template-rows: auto 1fr auto;
	}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories {
			grid-area: 1 / 1 / 2 / 2;
			padding: var(--ck-spacing-medium) var(--ck-spacing-large);
		}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories > .ck-labeled-field-view {
				padding-top: var(--ck-spacing-standard);
				width: 100%;
			}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories > .ck-labeled-field-view .ck.ck-labeled-field-view__status {
					background: var(--ck-color-base-error);
					color: var(--ck-color-base-background);
					padding: var(--ck-spacing-small) var(--ck-spacing-medium);
					min-width: var(--ck-table-properties-min-error-width);
					text-align: center;

					animation: ck-table-form-labeled-view-status-appear .15s ease both;

					/* The arrow pointing towards the field. */
				}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories > .ck-labeled-field-view .ck.ck-labeled-field-view__status::after {
						border-color: transparent transparent var(--ck-color-base-error) transparent;
						border-width: 0 var(--ck-table-properties-error-arrow-size) var(--ck-table-properties-error-arrow-size) var(--ck-table-properties-error-arrow-size);
						border-style: solid;
					}

@media (prefers-reduced-motion: reduce) {

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories > .ck-labeled-field-view .ck.ck-labeled-field-view__status {
						animation: none;
				}
					}

/* Hide the error balloon when the field is blurred. Makes the experience much more clear. */

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories > .ck-labeled-field-view .ck-input.ck-error:not(:focus) + .ck.ck-labeled-field-view__status {
					display: none;
				}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories > .ck-labeled-field-view > .ck-label {
					font-size: var(--ck-font-size-tiny);
					text-align: center;
				}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories .ck-dropdown {
				display: block;
				width: 100%;
			}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories .ck-dropdown > button:not(:focus) {
						border: 1px solid var(--ck-color-base-border);
					}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-categories .ck-dropdown > button > span {
						width: 100%;
					}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-grid {
			grid-area: 2 / 1 / 3 / 2;
			max-height: 200px;
		}

.ck.ck-special-characters > .ck-dialog__content > div > .ck-character-info {
			grid-area: 3 / 1 / 4 / 2;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-style-panel-columns: 3;
}

.ck.ck-style-panel .ck-style-grid {
	display: grid;
	grid-template-columns: repeat(var(--ck-style-panel-columns),auto);
	justify-content: start;
}

.ck.ck-style-panel .ck-style-grid .ck-style-grid__button {
		display: flex;
		justify-content: space-between;
		flex-direction: column;
	}

.ck.ck-style-panel .ck-style-grid .ck-style-grid__button .ck-style-grid__button__preview {
			display: flex;
			align-content: center;
			justify-content: flex-start;
			align-items: center;
			flex-grow: 1;
			flex-basis: 100%;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck-content .table {
	/* Give the table widget some air and center it horizontally */
	/* The first value should be equal to --ck-spacing-large variable if used in the editor context
	to avoid the content jumping (See https://github.com/ckeditor/ckeditor5/issues/9825). */
	margin: 0.9em auto;
	display: table;
}

.ck-content .table table {
		/* The table cells should have slight borders */
		border-collapse: collapse;
		border-spacing: 0;

		/* Table width and height are set on the parent <figure>. Make sure the table inside stretches
		to the full dimensions of the container (https://github.com/ckeditor/ckeditor5/issues/6186). */
		width: 100%;
		height: 100%;

		/* The outer border of the table should be slightly darker than the inner lines.
		Also see https://github.com/ckeditor/ckeditor5-table/issues/50. */
		border: 1px double hsl(0, 0%, 70%);
	}

.ck-content .table table td,
		.ck-content .table table th {
			min-width: 2em;
			padding: .4em;

			/* The border is inherited from .ck-editor__nested-editable styles, so theoretically it's not necessary here.
			However, the border is a content style, so it should use .ck-content (so it works outside the editor).
			Hence, the duplication. See https://github.com/ckeditor/ckeditor5/issues/6314 */
			border: 1px solid hsl(0, 0%, 75%);
		}

.ck-content .table table th {
			font-weight: bold;
			background: hsla(0, 0%, 0%, 5%);
		}

/**
 * Expanding the table to the full height of the parent container is necessary because tables
 * are rendered inside <figure> elements, which is kinda buggy in table height calculation.
 * While setting \`height: 100%\` fixes the issue in the editing mode described here:
 * https://github.com/ckeditor/ckeditor5/issues/6186
 *
 * it's causing another issue with the table height in the print preview mode here:
 * https://github.com/ckeditor/ckeditor5/issues/16856
 *
 * For now, resetting the height to \`initial\` in the print mode works as a workaround.
 */
@media print {
	.ck-content .table table {
		height: initial;
	}
}

/* Text alignment of the table header should match the editor settings and override the native browser styling,
when content is available outside the editor. See https://github.com/ckeditor/ckeditor5/issues/6638 */
.ck-content[dir="rtl"] .table th {
	text-align: right;
}

.ck-content[dir="ltr"] .table th {
	text-align: left;
}

.ck-editor__editable .ck-table-bogus-paragraph {
	/*
	 * Use display:inline-block to force Chrome/Safari to limit text mutations to this element.
	 * See https://github.com/ckeditor/ckeditor5/issues/6062.
	 */
	display: inline-block;

	/*
	 * Inline HTML elements nested in the span should always be dimensioned in relation to the whole cell width.
	 * See https://github.com/ckeditor/ckeditor5/issues/9117.
	 */
	width: 100%;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck .ck-insert-table-dropdown__grid {
	display: flex;
	flex-direction: row;
	flex-wrap: wrap;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-form__row {
	display: flex;
	flex-direction: row;
	flex-wrap: nowrap;
	justify-content: space-between;

	/* Ignore labels that work as fieldset legends */
}

.ck.ck-form__row > *:not(.ck-label) {
		flex-grow: 1;
	}

.ck.ck-form__row.ck-table-form__action-row .ck-button-save,
		.ck.ck-form__row.ck-table-form__action-row .ck-button-cancel {
			justify-content: center;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-table-cell-properties-form .ck-form__row.ck-table-cell-properties-form__alignment-row {
			flex-wrap: wrap;
		}

.ck.ck-table-cell-properties-form .ck-form__row.ck-table-cell-properties-form__alignment-row .ck.ck-toolbar:first-of-type {
					/* 4 buttons out of 7 (h-alignment + v-alignment) = 0.57 */
					flex-grow: 0.57;
				}

.ck.ck-table-cell-properties-form .ck-form__row.ck-table-cell-properties-form__alignment-row .ck.ck-toolbar:last-of-type {
					/* 3 buttons out of 7 (h-alignment + v-alignment) = 0.43 */
					flex-grow: 0.43;
				}

.ck.ck-table-cell-properties-form .ck-form__row.ck-table-cell-properties-form__alignment-row .ck.ck-toolbar .ck-button {
					flex-grow: 1;
				}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-input-color {
	width: 100%;
	display: flex;
	flex-direction: row-reverse;
}

.ck.ck-input-color > input.ck.ck-input-text {
		min-width: auto;
		flex-grow: 1;
	}

.ck.ck-input-color > div.ck.ck-dropdown {
		min-width: auto;

		/* This dropdown has no arrow but a color preview instead. */
	}

.ck.ck-input-color > div.ck.ck-dropdown > .ck-input-color__button .ck-dropdown__arrow {
			display: none;
		}

.ck.ck-input-color .ck.ck-input-color__button {
		/* Resolving issue with misaligned buttons on Safari (see #10589) */
		display: flex;
	}

.ck.ck-input-color .ck.ck-input-color__button .ck.ck-input-color__button__preview {
			position: relative;
			overflow: hidden;
		}

.ck.ck-input-color .ck.ck-input-color__button .ck.ck-input-color__button__preview > .ck.ck-input-color__button__preview__no-color-indicator {
				position: absolute;
				display: block;
			}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-table-form .ck-form__row.ck-table-form__border-row {
			flex-wrap: wrap;
		}

.ck.ck-table-form .ck-form__row.ck-table-form__background-row {
			flex-wrap: wrap;
		}

.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row {
			flex-wrap: wrap;
			align-items: center;
		}

.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row .ck-labeled-field-view {
				display: flex;
				flex-direction: column-reverse;
				align-items: center;
			}

.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row .ck-labeled-field-view .ck.ck-dropdown {
					flex-grow: 0;
				}

.ck.ck-table-form .ck-form__row.ck-table-form__dimensions-row .ck-table-form__dimension-operator {
				flex-grow: 0;
			}

.ck.ck-table-form .ck.ck-labeled-field-view {
		/* Allow absolute positioning of the status (error) balloons. */
		position: relative;
	}

.ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status {
			position: absolute;
			left: 50%;
			bottom: calc( -1 * var(--ck-table-properties-error-arrow-size) );
			transform: translate(-50%,100%);

			/* Make sure the balloon status stays on top of other form elements. */
			z-index: 1;

			/* The arrow pointing towards the field. */
		}

.ck.ck-table-form .ck.ck-labeled-field-view .ck.ck-labeled-field-view__status::after {
				content: "";
				position: absolute;
				top: calc( -1 * var(--ck-table-properties-error-arrow-size) );
				left: 50%;
				transform: translateX( -50% );
			}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-table-properties-form .ck-form__row.ck-table-properties-form__alignment-row {
			flex-wrap: wrap;
			flex-basis: 0;
			align-content: baseline;
		}

.ck.ck-table-properties-form .ck-form__row.ck-table-properties-form__alignment-row .ck.ck-toolbar .ck-toolbar__items {
				flex-wrap: nowrap;
			}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-color-selector-caption-background: hsl(0, 0%, 97%);
	--ck-color-selector-caption-text: hsl(0, 0%, 20%);
	--ck-color-selector-caption-highlighted-background: hsl(52deg 100% 50%);
}

/* Content styles */
.ck-content .table > figcaption {
	display: table-caption;
	caption-side: top;
	word-break: break-word;
	text-align: center;
	color: var(--ck-color-selector-caption-text);
	background-color: var(--ck-color-selector-caption-background);
	padding: .6em;
	font-size: .75em;
	outline-offset: -1px;

	/* Improve placeholder rendering in high-constrast mode (https://github.com/ckeditor/ckeditor5/issues/14907). */
}
@media (forced-colors: active) {
		.ck-content .table > figcaption {
		background-color: unset;
		color: unset;
		}
	}

/* Editing styles */
@media (forced-colors: none) {
		.ck.ck-editor__editable .table > figcaption.table__caption_highlighted {
			animation: ck-table-caption-highlight .6s ease-out;
		}
	}
.ck.ck-editor__editable .table > figcaption.ck-placeholder::before {
		padding-left: inherit;
		padding-right: inherit;

		/*
		 * Make sure the table caption placeholder doesn't overflow the placeholder area.
		 * See https://github.com/ckeditor/ckeditor5/issues/9162.
		 */
		white-space: nowrap;
		overflow: hidden;
		text-overflow: ellipsis;
	}

@keyframes ck-table-caption-highlight {
	0% {
		background-color: var(--ck-color-selector-caption-highlighted-background);
	}

	100% {
		background-color: var(--ck-color-selector-caption-background);
	}
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-color-selector-column-resizer-hover: var(--ck-color-base-active);
	--ck-table-column-resizer-width: 7px;

	/* The offset used for absolute positioning of the resizer element, so that it is placed exactly above the cell border.
	   The value is: minus half the width of the resizer decreased additionaly by the half the width of the border (0.5px). */
	--ck-table-column-resizer-position-offset: calc(var(--ck-table-column-resizer-width) * -0.5 - 0.5px);
}

.ck-content .table .ck-table-resized {
	table-layout: fixed;
}

.ck-content .table table {
	overflow: hidden;
}

.ck-content .table td,
.ck-content .table th {
	/* To prevent text overflowing beyond its cell when columns are resized by resize handler
	(https://github.com/ckeditor/ckeditor5/pull/14379#issuecomment-1589460978). */
	overflow-wrap: break-word;
	position: relative;
}

.ck.ck-editor__editable .table .ck-table-column-resizer {
	position: absolute;
	top: 0;
	bottom: 0;
	right: var(--ck-table-column-resizer-position-offset);
	width: var(--ck-table-column-resizer-width);
	cursor: col-resize;
	user-select: none;
	z-index: var(--ck-z-default);
}

.ck.ck-editor__editable.ck-column-resize_disabled .table .ck-table-column-resizer {
	display: none;
}

/* The resizer elements, which are extended to an extremely high height, break the drag & drop feature in Chrome. To make it work again,
   all resizers must be hidden while the table is dragged. */
.ck.ck-editor__editable .table[draggable] .ck-table-column-resizer {
	display: none;
}

.ck.ck-editor__editable .table .ck-table-column-resizer:hover,
.ck.ck-editor__editable .table .ck-table-column-resizer__active {
	background-color: var(--ck-color-selector-column-resizer-hover);
	opacity: 0.25;
	/* The resizer element resides in each cell so to occupy the entire height of the table, which is unknown from a CSS point of view,
	   it is extended to an extremely high height. Even for screens with a very high pixel density, the resizer will fulfill its role as
	   it should, i.e. for a screen of 476 ppi the total height of the resizer will take over 350 sheets of A4 format, which is totally
	   unrealistic height for a single table. */
	top: -999999px;
	bottom: -999999px;
}

.ck.ck-editor__editable[dir=rtl] .table .ck-table-column-resizer {
	left: var(--ck-table-column-resizer-position-offset);
	right: unset;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * A class which hides an element in DOM.
 */

.ck-hidden {
	/* Override selector specificity. Otherwise, all elements with some display
	style defined will override this one, which is not a desired result. */
	display: none !important;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-z-default: 1;
	--ck-z-panel: calc( var(--ck-z-default) + 999 );
	--ck-z-dialog: 9999;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * A class that disables all transitions of the element and its children.
 */
.ck-transitions-disabled,
.ck-transitions-disabled * {
	transition: none !important;
}
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
:root {
	--ck-powered-by-line-height: 10px;
	--ck-powered-by-padding-vertical: 2px;
	--ck-powered-by-padding-horizontal: 4px;
	--ck-powered-by-text-color: hsl(0, 0%, 31%);
	--ck-powered-by-border-radius: var(--ck-border-radius);
	--ck-powered-by-background: hsl(0, 0%, 100%);
	--ck-powered-by-border-color: var(--ck-color-focus-border);
}
.ck.ck-balloon-panel.ck-powered-by-balloon {
	--ck-border-radius: var(--ck-powered-by-border-radius);

	box-shadow: none;
	background: var(--ck-powered-by-background);
	min-height: unset;
	z-index: calc( var(--ck-z-panel) - 1 );
}
.ck.ck-balloon-panel.ck-powered-by-balloon .ck.ck-powered-by {
		line-height: var(--ck-powered-by-line-height);
	}
.ck.ck-balloon-panel.ck-powered-by-balloon .ck.ck-powered-by a {
			cursor: pointer;
			display: flex;
			align-items: center;
			opacity: .66;
			filter: grayscale(80%);
			line-height: var(--ck-powered-by-line-height);
			padding: var(--ck-powered-by-padding-vertical) var(--ck-powered-by-padding-horizontal);
		}
.ck.ck-balloon-panel.ck-powered-by-balloon .ck.ck-powered-by .ck-powered-by__label {
			font-size: 7.5px;
			letter-spacing: -.2px;
			padding-left: 2px;
			text-transform: uppercase;
			font-weight: bold;
			margin-right: 4px;
			cursor: pointer;
			line-height: normal;
			color: var(--ck-powered-by-text-color);

		}
.ck.ck-balloon-panel.ck-powered-by-balloon .ck.ck-powered-by .ck-icon {
			display: block;
			cursor: pointer;
		}
.ck.ck-balloon-panel.ck-powered-by-balloon .ck.ck-powered-by:hover a {
				filter: grayscale(0%);
				opacity: 1;
			}
.ck.ck-balloon-panel.ck-powered-by-balloon[class*="position_inside"] {
		border-color: transparent;
	}
.ck.ck-balloon-panel.ck-powered-by-balloon[class*="position_border"] {
		border: var(--ck-focus-ring);
		border-color: var(--ck-powered-by-border-color);
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * Makes element unselectable.
 */
/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-button,
a.ck.ck-button {
	-moz-user-select: none;
	-webkit-user-select: none;
	-ms-user-select: none;
	user-select: none;

	position: relative;
	display: inline-flex;
	align-items: center;
}

[dir="ltr"] .ck.ck-button,
[dir="ltr"] a.ck.ck-button {
		justify-content: left;
}

[dir="rtl"] .ck.ck-button,
[dir="rtl"] a.ck.ck-button {
		justify-content: right;
}

.ck.ck-button .ck-button__label, a.ck.ck-button .ck-button__label {
		display: none;
	}

.ck.ck-button.ck-button_with-text .ck-button__label, a.ck.ck-button.ck-button_with-text .ck-button__label {
			display: inline-block;
		}

/* Center the icon horizontally in a button without text. */

.ck.ck-button:not(.ck-button_with-text),  a.ck.ck-button:not(.ck-button_with-text)  {
		justify-content: center;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-button.ck-switchbutton .ck-button__toggle {
		display: block;
	}

.ck.ck-button.ck-switchbutton .ck-button__toggle .ck-button__toggle__inner {
			display: block;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-list-item-button {
	min-height: unset;
	width: 100%;
	border-radius: 0;
}

[dir="ltr"] .ck.ck-list-item-button {
		text-align: left;
}

[dir="rtl"] .ck.ck-list-item-button {
		text-align: right;
}

[dir="ltr"] .ck.ck-list-item-button.ck-list-item-button_toggleable {
			padding-left: var(--ck-spacing-small);
	}

[dir="rtl"] .ck.ck-list-item-button.ck-list-item-button_toggleable {
			padding-right: var(--ck-spacing-small);
	}

.ck.ck-list-item-button .ck-list-item-button__check-holder {
		display: inline-flex;
		width: .9em;
		height: .9em;
	}

[dir="ltr"] .ck.ck-list-item-button .ck-list-item-button__check-holder {
			margin-right: var(--ck-spacing-small);
	}

[dir="rtl"] .ck.ck-list-item-button .ck-list-item-button__check-holder {
			margin-left: var(--ck-spacing-small);
	}

.ck.ck-list-item-button .ck-list-item-button__check-icon {
		height: 100%;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-collapsible.ck-collapsible_collapsed > .ck-collapsible__children {
		display: none;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-color-grid {
	display: grid;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.color-picker-hex-input {
	width: max-content;
}

.color-picker-hex-input .ck.ck-input {
		min-width: unset;
	}

.ck.ck-color-picker__row {
	display: flex;
	flex-direction: row;
	flex-wrap: nowrap;
	justify-content: space-between;
	margin: var(--ck-spacing-large) 0 0;
	width: unset;
}

.ck.ck-color-picker__row .ck.ck-labeled-field-view {
		padding-top: unset;
	}

.ck.ck-color-picker__row .ck.ck-input-text {
		width: unset;
	}

.ck.ck-color-picker__row .ck-color-picker__hash-view {
		padding-top: var(--ck-spacing-tiny);
		padding-right: var(--ck-spacing-medium);
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* View fragment with color grids. */

.ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__remove-color,
		.ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__color-picker {
			display: flex;
			align-items: center;
		}

[dir="rtl"] .ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__remove-color,
		[dir="rtl"] .ck.ck-color-selector .ck-color-grids-fragment .ck-button.ck-color-selector__color-picker {
				justify-content: flex-start;
		}

/* View fragment with a color picker. */

.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-selector_action-bar {
			display: flex;
			flex-direction: row;
			justify-content: space-around;
		}

.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-selector_action-bar .ck-button-save,
			.ck.ck-color-selector .ck-color-picker-fragment .ck.ck-color-selector_action-bar .ck-button-cancel {
				flex: 1
			}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-dialog .ck.ck-dialog__actions {
		display: flex;
		justify-content: flex-end;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-dialog-overlay {
	user-select: none;
	overscroll-behavior: none;

	position: fixed;
	bottom: 0;
	left: 0;
	right: 0;
	top: 0;
}

.ck.ck-dialog-overlay.ck-dialog-overlay__transparent {
		pointer-events: none;
		animation: none;
		background: none;
	}

.ck.ck-dialog {
	overscroll-behavior: none;
	width: fit-content;
	position: absolute;
}

.ck.ck-dialog .ck.ck-form__header  {
		flex-shrink: 0;
	}

.ck.ck-dialog .ck.ck-form__header .ck-form__header__label {
			cursor: grab;
		}

.ck.ck-dialog-overlay.ck-dialog-overlay__transparent .ck.ck-dialog {
		pointer-events: all;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-dropdown-max-width: 75vw;
}

.ck.ck-dropdown {
	display: inline-block;
	position: relative;
}

.ck.ck-dropdown .ck-dropdown__arrow {
		pointer-events: none;
		z-index: var(--ck-z-default);
	}

/* Dropdown button should span horizontally, e.g. in vertical toolbars */

.ck.ck-dropdown .ck-button.ck-dropdown__button {
		width: 100%;
	}

.ck.ck-dropdown .ck-dropdown__panel {
		display: none;
		z-index: var(--ck-z-panel);
		max-width: var(--ck-dropdown-max-width);

		position: absolute;
	}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel-visible {
			display: inline-block;
		}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_ne,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_nw,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_n,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_nmw,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_nme {
			bottom: 100%;
		}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_se,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_sw,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_smw,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_sme,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_s {
			/*
			 * Using transform: translate3d( 0, 100%, 0 ) causes blurry dropdown on Chrome 67-78+ on non-retina displays.
			 * See https://github.com/ckeditor/ckeditor5/issues/1053.
			 */
			top: 100%;
			bottom: auto;
		}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_ne,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_se {
			left: 0px;
		}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_nw,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_sw {
			right: 0px;
		}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_s,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_n {
			/* Positioning panels relative to the center of the button */
			left: 50%;
			transform: translateX(-50%);
		}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_nmw,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_smw {
			/* Positioning panels relative to the middle-west of the button */
			left: 75%;
			transform: translateX(-75%);
		}

.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_nme,
		.ck.ck-dropdown .ck-dropdown__panel.ck-dropdown__panel_sme {
			/* Positioning panels relative to the middle-east of the button */
			left: 25%;
			transform: translateX(-25%);
		}

/*
 * Toolbar dropdown panels should be always above the UI (eg. other dropdown panels) from the editor's content.
 * See https://github.com/ckeditor/ckeditor5/issues/7874
 */
.ck.ck-toolbar .ck-dropdown__panel {
	z-index: calc( var(--ck-z-panel) + 1 );
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-splitbutton {
	/* Enable font size inheritance, which allows fluid UI scaling. */
	font-size: inherit;
}

.ck.ck-splitbutton .ck-splitbutton__action:focus {
		z-index: calc(var(--ck-z-default) + 1);
	}


/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-toolbar-dropdown-max-width: 60vw;
}

.ck.ck-toolbar-dropdown > .ck-dropdown__panel {
	/* https://github.com/ckeditor/ckeditor5/issues/5586 */
	width: max-content;
	max-width: var(--ck-toolbar-dropdown-max-width);
}

.ck.ck-toolbar-dropdown > .ck-dropdown__panel .ck-button:focus {
			z-index: calc(var(--ck-z-default) + 1);
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-dropdown-menu-list__nested-menu__button > .ck-dropdown-menu-list__nested-menu__button__arrow {
	pointer-events: none;
	z-index: var(--ck-z-default);
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-balloon-panel.ck-dropdown-menu__nested-menu__panel {
	position: absolute;
	max-height: 314px; /* With the default settings, this is equal to 10 menu items. */
	overflow-y: auto;
	z-index: calc(var(--ck-z-panel) + 1);
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-dropdown-menu-list__nested-menu {
	display: block;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-aria-live-announcer {
	position: absolute;
	left: -10000px;
	top: -10000px;
}

.ck.ck-aria-live-region-list {
	list-style-type: none;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-form__header {
	display: flex;
	flex-direction: row;
	flex-wrap: nowrap;
	align-items: center;
	justify-content: space-between;
}

.ck.ck-form__header h2.ck-form__header__label {
		flex-grow: 1;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-icon {
	vertical-align: middle;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-label {
	display: block;
}

.ck.ck-voice-label {
	display: none;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-labeled-field-view > .ck.ck-labeled-field-view__input-wrapper {
		display: flex;
		position: relative;
	}

.ck.ck-labeled-field-view .ck.ck-label {
		display: block;
		position: absolute;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * Makes element unselectable.
 */

.ck.ck-list {
	-moz-user-select: none;
	-webkit-user-select: none;
	-ms-user-select: none;
	user-select: none;

	display: flex;
	flex-direction: column;
}

.ck.ck-list .ck-list__item,
	.ck.ck-list .ck-list__separator {
		display: block;
	}

/* Make sure that whatever child of the list item gets focus, it remains on the
	top. Thanks to that, styles like box-shadow, outline, etc. are not masked by
	adjacent list items. */

.ck.ck-list .ck-list__item > *:focus {
		position: relative;
		z-index: var(--ck-z-default);
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	/* Make sure the balloon arrow does not float over its children. */
	--ck-balloon-panel-arrow-z-index: calc(var(--ck-z-default) - 3);
}

.ck.ck-balloon-panel {
	display: none;
	position: absolute;

	z-index: var(--ck-z-panel);
}

.ck.ck-balloon-panel.ck-balloon-panel_with-arrow::before,
		.ck.ck-balloon-panel.ck-balloon-panel_with-arrow::after {
			content: "";
			position: absolute;
		}

.ck.ck-balloon-panel.ck-balloon-panel_with-arrow::before {
			z-index: var(--ck-balloon-panel-arrow-z-index);
		}

.ck.ck-balloon-panel.ck-balloon-panel_with-arrow::after {
			z-index: calc(var(--ck-balloon-panel-arrow-z-index) + 1);
		}

.ck.ck-balloon-panel[class*="arrow_n"]::before {
			z-index: var(--ck-balloon-panel-arrow-z-index);
		}

.ck.ck-balloon-panel[class*="arrow_n"]::after {
			z-index: calc(var(--ck-balloon-panel-arrow-z-index) + 1);
		}

.ck.ck-balloon-panel[class*="arrow_s"]::before {
			z-index: var(--ck-balloon-panel-arrow-z-index);
		}

.ck.ck-balloon-panel[class*="arrow_s"]::after {
			z-index: calc(var(--ck-balloon-panel-arrow-z-index) + 1);
		}

.ck.ck-balloon-panel.ck-balloon-panel_visible {
		display: block;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck .ck-balloon-rotator__navigation {
	display: flex;
	align-items: center;
	justify-content: center;
}

/* Buttons inside a toolbar should be centered when rotator bar is wider.
 * See: https://github.com/ckeditor/ckeditor5-ui/issues/495
 */
.ck .ck-balloon-rotator__content .ck-toolbar {
	justify-content: center;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck .ck-fake-panel {
	position: absolute;

	/* Fake panels should be placed under main balloon content. */
	z-index: calc(var(--ck-z-panel) - 1);
}

.ck .ck-fake-panel div {
	position: absolute;
}

.ck .ck-fake-panel div:nth-child( 1 ) {
	z-index: 2;
}

.ck .ck-fake-panel div:nth-child( 2 ) {
	z-index: 1;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-sticky-panel .ck-sticky-panel__content_sticky {
		z-index: var(--ck-z-panel); /* #315 */
		position: fixed;
		top: 0;
	}

.ck.ck-sticky-panel .ck-sticky-panel__content_sticky_bottom-limit {
		top: auto;
		position: absolute;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-autocomplete {
	position: relative;
}

.ck.ck-autocomplete > .ck-search__results {
		position: absolute;
		z-index: var(--ck-z-panel);
	}

.ck.ck-autocomplete > .ck-search__results.ck-search__results_n {
			bottom: 100%;
		}

.ck.ck-autocomplete > .ck-search__results.ck-search__results_s {
			top: 100%;
			bottom: auto;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-search > .ck-labeled-field-view > .ck-labeled-field-view__input-wrapper > .ck-icon {
			position: absolute;
			top: 50%;
			transform: translateY(-50%);
		}

[dir="ltr"] .ck.ck-search > .ck-labeled-field-view > .ck-labeled-field-view__input-wrapper > .ck-icon {
				left: var(--ck-spacing-medium);
		}

[dir="rtl"] .ck.ck-search > .ck-labeled-field-view > .ck-labeled-field-view__input-wrapper > .ck-icon {
				right: var(--ck-spacing-medium);
		}

.ck.ck-search > .ck-labeled-field-view .ck-search__reset {
			position: absolute;
			top: 50%;
			transform: translateY(-50%);
		}

.ck.ck-search > .ck-search__results > .ck-search__info > span:first-child {
				display: block;
			}

/* Hide the filtered view when nothing was found */

.ck.ck-search > .ck-search__results > .ck-search__info:not(.ck-hidden) ~ * {
				display: none;
			}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-highlighted-text mark {
	background: var(--ck-color-highlight-background);
	vertical-align: initial;
	font-weight: inherit;
	line-height: inherit;
	font-size: inherit;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * Makes element unselectable.
 */

.ck.ck-balloon-panel.ck-tooltip {
	-moz-user-select: none;
	-webkit-user-select: none;
	-ms-user-select: none;
	user-select: none;

	z-index: calc( var(--ck-z-dialog) + 100 );
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-toolbar-spinner-size: 18px;
}

.ck.ck-spinner-container {
	display: block;
	position: relative;
}

.ck.ck-spinner {
	position: absolute;
	top: 50%;
	left: 0;
	right: 0;
	margin: 0 auto;
	transform: translateY(-50%);
	z-index: 1;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * Makes element unselectable.
 */

.ck.ck-toolbar {
	-moz-user-select: none;
	-webkit-user-select: none;
	-ms-user-select: none;
	user-select: none;

	display: flex;
	flex-flow: row nowrap;
	align-items: center;
}

.ck.ck-toolbar > .ck-toolbar__items {
		display: flex;
		flex-flow: row wrap;
		align-items: center;
		flex-grow: 1;

	}

.ck.ck-toolbar .ck.ck-toolbar__separator {
		display: inline-block;

		/*
		 * A leading or trailing separator makes no sense (separates from nothing on one side).
		 * For instance, it can happen when toolbar items (also separators) are getting grouped one by one and
		 * moved to another toolbar in the dropdown.
		 */
	}

.ck.ck-toolbar .ck.ck-toolbar__separator:first-child,
		.ck.ck-toolbar .ck.ck-toolbar__separator:last-child {
			display: none;
		}

.ck.ck-toolbar .ck-toolbar__line-break {
		flex-basis: 100%;
	}

.ck.ck-toolbar.ck-toolbar_grouping > .ck-toolbar__items {
		flex-wrap: nowrap;
	}

.ck.ck-toolbar.ck-toolbar_vertical > .ck-toolbar__items {
		flex-direction: column;
	}

.ck.ck-toolbar.ck-toolbar_floating > .ck-toolbar__items {
		flex-wrap: nowrap;
	}

.ck.ck-toolbar > .ck.ck-toolbar__grouped-dropdown > .ck-dropdown__button .ck-dropdown__arrow {
			display: none;
		}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-block-toolbar-button {
	position: absolute;
	z-index: var(--ck-z-default);
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-menu-bar__menu > .ck-menu-bar__menu__button > .ck-menu-bar__menu__button__arrow {
		pointer-events: none;
		z-index: var(--ck-z-default);
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-menu-bar-menu-max-width: 75vw;
	--ck-menu-bar-nested-menu-horizontal-offset: 5px;
}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel {
	z-index: var(--ck-z-panel);
	max-width: var(--ck-menu-bar-menu-max-width);
	position: absolute;
}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_ne,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_nw {
		bottom: 100%;
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_se,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_sw {
		top: 100%;
		bottom: auto;
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_ne,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_se {
		left: 0px;
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_nw,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_sw {
		right: 0px;
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_es,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_en {
		left: calc( 100% - var(--ck-menu-bar-nested-menu-horizontal-offset) );
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_es {
		top: 0px;
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_en {
		bottom: 0px;
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_ws,
	.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_wn {
		right: calc( 100% - var(--ck-menu-bar-nested-menu-horizontal-offset) );
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_ws {
		top: 0px;
	}

.ck.ck-menu-bar__menu > .ck.ck-menu-bar__menu__panel.ck-menu-bar__menu__panel_position_wn {
		bottom: 0px;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck.ck-menu-bar__menu {
	display: block;
	position: relative;
}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

:root {
	--ck-color-resizer: var(--ck-color-focus-border);
	--ck-color-resizer-tooltip-background: hsl(0, 0%, 15%);
	--ck-color-resizer-tooltip-text: hsl(0, 0%, 95%);

	--ck-resizer-border-radius: var(--ck-border-radius);
	--ck-resizer-tooltip-offset: 10px;
	--ck-resizer-tooltip-height: calc(var(--ck-spacing-small) * 2 + 10px);
}

.ck .ck-widget {
	/* This is neccessary for type around UI to be positioned properly. */
	position: relative;
}

.ck .ck-widget.ck-widget_with-selection-handle {
	/* Make the widget wrapper a relative positioning container for the drag handle. */
	position: relative;
}

.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle {
		position: absolute;
	}

.ck .ck-widget.ck-widget_with-selection-handle .ck-widget__selection-handle .ck-icon {
			/* Make sure the icon in not a subject to font-size or line-height to avoid
			unnecessary spacing around it. */
			display: block;
		}

/* Show the selection handle on mouse hover over the widget, but not for nested widgets. */

.ck .ck-widget.ck-widget_with-selection-handle:hover > .ck-widget__selection-handle {
		visibility: visible;
	}

/* Show the selection handle when the widget is selected, but not for nested widgets. */

.ck .ck-widget.ck-widget_with-selection-handle.ck-widget_selected > .ck-widget__selection-handle {
		visibility: visible;
	}

.ck .ck-size-view {
	background: var(--ck-color-resizer-tooltip-background);
	color: var(--ck-color-resizer-tooltip-text);
	border: 1px solid var(--ck-color-resizer-tooltip-text);
	border-radius: var(--ck-resizer-border-radius);
	font-size: var(--ck-font-size-tiny);
	display: block;
	padding: 0 var(--ck-spacing-small);
	height: var(--ck-resizer-tooltip-height);
	line-height: var(--ck-resizer-tooltip-height);
}

.ck .ck-size-view.ck-orientation-top-left,
	.ck .ck-size-view.ck-orientation-top-right,
	.ck .ck-size-view.ck-orientation-bottom-right,
	.ck .ck-size-view.ck-orientation-bottom-left,
	.ck .ck-size-view.ck-orientation-above-center {
		position: absolute;
	}

.ck .ck-size-view.ck-orientation-top-left {
		top: var(--ck-resizer-tooltip-offset);
		left: var(--ck-resizer-tooltip-offset);
	}

.ck .ck-size-view.ck-orientation-top-right {
		top: var(--ck-resizer-tooltip-offset);
		right: var(--ck-resizer-tooltip-offset);
	}

.ck .ck-size-view.ck-orientation-bottom-right {
		bottom: var(--ck-resizer-tooltip-offset);
		right: var(--ck-resizer-tooltip-offset);
	}

.ck .ck-size-view.ck-orientation-bottom-left {
		bottom: var(--ck-resizer-tooltip-offset);
		left: var(--ck-resizer-tooltip-offset);
	}

/* Class applied if the widget is too small to contain the size label */

.ck .ck-size-view.ck-orientation-above-center {
		top: calc(var(--ck-resizer-tooltip-height) * -1);
		left: 50%;
		transform: translate(-50%);
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

.ck .ck-widget_with-resizer {
	/* Make the widget wrapper a relative positioning container for the drag handle. */
	position: relative;
}

.ck .ck-widget__resizer {
	display: none;
	position: absolute;

	/* The wrapper itself should not interfere with the pointer device, only the handles should. */
	pointer-events: none;

	left: 0;
	top: 0;
}

.ck-focused .ck-widget_with-resizer.ck-widget_selected > .ck-widget__resizer {
		display: block;
	}

.ck .ck-widget__resizer__handle {
	position: absolute;

	/* Resizers are the only UI elements that should interfere with a pointer device. */
	pointer-events: all;
}

.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-top-left,
	.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-bottom-right {
		cursor: nwse-resize;
	}

.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-top-right,
	.ck .ck-widget__resizer__handle.ck-widget__resizer__handle-bottom-left {
		cursor: nesw-resize;
	}

/*
 * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/*
	 * Styles of the type around buttons
	 */

.ck .ck-widget .ck-widget__type-around__button {
		display: block;
		position: absolute;
		overflow: hidden;
		z-index: var(--ck-z-default);
	}

.ck .ck-widget .ck-widget__type-around__button svg {
			position: absolute;
			top: 50%;
			left: 50%;
			z-index: calc(var(--ck-z-default) + 2);
		}

.ck .ck-widget .ck-widget__type-around__button.ck-widget__type-around__button_before {
			/* Place it in the middle of the outline */
			top: calc(-0.5 * var(--ck-widget-outline-thickness));
			left: min(10%, 30px);

			transform: translateY(-50%);
		}

.ck .ck-widget .ck-widget__type-around__button.ck-widget__type-around__button_after {
			/* Place it in the middle of the outline */
			bottom: calc(-0.5 * var(--ck-widget-outline-thickness));
			right: min(10%, 30px);

			transform: translateY(50%);
		}

/*
	 * Styles for the buttons when:
	 * - the widget is selected,
	 * - or the button is being hovered (regardless of the widget state).
	 */

.ck .ck-widget.ck-widget_selected > .ck-widget__type-around > .ck-widget__type-around__button::after, .ck .ck-widget > .ck-widget__type-around > .ck-widget__type-around__button:hover::after {
			content: "";
			display: block;
			position: absolute;
			top: 1px;
			left: 1px;
			z-index: calc(var(--ck-z-default) + 1);
		}

/*
	 * Styles for the horizontal "fake caret" which is displayed when the user navigates using the keyboard.
	 */

.ck .ck-widget > .ck-widget__type-around > .ck-widget__type-around__fake-caret {
		display: none;
		position: absolute;
		left: 0;
		right: 0;
	}

/*
	 * When the widget is hovered the "fake caret" would normally be narrower than the
	 * extra outline displayed around the widget. Let's extend the "fake caret" to match
	 * the full width of the widget.
	 */

.ck .ck-widget:hover > .ck-widget__type-around > .ck-widget__type-around__fake-caret {
		left: calc( -1 * var(--ck-widget-outline-thickness) );
		right: calc( -1 * var(--ck-widget-outline-thickness) );
	}

/*
	 * Styles for the horizontal "fake caret" when it should be displayed before the widget (backward keyboard navigation).
	 */

.ck .ck-widget.ck-widget_type-around_show-fake-caret_before > .ck-widget__type-around > .ck-widget__type-around__fake-caret {
		top: calc( -1 * var(--ck-widget-outline-thickness) - 1px );
		display: block;
	}

/*
	 * Styles for the horizontal "fake caret" when it should be displayed after the widget (forward keyboard navigation).
	 */

.ck .ck-widget.ck-widget_type-around_show-fake-caret_after > .ck-widget__type-around > .ck-widget__type-around__fake-caret {
		bottom: calc( -1 * var(--ck-widget-outline-thickness) - 1px );
		display: block;
	}

/*
 * Integration with the read-only mode of the editor.
 */
.ck.ck-editor__editable.ck-read-only .ck-widget__type-around {
	display: none;
}

/*
 * Integration with the restricted editing mode (feature) of the editor.
 */
.ck.ck-editor__editable.ck-restricted-editing_mode_restricted .ck-widget__type-around {
	display: none;
}

/*
 * Integration with the #isEnabled property of the WidgetTypeAround plugin.
 */
.ck.ck-editor__editable.ck-widget__type-around_disabled .ck-widget__type-around {
	display: none;
}

/*# sourceMappingURL=ckeditor5.css.map */`, "",{"version":3,"sources":["webpack://./node_modules/ckeditor5/dist/ckeditor5.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/index.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/globals.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_colors.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_disabled.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_focus.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_fonts.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_reset.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_rounded.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_shadow.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/globals/_spacing.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/autocomplete/autocomplete.css","webpack://./node_modules/ckeditor5/node_modules/@ckeditor/ckeditor5-theme-lark/theme/mixins/_rounded.css","webpack://./node_modules/ckeditor5/node_modules/@ckeditor/ckeditor5-theme-lark/theme/mixins/_shadow.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/mixins/_rounded.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/mixins/_shadow.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/button/button.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/mixins/_focus.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/mixins/_disabled.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/mixins/_button.css","webpack://./node_modules/ckeditor5/node_modules/@ckeditor/ckeditor5-ui/theme/mixins/_dir.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/button/switchbutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/button/listitembutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/collapsible/collapsible.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/colorgrid/colorgrid.css","webpack://./node_modules/ckeditor5/node_modules/@ckeditor/ckeditor5-ui/theme/mixins/_mediacolors.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/colorselector/colorselector.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dialog/dialog.css","webpack://./node_modules/ckeditor5/node_modules/@ckeditor/ckeditor5-ui/theme/mixins/_rwd.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dialog/dialogactions.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/dropdown.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/listdropdown.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/splitbutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/toolbardropdown.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/menu/dropdownmenubutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/menu/dropdownmenulistitem.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/menu/dropdownmenulistitembutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/dropdown/menu/dropdownmenupanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/editorui/accessibilityhelp.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/editorui/editorui.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/formheader/formheader.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/icon/icon.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/input/input.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/label/label.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/labeledfield/labeledfieldview.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/labeledinput/labeledinput.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/list/list.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/menubar/menubar.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/menubar/menubarmenu.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/menubar/menubarmenubutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/menubar/menubarmenulistitem.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/menubar/menubarmenulistitembutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/menubar/menubarmenupanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/panel/balloonpanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/panel/balloonrotator.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/panel/fakepanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/panel/stickypanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/responsive-form/responsiveform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/search/search.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/spinner/spinner.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/textarea/textarea.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/toolbar/blocktoolbar.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/toolbar/toolbar.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-ui/components/tooltip/tooltip.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-editor-classic/classiceditor.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-clipboard/clipboard.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-code-block/codeblock.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-engine/placeholder.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-find-and-replace/findandreplaceform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-heading/heading.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-horizontal-line/horizontalline.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-html-embed/htmlembed.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-image/imageinsert.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-image/imageupload.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-image/imageuploadicon.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-image/imageuploadloader.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-image/imageuploadprogress.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-link/link.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-link/linkactions.css","webpack://./node_modules/ckeditor5/node_modules/@ckeditor/ckeditor5-ui/theme/mixins/_unselectable.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-link/linkform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-link/linkimage.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-list/listproperties.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-list/liststyles.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-media-embed/mediaembedediting.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-mention/mention.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-restricted-editing/restrictedediting.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-special-characters/charactergrid.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-special-characters/characterinfo.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-special-characters/specialcharacters.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-style/style.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-style/stylegrid.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-style/stylegroup.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-style/stylepanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/colorinput.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/form.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/formrow.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/inserttable.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/tablecellproperties.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/tableediting.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/tableform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/tableproperties.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-table/tableselection.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-widget/widget.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-widget/widgetresize.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-theme-lark/theme/ckeditor5-widget/widgettypearound.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-basic-styles/theme/code.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-block-quote/theme/blockquote.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ckbox/theme/ckboximageedit.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-clipboard/theme/clipboard.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-code-block/theme/codeblock.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-editor-classic/theme/classiceditor.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-editor-inline/theme/inlineeditor.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-engine/theme/placeholder.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-engine/theme/renderer.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-find-and-replace/theme/findandreplace.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-find-and-replace/theme/findandreplaceform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-font/theme/fontsize.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-heading/theme/heading.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-highlight/theme/highlight.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-horizontal-line/theme/horizontalline.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-html-embed/theme/htmlembed.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-html-support/theme/datafilter.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imagecaption.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imageinsert.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imageresize.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imagecustomresizeform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imagestyle.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/textalternativeform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imageuploadprogress.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imageuploadicon.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imageuploadloader.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/image.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-image/theme/imageplaceholder.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-link/theme/linkimage.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-link/theme/linkactions.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-link/theme/linkform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-list/theme/documentlist.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-list/theme/liststyles.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-list/theme/list.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-list/theme/todolist.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-media-embed/theme/mediaembed.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-media-embed/theme/mediaembedediting.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/responsive-form/responsiveform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-media-embed/theme/mediaform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-mention/theme/mentionui.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-minimap/theme/minimap.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-page-break/theme/pagebreak.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-show-blocks/theme/showblocks.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-source-editing/theme/sourceediting.css","webpack://./node_modules/ckeditor5/node_modules/@ckeditor/ckeditor5-theme-lark/theme/mixins/_focus.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-special-characters/theme/charactergrid.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-special-characters/theme/characterinfo.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-special-characters/theme/specialcharacters.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-style/theme/stylegrid.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/table.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/inserttable.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/formrow.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/tablecellproperties.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/colorinput.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/tableform.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/tableproperties.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/tablecaption.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-table/theme/tablecolumnresize.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/globals/globals.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/globals/_hidden.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/globals/_zindex.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/globals/_transition.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/globals/_poweredby.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/button/button.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/mixins/_unselectable.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/mixins/_dir.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/button/switchbutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/button/listitembutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/collapsible/collapsible.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/colorgrid/colorgrid.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/colorpicker/colorpicker.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/colorselector/colorselector.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dialog/dialogactions.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dialog/dialog.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dropdown/dropdown.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dropdown/splitbutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dropdown/toolbardropdown.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dropdown/menu/dropdownmenubutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dropdown/menu/dropdownmenupanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/dropdown/menu/dropdownmenu.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/arialiveannouncer/arialiveannouncer.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/formheader/formheader.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/icon/icon.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/label/label.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/labeledfield/labeledfieldview.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/list/list.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/panel/balloonpanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/panel/balloonrotator.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/panel/fakepanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/panel/stickypanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/autocomplete/autocomplete.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/search/search.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/highlightedtext/highlightedtext.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/tooltip/tooltip.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/spinner/spinner.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/toolbar/toolbar.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/toolbar/blocktoolbar.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/menubar/menubarmenubutton.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/menubar/menubarmenupanel.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-ui/theme/components/menubar/menubarmenu.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-widget/theme/widget.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-widget/theme/widgetresize.css","webpack://./node_modules/ckeditor5/packages/ckeditor5-widget/theme/widgettypearound.css"],"names":[],"mappings":"AAAA;;;EAGE;ACHF;;;EAGE;;AAEF,UAAU;ACLV;;;EAGE;ACHF;;;EAGE;AAEF;CACC,mDAAmD;CACnD,oDAAoD;CACpD,kDAAkD;CAClD,uDAAuD;CACvD,mDAAmD;CACnD,+CAA+C;CAC/C,sDAAsD;CACtD,4DAA4D;CAC5D,kDAAkD;;CAElD,+FAA+F;;CAE/F,4DAA4D;CAC5D,+EAA+E;CAC/E,4DAA4D;CAC5D,8DAA8D;CAC9D,yDAAyD;CACzD,qDAAqD;CACrD,sDAAsD;CACtD,0DAA0D;CAC1D,sDAAsD;;CAEtD,+FAA+F;;CAE/F,uDAAuD;CACvD,iEAAiE;CACjE,kEAAkE;CAClE,8DAA8D;;CAE9D,6DAA6D;CAC7D,oEAAoE;CACpE,oEAAoE;CACpE,iEAAiE;CACjE,yDAAyD;;;CAGzD,sEAAsE;CACtE,sEAAsE;CACtE,sEAAsE;CACtE,oEAAoE;CACpE,sEAAsE;;CAEtE,oDAAoD;CACpD,qDAAqD;;CAErD,8DAA8D;CAC9D,iEAAiE;CACjE,qFAAqF;CACrF,uEAAuE;CACvE,8EAA8E;CAC9E,gEAAgE;;CAEhE,+FAA+F;;CAE/F,2EAA2E;CAC3E,oEAAoE;;CAEpE,+FAA+F;;CAE/F,iEAAiE;CACjE,mEAAmE;;CAEnE,+FAA+F;;CAE/F,oEAAoE;CACpE,6DAA6D;CAC7D,gEAAgE;CAChE,0DAA0D;CAC1D,2DAA2D;CAC3D,oEAAoE;CACpE,sDAAsD;;CAEtD,+FAA+F;;CAE/F,mEAAmE;CACnE,6FAA6F;CAC7F,2EAA2E;CAC3E,+EAA+E;CAC/E,sEAAsE;;CAEtE,+FAA+F;;CAE/F,oEAAoE;CACpE,6DAA6D;;CAE7D,+FAA+F;;CAE/F,sEAAsE;CACtE,+DAA+D;;CAE/D,+FAA+F;;CAE/F,gEAAgE;CAChE,iEAAiE;;CAEjE,+FAA+F;;CAE/F,yDAAyD;;CAEzD,+FAA+F;;CAE/F,2DAA2D;;CAE3D,6FAA6F;;CAE7F,oDAAoD;CACpD,mEAAmE;CACnE,gEAAgE;;CAEhE,gGAAgG;;CAEhG,yDAAyD;;CAEzD,gGAAgG;;CAEhG,gDAAgD;AACjD;AC1HA;;;EAGE;AAEF;CACC;;GAEE;CACF,yBAAyB;AAC1B;ACVA;;;EAGE;AAEF;CACC;;GAEE;CACF,2CAA2C;;CAE3C;;GAEE;CACF,iGAAiG;;CAEjG;;GAEE;CACF,6GAA6G;;CAE7G;;GAEE;CACF,uGAAuG;;CAEvG;;GAEE;CACF,uDAAuD;AACxD;AC9BA;;;EAGE;AAEF;CACC,yBAAyB;CACzB,8BAA8B;CAC9B,6DAA6D;;CAE7D,0BAA0B;CAC1B,4BAA4B;CAC5B,0BAA0B;CAC1B,yBAAyB;CACzB,2BAA2B;AAC5B;ACfA;;;EAGE;AAEF;CACC;;;gBAGe;CACf,mCAAmC;AACpC;AAEA;;EAEE;AACF;;;CAGC,sBAAsB;CACtB,WAAW;CACX,YAAY;CACZ,gBAAgB;;CAEhB,2CAA2C;CAC3C,SAAS;CACT,UAAU;CACV,SAAS;CACT,uBAAuB;CACvB,qBAAqB;CACrB,sBAAsB;CACtB,gBAAgB;;CAEhB,gEAAgE;CAChE,qBAAqB;AACtB;AAEA;;EAEE;AACF;;CAEC,uDAAuD;CACvD,yBAAyB;CACzB,kGAAkG;CAClG,2BAA2B;CAC3B,gBAAgB;CAChB,mBAAmB;CACnB,YAAY;CACZ,WAAW;AACZ;AAGC;EACC,iBAAiB;CAClB;AAEA;EACC,WAAW;EACX,uBAAuB;CACxB;AAEA;EACC,qBAAqB;CACtB;AAEA;;;EAGC,YAAY;CACb;AAEA;;;EAGC,eAAe;CAChB;AAEA;EACC,aAAa;EACb,oCAAoC;CACrC;AAEA;EACC,kGAAkG;EAClG,UAAU;EACV;CACD;AAGD;;EAEE;AACF;;CAEC,iBAAiB;AAClB;AChGA;;;EAGE;AAEF;;EAEE;AACF;CACC,uBAAuB;AACxB;ACVA;;;EAGE;AAEF;CACC;;GAEE;CACF,iEAAiE;;CAEjE;;GAEE;CACF,2DAA2D;;CAE3D;;GAEE;CACF,yEAAyE;AAC1E;ACpBA;;;EAGE;AAEF;CACC,8BAA8B;CAC9B,2DAA2D;CAC3D,kDAAkD;CAClD,4DAA4D;CAC5D,2DAA2D;CAC3D,2DAA2D;CAC3D,gEAAgE;AACjE;;ATLA,eAAe;AURf;;;EAGE;ACHF;;;EAGE;AAEF;;;;EAIE;ACTF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AFLD;EGEA,gBAAgB;CHuBhB;AAzBA;EGMC,sCAAsC;CHmBvC;AAzBA;EIAA,sCAA8B;;EJI7B,iBAAiB;EACjB,gBAAgB;EAChB,2CAA2C;EAC3C,uDAAuD;EACvD,eAAe;CAiBhB;AAfC;GACC,4BAA4B;GAC5B,6BAA6B;;GAE7B,uEAAuE;GACvE,mBAAmB;EACpB;AAEA;GACC,yBAAyB;GACzB,0BAA0B;;GAE1B,uEAAuE;GACvE,gBAAgB;EACjB;AKjCF;;;EAGE;ACHF;;;EAGE;AAEF;;EAEE;AFPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AGdF;;;EAGE;AAEF;;EAEE;AJPF;;;EAGE;AAEF;;;;EAIE;AKTF;;;EAGE;AAEF;;;;;EAKE;ACVF;;;EAGE;AJSF;;CGAC,qDAAqC;CLDrC,gBAAgB;;CEMhB,mBAAmB;CACnB,eAAe;CACf,sBAAsB;CACtB,+BAA+B;CAC/B,kBAAkB;;CAElB,iFAAiF;CACjF,4CAA4C;CAC5C,6CAA6C;;CAE7C;iDACgD;CAChD,cAAc;;CAEd,iEAAiE;CACjE,kBAAkB;;CAElB,qDAAqD;CACrD,6BAA6B;;CAE7B,+DAA+D;CAC/D,8DAA8D;;CAE9D,gEAAgE;CAChE,wBAAwB;AAgHzB;AG1IE;GACC,2DAA2C;EAC5C;AAEA;GACC,4DAA4C;EAC7C;AAGD,+DAA+D;AAC/D;EACC,8DAA8C;CAC/C;AHfD;;;;EFGE,sCAAsC;AE0IxC;AA9GC;AA/BD;;EAgCE,gBAAgB;AA6GlB;CA5GC;AAEA;;;;ECtCA,4BAA4B;EAC5B,aAAa;EACb,4BAA2B;EFF3B,6CAA8B;CC0C9B;AAEA,yDAAyD;AAExD;;;;GAEC,cAAc;EACf;AAGD;EACC,iEAAiE;EACjE,kBAAkB;EAClB,oBAAoB;EACpB,cAAc;EACd,eAAe;;EAEf;kEACgE;EAChE,sBAAsB;CASvB;AAlBA;GAYE,gBAAgB;CAMlB;AAlBA;GAgBE,iBAAiB;CAEnB;AAEA;EACC,cAAc;CAWf;AAZA;GAIE,oCAAoC;CAQtC;AAZA;GAQE,qCAAqC;CAIvC;AAZA;;EAWC,WAAW;CACZ;AAEA,+DAA+D;AAE9D;;;;GAEC,iFAAiF;GD1FnF,sDAA8B;EC4F7B;AAEA;GE9FD,mCAAmC;EFgGlC;AAEA,+DAA+D;AAC/D;GEnGD,mCAAmC;EFqGlC;AAEA;GACC,WAAW;EACZ;AAGD;EACC,0DAA0D;;EAE1D,0DAA0D;CAU3D;AATC;IAEE,sCAAsC;EAMxC;AARA;IAME,qCAAqC;EAEvC;AAIA,0DAA0D;AAC1D;GACC,YAAY;EACb;AAGD,6EAA6E;AAC7E;EGhIA,gDAAqC;;EHmIpC,sCAAsC;CACvC;AGjIC;GACC,sDAA2C;EAC5C;AAEA;GACC,uDAA4C;EAC7C;AAGD,+DAA+D;AAC/D;EACC,yDAA8C;CAC/C;AHuHA;EACC,kCAAkC;CACnC;AAEA;EACC,oCAAoC;CACrC;AAGD,4DAA4D;AAC5D;;CGhJC,oDAAqC;;CHoJrC,yCAAyC;AAC1C;AGlJE;GACC,0DAA2C;EAC5C;AAEA;GACC,2DAA4C;EAC7C;AAGD,+DAA+D;AAC/D;EACC,6DAA8C;CAC/C;AHwID;;CAEC,iBAAiB;AAClB;AKtKA;;;EAGE;APHF;;;EAGE;AAEF;;;;EAIE;AITF;;;EAGE;AAEF;;EAEE;AEPF;;;EAGE;ACMF;;4DAE4D;AAC5D;CACC,2BAA2B;CAC3B,+CAA+C;CAC/C,2BAA2B;CAC3B,gEAAgE;CAChE;;;;EAIC;CACD,2FAA2F;AAC5F;AAGC;;;GAGE;AACF;EACC,cAAc;EACd,uBAAuB;CACxB;AAEA;GAEE,uCAAuC;GACvC,+CAA+C;CAOjD;AAVA;GAOE,uCAAuC;GACvC,8CAA8C;CAEhD;AAEA;EPpCA,gBAAgB;COgFhB;AA5CA;EPhCC,sCAAsC;CO4EvC;AA5CA;GAIE,oEAAoE;GACpE,iBAAiB;CAuCnB;AA5CA;GASE,mEAAmE;GACnE,kBAAkB;CAkCpB;AA5CA;;EAaC,+DAA+D;EAC/D,6DAA6D;EAC7D,sFAAsF;EACtF,6BAA6B;EAC7B,2CAA2C;EAC3C,wDAAwD;CA0BzD;AAxBC;GPxDD,gBAAgB;EOuEf;AAfA;EPpDA,sCAAsC;IOsDpC,iDAAiD;EAanD;AAfA;;GAKC,gDAAgD;GAChD,iDAAiD;GACjD,0DAA0D;;GAE1D,uDAAuD;GACvD,0BAA0B;EAK3B;AAHC;AAZD;IAaE,gBAAgB;EAElB;GADC;AAGD;GACC,8DAA8D;EAK/D;AAHC;IACC,sDAAsD;GACvD;AAIF;EHpFA,mCAAmC;CGsFnC;AAEA,8EAA8E;AAC9E;EACC,yBAAyB;EACzB,aAAa;EACb,gBAAgB;CAOjB;AALC;GACC,mGAAmG;GACnG,mBAAmB;GACnB,6BAA6B;EAC9B;AAGD,0DAA0D;AAEzD;GACC,uDAAuD;EAkBxD;AAhBC;IACC,6DAA6D;GAC9D;AAGC;;KAEC;AAHF;KAKE,8DAA8D;GAMhE;AAXA;KASE,2EAA2E;GAE7E;AClIH;;;EAGE;AFHF;;;EAGE;AEIF;CACC,oEAAoE;AAiCrE;AA/BC;;EAEC,2CAA2C;EAC3C,2BAA2B;CAC5B;AAEA;GAEE,qCAAqC;CAMvC;AARA;GAME,sCAAsC;CAExC;AAEA;;;;GAIE;AACF;;;;EAIC,wDAAwD;CAKzD;AAHC;GACC,2BAA2B;EAC5B;ACvCF;;;EAGE;AAEF;CACC,4DAA4D;AAC7D;AAGC;EACC,WAAW;EACX,iBAAiB;EACjB,gBAAgB;EAChB,cAAc;CAgBf;AAdC;GACC,uBAAuB;EACxB;AAEA;GACC,uBAAuB;GACvB,yBAAyB;GACzB,gBAAgB;EACjB;AAEA;GACC,sCAAsC;GACtC,uCAAuC;EACxC;AAGD;EACC,iFAAiF;CAClF;AAGC;GACC,yBAAyB;EAC1B;ACvCF;;;EAGE;AVHF;;;EAGE;AAEF;;;;EAIE;AWTF;;;EAGE;ADKF;CACC,+BAA+B;;CAE/B;;4DAE2D;CAC3D,oDAAoD;AACrD;AAEA;CACC,aAAa;CACb,YAAY;AACb;AAEA;CACC,+BAA+B;AAkEhC;AC3EC;EACC;EDWA,qCAAqC;EACrC,sCAAsC;EACtC,yCAAyC;EACzC,0CAA0C;EAC1C,UAAU;EACV,SAAS;ECdT;;EDgBA;;;GAGC,kDAAkD;GAClD,SAAS;EACV;;EAEA;GACC,iDAAiD;EAClD;;EAEA;GACC,gGAAgG;EACjG;;EAEA;;GAEC,mGAAmG;EACpG;CCjCD;ADoCA;;;GAGE;ACnDF;EACC;EDoDA,YAAY;EACZ,aAAa;EACb,gBAAgB;EAChB,iBAAiB;EACjB,kCAAkC;ECtDlC;;EDwDA;GACC,qBAAqB;EACtB;CCzDD;AD4DA;AAhDD;EAiDE,gBAAgB;AAkBlB;CAjBC;AAEA;EACC,aAAa;EACb,iBAAiB;CAClB;AAEA;EACC,aAAa;EACb,4CAA4C;CAC7C;AAGC;GACC,cAAc;EACf;AAIF;CACC,qCAAqC;AACtC;AE7FA;;;EAGE;ANHF;;;EAGE;AMKD,oCAAoC;AAEnC;;GAEC,WAAW;EACZ;AAEA;GACC,wEAAwE;GACxE,4BAA4B;GAC5B,6BAA6B;EAe9B;AAbC;IACC,iDAAiD;GAClD;AAEA;KAEE,wCAAwC;GAM1C;AARA;KAME,uCAAuC;GAEzC;AAGD;GACC,kBAAkB;EACnB;AAGD,uCAAuC;AAEtC;GACC,YAAY;EAoBb;AAlBC;IACC,aAAa;IACb,gBAAgB;GAejB;AAbC;KACC,kEAAkE;IACnE;AAEA;KACC,kEAAkE;IACnE;AAEA;;KAEC,WAAW;KACX,YAAY;IACb;AAIF;GACC,kBAAkB;EACnB;ACnEF;;;EAGE;AbHF;;;EAGE;AAEF;;;;EAIE;ACTF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AadF;;;EAGE;ADMF;CACC,2DAA2D;CAC3D,8DAA8D;CAC9D,4BAA4B;CAC5B,4BAA4B;CAC5B,6DAA6D;CAC7D,iEAAiE;AAClE;AAEA;CACC,gCAAgC;CAChC,qDAAqD;CACrD,2BAA2B;AAC5B;AAEA;CbbC,gBAAgB;Aa2BjB;AAdA;EbTE,sCAAsC;AauBxC;AAdA;CZfC,sCAA8B;;CYmB9B,8CAA8C;;CAE9C,6CAA6C;CAC7C,uCAAuC;CACvC,qCAAqC;CACrC,6CAA6C;AAK9C;AAHC;EACC,kEAAkE;CACnE;AAGD;CACC;EACC,gCAAgC;CACjC;;CAEA;EACC,qDAAqD;CACtD;AACD;AEhDA;;;EAGE;AAGD;EACC,gCAAgC;CAKjC;AAHC;GACC,oCAAoC;EACrC;ACXF;;;EAGE;AhBHF;;;EAGE;AAEF;;;;EAIE;AITF;;;EAGE;AAEF;;EAEE;AHPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AKdF;;;EAGE;AUOF;CACC,yDAAyD;AAC1D;AAEA;CACC,iEAAiE;CACjE,kBAAkB;AA2EnB;AAzEC;EACC,oCAAoC;CACrC;AAGC;GACC,iCAAiC;;GAEjC,yCAAyC;GACzC,uCAAuC;EACxC;AAIA;GACC,gCAAgC;;GAEhC,yCAAyC;GACzC,qCAAqC;EACtC;AAGD;EZ/BA,mCAAmC;CYiCnC;AAIE;IACC,uEAAuE;IACvE,qCAAqC;GACtC;AAIA;IACC,uEAAuE;IACvE,sCAAsC;GACvC;AAGD,QAAQ;AACR;GACC,UAAU;GACV,gBAAgB;GAChB,uBAAuB;EACxB;AAEA,+DAA+D;AAC/D;GZ1DD,mCAAmC;EY4DlC;AAEA,qDAAqD;AACrD;GACC,4BAA4B;GAC5B,6BAA6B;EAC9B;AAEA;GACC,WAAW;EACZ;AAEA,sDAAsD;AACtD;;GAEC,gBAAgB;EAKjB;AAHC;If7EF,6CAA8B;Ge+E5B;AAKH;ChBlFC,gBAAgB;AgBkHjB;AAhCA;EhB9EE,sCAAsC;AgB8GxC;AAhCA;CfpFC,sCAA8B;;CewF9B,qDAAqD;CACrD,uDAAuD;CACvD,SAAS;;CAET,uEAAuE;CACvE,eAAe;;CAEf;mDACkD;AAoBnD;AAnBC;EACC,yBAAyB;CAC1B;AAEA;EACC,0BAA0B;CAC3B;AAEA;EACC,4BAA4B;CAC7B;AAEA;EACC,6BAA6B;CAC9B;AAEA;EACC,aAAa;CACd;AC5HD;;;EAGE;AjBHF;;;EAGE;AAEF;;;;EAIE;AiBFF;CACC;mDACkD;CjBElD,gBAAgB;AiBqBjB;AAzBA;EjBQE,sCAAsC;EiBJtC,yBAAyB;AAqB3B;AAlBC;qCACoC;AAEnC;GjBND,gBAAgB;EiBYf;AANA;EjBFA,sCAAsC;IiBIpC,yBAAyB;IACzB,4BAA4B;IAC5B,6BAA6B;EAE/B;AAEA;GjBdD,gBAAgB;EiBmBf;AALA;EjBVA,sCAAsC;IiBYpC,yBAAyB;IACzB,0BAA0B;EAE5B;AC9BF;;;EAGE;AlBHF;;;EAGE;AAEF;;;;EAIE;AkBFF;CACC,yDAAyD;CACzD,qDAAqD;AACtD;AAGC;;GAEE;AACF;;GAGE,oDAAoD;GACpD,8BAA8B;GAC9B,iCAAiC;CAQnC;AAbA;;GASE,mDAAmD;GACnD,6BAA6B;GAC7B,gCAAgC;CAElC;AAEA;EACC;yCACuC;EACvC,gBAAgB;CAiBjB;AApBA;GAME,kDAAkD;GAClD,6BAA6B;GAC7B,gCAAgC;CAYlC;AApBA;GAYE,mDAAmD;GACnD,8BAA8B;GAC9B,iCAAiC;CAMnC;AAHC;GACC,oCAAoC;EACrC;AAGD;qDACoD;AACpD;EACC,qBAAqB;EACrB,wBAAwB;CACzB;AAEA;;mCAEkC;AAGjC,yEAAyE;AACzE;GACC,yDAAyD;EAC1D;AAEA;4CAC0C;AAC1C;GACC,WAAW;GACX,kBAAkB;GAClB,UAAU;GACV,YAAY;GACZ,2DAA2D;EAC5D;AAEA,oFAAoF;AACpF;GACC,kEAAkE;EACnE;AAGC;IACC,UAAU;GACX;AAIA;IACC,WAAW;GACZ;AAIF;mDACkD;AAClD;ElBzFA,gBAAgB;CkBmGhB;AAVA;ElBrFC,sCAAsC;CkB+FvC;AARE;IACC,4BAA4B;GAC7B;AAEA;IACC,6BAA6B;GAC9B;AC5GH;;;EAGE;AAEF;CACC,SAAS;AACV;ACPA;;;EAGE;AhBHF;;;EAGE;AAEF;;EAEE;ACPF;;;EAGE;AAEF;;;;;EAKE;ACVF;;;EAGE;AcMF;;EAEE;AACF;CACC,WAAW;CACX,oEAAoE;CACpE,gBAAgB;AAyEjB;AAvEC;EACC,yBAAyB;EACzB,gBAAgB;CAKjB;AAHC;GACC,2DAA2D;EAC5D;AAGD;EACC,YAAY;EACZ,gBAAgB;EAChB,uBAAuB;CACxB;AAEA;EhBvBA,mCAAmC;CgByBnC;AAEA,2CAA2C;AAC3C;EACC,gEAAgE;CACjE;AAEA;EACC,oCAAoC;CAerC;AAhBA;GAIE,yBAAyB;;GAEzB,qFAAqF;GACrF,gDAAgD;CASlD;AAhBA;GAWE,wBAAwB;;GAExB,uGAAuG;GACvG,+CAA+C;CAEjD;AAEA;EhBlDA,mCAAmC;CgBoDnC;AAGC;GACC,qCAAqC;EACtC;AAEA;GACC,iCAAiC;;GAEjC,yCAAyC;GACzC,uCAAuC;EACxC;AAIA;GACC,sCAAsC;EACvC;AAEA;GACC,gCAAgC;;GAEhC,yCAAyC;GACzC,qCAAqC;EACtC;ACtFF;;;EAGE;AAEF;CACC,4CAA4C;AAC7C;AAEA;CACC,sDAAsD;AACvD;ACXA;;;EAGE;AAEF;;EAEE;AACF;CACC,gBAAgB;AA0BjB;AAxBC;;EAEC,0FAA0F;EAC1F,+BAA+B;CAChC;AAEA;EACC,gDAAgD;EAChD,+CAA+C;EAC/C,qCAAqC;CACtC;AAEA;;;GAGE;AACF;EACC,yBAAyB;EACzB,gBAAgB;CAKjB;AAHC;GACC,2DAA2D;EAC5D;ACjCF;;;EAGE;AvBHF;;;EAGE;AAEF;;;;EAIE;ACTF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AsBNF;CACC,6CAA6C;AAC9C;AAEA;CtBHC,sCAA8B;;CsBM9B,qDAAqD;CACrD,uDAAuD;CACvD,SAAS;CACT,mBAAmB;CACnB,uDAAuD;;CAEvD,0BAA0B;AA8B3B;AA7BC;;EAEC,aAAa;CACd;AAEA,qDAAqD;AACrD;;EAEC,yBAAyB;CAC1B;AAEA;;EAEC,0BAA0B;CAC3B;AAEA;;EAEC,4BAA4B;CAC7B;AAEA;;EAEC,6BAA6B;CAC9B;AAEA;EACC,aAAa;CACd;AClDD;;;EAGE;ArBHF;;;EAGE;AAEF;;EAEE;AFPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AuBNF;CACC,+CAA+C;CAC/C,gDAAgD;CAChD,8DAA8D;CAC9D,yEAAyE;CACzE,iEAAiE;AAClE;AAEA;CACC,gCAAgC;CAChC,wDAAwD;CACxD,0DAA0D;CAC1D,cAAc;CACd,iBAAiB;;CAEjB,6BAA6B;AA8E9B;AA5EC;ErBhBA,4BAA4B;EAC5B,aAAa;EACb,4BAA2B;EFF3B,6CAA8B;CuBmB9B;AAEA;EACC,mBAAmB;CACpB;AAEA,kDAAkD;AAClD;EACC,aAAa;CACd;AAEA;EACC,iBAAiB;EACjB,gBAAgB;CACjB;AAEA;EACC,iBAAiB;EACjB,cAAc;CACf;AAEA;;;;EAIC,aAAa;CACd;AAEA;EACC,aAAa;EACb,8BAA8B;EAC9B,sEAAsE;EACtE,mBAAmB;CAepB;AAbC;GACC,yEAAyE;GACzE,eAAe;EAChB;AAEA;GACC,oBAAoB;EACrB;AAEA;GACC,oBAAoB;GACpB,iBAAiB;EAClB;AAGD;EACC,qBAAqB;EACrB,qEAAqE;EACrE,aAAa;EACb,sBAAsB;EACtB,cAAc;EACd,kBAAkB;EAClB,kBAAkB;EAClB,eAAe;CAChB;AAEA;EACC,sBAAsB;CACvB;AAEA;EACC,gBAAgB;EAChB,4EAA4E;EAC5E,aAAa;CAKd;AAHC;GACC,gBAAgB;EACjB;ACnGF;;;EAGE;AzBHF;;;EAGE;AAEF;;;;EAIE;AITF;;;EAGE;AAEF;;EAEE;AHPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AEdF;;;EAGE;AAEF;;EAEE;AEPF;;;EAGE;AAEF;;;;;EAKE;AoBCF;CACC,mDAAmD;AACpD;AAEA;CzBJC,gBAAgB;AyBWjB;AAPA;EzBAE,sCAAsC;AyBOxC;AAJC;EtBTA,4BAA4B;EAC5B,aAAa;EACb,4BAA2B;EFF3B,uCAA8B;CwBY9B;AAGD;CACC,cAAc;CACd,qCAAqC;CACrC,6BAA6B;AA4B9B;AA1BC;EACC,gBAAgB;CACjB;AAEA;EACC,iBAAiB;CAClB;AAEA,gEAAgE;AAChE;EACC,mCAAmC;CACpC;AAEA,qDAAqD;AACrD;EACC;;;IAGE;EACF,sCAAsC;CACvC;AAEA,sDAAsD;AACtD;EACC,mDAAmD;CACpD;AAGD,gEAAgE;AAE/D;EACC,qDAAqD;CACtD;AAIA;EACC,kDAAkD;CACnD;ACnED;;;EAGE;ApBHF;;;EAGE;AoBIF;CACC,6BAA6B;AAC9B;AAEA;CACC,wDAAwD;CACxD,oCAAoC;CACpC,yCAAyC;CACzC,oDAAoD;AAgBrD;AAdC;GAEE,sCAAsC;CAMxC;AARA;GAME,qCAAqC;CAEvC;AAEA;EACC,yBAAyB;EACzB,iBAAiB;CAClB;AC9BD;;;EAGE;AAEF;CACC,6EAA6E;CAC7E,kCAAkC;AACnC;AAEA;CACC,0BAA0B;CAC1B,2BAA2B;;CAE3B,uFAAuF;CACvF,mCAAmC;;CAEnC,+BAA+B;CAC/B,eAAe;;CAEf,yDAAyD;CACzD,sBAAsB;AAoBvB;AAlBC;EACC,+BAA+B;EAC/B,eAAe;CAChB;AAEA,gFAAgF;AAChF;EACC,cAAc;CAUf;AARC;GACC,cAAc;EAMf;AAJC;IACC,kBAAkB;IAClB,kBAAkB;GACnB;ACtCH;;;EAGE;A5BHF;;;EAGE;AAEF;;;;EAIE;AGTF;;;EAGE;AAEF;;EAEE;AFPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;A2BLF;CACC,sBAAsB;;CAEtB,4BAA4B;CAC5B,4CAA4C;AAC7C;AAEA;C5BLC,gBAAgB;A4BmDjB;AA9CA;E5BDE,sCAAsC;A4B+CxC;AA9CA;;CAGC,4CAA4C;CAC5C,8CAA8C;CAC9C,8DAA8D;CAC9D,gCAAgC;;CAEhC,wEAAwE;CACxE,6CAA6C;;CAE7C,+DAA+D;CAC/D,8DAA8D;AAkC/D;AAhCC;AAdD;EAeE,gBAAgB;AA+BlB;CA9BC;AAEA;EzBzBA,4BAA4B;EAC5B,aAAa;EACb,4BAA2B;EFF3B,6CAA8B;C2B4B9B;AAEA;EACC,uDAAuD;EACvD,qDAAqD;EACrD,0CAA0C;CAM3C;AAJC;GACC,iFAAiF;G3BpCnF,sDAA8B;E2BsC7B;AAGD;EACC,gDAAgD;EAChD,uCAAuC;CASxC;AAPC;AAJD;GAKE,eAAe;CAMjB;EALC;AAEA;G3BjDD,mDAA8B;E2BmD7B;AAIF;CACC;EACC,2BAA2B;CAC5B;;CAEA;EACC,0BAA0B;CAC3B;;CAEA;EACC,2BAA2B;CAC5B;;CAEA;EACC,0BAA0B;CAC3B;AACD;AChFA;;;EAGE;AAEF;CACC,iBAAiB;AAClB;ACPA;;;EAGE;AxBHF;;;EAGE;ANHF;;;EAGE;AAEF;;;;EAIE;A8BDF;CACC,sEAAsE;CACtE,iFAAiF;CACjF,qEAAqE;CACrE,iFAAiF;CACjF,0EAA0E;AAC3E;AAEA;C9BLC,gBAAgB;A8BmHjB;AA9GA;E9BDE,sCAAsC;A8B+GxC;AA3GC;EACC,WAAW;CAwCZ;AAtCC;GACC,QAAQ;EAoCT;AArCA;IAIE,SAAS;IACT,qBAAqB;IACrB,+DAA+D;IAC/D,+DAA+D;EA8BjE;AArCA;IAWE,UAAU;IACV,wBAAwB;IACxB,0EAA0E;EAwB5E;AArCA;;GAgBC,oBAAoB;;GAEpB,0DAA0D;GAC1D,8CAA8C;GAC9C,oBAAoB;GACpB,mBAAmB;;GAEnB,6DAA6D;GAC7D,uBAAuB;GACvB,gBAAgB;;GAEhB,eAAe;;GAEf;;;sDAGmD;EAKpD;AAHC;AAlCD;IAmCE,gBAAgB;EAElB;GADC;AAKD;GACC,iCAAiC;EAClC;AAEA;GACC,iCAAiC;EAClC;AAGD;EACC,oCAAoC;EACpC,mCAAmC;;EAEnC;kCACgC;EAChC,mBAAmB;CAKpB;AAHC;GACC,iCAAiC;EAClC;AAGD,mEAAmE;AACnE;;EAEC,0CAA0C;CAC3C;AAEA,qGAAqG;AACrG,0DAA0D;AAC1D;;GAGE,iIAAiI;CAYnI;AAfA;;GAOE,4IAA4I;CAQ9I;AAfA;;;EAUC,mDAAmD;EACnD,kEAAkE;;EAElE,uBAAuB;EACvB,UAAU;CACX;AAEA,uHAAuH;AAEvH,yGAAyG;AACzG;EACC,uBAAuB;CACxB;AAEA,8EAA8E;AAC9E;EACC,UAAU;CACX;AAEA,yFAAyF;AACzF;EACC,+HAA+H;CAChI;AC7HD;;;EAGE;AAEF;CACC,oCAAoC;CACpC,mCAAmC;;CAEnC;iCACgC;CAChC,mBAAmB;AACpB;AAEA;CACC,iCAAiC;AAClC;AChBA;;;EAGE;A5BHF;;;EAGE;AAEF;;EAEE;AJPF;;;EAGE;AAEF;;;;EAIE;ACTF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AKdF;;;EAGE;A0BOF;ChCCC,gBAAgB;AgCOjB;AARA;EhCKE,sCAAsC;AgCGxC;AARA;;CAGC,qBAAqB;CACrB,2CAA2C;;CAE3C,mDAAmD;CACnD,kCAAkC;AACnC;AAEA;CACC,eAAe;;CAEf,sCAAsC;CACtC,eAAe;AA4DhB;AA1DC;EACC,oEAAoE;EACpE,iBAAiB;EACjB,WAAW;EACX,gBAAgB;CAuCjB;AA3CA;GAOE,gBAAgB;CAoClB;AA3CA;GAWE,iBAAiB;CAgCnB;AA7BC;GACC,4DAA4D;GAC5D,wEAAwE;EACzE;AAEA;GACC,gBAAgB;EACjB;AAEA;GACC,qDAAqD;GACrD,0CAA0C;EAa3C;AAXC;IACC,gBAAgB;GACjB;AAEA;IACC,2DAA2D;GAC5D;AAEA;IACC,6CAA6C;GAC9C;AAGD;GACC,wDAAwD;EACzD;AAGD;6CAC4C;AAE3C;GACC,2CAA2C;GAC3C,cAAc;EAMf;AAJC;IACC,wDAAwD;IACxD,cAAc;GACf;AAKH;CACC,qCAAqC;;CAErC,mEAAmE;AAepE;AAdC;EACC,cAAc;CACf;AAEA,iEAAiE;AACjE;EACC,iDAAiD;CAClD;AAEA;EACC,eAAe;EACf,iBAAiB;EACjB,2DAA2D;CAC5D;AAGD;CACC,WAAW;CACX,WAAW;CACX,uCAAuC;;CAEvC,gCAAgC;CAChC,iCAAiC;AAClC;ACjHA;;;EAGE;AAEF;CACC,aAAa;CACb,eAAe;CACf,2BAA2B;CAC3B,2CAA2C;CAC3C,gCAAgC;CAChC,4BAA4B;CAC5B,gDAAgD;CAChD,WAAW;AACZ;ACdA;;;EAGE;AAEF;CACC,iEAAiE;CACjE,kBAAkB;AAKnB;AAHC;EACC,eAAe;CAChB;ACXD;;;EAGE;A/BHF;;;EAGE;AAEF;;EAEE;ACPF;;;EAGE;AAEF;;;;;EAKE;ACVF;;;EAGE;A6BOD;;GAEE;AACF;EACC,WAAW;CAuBZ;AArBC;GACC,YAAY;GACZ,gBAAgB;GAChB,uBAAuB;EACxB;AAEA;G/BbD,mCAAmC;E+BelC;AAGC;IACC,qCAAqC;GACtC;AAIA;IACC,sCAAsC;GACvC;AAIF;;GAEE;AACF;EACC,yDAAyD;EACzD,iBAAiB;CAelB;AAbC;GACC,YAAY;GACZ,kBAAkB;EACnB;AAEA;GACC,4BAA4B;GAC5B,6BAA6B;EAC9B;AAEA;GACC,aAAa;EACd;AAGD;;GAEE;AACF;EACC,gBAAgB;CA+BjB;AA7BC;GACC,oCAAoC;EAuBrC;AAxBA;IAIE,yBAAyB;;IAEzB,yCAAyC;IACzC,uCAAuC;;IAEvC,qFAAqF;IACrF,gDAAgD;EAclD;AAxBA;IAcE,wBAAwB;;IAExB,gCAAgC;;IAEhC,yCAAyC;IACzC,qCAAqC;;IAErC,uGAAuG;IACvG,+CAA+C;EAEjD;AAEA;G/BpFD,mCAAmC;E+BsFlC;AC/FF;;;EAGE;AAEF;CACC,uCAAuC;AACxC;AAEA;CACC,iDAAiD;AAClD;ACXA;;;EAGE;A/BHF;;;EAGE;A+BKD;;GAEE;AACF;EACC,gBAAgB;CAoBjB;AAlBC;;GAEC,0FAA0F;GAC1F,+BAA+B;EAChC;AAEA;GACC,wDAAwD;GACxD,mCAAmC;EASpC;AAXA;IAKE,sCAAsC;EAMxC;AAXA;IASE,qCAAqC;EAEvC;AC/BF;;;EAGE;AtCHF;;;EAGE;AAEF;;;;EAIE;ACTF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AEdF;;;EAGE;AAEF;;EAEE;AmCEF;CACC,wCAAwC;AACzC;AAEA;CtCFC,gBAAgB;AsCoCjB;AAlCA;EtCEE,sCAAsC;AsCgCxC;AAlCA;CrCJC,sCAA8B;;CqCQ9B,qDAAqD;CACrD,uDAAuD;CACvD,SAAS;CACT,mBAAmB;CACnB,kDAAkD;;CAElD,qDAAqD;AAwBtD;AAvBC;;EAEC,yBAAyB;CAC1B;AAEA;;EAEC,0BAA0B;CAC3B;AAEA;;EAEC,4BAA4B;CAC7B;AAEA;;EAEC,6BAA6B;CAC9B;AAEA;EACC,aAAa;CACd;AAKC;;GAEC,yBAAyB;GACzB,gBAAgB;EACjB;AAIA;;GAEC,kDAAkD;GAClD,kBAAkB;GAClB,UAAU;;GnCtDZ,4BAA4B;;GAC5B,aAAa;;GACb,4BAA2B;GFF3B,6CAA8B;EqC0D7B;ACnEF;;;EAGE;AvCHF;;;EAGE;AAEF;;;;EAIE;ACTF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AsCNF;CACC,8BAA8B;CAC9B,8BAA8B;CAC9B,+BAA+B;CAC/B,kCAAkC;CAClC,qEAAqE;AACtE;AAEA;CvCLC,gBAAgB;AuCmMjB;AA9LA;EvCDE,sCAAsC;AuC+LxC;AA9LA;CtCPC,sCAA8B;;CsCW9B,gBAAgB;;CAEhB,4CAA4C;CAC5C,yEAAyE;AAuL1E;AApLE;;GAEC,QAAQ;GACR,SAAS;GACT,mBAAmB;EACpB;AAIA;;GAEC,oHAAoH;EACrH;AAEA;GACC,8EAA8E;GAC9E,uDAAuD;EACxD;AAEA;GACC,kFAAkF;GAClF,mFAAmF;EACpF;AAIA;;GAEC,oHAAoH;EACrH;AAEA;GACC,kEAAkE;GAClE,wDAAwD;GACxD,0DAA0D;EAC3D;AAEA;GACC,kFAAkF;GAClF,sFAAsF;EACvF;AAIA;;GAEC,oHAAoH;EACrH;AAEA;GACC,8EAA8E;GAC9E,yDAAyD;EAC1D;AAEA;GACC,kFAAkF;GAClF,qFAAqF;EACtF;AAIA;;GAEC,oHAAoH;EACrH;AAEA;GACC,8EAA8E;GAC9E,wDAAwD;EACzD;AAEA;GACC,kFAAkF;GAClF,oFAAoF;EACrF;AAIA;;GAEC,SAAS;GACT,0DAA0D;GAC1D,8CAA8C;EAC/C;AAIA;;GAEC,kDAAkD;GAClD,8CAA8C;EAC/C;AAIA;;GAEC,mDAAmD;GACnD,8CAA8C;EAC/C;AAIA;;GAEC,SAAS;GACT,0DAA0D;GAC1D,iDAAiD;EAClD;AAIA;;GAEC,kDAAkD;GAClD,iDAAiD;EAClD;AAIA;;GAEC,mDAAmD;GACnD,iDAAiD;EAClD;AAIA;;GAEC,UAAU;GACV,0DAA0D;GAC1D,iDAAiD;EAClD;AAIA;;GAEC,SAAS;GACT,yDAAyD;GACzD,iDAAiD;EAClD;AAIA;;GAEC,UAAU;GACV,0DAA0D;GAC1D,8CAA8C;EAC/C;AAIA;;GAEC,SAAS;GACT,yDAAyD;GACzD,8CAA8C;EAC/C;AAIA;;GAEC,gDAAgD;GAChD,yDAAyD;GACzD,QAAQ;EACT;AAIA;;GAEC,+CAA+C;GAC/C,yDAAyD;GACzD,QAAQ;EACT;AC5MF;;;EAGE;AAEF;CACC,8CAA8C;CAC9C,uDAAuD;CACvD,kCAAkC;;CAElC,mDAAmD;AAcpD;AAbC;EACC,qCAAqC;EACrC,mCAAmC;EACnC,sCAAsC;CACvC;AAEA,4CAA4C;AAC5C;EACC,wCAAwC;;EAExC,6EAA6E;EAC7E,oCAAoC;CACrC;AAKA,uEAAuE;AACvE;EACC,gBAAgB;CACjB;AC/BD;;;EAGE;AxCHF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AwCPF;CACC,8CAA8C;CAC9C,4CAA4C;AAC7C;AAEA,qEAAqE;AACrE;CxCJC,sCAA8B;;CwCO9B,gBAAgB;;CAEhB,4CAA4C;CAC5C,8CAA8C;CAC9C,sCAAsC;;CAEtC,WAAW;CACX,YAAY;AACb;AAEA;CACC,2DAA2D;CAC3D,wDAAwD;AACzD;AAEA;CACC,qEAAqE;CACrE,kEAAkE;AACnE;AACA;CACC,qEAAqE;CACrE,kEAAkE;AACnE;AAEA,mFAAmF;AACnF;;;CAGC,6CAA6C;AAC9C;AC7CA;;;EAGE;AzCHF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AyCND;EzCCA,sCAA8B;;EyCE7B,uBAAuB;EACvB,yBAAyB;EACzB,0BAA0B;CAC3B;ACdD;;;EAGE;A7BHF;;;EAGE;ARHF;;;EAGE;AqCKF;CACC,mDAAmD;AACpD;AAEA;CACC,gCAAgC;AAoEjC;AAlEC;EACC,2DAA2D;EAC3D,aAAa;CACd;AAGC;GACC,uCAAuC;EACxC;AAIA;GACC,uCAAuC;EACxC;A7BvBD;A6BMD;EAqBE,UAAU;EACV,uCAAuC;AA+CzC;;EA7CE;GACC,yDAAyD;EAY1D;;GAVC;;IAEC,YAAY;IACZ,WAAW;GACZ;;GAEA,yDAAyD;GACzD;IACC,mBAAmB;GACpB;;EAGD,8EAA8E;GAE7E;IACC,mDAAmD;GACpD;;EAGD;;GAEC,mCAAmC;GACnC,mCAAmC;GACnC,gBAAgB;EAiBjB;;GAfC;IACC,iDAAiD;GAClD;;EARD;;IAWE,cAAc;EAUhB;;EArBA;;IAeE,cAAc;EAMhB;;IAJE;KACC,mDAAmD;IACpD;C7BrEH;A8BRD;;;EAGE;AtCHF;;;EAGE;AsCIF;CACC,+FAA+F;AAChG;AAIE;GACC,WAAW;EACZ;AAEA;GACC,2FAA2F;EAoB5F;AAlBC;IACC,WAAW;IACX,oBAAoB;GACrB;AAEA;IACC,WAAW;GAWZ;AAZA;KAIE,4DAA4D;GAQ9D;AAJE;MACC,4DAA4D;KAC7D;AAKH;GACC,uGAAuG;EAwCxG;AAtCC;IACC,8HAA8H;GAC/H;AAEA;IACC,eAAe;IACf,gBAAgB;;IAEhB,gBAAgB;IAChB,WAAW;IACX,UAAU;GAaX;AAnBA;KASE,+BAA+B;GAUjC;AAnBA;KAaE,8BAA8B;GAMhC;AAHC;KACC,UAAU;IACX;AAGD;IACC,WAAW;GAWZ;AARE;MACC,6DAA6D;KAC9D;AANF;KAUE,6DAA6D;GAE/D;AAIF;EACC,eAAe;CAkBhB;AAhBC;GACC,WAAW;GACX,yDAAyD;EAa1D;AAXC;IACC,mBAAmB;GACpB;AAEA;IACC,iBAAiB;GAClB;AAEA;IACC,oCAAoC;GACrC;ACrGH;;;EAGE;AAEF;CACC,+BAA+B;AAChC;AAEA;CACC,qCAAqC;CACrC,sCAAsC;CACtC,iDAAiD;AAKlD;AAHC;AALD;EAME,sBAAsB;AAExB;CADC;AAGD;CACC,qCAAqC;CACrC,sCAAsC;CACtC,kBAAkB;CAClB,sCAAsC;CACtC,6BAA6B;AAC9B;AAEA;CACC;EACC;CACD;AACD;AC/BA;;;EAGE;AAEF;;;EAGE;AACF;CACC;AACD;ACXA;;;EAGE;AAEF;CACC,qDAAqD;CACrD,0DAA0D;AAC3D;AAEA;CACC,2CAA2C;CAC3C,uCAAuC;AACxC;ACbA;;;EAGE;AhDHF;;;EAGE;AAEF;;;;EAIE;AMTF;;;EAGE;A0CKF;ChDGC,gBAAgB;AgDwGjB;AA3GA;EhDOE,sCAAsC;AgDoGxC;AA3GA;;CAGC,8CAA8C;CAC9C,kCAAkC;CAClC,gDAAgD;AAsGjD;AApGC;EACC,2BAA2B;EAC3B,UAAU;EACV,cAAc;EACd,0CAA0C;;EAE1C;;;IAGE;EACF,mCAAmC;EACnC,sCAAsC;CACvC;AAEA;EACC,SAAS;CACV;AAGC;GACC,kCAAkC;GAClC,qCAAqC;EACtC;AAEA;+BAC6B;AAC7B;GACC,aAAa;EACd;AAGD;;EAEC,4DAA4D;EAC5D,mCAAmC;EACnC,sCAAsC;CACvC;AAEA;EACC,uDAAuD;EACvD,UAAU;;EAEV,+FAA+F;CAWhG;AAVC;GACC,kEAAkE;GAClE,WAAW;;GAEX,uDAAuD;GACvD,SAAS;;GAET,wFAAwF;GACxF,gBAAgB;EACjB;AAGD;EACC,6BAA6B;EAC7B,UAAU;CAWX;AATC;GACC,wDAAwD;GACxD,SAAS;;GAET,sDAAsD;EAIvD;AAHC;IACC,gBAAgB;GACjB;AAKD;;;IAGE;AACF;GACC,oCAAoC;EACrC;AAGD,qEAAqE;AAEpE,gHAAgH;AAChH;GACC,eAAe;EAChB;AAEA;GACC,cAAc;GACd,WAAW;EACZ;AAGD;EACC,aAAa;CACd;AAtGD;EAyGE,SAAS;AAEX;AAEA,sBAAsB;AAEtB;;;;;EAKE;AAGD;EACC,eAAe;CAChB;AAEA;EACC,kCAAkC;EAClC,oCAAoC;CACrC;AAEA;EACC,cAAc;CACf;AAGC,6DAA6D;AAC7D;GACC,yBAAyB;GACzB,4BAA4B;EAC7B;AAEA,2DAA2D;AAC3D;GACC,0BAA0B;GAC1B,6BAA6B;EAC9B;AAGD,uFAAuF;AACvF;EACC,oCAAoC;CACrC;AAEA,wFAAwF;AACxF;EACC,oCAAoC;CACrC;AAGD;;;;;EAKE;AAGD;EACC,eAAe;CAChB;AAGC,6DAA6D;AAC7D;GACC,0BAA0B;GAC1B,6BAA6B;EAC9B;AAEA,2DAA2D;AAC3D;GACC,yBAAyB;GACzB,4BAA4B;EAC7B;AAGD,uFAAuF;AACvF;EACC,qCAAqC;CACtC;AAEA,wFAAwF;AACxF;EACC,qCAAqC;CACtC;AAGD,qBAAqB;AC1MrB;;;EAGE;AjDHF;;;EAGE;AAEF;;;;EAIE;AiDFF;CACC,8BAA8B;CAC9B,8BAA8B;CAC9B,kCAAkC;CAClC,8BAA8B;CAC9B,8BAA8B;CAC9B,+DAA+D;;CAE/D,mCAAmC;;CAenC,+BAA+B;CAC/B,gBAAgB;AAMjB;AApBC;EACC,eAAe;EACf,gBAAgB;EAChB,mCAAmC;CACpC;AAEA;EACC,yBAAyB;EACzB,qBAAqB;EACrB,yCAAyC;EACzC,gBAAgB;CACjB;AAKA,yDAAyD;AACzD;EACC,aAAa;CACd;;A9DiBD,WAAW;A+DrDX;;;EAGE;AlDHF;;;EAGE;AAEF;;;;EAIE;AkDAA;GlDED,gBAAgB;EkDmBf;AArBA;ElDMA,sCAAsC;IkDJpC,4BAA4B;IAC5B,6BAA6B;EAkB/B;AArBA;;GAMC,6CAA6C;GAC7C,sBAAsB;EAcvB;AAZC;IACC,wBAAwB;GACzB;AAEA;IACC,SAAS;IACT,oDAAoD;GACrD;AAEA;IACC,SAAS;GACV;AAKH,0FAA0F;AAC1F;CACC,gEAAgE;CAChE,2CAA2C;;ClD1B3C,gBAAgB;AkDoCjB;AAZA;ElDpBE,sCAAsC;EkDyBtC,yBAAyB;EACzB,0BAA0B;AAM5B;AAHC;EACC,yCAAyC;CAC1C;;A/DUD,YAAY;AgExDZ;;;EAGE;A7CHF;;;EAGE;A6CIF;CACC,0CAA0C;CAC1C,0CAA0C;CAC1C,8DAA8D;AAC/D;AAGC;;GAEE;AAED;GACC,8DAA8D;GAC9D,2DAA2D;GAC3D,uDAAuD;GACvD,iDAAiD;GACjD,iBAAiB;;GAEjB,kCAAkC;EAgBnC;AAfC;IACC,WAAW;IACX,QAAQ;IACR,SAAS;;IAET,cAAc;IACd,kBAAkB;IAClB,SAAS;IACT,2DAA2D;;IAE3D,2BAA2B;IAC3B,uFAAuF;IACvF,0KAA0K;IAC1K,mBAAmB;GACpB;AAIF;;GAEE;AACF;EACC,kGAAkG;CACnG;AAEA;;GAEE;AACF;EACC,SAAS;EACT,wBAAwB;CACzB;AAGD;CACC,SAAS;CACT,uDAAuD;CACvD,iDAAiD;CACjD,gBAAgB;AAwBjB;AAtBC;EACC,WAAW;EACX,kBAAkB;EAClB,0DAA0D;EAC1D,QAAQ;EACR,SAAS;EACT,mBAAmB;CAepB;AArBA;GASE,UAAU;;GAEV,oKAAoK;GACpK,uFAAuF;CASzF;AArBA;GAgBE,WAAW;;GAEX,mKAAmK;GACnK,uFAAuF;CAEzF;ACvFD;;;EAGE;AAEF;CACC,uDAAuD;AACxD;AAEA;CACC,SAAS;CACT,WAAW;CACX,uDAAuD;;CAEvD,eAAe;CACf,gCAAgC;CAChC,iBAAiB;CACjB,wDAAwD;CACxD,uBAAuB;CACvB,mBAAmB;AACpB;AAEA;CACC,2FAA2F;CAC3F,iBAAiB;CACjB,gBAAgB;CAChB,kBAAkB;AACnB;AC3BA;;;EAGE;A1CHF;;;EAGE;A0CIF,gCAAgC;A1CD/B;EACC;E0CGA;;;IAGE;EACF,0CAA0C;E1CL1C;CACD;A0COA;EACC,YAAY;CAmBb;A1CvBA;EACC;G0CMC,8CAA8C;E1CJ/C;CACD;AAZA;EACC;G0CkBC;;;KAGE;GACF,kBAAkB;;GAElB;;;KAGE;GACF,gBAAgB;E1C1BjB;CACD;A2CVD;;;EAGE;AxCHF;;;EAGE;ARHF;;;EAGE;AgDKF;CACC,YAAY;;CAEZ;;;GAGE;AA+GH;AA9GC;EACC,aAAa;CACd;AAEA,oDAAoD;AACpD;;EAEC,cAAc;EACd,mBAAmB;EACnB,eAAe;EACf,mBAAmB;EACnB,sBAAsB;;EAEtB,gCAAgC;EAChC,SAAS;;CA2BV;AAzBC;GACC,cAAc;EACf;AAGC;IACC,uCAAuC;GACxC;AAIA;IACC,wCAAwC;GACzC;AAGD;GACC,cAAc;EAMf;AAJC;IACC,WAAW;IACX,eAAe;GAChB;AAKF,qCAAqC;AACrC;EACC,0EAA0E;EAC1E,uBAAuB;CAqCxB;AAnCC;GACC,wBAAwB;EACzB;AAEA;GACC,yBAAyB;EAC1B;AAEA;GACC,QAAQ;GACR,2BAA2B;EAW5B;AAbA;IAKE,iCAAiC;EAQnC;AAbA;IASE,gCAAgC;EAIlC;AAbA;;GAYC,kCAAkC;EACnC;AAEA;GACC,cAAc;GACd,uCAAuC;EASxC;AAXA;IAKE,cAAc;EAMhB;AAXA;IASE,eAAe;EAEjB;AAGD,sCAAsC;AACtC;EACC,eAAe;EACf,yBAAyB;EACzB,gDAAgD;CAWjD;AATC;GACC,iBAAiB;;GAEjB,8EAA8E;EAK/E;AAJC;IACC,qCAAqC;IACrC,sCAAsC;GACvC;AAIF;EACC,WAAW;EACX,aAAa;EACb,mBAAmB;EACnB,iBAAiB;EACjB,8BAA8B;EAC9B,mBAAmB;CACpB;AxCtHA;CwC0HA;EACC,YAAY;;EAEZ,+GAA+G;EAC/G,eAAe;;EAEf,qCAAqC;CA0DtC;EAzDC;GACC,eAAe;EA4BhB;;GA1BC;IACC,cAAc;IACd,WAAW;IACX,yCAAyC;GAC1C;;GAEA;IACC,kBAAkB;GAkBnB;;IAhBC;KACC,cAAc;IAcf;;IAfA;MAIE,cAAc;IAWhB;;IAfA;MAQE,eAAe;IAOjB;;KAJC;MACC,WAAW;MACX,kBAAkB;KACnB;;EAKH,sCAAsC;EACtC;GACC,eAAe;GACf,cAAc;EAsBf;;GApBC;IACC,kBAAkB;GAkBnB;;IAhBC;KACC,cAAc;IASf;;IAVA;MAIE,cAAc;IAMhB;;IAVA;MAQE,eAAe;IAEjB;;IAEA;KACC,WAAW;KACX,kBAAkB;IACnB;CxCrLH;AyCRD;;;EAGE;AAEF,oCAAoC;AAEnC;EACC,UAAU;CACX;AAEA;EACC,eAAe;CAChB;ACbD;;;EAGE;AAEF;;;;EAIE;ACTF;;;EAGE;AAEF;CACC,qEAAqE;CACrE,mCAAmC;CACnC,4CAA4C;CAC5C,0FAA0F;;CAE1F,2EAA2E;CAC3E,uDAAuD;AACxD;AAEA,2BAA2B;AAC3B;CACC,mCAAmC;CACnC,iDAAiD;AAyIlD;AAvIC;EACC,kGAAkG;CACnG;AAEA,kEAAkE;AAClE;EACC,gBAAgB;CACjB;AAEA;EACC,iBAAiB;CAClB;AAEA,+FAA+F;AAE/F;EACC,oCAAoC;EACpC,4DAA4D;EAC5D,gCAAgC;EAChC,4BAA4B;EAC5B,2GAA2G;EAC3G,mIAAmI;EACnI,kEAAkE;EAClE,sCAAsC;EACtC,mCAAmC;EACnC,gCAAgC;CACjC;AAEA;EACC,UAAU;EACV,iCAAiC;CAClC;AAEA,+DAA+D;AAC/D;EACC,iBAAiB;CAClB;AAxCD;EA2CE,QAAQ;EACR,uDAAuD;AA+FzD;AA3IA;EAgDE,MAAM;EACN,uDAAuD;EACvD,wCAAwC;AAyF1C;AA3IA;EAsDE,QAAQ;EACR,uDAAuD;AAoFzD;AAjFC,iGAAiG;AAEjG;EACC,mCAAmC;CACpC;AAEA,oCAAoC;AACpC;EACC,+BAA+B;EAC/B,iCAAiC;CAalC;AAXC;GACC,kCAAkC;EACnC;AAEA;GACC,oCAAoC;EACrC;AAEA;GACC,mCAAmC;EACpC;AAGD;EACC,gCAAgC;EAChC,WAAW;CACZ;AAEA,6BAA6B;AAC7B;EACC,sBAAsB;EACtB,0CAA0C;EAC1C,yCAAyC;EACzC,YAAY;EACZ,YAAY;EACZ,mCAAmC;;EAEnC,sBAAsB;EACtB,WAAW;EACX,qBAAqB;EACrB,mCAAmC,EAAE,uBAAuB;;EAE5D,qCAAqC;EACrC,gBAAgB;EAChB,cAAc;CAUf;AARC;GACC,2DAA2D;GAC3D,iDAAiD;;GAEjD,uHAAuH;GACvH,mEAAmE;GACnE,UAAU;EACX;AAGD,gCAAgC;AAChC;EACC,mDAAmD;EACnD,yCAAyC;;EAEzC,0EAA0E;CAI3E;AARA;GAME,oBAAoB;CAEtB;AAEA;EACC,sBAAsB;EACtB,iDAAiD;CAMlD;AAJC;GACC,iBAAiB;GACjB,kBAAkB;EACnB;AAGD;EACC;CACD;AC1JD;;;EAGE;ApDHF;;;EAGE;AoDIF;CACC,4CAA4C;AAC7C;AAEA;CACC,sBAAsB;AAgBvB;AAdC;EACC,wCAAwC;EACxC,mCAAmC;CAWpC;AATC;;GAEC,uBAAuB;GACvB,eAAe;EAChB;AAEA;GACC,2BAA2B;EAC5B;AAKD;EACC,cAAc;EACd,WAAW;CASZ;AAXA;GAKE,gBAAgB;CAMlB;AAXA;GASE,iBAAiB;CAEnB;AAEA;;EASC,qDAAqD;CACtD;AATC;GACC,iDAAiD;EAClD;AAEA;GACC,oDAAoD;EACrD;AAKD,wFAAwF;AACxF;EACC,qDAAqD;EACrD,gCAAgC;CACjC;AAEA;EACC,aAAa;CACd;AChED;;;EAGE;ACHF;;;EAGE;AAEF;CACC,8CAA8C;CAC9C,4DAA4D;;CAE5D,2FAA2F;CAC3F,+BAA+B;CAC/B,iCAAiC;CACjC,+DAA+D;AAChE;AAEA;CACC,UAAU;CACV,wDAAwD;CACxD,0EAA0E;CAC1E,uCAAuC;CACvC,gCAAgC;;CAEhC,gCAAgC;CAChC,uDAAuD;;CAEvD,gDAAgD;CAChD,4BAA4B;;CAE5B;;;GAGE;CACF,gBAAgB;CAChB,sFAAsF;CACtF,uFAAuF;;CAEvF,6EAA6E;AAkC9E;AAjCC;EACC,2EAA2E;EAC3E,SAAS;;EAET,QAAQ;EACR,UAAU;EACV,SAAS;EACT,QAAQ;;EAER,oCAAoC;EACpC,0BAA0B;EAC1B,qFAAqF;EACrF,uFAAuF;;EAEvF,6CAA6C;EAC7C,yBAAyB;EACzB,sBAAsB;EACtB,6BAA6B;;EAE7B,oGAAoG;EACpG,sBAAsB;CACvB;AAEA;AA7CD;EA8CE,uBAAuB;AASzB;;EAPE;GACC,eAAe;GACf,UAAU;GACV,YAAY;GACZ,cAAc;EACf;CACD;AAGD;CACC;EACC,UAAU;CACX;;CAEA;EACC,UAAU;CACX;AACD;AAEA;CACC;EACC,UAAU;CACX;;CAEA;EACC,UAAU;CACX;AACD;AAEA;CACC;EACC,UAAU;EACV,QAAQ;EACR,SAAS;CACV;CACA;EACC,YAAY;EACZ,SAAS;CACV;CACA;EACC,UAAU;EACV,YAAY;EACZ,cAAc;CACf;AACD;AC3GA;;;EAGE;AAEF;CACC,qDAAqD;CACrD,yCAAyC;CACzC,+CAA+C;AAChD;AAEA;CACC,kEAAkE;CAClE,WAAW;CACX,SAAS;AAeV;AAbC;EACC,6GAA6G;CAC9G;AAEA;EACC;;;;;IAKE;EACF,6DAA6D;CAC9D;AAGD;CACC,WAAW;CACX,YAAY;AAUb;AARC;EACC,+CAA+C;EAC/C,gDAAgD;EAChD,kBAAkB;EAClB,+DAA+D;EAC/D,mCAAmC;EACnC,0DAA0D;CAC3D;AAGD;CACC;EACC,2BAA2B;CAC5B;AACD;ACjDA;;;EAGE;AAKA,uBAAuB;AACvB;GACC,uBAAuB;EAMxB;AAJC;AAHD;IAIE,UAAU;IACV,eAAe;EAEjB;GADC;AAIF,yBAAyB;AACzB;;EAEC,WAAW;EACX,QAAQ;EACR,iDAAiD;EACjD,uBAAuB;CACxB;AAGD;CACC,OAAO,UAAU,EAAE;CACnB,OAAO,UAAU,EAAE;AACpB;AChCA;;;EAGE;AAEF,qEAAqE;AACrE;CACC,oDAAoD;;CAEpD,gGAAgG;AAIjG;AAHC;EACC,0FAA0F;CAC3F;AAGD;;;EAGE;AACF;CACC,+CAA+C;AAChD;AAEA,uCAAuC;AACvC;CACC,YAAY;CACZ,iDAAiD;CACjD,kBAAkB;CAClB,wCAAwC;AACzC;AC7BA;;;EAGE;ACHF;;;EAGE;AAEF;;EAEE;A3DPF;;;EAGE;AHHF;;;EAGE;AAEF;;EAEE;AFPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AadF;;;EAGE;AkDSD;EACC,eAAe;EACf,gBAAgB;CAmCjB;AAjCC;GACC,mCAAmC;GACnC,mCAAmC;GACnC,uBAAuB;GACvB,eAAe;;GAEf;oEACiE;GACjE,gCAAgC;GAChC,cAAc;GACd,kBAAkB;EAKnB;AAHC;IACC,0BAA0B;GAC3B;AAGD;;;;GAIC,gBAAgB;EACjB;AAEA;GACC,gBAAgB;EACjB;AAGC;IACC,0BAA0B;GAC3B;AAKD;GACC,uCAAuC;EACxC;AAIA;GACC,uCAAuC;EACxC;AlDtDD;EkD0DC;GACC,+DAA+D;EAMhE;;GAJC;IACC,YAAY;IACZ,eAAe;GAChB;;EAGD;IAEE,cAAc;EAMhB;;EARA;IAME,cAAc;EAEhB;ClDzED;AoDRD;;;EAGE;A5DHF;;;EAGE;A4DIF;;;EAGE;AACF;CACC,UAAU;CACV,gCAAgC;AA+CjC;AA7CC;EACC,+EAA+E;CAMhF;AAJC;GACC,YAAY;GACZ,WAAW;EACZ;AAGD;EACC,mCAAmC;EACnC,SAAS;EACT,UAAU;EACV,gBAAgB;CAiBjB;AAfC;GACC,iDAAiD;EAClD;AARD;GAWE,cAAc;CAUhB;AArBA;GAeE,cAAc;CAMhB;AAJE;IACC,mDAAmD;GACpD;AAIF,4GAA4G;AAC5G;EACC,iCAAiC;CAUlC;AARC;GACC,UAAU;GACV,WAAW;EAKZ;AAHC;IACC,gBAAgB;GACjB;ACzDH;;;EAGE;AAEF;CACC,uFAAuF;CACvF,uCAAuC;CACvC,uEAAuE;AACxE;AAGC,2BAA2B;AAG1B;GACC,WAAW;;GAEX;;;KAGE;GACF,sCAAsC;GACtC,wCAAwC;;GAExC,qCAAqC;GACrC,yDAA+3B;GAC/3B,qBAAqB;GACrB,4BAA4B;GAC5B,2BAA2B;GAC3B,mBAAmB;;GAEnB;;;IAGC;GACD,gBAAgB;GAChB,sGAAsG;GACtG,uGAAuG;EACxG;ACvCF;;;EAGE;AAGD,+DAA+D;AAC/D;EACC,gCAAgC;CASjC;AAPC;GACC,eAAe;EAKhB;AAHC;IACC,sCAAsC;GACvC;AAIF;;;GAGE;AAED;GACC,wCAAwC;EACzC;AAEA,4EAA4E;AAC5E;GACC,iDAAiD;EAWlD;AARE;KACC,WAAW;IAKZ;AAHC;MACC,sCAAsC;KACvC;AAMJ;EACC,eAAe;EACf,WAAW;CACZ;AAEA;EACC,uBAAuB;EACvB,eAAe;EACf,gBAAgB;EAChB,gDAAgD;CAOjD;AALC;GACC,gBAAgB;GAChB,yBAAyB;GACzB,gBAAgB;EACjB;AC3DF;;;EAGE;AAEF;CACC,iCAAiC;AAClC;AAEA;CACC,wCAAwC;CACxC,iCAAiC;CACjC,oCAAoC;CACpC,gCAAgC;AA0BjC;AAxBC;EACC,qEAAqE;EACrE,uCAAuC;EACvC,wCAAwC;EACxC,UAAU;;EAEV;;;IAGE;EACF,SAAS;;EAET;;;;IAIE;EACF,uBAAuB;CAMxB;AAJC;GACC,uCAAuC;GACvC,wCAAwC;EACzC;ACrCF;;;EAGE;AAEF;CACC,2CAA2C;;CAE3C,4DAA4D;CAC5D,4EAA4E;AAC7E;AAEA;CACC,cAAc;AA+Ff;AA7FC;EACC,+CAA+C;EAC/C,2CAA2C;CA4B5C;AA1BC;GACC,sDAAsD;GACtD,mDAAmD;GACnD,sCAAsC;GACtC,2BAA2B;GAC3B,sBAAsB;EAMvB;AAJC;IACC,WAAW;IACX,YAAY;GACb;AAGD;GACC,uDAAuD;GACvD,mBAAmB;GACnB,kBAAkB;GAClB,kBAAkB;GAClB,uBAAuB;EAOxB;AALC;IACC,6DAA6D;IAC7D,eAAe;IACf,0BAA0B;GAC3B;AAIF;EACC,gBAAgB;EAChB,iBAAiB;CAClB;AAEA;;;;EAIC,yDAAiwG;CAClwG;AAEA;EACC,8BAA8B;CAa/B;AAXC;GACC,yDAAywC;EAC1wC;AAEA;GACC,0BAA0B;EAK3B;AAHC;IACC,uBAAuB;GACxB;AAIF;EACC,8FAA8F;CAc/F;AAZC;GACC,yDAAy2J;EAC12J;AAEA,0DAA0D;AAC1D;GACC,0BAA0B;EAK3B;AAHC;IACC,uBAAuB;GACxB;AAIF;EACC,sFAAsF;EACtF,+EAA+E;CAahF;AAXC;GACC,yDAA6zC;EAC9zC;AAEA;GACC,0BAA0B;EAK3B;AAHC;IACC,uBAAuB;GACxB;ACzGH;;;EAGE;AAEF;CACC,wDAAwD;CACxD,4CAA4C;AAC7C;AAEA;CACC,8CAA8C;CAC9C,mCAAmC;AACpC;ACbA;;;EAGE;AAEF;CACC,2EAA2E;CAC3E,kFAAkF;CAClF,yEAAyE;CACzE,oFAAoF;CACpF,kFAAkF;AACnF;AAEA;CACC,sCAAsC;CACtC,yEAAyE;CACzE,iBAAiB;CACjB;;;;;;;;IAQG;AAqBJ;AAnBC;AAdD;EAeE,gBAAgB;AAkBlB;CAjBC;AAEA;EACC,kFAAkF;EAClF;;;;;;KAMG;CACJ;AAEA;EACC,iFAAiF;EACjF,iBAAiB;CAClB;AAGD;CACC,eAAe;;CAEf;+BAC8B;AAgB/B;AAfC;EACC,eAAe;CAChB;AAEA;EACC,YAAY;CASb;AAPC;GACC,YAAY;EACb;AAEA;GACC,yEAAyE;EAC1E;AClEF;;;EAGE;A3DHF;;;EAGE;AdHF;;;EAGE;AAEF;;;;EAIE;AyEDF;CACC,mCAAmC;AACpC;AAEA;CACC,gBAAgB;CAChB,kBAAkB;AAoCnB;AAlCC;EACC,yFAAyF;EACzF,0DAA0D;EAC1D,oCAAoC;CACrC;AAEA;EACC,yCAAyC;EACzC,0CAA0C;EAC1C,6CAA6C;EAC7C,8CAA8C;EAC9C,gBAAgB;EAChB,UAAU;EACV,+BAA+B;EAC/B,SAAS;CAmBV;AAjBC;AAVD;GAWE,gBAAgB;CAgBlB;EAfC;AAEA;;GAEC,kDAAkD;GAClD,SAAS;GACT,mGAAmG;EACpG;AAEA,gEAAgE;AAChE;GACC,+CAA+C;GAC/C,WAAW;GACX,kBAAkB;EACnB;AChDF;;;EAGE;A5DHF;;;EAGE;A4DIF;CACC,wDAAwD;CACxD,iDAAiD;AAgBlD;AAdC;EACC,yBAAyB;EACzB,oCAAoC;CACrC;AAEA;EACC,gBAAgB;EAChB,uBAAuB;EACvB,gBAAgB;CACjB;AAEA;EACC,WAAW;CACZ;ACxBD;;;EAGE;ArEHF;;;EAGE;AQHF;;;EAGE;A6DOD;EACC,gBAAgB;EAChB,uBAAuB;EACvB,gBAAgB;CACjB;AAEA;EACC,4FAA4F;EAC5F,iBAAiB;EACjB,gBAAgB;EAChB,kBAAkB;CACnB;A7DfA;A6DED;EAgBE,gBAAgB;AAOlB;;EALE;GACC,uBAAuB;GACvB,gBAAgB;EACjB;C7DrBD;A8DRD;;;EAGE;AAEF;CACC,kBAAkB;AACnB;ACPA;;;EAGE;AAEF;CACC,oCAAoC;CACpC,oCAAoC;CACpC,2DAA2D;CAC3D,iEAAiE;CACjE,2DAA2D;AAC5D;AAEA;CACC,gCAAgC;CAChC,mCAAmC;AAkFpC;AAhFC;EACC,2EAA2E;EAC3E,4EAA4E;;EAE5E,UAAU;EACV,yCAAyC;EACzC,2CAA2C;;EAE3C,+CAA+C;CAuEhD;AAtEC;GACC,6CAA6C;EAC9C;AAEA;GACC,YAAY;GACZ,iBAAiB;GACjB,WAAW;GACX,mCAAmC;GACnC,gBAAgB;GAChB,uBAAuB;GACvB,cAAc;EACf;AAEA;GACC,WAAW;GACX,gBAAgB;GAChB,WAAW;;GAEX,iCAAiC;GACjC,2CAA2C;GAC3C,iDAAiD;EAClD;AAEA;GACC,8EAA8E;;GAE9E,+CAA+C;EAWhD;AAVC;IACC,2DAA2D;GAC5D;AAEA;IACC,WAAW;;IAEX,6CAA6C;IAC7C,oBAAoB;GACrB;AAGD;GACC,yCAAyC;EAU1C;AARC;IACC,gDAAgD;IAChD,UAAU,EAAE,gDAAgD;GAC7D;AAEA;IACC,+CAA+C;GAChD;AAIA;IACC,yDAAyD;GAC1D;AAEA;IACC,+DAA+D;GAChE;AAGD;GACC,6DAA6D;EAK9D;AAHC;IACC,UAAU;GACX;AC9FH;;;EAGE;AAGD;EACC,iCAAiC;CAClC;AAGC;GACC,aAAa;EACd;ACbF;;;EAGE;AAEF;CACC,kCAAkC;AACnC;AAEA;CACC,gCAAgC;CAChC,gBAAgB;CAChB,4CAA4C;AAC7C;ACbA;;;EAGE;A1EHF;;;EAGE;ANHF;;;EAGE;AAEF;;;;EAIE;AgFAD;GAEE,0BAA0B;GAC1B,6BAA6B;CAa/B;AAhBA;GAOE,yBAAyB;GACzB,4BAA4B;CAQ9B;AALC;+EAC6E;AAC7E;GACC,UAAU;EACX;AAIA;GACC,UAAU;EA0CX;AA3CA;IAIE,yBAAyB;IACzB,4BAA4B;EAsC9B;AApCE;KACC,kCAAkC;IACnC;AATF;IAaE,0BAA0B;IAC1B,6BAA6B;EA6B/B;AA3BE;KACC,mCAAmC;IACpC;AAGD;IACC,qDAAqD;GACtD;AAEA;IhF1CF,gBAAgB;GgF2Dd;AAjBA;EhFtCD,sCAAsC;GgFuDrC;AAjBA;;IAGC,WAAW;IACX,YAAY;IACZ,8CAA8C;GAY/C;AAVC;KACC,SAAS;KACT,SAAS;KACT,YAAY;KACZ,SAAS;KACT,6BAA6B;KAC7B,kBAAkB;KAClB,wBAAwB;KACxB,qBAAqB;IACtB;AAKH;EACC,WAAW;EACX,wEAAwE;;EAExE,4BAA4B;EAC5B,6BAA6B;CAsB9B;AApBC;GACC,qDAAqD;EACtD;AATD;GAYE,0BAA0B;CAe5B;AA3BA;GAgBE,yBAAyB;CAW3B;AARC;GACC,wCAAwC;EAMzC;AAPA;IAIE,eAAe;IACf,uCAAuC;EAEzC;ACpGF;;;EAGE;AAEF;CACC,oCAAoC;AAyBrC;AAvBC;EACC,2DAA2D;EAC3D,aAAa;CACd;AAEA;EACC,eAAe;EACf,QAAQ;CACT;AAEA;EACC,eAAe;CAWhB;AARE;IACC,6CAA6C;GAC9C;AAEA;IACC,WAAW;GACZ;AC5BH;;;EAGE;A5EHF;;;EAGE;A4EIF;CACC,6DAA6D;;CAE7D,gDAAgD;AAyBjD;AAvBE;IAEE,oCAAoC;EAMtC;AARA;IAME,qCAAqC;EAEvC;AAGD;EACC,WAAW;EACX,eAAe;CAChB;AAEA;EACC,mCAAmC;CAKpC;AAHC;GACC,2BAA2B;EAC5B;ACjCF;;;EAGE;AAEF;CACC,wCAAwC;CACxC,2CAA2C;CAC3C,0CAA0C;CAC1C,0CAA0C;AAC3C;AAEA;CACC,2FAA2F;CAC3F,2JAA2J;CAC3J,0FAA0F;AAC3F;AAEA;;CAEC,kBAAkB;AACnB;AAEA;CACC,oDAAoD;CACpD,sDAAsD;CACtD,kDAAkD;CAClD,6CAA6C;CAC7C,kBAAkB;CAClB,aAAa;CACb,gBAAgB;AAcjB;AAZC;AATD;EAUE,gBAAgB;AAWlB;CAVC;AAEA;EACC,gBAAgB;CACjB;AAEA;EACC,0CAA0C;EAC1C,8CAA8C;CAC/C;AC3CD;;;EAGE;AAEF;CACC,YAAY;AAkBb;AAfE;GACC,oBAAoB;GACpB,UAAU;GACV,UAAU;EACX;AAGC;IACC,gBAAgB;;IAEhB,2FAA2F;IAC3F,sCAAsC;GACvC;ACrBH;;;EAGE;AAEF;CACC,oEAAoE;AACrE;AAKE;;;;;IAKE;AACF;;;;GAEC,2DAA2D;GAC3D,4DAA4D;GAC5D,+CAA+C;GAC/C,oBAAoB,EAAE,4CAA4C;EACnE;ACxBF;;;EAGE;AtFHF;;;EAGE;AAEF;;;;EAIE;AsFFF;CACC,2CAA2C;CAC3C,4CAA4C;AAC7C;AAMI;KACC,mCAAmC;KACnC,kBAAkB;IACnB;AAGD;;IAEC,WAAW;IACX,eAAe;IACf,eAAe;GAChB;AAGD;GACC,UAAU;EAcX;AAZC;;IAEC;GACD;AAEA;IACC,oBAAoB;IACpB,qBAAqB;IACrB,yCAAyC;IACzC,8CAA8C;IAC9C,iCAAiC;GAClC;AAIF;EACC,uCAAuC;CA6BxC;AA3BC;GtFxCD,gBAAgB;EsF6Df;AArBA;EtFpCA,sCAAsC;EsFyDtC;AArBA;;GAGC,sCAAsC;GACtC,sCAAsC;GACtC,yDAAyD;GACzD,qDAAqD;GACrD,kBAAkB;;GASlB,kEAAkE;;GAPlE,0CAA0C;EAY3C;AAXC;IACC,4EAA4E;IAC5E,mJAAmJ;IACnJ,mBAAmB;GACpB;AAIA;AAlBD;IAmBE,eAAe;EAEjB;GADC;AAGD,4FAA4F;AAC5F;GACC,aAAa;EACd;AAIF;CACC;EACC,UAAU;CACX;;CAEA;EACC,UAAU;CACX;AACD;ACzFA;;;EAGE;AAEF;CACC,YAAY;AAmBb;AAhBE;GACC,oBAAoB;GACpB,UAAU;EAYX;AAVC;IACC,gBAAgB;;IAEhB,2FAA2F;IAC3F,sCAAsC;GAKvC;AAHC;KACC,WAAW;IACZ;ACrBJ;;;EAGE;AAEF;CACC,4DAA4D;AAC7D;AAGC;;EAEC,kBAAkB;EAClB,wBAAwB;EACxB,cAAc;EACd,iBAAiB;;EAEjB,sDAAsD;CA4BvD;AA3BC;GACC,WAAW;GACX,oBAAoB;GACpB,0DAA0D;GAC1D,kBAAkB;GAClB,MAAM;GACN,OAAO;GACP,QAAQ;GACR,SAAS;EACV;AAEA;;;;GAEC,6BAA6B;EAC9B;AAEA;;;IAGE;AACF;GACC,cAAc;EAKf;AAHC;IACC,aAAa;GACd;AC3CH;;;EAGE;AtFHF;;;EAGE;AAEF;;EAEE;AFPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;AUdF;;;EAGE;A8EMF;CACC,kCAAkC;CAClC,mCAAmC;CACnC,6CAA6C;CAC7C,yCAAyC;;CAEzC,iDAAiD;CACjD,kDAAkD;CAClD,4EAA4E;CAC5E,0EAA0E;AAC3E;AAEA;CACC,iDAAiD;CACjD,oBAAoB;CACpB,0BAA0B;CAC1B,8GAA8G;AAc/G;AAZC;AAND;EAOE,gBAAgB;AAWlB;CAVC;AAEA;;EAEC,8EAA8E;CAC/E;AAEA;EACC,kDAAkD;CACnD;AAGD;CACC,6BAA6B;;CAE7B;4GAC2G;AAiB5G;AAhBC;;ExFrCA,uCAA8B;CwFoD9B;A9E/CA;EACC;G8EmCC,kEAAkE;E9EjCnE;CACD;A8EmCC;;;;IAIE;AACF;GtFjDD,4BAA4B;GAC5B,aAAa;GACb,4BAA2B;EsFiD1B;AAKD;EACC,YAAY;EACZ,sBAAsB;;EAEtB,iGAAiG;EACjG,6BAA6B;EAC7B,UAAU;;EAEV;;;6EAG2E;EAC3E;;;+FAG6F;;EAE7F,iCAAiC;EACjC,kEAAkE;;EAElE,uDAAuD;EACvD,4BAA4B;EAC5B,oDAAoD;EACpD,MAAM;CA6BP;AA3BC;AAzBD;GA0BE,gBAAgB;CA0BlB;EAzBC;AAEA;GACC,yFAAyF;GACzF,yCAAyC;GACzC,0CAA0C;GAC1C,qDAAqD;;GAErD,4DAA4D;EAW7D;AAVC;IACC,UAAU;;IAEV,mEAAmE;IACnE,kEAAkE;GAKnE;AAHC;AAND;KAOE,gBAAgB;GAElB;IADC;AAIF,qGAAqG;AACrG;GACC,UAAU;EACX;AAGD,2FAA2F;AAC3F;EACC,UAAU;EACV,qDAAqD;CACtD;AAEA,wFAAwF;AAGvF;GACC,UAAU;GACV,8CAA8C;;GAE9C,oFAAoF;EAIrF;AAHC;IACC,UAAU;GACX;AAKH,sFAAsF;AACtF,0DAA0D;AAC1D;CACC,UAAU;CACV,qDAAqD;AACtD;AAEA,sDAAsD;AACtD;CACC,6FAA6F;CAC7F,gBAAgB;AAkBjB;AAhBC;EACC;;;;;IAKE;EACF,kCAAkC;CACnC;AAGC;;GAEC,iDAAiD;EAClD;AAIF,mFAAmF;AACnF,0DAA0D;AAEzD;;EAEC,oDAAoD;CAQrD;AALE;;;;IAEC,iDAAiD;GAClD;AAKH;;CAEC;;;;yDAIwD;CACxD,0DAA0D;AAC3D;AClMA;;;EAGE;AAEF;CACC,uBAAuB;;CAEvB,uCAAuC;CACvC,iEAAiE;CACjE,8BAA8B;AAC/B;AAEA;CACC,0CAA0C;AAC3C;AAEA;CACC,6BAA6B;CAC7B,8BAA8B;CAC9B,wCAAwC;CACxC,6DAA6D;CAC7D,8CAA8C;AAqB/C;AAnBC;EACC,6BAA6B;EAC7B,8BAA8B;CAC/B;AAEA;EACC,6BAA6B;EAC7B,+BAA+B;CAChC;AAEA;EACC,gCAAgC;EAChC,+BAA+B;CAChC;AAEA;EACC,gCAAgC;EAChC,8BAA8B;CAC/B;AC1CD;;;EAGE;AAEF;CACC,yCAAyC;CACzC,yEAAyE;CACzE,+EAA+E;CAC/E,4FAA4F;CAC5F,yDAAyD;CACzD,wDAAwD;CACxD,0EAA0E;AAC3E;AAaC;;GAEE;AACF;EACC,+CAA+C;EAC/C,gDAAgD;EAChD,qDAAqD;EACrD,oBAAoB;EACpB,yMAAyM;;EAb1M,UAAU;;EACV,oBAAoB;CAgFpB;AAhEC;AATD;GAUE,gBAAgB;CA+DlB;EA9DC;AAEA;GACC,WAAW;GACX,WAAW;GACX,+BAA+B;GAC/B,8BAA8B;GAC9B,eAAe;EAoBhB;AAlBC;AAPD;IAQE,gBAAgB;EAiBlB;GAhBC;AAEA;IACC,oBAAoB;IACpB,oBAAoB;;IAEpB,UAAU;IACV,sDAAsD;IACtD,mBAAmB;IACnB,qBAAqB;IACrB,sBAAsB;GACvB;AAEA;IACC,mBAAmB;GACpB;AAGD;GACC;;KAEE;GACF,8DAA8D;;GAE9D;;KAEE;EAwBH;AAtBE;KACC,qDAAqD;IACtD;AAEA;KACC,yDAAyD;IAC1D;AAGD;AAnBD;IAoBE,eAAe;EAYjB;KATG;MACC,eAAe;KAChB;;KAEA;MACC,eAAe;KAChB;GAEF;AAIF;;GAEE;AAGD;GA7FD,UAAU;GACV,oBAAoB;EA8FnB;AAGD;;;GAGE;AACF;EACC,2DAA2D;CAC5D;AAEA;;;;GAIE;AACF;;EAEC,4DAA4D;CAQ7D;AANC;GACC,2DAA2D;GAC3D,4DAA4D;GAC5D,oBAAoB;GACpB,kFAAkF;EACnF;AAGD;;;GAGE;AACF;EACC,iBAAiB;CAClB;AAEA;;GAEE;AACF;EACC,oBAAoB;EACpB,WAAW;EACX,oFAAoF;;EAEpF;;;IAGE;EACF,wCAAwC;EACxC,qCAAqC;CACtC;AAEA;;;GAGE;AAED;;GAEC,0BAA0B;EAC3B;AAKA;;;;IAIE;AACF;GACC,kDAAkD;EACnD;AAEA;;;IAGE;AACF;GAxKD,UAAU;GACV,oBAAoB;EAyKnB;AAEA;;;IAGE;AAIA;KACC;IACD;AAIF;;;;IAIE;AACF;GACC;EACD;AAIF;;;;EAIE;AACF;CACC,cAAc;CACd,kBAAkB;AACnB;AAEA;;;;;EAKE;AAKC;IAxNF,UAAU;IACV,oBAAoB;GAyNlB;AAKH;;EAEE;AACF;CACC,sEAAsE;AAKvE;AAHC;EACC,qBAAqB;CACtB;AAGD;CACC;EACC,qBAAqB;CACtB;CACA;EACC,oBAAoB;CACrB;AACD;AAEA;CACC;EACC,oBAAoB;CACrB;CACA;EACC,oBAAoB;CACrB;AACD;AAEA;CACC;EACC,+HAA+H;CAChI;CACA;EACC,+HAA+H;CAChI;CACA;EACC,iIAAiI;CAClI;AACD;AAEA;CACC;EACC,UAAU;CACX;CACA;EACC,UAAU;CACX;CACA;EACC,UAAU;CACX;CACA;EACC,UAAU;CACX;CACA;EACC,UAAU;CACX;AACD;;AC7SA;;;EAGE;;AAEF;CACC,uCAAuC;CACvC,cAAc;CACd,kBAAkB;AACnB;;AAEA;CACC,uCAAuC;AACxC;;ACbA;;;EAGE;;AAEF;CACC,YAAY;CACZ,gBAAgB;;CAEhB,gEAAgE;CAChE,oBAAoB;CACpB,mBAAmB;;CAEnB,cAAc;CACd,eAAe;CACf,kBAAkB;CAClB,sCAAsC;AACvC;;AAEA;CACC,cAAc;CACd,uCAAuC;AACxC;;ACtBA;;;EAGE;;AAEF;CACC,wCAAwC;CACxC,yDAAyD;CACzD,0DAA0D;AAC3D;;AAIE;GACC,kBAAkB;EA2BnB;;AAzBC;IACC,WAAW;;IAEX,kBAAkB;IAClB,MAAM;IACN,OAAO;IACP,UAAU;;IAEV,YAAY;IACZ,WAAW;;IAEX;;;;;KAKC;IACD,0BAA0B;;IAE1B,2DAA2D;GAC5D;;AAEA;IACC,YAAY;GACb;;AAKH;CACC;EACC,2BAA2B;CAC5B;CACA;EACC,4BAA4B;CAC7B;AACD;;ACpDA;;;EAGE;;AAGD;;GAEE;;AACF;EACC,eAAe;EACf,kBAAkB;EAClB,oBAAoB;CAMrB;;AAJC;GACC,kBAAkB;GAClB,QAAQ;EACT;;AAGD;;GAEE;;AAED;GACC,aAAa;EACd;;AAEA;GACC,aAAa;EACd;;AAIF;CACC,kBAAkB;CAClB,oBAAoB;AACrB;;ACrCA;;;EAGE;;AAEF;CACC,YAAY;CACZ,wBAAwB;CACxB,iCAAiC;CACjC,iCAAiC;CACjC,kBAAkB;;CAElB,gDAAgD;CAChD,gBAAgB;CAChB,cAAc;;CAEd,WAAW;CACX,qBAAqB;;CAErB,yDAAyD;CACzD,kBAAkB;;CAElB,8DAA8D;CAC9D,gBAAgB;AAOjB;;AALC;EACC,iBAAiB;EACjB,UAAU;EACV,gBAAgB;CACjB;;AAGD;CACC,kBAAkB;AAMnB;;AAJC;EACC,4BAA4B;EAC5B,kBAAkB;CACnB;;ACtCD;;;EAGE;;AAEF;CACC;;oDAEmD;CACnD,kBAAkB;AAMnB;;AAJC;EACC,mEAAmE;EACnE,0BAA0B;CAC3B;;ACdD;;;EAGE;;AAEF;CACC,YAAY;CACZ,uDAAuD;AACxD;;ACRA;;;EAGE;;AAEF,gCAAgC;AAChC;;CAEC,kBAAkB;AAWnB;AATC;EACC,kBAAkB;EAClB,OAAO;EACP,QAAQ;EACR,+BAA+B;;EAE/B,gCAAgC;EAChC,oBAAoB;CACrB;;AAGD,iCAAiC;AAEhC;EACC,aAAa;CACd;;AAGD;;;;EAIE;AACF;CACC,kBAAkB;AACnB;;ACnCA;;;EAGE;;AAEF,iFAAiF;AACjF;CACC,aAAa;AACd;;ACRA;;;EAGE;;AAEF;CACC,gDAAgD;CAChD,2BAA2B;AAC5B;;AAEA;CACC,8BAA8B;AAC/B;;ACZA;;;EAGE;;AAEF;CACC,eAAe;AAUhB;;AARC;EACC,aAAa;;EAEb,2BAA2B;CAI5B;;AAHC;GACC,kBAAkB;EACnB;;ACdF;;;EAGE;;AAEF,qHAAqH;;AAErH;uDACuD;AAEtD;EACC,eAAe;CAChB;AAEA;EACC,gBAAgB;CACjB;AAEA;EACC,gBAAgB;CACjB;AAEA;EACC,gBAAgB;CACjB;;ACxBD;;;EAGE;;AAEF;CACC,eAAe;AAChB;;AAEA;CACC,eAAe;AAChB;;AAEA;CACC,eAAe;AAChB;;AAEA;CACC,iBAAiB;AAClB;;ACnBA;;;EAGE;;AAEF;CACC,+CAA+C;CAC/C,+CAA+C;CAC/C,8CAA8C;CAC9C,8CAA8C;CAC9C,wCAAwC;CACxC,6CAA6C;AAC9C;;AAGC;EACC,mDAAmD;CACpD;AAFA;EACC,kDAAmD;CACpD;AAFA;EACC,iDAAmD;CACpD;AAFA;EACC,iDAAmD;CACpD;;AAIA;EACC,kCAAqC;;EAErC,8EAA8E;EAC9E,6BAA6B;CAC9B;AALA;EACC,oCAAqC;;EAErC,8EAA8E;EAC9E,6BAA6B;CAC9B;;AC1BD;;;EAGE;;;AAGF;CACC,gFAAgF;CAChF,kBAAkB;AACnB;;AAEA;CACC,cAAc;CACd,WAAW;CACX,2BAA2B;CAC3B,SAAS;AACV;;AChBA;;;EAGE;;AAEF,2BAA2B;AAC3B;CACC,6BAA6B;CAC7B;wFACuF;CACvF,kBAAkB;CAClB,kBAAkB;CAClB,kBAAkB;;CAElB;iHACgH;CAChH,eAAe;;CAEf,yDAAyD;CACzD,kBAAkB;;CAElB,gGAAgG;AA8CjG;AA5CC;EACC,kBAAkB;;EAElB,oDAAoD;EACpD,UAAU;CACX;AAEA,iGAAiG;AAEjG,oCAAoC;AACpC;EACC,kBAAkB;EAClB,aAAa;EACb,sBAAsB;CACvB;AAEA;EACC,kBAAkB;EAClB,gBAAgB;EAChB,aAAa;CACd;AAEA;EACC,WAAW;EACX,kBAAkB;EAClB,YAAY;;EAEZ,0FAA0F;EAC1F,cAAc;EACd,yBAAyB;EACzB,mBAAmB;CACpB;AAEA;EACC,kBAAkB;EAClB,OAAO;EACP,MAAM;EACN,QAAQ;EACR,SAAS;;EAET,aAAa;EACb,mBAAmB;EACnB,uBAAuB;CACxB;;AClED;;;EAGE;;AAEF;CACC,mDAAmD;AACpD;;AAEA;CACC,mCAAmC;CACnC,iDAAiD;CACjD,gCAAgC;CAChC,0BAA0B;CAC1B,qEAAqE;CACrE,kDAAkD;AA+BnD;;AA7BC;EACC,yGAAyG;CAC1G;;AAEA;EACC,mBAAmB;EACnB,kBAAkB;EAClB,kBAAkB;EAClB,2CAA2C;EAC3C,MAAM;EACN,gCAAgC;EAChC,4BAA4B;EAC5B,2GAA2G;EAC3G,0IAA0I;EAC1I,kEAAkE;EAClE,sCAAsC;EACtC,mCAAmC;EACnC,gCAAgC;CACjC;;AAEA,0BAA0B;;AAC1B;EACC,iBAAiB;CAClB;;AAEA;EACC,gDAAgD;EAChD,oBAAoB;CACrB;;AAGD;CACC,gBAAgB;AACjB;;AAEA;CACC,qBAAqB;AACtB;;;ACtDA;;;EAGE;;AlGHF;;;EAGE;;AkGIF;CACC,oDAAoD;CACpD,8CAA8C;CAC9C,oEAAoE;AACrE;;AAEA,mBAAmB;AACnB;CACC,sBAAsB;CACtB,oBAAoB;CACpB,sBAAsB;CACtB,yCAAyC;CACzC,0DAA0D;CAC1D,aAAa;CACb,gBAAgB;CAChB,oBAAoB;;CAEpB,+GAA+G;AAKhH;AAJC;AAXD;EAYE,uBAAuB;EACvB,YAAY;AAEd;CADC;;AAGD,mBAAmB;AlGjBlB;EACC;EkGmBA,kDAAkD;ElGjBlD;CACD;AkGmBA;AALD;EAME,eAAe;AAEjB;CADC;;AAGD;CACC;EACC,sEAAsE;CACvE;;CAEA;EACC,0DAA0D;CAC3D;AACD;;AClDA;;;EAGE;;AAEF;CACC,YAAY;CACZ,0DAA0D;AAM3D;;AAJC;EACC,aAAa;EACb,qCAAqC;CACtC;;ACZD;;;EAGE;;AAEF,yFAAyF;AACzF;CACC,YAAY;AACb;;AAEA;CACC,eAAe;CACf;;;;EAIC;CACD,cAAc;CACd,sBAAsB;AAWvB;;AATC;EACC,qFAAqF;EACrF,WAAW;CACZ;;AAEA;EACC,gFAAgF;EAChF,cAAc;CACf;;AAIA;yDACwD;;AAGvD;GACC,eAAe;EAChB;;AAIF;CACC,wCAAwC;AACzC;;AAEA;CACC,uCAAuC;AACxC;;AAEA;CACC,UAAU;AACX;;ACpDA;;;EAGE;;AlGHF;;;EAGE;;AkGIF;CACC,aAAa;CACb,mBAAmB;CACnB,iBAAiB;CACjB,uBAAuB;AAqBxB;;AAnBC;EACC,qBAAqB;CACtB;;AAEA;EACC,aAAa;CACd;;AlGbA;;AkGCD;EAeE,eAAe;AAUjB;;EARE;GACC,gBAAgB;EACjB;;EAEA;GACC,eAAe;EAChB;ClGtBD;;AmGRD;;;EAGE;;AAEF;CACC,+BAA+B;CAC/B,wEAAwE;AACzE;;AAGC,4DAA4D;;AAE3D;;yDAEuD;;AACvD;;GAEC,qDAAqD;EACtD;;AAEA;gFAC8E;;AAC9E;;GAEC,WAAW;EACZ;;AAEA;GACC,YAAY;GACZ,0CAA0C;GAC1C,cAAc;EACf;;AAEA;GACC,WAAW;GACX,2CAA2C;EAC5C;;AAEA;GACC,YAAY;GACZ,0CAA0C;EAC3C;;AAEA;GACC,eAAe;GACf,iBAAiB;EAClB;;AAEA;GACC,cAAc;GACd,kBAAkB;EACnB;;AAGD;EACC,iBAAiB;EACjB,kBAAkB;CACnB;;AAEA;EACC,WAAW;EACX,2CAA2C;CAC5C;;AAEA;EACC,YAAY;EACZ,0CAA0C;CAC3C;;AAEA,6GAA6G;;AAC7G;;;EAGC,aAAa;CACd;;AAGC;;GAEC,gDAAgD;GAChD,mDAAmD;EACpD;;AAEA;GACC,kDAAkD;EACnD;;AAEA;GACC,iDAAiD;EAClD;;AAKD;yDACwD;;AAItD;;;;;;IAGC,sDAAsD;GAKvD;;AAHC;KACC,aAAa;IACd;;AAKD;;;IAGC,4DAA4D;GAC7D;;ACpHH;;;EAGE;;ApGHF;;;EAGE;;AoGIF;CACC,aAAa;CACb,mBAAmB;CACnB,iBAAiB;AAqBlB;;AAnBC;EACC,qBAAqB;CACtB;;AAEA;EACC,aAAa;CACd;;ApGZA;;AoGCD;EAcE,eAAe;AAUjB;;EARE;GACC,gBAAgB;EACjB;;EAEA;GACC,eAAe;EAChB;CpGrBD;;AqGRD;;;EAGE;;AAGD;;EAEC,kBAAkB;CACnB;;AAEA,yBAAyB;;AACzB;;EAEC,kBAAkB;EAClB,MAAM;EACN,OAAO;CACR;;ACjBD;;;EAGE;;AAEF;CACC,cAAc;CACd,kBAAkB;;CAElB;;;GAGE;CACF,sCAAsC;CACtC,wCAAwC;CACxC,kBAAkB;CAClB,UAAU;AAMX;;AAJC;EACC,WAAW;EACX,kBAAkB;CACnB;;ACrBD;;;EAGE;;AAEF;CACC,kBAAkB;CAClB,aAAa;CACb,mBAAmB;CACnB,uBAAuB;CACvB,MAAM;CACN,OAAO;AAMR;;AAJC;EACC,WAAW;EACX,kBAAkB;CACnB;;AChBD;;;EAGE;;AAGD;EACC,cAAc;EACd,WAAW;EACX,kBAAkB;;EAElB,8FAA8F;EAC9F;0FACwF;EACxF,kBAAkB;;EAElB,+GAA+G;EAC/G,eAAe;CAmBhB;;AAjBC;GACC,iEAAiE;GACjE,cAAc;;GAEd,uEAAuE;GACvE,cAAc;;GAEd,mGAAmG;GACnG,eAAe;;GAEf,6HAA6H;GAC7H,eAAe;;GAEf;4DACyD;GACzD,YAAY;EACb;;AAGD;EACC;;;;IAIE;EACF,oBAAoB;;EAEpB,wFAAwF;EACxF,eAAe;;EAEf,+GAA+G;EAC/G,uBAAuB;;EAEvB,+FAA+F;CAehG;;AAdC;GACC,aAAa;EACd;;AAEA,mEAAmE;;AACnE;;GAEC,mGAAmG;GACnG,YAAY;GACZ,cAAc;;GAEd,wFAAwF;GACxF,eAAe;EAChB;;AAKD;;;;GAIE;;AACF;EACC,qBAAqB;EACrB,sBAAsB;;EAEtB;;;IAGE;EACF,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;CACxB;;AAEA;;GAEE;;AACF;EACC,UAAU;;EAEV;;;IAGE;CAIH;;AAHC;GACC,UAAU;EACX;;AAGD;;GAEE;;AACF;EACC,UAAU;;EAEV;;;IAGE;CAaH;;AAZC;GACC,UAAU;;GAEV;;;;KAIE;EAIH;;AAHC;IACC,aAAa;GACd;;AAIF;0DACyD;;AACzD;EACC,YAAY;CACb;;AAEA;yDACwD;;AAGvD;GACC,eAAe;EAChB;;AC5IF;;;EAGE;;AAGD;EACC,0BAA0B;CAC3B;;ACRD;;;EAGE;;AAGD,2BAA2B;;AAG1B;GACC,cAAc;GACd,kBAAkB;EACnB;;;ACZF;;;EAGE;;A3GHF;;;EAGE;;A2GIF;CACC,aAAa;CACb,mBAAmB;CACnB,iBAAiB;AAqBlB;;AAnBC;EACC,qBAAqB;CAKtB;;AAHC;GACC,gBAAgB;EACjB;;A3GXD;;A2GCD;EAcE,eAAe;AAUjB;;EARE;GACC,gBAAgB;EACjB;;EAEA;GACC,eAAe;EAChB;C3GrBD;;A4GRD;;;EAGE;;A5GHF;;;EAGE;;A4GIF;CACC,aAAa;CACb,uBAAuB;AAiBxB;;AAfC;EACC,aAAa;CACd;;A5GPA;;A4GCD;EASE,eAAe;AAUjB;;EARE;GACC,gBAAgB;EACjB;;EAEA;GACC,eAAe;EAChB;C5GhBD;;A4GoBD;;;EAGE;AACF;CACC,cAAc;;CAEd;;;GAGE;AAOH;AALE;;GAEC,oCAAoC;EACrC;;AC3CF;;;EAGE;;AAEF;CACC,cAAc;AACf;;ACPA;;;EAGE;;AAEF;CACC,aAAa;AACd;;ACPA;;;EAGE;;AAEF;CACC,wBAAwB;AAiBzB;;AAfC;EACC,4BAA4B;CAa7B;;AAXC;GACC,4BAA4B;EAS7B;;AAPC;IACC,4BAA4B;GAK7B;;AAHC;KACC,4BAA4B;IAC7B;;AAMJ;CACC,qBAAqB;AAatB;;AAXC;EACC,uBAAuB;CASxB;;AAPC;GACC,uBAAuB;EAKxB;;AAHC;IACC,uBAAuB;GACxB;;ACpCH;;;EAGE;;AAEF;CACC,mCAAmC;AACpC;;AAyEA;;EAEE;AACF;CACC,gBAAgB;AAwBjB;AAtBC;EACC,kBAAkB;EAClB,kBAAkB;CAKnB;AAHC;GACC,eAAe;EAChB;AAIA;GAtFD,wBAAwB;GACxB,qBAAqB;GACrB,kBAAkB;GAClB,yCAAyC;GACzC,0CAA0C;GAC1C,sBAAsB;GAEtB,kBAAkB;GAClB,SAAS;GAET,eAAe;GACf,WAAW;GACX,mBAAmB;GACnB,QAAQ;GACR,cAAc;GAEd,eAAe;EAwEd;AAFA;EApEA,OAAO;EACP,eAAe;EACf,YAAY;EACZ,kBAAkB;EAmElB;AAhED;EACC,cAAc;EACd,kBAAkB;EAClB,sBAAsB;EACtB,WAAW;EACX,WAAW;EACX,YAAY;EACZ,iCAAiC;EACjC,kBAAkB;EAClB,wCAAwC;CAKzC;AAHC;AAXD;GAYE,gBAAgB;CAElB;EADC;AAGD;EACC,cAAc;EACd,kBAAkB;EAClB,uBAAuB;EACvB,oBAAoB;EACpB,WAAW;;EAEX,uFAAuF;EACvF,oDAAoD;EACpD,qDAAqD;EACrD,uDAAuD;EACvD,wDAAwD;EACxD,mBAAmB;EACnB,yBAAyB;EACzB,+GAA+G;EAC/G,wBAAwB;CACzB;AAGC;GACC,8BAA8B;GAC9B,gCAAgC;EACjC;AAEA;GACC,8BAA8B;EAC/B;AAwBA;GACC,sBAAsB;EACvB;AAEA;GACC,kBAAkB;EACnB;;AAIF;;EAEE;AAED;;;GAGE;AACF;;EAEC,eAAe;CAKhB;AAHC;GACC,0CAA0C;EAC3C;AAGD;;GAEE;AACF;EAxHA,wBAAwB;EACxB,qBAAqB;EACrB,kBAAkB;EAClB,yCAAyC;EACzC,0CAA0C;EAC1C,sBAAsB;EAEtB,kBAAkB;EAClB,SAAS;EAET,eAAe;EACf,WAAW;EACX,mBAAmB;EACnB,QAAQ;EACR,cAAc;EAEd,eAAe;CA0Gf;AAFA;EAtGC,OAAO;EACP,eAAe;EACf,YAAY;EACZ,kBAAkB;CAqGnB;AAlGA;EACC,cAAc;EACd,kBAAkB;EAClB,sBAAsB;EACtB,WAAW;EACX,WAAW;EACX,YAAY;EACZ,iCAAiC;EACjC,kBAAkB;EAClB,wCAAwC;CAKzC;AAHC;AAXD;GAYE,gBAAgB;CAElB;EADC;AAGD;EACC,cAAc;EACd,kBAAkB;EAClB,uBAAuB;EACvB,oBAAoB;EACpB,WAAW;;EAEX,uFAAuF;EACvF,oDAAoD;EACpD,qDAAqD;EACrD,uDAAuD;EACvD,wDAAwD;EACxD,mBAAmB;EACnB,yBAAyB;EACzB,+GAA+G;EAC/G,wBAAwB;CACzB;AAGC;GACC,8BAA8B;GAC9B,gCAAgC;EACjC;AAEA;GACC,8BAA8B;EAC/B;AA2DA;GACC,kBAAkB;EACnB;;ACzIF;;;EAGE;;AAEF;CACC;8DAC6D;CAC7D,WAAW;;CAEX,qEAAqE;CACrE;wFACuF;CACvF,eAAe;;CAEf;0DACyD;CACzD,cAAc;;CAEd;mEACkE;CAClE,eAAe;AAChB;;ACtBA;;;EAGE;;AAGD;EACC,aAAa;EACb,sBAAsB;EACtB,mBAAmB;CAapB;;AAXC;GACC,qEAAqE;GACrE,eAAe;;GAEf,kBAAkB;EAMnB;;AAJC;IACC,gBAAgB;IAChB,cAAc;GACf;;AAWD;GACC,aAAa;EACd;;AAIF;gEACgE;AAChE;CACC,oBAAoB;AACrB;;AAEA;gEACgE;AAChE;CACC,oBAAoB;AACrB;;AC/CA;;;EAGE;;AnHHF;;;EAGE;;AmHKD;EACC,WAAW;EACX,QAAQ;EACR,kBAAkB;EAClB,WAAW;EACX,SAAS;EACT,YAAY;EACZ,UAAU;CACX;;AAEA;EACC,aAAa;CACd;;AnHdA;GmHoBE;IACC,WAAW;IACX,QAAQ;IACR,kBAAkB;IAClB,WAAW;IACX,SAAS;IACT,YAAY;IACZ,UAAU;GACX;;GAEA;IACC,aAAa;GACd;CnH9BF;;AoHRD;;;EAGE;;ApHHF;;;EAGE;;AoHIF;CACC,aAAa;CACb,uBAAuB;CACvB,mBAAmB;CACnB,iBAAiB;CACjB,YAAY;AA0Bb;;AAxBC;EACC,qBAAqB;EACrB,WAAW;CACZ;;AAEA;EACC,aAAa;CACd;;AAEA;EACC,WAAW;CACZ;;ApHnBA;;AoHCD;EAqBE,eAAe;AAUjB;;EARE;GACC,gBAAgB;EACjB;;EAEA;GACC,eAAe;EAChB;CpH5BD;;AqHRD;;;EAGE;;AAEF;CACC,mCAAmC;AACpC;;AAEA;CACC,6CAA6C;;CAE7C,gBAAgB;;CAEhB;0DACyD;CACzD,kBAAkB;;CAElB,4BAA4B;;CAE5B;0DACyD;AAK1D;;AAJC;EACC,gBAAgB;EAChB,cAAc;CACf;;ACzBD;;;EAGE;;AAEF;CACC,mDAAmD;CACnD,mDAAmD;CACnD,uDAAuD;CACvD,qDAAqD;AACtD;;AAEA;CACC,kBAAkB;CAClB,iBAAiB;CACjB,2CAA2C;AA+D5C;;AA7DC;;EAEC,WAAW;EACX,YAAY;CACb;;AAEA;EACC,SAAS;EACT,oBAAoB;EACpB,kBAAkB;EAClB,yDAAyD;EACzD,2DAA2D;EAC3D,SAAS;CACV;;AAEA;EACC,kBAAkB;EAClB,WAAW;EACX,MAAM;EACN,kEAAkE;EAClE,UAAU;EACV,wCAAwC;CAuCzC;;AApCC;;AATD;GAUE,gBAAgB;CAmClB;EAlCC;;AAEA;GACC,iEAAiE;EAClE;;AAEA;;GAEC,iEAAiE;EAKlE;;AAHC;IACC,UAAU;GACX;;AAGD;GACC,gCAAgC;GAChC,kBAAkB;GAClB,QAAQ;GACR,UAAU;GACV,uDAAuD;GACvD,sCAAsC;GACtC,iDAAiD;GACjD,gBAAgB;GAChB,eAAe;GACf,kBAAkB;GAClB,UAAU;GACV,qCAAqC;EAMtC;;AAHC;;AAfD;IAgBE,gBAAgB;EAElB;GADC;;;AC3EH;;;EAGE;;AAEF;CACC,kBAAkB;CAClB,WAAW;CACX,cAAc;CACd,aAAa;CACb,mBAAmB;CACnB,uBAAuB;AAQxB;;AANC;EACC,WAAW;EACX,kBAAkB;EAClB,yCAAyC;EACzC,WAAW;CACZ;;AAGD;CACC,kBAAkB;CAClB,UAAU;CACV,kBAAkB;CAClB,cAAc;CACd,yBAAyB;CACzB,iCAAiC;CACjC,kBAAkB;CAClB,0DAA0D;CAC1D,iBAAiB;CACjB,iBAAiB;CACjB,sBAAsB;CACtB,4BAA4B;CAC5B,6CAA6C;;CAE7C,kEAAkE;CAClE,yBAAyB;CACzB,sBAAsB;CACtB,qBAAqB;CACrB,iBAAiB;AAClB;;AAEA,wEAAwE;AACxE;CACC;EACC,UAAU;CAKX;;EAHC;GACC,aAAa;EACd;;CAGD;;;;;GAKE;CACF;EACC,gBAAgB;CACjB;AACD;;AC9DA;;;EAGE;;AhIHF;;;EAGE;;AgIIF;CACC,8CAA8C;AAC/C;;AAsCC;EAzBA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAuBpD;;AAtBA;EAfA,yDAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,yiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAWA;EAnCA,yDAAsf;EACtf,4BAA4B;CAoC5B;;AAFA;EA9BA,yiBAAyiB;EACziB,yCAAyC;CA+BzC;;AAEA;EA7BA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA2BpD;;AA1BA;EAfA,yDAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,uiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAeA;EAvCA,yDAAsf;EACtf,4BAA4B;CAwC5B;;AAFA;EAlCA,uiBAAyiB;EACziB,yCAAyC;CAmCzC;;AAEA;EAjCA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA+BpD;;AA9BA;EAfA,yDAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,4iBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAmBA;EA3CA,yDAAsf;EACtf,4BAA4B;CA4C5B;;AAFA;EAtCA,4iBAAyiB;EACziB,yCAAyC;CAuCzC;;AAEA;EArCA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAmCpD;;AAlCA;EAfA,yDAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,yiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAuBA;EA/CA,yDAAsf;EACtf,4BAA4B;CAgD5B;;AAFA;EA1CA,yiBAAyiB;EACziB,yCAAyC;CA2CzC;;AAEA;EAzCA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAuCpD;;AAtCA;EAfA,yDAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,qiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA2BA;EAnDA,yDAAsf;EACtf,4BAA4B;CAoD5B;;AAFA;EA9CA,qiBAAyiB;EACziB,yCAAyC;CA+CzC;;AAEA;EA7CA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA2CpD;;AA1CA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,wiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA+BA;EAvDA,0DAAsf;EACtf,4BAA4B;CAwD5B;;AAFA;EAlDA,wiBAAyiB;EACziB,yCAAyC;CAmDzC;;AAEA;EAjDA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA+CpD;;AA9CA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAmCA;EA3DA,0DAAsf;EACtf,4BAA4B;CA4D5B;;AAFA;EAtDA,oiBAAyiB;EACziB,yCAAyC;CAuDzC;;AAEA;EArDA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAmDpD;;AAlDA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAuCA;EA/DA,0DAAsf;EACtf,4BAA4B;CAgE5B;;AAFA;EA1DA,oiBAAyiB;EACziB,yCAAyC;CA2DzC;;AAEA;EAzDA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAuDpD;;AAtDA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA2CA;EAnEA,0DAAsf;EACtf,4BAA4B;CAoE5B;;AAFA;EA9DA,oiBAAyiB;EACziB,yCAAyC;CA+DzC;;AAEA;EA7DA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA2DpD;;AA1DA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA+CA;EAvEA,0DAAsf;EACtf,4BAA4B;CAwE5B;;AAFA;EAlEA,oiBAAyiB;EACziB,yCAAyC;CAmEzC;;AAEA;EAjEA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA+DpD;;AA9DA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAmDA;EA3EA,0DAAsf;EACtf,4BAA4B;CA4E5B;;AAFA;EAtEA,oiBAAyiB;EACziB,yCAAyC;CAuEzC;;AAEA;EArEA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAmEpD;;AAlEA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAuDA;EA/EA,0DAAsf;EACtf,4BAA4B;CAgF5B;;AAFA;EA1EA,oiBAAyiB;EACziB,yCAAyC;CA2EzC;;AAEA;EAzEA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAuEpD;;AAtEA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,wiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA2DA;EAnFA,0DAAsf;EACtf,4BAA4B;CAoF5B;;AAFA;EA9EA,wiBAAyiB;EACziB,yCAAyC;CA+EzC;;AAEA;EA7EA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA2EpD;;AA1EA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,siBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA+DA;EAvFA,0DAAsf;EACtf,4BAA4B;CAwF5B;;AAFA;EAlFA,siBAAyiB;EACziB,yCAAyC;CAmFzC;;AAEA;EAjFA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA+EpD;;AA9EA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,qiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAmEA;EA3FA,0DAAsf;EACtf,4BAA4B;CA4F5B;;AAFA;EAtFA,qiBAAyiB;EACziB,yCAAyC;CAuFzC;;AAEA;EArFA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAmFpD;;AAlFA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,qiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAuEA;EA/FA,0DAAsf;EACtf,4BAA4B;CAgG5B;;AAFA;EA1FA,qiBAAyiB;EACziB,yCAAyC;CA2FzC;;AAEA;EAzFA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAuFpD;;AAtFA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA2EA;EAnGA,0DAAsf;EACtf,4BAA4B;CAoG5B;;AAFA;EA9FA,oiBAAyiB;EACziB,yCAAyC;CA+FzC;;AAEA;EA7FA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA2FpD;;AA1FA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,oiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA+EA;EAvGA,0DAAsf;EACtf,4BAA4B;CAwG5B;;AAFA;EAlGA,oiBAAyiB;EACziB,yCAAyC;CAmGzC;;AAEA;EAjGA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CA+FpD;;AA9FA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,miBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAmFA;EA3GA,0DAAsf;EACtf,4BAA4B;CA4G5B;;AAFA;EAtGA,miBAAyiB;EACziB,yCAAyC;CAuGzC;;AAEA;EArGA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAmGpD;;AAlGA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,yiBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AAuFA;EA/GA,0DAAsf;EACtf,4BAA4B;CAgH5B;;AAFA;EA1GA,yiBAAyiB;EACziB,yCAAyC;CA2GzC;;AAEA;EAzGA,4BAA4B;EAC5B,iBAAiB;EAEjB;qDACoD;CAuGpD;;AAtGA;EAfA,0DAAsf;EACtf,4BAA4B;CAgB5B;;AACA;EAbA,4iBAAyiB;EACziB,yCAAyC;CAczC;;AAEA;EACC,sDAAsD;CACvD;;AA2FA;EAnHA,0DAAsf;EACtf,4BAA4B;CAoH5B;;AAFA;EA9GA,4iBAAyiB;EACziB,yCAAyC;CA+GzC;;ACjID;;;EAGE;;AzIHF;;;EAGE;;AAEF;;;;EAIE;A0ITF;;;EAGE;AAEF;;EAEE;AzIPF;;;EAGE;AAEF;;EAEE;AAKF;;EAEE;;AwILF;CACC,kBAAkB;CAClB,gBAAgB;AACjB;;AAEA;;CAEC,gCAAgC;CAChC,SAAS;CACT,6BAA6B;CAC7B,uCAAuC;CACvC,qCAAqC;CACrC,sBAAsB;CACtB,qBAAqB;AACtB;;AAEA;CACC,6BAA6B;CAC7B,kBAAkB;CAClB,cAAc;AACf;;AAEA;CACC,kBAAkB;CAClB,WAAW;CACX,YAAY;CACZ,YAAY;CACZ,aAAa;CACb,gBAAgB;CAChB,sBAAsB;;CAEtB,yCAAyC;;CzI7BzC,gBAAgB;AyIwCjB;;AApBA;EzIhBE,sCAAsC;EyI4BtC,yBAAyB;EACzB,0BAA0B;AAO5B;;AAJC;ECtCA,4BAA4B;EAC5B,aAAa;EACb,4BAA2B;EzIF3B,uCAA8B;CwIyC9B;;AElDD;;;EAGE;;AAEF;CACC,eAAe;AAKhB;;AAHC;EACC,aAAa;CACd;;ACVD;;;EAGE;;AAEF;CACC,aAAa;CACb,8BAA8B;AAC/B;;ACRA;;;EAGE;;AAEF;;;;EAIE;;A7HTF;;;EAGE;;A6HWD;EACC,YAAY;EACZ,eAAe;EACf,YAAY;;EAEZ,aAAa;EACb,oBAAoB;EACpB,iBAAiB;EACjB,0BAA0B;EAC1B,iCAAiC;CAkElC;;AAhEC;GACC,wBAAwB;GACxB,yDAAyD;EAoD1D;;AAlDC;IACC,uCAAuC;IACvC,WAAW;GAgCZ;;AA9BC;KACC,sCAAsC;KACtC,sCAAsC;KACtC,yDAAyD;KACzD,qDAAqD;KACrD,kBAAkB;;KASlB,kEAAkE;;KAPlE,0CAA0C;IAY3C;;AAXC;MACC,4EAA4E;MAC5E,mJAAmJ;MACnJ,mBAAmB;KACpB;;AAIA;;AAhBD;MAiBE,eAAe;IAEjB;KADC;;AAGD,4FAA4F;;AAC5F;KACC,aAAa;IACd;;AAEA;KACC,mCAAmC;KACnC,kBAAkB;IACnB;;AAGD;IACC,cAAc;IACd,WAAW;GAWZ;;AARE;MACC,6CAA6C;KAC9C;;AAEA;MACC,WAAW;KACZ;;AAKH;GACC,wBAAwB;GACxB,iBAAiB;EAClB;;AAEA;GACC,wBAAwB;EACzB;;ACxFF;;;EAGE;;AAEF;CACC,2BAA2B;AAC5B;;AAEA;CACC,aAAa;CACb,iEAAiE;CACjE,sBAAsB;AAgBvB;;AAdC;EACC,aAAa;EACb,8BAA8B;EAC9B,sBAAsB;CAUvB;;AARC;GACC,aAAa;GACb,qBAAqB;GACrB,2BAA2B;GAC3B,mBAAmB;GACnB,YAAY;GACZ,gBAAgB;EACjB;;AC1BF;;;EAGE;;AAEF;CACC,8DAA8D;CAC9D;wFACuF;CACvF,kBAAkB;CAClB,cAAc;AAgCf;;AA9BC;EACC,+CAA+C;EAC/C,yBAAyB;EACzB,iBAAiB;;EAEjB;gGAC8F;EAC9F,WAAW;EACX,YAAY;;EAEZ;mEACiE;EACjE,kCAAkC;CAiBnC;;AAfC;;GAEC,cAAc;GACd,aAAa;;GAEb;;kFAE+E;GAC/E,iCAAiC;EAClC;;AAEA;GACC,iBAAiB;GACjB,+BAA+B;EAChC;;AAIF;;;;;;;;;;EAUE;AACF;CACC;EACC,eAAe;CAChB;AACD;;AAEA;qGACqG;AACrG;CACC,iBAAiB;AAClB;;AAEA;CACC,gBAAgB;AACjB;;AAEA;CACC;;;GAGE;CACF,qBAAqB;;CAErB;;;GAGE;CACF,WAAW;AACZ;;ACnFA;;;EAGE;;AAEF;CACC,aAAa;CACb,mBAAmB;CACnB,eAAe;AAChB;;ACTA;;;EAGE;;AAEF;CACC,aAAa;CACb,mBAAmB;CACnB,iBAAiB;CACjB,8BAA8B;;CAE9B,gDAAgD;AAWjD;;AAVC;EACC,YAAY;CACb;;AAGC;;GAEC,uBAAuB;EACxB;;ACpBF;;;EAGE;;AAIA;GACC,eAAe;EAiBhB;;AAdE;KACC,0DAA0D;KAC1D,eAAe;IAChB;;AAEA;KACC,0DAA0D;KAC1D,eAAe;IAChB;;AAEA;KACC,YAAY;IACb;;ACvBJ;;;EAGE;;AAEF;CACC,WAAW;CACX,aAAa;CACb,2BAA2B;AA8B5B;;AA5BC;EACC,eAAe;EACf,YAAY;CACb;;AAEA;EACC,eAAe;;EAEf,4DAA4D;CAI7D;;AAHC;GACC,aAAa;EACd;;AAGD;EACC,mEAAmE;EACnE,aAAa;CAWd;;AATC;GACC,kBAAkB;GAClB,gBAAgB;EAMjB;;AAJC;IACC,kBAAkB;IAClB,cAAc;GACf;;ACnCH;;;EAGE;;AAIA;GACC,eAAe;EAChB;;AAEA;GACC,eAAe;EAChB;;AAEA;GACC,eAAe;GACf,mBAAmB;EAepB;;AAbC;IACC,aAAa;IACb,8BAA8B;IAC9B,mBAAmB;GAKpB;;AAHC;KACC,YAAY;IACb;;AAGD;IACC,YAAY;GACb;;AAIF;EACC,+DAA+D;EAC/D,kBAAkB;CAoBnB;;AAlBC;GACC,kBAAkB;GAClB,SAAS;GACT,gEAAgE;GAChE,+BAA+B;;GAE/B,sEAAsE;GACtE,UAAU;;GAEV,0CAA0C;EAQ3C;;AAPC;IACC,WAAW;IACX,kBAAkB;IAClB,6DAA6D;IAC7D,SAAS;IACT,6BAA6B;GAC9B;;ACvDH;;;EAGE;;AAIA;GACC,eAAe;GACf,aAAa;GACb,uBAAuB;EAKxB;;AAHC;IACC,iBAAiB;GAClB;;ACdH;;;EAGE;;AzIHF;;;EAGE;;AyIIF;CACC,uDAAuD;CACvD,iDAAiD;CACjD,uEAAuE;AACxE;;AAEA,mBAAmB;AACnB;CACC,sBAAsB;CACtB,iBAAiB;CACjB,sBAAsB;CACtB,kBAAkB;CAClB,4CAA4C;CAC5C,6DAA6D;CAC7D,aAAa;CACb,gBAAgB;CAChB,oBAAoB;;CAEpB,+GAA+G;AAKhH;AzIxBC;EACC;EyIoBA,uBAAuB;EACvB,YAAY;EzInBZ;CACD;;AyIsBD,mBAAmB;AzIlBlB;EyIqBC;GACC,kDAAkD;EACnD;CzInBD;AyIsBA;EACC,qBAAqB;EACrB,sBAAsB;;EAEtB;;;IAGE;EACF,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;CACxB;;AAGD;CACC;EACC,yEAAyE;CAC1E;;CAEA;EACC,6DAA6D;CAC9D;AACD;;AC9DA;;;EAGE;;AAEF;CACC,qEAAqE;CACrE,oCAAoC;;CAEpC;0HACyH;CACzH,oGAAoG;AACrG;;AAEA;CACC,mBAAmB;AACpB;;AAEA;CACC,gBAAgB;AACjB;;AAEA;;CAEC;8EAC6E;CAC7E,yBAAyB;CACzB,kBAAkB;AACnB;;AAEA;CACC,kBAAkB;CAClB,MAAM;CACN,SAAS;CACT,qDAAqD;CACrD,2CAA2C;CAC3C,kBAAkB;CAClB,iBAAiB;CACjB,4BAA4B;AAC7B;;AAEA;CACC,aAAa;AACd;;AAEA;4DAC4D;AAC5D;CACC,aAAa;AACd;;AAEA;;CAEC,+DAA+D;CAC/D,aAAa;CACb;;;4CAG2C;CAC3C,cAAc;CACd,iBAAiB;AAClB;;AAEA;CACC,oDAAoD;CACpD,YAAY;AACb;;AClEA;;;EAGE;;ACHF;;;EAGE;;AAEF;;EAEE;;AACF;CACC;uEACsE;CACtE,wBAAwB;AACzB;ACZA;;;EAGE;AAEF;CACC,iBAAiB;CACjB,+CAA+C;CAC/C,mBAAmB;AACpB;ACTA;;;EAGE;AAEF;;EAEE;AACF;;CAEC,2BAA2B;AAC5B;ACXA;;;EAGE;AAEF;CACC,iCAAiC;CACjC,qCAAqC;CACrC,uCAAuC;CACvC,2CAA2C;CAC3C,sDAAsD;CACtD,4CAA4C;CAC5C,0DAA0D;AAC3D;AAEA;CACC,sDAAsD;;CAEtD,gBAAgB;CAChB,2CAA2C;CAC3C,iBAAiB;CACjB,sCAAsC;AAiDvC;AA/CC;EACC,6CAA6C;CAoC9C;AAlCC;GACC,eAAe;GACf,aAAa;GACb,mBAAmB;GACnB,YAAY;GACZ,sBAAsB;GACtB,6CAA6C;GAC7C,sFAAsF;EACvF;AAEA;GACC,gBAAgB;GAChB,qBAAqB;GACrB,iBAAiB;GACjB,yBAAyB;GACzB,iBAAiB;GACjB,iBAAiB;GACjB,eAAe;GACf,mBAAmB;GACnB,sCAAsC;;EAEvC;AAEA;GACC,cAAc;GACd,eAAe;EAChB;AAGC;IACC,qBAAqB;IACrB,UAAU;GACX;AAIF;EACC,yBAAyB;CAC1B;AAEA;EACC,4BAA4B;EAC5B,+CAA+C;CAChD;;ACrED;;;EAGE;;ACHF;;;EAGE;;AAEF;;EAEE;ACPF;;;EAGE;;AFKF;;CCCC,sBAAsB;CACtB,yBAAyB;CACzB,qBAAqB;CACrB,iBAAgB;;CDAhB,kBAAkB;CAClB,oBAAoB;CACpB,mBAAmB;AAwBpB;;AA9BA;;EASE,qBAAqB;AAqBvB;;AA9BA;;EAaE,sBAAsB;AAiBxB;;AAdC;EACC,aAAa;CACd;;AAGC;GACC,qBAAqB;EACtB;;AAGD,2DAA2D;;AAC3D;EACC,uBAAuB;CACxB;;AGrCD;;;EAGE;;AAGD;EACC,cAAc;CAKf;;AAHC;GACC,cAAc;EACf;;ACXF;;;EAGE;;AFHF;;;EAGE;;AEIF;CACC,iBAAiB;CACjB,WAAW;CACX,gBAAgB;AAqCjB;;AAxCA;EAME,gBAAgB;AAkClB;;AAxCA;EAUE,iBAAiB;AA8BnB;;AA3BC;GAEE,qCAAqC;CAMvC;;AARA;GAME,sCAAsC;CAExC;;AAEA;EACC,oBAAoB;EACpB,WAAW;EACX,YAAY;CASb;;AAZA;GAME,qCAAqC;CAMvC;;AAZA;GAUE,oCAAoC;CAEtC;;AAEA;EACC,YAAY;CACb;;AC9CD;;;EAGE;;AAGD;EACC,aAAa;CACd;;ACRD;;;EAGE;;AAEF;CACC,aAAa;AACd;;ACPA;;;EAGE;;AAEF;CACC,kBAAkB;AAKnB;;AAHC;EACC,gBAAgB;CACjB;;AAGD;CACC,aAAa;CACb,mBAAmB;CACnB,iBAAiB;CACjB,8BAA8B;CAC9B,mCAAmC;CACnC,YAAY;AAcb;;AAZC;EACC,kBAAkB;CACnB;;AAEA;EACC,YAAY;CACb;;AAEA;EACC,mCAAmC;EACnC,uCAAuC;CACxC;;AChCD;;;EAGE;;A7JHF;;;EAGE;;A6JKD,oCAAoC;;AAEnC;;GAEC,aAAa;GACb,mBAAmB;EAKpB;;AARA;;IAME,2BAA2B;EAE7B;;AAGD,uCAAuC;;AAEtC;GACC,aAAa;GACb,mBAAmB;GACnB,6BAA6B;EAM9B;;AAJC;;IAEC;GACD;;AC/BH;;;EAGE;;AAGD;EACC,aAAa;EACb,yBAAyB;CAC1B;;ACTD;;;EAGE;;AAEF;CACC,iBAAiB;CACjB,yBAAyB;;CAEzB,eAAe;CACf,SAAS;CACT,OAAO;CACP,QAAQ;CACR,MAAM;AAOP;;AALC;EACC,oBAAoB;EACpB,eAAe;EACf,gBAAgB;CACjB;;AAGD;CACC,yBAAyB;CACzB,kBAAkB;CAClB,kBAAkB;AAanB;;AAXC;EACC,cAAc;CAKf;;AAHC;GACC,YAAY;EACb;;AAVF;EAcE,mBAAmB;AAErB;;ACtCA;;;EAGE;;AAEF;CACC,6BAA6B;AAC9B;;AAEA;CACC,qBAAqB;CACrB,kBAAkB;AA2EnB;;AAzEC;EACC,oBAAoB;EACpB,4BAA4B;CAC7B;;AAEA,wEAAwE;;AACxE;EACC,WAAW;CACZ;;AAEA;EACC,aAAa;EACb,0BAA0B;EAC1B,uCAAuC;;EAEvC,kBAAkB;CAyDnB;;AAvDC;GACC,qBAAqB;EACtB;;AAEA;;;;;GAKC,YAAY;EACb;;AAEA;;;;;GAKC;;;KAGE;GACF,SAAS;GACT,YAAY;EACb;;AAEA;;GAEC,SAAS;EACV;;AAEA;;GAEC,UAAU;EACX;;AAEA;;GAEC,4DAA4D;GAC5D,SAAS;GACT,2BAA2B;EAC5B;;AAEA;;GAEC,iEAAiE;GACjE,SAAS;GACT,2BAA2B;EAC5B;;AAEA;;GAEC,iEAAiE;GACjE,SAAS;GACT,2BAA2B;EAC5B;;AAIF;;;EAGE;AACF;CACC,sCAAsC;AACvC;;AC9FA;;;EAGE;;AAEF;CACC,iEAAiE;CACjE,kBAAkB;AAKnB;;AAHC;EACC,sCAAsC;CACvC;;;ACXD;;;EAGE;;AAEF;CACC,qCAAqC;AACtC;;AAEA;CACC,sDAAsD;CACtD,kBAAkB;CAClB,+CAA+C;AAOhD;;AAJE;GACC,sCAAsC;EACvC;;ACjBF;;;EAGE;;AAEF;CACC,oBAAoB;CACpB,4BAA4B;AAC7B;;ACRA;;;EAGE;;AAEF;CACC,kBAAkB;CAClB,iBAAiB,EAAE,+DAA+D;CAClF,gBAAgB;CAChB,oCAAoC;AACrC;;ACVA;;;EAGE;;AAEF;CACC,cAAc;AACf;;ACPA;;;EAGE;;AAEF;CACC,kBAAkB;CAClB,cAAc;CACd,aAAa;AACd;;AAEA;CACC,qBAAqB;AACtB;;ACbA;;;EAGE;;AAEF;CACC,aAAa;CACb,mBAAmB;CACnB,iBAAiB;CACjB,mBAAmB;CACnB,8BAA8B;AAK/B;;AAHC;EACC,YAAY;CACb;;ACdD;;;EAGE;;AAEF;CACC,sBAAsB;AACvB;;ACPA;;;EAGE;;AAEF;CACC,cAAc;AACf;;AAEA;CACC,aAAa;AACd;;ACXA;;;EAGE;;AAGD;EACC,aAAa;EACb,kBAAkB;CACnB;;AAEA;EACC,cAAc;EACd,kBAAkB;CACnB;;ACdD;;;EAGE;;ArBHF;;;EAGE;;AAEF;;EAEE;;AqBAF;CrBEC,sBAAsB;CACtB,yBAAyB;CACzB,qBAAqB;CACrB,iBAAgB;;CqBFhB,aAAa;CACb,sBAAsB;AAcvB;;AAZC;;EAEC,cAAc;CACf;;AAEA;;uBAEsB;;AACtB;EACC,kBAAkB;EAClB,4BAA4B;CAC7B;;ACxBD;;;EAGE;;AAEF;CACC,kEAAkE;CAClE,+DAA+D;AAChE;;AAEA;CACC,aAAa;CACb,kBAAkB;;CAElB,0BAA0B;AAyC3B;;AAtCE;;GAEC,WAAW;GACX,kBAAkB;EACnB;;AAEA;GACC,8CAA8C;EAC/C;;AAEA;GACC,wDAAwD;EACzD;;AAIA;GACC,8CAA8C;EAC/C;;AAEA;GACC,wDAAwD;EACzD;;AAIA;GACC,8CAA8C;EAC/C;;AAEA;GACC,wDAAwD;EACzD;;AAGD;EACC,cAAc;CACf;;ACtDD;;;EAGE;;AAEF;CACC,aAAa;CACb,mBAAmB;CACnB,uBAAuB;AACxB;;AAEA;;EAEE;AACF;CACC,uBAAuB;AACxB;;AChBA;;;EAGE;;AAEF;CACC,kBAAkB;;CAElB,6DAA6D;CAC7D,oCAAoC;AACrC;;AAEA;CACC,kBAAkB;AACnB;;AAEA;CACC,UAAU;AACX;;AAEA;CACC,UAAU;AACX;;ACtBA;;;EAGE;;AAGD;EACC,0BAA0B,EAAE,SAAS;EACrC,eAAe;EACf,MAAM;CACP;;AAEA;EACC,SAAS;EACT,kBAAkB;CACnB;;ACfD;;;EAGE;;AAEF;CACC,kBAAkB;AAenB;;AAbC;EACC,kBAAkB;EAClB,0BAA0B;CAU3B;;AARC;GACC,YAAY;EACb;;AAEA;GACC,SAAS;GACT,YAAY;EACb;;ACnBF;;;EAGE;;AjLHF;;;EAGE;;AiLMA;GACC,kBAAkB;GAClB,QAAQ;GACR,2BAA2B;EAS5B;;AAZA;IAME,8BAA8B;EAMhC;;AAZA;IAUE,+BAA+B;EAEjC;;AAEA;GACC,kBAAkB;GAClB,QAAQ;GACR,2BAA2B;EAC5B;;AAKC;IACC,cAAc;GACf;;AAEA,kDAAkD;;AAClD;IACC,aAAa;GACd;;ACvCH;;;EAGE;;AAEF;CACC,gDAAgD;CAChD,uBAAuB;CACvB,oBAAoB;CACpB,oBAAoB;CACpB,kBAAkB;AACnB;;ACXA;;;EAGE;;A7BHF;;;EAGE;;AAEF;;EAEE;;A6BAF;C7BEC,sBAAsB;CACtB,yBAAyB;CACzB,qBAAqB;CACrB,iBAAgB;;C6BFhB,yCAAyC;AAC1C;;ACXA;;;EAGE;;AAEF;CACC,+BAA+B;AAChC;;AAEA;CACC,cAAc;CACd,kBAAkB;AACnB;;AAEA;CACC,kBAAkB;CAClB,QAAQ;CACR,OAAO;CACP,QAAQ;CACR,cAAc;CACd,2BAA2B;CAC3B,UAAU;AACX;;ACtBA;;;EAGE;;A/BHF;;;EAGE;;AAEF;;EAEE;;A+BAF;C/BEC,sBAAsB;CACtB,yBAAyB;CACzB,qBAAqB;CACrB,iBAAgB;;C+BFhB,aAAa;CACb,qBAAqB;CACrB,mBAAmB;AA6CpB;;AA3CC;EACC,aAAa;EACb,mBAAmB;EACnB,mBAAmB;EACnB,YAAY;;CAEb;;AAEA;EACC,qBAAqB;;EAErB;;;;IAIE;CAKH;;AAJC;;GAEC,aAAa;EACd;;AAGD;EACC,gBAAgB;CACjB;;AAEA;EACC,iBAAiB;CAClB;;AAEA;EACC,sBAAsB;CACvB;;AAEA;EACC,iBAAiB;CAClB;;AAGC;GACC,aAAa;EACd;;ACvDF;;;EAGE;;AAEF;CACC,kBAAkB;CAClB,4BAA4B;AAC7B;;ACRA;;;EAGE;;AAGD;EACC,oBAAoB;EACpB,4BAA4B;CAC7B;;ACTD;;;EAGE;;AAEF;CACC,kCAAkC;CAClC,gDAAgD;AACjD;;AAEA;CACC,0BAA0B;CAC1B,4CAA4C;CAC5C,kBAAkB;AAgDnB;;AA9CC;;EAEC,YAAY;CACb;;AAEA;;EAEC,SAAS;EACT,YAAY;CACb;;AAEA;;EAEC,SAAS;CACV;;AAEA;;EAEC,UAAU;CACX;;AAEA;;EAEC,qEAAqE;CACtE;;AAEA;EACC,QAAQ;CACT;;AAEA;EACC,WAAW;CACZ;;AAEA;;EAEC,sEAAsE;CACvE;;AAEA;EACC,QAAQ;CACT;;AAEA;EACC,WAAW;CACZ;;AC5DD;;;EAGE;;AAEF;CACC,cAAc;CACd,kBAAkB;AACnB;;ACRA;;;EAGE;;AAEF;CACC,gDAAgD;CAChD,sDAAsD;CACtD,gDAAgD;;CAEhD,mDAAmD;CACnD,iCAAiC;CACjC,qEAAqE;AACtE;;AAEA;CACC,qEAAqE;CACrE,kBAAkB;AACnB;;AAEA;CACC,kFAAkF;CAClF,kBAAkB;AAqBnB;;AAnBC;EACC,kBAAkB;CAOnB;;AALC;GACC;mCACgC;GAChC,cAAc;EACf;;AAGD,0FAA0F;;AAC1F;EACC,mBAAmB;CACpB;;AAEA,uFAAuF;;AACvF;EACC,mBAAmB;CACpB;;AAGD;CACC,sDAAsD;CACtD,2CAA2C;CAC3C,sDAAsD;CACtD,8CAA8C;CAC9C,mCAAmC;CACnC,cAAc;CACd,kCAAkC;CAClC,wCAAwC;CACxC,6CAA6C;AAoC9C;;AAlCC;;;;;EAKC,kBAAkB;CACnB;;AAEA;EACC,qCAAqC;EACrC,sCAAsC;CACvC;;AAEA;EACC,qCAAqC;EACrC,uCAAuC;CACxC;;AAEA;EACC,wCAAwC;EACxC,uCAAuC;CACxC;;AAEA;EACC,wCAAwC;EACxC,sCAAsC;CACvC;;AAEA,uEAAuE;;AACvE;EACC,gDAAgD;EAChD,SAAS;EACT,0BAA0B;CAC3B;;ACzFD;;;EAGE;;AAEF;CACC,kFAAkF;CAClF,kBAAkB;AACnB;;AAEA;CACC,aAAa;CACb,kBAAkB;;CAElB,8FAA8F;CAC9F,oBAAoB;;CAEpB,OAAO;CACP,MAAM;AACP;;AAGC;EACC,cAAc;CACf;;AAGD;CACC,kBAAkB;;CAElB,mFAAmF;CACnF,mBAAmB;AAWpB;;AATC;;EAEC,mBAAmB;CACpB;;AAEA;;EAEC,mBAAmB;CACpB;;ACzCD;;;EAGE;;AAGD;;GAEE;;AACF;EACC,cAAc;EACd,kBAAkB;EAClB,gBAAgB;EAChB,4BAA4B;CAwB7B;;AAtBC;GACC,kBAAkB;GAClB,QAAQ;GACR,SAAS;GACT,sCAAsC;EACvC;;AAEA;GACC,0CAA0C;GAC1C,oDAAoD;GACpD,oBAAoB;;GAEpB,2BAA2B;EAC5B;;AAEA;GACC,0CAA0C;GAC1C,uDAAuD;GACvD,qBAAqB;;GAErB,0BAA0B;EAC3B;;AAGD;;;;GAIE;;AAGD;GACC,WAAW;GACX,cAAc;GACd,kBAAkB;GAClB,QAAQ;GACR,SAAS;GACT,sCAAsC;EACvC;;AAGD;;GAEE;;AACF;EACC,aAAa;EACb,kBAAkB;EAClB,OAAO;EACP,QAAQ;CACT;;AAEA;;;;GAIE;;AACF;EACC,qDAAqD;EACrD,sDAAsD;CACvD;;AAEA;;GAEE;;AACF;EACC,0DAA0D;EAC1D,cAAc;CACf;;AAEA;;GAEE;;AACF;EACC,6DAA6D;EAC7D,cAAc;CACf;;AAGD;;EAEE;AACF;CACC,aAAa;AACd;;AAEA;;EAEE;AACF;CACC,aAAa;AACd;;AAEA;;EAEE;AACF;CACC,aAAa;AACd;;AhNiwSA,wCAAwC","sourcesContent":["/*\n * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.\n * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license\n */\n\n/* Reset */\n/*\n * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.\n * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license\n */\n/*\n * Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.\n * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license\n */\n:root {\n\t--ck-color-base-foreground: \t\t\t\t\t\t\t\thsl(0, 0%, 98%);\n\t--ck-color-base-background: \t\t\t\t\t\t\t\thsl(0, 0%, 100%);\n\t--ck-color-base-border: \t\t\t\t\t\t\t\t\thsl(220, 6%, 81%);\n\t--ck-color-base-action: \t\t\t\t\t\t\t\t\thsl(104, 50.2%, 42.5%);\n\t--ck-color-base-focus: \t\t\t\t\t\t\t\t\t\thsl(209, 92%, 70%);\n\t--ck-color-base-text: \t\t\t\t\t\t\t\t\t\thsl(0, 0%, 20%);\n\t--ck-color-base-active: \t\t\t\t\t\t\t\t\thsl(218.1, 100%, 58%);\n\t--ck-color-base-active-focus:\t\t\t\t\t\t\t\thsl(218.2, 100%, 52.5%);\n\t--ck-color-base-error:\t\t\t\t\t\t\t\t\t\thsl(15, 100%, 43%);\n\n\t/* -- Generic colors ------------------------------------------------------------------------ */\n\n\t--ck-color-focus-border-coordinates: \t\t\t\t\t\t218, 81.8%, 56.9%;\n\t--ck-color-focus-border: \t\t\t\t\t\t\t\t\thsl(var(--ck-color-focus-border-coordinates));\n\t--ck-color-focus-outer-shadow:\t\t\t\t\t\t\t\thsl(212.4, 89.3%, 89%);\n\t--ck-color-focus-disabled-shadow:\t\t\t\t\t\t\thsla(209, 90%, 72%,.3);\n\t--ck-color-focus-error-shadow:\t\t\t\t\t\t\t\thsla(9,100%,56%,.3);\n\t--ck-color-text: \t\t\t\t\t\t\t\t\t\t\tvar(--ck-color-base-text);\n\t--ck-color-shadow-drop: \t\t\t\t\t\t\t\t\thsla(0, 0%, 0%, 0.15);\n\t--ck-color-shadow-drop-active:\t\t\t\t\t\t\t\thsla(0, 0%, 0%, 0.2);\n\t--ck-color-shadow-inner: \t\t\t\t\t\t\t\t\thsla(0, 0%, 0%, 0.1);\n\n\t/* -- Buttons ------------------------------------------------------------------------------- */\n\n\t--ck-color-button-default-background: \t\t\t\t\t\ttransparent;\n\t--ck-color-button-default-hover-background: \t\t\t\thsl(0, 0%, 94.1%);\n\t--ck-color-button-default-active-background: \t\t\t\thsl(0, 0%, 94.1%);\n\t--ck-color-button-default-disabled-background: \t\t\t\ttransparent;\n\n\t--ck-color-button-on-background: \t\t\t\t\t\t\thsl(212, 100%, 97.1%);\n\t--ck-color-button-on-hover-background: \t\t\t\t\t\thsl(211.7, 100%, 92.9%);\n\t--ck-color-button-on-active-background: \t\t\t\t\thsl(211.7, 100%, 92.9%);\n\t--ck-color-button-on-disabled-background: \t\t\t\t\thsl(211, 15%, 95%);\n\t--ck-color-button-on-color:\t\t\t\t\t\t\t\t\thsl(218.1, 100%, 58%);\n\n\n\t--ck-color-button-action-background: \t\t\t\t\t\tvar(--ck-color-base-action);\n\t--ck-color-button-action-hover-background: \t\t\t\t\thsl(104, 53.2%, 40.2%);\n\t--ck-color-button-action-active-background: \t\t\t\thsl(104, 53.2%, 40.2%);\n\t--ck-color-button-action-disabled-background: \t\t\t\thsl(104, 44%, 58%);\n\t--ck-color-button-action-text: \t\t\t\t\t\t\t\tvar(--ck-color-base-background);\n\n\t--ck-color-button-save: \t\t\t\t\t\t\t\t\thsl(120, 100%, 27%);\n\t--ck-color-button-cancel: \t\t\t\t\t\t\t\t\thsl(15, 100%, 43%);\n\n\t--ck-color-switch-button-off-background:\t\t\t\t\thsl(0, 0%, 57.6%);\n\t--ck-color-switch-button-off-hover-background:\t\t\t\thsl(0, 0%, 49%);\n\t--ck-color-switch-button-on-background:\t\t\t\t\t\tvar(--ck-color-button-action-background);\n\t--ck-color-switch-button-on-hover-background:\t\t\t\thsl(104, 53.2%, 40.2%);\n\t--ck-color-switch-button-inner-background:\t\t\t\t\tvar(--ck-color-base-background);\n\t--ck-color-switch-button-inner-shadow:\t\t\t\t\t\thsla(0, 0%, 0%, 0.1);\n\n\t/* -- Dropdown ------------------------------------------------------------------------------ */\n\n\t--ck-color-dropdown-panel-background: \t\t\t\t\t\tvar(--ck-color-base-background);\n\t--ck-color-dropdown-panel-border: \t\t\t\t\t\t\tvar(--c