<?php

namespace App;

use App\Notifications\UserResetPassword;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Storage;

class User extends Authenticatable
{
    use Notifiable;
	use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name','email','password','device','mbl','mbl_verified','status','standard_id','state_id','city_id','pincode',
		'logo','watermark_type','watermark_name','watermark_logo','name_of_instiute','text_size','text_opacity',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
	
	 /**
     * Send the password reset notification.
     *
     * @param  string  $token
     * @return void
     */
	
	public function sendPasswordResetNotification($token)
    {
        $this->notify(new UserResetPassword($token));
    }
	
	public function user(){
        return $this->belongsTo('App\User','id')->withTrashed();
    }
	
	public function standard()
	{
        return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }
	
	public function state()
	{
        return $this->belongsTo('App\Model\State','state_id')->withTrashed();
    }
	
	public function city()
	{
        return $this->belongsTo('App\Model\City','city_id')->withTrashed();
    }
	
	protected $appends = ['logo_url','watermark_logo_url'];
	
	public function getLogoUrlAttribute($value)
    {
        return  !empty($this->attributes['logo']) && Storage::exists($this->attributes['logo'])? Storage::url($this->attributes['logo']):null;
    }
	
	public function getWatermarkLogoUrlAttribute($value)
    {
        return  !empty($this->attributes['watermark_logo']) && Storage::exists($this->attributes['watermark_logo'])? Storage::url($this->attributes['watermark_logo']):null;
    }
}
