<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subject extends Model {

    use SoftDeletes;

    protected $fillable = [
        'name','status','semester_id','standard_id','medium_id',
    ];
	
	public function standard()
	{
        return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }
	
	public function medium()
	{
        return $this->belongsTo('App\Model\Medium','medium_id')->withTrashed();
    }
}
