<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;

class Subcategory extends Model
{
    use SoftDeletes;
	use Sluggable;
	
	protected $table = "subcategories";
	
    protected $fillable = [
        'category_id','name','image','status',
    ];
	
	protected $appends = ['image_url','image_thumb_url'];
	
	public function getImageUrlAttribute($value)
    {
        return  !empty($this->attributes['image']) && Storage::exists($this->attributes['image'])? Storage::url($this->attributes['image']):null;
    }
    public function getImageThumbUrlAttribute($value)
    {
        return Storage::exists( $this->attributes['image'])? Storage::url('thumb/'.$this->attributes['image']):null;
    }
	
	public function sluggable()
    {
        return ['slug' => ['source' => 'name','onUpdate'=>true]];
    }
	
	public function category()
	{
        return $this->belongsTo('App\Model\Category','category_id')->withTrashed();
    }
	
	public function getCategoryNameAttribute()
	{
		return \App\Model\Category::where('id',$this->category_id)->value('name');
	}
	
}
