<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Standard extends Model {

    use SoftDeletes;

    protected $fillable = [
        'name','status','medium_id','board_id',
    ];
	
	public function medium()
	{
        return $this->belongsTo('App\Model\Medium','medium_id')->withTrashed();
    }
    public function board()
	{
        return $this->belongsTo('App\Model\Board','board_id')->withTrashed();
    }
}
