<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sitesetting extends Model {

    use SoftDeletes;

    protected $fillable = [
        'comp_name','abt_detail','image' ,'comp_address','comp_phone','comp_phone2','comp_phone3','comp_email',
		'comp_tweeter','comp_fb','comp_gplus','linkdin_link','insta_link','meta_tag','privacy_policy','tandc',
		'help','subscribe_price','subscribe_detail','subscribe_name',
    ];

    protected $appends = ['image_url','image_thumb_url'];
    	
    public function getImageUrlAttribute($value)
    {
        return  !empty($this->attributes['image']) && Storage::exists($this->attributes['image'])? Storage::url($this->attributes['image']):null;
    }
    public function getImageThumbUrlAttribute($value)
    {
        return Storage::exists( $this->attributes['image'])? Storage::url('thumb/'.$this->attributes['image']):null;
    }

}
