<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Semester extends Model {

    use SoftDeletes;

    protected $table = 'semesters';

    protected $fillable = [
        'name','status','standard_id','medium_id','board_id'
    ];

    public function standard()
	{
        return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }

    public function medium()
	{
        return $this->belongsTo('App\Model\Medium','medium_id')->withTrashed();
    }
    public function board()
	{
        return $this->belongsTo('App\Model\Board','board_id')->withTrashed();
    }
}
