<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuestionType extends Model {

    use SoftDeletes;

    protected $table = 'questiontypes';

    protected $fillable = [
        'name','status','standard_id','medium_id','subject_id',
    ];

    public function standard()
	{
        return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }

    public function medium()
	{
        return $this->belongsTo('App\Model\Medium','medium_id')->withTrashed();
    }
    public function subject()
	{
        return $this->belongsTo('App\Model\Subject','subject_id')->withTrashed();
    }
    public function question()
    {
        return $this->hasMany('App\Model\Question', 'section_id', 'id')->withTrashed(); 
    }
   
}
