<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuestionDetail extends Model {

    use SoftDeletes;

    protected $fillable = [
        'question_id','paperstyle_id','question_type','question','answer','option1','option2','option3','option4','category_id',
    ];
	
	protected $appends = ['mark'];
	
	public function paperstyle()
	{
        return $this->belongsTo('App\Model\Paperstyle','paperstyle_id')->withTrashed();
    }
	
	public function getMarkAttribute()
	{
		return \App\Model\Paperstyle::where('id',$this->paperstyle_id)->value('name');
	}
}
