<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model {

    use SoftDeletes;

    protected $fillable = [
        'board_id','medium_id','standard_id','subject_id','chapter_id','question_type','question_line','difficulty','reference_id','imp','imp_year','question_title','marks','optionA','optionB','optionC','optionD','answer','formate','section_id','category_id','semester_id','explanation','status',
    ];
	
	public function board()
	{
        return $this->belongsTo('App\Model\Board','board_id')->withTrashed();
    }
	
	public function medium()
	{
        return $this->belongsTo('App\Model\Medium','medium_id')->withTrashed();
    }
	
	public function standard()
	{
        return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }
    public function reference()
	{
        return $this->belongsTo('App\Model\Reference','reference_id')->withTrashed();
    }

	public function subject()
	{
        return $this->belongsTo('App\Model\Subject','subject_id')->withTrashed();
    }
	
	public function chapter()
	{
        return $this->belongsTo('App\Model\Chapter','chapter_id')->withTrashed();
    }

    public function questiontype()
	{
        return $this->belongsTo('App\Model\QuestionType','section_id');
    }
    public function category()
	{
        return $this->belongsTo('App\Model\Category','category_id');
    }
    public function semester()
	{
        return $this->belongsTo('App\Model\Semester','semester_id');
    }
}
