<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\SoftDeletes;

class PreviousPaper extends Model {

    use SoftDeletes;

    protected $fillable = [
        'papertype_id','pdf','date','status','medium_id','standard_id','subject_id',
    ];
	
    protected $appends = ['pdf_url'];
	    
    public function getPdfUrlAttribute($value)
    {
        return  !empty($this->attributes['pdf']) && Storage::exists($this->attributes['pdf'])? Storage::url($this->attributes['pdf']):null;
    }
	
	public function papertype()
	{
        return $this->belongsTo('App\Model\Papertype','papertype_id')->withTrashed();
    }	
	
	public function medium()	{ 
	    return $this->belongsTo('App\Model\Medium','medium_id')->withTrashed();  
	}
	
	public function standard()	{     
	    return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }
	
	public function subject()	{ 
	    return $this->belongsTo('App\Model\Subject','subject_id')->withTrashed();  
	}

}
