<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Paper extends Model {

    use SoftDeletes;

    protected $fillable = [
		'admin_id','board_id','medium_id','semester_id','standard_id','subject_id','chapter_id','paper_date','paper_type','paper_difficulty','generate_as','generate_type','status'
    ];
    
    public function paperdetail(){
        return $this->hasMany('App\Model\PaperDetail','paper_id')->orderBy('sequence','ASC')->orderBy('paper_id', 'ASC')->with(['question']);
    }
    public function board()
	{
        return $this->belongsTo('App\Model\Board','board_id')->withTrashed();
    }
	
	public function subject()
	{
        return $this->belongsTo('App\Model\Subject','subject_id')->withTrashed();
    }
    public function standard()
	{
        return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }

    public function semester()
	{
        return $this->belongsTo('App\Model\Semester','semester_id')->withTrashed();
    }
	
	public function chapter()
	{
        return $this->belongsTo('App\Model\Chapter','chapter_id')->withTrashed();
    }
}
