<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contact extends Model {

    use SoftDeletes;

    protected $fillable = [
        'uid','querytype_id','feedback',
    ];
    
    public function user()
	{
        return $this->belongsTo('App\User','uid')->withTrashed();
    }
    
    public function querytype()
	{
        return $this->belongsTo('App\Model\Querytype','querytype_id')->withTrashed();
    }
}
