<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chapter extends Model {

    use SoftDeletes;

    protected $fillable = [
        'name','status','subject_id','medium_id','standard_id',
    ];
	
	public function standard()
	{
        return $this->belongsTo('App\Model\Standard','standard_id')->withTrashed();
    }
	
	public function medium()
	{
        return $this->belongsTo('App\Model\Medium','medium_id')->withTrashed();
    }
	
	public function subject()
	{
        return $this->belongsTo('App\Model\Subject','subject_id')->withTrashed();
    }
}
