<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;

class Category extends Model {

    use SoftDeletes;
	use Sluggable;

    protected $fillable = [
        'sequence','name','image','status','paperstyle_id',
    ];

    protected $appends = ['image_url','image_thumb_url'];
	
	public function scopeStatus($query) {
        return $query->where('status', '=', 'Active');
    }
   
    public function getImageUrlAttribute($value)
    {
        return  !empty($this->attributes['image']) && Storage::exists($this->attributes['image'])? Storage::url($this->attributes['image']):null;
    }
    public function getImageThumbUrlAttribute($value)
    {
        return Storage::exists( $this->attributes['image'])? Storage::url('thumb/'.$this->attributes['image']):null;
    }
	
	public function sluggable()
    {
        return ['slug' => ['source' => 'name','onUpdate'=>true]];
    }
	
	public function subcategory()
	{
        return $this->hasMany('App\Model\Subcategory','category_id')->where('status','Active')->withTrashed();
    }
	
	public function paperstyle()
	{
        return $this->belongsTo('App\Model\Paperstyle','paperstyle_id')->withTrashed();
    }

}
