<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Response;
use Stichoza\GoogleTranslate\TranslateClient;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Requests;
use Validator;
use App\Model\Product;
use App\User;

class UserController extends Controller
{
    public function login(Request $request)
    {
        if (!empty($request['email']) && !empty($request['password'])) {
            $user = User::where('email', $request['email'])->orWhere('email', $request['email'])->first();
            if (!empty($user) && Hash::check($request['password'], $user->password)) {
                $token = Str::random(30);
                $user->api_token = $token;
                $user->save();
                $user->update(['api_token' => $token]);
                $response['result'] = "1";
                $response['message'] = "Success";
                $response['token'] = $token;
                $response['data'] = $user;
				if($user->mbl_verified==0)
				{
					$mbl = $user->mbl;
					$otp_onetime=rand(1000,9999);
					$sms = "Your Otp for Question Paper Bank is ".$otp_onetime;
					$sms2=urlencode($sms);
					$sms_url ="http://msgportal.echoexit.info/submitsms.jsp?user=echoexit&key=2b3324ba4fXX&mobile=$mbl&message='".$sms2."'&senderid=BRTSMJ&accusage=1";
					$ch=curl_init();
					curl_setopt($ch,CURLOPT_URL,$sms_url);
					curl_setopt($ch, CURLOPT_POST, 1);
					curl_setopt($ch,CURLOPT_POSTFIELDS,$otp_onetime);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); curl_setopt($ch,CURLOPT_TIMEOUT, '3');
					$content = trim(curl_exec($ch));
					curl_close($ch);
					$response['otp']=$otp_onetime;
				}
            } else {
                $response['result'] = '0';
                $response['message'] = 'Invalid email or password.';
            }
			return Response::json($response);
        }
		elseif (!empty($request['mbl']) && !empty($request['password']))
		{
			$user = User::where('mbl', $request['mbl'])->orWhere('mbl', $request['mbl'])->first();
			if (!empty($user) && Hash::check($request['password'], $user->password)) {
				$token = Str::random(30);
                $user->api_token = $token;
                $user->save();
                $user->update(['api_token' => $token]);
                $response['result'] = "1";
                $response['message'] = "Success";
                $response['token'] = $token;
                $response['data'] = $user;
				if($user->mbl_verified==0)
				{
					$mbl = $user->mbl;
					$otp_onetime=rand(1000,9999);
					$sms = "Your Otp for Question Paper Bank is ".$otp_onetime;
					$sms2=urlencode($sms);
					$sms_url ="http://msgportal.echoexit.info/submitsms.jsp?user=echoexit&key=2b3324ba4fXX&mobile=$mbl&message='".$sms2."'&senderid=BRTSMJ&accusage=1";
					$ch=curl_init();
					curl_setopt($ch,CURLOPT_URL,$sms_url);
					curl_setopt($ch, CURLOPT_POST, 1);
					curl_setopt($ch,CURLOPT_POSTFIELDS,$otp_onetime);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); curl_setopt($ch,CURLOPT_TIMEOUT, '3');
					$content = trim(curl_exec($ch));
					curl_close($ch);
					$response['otp']=$otp_onetime;
				}
			}
			else {
                $response['result'] = '0';
                $response['message'] = 'Invalid Mobile & Password.';
            }
			return Response::json($response);
		}
		else {
            $response['result'] = '0';
            $response['message'] = 'Mobile & Password required.';
        }
        return Response::json($response);
    }

    public function signup(Request $request)
    {
        if (!empty($request['email'])) {
            if (User::where('email', $request['email'])->count()) {
                $response['result'] = "0";
                $response['message'] = "We already have this email in our system. Please change.";
            }
			else if (User::where('mbl', $request['mbl'])->count()) {
                $response['result'] = "0";
                $response['message'] = "We already have this Mobile in our system. Please change.";
            }			
			else {
                $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'email' => 'email',
					'mbl' => 'required|numeric',
					'password' => 'required|min:5',
					'state_id' => 'required',
					'city_id' => 'required',
					'pincode' => 'required',

                ], [
                    'name.min' => 'Please choose a username in the following format: 2-20 characters',
                    'name.max' => 'Please choose a username in the following format: 2-20 characters',
                    'password.min' => 'Please create a password in the following format: 5-10 characters',
                    'password.max' => 'Please create a password in the following format: 5-10 characters',
                    'email.email' => 'The email format is wrong – please enter a valid email address',
                ]);
                if ($validator->fails()) {
                    $response['result'] = "0";
                    $response['message'] = $validator->errors()->first();
                    return Response::json($response);
                }
				$token = Str::random(30);
                $user = User::create([
                    'name' => $request['name'],
                    'email' => $request['email'],
					'mbl' => $request['mbl'],
					'standard_id' => $request['standard_id'],
					'state_id' => $request['state_id'],
					'city_id' => $request['city_id'],
					'pincode' => $request['pincode'],
                    'password' => bcrypt($request['password']),
                ]);
				$user->api_token = $token;
				$user->save();
				$user->update(['api_token' => $token]);
				$mbl = $request['mbl'];
				$otp_onetime=rand(1000,9999);
				$sms = "Your Otp for Question Paper Bank is ".$otp_onetime;
				$sms2=urlencode($sms);
				$sms_url ="http://msgportal.echoexit.info/submitsms.jsp?user=echoexit&key=2b3324ba4fXX&mobile=$mbl&message='".$sms2."'&senderid=BRTSMJ&accusage=1";
				$ch=curl_init();
				curl_setopt($ch,CURLOPT_URL,$sms_url);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch,CURLOPT_POSTFIELDS,$otp_onetime);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); curl_setopt($ch,CURLOPT_TIMEOUT, '3');
				$content = trim(curl_exec($ch));
				curl_close($ch);
				
				$userdata = User::where('id',$user->id)->first();
				$response['result'] = "1";
                $response['message'] = "Welcome to Question Paper Bank!";
                $response['otp'] = "$otp_onetime";
                $response['token'] = $token;
                $response['data'] = $userdata;
            }
        } else {
            $response['result'] = '0';
            $response['message'] = 'Email is required.';
        }
        return Response::json($response);
    }
	
	public function get_profile(Request $request)
    {
        $auth = User::with(['standard','state','city'])->where('api_token', $request['api_token'])->whereNotNull('api_token')->first();
        $input = $request->all();
        if ((!empty($auth)) and (empty($input['id']))) {
            $response['result'] = '1';
            $response['message'] = 'Profile details.';
            $response['profile'] = $auth;
        }
        elseif (!empty($input['id'])) {
            $notlogin = User::where('id', $input['id'])->first();
            $response['result'] = '2';
            $response['message'] = 'Profile details.';
            $response['profile'] = $notlogin;
        } else {
            $response['result'] = '0';
            $response['message'] = 'Invalid authentication.';
        }
        return Response::json($response);
    }
	
	/*public function reset_password(Request $request)
    {
        $user = User::where('email','=',$request['email'])->whereNotNull('email')->first();
		if (!empty($user)) {
			$new_pasword = strtolower(str_random(8));
			$user->password = bcrypt($new_pasword);
			$user->save();
			Mail::send('mail.password', ['password' => $new_pasword], function ($message) use ($user) {
				$message->to($user->email, 'Reset Password')->subject
				('Laraveldemo reset password');
				$message->from('xyz@gmail.com','Laraveldemo');
			});
				
			$response['result'] = '1';
			$response['message'] = 'New password was sent to your email.';	
        } else {
            $response['result'] = '0';
            $response['message'] = "We couldn't find account having this email id and mobile number.";
        }
        return Response::json($response);
    }*/
	
	public function reset_password(Request $request)
    {
		$user=User::where('mbl',$request->mbl)->whereNotNull('mbl')->first();
		if (!empty($user)) {
			$new_pasword = rand(999999,9999999);
			$user->password = bcrypt($new_pasword);
			$user->save();
			$mbl = $request->mbl;
			$otp_onetime = $new_pasword;
			$sms = "Your new password for Question Paper Bank ".$otp_onetime;
			$sms2 = urlencode($sms);
			$sms_url ="http://msgportal.echoexit.info/submitsms.jsp?user=echoexit&key=2b3324ba4fXX&mobile=$mbl&message='".$sms2."'&senderid=BRTSMJ&accusage=1";
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $sms_url);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $otp_onetime);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, '3');
			$content = trim(curl_exec($ch));
			curl_close($ch);
			
			$response['result'] = '1';
			$response['message'] = 'New password was sent to your mobile number.';
		} else {
			$response['result'] = '0';
			$response['message'] = "We couldn't find account having this mobile number.";
		}
		return Response::json($response);
	}
	
	public function changepassword(Request $request)
	{
		$auth = User::where('api_token', $request['api_token'])->whereNotNull('api_token')->first();
        if (!empty($auth)) {
			if (!empty($auth) && Hash::check($request['password'], $auth->password)){
				$auth->password=bcrypt($request['newpassword']);
				$auth->save();
				$response['result'] = '1';
				$response['message'] = 'Password Changed Successfully..';	
			}
			else{
				$response['result'] = '2';
				$response['message'] = 'Your Old Password Dose not Match';	
			}
		}
		else {
            $response['result'] = '0';
            $response['message'] = 'Invalid authentication.';
		}
		return Response::json($response);
	}
	
	public function verifyotp(Request $request)
    {
        $auth = User::where('api_token', $request['api_token'])->whereNotNull('api_token')->first();
        $input = $request->all();
        if (!empty($auth)) {
			$user = User::where('api_token',$request['api_token'])->first();
			$user->mbl_verified = '1';
			$user->save();
            $response['result'] = '1';
            $response['message'] = "Welcome to Question Paper Bank!";
            $response['data'] = $user;
        }
        else {
            $response['result'] = '0';
            $response['message'] = 'Invalid authentication.';
        }
        return Response::json($response);
    }

    public function update_profile(Request $request)
    {
        $auth = User::where('api_token', $request['api_token'])->first();
        if (!empty($auth)) {
            if (!empty($request['email'])) {
                if (User::where('email', $request['email'])->where('id', '!=', $auth->id)->count()) {
                    $response['result'] = "0";
                    $response['message'] = "Email id already registered.";
                    return Response::json($response);
                }
            }
            if (!empty($request['mbl'])) {
                if (User::where('mbl', $request['mbl'])->where('id', '!=', $auth->id)->count()) {
                    $response['result'] = "0";
                    $response['message'] = "This mobile already registered.";
                    return Response::json($response);
                }
            }
            $input = $request->all();
            if (!empty($request['name'])) {
                $auth->name = $request['name'];
            }
            if (!empty($request['email'])) {
                $auth->email = $request['email'];
            }
            if (!empty($request['mbl'])) {
                $auth->mbl = $request['mbl'];
            }
			if (!empty($request['standard_id'])) {
                $auth->standard_id = $request['standard_id'];
            }
			if (!empty($request['state_id'])) {
                $auth->state_id = $request['state_id'];
            }
			if (!empty($request['city_id'])) {
                $auth->city_id = $request['city_id'];
            }
			if (!empty($request['pincode'])) {
                $auth->pincode = $request['pincode'];
            }
            $auth->save();
			$response['result'] = '1';
            $response['message'] = 'Profile updated successfully.';
            $response['profile'] = $auth;
        } else {
            $response['result'] = '0';
            $response['message'] = 'Invalid authentication.';
        }
        return Response::json($response);
    }
	
	public function pdf_settings(Request $request)
    {
        $auth = User::where('api_token', $request['api_token'])->first();
        if (!empty($auth)) {
			if(!empty($request['logo'])){
				$auth->logo = $this->uploadFile($request, null, 'logo', 'logo', false);
			}
            if (!empty($request['watermark_type'])) {
                $auth->watermark_type = $request['watermark_type'];
            }
			if (!empty($request['watermark_name'])) {
                $auth->watermark_name = $request['watermark_name'];
            }
			if(!empty($request['watermark_logo'])){
				$auth->watermark_logo = $this->uploadFile($request, null, 'watermark_logo', 'watermarklogo', false);
			}
			if (!empty($request['name_of_instiute'])) {
                $auth->name_of_instiute = $request['name_of_instiute'];
            }
			if (!empty($request['text_size'])) {
                $auth->text_size = $request['text_size'];
            }
			if (!empty($request['text_opacity'])) {
                $auth->text_opacity = $request['text_opacity'];
            }
            $auth->save();
			$response['result'] = '1';
            $response['message'] = 'Pdf settings updated successfully.';
            $response['profile'] = $auth;
        } else {
            $response['result'] = '0';
            $response['message'] = 'Invalid authentication.';
        }
        return Response::json($response);
    }
	
	public function checklogin(Request $request)
    {
        $auth = User::with(['standard','state','city'])->where('api_token', $request['api_token'])->whereNotNull('api_token')->first();
        if(!empty($auth)) {
            $response['result'] = '1';
            $response['message'] = 'Welcome to Question Paper Bank!';
            $response['data'] = $auth;
        } else {
            $response['result'] = '0';
            $response['message'] = 'Invalid authentication.';
        }
        return Response::json($response);
    }
}
