<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\DB;
use App\Model\Question;
use App\Model\QuestionDetail;

class QuestionController extends Controller
{
    
    public function __construct()
    {
        //$this->middleware('auth');
    }
	
	public function getquestion(Request $request)
    {
		$question = Question::query();
		if(!empty($request['board_id'])){
			$question->where('board_id',$request['board_id']);
		}
		if(!empty($request['medium_id'])){
			$question->where('medium_id',$request['medium_id']);
		}
		if(!empty($request['standard_id'])){
			$question->where('standard_id',$request['standard_id']);
		}
		if(!empty($request['subject_id'])){
			$question->where('subject_id',$request['subject_id']);
		}
		if(!empty($request['chapter_id'])){
			$question->whereIn('chapter_id',explode(',',$request->chapter_id));
		}
		$questionid = $question->pluck('id');
		$records = QuestionDetail::query();
		$records->whereIn('question_id',$questionid);
		if(!empty($request['paperstyle_id'])){
			$records->whereIn('paperstyle_id',explode(',',$request->paperstyle_id));
		}
		$records->orderBy('paperstyle_id','ASC');
		$records = $records->paginate(10);
		$records->appends($request->all());
		
		
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function check_question(Request $request)
    {
        $question = Question::query();
		if(!empty($request['board_id'])){
			$question->where('board_id',$request['board_id']);
		}
		if(!empty($request['medium_id'])){
			$question->where('medium_id',$request['medium_id']);
		}
		if(!empty($request['standard_id'])){
			$question->where('standard_id',$request['standard_id']);
		}
		if(!empty($request['subject_id'])){
			$question->where('subject_id',$request['subject_id']);
		}
		if(!empty($request['chapter_id'])){
			$question->whereIn('chapter_id',explode(',',$request->chapter_id));
		}
		$questionid = $question->pluck('id');
		
		$mark1 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark1->where('question_id',$request['question_id']);
		}
		$mark1->where('paperstyle_id',1);
		$mark1 = $mark1->count();
		
		$mark2 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark2->where('question_id',$request['question_id']);
		}
		$mark2->where('paperstyle_id',2);
		$mark2 = $mark2->count();
		
		$mark3 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark3->where('question_id',$request['question_id']);
		}
		$mark3->where('paperstyle_id',3);
		$mark3 = $mark3->count();
		
		$mark4 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark4->where('question_id',$request['question_id']);
		}
		$mark4->where('paperstyle_id',4);
		$mark4 = $mark4->count();
		
		$mark5 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark5->where('question_id',$request['question_id']);
		}
		$mark5->where('paperstyle_id',5);
		$mark5 = $mark5->count();
		
		$mark6 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark6->where('question_id',$request['question_id']);
		}
		$mark6->where('paperstyle_id',6);
		$mark6 = $mark6->count();
		
		$mark7 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark7->where('question_id',$request['question_id']);
		}
		$mark7->where('paperstyle_id',7);
		$mark7 = $mark7->count();
		
		$mark8 = QuestionDetail::query();
		if(!empty($request['question_id'])){
			$mark8->where('question_id',$request['question_id']);
		}
		$mark8->where('paperstyle_id',8);
		$mark8 = $mark8->count();
		
		$records = array('1 Mark'=>$mark1,'2 Mark'=>$mark2,'3 Mark'=>$mark3,'4 Mark'=>$mark4,'5 Mark'=>$mark5,'6 Mark'=>$mark6,'7 Mark'=>$mark7,'8 Mark'=>$mark8);
		
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['data'] = $records;
		
        return Response::json($response);
    }
	public function generatepdf(Request $request){
		$response['result'] = '1';
        $response['message'] = 'Success';
		return Response::json($response);
	}
	
}
