<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\DB;
use App\Model\Standard;
use App\Model\State;
use App\Model\City;
use App\Model\Board;
use App\Model\Medium;
use App\Model\Subject;
use App\Model\Chapter;
use App\Model\Paperstyle;
use App\Model\Querytype;
use App\Model\Papertype;

class DropdownController extends Controller
{
    
    public function __construct()
    {
        //$this->middleware('auth');
    }
	
	public function getstandard(Request $request)
    {
        $records = Standard::query();
		if(!empty($request['medium_id'])){
			$records = $records->where('medium_id',$request['medium_id']);
		}
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getstate(Request $request)
    {
        $records = State::query();
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getcity(Request $request)
    {
        $records = City::query();
		if(!empty($request['state_id'])){
			$records = $records->where('state_id',$request['state_id']);
		}
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getboard(Request $request)
    {
        $records = Board::query();
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getmedium(Request $request)
    {
        $records = Medium::query();
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getsubject(Request $request)
    {
        $records = Subject::query();
		if(!empty($request['standard_id'])){
			$records = $records->where('standard_id',$request['standard_id']);
		}
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getchapter(Request $request)
    {
        $records = Chapter::query();
		if(!empty($request['subject_id'])){
			$records = $records->where('subject_id',$request['subject_id']);
		}
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getpaperstyle(Request $request)
    {
        $records = Paperstyle::query();
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getquerytype(Request $request)
    {
        $records = Querytype::query();
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
	
	public function getpapertype(Request $request)
    {
        $records = Papertype::query();
		$records = $records->paginate(50);
		$records->appends($request->all());
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
}
