<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\DB;
use App\Model\Category;
use App\Model\Subcategory;
use App\Model\Sitesetting;

class CategoryController extends Controller
{
    
    public function __construct()
    {
        //$this->middleware('auth');
    }

    public function index(Request $request)
    {
        $records = Category::with(['paperstyle'])->where('status','Active')->orderBy('sequence','ASC')->get();
        
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
    
    public function sublevel(Request $request, $cid)
    {
        $records = Subcategory::select('*')
            ->where([
                ['status', '=', 'Active'],
                ['category_id', '=', $cid],
            ])
            ->get();
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }

    public function sitesetting(Request $request)
    {
        $records = Sitesetting::first();
        $response['result'] = '1';
        $response['message'] = 'Success';
        $response['records'] = $records;
        return Response::json($response);
    }
}
