<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use App\User;

class UserController extends Controller
{
    private $data = array(
        'route' => 'admin.user.',
        'title' => 'User',
        'menu' => 'user',
        'submenu' => '',
    );
	
    public function __construct()
    {
        //$this->middleware('auth');
    }
	
    private function _validate($request, $id = null)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
            'email' => 'required|email|max:255|unique:users,email'.(!empty($id)?','.$id:''),
			'mbl' => 'required|numeric|unique:users,mbl'.(!empty($id)?','.$id:''),
			'password' => 'required_with:password_confirmation|max:255',
            'password_confirmation' => 'required_with:password|max:255|same:password',
        ]);
		if ($id == null) {
            $this->validate($request, [
                'password' => 'required|max:255',
                'password_confirmation' => 'required|max:255|same:password',
            ]);
        }
    }

    public function index(Request $request)
    {

        if($request->has('export') && ($request->get('export')=='xlsx' || $request->get('export')=='csv')){
		   $users = User::orderBy('id','ASC')->get();
				$subset = $users->map(function ($user) {
					return collect($user->toArray())
						->only(['name','mbl','email'])
						->all();
				});
		   $this->exportFile($request->get('export'), 'Userlist'.rand(), ['Name','Mobile','Email'], $subset);
		}
		
        if ($request->ajax()) {
            $records = User::with(['state','city'])->select('users.*');
            return Datatables::of($records)
                ->editColumn('created_at', function ($record) {
                    return $record->created_at->format(config('app.display_date'));
                })
                ->addColumn('status', function ($record) {
                    return '<input id="toggle-demo" value="'.$record->id.'" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" '.($record->status == "Active"?" checked":"" ).' >';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.route($this->data['route'].'show',['id' =>$record->id]).'" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>'./*
                          '&nbsp;<a href="'.route($this->data['route'].'edit',['id' =>$record->id]).'" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>'.*/
                          '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="'.$record->id.'" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                })
                ->rawColumns(['status','action'])
                ->make(true);
        }
        return view('admin.user.index',$this->data);

    }

    public function create()
    {
        return view('admin.user.create',$this->data);
    }


    public function store(Request $request)
    {
        $this->_validate($request);
        $request['password'] = bcrypt($request['password']);
        $record =  new User($request->all());
        $record->save();

        Session::flash('success', $this->data['title'].' inserted successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function show($id)
    {
        $this->data['record'] = User::findOrFail($id);
        return view('admin.user.show',$this->data);
    }


    public function edit($id)
    {
        $this->data['record'] = User::findOrFail($id);
        return view('admin.user.create',$this->data);
    }


    public function update(Request $request, $id)
    {
        $record = User::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->only(['status']));
            return \Illuminate\Support\Facades\Response::json(['result'=>'success']);
        }
        $this->_validate($request,$id);
        $record->update($request->all());

        Session::flash('info', $this->data['title'].' updated successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function destroy($id)
    {
        $record = User::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json(['result'=>'success','message'=>'Deleted Data successfully!']);
    }

}

