<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use App\Model\Category;
use App\Model\Subcategory;

class SubcategoryController extends Controller
{
    private $data = array(
        'route' => 'admin.subcategory.',
        'title' => 'Subcategory',
        'menu' => 'subcategory',
        'submenu' => '',
    );
	
    public function __construct()
    {
        //$this->middleware('auth');
    }
	
    private function _validate($request, $id = null)
    {
        $this->validate($request, [
            'category_id' => 'required',
            'name' => 'required|max:255',
			'image' => (!empty($id)?'mimes:jpeg,png,jpg,gif,svg|max:2048':'required|mimes:jpeg,png,jpg,gif,svg|max:2048'),
        ]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $records = Subcategory::with('category')->select('*');
			 
            return Datatables::of($records)
			    ->editColumn('created_at', function ($record) {
                    return $record->created_at->format(config('app.display_date'));
                  })
				->addColumn('image', function ($record) {
					if(!empty($record['image_url'])){
						return '<a href= "'. url($record->image_url).'" target="_blank" ><img src="'.$record->image_url.'" width="100" ></a>';
					}else{
						return '';
					}
				})
                ->addColumn('status', function ($record) {
                    return '<input id="toggle-demo" value="'.$record->id.'" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" '.($record->status == "Active"?" checked":"" ).' >';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.route($this->data['route'].'show',['id' =>$record->id]).'" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>'.
                          '&nbsp;<a href="'.route($this->data['route'].'edit',['id' =>$record->id]).'" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>'.
                          '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="'.$record->id.'" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                })
                ->rawColumns(['status','action','image'])
                  ->make(true);
        }
        return view('admin.subcategory.index',$this->data);

    }

    public function create()
    {
        return view('admin.subcategory.create',$this->data);
    }

    public function store(Request $request)
    {
        $this->_validate($request);
		$input = $request->all();
		$input['image'] = $this->uploadFile($request, null, 'image', 'category', false);
        $record =  new Subcategory($input);
        $record->save();

        Session::flash('success', $this->data['title'].' inserted successfully.');
        return redirect()->route($this->data['route'].'index');
    }

    public function show($id)
    {
        $this->data['record'] = Subcategory::findOrFail($id);
		
		$category_id = $this->data['record']['category_id'];
        if($category_id == ''){
            $this->data['category']['name'] = 'NULL';
        }else{
            $this->data['category'] = Category::findOrFail($category_id);            
        }
		
        return view('admin.subcategory.show',$this->data);
    }

    public function edit($id)
    {
        $this->data['record'] = Subcategory::findOrFail($id);
        return view('admin.subcategory.create',$this->data);
    }

    public function update(Request $request, $id)
    {
        $record = Subcategory::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->only(['status']));
            return \Illuminate\Support\Facades\Response::json(['result'=>'success']);
        }
        $this->_validate($request, $id);
		$input = $request->all();
		$input['image'] = $this->uploadFile($request, $record, 'image', 'category', false);
        if (empty($input['image'])) {
            unset($input['image']);
        }
        $record->update($input);

        Session::flash('info', $this->data['title'].' updated successfully.');
        return redirect()->route($this->data['route'].'index');
    }

    public function destroy($id)
    {
        $record = Subcategory::findOrFail($id);
        $this->deleteFile($record,'image',false);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }
}
