<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Model\Sitesetting;
use Illuminate\Support\Facades\Auth;

class SitesettingController extends Controller {

    private $data = array(
        'route' => 'admin.sitesetting.',
        'title' => 'Sitesetting',
        'menu' => 'sitesetting',
        'submenu' => '',
    );

    public function __construct() {
        $this->middleware(['permission:publish |sitesetting view|sitesetting edit']);
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);
    }

    public function index()
    {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['sitesetting view']), 403);

        $this->data['record'] = Sitesetting::first();
        return view('admin.sitesetting',$this->data);
    }
	
	public function sitesetting_post(Request $request)
    {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['sitesetting edit']), 403);

        $record = Sitesetting::findOrFail($request->id);
        $this->_validate($request);
        $input = $request->all();
		$input['image'] = $this->uploadFile($request,$record, 'image', 'sitesetting', false);
        if (empty($input['image'])) {
            unset($input['image']);
        }
        $record->update($input);
        Session::flash('success','Sitesetting updated successfully.');
        $val =  route('admin.sitesetting');
        return redirect($val);
    }

}
