<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{
    private $data = array(
        'route' => 'admin.role.',
        'title' => 'Role',
        'menu' => 'admin',
        'submenu' => 'role',
    );
	
    public function __construct()
    {
        //$this->middleware('auth');
        $this->middleware(['permission:publish |role']);
    }
	
    private function _validate($request, $id = null)
    {
        $this->validate($request, [
            'name' => 'required|alpha|max:255',
        ]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $records = Role::select('*');
			
            return Datatables::of($records)
                //return $this->dataTable->eloquent($records) 
                ->editColumn('created_at', function ($record) {
                    return $record->created_at->format(config('app.display_date'));
                })
                ->addColumn('permissions', function ($record) {
                    $permissions =  $record->permissions->pluck('name');
                    $html = '';
                    foreach ($permissions as $key => $value) {
                        $html .= '<small class="label label-success">'.$value.'</small>&nbsp;';
                    }
                    return $html;
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.route($this->data['route'].'edit',['id' =>$record->id]).'" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>'.
                          '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="'.$record->id.'" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                })
                ->rawColumns(['permissions','action'])
                ->make(true);
        }
        return view('admin.role.index',$this->data);

    }

    public function create()
    {
        return view('admin.role.create',$this->data);
    }


    public function store(Request $request)
    {
        $this->_validate($request);
        $record =  new Role($request->all());
        $record->save();

        Session::flash('success', $this->data['title'].' inserted successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function show($id)
    {
        $this->data['record'] = Role::findOrFail($id);
        return view('admin.role.show',$this->data);
    }


    public function edit($id)
    {
        $admin = Role::findOrFail($id);
        $this->data['assigned_permissions'] = $admin->permissions->pluck('name');
        $this->data['record'] = $admin;
        return view('admin.role.create',$this->data);
    }


    public function update(Request $request, $id)
    {
        $record = Role::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->only(['status']));
            return \Illuminate\Support\Facades\Response::json(['result'=>'success']);
        }

        $this->_validate($request);
        $record->update($request->only('name'));
        if(!empty($request['permissions'])){
            $record->syncPermissions($request['permissions']);
        }

        Session::flash('info', $this->data['title'].' updated successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function destroy($id)
    {
        $record = Role::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json(['result'=>'success','message'=>'Deleted Data successfully!']);
    }
}
