<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Auth;
use App\Model\Category;
use App\Model\Chapter;
use App\Model\QuestionType;
use App\Model\QuestionDetail;

class QuestionTypeController extends Controller {

    private $data = array(
        'route' => 'admin.questiontype.',
        'title' => 'Questiontype',
        'menu' => 'questiontype',
        'submenu' => '',
    );

    public function __construct() {
        $this->middleware(['permission:publish |questiontype view|questiontype add|questiontype edit|questiontype delete']);
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
            'standard_id' => 'required',
            'subject_id' => 'required',
            'name' => 'required'
           
           
        ]);
       
    }

    public function index(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['questiontype view']), 403);

        if ($request->ajax()) {
            $records = QuestionType::with(['medium','standard','subject'])->select('questiontypes.*')->orderBy('questiontypes.id', 'DESC');
			
            return Datatables::of($records)
                    
                    ->addColumn('status', function ($record) {
                        return '<input id="toggle-demo" value="' . $record->id . '" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" ' . ($record->status == "Active" ? " checked" : "" ) . ' >';
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="' . route($this->data['route'] . 'edit', ['id' => $record->id]) . '" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>' .
                                '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="' . $record->id . '" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                    })
                    ->rawColumns(['status','action'])
                    ->make(true);
        }
        return view('admin.questiontype.index', $this->data);
        
    }

    public function create() {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['questiontype add']), 403);

		$medium = \App\Model\Medium::with('standard')->where('status','=','Active')->get();
        $medium_array = [];
        foreach ($medium as $key => $m) {
            $medium_array[$m['name']] = $m['standard']->pluck('name','id')->toArray(); 
        }
        $this->data['record'] = [];
		$this->data['dropdown'] = $medium_array;
        return view('admin.questiontype.create', $this->data);
    }

    public function store(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['questiontype add']), 403);

        $this->_validate($request);
        $input = $request->all();
		
        $record = new QuestionType($input);
        $standard = \App\Model\Standard::where('id',$request->standard_id)->first();
        $record->medium_id = $standard->medium_id;
        $record->save();
		
        Session::flash('success', $this->data['title'] . ' inserted successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function show($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['questiontype view']), 403);

        $this->data['record'] = QuestionType::with(['medium','standard','subject'])->where('id',$id)->first();
        return view('admin.questiontype.show', $this->data);
    }

    public function edit($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['questiontype edit']), 403);

        $this->data['record'] = QuestionType::findOrFail($id);
		$medium = \App\Model\Medium::with('standard')->where('status','=','Active')->get();
        $medium_array = [];
        foreach ($medium as $key => $m) {
            $medium_array[$m['name']] = $m['standard']->pluck('name','id')->toArray(); 
        }
		$this->data['dropdown'] = $medium_array;
		$this->data['subject']= \App\Model\Subject::where('standard_id',$this->data['record']->standard_id)->pluck('name','id');
		
        return view('admin.questiontype.create', $this->data);
    }

    public function update(Request $request, $id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['questiontype edit']), 403);

        $record = QuestionType::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->all());
            return \Illuminate\Support\Facades\Response::json(['result' => 'success']);
        }
         $this->_validate($request, $id);
         
        $input = $request->all();
        $standard = \App\Model\Standard::where('id',$request->standard_id)->first();
        $record->medium_id = $standard->medium_id;
       
        $record->update($input);

        Session::flash('info', $this->data['title'] . ' updated successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function destroy($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['questiontype delete']), 403);

        $record = QuestionType::findOrFail($id);
        $record->delete();
		
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }
	
	
	public function getsubject($id)
{
    $standard = \App\Model\Standard::withTrashed()->where('id', $id)->first();
    $subjects = \App\Model\Subject::withTrashed()->where('standard_id', $id)->where('medium_id',$standard->medium_id)->pluck('name', 'id');
    return response()->json($subjects);
}
	
	
	public function getchapter($id)
    {
        $chapter = Chapter::where('subject_id',$id)->pluck('name','id');
        return response()->json($chapter);
    }
	
	  

}
