<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Auth;
use App\Model\Category;
use App\Model\Standard;
use App\Model\Semester;
use App\Model\Question;
use App\Model\QuestionType;
use App\Model\QuestionDetail;

class QuestionController extends Controller {

    private $data = array(
        'route' => 'admin.question.',
        'title' => 'Question',
        'menu' => 'question',
        'submenu' => '',
    );

    public function __construct() {
        $this->middleware(['permission:publish |question view|question add|question edit|question delete']);
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
            'board_id' => 'required',
            'standard_id' => 'required',
            'chapter_id' => 'required',
            'standard_id' => 'required',
            'reference_id' => 'required',
            'question_type' => 'required',
            'difficulty' => 'required',
            'marks' => 'required',
            /* 'imp' => 'required',
             'imp_year' => 'required', */
            'question_title' => 'required',
           
        ]);
        $this->validate($request, [
            'optionA' => 'required_if:question_type,multiple',
            'optionB' => 'required_if:question_type,multiple',
            'optionC' => 'required_if:question_type,multiple',
            'optionD' => 'required_if:question_type,multiple',
            'multiple_answer' => 'required_if:question_type,multiple',
            'formate' => 'required_if:question_type,multiple',
            'true_false_answer' => 'required_if:question_type,true/false',
            'question_answer' => 'required_if:question_type,question',
        ]);
    }

    public function index(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['question view']), 403);

        if ($request->ajax()) {
            $records = Question::select('questions.*')->orderBy('questions.id', 'DESC')->with(['board','medium','standard','subject','chapter']);
			
            return Datatables::of($records)
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format(config('app.display_date'));
                    })
                    ->editColumn('question_title', function ($record) {
                        return $record->question_title;
                    })
                    ->addColumn('status', function ($record) {
                        return '<input id="toggle-demo" value="' . $record->id . '" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" ' . ($record->status == "Active" ? " checked" : "" ) . ' >';
                    })
                    ->addColumn('action', function ($record) {
                        return /* '<a href="' . url('admin/question/addquestion/'.$record->id). '" class="btn btn-warning btn-sm" title="" data-toggle="tooltip" data-original-title="Add Question"><i class="fa fa-plus"></i></a>'.*/
						        '&nbsp;<a href="' . route($this->data['route'] . 'show', ['id' => $record->id]) . '" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>' .
                                '&nbsp;<a href="' . route($this->data['route'] . 'edit', ['id' => $record->id]) . '" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>' .
                                '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="' . $record->id . '" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                    })
                    ->rawColumns(['status','action','question_title'])
                    ->make(true);
        }
        return view('admin.question.index', $this->data);
        
    }

    public function create() {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['question add']), 403);

		$medium = \App\Model\Medium::with('standard')->where('status','=','Active')->get();
        $medium_array = [];
        foreach ($medium as $key => $m) {
            $medium_array[$m['name']] = $m['standard']->pluck('name','id')->toArray(); 
        }
        $this->data['record'] = [];
		$this->data['dropdown'] = $medium_array;
        return view('admin.question.create', $this->data);
    }

    public function store(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['question add']), 403);

        $this->_validate($request);
        $input = $request->all();
		$main_medium=\App\Model\Standard::where('id',$input['standard_id'])->first();
		$input['medium_id']=$main_medium->medium_id;
        if(!empty($request->multiple_answer))
        {
            $input['answer'] = $request->multiple_answer;
            $input['formate'] = $request->formate;
        }
        if(!empty($request->true_false_answer))
        {
            $input['answer'] = $request->true_false_answer;
        }
        if(!empty($request->question_answer))
        {
            $input['answer'] = $request->question_answer;
        }
        $record = new Question($input);
        $record->save();
		
        Session::flash('success', $this->data['title'] . ' inserted successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function show($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['question view']), 403);

        $this->data['record'] = Question::with(['board','medium','standard','subject','chapter'])->where('id',$id)->first();
        return view('admin.question.show', $this->data);
    }

    public function edit($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['question edit']), 403);

        $this->data['record'] = $record = Question::findOrFail($id);
		$medium = \App\Model\Medium::with('standard')->where('status','=','Active')->get();
        $section = QuestionType::where('id',$record->section_id)->pluck('name','id')->toArray();
        $standard = Standard::where('id',$record->standard_id)->pluck('name','id')->toArray();
        $semester = Semester::where('id',$record->semester_id)->pluck('name','id')->toArray();
        $medium_array = [];
        foreach ($medium as $key => $m) {
            $medium_array[$m['name']] = $m['standard']->pluck('name','id')->toArray(); 
        }
		$this->data['dropdown'] = $medium_array;
        $this->data['section'] = $section;
        $this->data['standard'] = $standard;
        $this->data['semester'] = $semester;
		$this->data['subject']= \App\Model\Subject::where('standard_id',$this->data['record']->standard_id)->pluck('name','id');
		$this->data['chapter']= \App\Model\Chapter::where('subject_id',$this->data['record']->subject_id)->pluck('name','id');
        return view('admin.question.create', $this->data);
    }

    public function update(Request $request, $id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['question edit']), 403);
       
        $record = Question::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->all());
            return \Illuminate\Support\Facades\Response::json(['result' => 'success']);
        }
        $this->_validate($request, $id);
        $input = $request->all();
		$main_medium=\App\Model\Standard::where('id',$input['standard_id'])->first();
		$input['medium_id']=$main_medium->medium_id;
        if($request->question_type === 'question')
        {
        if(!empty($request->question_answer))
        {  
            $input['answer'] = $request->question_answer;
            $input['optionA'] = null;
            $input['optionB'] = null;
            $input['optionC'] = null;
            $input['optionD'] = null;
            $input['formate'] = null;
        }
    }
    if($request->question_type === 'multiple')
    {
        if(!empty($request->multiple_answer))
        {
            $input['answer'] = $request->multiple_answer;
          
            $input['formate'] = $request->formate;
        }
    }
    if($request->question_type === 'true/false')
    {
        if(!empty($request->true_false_answer))
        {
            $input['answer'] = $request->true_false_answer;
            $input['optionA'] = null;
            $input['optionB'] = null;
            $input['optionC'] = null;
            $input['optionD'] = null;
            $input['formate'] = null;
        }
    } 
       
        $record->update($input);

        Session::flash('info', $this->data['title'] . ' updated successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function destroy($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['question delete']), 403);

        $record = Question::findOrFail($id);
        $record->delete();
		QuestionDetail::where('question_id',$id)->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }
	
	public function addquestion($id) {
	    $this->data['question'] = Question::with(['board','medium','standard','subject','chapter'])->where('id',$id)->first();
		$this->data['record'] = QuestionDetail::with(['paperstyle'])->where('question_id',$id)->orderBy('id','DESC')->paginate(12);
        $this->data['question_id'] = $id;
        return view('admin.question.addquestion', $this->data);
    }
	
	public function savequestion(Request $request)
    {
        $this->validate($request, [
            'paperstyle_id' => 'required',
        ]);
        $input = $request->all();
		$record = new QuestionDetail($input);
		$record->save();
       
        Session::flash('success', $this->data['title'] . 'Question inserted successfully.');
        return redirect()->back();
    }
	
	public function deletequestion($id) {
        $record = QuestionDetail::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }
	
	public function getchapter(Request $request)
	{
		$id=$request->subject_id;
		$record = \App\Model\Chapter::where('subject_id',$id)->pluck('name','id');
        $questiontype = \App\Model\QuestionType::where('subject_id',$id)->pluck('name','id');
        $response = ['chapter' => $record,'questiontype'=>$questiontype];
		return \Illuminate\Support\Facades\Response::json($response);
	}
	public function upload(Request $request)
    {if ($request->hasFile('upload')) {
        $originName = $request->file('upload')->getClientOriginalName();
        $fileName = pathinfo($originName, PATHINFO_FILENAME);
        $extension = $request->file('upload')->getClientOriginalExtension();
        $fileName = $fileName . '_' . time() . '.' . $extension;

        
        $request->file('upload')->move(public_path('images'), $fileName);

       
        $url = asset('public/images/' . $fileName); 

       
        $CKEditorFuncNum = $request->input('CKEditorFuncNum');

        
        $response = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', 'Image uploaded successfully')</script>";

       
        @header('Content-type: text/html; charset=utf-8');
        echo $response;
        exit; 
    }
    return response()->json(['uploaded' => false, 'error' => ['message' => 'File upload failed.']]);

    }
	
	public function savepaperstyle(Request $request)
	{
		Session::put('session_paperstyle_id',$request->paperstyle_id);
		return 1;
	}
	public function updatequestion($id) {
		$this->data['record'] = QuestionDetail::where('id',$id)->first();
        return view('admin.question.updatequestion', $this->data);
    }
	
	public function getcategory(Request $request) {
		$records = Category::where('paperstyle_id',$request->paperstyle_id)->pluck('name','id')->toArray();
		$this->data['records'] =$records;
		return view('admin.question.category', $this->data);
    }
	
	public function updatequestiondata(Request $request)
    {
		
        $this->validate($request, [
            'question' => 'required',
        ]);
		
        $record = QuestionDetail::findOrFail($request->id);
        $input = $request->all();
        $record->update($input);
      
        Session::flash('success', $this->data['title'] . 'Question update successfully.');
        return redirect()->back();
		
    }
    public function getsemester($id)
    {
        $semester = \App\Model\Semester::where('standard_id',$id)->pluck('name', 'id');
   
        return response()->json($semester);
    }


    public function testCkediter(){
        // dd('sdf');
        return view('admin.question.testCkediter');
    }

}
