<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Auth;
use App\Model\Querytype;

class QuerytypeController extends Controller {

    private $data = array(
        'route' => 'admin.querytype.',
        'title' => 'Querytype',
        'menu' => 'querytype',
        'submenu' => '',
    );

    public function __construct() {
		
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
            'name' => 'required|max:255',
        ]);
    }

    public function index(Request $request) {
        if ($request->ajax()) {
            $records = Querytype::select('*');
			
            return Datatables::of($records)
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format(config('app.display_date'));
                    })
                    ->addColumn('status', function ($record) {
                        return '<input id="toggle-demo" value="' . $record->id . '" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" ' . ($record->status == "Active" ? " checked" : "" ) . ' >';
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="' . route($this->data['route'] . 'show', ['id' => $record->id]) . '" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>' .
                                '&nbsp;<a href="' . route($this->data['route'] . 'edit', ['id' => $record->id]) . '" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>' .
                                '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="' . $record->id . '" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                    })
                    ->rawColumns(['status','action'])
                    ->make(true);
        }
        return view('admin.querytype.index', $this->data);
        
    }

    public function create() {
        return view('admin.querytype.create', $this->data);
    }

    public function store(Request $request) {
        $this->_validate($request);
        $input = $request->all();
        $record = new Querytype($input);
        $record->save();
		
        Session::flash('success', $this->data['title'] . ' inserted successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function show($id) {
        $this->data['record'] = Querytype::findOrFail($id);
        return view('admin.querytype.show', $this->data);
    }

    public function edit($id) {
        $this->data['record'] = Querytype::findOrFail($id);
        return view('admin.querytype.create', $this->data);
    }

    public function update(Request $request, $id) {
        $record = Querytype::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->all());
            return \Illuminate\Support\Facades\Response::json(['result' => 'success']);
        }
        $this->_validate($request, $id);
        $input = $request->all();
        $record->update($input);

        Session::flash('info', $this->data['title'] . ' updated successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function destroy($id) {
        $record = Querytype::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }

}
