<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class ProfileController extends Controller
{
    private $data = array(
        'controller' => 'AdminAuth\HomeController',
        'title' => 'Profile',
        'menu' => 'profile',
        'submenu' => 'profile',
    );
    
    public function index()
    {
        $this->data['submenu'] = 'profile';
        $this->data['record'] = Auth::guard('admin')->user();
        return view('admin.profile',$this->data);
    }
	
    public function reset_password()
    {
        $this->data['submenu'] = 'reset_password';
        return view('admin.reset_password',$this->data);
    }

    public function password(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|min:6|confirmed',
            'password_confirmation' => 'required',
        ]);
        $record = Auth::guard('admin')->user();
        $request['password'] = bcrypt($request['password']);
        $record->update($request->only(['password']));
        Session::flash('success','Password updated successfully.');
        $val =  route('admin.profile.reset_password');
        return redirect($val);
    }
	
    public function profile_post(Request $request)
    {
        $record = Auth::guard('admin')->user();
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:admins,email,'.$record['id'],
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);
        $input = $request->all();
        $input['image'] = $this->uploadFile($request,$record ,'image', 'profile',false);
		if (empty($input['image'])) {
            unset($input['image']);
        }
        $record->update($input);
        Session::flash('success','Profile updated successfully.');
        $val =  route('admin.profile');
        return redirect($val);
    }
}
