<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use App\Model\Product;

class ProductController extends Controller
{
    private $data = array(
        'route' => 'admin.product.',
        'title' => 'Product',
        'menu' => 'product',
        'submenu' => '',
    );
	
    public function __construct()
    {
       //$this->middleware('auth');
    }
	
    private function _validate($request, $id = null)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
            'description' => 'required',
			'image' => (!empty($id)?'mimes:jpeg,png,jpg,gif,svg|max:2048':'required|mimes:jpeg,png,jpg,gif,svg|max:2048'),
        ]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $records = Product::with('category')->select('*');
			 
            return Datatables::of($records)
			    ->addIndexColumn()
			    ->editColumn('created_at', function ($record) {
				    return $record->created_at->format('d-m-Y');
			    })
			    ->addColumn('image', function ($record) {
					if(!empty($record['image_url'])){
						return '<a href= "'. url($record->image_url).'" target="_blank" ><img src="'.$record->image_url.'" width="100" ></a>';
					}else{
						return '';
					}
				})
                ->addColumn('status', function ($record) {
                    return '<input id="toggle-demo" value="'.$record->id.'" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" '.($record->status == "Active"?" checked":"" ).' >';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.route($this->data['route'].'show',['id' =>$record->id]).'" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>'.
                          '&nbsp;<a href="'.route($this->data['route'].'edit',['id' =>$record->id]).'" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>'.
                          '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="'.$record->id.'" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                })
                ->rawColumns(['status','action','image'])
                ->make(true);
        }
        return view('admin.product.index',$this->data);

    }

    public function create()
    {
        return view('admin.product.create',$this->data);
    }


    public function store(Request $request)
    {
        $this->_validate($request);
		$input = $request->all();
		$input['image'] = $this->uploadFile($request, null, 'image', 'product', false);
        $record =  new Product($input);
        $record->save();

        Session::flash('success', $this->data['title'].' inserted successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function show($id)
    {
        $this->data['record'] = Product::findOrFail($id);
        return view('admin.product.show',$this->data);
    }


    public function edit($id)
    {
        $this->data['record'] = Product::findOrFail($id);
        return view('admin.product.create',$this->data);
    }


    public function update(Request $request, $id)
    {
        $record = Product::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->all());
            return \Illuminate\Support\Facades\Response::json(['result' => 'success']);
        }
		$this->_validate($request, $id);
        $input = $request->all();
        $input['image'] = $this->uploadFile($request, $record, 'image', 'product', false);
        if (empty($input['image'])) {
            unset($input['image']);
        }
        $record->update($input);

        Session::flash('info', $this->data['title'].' updated successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function destroy($id)
    {
        $record = Product::findOrFail($id);
		$this->deleteFile($record,'image',false);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json(['result'=>'success','message'=>'Deleted Data successfully!']);
    }
}
