<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{
    private $data = array(
        'route' => 'admin.permission.',
        'title' => 'Permission',
        'menu' => 'admin',
        'submenu' => 'permission',
    );
	
    public function __construct()
    {
        $this->middleware(['permission:publish |permission']);
    }
	
    private function _validate($request, $id = null)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
        ]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $records = Permission::select('*');
			
            return Datatables::of($records)
                //return $this->dataTable->eloquent($records)   
			    ->editColumn('created_at', function ($record) {
				    return $record->created_at->format(config('app.display_date'));
			    })
                ->addColumn('status', function ($record) {
                    return '<input id="toggle-demo" value="'.$record->id.'" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" '.($record->status == "Active"?" checked":"" ).' >';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.route($this->data['route'].'show',['id' =>$record->id]).'" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>'.
                          '&nbsp;<a href="'.route($this->data['route'].'edit',['id' =>$record->id]).'" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>'.
                          '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="'.$record->id.'" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                })
                ->rawColumns(['status','action'])
                ->make(true);
        }
        return view('admin.permission.index',$this->data);

    }

    public function create()
    {
        return view('admin.permission.create',$this->data);
    }


    public function store(Request $request)
    {
        $this->_validate($request);
        $record =  new Permission($request->all());
        $record->save();

        Session::flash('success', $this->data['title'].' inserted successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function show($id)
    {
        $this->data['record'] = Permission::findOrFail($id);
        return view('admin.permission.show',$this->data);
    }


    public function edit($id)
    {
        $this->data['record'] = Permission::findOrFail($id);
        return view('admin.permission.create',$this->data);
    }


    public function update(Request $request, $id)
    {
        $record = Permission::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->only(['status']));
            return \Illuminate\Support\Facades\Response::json(['result'=>'success']);
        }

        $this->_validate($request);
        $record->update($request->all());

        Session::flash('info', $this->data['title'].' updated successfully.');
        return redirect()->route($this->data['route'].'index');
    }


    public function destroy($id)
    {
        $record = Permission::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json(['result'=>'success','message'=>'Deleted Data successfully!']);
    }
}
