<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Auth;
use App\Model\Paperstyle;

class PaperstyleController extends Controller {

    private $data = array(
        'route' => 'admin.paperstyle.',
        'title' => 'Paperstyle',
        'menu' => 'dropdown',
        'submenu' => 'paperstyle',
    );

    public function __construct() {
        $this->middleware(['permission:publish |paperstyle view|paperstyle add|paperstyle edit|paperstyle delete']);
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
            'name' => 'required|max:255',
        ]);
    }

    public function index(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['paperstyle view']), 403);

        if ($request->ajax()) {
            $records = Paperstyle::select('*');
			
            return Datatables::of($records)
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format(config('app.display_date'));
                    })
                    ->addColumn('status', function ($record) {
                        return '<input id="toggle-demo" value="' . $record->id . '" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" ' . ($record->status == "Active" ? " checked" : "" ) . ' >';
                    })
                    ->addColumn('action', function ($record) {
                        return /* '<a href="' . route($this->data['route'] . 'show', ['id' => $record->id]) . '" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>' . */
                                '&nbsp;<a href="' . route($this->data['route'] . 'edit', ['id' => $record->id]) . '" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>' .
                                '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="' . $record->id . '" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                    })
                    ->rawColumns(['status','action'])
                    ->make(true);
        }
        return view('admin.paperstyle.index', $this->data);
        
    }

    public function create() {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['paperstyle add']), 403);

        return view('admin.paperstyle.create', $this->data);
    }

    public function store(Request $request) {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['paperstyle add']), 403);

        $this->_validate($request);
        $input = $request->all();
        $record = new Paperstyle($input);
        $record->save();
		
        Session::flash('success', $this->data['title'] . ' inserted successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function show($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['paperstyle view']), 403);

        $this->data['record'] = Paperstyle::findOrFail($id);
        return view('admin.paperstyle.show', $this->data);
    }

    public function edit($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['paperstyle edit']), 403);

        $this->data['record'] = Paperstyle::findOrFail($id);
        return view('admin.paperstyle.create', $this->data);
    }

    public function update(Request $request, $id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['paperstyle edit']), 403);

        $record = Paperstyle::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->all());
            return \Illuminate\Support\Facades\Response::json(['result' => 'success']);
        }
        $this->_validate($request, $id);
        $input = $request->all();
        $record->update($input);

        Session::flash('info', $this->data['title'] . ' updated successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function destroy($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['paperstyle delete']), 403);

        $record = Paperstyle::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }

}
