<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Auth;
use App\Model\Contact;

class ContactController extends Controller {

    private $data = array(
        'route' => 'admin.contact.',
        'title' => 'Contact',
        'menu' => 'contact',
        'submenu' => '',
    );

    public function __construct() {
        $this->middleware(['permission:publish |contact view|contact delete']);
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
           
        ]);
    }

    public function index(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['contact view']), 403);
    
        if ($request->ajax()) {
            $records = Contact::with(['user','querytype'])->orderBy('contacts.id','DESC')->select('contacts.*');
			
            return Datatables::of($records)
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format(config('app.display_date'));
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="' . route($this->data['route'] . 'show', ['id' => $record->id]) . '" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>' .
                                '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="' . $record->id . '" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                    })
                    ->rawColumns(['action'])
                    ->make(true);
        }
        return view('admin.contact.index', $this->data);
        
    }

    public function create() {
       
    }

    public function store(Request $request) {
        
    }

    public function show($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['contact view']), 403);

        $this->data['record'] = Contact::findOrFail($id);
        return view('admin.contact.show', $this->data);
    }

    public function edit($id) {
       
    }

    public function update(Request $request, $id) {
        
    }

    public function destroy($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['contact delete']), 403);

        $record = Contact::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }

}
